unit gossdat;
//## ==========================================================================================================================================================================================================================
//##
//## MIT License
//##
//## Copyright 2025 Blaiz Enterprises ( http://www.blaizenterprises.com )
//##
//## Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
//## files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
//## modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
//## is furnished to do so, subject to the following conditions:
//##
//## The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
//##
//## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
//## OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//## LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//## CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//##
//## ==========================================================================================================================================================================================================================
//## Library.................. static data (gossdat.pas)
//## Version.................. -
//## Items.................... -
//## Last Updated ............ 07nov2025, 24oct2025, 07sep2025
//## Lines of Code............ -
//##
//## main.pas ................ app code
//## gossroot.pas ............ console/gui app startup and control
//## gossio.pas .............. file io
//## gossimg.pas ............. image/graphics
//## gossnet.pas ............. network
//## gosswin.pas ............. static Win32 api calls
//## gosswin2.pas ............ dynamic Win32 api calls
//## gosssnd.pas ............. sound/audio/midi/chimes
//## gossgui.pas ............. gui management/controls
//## gossdat.pas ............. app icons (24px and 20px) and help documents (gui only) in txt, bwd or bwp format
//## gosszip.pas ............. zip support
//## gossjpg.pas ............. jpeg support
//## gossgame.pas ............ game support (optional)
//## gamefiles.pas ........... internal files for game (optional)
//##
//## ==========================================================================================================================================================================================================================
//## Important Format(s) Note:
//##
//## Many of the images and documents used below require a specific file format and storage in a binary pascal array in order to work.  A free gui tool
//## is available at http://www.blaizenterprises.com/blaiztools.html  The tool provides one button actions for pasting and converting images into
//## TEA/JPEG/PNG image formats, and packing them into a pascal array, as well as support for loading, compressing and packing text documents into
//## pascal arrays.
//## ==========================================================================================================================================================================================================================
//## Performance Note:
//##
//## The runtime compiler options "Range Checking" and "Overflow Checking", when enabled under Delphi 3
//## (Project > Options > Complier > Runtime Errors) slow down graphics calculations by about 50%,
//## causing ~2x more CPU to be consumed.  For optimal performance, these options should be disabled
//## when compiling.
//## ==========================================================================================================================================================================================================================

interface

uses
   gossroot;

const
//program icons ----------------------------------------------------------------
//app icon (required) - 24w x 24h size in TEA format only, accessed via tepIcon24
//Note: This icon is used by Gossamer internally for display on the app's Window Header (Title bar) and must be in the TEA (text picture) format.
//      A separate MS icon (.ico) is required for display on Windows Desktop/Explorer/Taskbar etc, currently stored within the resource file
//      "<app name>-256.res"
program_icon24h
:array[0..2196] of byte=(
84,69,65,51,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,0,0,0,7,0,0,0,170,1,3,0,0,171,1,12,0,0,170,1,28,0,0,170,1,46,0,0,169,2,55,0,0,170,1,46,0,0,170,1,28,0,0,171,1,12,0,0,170,1,3,0,0,0,12,0,0,0,176,1,2,0,0,178,1,20,0,0,176,1,69,0,0,176,1,129,0,0,175,1,175,0,0,175,1,203,0,0,174,2,214,0,0,175,1,203,0,0,175,1,175,0,0,176,1,129,0,0,176,1,69,0,0,178,1,20,0,0,176,1,2,0,0,0,9,0,0,0,185,1,7,0,0,184,1,56,0,0,183,1,149,0,0,183,1,215,0,0,182,1,243,0,0,182,1,252,0,0,182,1,254,0,0,182,2,255,0,0,182,1,254,0,0,182,1,252,0,0,182,1,243,0,0,183,1,215,0,0,183,1,149,0,0,184,1,56,0,0,185,1,7,0,0,0,7,0,0,0,193,1,12,0,0,192,1,81,0,0,190,1,193,0,0,190,1,247,0,0,190,1,254,0,0,190,8,255,0,0,190,1,254,0,0,190,1,247,0,0,190,1,193,0,0,192,1,81,0,0,193,1,12,0,0,0,5,0,0,0,200,1,7,0,0,200,1,81,0,0,198,1,205,0,0,198,1,251,0,0,198,2,255,20,20,197,1,255,86,86,192,1,255,124,124,185,1,255,140,140,181,1,255,138,138,181,1,255,118,118,186,1,255,78,78,193,1,255,5,5,198,1,255,0,0,198,2,255,0,0,198,1,251,0,0,198,
1,205,0,0,200,1,81,0,0,200,1,7,0,0,0,3,0,0,0,210,1,2,0,0,207,1,56,0,0,207,1,193,0,0,206,1,251,0,0,206,2,255,58,58,202,1,255,175,175,176,1,255,227,227,149,1,255,241,241,139,1,255,245,245,136,2,255,240,240,140,1,255,222,222,151,1,255,162,162,181,1,255,43,43,203,1,255,0,0,206,2,255,0,0,206,1,251,0,0,207,1,193,0,0,207,1,56,0,0,210,1,2,0,0,0,2,0,0,0,216,1,20,0,0,214,1,149,0,0,214,1,247,0,0,214,2,255,44,44,211,1,255,175,175,182,1,255,248,248,135,1,255,254,254,129,1,255,250,250,134,1,255,244,244,140,1,255,245,245,139,1,255,252,252,131,1,255,255,255,128,1,255,245,245,138,1,255,160,160,188,1,255,32,32,213,1,255,0,0,214,2,255,0,0,214,1,247,0,0,214,1,149,0,0,216,1,20,0,0,0,1,0,0,0,224,1,3,0,0,222,1,69,0,0,221,1,215,0,0,221,1,254,0,0,220,1,255,2,2,220,1,255,104,104,210,1,255,232,232,151,1,255,255,255,128,1,255,237,237,148,1,255,171,171,192,1,255,132,132,205,1,255,140,140,203,1,255,197,197,178,1,255,249,249,136,1,255,255,255,128,1,255,226,226,157,1,255,92,92,213,1,255,1,1,220,1,255,0,0,220,
1,255,0,0,221,1,254,0,0,221,1,215,0,0,222,1,69,0,0,224,1,3,0,0,230,1,12,0,0,229,1,129,0,0,229,1,243,0,0,229,2,255,6,6,229,1,255,130,130,211,1,255,245,245,141,1,255,255,255,129,1,255,207,207,175,1,255,47,47,226,1,255,0,0,229,2,255,87,87,222,1,255,221,221,165,1,255,249,249,137,1,255,235,235,152,1,255,119,119,215,1,255,4,4,229,1,255,0,0,229,2,255,0,0,229,1,243,0,0,229,1,130,0,0,230,1,12,0,0,238,1,28,0,0,237,1,175,0,0,237,1,252,0,0,237,2,255,4,4,237,1,255,120,120,222,1,255,240,240,148,1,255,255,255,128,1,255,238,238,149,1,255,166,166,202,1,255,113,113,222,1,255,74,74,231,1,255,39,39,235,1,255,89,89,229,1,255,100,100,227,1,255,85,85,230,1,255,38,38,235,1,255,0,0,237,3,255,0,0,237,1,252,0,0,237,1,175,0,0,238,1,28,0,0,245,1,46,0,0,245,1,203,0,0,245,1,254,0,0,245,3,255,74,74,240,1,255,208,208,183,1,255,254,254,130,1,255,255,255,128,1,255,251,251,134,1,255,238,238,151,1,255,216,216,174,1,255,183,183,199,1,255,133,133,223,1,255,68,68,240,1,255,0,0,245,5,255,0,0,245,1,254,0,0,245,1,203,
0,0,245,1,46,0,0,252,1,55,0,0,252,1,214,0,0,252,4,255,11,11,252,1,255,113,113,238,1,255,220,220,177,1,255,253,253,133,1,255,255,255,129,1,255,255,255,128,2,255,252,252,132,1,255,242,242,147,1,255,213,213,181,1,255,119,119,235,1,255,10,10,252,1,255,0,0,252,4,255,0,0,252,1,214,0,0,252,1,56,0,0,249,1,55,0,0,249,1,214,0,0,249,5,255,2,2,249,1,255,72,72,244,1,255,170,170,210,1,255,216,216,176,1,255,235,235,155,1,255,247,247,141,1,255,253,253,130,1,255,255,255,128,1,255,254,254,129,1,255,222,222,173,1,255,97,97,240,1,255,2,2,249,1,255,0,0,249,3,255,0,0,249,1,214,0,0,249,1,56,0,0,242,1,46,0,0,242,1,203,0,0,242,1,254,0,0,242,2,255,1,1,242,1,255,16,16,242,1,255,39,39,240,1,255,54,54,239,1,255,12,12,242,1,255,61,61,238,1,255,106,106,229,1,255,149,149,214,1,255,196,196,188,1,255,242,242,146,1,255,255,255,128,1,255,251,251,135,1,255,157,157,212,1,255,14,14,241,1,255,0,0,242,2,255,0,0,242,1,254,0,0,242,1,203,0,0,242,1,46,0,0,235,1,28,0,0,234,1,175,0,0,234,1,252,0,0,234,2,255,18,18,233,1,255,
152,152,209,1,255,208,208,179,1,255,213,213,175,1,255,113,113,221,1,255,0,0,234,3,255,46,46,231,1,255,181,181,193,1,255,253,253,130,1,255,255,255,128,1,255,181,181,194,1,255,21,21,233,1,255,0,0,234,2,255,0,0,234,1,252,0,0,234,1,175,0,0,235,1,28,0,0,227,1,12,0,0,226,1,129,0,0,226,1,243,0,0,226,2,255,19,19,225,1,255,174,174,192,1,255,253,253,130,1,255,254,254,130,1,255,193,193,183,1,255,49,49,224,1,255,0,0,226,2,255,24,24,225,1,255,179,179,190,1,255,253,253,130,1,255,254,254,129,1,255,176,176,191,1,255,19,19,225,1,255,0,0,226,2,255,0,0,226,1,243,0,0,226,1,130,0,0,227,1,12,0,0,221,1,3,0,0,219,1,69,0,0,218,1,215,0,0,218,1,254,0,0,218,1,255,6,6,218,1,255,129,129,202,1,255,241,241,142,1,255,255,255,128,1,255,244,244,141,1,255,188,188,181,1,255,138,138,201,1,255,133,133,202,1,255,174,174,188,1,255,238,238,147,1,255,255,255,128,1,255,246,246,137,1,255,141,141,198,1,255,9,9,218,1,255,0,0,218,1,255,0,0,218,1,254,0,0,218,1,215,0,0,219,1,69,0,0,221,1,3,0,0,0,1,0,0,0,213,1,20,0,0,211,1,149,
0,0,211,1,247,0,0,211,2,255,56,56,207,1,255,184,184,176,1,255,249,249,134,1,255,255,255,128,1,255,252,252,132,1,255,245,245,139,1,255,244,244,140,1,255,250,250,133,1,255,255,255,128,1,255,252,252,131,1,255,200,200,168,1,255,70,70,206,1,255,1,1,211,1,255,0,0,211,1,255,0,0,211,1,247,0,0,211,1,149,0,0,213,1,20,0,0,0,2,0,0,0,207,1,2,0,0,204,1,56,0,0,204,1,193,0,0,203,1,251,0,0,203,2,255,61,61,199,1,255,175,175,174,1,255,226,226,149,1,255,241,241,139,1,255,245,245,136,2,255,242,242,138,1,255,229,229,146,1,255,187,187,169,1,255,80,80,197,1,255,1,1,203,1,255,0,0,203,1,255,0,0,203,1,251,0,0,204,1,193,0,0,204,1,56,0,0,207,1,2,0,0,0,3,0,0,0,197,1,7,0,0,197,1,81,0,0,195,1,205,0,0,195,1,251,0,0,195,2,255,17,17,194,1,255,83,83,190,1,255,121,121,183,1,255,139,139,179,1,255,140,140,179,1,255,125,125,182,1,255,91,91,188,1,255,33,33,194,1,255,0,0,195,2,255,0,0,195,1,251,0,0,195,1,205,0,0,197,1,81,0,0,197,1,7,0,0,0,5,0,0,0,190,1,12,0,0,189,1,81,0,0,187,1,193,0,0,187,1,247,0,0,187,1,254,0,0,187,
8,255,0,0,187,1,254,0,0,187,1,247,0,0,187,1,193,0,0,189,1,81,0,0,190,1,12,0,0,0,7,0,0,0,182,1,7,0,0,181,1,56,0,0,180,1,149,0,0,180,1,215,0,0,179,1,243,0,0,179,1,252,0,0,179,1,254,0,0,179,2,255,0,0,179,1,254,0,0,179,1,252,0,0,179,1,243,0,0,180,1,215,0,0,180,1,149,0,0,181,1,56,0,0,182,1,7,0,0,0,9,0,0,0,173,1,2,0,0,175,1,20,0,0,173,1,69,0,0,173,1,130,0,0,172,1,175,0,0,172,1,203,0,0,171,2,214,0,0,172,1,203,0,0,172,1,175,0,0,173,1,130,0,0,173,1,69,0,0,175,1,20,0,0,173,1,2,0,0,0,12,0,0,0,167,1,3,0,0,168,1,12,0,0,167,1,28,0,0,167,1,46,0,0,166,2,56,0,0,167,1,46,0,0,167,1,28,0,0,168,1,12,0,0,167,1,3,0,0,0,7,0);


//app small icon (optional) - 20w x 20h size in TEA format only, accessed via tepIcon20
program_icon20h
:array[0..1731] of byte=(
84,69,65,51,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,0,0,0,5,0,0,0,176,1,4,0,0,174,1,17,0,0,173,1,39,0,0,172,1,63,0,0,171,2,76,0,0,172,1,63,0,0,173,1,39,0,0,174,1,17,0,0,176,1,4,0,0,0,8,0,0,0,176,1,1,0,0,182,1,16,0,0,181,1,64,0,0,179,1,129,0,0,178,1,183,0,0,177,1,214,0,0,177,2,227,0,0,177,1,214,0,0,178,1,183,0,0,179,1,129,0,0,181,1,64,0,0,182,1,16,0,0,176,1,1,0,0,0,5,0,0,0,190,1,1,0,0,191,1,30,0,0,188,1,116,0,0,187,1,203,0,0,186,1,242,0,0,186,1,254,0,0,186,4,255,0,0,186,1,254,0,0,186,1,242,0,0,187,1,203,0,0,188,1,116,0,0,191,1,30,0,0,190,1,1,0,0,0,3,0,0,0,199,1,1,0,0,200,1,30,0,0,197,1,135,0,0,196,1,226,0,0,196,1,253,0,0,196,1,255,47,47,194,1,255,94,94,188,1,255,115,115,185,1,255,113,113,185,1,255,88,88,189,1,255,40,40,194,1,255,0,0,196,1,255,0,0,196,1,253,0,0,196,1,226,0,0,197,1,135,0,0,200,1,30,0,0,199,1,1,0,0,0,2,0,0,0,208,1,16,0,0,207,1,116,0,0,206,1,226,0,0,205,1,253,21,21,205,1,255,108,108,194,1,255,194,194,167,1,255,226,226,149,1,255,233,233,144,2,255,224,224,150,
1,255,186,186,170,1,255,98,98,196,1,255,15,15,205,1,255,0,0,205,1,253,0,0,206,1,226,0,0,207,1,116,0,0,208,1,16,0,0,0,1,0,0,0,219,1,4,0,0,216,1,64,0,0,215,1,203,0,0,215,1,253,6,6,214,1,255,88,88,207,1,255,205,205,167,1,255,250,250,133,1,255,244,244,141,1,255,234,234,150,1,255,235,235,149,1,255,248,248,136,1,255,250,250,133,1,255,196,196,172,1,255,79,79,209,1,255,4,4,214,1,255,0,0,215,1,253,0,0,215,1,203,0,0,216,1,64,0,0,219,1,4,0,0,226,1,17,0,0,224,1,129,0,0,224,1,242,0,0,223,1,255,21,21,222,1,255,138,138,203,1,255,243,243,141,1,255,244,244,142,1,255,175,175,191,1,255,115,115,212,1,255,126,126,209,1,255,197,197,180,1,255,250,250,135,1,255,239,239,146,1,255,130,130,207,1,255,18,18,222,1,255,0,0,223,1,255,0,0,224,1,242,0,0,224,1,129,0,0,226,1,17,0,0,234,1,39,0,0,233,1,183,0,0,233,1,254,0,0,233,1,255,25,25,232,1,255,149,149,209,1,255,248,248,138,1,255,241,241,146,1,255,160,160,202,1,255,79,79,226,1,255,39,39,231,1,255,108,108,222,1,255,184,184,194,1,255,186,186,193,1,255,108,108,
222,1,255,15,15,233,1,255,0,0,233,1,255,0,0,233,1,254,0,0,233,1,183,0,0,234,1,39,0,0,243,1,63,0,0,243,1,214,0,0,243,2,255,14,14,242,1,255,119,119,228,1,255,231,231,160,1,255,254,254,130,1,255,237,237,151,1,255,212,212,175,1,255,184,184,196,1,255,145,145,216,1,255,97,97,232,1,255,48,48,240,1,255,16,16,242,1,255,0,0,243,3,255,0,0,243,1,214,0,0,243,1,63,0,0,251,1,76,0,0,251,1,227,0,0,251,2,255,2,2,251,1,255,57,57,248,1,255,165,165,217,1,255,238,238,156,1,255,253,253,133,1,255,252,252,133,1,255,249,249,137,1,255,240,240,149,1,255,218,218,175,1,255,150,150,222,1,255,49,49,248,1,255,1,1,251,1,255,0,0,251,2,255,0,0,251,1,227,0,0,251,1,77,0,0,248,1,76,0,0,248,1,227,0,0,248,3,255,4,4,248,1,255,47,47,246,1,255,130,130,228,1,255,194,194,194,1,255,221,221,169,1,255,237,237,152,1,255,248,248,137,1,255,253,253,130,1,255,234,234,160,1,255,130,130,229,1,255,20,20,248,1,255,0,0,248,2,255,0,0,248,1,227,0,0,248,1,77,0,0,240,1,63,0,0,240,1,214,0,0,240,2,255,17,17,239,1,255,93,93,232,1,255,127,127,
223,1,255,103,103,230,1,255,48,48,237,1,255,84,84,232,1,255,130,130,219,1,255,187,187,192,1,255,242,242,146,1,255,254,254,130,1,255,178,178,200,1,255,38,38,238,1,255,0,0,240,2,255,0,0,240,1,214,0,0,240,1,63,0,0,231,1,39,0,0,230,1,183,0,0,230,1,254,0,0,230,1,255,39,39,228,1,255,175,175,195,1,255,236,236,153,1,255,203,203,180,1,255,90,90,223,1,255,0,0,231,2,255,99,99,220,1,255,220,220,164,1,255,255,255,127,1,255,190,190,186,1,255,43,43,228,1,255,0,0,230,1,255,0,0,230,1,254,0,0,230,1,183,0,0,231,1,39,0,0,223,1,17,0,0,221,1,129,0,0,220,1,242,0,0,220,1,255,32,32,219,1,255,162,162,192,1,255,250,250,133,1,255,245,245,141,1,255,186,186,184,1,255,122,122,208,1,255,117,117,209,1,255,174,174,190,1,255,240,240,145,1,255,252,252,131,1,255,169,169,190,1,255,34,34,219,1,255,0,0,220,1,255,0,0,220,1,242,0,0,221,1,129,0,0,223,1,17,0,0,216,1,4,0,0,213,1,64,0,0,212,1,203,0,0,212,1,253,9,9,211,1,255,99,99,202,1,255,211,211,162,1,255,251,251,132,1,255,247,247,137,1,255,235,235,149,1,255,234,234,150,
1,255,244,244,139,1,255,252,252,131,1,255,220,220,156,1,255,110,110,200,1,255,13,13,211,1,255,0,0,212,1,253,0,0,212,1,203,0,0,213,1,64,0,0,216,1,4,0,0,0,1,0,0,0,205,1,16,0,0,204,1,116,0,0,203,1,226,0,0,202,1,253,23,23,201,1,255,110,110,191,1,255,194,194,165,1,255,225,225,149,1,255,233,233,144,2,255,227,227,147,1,255,200,200,162,1,255,122,122,189,1,255,32,32,201,1,255,0,0,202,1,253,0,0,203,1,226,0,0,204,1,116,0,0,205,1,16,0,0,0,2,0,0,0,196,1,1,0,0,197,1,30,0,0,194,1,135,0,0,193,1,226,0,0,193,1,253,0,0,193,1,255,45,45,191,1,255,91,91,186,1,255,114,114,182,1,255,115,115,182,1,255,96,96,185,1,255,53,53,190,1,255,2,2,193,1,255,0,0,193,1,253,0,0,193,1,226,0,0,194,1,135,0,0,197,1,30,0,0,196,1,1,0,0,0,3,0,0,0,187,1,1,0,0,188,1,30,0,0,185,1,116,0,0,184,1,203,0,0,183,1,242,0,0,183,1,254,0,0,183,4,255,0,0,183,1,254,0,0,183,1,242,0,0,184,1,203,0,0,185,1,116,0,0,188,1,30,0,0,187,1,1,0,0,0,5,0,0,0,173,1,1,0,0,179,1,16,0,0,178,1,64,0,0,176,1,129,0,0,175,1,183,0,0,174,1,214,0,0,174,2,227,0,0,
174,1,214,0,0,175,1,183,0,0,176,1,129,0,0,178,1,64,0,0,179,1,16,0,0,173,1,1,0,0,0,8,0,0,0,173,1,4,0,0,171,1,17,0,0,170,1,39,0,0,169,1,63,0,0,168,2,77,0,0,169,1,63,0,0,170,1,39,0,0,171,1,17,0,0,173,1,4,0,0,0,5,0);
//:array[0..0] of byte=(0);


//additional icons (B..D) are optional - 25may2025 -----------------------------
//Note: Supported image format: tea
//Note: Each icon, if specified, must be 24w x 24h.  The icons form an animation of upto 10 cells in total.
//      When triggered, the app icon - (top-left) of window - will animate and cycle through each of the cells
//      in a continuos loop for a short time period of about 2 seconds.
//How To Use:
//      Use rootwin.xhead.aniAdd(xtep,xms) to add upto 10 cells, and rootwin.xhead.aniPlay to
//      trigger animation playback for ~2 seconds.  To extend playback, call rootwin.xhead.aniPlay
//      regularly.
//
//Example:
//to setup the animation ready for playback:
//      rootwin.xhead.aniAdd(tepIcon24 ,200);
//      rootwin.xhead.aniAdd(tepIcon24B,200);
//      rootwin.xhead.aniAdd(tepIcon24C,200);
//      rootwin.xhead.aniAdd(tepIcon24D,200);
//
//to play the animation call:
//      rootwin.xhead.aniPlay;
//
//to clear the animation (e.g. to create a new animation) call:
//      rootwin.xhead.aniClear;
//
//Note: the examples above must be executed within "tprogram" for access to rootwin, see
//      the unit marked "main" for tprogram.


//accessed via "tepIcon24B"
program_icon24hB
:array[0..1836] of byte=(
84,69,65,51,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,0,0,0,7,0,255,255,89,1,1,255,255,88,1,4,255,255,88,1,15,255,255,88,1,31,255,255,88,2,42,255,255,88,1,31,255,255,88,1,15,255,255,88,1,4,255,255,89,1,1,0,0,0,12,0,255,255,81,1,1,255,255,79,1,10,255,255,80,1,57,255,255,80,1,131,255,255,81,1,187,255,255,81,1,218,255,255,81,2,229,255,255,81,1,218,255,255,81,1,187,255,255,80,1,131,255,255,80,1,57,255,255,79,1,10,255,255,81,1,1,0,0,0,9,0,255,255,72,1,3,255,255,72,1,43,255,255,73,1,151,255,255,74,1,229,255,255,74,1,251,255,255,74,1,254,255,255,74,4,255,255,255,74,1,254,255,255,74,1,251,255,255,74,1,229,255,255,73,1,151,255,255,72,1,43,255,255,72,1,3,0,0,0,7,0,255,255,64,1,5,255,255,65,1,73,255,255,65,1,205,255,255,66,1,251,255,255,66,10,255,255,255,66,1,251,255,255,65,1,205,255,255,65,1,73,255,255,64,1,5,0,0,0,5,0,255,255,56,1,3,255,255,57,1,73,255,255,58,1,219,255,255,58,1,254,255,255,58,3,255,246,246,58,1,255,221,221,68,1,255,209,209,76,1,255,210,210,75,1,255,226,226,65,1,
255,249,249,58,1,255,255,255,58,3,255,255,255,58,1,254,255,255,58,1,219,255,255,57,1,73,255,255,56,1,3,0,0,0,3,0,255,255,52,1,1,255,255,49,1,43,255,255,50,1,205,255,255,50,1,254,255,255,50,2,255,251,251,50,1,255,178,178,85,1,255,63,63,117,1,255,1,1,126,1,255,0,0,127,2,255,2,2,126,1,255,80,80,114,1,255,193,193,78,1,255,253,253,50,1,255,255,255,50,2,255,255,255,50,1,254,255,255,50,1,205,255,255,49,1,43,255,255,52,1,1,0,0,0,2,0,255,255,41,1,10,255,255,42,1,151,255,255,42,1,251,255,255,42,3,255,166,166,86,1,255,0,0,127,7,255,4,4,126,1,255,188,188,77,1,255,255,255,42,3,255,255,255,42,1,251,255,255,42,1,151,255,255,41,1,10,0,0,0,1,0,255,255,38,1,1,255,255,34,1,57,255,255,34,1,229,255,255,35,3,255,237,237,38,1,255,36,36,121,1,255,0,0,127,1,255,54,54,119,1,255,182,182,77,1,255,216,216,55,1,255,211,211,59,1,255,142,142,94,1,255,0,0,127,2,255,62,62,116,1,255,245,245,35,1,255,255,255,35,3,255,255,255,34,1,229,255,255,34,1,57,255,255,38,1,1,255,255,26,1,4,255,255,26,1,131,255,255,27,1,251,
255,255,27,3,255,215,215,52,1,255,0,0,127,2,255,146,146,92,1,255,255,255,27,3,255,248,248,27,1,255,82,82,110,1,255,1,1,125,1,255,2,2,123,1,255,221,221,44,1,255,255,255,27,3,255,255,255,27,1,251,255,255,26,1,131,255,255,26,1,4,255,255,18,1,15,255,255,18,1,187,255,255,19,1,254,255,255,19,3,255,225,225,35,1,255,2,2,125,1,255,0,0,127,1,255,45,45,120,1,255,179,179,74,1,255,233,233,27,1,255,252,252,19,1,255,255,255,19,1,255,234,234,28,1,255,228,228,28,1,255,233,233,23,1,255,251,251,19,1,255,255,255,19,3,255,255,255,19,1,254,255,255,18,1,187,255,255,18,1,15,255,255,10,1,31,255,255,11,1,218,255,255,11,4,255,251,251,11,1,255,108,108,102,1,255,0,0,127,3,255,17,17,122,1,255,96,96,106,1,255,162,162,83,1,255,215,215,43,1,255,251,251,11,1,255,255,255,11,6,255,255,255,11,1,218,255,255,10,1,31,255,255,3,1,42,255,255,3,1,229,255,255,3,5,255,230,230,29,1,255,86,86,108,1,255,0,0,127,5,255,2,2,125,1,255,107,107,102,1,255,226,226,32,1,255,255,255,3,5,255,255,255,3,1,229,255,255,3,1,43,255,255,6,1,
42,255,255,6,1,229,255,255,6,6,255,244,244,9,1,255,185,185,68,1,255,107,107,103,1,255,22,22,121,1,255,0,0,127,4,255,75,75,112,1,255,240,240,15,1,255,255,255,6,4,255,255,255,6,1,229,255,255,6,1,43,255,255,13,1,31,255,255,14,1,218,255,255,14,6,255,254,254,14,1,255,255,255,14,1,255,253,253,14,1,255,236,236,19,1,255,201,201,58,1,255,142,142,92,1,255,27,27,122,1,255,0,0,127,2,255,183,183,72,1,255,255,255,14,4,255,255,255,14,1,218,255,255,13,1,31,255,255,21,1,15,255,255,21,1,187,255,255,21,1,254,255,255,22,3,255,184,184,69,1,255,136,136,96,1,255,108,108,102,1,255,226,226,39,1,255,255,255,22,3,255,254,254,22,1,255,180,180,73,1,255,0,0,127,2,255,148,148,92,1,255,255,255,22,3,255,255,255,21,1,254,255,255,21,1,187,255,255,21,1,15,255,255,29,1,4,255,255,29,1,131,255,255,30,1,251,255,255,30,3,255,158,158,89,1,255,0,0,127,2,255,159,159,86,1,255,254,254,30,1,255,255,255,30,3,255,181,181,76,1,255,0,0,127,2,255,154,154,91,1,255,255,255,30,3,255,255,255,30,1,251,255,255,29,1,131,255,255,29,1,
4,255,255,41,1,1,255,255,37,1,57,255,255,37,1,229,255,255,37,3,255,216,216,57,1,255,6,6,125,1,255,0,0,127,1,255,14,14,124,1,255,157,157,89,1,255,212,212,60,1,255,215,215,58,1,255,177,177,80,1,255,44,44,121,1,255,0,0,127,1,255,1,1,126,1,255,203,203,67,1,255,255,255,37,3,255,255,255,37,1,229,255,255,37,1,57,255,255,41,1,1,0,0,0,1,0,255,255,44,1,10,255,255,45,1,151,255,255,45,1,251,255,255,45,2,255,253,253,45,1,255,153,153,92,1,255,0,0,127,8,255,125,125,102,1,255,250,250,46,1,255,255,255,45,2,255,255,255,45,1,251,255,255,45,1,151,255,255,44,1,10,0,0,0,2,0,255,255,54,1,1,255,255,52,1,43,255,255,53,1,205,255,255,53,1,254,255,255,53,2,255,250,250,53,1,255,178,178,86,1,255,68,68,117,1,255,1,1,126,1,255,0,0,127,2,255,1,1,126,1,255,51,51,120,1,255,160,160,94,1,255,245,245,55,1,255,255,255,53,2,255,255,255,53,1,254,255,255,53,1,205,255,255,52,1,43,255,255,54,1,1,0,0,0,3,0,255,255,59,1,3,255,255,60,1,73,255,255,60,1,219,255,255,61,1,254,255,255,61,3,255,247,247,61,1,255,223,223,69,1,255,
210,210,77,1,255,209,209,78,1,255,221,221,70,1,255,244,244,61,1,255,255,255,61,3,255,255,255,61,1,254,255,255,60,1,219,255,255,60,1,73,255,255,59,1,3,0,0,0,5,0,255,255,67,1,5,255,255,68,1,73,255,255,68,1,205,255,255,69,1,251,255,255,69,10,255,255,255,69,1,251,255,255,68,1,205,255,255,68,1,73,255,255,67,1,5,0,0,0,7,0,255,255,75,1,3,255,255,75,1,43,255,255,76,1,151,255,255,77,1,229,255,255,77,1,251,255,255,77,1,254,255,255,77,4,255,255,255,77,1,254,255,255,77,1,251,255,255,77,1,229,255,255,76,1,151,255,255,75,1,43,255,255,75,1,3,0,0,0,9,0,255,255,84,1,1,255,255,82,1,10,255,255,83,1,57,255,255,83,1,131,255,255,84,1,187,255,255,84,1,218,255,255,84,2,229,255,255,84,1,218,255,255,84,1,187,255,255,83,1,131,255,255,83,1,57,255,255,82,1,10,255,255,84,1,1,0,0,0,12,0,255,255,92,1,1,255,255,91,1,4,255,255,91,1,15,255,255,91,1,31,255,255,91,2,43,255,255,91,1,31,255,255,91,1,15,255,255,91,1,4,255,255,92,1,1,0,0,0,7,0);


//accessed via "tepIcon24C"
program_icon24hC
:array[0..0] of byte=(0);


//accessed via "tepIcon24D"
program_icon24hD
:array[0..0] of byte=(0);


//help viewer banner images - optional -----------------------------------------
//.banner 1
programbanner
:array[0..0] of byte=(0);//disabled

//.banner 2
programbanner2
:array[0..0] of byte=(0);//disabled


//app help document(s) - optional ----------------------------------------------
//note: these help documents, if specified, are processed and merged into one large
//      document at runtime by the built-in help viewer, which supports documents in
//      the following 3 formats:
//
//      1. txt - plain text
//      2. bwd - enhanced text (Blaiz Enterprises format)
//      3. bwp - advanced text (Blaiz Enterprises format)
//
//      These documents can be compressed (using zip) or left uncompressed.


//app help - app specific help document, which appears above system help
apphelp
:array[0..0] of byte=(0);


//system help - information relating to the app's system settings and general behaviour
syshelp//07nov2025
:array[0..17112] of byte=(
120,1,236,157,235,110,28,201,153,166,109,96,127,17,152,123,200,37,48,48,53,75,138,18,213,39,11,59,99,80,20,213,226,88,18,5,146,106,185,215,235,31,201,170,36,89,86,157,92,7,81,236,203,88,204,21,205,149,237,243,190,95,68,102,86,145,114,171,103,52,30,187,157,141,238,150,88,149,25,241,157,207,17,124,242,246,233,195,95,240,207,96,124,49,249,127,252,57,44,199,253,121,175,156,86,143,139,7,255,176,49,191,153,47,170,209,188,119,85,141,226,131,235,89,57,157,47,110,134,252,180,247,15,27,23,147,241,98,92,234,171,131,201,114,54,168,102,197,171,234,58,62,158,15,126,224,227,135,233,161,222,100,56,153,121,69,189,226,159,246,88,225,203,47,211,195,177,34,27,158,95,166,71,31,126,245,245,215,95,126,177,151,222,23,132,139,234,195,226,223,255,237,23,191,248,253,226,15,7,87,229,248,178,42,22,87,85,225,199,7,227,203,98,114,225,159,203,233,244,87,243,226,219,55,71,27,207,102,147,81,177,152,76,249,111,50,60,47,103,69,111,56,232,189,43,54,127,191,168,166,143,39,211,197,96,50,158,239,61,248,67,113,28,127,
221,44,38,179,130,183,139,81,53,94,22,155,247,239,223,47,254,165,249,110,75,11,205,6,151,87,11,109,116,61,24,247,39,215,247,238,23,197,254,184,216,172,23,136,143,249,118,56,44,250,131,249,116,88,222,240,200,105,53,172,122,139,180,111,160,206,174,7,162,200,102,177,40,207,129,175,152,95,77,174,139,225,96,238,213,253,76,17,68,159,223,223,216,56,3,205,77,63,95,156,154,19,243,205,120,118,48,47,216,100,176,40,6,99,214,88,92,205,170,170,152,179,151,48,123,188,241,240,126,241,100,57,24,46,118,142,198,65,165,188,100,177,83,204,170,178,95,76,198,195,155,221,229,188,42,202,121,49,152,111,236,221,47,14,150,243,5,68,91,1,128,167,121,6,234,249,187,193,188,60,31,242,198,184,95,12,203,243,106,56,172,250,249,173,135,59,15,31,108,60,186,95,156,150,239,249,240,211,214,152,251,89,246,191,24,12,171,173,249,61,96,18,229,222,25,233,25,251,240,223,195,175,30,252,175,226,220,152,12,214,49,1,237,222,213,100,2,14,23,112,91,196,30,140,166,195,27,168,96,154,151,43,96,136,208,48,152,175,89,7,10,12,23,131,
81,197,59,207,96,252,96,60,95,148,227,94,181,93,236,255,105,89,22,47,203,217,96,172,239,222,150,139,222,149,8,36,89,171,101,139,77,37,128,243,180,124,188,188,96,225,157,98,60,41,198,21,248,95,72,154,198,69,217,239,15,196,143,114,88,12,39,101,127,59,0,216,150,172,205,171,5,204,221,47,158,12,203,193,15,197,225,120,81,205,166,179,193,188,154,255,106,21,234,173,127,186,127,222,131,52,37,124,94,104,75,104,2,231,203,90,94,22,215,213,120,113,19,47,205,183,193,108,62,69,0,6,226,147,160,48,39,164,33,163,9,242,85,206,167,72,200,252,150,186,136,118,147,17,242,195,215,131,18,81,204,60,100,39,54,236,87,179,129,216,90,46,17,144,114,49,232,149,67,208,21,209,69,153,185,72,117,118,13,51,36,213,112,147,109,69,176,139,25,198,97,187,24,67,75,127,6,115,38,51,232,12,24,208,31,88,207,6,11,160,140,183,160,13,82,229,103,71,194,49,96,31,141,16,137,31,38,227,138,167,79,121,181,95,206,146,112,73,53,14,75,184,115,167,108,20,87,146,234,5,182,96,114,61,46,150,227,193,159,150,82,142,70,193,230,128,188,159,164,
58,32,72,250,81,128,218,228,58,144,72,248,32,56,231,128,153,52,160,234,11,91,144,5,135,5,82,113,215,34,219,44,54,155,200,14,104,123,209,194,218,205,66,250,123,82,210,98,33,244,251,40,183,87,222,100,217,231,85,113,51,89,254,138,23,47,176,49,197,162,66,226,111,43,101,49,31,78,224,225,78,81,9,255,139,165,120,145,161,179,126,182,4,28,115,180,184,154,44,33,249,248,38,68,51,176,145,221,70,30,67,3,37,172,104,198,32,80,43,167,146,207,48,151,80,191,244,118,54,83,139,114,182,96,91,177,166,250,80,162,106,224,2,40,197,67,62,76,88,20,15,55,97,204,113,32,29,22,147,5,16,31,212,5,211,89,161,15,6,209,164,45,166,229,176,90,44,248,202,70,19,24,170,114,6,25,14,108,170,203,252,181,246,78,6,213,244,139,119,251,200,233,228,50,25,99,113,179,255,71,72,149,120,9,247,251,213,124,48,147,204,66,200,64,230,248,183,197,245,21,36,237,35,79,122,97,136,206,141,145,230,247,213,240,102,59,61,163,167,251,179,242,82,124,152,161,51,50,144,189,229,108,62,153,237,194,146,203,106,182,24,76,107,193,79,155,37,44,108,96,
122,127,90,178,107,250,194,10,226,133,122,147,209,116,201,118,146,139,10,16,90,28,18,36,248,29,124,22,111,141,23,131,241,146,77,225,232,114,218,71,190,48,61,19,116,250,194,6,45,219,157,108,8,141,196,176,54,71,210,212,85,13,53,123,225,199,6,94,243,91,240,12,172,198,213,117,2,48,188,12,44,150,56,108,188,149,106,26,220,249,213,192,226,178,246,28,160,92,97,178,109,136,36,216,122,235,55,69,113,88,206,229,233,194,227,34,223,193,159,228,193,66,242,119,178,251,77,222,18,231,122,144,92,96,195,219,196,209,157,85,229,9,157,201,74,146,149,7,209,13,35,31,228,189,173,36,97,79,218,78,95,158,93,30,255,165,60,252,191,20,14,4,68,32,125,118,42,180,246,231,184,125,169,225,217,205,84,138,45,244,90,226,35,213,221,212,131,155,216,156,197,98,50,230,201,239,37,37,109,124,101,155,77,245,36,180,239,188,128,180,31,81,92,142,49,164,22,97,175,211,223,204,216,100,123,220,94,105,158,41,55,38,242,169,31,148,65,145,223,128,61,237,135,139,30,222,6,35,181,178,117,144,0,176,199,214,59,107,247,51,116,183,241,118,
16,207,111,38,90,162,23,25,146,59,173,42,70,120,190,12,135,216,242,147,177,141,118,70,48,50,218,219,66,51,91,47,220,137,156,104,210,200,36,143,207,137,121,16,40,41,152,121,104,139,180,130,212,70,216,129,28,97,173,200,140,67,38,113,164,77,133,32,25,108,57,109,91,223,16,160,97,137,113,200,150,55,246,74,76,16,195,175,196,182,136,157,138,41,46,20,151,218,246,177,248,132,164,24,96,185,30,221,160,141,34,92,143,119,102,118,244,61,108,138,165,35,197,126,24,64,7,110,9,221,132,255,1,28,59,50,99,138,17,33,203,173,133,107,203,141,202,201,127,219,14,236,36,50,239,42,156,16,185,171,69,239,55,27,223,87,118,103,200,196,29,203,36,201,200,14,2,240,179,75,184,88,206,245,222,199,168,44,83,184,226,198,86,189,215,10,13,179,249,92,231,136,168,198,126,243,43,129,47,227,31,194,82,134,173,174,159,86,236,215,18,16,217,230,85,179,22,120,173,26,183,243,146,120,158,101,181,138,2,200,28,61,110,215,8,182,125,94,245,1,7,215,195,227,6,145,18,19,222,94,41,174,18,171,181,218,229,108,130,138,38,110,17,155,221,250,
44,30,37,86,36,4,114,194,48,30,16,14,65,82,254,80,70,2,20,56,28,132,111,30,33,99,107,1,178,1,116,191,73,83,44,117,168,69,78,88,16,100,194,163,177,5,111,14,99,203,243,9,10,181,144,96,250,213,221,81,53,99,11,199,250,34,99,86,196,148,222,160,154,250,91,0,194,15,97,161,244,169,172,7,82,18,251,201,67,240,223,87,15,154,176,169,5,99,50,217,188,93,42,0,196,249,207,171,247,149,132,218,248,201,77,47,174,112,197,23,23,213,12,64,67,83,22,108,50,28,188,171,138,171,201,108,64,168,182,224,113,137,14,47,58,80,204,50,68,104,89,245,121,246,162,236,11,13,63,163,192,100,38,47,23,98,113,61,57,87,216,58,100,211,161,36,243,76,177,37,1,206,56,146,154,8,205,28,126,160,82,193,132,68,248,73,113,41,247,54,130,102,152,121,91,33,137,5,212,101,153,183,87,146,142,185,226,219,219,200,154,30,41,236,149,108,16,35,42,190,41,205,89,212,152,96,157,149,136,106,69,183,241,68,65,59,96,181,23,10,16,146,154,65,23,108,188,36,98,236,200,44,236,83,68,252,87,96,190,131,107,189,144,196,44,38,215,138,101,47,103,213,13,9,247,
144,56,153,93,231,119,61,146,16,33,150,37,16,49,221,175,200,68,135,206,70,109,253,64,241,24,3,52,31,14,216,122,59,28,43,38,23,157,132,27,132,161,146,69,196,104,49,27,236,100,90,130,197,93,226,61,95,78,21,162,75,31,70,229,135,193,104,57,74,146,29,86,182,95,77,225,63,50,252,104,175,56,87,54,2,146,39,223,62,217,23,197,208,3,162,192,111,244,57,241,10,161,37,152,85,80,239,124,184,4,18,9,68,57,156,94,17,45,147,59,141,97,111,138,35,179,47,98,71,172,231,120,62,133,204,240,239,245,171,111,99,103,0,125,53,89,84,143,241,120,137,39,208,238,22,23,237,196,38,83,68,85,17,57,28,84,230,17,146,37,112,151,170,2,20,123,15,138,139,233,188,216,242,151,243,130,167,101,242,39,227,254,61,44,198,213,0,191,54,170,128,192,246,4,24,20,198,41,40,107,84,86,218,63,171,166,37,58,216,48,120,91,235,42,149,108,175,152,52,162,44,222,195,146,73,160,47,41,170,32,20,158,2,203,207,190,243,37,48,18,46,58,137,16,217,216,233,224,245,155,98,58,185,22,27,201,227,156,139,33,148,96,36,150,43,183,155,12,151,78,240,225,249,145,
45,215,12,20,70,200,124,31,144,224,218,4,17,128,234,94,131,204,0,54,246,136,229,144,215,74,158,54,18,83,175,213,34,209,110,107,93,177,116,50,115,152,50,225,101,80,229,191,98,62,154,160,5,69,80,24,165,200,68,129,62,50,164,167,150,60,164,6,46,131,230,128,192,25,74,226,180,168,67,108,156,46,224,232,37,111,111,61,184,127,159,154,207,189,199,27,79,43,66,225,17,96,205,49,26,215,197,72,49,69,34,115,139,181,161,87,208,124,142,32,237,142,100,54,222,15,156,216,130,252,62,9,245,117,241,190,68,186,32,139,116,238,150,197,157,47,207,101,237,207,171,49,137,26,14,8,173,5,94,241,26,70,224,109,202,32,170,215,216,46,30,62,120,176,3,116,74,160,99,53,24,114,62,25,246,135,10,109,247,211,78,97,148,121,84,162,64,74,162,84,6,113,188,33,180,185,40,151,195,5,143,158,225,231,198,250,60,187,196,86,248,114,74,178,35,170,108,154,82,132,67,169,54,244,52,170,69,4,56,167,229,69,85,60,169,93,145,130,209,188,55,166,109,38,40,225,202,77,161,31,204,227,140,22,159,190,83,148,0,212,87,178,43,200,251,152,184,225,82,
10,129,97,73,186,193,114,71,42,148,1,253,185,228,70,233,5,100,233,97,238,145,25,196,32,126,222,124,182,183,89,188,171,72,138,18,71,35,157,59,84,145,66,159,107,117,4,248,98,48,27,73,38,23,19,244,174,37,21,225,211,18,73,100,81,141,244,253,141,162,216,56,80,208,175,112,112,139,114,17,242,192,255,144,7,232,18,112,232,219,196,0,33,51,170,200,93,149,110,215,52,184,48,5,50,139,4,251,109,129,89,53,188,232,160,133,4,249,130,107,227,182,193,181,81,106,190,22,68,122,66,171,6,10,31,179,183,8,181,156,89,72,180,16,120,45,69,81,241,132,15,89,225,150,133,1,5,139,76,114,90,59,222,163,5,121,138,15,85,146,3,125,91,24,156,173,2,232,89,229,132,210,53,7,177,141,127,5,223,16,1,102,67,84,107,62,151,154,71,65,115,141,82,59,88,38,168,47,73,151,185,113,229,37,173,94,244,110,122,138,152,160,167,158,250,136,93,68,183,159,55,78,61,130,234,221,239,178,95,79,65,246,10,39,95,34,152,200,86,45,192,201,125,12,171,139,197,46,86,120,11,165,95,206,131,228,84,251,224,181,188,216,174,171,36,91,211,97,243,21,42,245,187,
98,58,248,16,113,64,139,253,63,84,51,34,190,229,12,59,93,59,251,201,197,197,42,164,111,29,71,52,144,198,207,102,215,35,11,220,190,171,29,34,76,10,57,46,202,30,82,44,185,54,247,29,123,253,56,234,25,2,194,87,0,120,38,11,117,52,222,61,38,168,145,173,251,82,146,113,32,58,139,103,132,150,88,240,176,57,59,139,201,14,230,75,127,216,22,203,161,80,178,163,138,119,193,199,114,157,101,127,25,37,182,178,47,69,184,83,208,93,93,120,63,168,120,129,239,73,255,20,15,151,151,136,226,182,132,208,76,79,229,132,96,55,226,241,70,153,88,203,116,58,212,81,17,135,76,95,144,38,79,221,178,140,41,220,186,144,188,249,17,86,73,184,182,200,186,247,41,100,109,19,72,136,38,33,180,81,149,27,81,105,223,73,81,157,171,0,107,75,150,66,75,118,91,159,216,69,40,253,113,158,129,95,5,184,51,153,119,71,107,15,31,228,234,89,235,149,164,106,46,161,241,244,173,228,231,73,45,187,97,165,127,60,3,58,168,203,119,207,16,161,28,208,100,243,143,179,108,149,198,100,202,240,75,112,62,154,18,237,102,65,182,61,81,53,35,226,90,142,224,
98,88,70,250,15,0,155,43,44,51,248,148,83,247,41,140,73,241,116,82,54,203,5,120,77,207,39,242,4,117,233,229,181,158,220,116,156,137,59,80,56,213,126,193,25,84,253,236,51,34,102,21,242,132,209,57,22,94,158,23,137,148,181,199,205,17,174,59,101,15,15,77,42,190,28,226,5,37,89,243,193,104,48,164,217,162,254,79,173,77,78,113,228,177,148,70,19,223,149,33,101,188,128,203,161,230,23,81,9,201,147,68,253,122,50,123,7,204,139,72,204,182,115,193,137,232,55,85,19,137,49,206,39,148,95,70,228,147,42,194,19,242,12,46,40,93,18,224,167,183,176,120,142,87,231,187,97,65,48,130,229,8,45,84,85,77,29,172,208,148,200,245,208,120,5,178,19,226,222,185,182,215,154,197,150,183,178,150,98,184,194,9,78,166,250,57,118,86,235,231,251,84,58,81,253,130,216,85,25,134,43,194,242,131,120,15,147,185,44,46,39,147,62,49,30,21,117,148,27,181,158,18,103,98,118,166,14,72,203,158,114,62,106,67,10,78,6,16,21,98,107,57,213,148,54,159,12,137,67,136,241,144,194,120,90,180,106,145,29,230,188,77,165,221,120,57,209,79,166,34,248,
162,56,33,213,50,200,38,103,203,41,121,160,41,134,213,95,142,175,41,246,65,180,26,113,136,15,49,249,170,73,227,118,97,89,164,112,65,206,154,109,33,12,80,243,143,229,140,78,9,81,135,106,129,88,229,10,168,82,29,86,112,68,70,2,190,138,155,195,143,73,40,90,120,215,105,150,137,156,132,172,34,191,164,73,1,145,219,101,128,100,155,3,55,185,238,122,117,212,61,234,3,128,129,116,69,99,39,236,137,138,76,253,9,117,150,40,157,202,80,166,228,192,109,76,210,104,9,170,87,35,243,120,167,52,49,133,171,187,1,197,111,156,237,69,176,172,184,23,214,192,15,226,86,149,187,100,73,193,30,222,225,60,228,185,29,108,95,134,124,37,120,135,138,192,30,254,250,215,15,224,175,35,79,193,128,161,31,204,208,170,178,63,153,141,197,5,150,125,134,122,30,160,176,144,11,228,94,43,9,136,31,183,230,176,118,184,27,164,226,97,7,141,179,201,152,18,196,104,57,87,47,198,185,150,130,44,34,57,22,144,51,58,138,56,6,191,239,2,0,124,69,221,45,151,222,158,86,211,136,38,23,44,164,54,47,76,228,11,81,220,75,44,11,161,197,205,206,229,
140,58,183,116,213,246,31,181,31,252,160,245,69,63,86,81,95,37,233,179,8,152,189,198,98,146,34,249,62,193,101,138,9,33,195,57,201,131,4,35,81,62,101,202,14,232,175,201,143,36,246,99,4,9,86,181,4,5,238,159,177,89,36,52,214,1,181,116,208,180,155,169,81,14,150,240,126,100,164,95,23,211,15,225,245,232,187,34,7,153,189,72,219,92,105,187,228,142,128,157,28,147,102,44,27,78,122,189,229,244,134,54,70,15,187,160,210,1,118,94,133,121,201,15,169,23,197,5,201,242,179,229,12,140,103,106,72,129,99,130,95,122,21,17,104,212,67,32,108,132,95,229,144,236,1,230,77,70,238,159,41,151,149,68,133,32,69,85,138,69,120,2,19,3,67,30,20,91,180,11,211,83,247,4,32,145,216,214,85,85,190,135,43,241,174,56,121,203,67,61,83,114,75,239,56,10,106,45,150,228,112,53,72,83,199,221,242,57,110,63,177,231,151,173,194,143,31,115,68,89,190,47,177,218,42,189,176,104,171,163,106,116,46,197,119,251,148,125,146,98,245,209,120,232,140,8,37,119,54,191,4,200,179,168,102,72,60,146,113,102,51,253,148,154,226,42,158,44,232,16,102,
157,101,137,86,13,208,144,32,83,167,137,98,72,60,4,38,103,164,42,136,46,156,74,71,183,130,213,176,54,140,186,219,239,171,18,37,81,196,151,168,43,249,64,226,32,242,122,233,123,169,2,64,184,39,121,11,250,0,224,215,123,60,182,102,102,162,237,34,81,90,51,37,251,185,247,73,63,146,29,108,51,208,61,81,135,165,108,164,85,106,211,231,182,81,168,200,120,61,109,207,109,172,249,29,92,69,83,205,212,220,233,170,119,209,204,68,52,102,47,80,249,22,91,159,212,121,167,35,64,195,64,126,192,19,98,81,93,44,53,188,171,37,14,178,68,71,30,174,60,137,56,242,129,54,20,45,240,7,193,65,58,176,3,197,198,238,166,38,224,100,178,136,30,208,71,71,202,123,191,13,122,229,234,4,2,241,246,10,33,86,93,235,214,178,68,52,196,1,180,141,114,237,53,213,57,180,22,145,243,23,191,53,9,191,249,45,170,239,141,231,60,186,79,73,199,6,243,146,1,149,30,14,110,225,44,88,122,77,20,49,57,127,63,160,103,102,121,155,15,46,199,132,3,216,152,69,93,168,228,133,243,138,54,57,234,173,36,200,61,100,64,198,168,165,106,74,216,47,137,171,75,
17,138,201,73,116,27,72,154,39,213,117,126,2,148,107,229,152,26,214,166,46,219,188,157,104,150,124,198,5,209,145,27,220,41,54,217,178,111,133,160,125,122,186,247,92,149,26,140,85,15,1,216,48,73,132,66,8,253,172,10,36,47,41,103,132,105,181,183,206,68,146,4,64,89,69,17,194,35,189,42,141,48,165,160,146,63,86,89,140,210,112,64,160,29,29,40,79,137,121,129,128,52,36,242,159,185,27,95,200,63,186,113,64,230,136,239,166,32,166,38,105,56,17,219,61,49,75,28,150,2,148,231,4,111,11,245,120,101,28,209,5,250,184,20,141,20,239,33,57,148,115,201,78,134,42,94,90,110,128,132,40,39,67,110,67,95,170,85,79,73,162,116,56,133,197,166,69,153,31,176,60,156,125,55,47,148,218,104,177,153,252,29,6,90,165,130,204,66,240,142,228,154,61,145,60,91,2,224,64,27,174,136,80,222,73,62,245,225,238,5,150,206,86,142,200,139,156,75,102,94,142,38,50,235,107,132,54,215,208,172,77,248,87,75,88,182,141,181,190,64,40,10,158,176,73,84,101,159,217,4,143,42,79,223,64,132,164,60,87,38,34,45,33,30,29,97,219,6,115,133,16,23,250,
9,228,178,49,104,189,67,189,12,193,252,103,226,133,189,7,215,197,7,138,29,223,60,184,226,231,98,111,251,193,215,143,182,191,162,64,17,98,179,129,120,253,115,241,232,155,47,252,216,30,67,50,126,236,155,237,189,95,127,177,253,69,243,24,106,244,207,197,215,95,125,227,199,190,120,180,231,199,30,61,218,126,248,245,215,237,213,240,205,44,184,69,104,63,75,85,49,170,55,3,212,143,104,246,94,102,132,98,83,205,69,16,171,68,189,115,235,139,15,250,18,28,147,44,91,82,109,39,192,98,75,131,9,161,40,237,197,122,180,88,96,29,212,80,181,140,108,200,117,124,115,205,61,71,211,61,119,168,178,124,93,59,195,72,172,132,246,95,62,248,71,209,209,91,137,173,219,112,35,151,191,212,158,24,244,64,69,108,6,100,237,34,15,109,173,65,86,99,168,45,4,149,217,131,17,97,49,15,38,176,224,39,252,162,250,144,119,198,210,96,30,9,179,120,211,88,2,240,140,118,10,69,213,75,210,20,132,241,38,140,134,91,32,178,217,250,130,87,152,94,184,154,176,48,243,83,204,214,205,22,75,2,100,230,12,98,3,210,125,226,60,190,149,86,100,25,66,
103,108,220,64,44,73,149,28,171,148,217,234,72,22,128,204,160,128,141,105,36,89,82,230,53,95,170,33,19,106,150,53,35,104,69,83,42,23,52,173,166,132,62,42,49,149,74,73,102,82,160,173,189,47,255,145,66,76,34,37,181,30,188,61,1,80,208,20,213,205,100,112,227,167,109,91,173,206,172,105,16,37,226,128,23,1,90,221,57,182,3,83,252,86,251,30,152,50,96,104,36,44,117,248,115,249,27,42,198,105,178,238,46,55,4,51,136,188,162,62,3,160,123,219,197,35,103,74,95,108,83,117,69,135,251,50,245,80,70,52,107,180,79,56,233,147,100,124,179,146,247,39,236,94,94,99,164,84,249,208,3,30,215,74,15,223,18,18,56,148,216,189,27,170,47,0,67,216,65,252,24,118,20,72,122,50,84,90,46,244,61,79,129,233,117,251,64,98,80,11,22,132,210,158,16,11,115,231,170,143,202,246,13,212,128,233,69,81,198,214,162,38,238,28,22,208,69,182,212,148,17,130,180,136,242,0,133,216,218,251,64,39,99,57,205,60,91,247,231,34,181,118,87,85,63,197,101,64,209,167,117,65,237,73,162,69,58,58,83,185,41,12,125,191,192,142,176,170,148,92,223,182,5,
207,228,36,178,101,69,128,151,174,73,4,120,72,169,170,252,16,127,65,156,45,22,217,52,214,102,89,153,67,237,155,229,138,34,190,104,168,32,39,155,211,107,61,60,83,208,102,250,173,198,52,117,103,48,252,183,226,30,151,37,52,154,98,225,203,149,95,38,81,65,69,157,26,253,159,18,32,255,135,253,194,143,82,217,69,61,152,144,44,133,107,217,70,67,222,12,215,137,21,113,145,85,252,142,218,84,150,171,22,239,12,196,46,203,142,146,152,215,152,229,136,174,26,191,31,144,183,169,65,9,134,209,214,58,141,234,184,25,211,130,25,201,17,152,130,50,66,44,113,160,45,107,173,36,36,73,148,234,31,206,224,148,241,240,62,22,209,129,210,146,138,171,252,23,60,203,181,127,37,63,51,60,38,212,114,51,74,85,130,144,204,92,249,87,221,137,238,185,236,188,214,226,123,66,192,136,33,66,120,111,87,247,163,126,23,163,185,150,3,143,173,96,156,109,195,44,140,50,43,248,5,199,179,252,245,158,55,135,190,226,92,142,208,190,98,223,126,177,247,5,224,222,206,124,28,35,235,251,148,164,168,224,196,146,77,245,91,99,49,1,66,61,62,21,250,
22,97,232,106,84,127,68,76,160,166,112,46,217,165,216,73,192,139,188,153,109,228,44,152,39,196,215,212,37,117,76,161,13,82,108,172,20,90,68,171,206,9,51,171,208,212,114,152,98,153,141,103,164,104,180,234,60,126,32,147,144,242,20,241,206,40,64,2,100,162,137,232,45,16,130,196,78,55,227,169,246,71,45,58,8,144,34,105,191,143,166,193,158,212,190,101,113,25,77,190,18,169,85,71,193,168,188,57,199,239,46,109,246,50,190,72,108,146,152,154,37,254,126,159,80,134,241,11,244,57,226,49,99,128,20,0,142,226,186,107,26,124,196,113,80,33,19,70,5,248,219,210,181,112,73,164,191,236,201,245,8,209,102,23,210,120,77,195,74,186,219,67,120,8,66,12,238,18,216,43,2,247,11,33,47,154,54,81,54,236,34,113,35,100,122,66,133,5,137,84,191,233,42,94,203,6,49,179,231,158,42,2,161,172,223,61,252,192,0,101,50,225,29,95,135,241,144,73,244,75,154,69,255,68,217,243,174,2,44,100,250,94,164,158,90,57,167,219,33,152,72,68,228,207,166,43,132,124,90,253,177,252,110,201,104,248,108,32,194,121,152,235,110,169,93,21,216,227,
161,26,179,218,86,147,78,168,247,230,169,39,244,55,225,137,216,175,233,103,145,89,205,120,213,64,233,249,204,150,96,158,132,45,2,242,156,156,82,216,29,44,70,204,243,195,7,26,196,106,135,215,148,10,154,244,7,12,228,34,100,225,195,136,105,28,237,92,51,246,77,179,144,248,1,149,200,33,59,72,121,50,9,202,142,42,66,66,82,5,189,41,25,172,23,77,130,26,160,202,156,40,227,152,135,109,15,225,128,22,103,147,126,201,203,169,236,19,168,162,2,40,36,116,229,127,174,253,188,71,145,136,85,36,86,84,117,102,229,181,6,39,166,242,236,152,134,40,100,18,162,233,203,154,6,13,24,206,203,219,236,215,124,44,173,25,125,196,49,136,25,101,56,17,141,98,166,151,147,3,162,38,35,71,151,42,152,138,28,60,125,19,208,165,114,150,75,185,213,7,191,19,53,28,155,108,125,28,131,159,230,20,24,42,125,172,201,22,3,46,102,40,145,232,112,66,48,89,35,106,43,110,236,0,141,158,122,77,200,176,83,24,168,28,94,192,26,113,5,245,56,212,236,140,166,11,156,96,52,2,154,4,49,178,61,172,57,46,72,82,1,38,174,238,11,74,104,235,44,14,203,1,
21,83,41,54,84,62,70,227,23,41,196,86,150,40,186,194,185,220,247,93,11,174,97,4,84,38,50,229,143,183,62,44,81,252,154,206,122,110,130,241,126,240,119,7,94,167,7,230,197,195,135,33,117,161,250,233,232,73,16,154,101,94,150,61,195,245,130,6,226,7,16,197,118,71,38,140,44,202,141,169,156,141,57,51,198,41,19,118,177,71,81,71,12,181,128,175,16,187,36,242,229,89,117,106,129,35,215,241,160,158,130,28,207,200,103,150,201,112,62,193,224,133,249,82,114,205,3,96,195,33,1,41,50,145,3,120,70,133,31,119,52,208,233,1,0,37,97,224,115,213,153,86,182,198,32,175,71,151,36,180,19,173,205,75,42,10,156,187,125,151,9,54,55,197,136,77,164,70,23,81,134,20,218,84,154,2,73,219,29,118,10,147,9,54,74,235,249,217,10,91,99,204,182,146,235,92,25,204,168,97,144,96,125,158,225,222,204,246,136,233,151,77,18,150,91,75,4,15,5,18,223,18,2,13,117,228,2,209,152,77,152,17,34,173,33,171,30,114,198,134,246,163,233,15,20,168,172,181,123,129,230,0,246,51,89,250,186,134,181,155,98,40,61,156,219,100,130,178,158,241,13,105,133,
33,84,110,96,82,132,190,162,172,198,177,236,254,61,32,206,7,110,119,218,10,164,17,138,146,243,28,46,253,104,56,28,6,30,196,249,16,45,111,216,76,54,91,99,125,148,237,180,190,10,235,209,243,202,134,230,248,183,121,208,55,90,241,30,27,55,11,244,181,124,115,158,161,88,142,169,71,244,99,232,3,76,243,0,134,62,44,74,166,189,164,187,28,83,49,179,93,218,104,64,217,17,90,50,33,24,48,53,229,156,104,169,235,41,237,20,121,196,238,25,9,210,24,87,61,70,120,169,29,199,23,65,210,155,17,67,42,50,105,72,155,87,13,191,0,199,46,21,202,155,159,119,132,119,22,253,159,30,211,121,135,11,141,211,224,186,198,151,244,36,22,58,45,82,10,53,51,57,79,141,249,193,21,171,130,250,251,132,136,92,148,19,225,57,115,14,216,15,76,187,167,60,82,121,236,92,85,186,48,133,43,26,234,24,36,136,211,218,19,209,250,72,144,40,249,54,16,4,86,105,252,68,71,162,206,36,7,174,36,198,174,219,33,46,207,106,148,146,86,103,87,26,159,59,65,184,84,163,198,129,158,202,139,170,50,65,68,138,96,242,55,113,18,195,48,214,86,90,230,2,9,200,199,
140,206,84,88,80,134,44,225,137,150,128,114,84,140,152,99,194,9,98,162,137,41,127,237,31,36,70,116,6,243,14,74,81,21,81,215,235,219,143,189,56,120,138,123,86,231,2,167,16,67,108,161,242,248,139,232,200,201,75,72,161,93,105,24,43,211,166,204,106,155,22,121,172,141,150,96,194,94,35,168,7,39,103,197,214,1,12,38,111,47,78,48,207,103,75,60,196,61,162,87,233,177,201,151,104,34,45,31,211,57,153,205,77,12,196,87,7,72,68,20,58,0,28,203,113,112,97,30,48,115,23,139,59,244,64,182,99,16,13,149,139,250,126,184,115,149,150,164,133,91,212,254,0,164,241,131,196,162,254,70,21,127,204,190,131,106,101,240,82,255,230,172,142,106,26,58,224,39,243,16,161,118,208,171,145,86,126,238,93,249,36,144,92,145,236,249,92,189,46,53,193,162,23,17,208,207,153,200,139,102,141,42,156,245,8,177,4,74,63,72,168,177,17,8,174,99,96,134,42,123,239,84,2,130,207,59,244,215,167,74,102,240,199,56,200,139,193,229,50,87,106,129,74,169,33,22,83,253,38,198,181,105,135,201,123,156,79,200,206,144,57,234,241,244,189,205,210,32,213,
109,103,193,113,159,251,88,180,21,91,156,56,46,203,139,180,137,139,242,168,12,145,194,114,87,54,118,147,243,131,130,170,224,155,217,146,153,148,116,227,168,20,56,74,62,146,199,146,225,22,157,69,91,18,202,26,170,224,141,201,134,29,252,149,166,204,212,54,132,32,213,232,188,234,171,140,145,40,173,32,202,17,40,53,5,135,248,218,218,161,39,92,13,149,36,103,147,30,40,199,164,248,230,217,73,153,192,104,82,195,14,50,47,232,167,217,21,180,53,137,91,66,196,66,8,227,66,125,83,12,160,99,50,188,175,208,135,246,37,61,238,157,144,177,92,164,202,197,32,24,170,102,30,53,221,84,176,76,117,159,53,197,2,255,253,40,92,70,1,97,39,126,0,13,184,76,129,84,7,40,99,70,16,159,198,128,45,134,80,147,130,25,212,112,81,234,13,55,3,138,100,65,70,25,200,81,16,213,152,157,174,49,160,216,148,168,16,137,219,233,107,219,136,164,138,147,123,15,121,166,32,123,244,204,209,96,40,122,145,81,116,231,141,136,103,62,26,80,237,140,24,40,101,182,252,36,139,154,197,220,141,8,160,158,35,144,101,177,249,98,114,189,153,134,227,
4,117,180,93,97,142,170,141,12,210,99,183,132,74,10,160,76,193,100,203,86,178,43,104,169,128,151,242,125,182,79,170,125,234,77,5,201,210,61,97,144,235,15,88,45,79,204,186,234,86,142,226,20,94,140,213,13,125,206,211,249,122,0,218,18,51,152,239,210,86,154,175,141,218,136,163,117,16,73,221,156,228,7,36,10,155,47,57,137,176,28,249,200,239,230,115,44,226,166,213,35,207,174,0,12,124,150,138,114,38,86,22,47,166,132,147,200,37,143,113,170,140,31,58,144,188,53,46,80,181,86,140,160,213,88,202,104,105,167,100,88,13,49,222,19,105,191,176,115,86,148,197,58,4,181,133,11,4,179,171,128,230,75,141,220,200,58,81,122,243,92,117,61,44,222,106,34,107,104,213,239,32,72,20,190,156,79,169,11,68,232,88,131,32,183,163,94,232,170,42,89,57,245,204,186,173,145,97,68,158,81,165,85,131,35,179,137,119,102,165,182,223,71,134,144,54,69,47,62,187,103,224,147,118,74,169,197,177,80,113,10,61,87,178,217,240,138,6,185,232,251,76,70,169,62,122,75,126,17,21,38,147,45,199,216,54,211,109,71,83,135,243,62,228,128,56,250,
220,44,174,19,74,89,72,144,154,85,68,101,101,30,210,234,37,126,156,49,57,41,249,102,126,210,135,106,28,55,145,60,206,168,91,174,121,87,24,6,196,33,223,178,245,160,98,71,43,11,4,5,154,19,44,43,196,80,185,88,157,107,218,81,185,150,145,202,83,81,3,216,124,202,80,192,102,161,14,55,118,195,93,255,205,23,170,47,233,51,13,44,187,202,241,164,213,217,205,169,219,67,83,110,47,213,3,93,238,137,70,175,52,117,215,203,102,21,75,130,22,177,134,19,188,11,8,47,59,156,58,224,239,201,106,42,38,146,80,134,48,236,73,129,208,191,243,74,231,141,120,212,101,90,60,212,76,39,141,20,247,144,22,143,244,134,76,157,158,87,143,110,93,116,196,85,149,104,246,137,142,233,236,208,246,208,159,148,84,28,58,32,36,237,146,31,20,246,51,110,64,143,177,53,51,183,113,241,237,243,199,72,25,85,12,164,159,90,0,141,40,79,84,168,203,67,194,225,225,10,75,142,79,88,164,86,167,50,74,233,65,102,77,78,44,62,58,126,141,65,0,141,204,156,56,154,183,121,234,35,174,167,130,88,227,111,175,12,4,3,202,250,56,200,41,28,80,39,17,82,183,0,
100,146,203,68,202,253,198,28,56,214,24,104,54,54,94,102,208,111,45,113,53,192,103,106,82,152,81,2,205,112,198,154,228,112,156,43,148,172,185,144,189,40,231,239,184,186,64,11,101,196,111,45,180,2,75,67,31,104,203,68,31,122,201,127,2,172,25,241,240,128,29,226,83,214,219,48,136,254,78,3,134,154,119,25,14,131,158,183,246,193,17,169,161,215,162,182,206,118,76,122,110,187,201,133,168,226,121,67,112,70,12,203,212,46,86,37,33,209,172,254,202,7,57,92,132,142,252,41,135,195,155,47,29,62,189,140,78,0,118,217,119,50,52,169,45,33,225,218,17,72,130,91,206,47,23,155,79,35,237,219,164,241,97,219,36,186,207,49,240,153,92,49,195,185,217,224,69,169,76,100,201,110,75,148,129,161,150,117,145,9,103,116,78,60,143,192,71,239,93,1,124,26,7,146,232,139,154,57,116,130,92,46,70,242,8,73,12,238,94,109,102,200,110,106,107,205,132,127,136,84,226,172,244,230,105,144,59,194,4,61,221,76,150,248,89,84,38,8,176,162,51,192,195,62,82,1,250,70,234,224,104,169,25,181,54,194,48,109,29,190,18,177,1,174,51,55,162,236,
249,125,43,68,128,198,161,86,202,5,185,52,224,27,34,218,176,201,219,37,208,116,143,195,45,160,238,72,181,78,235,243,12,224,29,22,145,221,87,210,172,122,107,159,223,167,32,27,132,64,59,141,79,36,221,117,91,199,238,46,99,40,37,243,235,212,28,20,139,190,27,171,177,99,121,103,228,116,182,232,33,116,59,107,100,126,169,179,189,202,206,36,28,191,199,14,50,115,57,146,172,252,65,37,113,223,181,112,232,246,179,175,90,184,15,187,125,196,66,202,139,6,123,55,254,12,216,162,138,46,111,149,72,206,154,169,158,130,204,68,217,201,3,2,75,38,36,92,183,22,51,147,236,66,144,196,28,125,232,133,173,235,214,235,32,187,96,133,92,41,200,72,164,143,71,195,172,194,46,194,5,226,139,58,221,212,90,238,7,53,114,32,125,75,116,202,18,151,151,74,58,242,201,100,200,65,127,158,122,200,120,129,247,29,232,80,243,27,149,58,175,136,223,109,80,75,123,131,87,104,251,62,84,213,140,36,108,171,136,53,73,1,26,127,134,13,207,238,12,162,231,66,86,210,100,161,74,63,146,96,140,83,145,30,130,23,17,145,9,2,231,22,67,164,5,171,226,
51,171,118,50,255,84,62,83,161,15,63,222,102,156,75,164,17,31,221,252,202,203,141,35,208,162,102,71,109,130,64,94,86,25,155,86,23,167,225,55,24,181,189,50,153,116,11,27,69,76,25,126,156,208,177,237,151,132,185,233,177,5,76,77,131,18,218,105,160,90,72,237,214,226,220,50,31,49,114,144,179,189,84,249,224,10,7,100,121,215,119,175,68,217,147,225,97,32,67,95,207,36,102,212,174,19,125,41,82,214,243,106,201,170,180,116,46,164,172,181,91,202,30,231,201,101,99,215,235,19,61,150,216,156,102,16,87,58,187,147,212,101,216,88,102,88,114,70,179,30,134,137,114,217,202,123,158,1,157,239,122,125,2,91,13,179,239,199,73,133,21,197,91,229,100,195,102,203,68,138,238,179,84,218,208,222,210,182,65,211,90,197,209,40,63,197,108,75,150,146,244,120,94,45,130,39,169,44,204,150,4,1,107,193,220,40,41,116,86,219,221,144,133,218,154,55,18,222,34,133,99,83,229,23,168,64,251,28,158,150,139,42,83,13,172,60,135,192,200,210,31,93,221,173,135,59,143,178,235,10,115,177,182,175,132,73,114,198,17,106,108,127,166,184,226,
234,75,133,47,96,181,80,10,25,45,57,97,66,179,161,133,174,107,178,240,54,210,38,234,46,113,132,55,103,124,154,64,80,107,76,221,127,35,40,8,229,15,35,103,33,1,80,51,33,52,37,62,119,30,33,133,70,145,149,181,161,254,10,186,60,52,19,129,35,243,44,215,40,251,228,220,131,197,145,97,82,102,153,145,23,145,220,81,45,98,51,190,190,168,145,113,71,211,49,35,113,251,53,179,147,245,37,49,0,146,178,54,140,7,199,183,49,195,85,223,78,113,84,254,145,254,79,4,176,9,102,13,84,212,175,166,25,159,250,109,17,12,35,192,236,18,36,130,30,106,120,213,50,94,31,122,8,181,157,235,24,94,118,108,232,214,126,29,35,202,51,164,190,7,114,179,57,25,239,198,73,191,254,110,214,125,162,11,101,72,112,37,188,251,38,157,209,93,178,109,149,134,251,187,89,24,42,46,126,240,115,203,49,79,178,197,137,225,58,208,44,248,140,17,176,19,87,23,28,108,164,54,140,170,33,58,200,171,186,148,162,78,254,34,102,199,133,25,193,211,34,206,51,108,81,234,231,138,2,90,235,177,26,171,159,82,78,164,151,78,205,158,83,180,217,40,216,211,166,66,
62,78,21,25,32,142,88,185,82,37,64,84,181,159,10,215,238,130,99,19,228,44,52,29,97,94,203,50,6,60,110,124,227,140,157,48,158,82,25,218,198,6,170,24,243,204,53,236,76,216,4,111,150,24,167,135,62,51,71,200,147,231,186,21,158,234,112,80,76,97,189,27,76,167,178,53,98,178,77,57,10,186,82,131,109,234,245,220,238,130,67,57,80,175,106,152,162,12,220,58,173,42,119,43,180,64,108,207,238,171,121,103,44,145,243,132,149,25,92,189,149,53,54,222,198,136,166,238,179,165,181,150,48,177,163,161,212,29,20,170,33,73,41,176,219,165,177,150,26,77,251,138,112,96,51,10,151,75,43,144,71,168,148,153,45,77,213,6,103,70,22,164,124,121,55,65,131,62,69,107,42,95,11,80,198,149,38,9,101,132,64,7,75,247,137,185,36,94,138,31,241,164,232,87,98,31,250,159,2,94,213,228,100,170,84,148,11,33,147,13,37,51,205,146,39,34,39,62,242,145,226,253,108,35,133,5,207,150,205,80,157,47,210,73,250,41,169,217,153,92,236,196,248,59,146,116,137,13,81,248,215,184,111,78,45,115,8,78,198,200,142,63,236,146,26,78,156,113,138,25,125,247,
80,217,15,40,83,129,48,238,202,97,48,170,71,108,160,173,18,70,245,82,98,76,30,49,210,164,5,80,158,230,83,238,46,84,171,119,129,9,245,115,78,67,242,211,206,37,164,63,58,163,124,138,249,153,95,113,116,57,18,14,3,94,87,109,222,87,187,228,135,112,68,243,217,126,48,147,19,92,68,230,228,87,217,251,77,29,43,250,60,130,7,115,48,0,169,79,192,5,80,195,41,169,151,175,47,177,181,145,218,239,248,106,17,214,190,226,219,246,245,18,186,149,46,185,183,220,225,11,244,25,141,243,237,72,46,241,48,111,180,100,231,231,78,114,218,55,26,69,218,179,203,44,6,87,26,65,5,5,103,192,107,210,178,173,11,6,20,180,92,234,214,214,208,226,57,46,3,11,213,94,203,203,126,124,17,228,62,9,110,128,159,23,172,137,199,150,200,16,76,158,76,49,3,231,75,93,1,161,18,11,71,73,56,62,57,25,81,182,208,149,81,20,154,199,49,222,148,141,97,176,12,228,34,245,137,195,39,12,177,105,150,105,43,225,3,106,243,123,27,27,79,39,75,157,110,56,144,41,3,252,83,77,253,100,189,118,62,236,34,73,4,89,148,209,252,112,152,133,132,24,66,207,182,248,
116,141,32,248,110,23,251,188,88,35,39,85,33,128,84,136,235,163,17,43,75,165,10,133,140,79,234,188,50,36,17,103,180,101,226,164,231,243,119,140,51,200,18,71,244,199,71,183,97,145,5,4,82,194,173,60,50,117,225,150,129,74,47,199,99,10,32,18,32,85,134,80,6,201,94,68,26,82,234,232,172,243,153,164,87,158,217,174,132,161,1,80,155,140,110,30,167,114,135,223,74,133,29,152,35,43,173,9,12,130,13,218,4,136,155,143,39,199,217,205,88,232,238,75,11,8,27,60,159,27,169,182,48,108,206,191,177,123,58,228,181,170,199,108,39,176,195,22,33,179,9,50,151,83,248,102,198,185,63,141,143,58,172,113,224,200,104,27,13,209,126,106,104,209,148,156,48,87,11,140,212,11,228,68,113,246,125,206,209,185,228,103,223,100,183,203,22,68,253,120,115,42,153,169,85,36,66,113,176,61,78,76,14,198,68,81,86,29,40,228,169,45,0,16,9,52,53,7,247,242,177,95,153,194,150,156,1,175,120,27,165,253,92,30,110,139,57,1,44,42,6,255,132,35,186,139,70,111,182,49,84,197,233,209,158,110,130,248,54,157,20,20,75,22,128,137,97,169,100,42,164,
159,11,77,200,16,237,212,87,60,228,128,52,197,1,44,78,25,47,110,232,0,152,56,67,97,134,71,105,221,71,196,220,114,202,99,106,226,48,225,174,122,121,112,57,166,132,200,238,80,60,146,20,157,182,160,64,143,150,107,110,81,0,88,218,224,91,12,182,112,180,111,57,118,231,114,239,139,84,164,142,83,142,84,147,124,11,71,93,139,65,44,101,73,133,60,228,6,131,56,135,67,15,107,72,218,82,151,174,32,227,25,143,196,151,48,169,28,170,32,72,233,216,5,179,244,52,22,99,173,26,37,67,189,122,121,130,239,12,9,13,37,209,194,4,203,60,195,160,250,32,157,196,104,229,202,159,86,113,50,215,245,66,122,195,220,251,142,159,181,235,36,128,150,60,195,178,24,221,77,32,230,112,47,249,14,85,210,93,133,76,202,126,133,179,47,120,131,210,42,131,167,27,26,92,248,219,149,118,177,76,147,93,198,114,201,182,12,41,120,166,210,99,27,222,84,102,150,52,193,50,33,110,2,82,161,245,237,57,210,1,93,176,208,118,56,10,210,211,162,188,165,244,29,73,19,100,162,100,211,81,184,107,151,45,223,141,225,6,108,100,83,66,38,79,63,100,108,164,
33,144,183,61,12,81,55,118,138,255,204,96,233,74,117,144,203,22,26,200,165,182,178,135,83,232,122,27,19,34,17,14,100,98,4,106,45,176,250,215,146,38,104,239,16,164,53,86,132,21,213,22,97,223,179,167,205,97,130,90,8,8,223,1,218,129,254,248,74,75,96,204,145,140,160,82,206,158,253,180,32,78,33,147,188,186,92,110,80,52,84,34,69,47,26,56,171,102,242,130,113,76,124,159,73,75,207,13,35,211,250,171,145,149,31,180,74,70,93,82,19,121,244,229,52,199,37,137,139,55,37,140,126,88,55,48,16,187,122,203,104,252,196,231,62,233,12,244,190,121,227,64,105,6,53,4,249,93,221,196,209,155,120,32,92,245,205,143,231,86,114,37,33,86,30,105,87,20,171,119,115,148,14,182,202,73,33,159,46,253,193,166,32,105,83,6,11,83,102,19,5,46,77,84,200,175,82,232,198,21,245,48,244,242,179,189,226,72,42,135,195,126,131,104,41,207,222,17,206,130,16,84,180,203,14,83,55,212,90,148,111,192,142,214,139,66,31,152,245,182,109,38,92,8,2,35,184,138,98,242,253,73,251,170,7,228,144,216,91,120,166,213,249,76,56,183,112,154,13,250,146,
124,95,72,74,126,100,195,117,199,21,5,242,45,48,25,133,160,104,100,10,203,5,193,187,166,105,116,94,127,156,5,0,214,232,202,33,192,76,227,162,186,164,171,50,47,129,158,67,107,164,94,92,173,164,94,145,26,38,240,245,225,163,246,19,177,34,207,160,244,173,70,178,178,4,48,241,145,106,40,66,213,92,231,148,124,171,205,153,214,77,13,139,22,60,0,47,211,177,177,241,134,82,15,163,90,40,208,49,39,196,72,183,115,106,26,138,32,81,134,25,227,249,144,230,54,174,97,73,161,206,29,56,193,236,55,115,70,104,181,43,113,99,170,255,233,181,154,62,130,181,62,124,26,169,1,223,129,87,57,116,159,126,192,200,188,175,252,81,5,40,174,208,0,113,90,158,54,90,55,146,34,221,116,203,50,79,19,34,209,178,103,145,220,23,229,175,234,7,106,158,51,141,112,214,85,112,145,190,62,239,181,222,202,178,203,228,101,1,29,247,54,129,64,14,245,160,9,73,216,219,136,160,152,139,219,253,245,55,190,100,13,39,164,132,246,177,171,20,168,64,60,23,99,26,210,68,145,43,82,28,25,6,145,194,117,23,13,121,5,165,229,166,60,244,198,245,147,147,
241,206,234,199,40,207,123,34,129,29,15,221,128,179,247,74,150,27,72,117,5,179,252,150,162,155,135,162,177,246,208,221,30,18,28,169,41,23,98,232,35,221,229,33,57,81,3,246,167,242,87,69,187,187,249,171,149,17,22,153,212,168,42,165,120,132,10,199,157,76,230,40,242,231,98,50,69,230,84,21,183,35,254,75,178,251,192,33,33,6,51,170,2,34,66,86,169,20,45,194,118,149,155,146,153,175,79,71,197,183,228,216,190,196,151,111,67,72,98,214,218,66,17,129,24,175,167,115,249,245,249,156,108,211,179,39,202,7,8,114,145,123,93,146,69,255,198,191,167,64,200,246,19,186,201,228,100,13,124,92,156,232,230,182,99,43,226,118,241,154,218,244,118,241,61,179,177,234,115,190,166,209,174,11,98,116,243,231,118,241,196,215,186,125,27,119,188,241,7,149,110,186,43,61,158,127,75,147,159,199,152,191,196,12,56,165,202,170,41,17,60,240,101,41,136,222,17,57,95,186,29,27,221,102,52,176,127,131,159,76,173,14,3,135,238,36,34,25,74,78,197,14,151,132,244,143,139,205,253,100,245,177,47,206,68,83,151,175,245,177,221,176,175,114,
245,132,181,157,17,65,96,189,94,186,166,23,118,17,43,135,195,170,11,160,153,172,241,113,220,23,35,18,54,195,57,210,100,24,221,126,64,234,134,153,72,53,229,236,225,237,9,19,231,99,111,48,63,211,171,233,194,218,72,40,82,84,150,122,115,228,55,88,202,28,176,102,144,55,239,243,183,64,180,14,96,227,59,110,171,231,19,102,88,116,7,137,131,118,159,249,56,243,233,199,122,14,65,0,175,13,216,130,84,192,226,172,198,125,209,124,250,157,44,47,29,56,38,241,14,96,213,118,215,27,56,248,70,214,3,2,188,113,61,54,155,112,137,193,92,113,60,245,198,116,114,202,251,152,206,134,53,146,92,1,166,98,97,42,89,200,42,57,111,72,151,1,224,53,235,203,154,144,75,46,87,240,164,134,204,121,98,3,86,52,39,19,192,119,154,198,46,210,232,146,119,227,90,5,10,177,245,21,11,138,205,125,97,83,236,67,81,104,197,53,183,214,139,179,57,183,174,30,8,163,237,251,27,198,156,98,2,14,110,18,208,83,12,111,4,77,179,13,136,44,198,10,42,123,92,15,81,125,13,154,81,229,209,175,38,56,53,8,57,105,175,15,70,106,98,176,57,27,41,58,5,104,164,
199,220,45,206,139,46,28,38,68,145,178,47,139,45,236,223,56,218,73,43,96,81,190,29,14,239,73,70,235,254,47,0,224,190,168,137,180,71,255,31,199,103,60,199,92,82,210,69,242,126,221,11,130,180,167,147,12,154,216,209,9,137,40,212,81,177,116,77,63,2,151,48,98,108,166,2,46,65,57,0,99,15,117,112,20,109,86,240,247,114,160,219,81,85,145,206,206,19,234,85,31,42,154,185,4,153,36,58,173,213,105,228,147,91,50,14,192,58,41,120,88,55,109,136,119,186,144,88,183,246,59,189,123,225,19,2,26,221,143,211,75,198,210,231,62,229,191,43,38,53,229,97,119,25,108,25,232,174,31,149,55,25,21,39,216,188,164,86,100,55,233,161,160,136,108,120,52,227,161,6,67,131,57,134,91,12,241,216,200,240,70,30,177,166,143,242,33,238,246,36,35,211,233,113,2,89,119,198,40,89,58,148,34,108,184,77,3,102,238,201,17,80,181,35,124,39,37,95,212,102,255,229,211,175,190,128,73,251,74,255,157,251,235,174,146,24,140,176,224,219,224,120,200,205,137,185,196,11,128,84,100,154,141,125,176,2,122,164,17,46,81,70,163,40,117,82,75,39,130,77,
210,110,65,18,120,19,51,48,90,133,105,245,250,198,185,204,204,59,192,22,119,129,5,38,101,215,67,41,10,214,139,28,113,105,64,143,223,2,178,31,79,153,15,60,29,40,214,155,242,9,15,96,185,50,217,208,160,163,49,221,210,62,129,29,94,197,30,157,141,104,33,129,161,103,178,184,210,79,199,174,163,130,164,106,153,232,197,164,173,162,75,62,76,195,137,8,41,220,187,100,137,214,77,154,18,65,29,96,119,148,79,215,76,193,52,139,171,118,198,117,240,113,16,72,128,202,160,164,107,103,153,111,167,209,36,149,144,85,150,146,123,63,21,69,8,234,157,123,104,103,23,148,220,103,91,125,209,197,106,157,143,64,247,52,181,160,64,128,29,212,196,73,182,194,132,89,81,195,156,166,75,164,226,146,2,98,41,239,65,89,187,249,213,14,77,82,18,13,100,159,61,71,48,179,74,188,215,21,98,34,236,184,79,247,243,50,149,243,67,55,197,101,16,23,69,115,155,117,21,99,40,114,198,51,217,144,37,179,14,25,234,30,173,201,160,67,119,250,133,18,90,47,26,130,20,140,2,69,154,238,158,244,86,205,138,111,171,15,20,200,43,213,147,248,58,170,156,
155,255,231,241,255,149,147,126,6,87,92,54,107,87,203,120,205,148,105,87,205,112,214,215,213,57,17,52,88,45,22,211,249,227,221,221,235,235,235,251,215,112,236,234,79,247,39,179,203,130,213,84,78,143,163,13,41,240,32,243,58,140,57,111,117,44,235,202,40,60,94,235,19,54,164,179,107,215,41,25,242,26,89,239,237,56,80,28,181,149,116,182,12,164,128,39,17,72,204,116,121,217,184,110,174,67,160,139,229,83,83,202,51,207,208,3,113,226,18,179,157,72,232,32,137,104,116,108,253,86,224,44,1,81,125,226,163,21,20,183,104,148,101,234,189,196,201,92,104,215,71,183,64,216,196,66,53,21,108,22,70,184,20,154,147,244,171,174,29,147,9,138,221,201,67,197,50,117,194,69,45,41,23,11,82,8,174,125,252,29,107,199,88,15,203,157,37,112,210,152,149,233,77,112,215,206,206,172,109,225,27,26,143,168,89,48,30,246,89,13,161,149,131,67,1,194,246,20,0,146,111,65,211,100,200,1,46,206,16,238,6,156,108,125,132,121,166,112,98,203,76,207,170,185,150,206,105,55,14,232,253,128,131,167,9,190,52,150,203,174,249,96,31,18,175,54,
244,177,107,232,132,150,117,13,71,212,141,42,122,157,193,134,163,8,54,229,203,124,242,202,234,183,100,94,251,151,12,32,213,127,192,53,231,95,33,20,135,30,40,111,240,219,136,98,179,60,241,6,14,88,161,219,191,148,34,247,38,219,157,105,243,37,197,86,121,12,142,239,215,22,12,148,158,122,98,31,130,68,245,245,227,45,170,214,136,139,9,181,250,36,202,159,36,12,90,166,102,201,136,86,10,243,104,190,74,108,234,219,91,144,157,166,221,117,166,162,163,234,203,84,61,211,13,6,84,139,46,46,228,47,226,244,27,236,253,40,122,68,14,142,230,228,79,68,221,22,158,167,77,83,174,166,94,32,251,54,27,99,110,213,135,115,191,193,213,251,225,204,158,232,150,108,228,240,32,251,23,89,120,79,30,80,78,72,179,93,246,14,33,107,28,106,61,199,187,236,122,8,45,217,98,170,167,188,227,49,2,232,1,218,158,120,113,53,212,157,28,121,212,249,57,133,86,17,4,110,75,57,168,214,70,131,74,161,78,64,210,14,158,37,105,159,38,62,153,243,22,176,88,200,191,199,66,100,217,103,149,103,174,210,123,184,141,131,17,12,79,112,224,0,227,25,
118,197,186,153,141,133,25,153,136,131,73,100,252,177,196,185,242,107,135,136,202,66,84,165,104,113,238,204,71,132,116,104,14,132,157,224,105,66,42,233,77,187,147,177,113,146,122,2,41,4,36,248,113,145,57,42,34,46,7,185,55,36,226,70,141,203,177,81,18,20,42,106,208,150,41,146,133,174,93,8,183,165,153,126,108,33,209,20,145,63,129,18,173,229,100,251,206,213,112,142,223,47,147,88,48,164,38,168,206,40,189,22,5,78,50,114,41,43,48,179,147,43,67,240,106,87,134,123,214,65,201,232,47,69,123,41,150,189,129,229,113,207,50,198,147,11,187,35,254,146,73,84,211,107,55,183,180,144,130,82,23,247,249,172,31,245,120,59,122,181,158,84,102,167,39,37,151,71,241,133,22,61,97,174,163,118,240,243,149,227,83,142,128,214,30,9,254,168,18,95,233,180,136,131,225,149,86,27,30,193,102,121,207,215,245,170,81,159,107,254,178,27,128,68,21,41,14,138,198,18,54,227,60,70,53,45,109,44,91,250,80,111,195,50,133,97,252,246,27,206,137,196,153,36,233,88,96,97,32,26,195,140,230,6,68,98,249,156,203,204,85,80,74,135,98,21,31,
208,35,106,164,95,84,209,207,13,83,154,179,171,251,120,82,183,218,213,20,97,212,63,249,188,186,237,22,173,54,73,86,77,16,87,170,57,99,59,156,156,3,105,106,194,201,13,69,9,91,191,169,40,28,103,106,195,25,116,69,233,204,228,75,72,200,89,199,151,18,93,201,55,249,39,221,28,82,0,88,73,187,211,9,118,138,29,57,178,53,107,60,169,58,32,34,149,69,54,101,28,244,124,85,142,255,212,187,189,179,122,62,173,111,246,78,234,177,102,172,220,137,142,115,105,12,121,18,150,210,147,113,37,220,93,204,108,155,28,137,125,75,232,71,146,192,136,11,33,62,250,77,180,238,39,241,84,138,104,191,32,56,109,238,6,195,215,247,43,133,95,124,155,5,13,174,41,78,195,102,201,204,200,223,198,97,203,49,119,254,84,4,176,201,166,211,31,12,170,168,147,224,120,77,154,226,218,120,211,91,202,199,143,196,107,157,121,137,11,192,212,7,161,22,39,112,180,191,204,99,10,203,211,111,224,210,227,169,232,167,48,195,154,156,74,33,46,140,217,117,107,123,254,115,44,125,55,105,2,35,95,112,162,189,64,71,185,153,162,101,64,86,155,212,54,205,
11,212,141,224,84,20,52,93,35,73,34,202,94,189,19,74,106,113,230,80,163,205,7,133,199,200,18,66,211,67,97,44,73,24,43,9,222,155,179,103,59,223,88,220,245,183,135,95,33,28,160,45,69,146,84,178,115,50,93,62,235,149,26,194,182,52,170,126,40,225,75,150,192,60,65,102,147,156,138,59,113,238,174,54,205,195,234,178,236,213,245,230,157,135,123,95,238,53,7,65,155,109,149,221,56,75,241,89,150,150,98,139,238,237,77,193,210,66,0,131,208,140,84,222,230,134,42,209,14,110,59,99,112,45,105,245,224,113,224,196,38,254,237,51,90,212,83,76,90,57,21,123,83,161,77,145,179,15,45,91,79,25,82,255,227,160,129,215,189,17,182,37,120,110,195,180,175,177,35,205,249,175,0,107,81,80,172,199,57,75,121,29,160,67,165,113,65,87,197,254,233,193,145,47,118,205,183,123,36,135,240,54,178,171,160,82,205,18,217,4,221,252,103,211,87,71,151,68,252,237,89,16,109,141,173,4,195,90,237,227,74,59,57,170,56,56,225,81,68,79,142,134,113,2,94,141,86,104,72,112,77,154,210,188,5,9,224,248,118,238,172,96,32,210,77,190,173,116,216,69,
55,24,150,252,31,11,37,241,209,205,59,2,135,132,86,89,163,212,245,82,117,100,220,133,24,196,243,99,122,31,41,48,226,220,83,156,124,189,168,42,28,102,58,195,35,213,96,133,150,126,102,115,41,17,75,191,166,198,39,87,125,109,200,176,124,143,54,89,65,110,85,40,182,11,151,85,66,160,93,104,89,199,214,19,5,200,147,40,149,90,246,117,178,10,196,244,247,40,131,248,140,8,253,135,1,215,158,225,27,229,251,76,69,56,103,62,204,164,248,250,109,4,162,122,92,95,100,170,35,202,236,23,229,0,95,214,113,13,113,98,46,64,99,30,0,238,185,10,142,58,203,30,104,152,71,150,8,127,131,17,2,32,2,186,108,147,108,19,1,211,119,234,214,163,11,186,61,67,35,234,105,106,34,140,215,152,251,162,246,116,182,142,251,197,185,53,106,79,81,201,255,36,148,144,192,140,28,27,242,139,41,146,65,133,117,45,227,29,39,211,128,81,15,16,202,176,50,190,121,72,6,236,224,18,115,251,65,121,189,107,7,226,80,58,123,203,109,192,83,201,120,148,195,148,132,97,207,174,116,212,57,236,89,140,173,185,140,134,211,37,30,162,146,133,112,112,76,50,
216,44,179,180,11,24,12,3,216,236,249,86,47,100,41,6,54,116,125,201,84,193,58,164,81,158,227,235,55,69,101,1,151,35,95,91,133,164,196,191,129,130,43,159,67,54,133,102,196,9,149,38,198,38,51,255,6,27,254,204,22,56,57,160,161,226,17,185,87,43,156,227,176,102,38,10,83,138,2,103,143,35,65,172,187,114,245,132,81,42,82,230,236,86,56,74,114,135,131,115,4,132,243,149,140,183,149,11,40,42,187,131,220,185,205,139,38,247,184,179,88,119,147,43,63,23,69,176,49,188,67,13,238,82,183,190,229,223,215,230,201,105,125,197,252,141,130,73,128,53,75,219,168,202,135,57,8,145,31,210,237,203,114,47,234,62,4,187,185,74,73,177,29,32,33,18,108,200,106,76,100,98,71,65,142,228,38,255,110,46,171,170,144,146,107,143,24,221,148,233,19,71,234,101,93,14,158,126,47,162,238,42,146,251,121,203,14,233,124,172,100,103,141,49,168,9,76,164,248,161,89,177,252,75,152,92,202,98,221,99,36,95,237,80,153,34,181,53,219,248,200,19,215,101,216,133,100,87,89,7,191,163,69,173,102,246,17,38,64,157,28,150,12,154,9,188,86,115,98,145,
220,132,97,255,116,155,149,68,115,192,58,81,19,134,158,24,28,43,135,177,23,157,47,56,215,173,201,155,136,212,196,241,200,189,195,152,212,96,213,253,23,10,219,213,14,135,70,33,26,125,110,198,200,90,9,122,178,153,90,54,250,195,245,200,119,38,8,145,115,158,139,35,217,111,228,206,146,45,169,184,77,153,56,137,190,74,48,71,146,178,101,142,38,33,72,206,239,114,153,23,138,159,41,150,226,95,148,141,204,68,204,111,42,114,168,188,128,76,111,71,160,150,28,178,94,137,27,30,136,0,230,212,39,5,149,82,31,36,76,169,140,176,94,59,60,65,40,139,204,200,218,55,58,178,224,28,118,248,30,205,109,105,179,228,248,162,17,84,243,35,25,135,75,20,65,215,50,105,51,143,108,218,195,40,173,242,111,127,112,114,161,239,184,186,155,41,97,44,137,86,212,131,146,6,140,175,148,208,211,96,240,113,5,58,91,218,21,97,171,105,135,61,86,108,147,203,206,239,170,138,64,109,229,229,144,194,0,49,165,140,233,119,13,9,22,255,210,9,40,137,9,37,165,226,170,75,136,174,161,132,230,54,77,11,129,218,9,46,184,67,88,177,172,22,41,155,205,
26,52,180,7,223,30,117,237,42,14,254,40,50,211,173,70,10,43,160,172,251,28,168,5,23,58,156,79,62,88,43,148,167,219,131,91,107,106,211,5,43,164,202,192,200,20,84,92,90,187,42,63,9,148,196,127,148,98,93,126,236,47,169,156,219,212,212,7,141,20,8,32,247,92,127,192,111,160,76,26,179,30,88,4,15,211,6,24,23,93,221,107,246,201,9,166,43,56,162,233,14,120,139,43,194,138,148,87,107,110,17,249,215,53,203,210,123,58,105,174,83,128,187,254,180,35,206,210,45,130,228,191,195,224,179,186,113,181,166,61,102,53,225,153,28,45,24,150,197,155,211,39,77,197,67,231,225,217,212,97,165,7,79,178,179,39,69,86,60,92,155,197,120,183,230,84,93,67,201,74,22,110,10,49,208,221,244,130,205,103,197,141,130,98,162,12,169,191,65,108,117,92,52,168,228,72,93,250,145,197,222,92,243,28,140,6,177,25,32,225,151,3,25,62,217,65,154,139,241,154,130,17,153,53,244,77,211,201,184,50,159,40,148,237,18,45,221,32,234,163,38,114,75,144,231,9,206,2,148,148,234,235,26,106,95,51,34,155,127,181,156,201,79,228,243,116,210,38,64,117,96,
205,243,52,209,0,160,70,90,139,131,153,142,169,0,74,146,46,155,38,88,45,101,188,90,142,20,159,167,34,41,15,56,46,89,99,72,222,107,45,148,143,155,114,115,121,21,78,249,3,10,10,44,115,68,147,106,237,158,99,80,179,251,28,53,98,130,196,240,219,196,195,210,64,37,79,220,155,170,105,86,95,32,142,82,101,44,27,236,32,230,53,39,117,108,78,70,81,89,73,242,38,12,49,45,210,209,228,108,99,64,60,73,125,50,102,191,66,132,194,116,41,142,136,250,235,186,66,160,240,132,83,58,41,217,120,161,84,99,94,229,93,83,212,128,139,220,97,194,138,215,46,141,38,67,37,98,228,26,50,194,166,192,217,129,67,109,89,37,69,98,69,13,19,184,96,21,149,185,173,82,216,226,198,147,76,195,52,30,74,49,11,220,139,41,56,107,40,164,215,67,49,94,148,38,181,156,105,243,98,191,226,186,135,48,2,181,64,73,208,105,184,168,137,194,206,21,195,34,152,9,153,216,98,51,107,190,192,91,39,16,191,103,118,176,88,218,9,33,173,207,217,208,62,136,128,33,215,68,234,96,205,209,220,138,80,242,43,220,254,169,56,137,203,239,48,175,89,29,194,165,65,65,
48,90,78,87,31,201,181,123,84,224,233,139,23,77,220,38,160,213,44,20,117,146,75,9,186,33,67,136,125,106,184,177,214,75,5,255,186,103,66,18,23,59,241,170,80,187,210,237,45,235,248,133,89,129,176,185,129,96,97,85,108,88,135,140,226,245,202,46,124,201,71,90,50,187,205,204,84,238,208,29,235,150,8,185,29,121,61,199,199,12,87,234,121,142,253,95,77,34,244,211,171,232,44,37,211,149,117,67,230,249,146,152,200,118,34,170,157,186,75,155,118,164,199,198,244,38,134,105,6,162,79,88,35,37,221,34,204,166,52,33,41,0,30,104,115,149,172,226,190,127,73,14,234,167,147,66,238,187,227,71,194,62,173,50,68,171,228,48,186,14,5,20,191,129,133,238,121,146,248,68,215,157,120,217,141,101,231,21,6,54,250,135,74,75,235,251,106,181,33,129,240,66,229,75,217,196,38,69,241,17,56,89,202,214,211,68,131,117,87,30,160,93,33,204,253,116,197,167,58,26,200,28,27,220,129,205,144,191,10,74,228,80,244,7,14,125,201,99,38,125,215,217,71,197,88,46,87,98,49,35,250,134,146,84,5,91,10,47,16,117,176,73,176,68,176,13,139,163,52,
33,121,83,164,206,54,199,206,91,237,172,204,227,122,138,94,62,199,65,4,148,225,98,101,221,103,175,57,129,36,106,0,109,247,118,251,54,12,49,69,215,10,105,241,23,146,154,168,136,10,138,253,215,71,196,20,220,244,29,106,186,178,110,67,192,214,186,49,0,9,231,214,5,92,52,167,216,146,227,156,54,45,91,100,23,8,45,69,205,46,182,126,173,81,6,156,76,52,107,21,223,54,18,129,8,54,172,187,255,234,240,76,60,248,215,253,239,246,107,149,104,44,40,239,239,52,214,21,36,36,213,52,130,116,46,117,29,124,45,211,32,220,130,24,128,95,17,176,37,127,33,193,34,107,128,207,172,1,55,199,148,89,114,43,82,144,37,181,212,70,173,111,49,126,217,223,72,170,41,218,194,116,74,73,31,83,207,70,52,105,37,91,20,173,137,45,194,41,152,114,41,28,93,238,115,219,85,152,138,100,30,66,205,214,168,6,30,175,211,229,62,113,70,11,110,245,153,173,116,111,204,56,40,45,68,208,221,130,36,137,94,226,75,33,31,63,234,178,51,155,34,58,98,46,59,34,249,89,216,201,41,153,23,109,88,2,173,184,52,175,207,110,216,13,194,151,11,207,67,35,243,188,
227,88,87,177,58,84,67,12,213,195,73,249,177,83,57,249,157,20,219,148,186,130,79,21,16,140,110,188,7,32,118,95,65,124,197,159,249,10,212,180,119,100,72,209,185,178,236,248,34,35,140,184,155,243,88,176,232,158,232,26,213,116,96,166,54,11,35,156,23,227,105,243,145,164,243,84,123,234,126,228,116,133,76,242,157,53,190,138,129,178,13,183,200,203,76,70,46,10,140,57,149,214,47,80,11,13,207,198,150,142,65,243,161,66,168,116,175,27,97,41,101,230,11,202,211,216,108,18,137,243,74,83,137,210,205,228,78,216,176,197,59,205,2,207,213,56,144,181,243,180,2,113,157,71,79,156,249,72,7,85,185,161,4,145,60,112,182,228,185,152,166,159,85,204,193,71,213,197,175,31,81,234,59,245,66,180,250,206,191,182,82,189,8,149,89,228,101,90,119,180,6,226,32,154,189,71,156,224,5,116,215,205,28,246,42,223,134,48,81,253,169,205,91,219,144,8,117,186,10,178,90,58,245,199,250,61,226,102,87,2,118,108,140,47,248,205,77,252,98,11,238,88,118,201,232,185,26,200,154,11,240,173,35,73,195,204,39,223,157,76,102,151,187,238,4,84,
62,0,207,197,53,152,120,238,104,2,82,157,13,133,191,68,85,118,132,22,203,28,223,34,72,189,8,158,39,74,16,21,158,8,115,228,83,103,2,35,62,210,231,113,42,95,41,167,189,50,153,96,176,150,117,235,17,175,100,149,16,105,169,136,236,246,106,202,9,220,128,227,204,5,2,42,202,200,135,162,177,48,249,229,212,36,76,189,78,132,47,69,9,132,136,103,97,89,234,160,57,200,161,107,66,226,26,9,30,81,66,224,176,12,60,156,145,230,223,73,1,228,207,116,253,36,78,151,118,34,96,136,136,177,87,72,39,23,1,241,105,115,82,60,35,239,218,1,51,81,206,59,99,208,228,71,219,230,183,174,120,193,192,140,223,181,238,121,137,159,31,221,113,217,75,124,163,235,102,1,16,247,171,23,161,56,160,9,157,140,49,223,73,224,100,184,124,122,180,31,191,28,202,56,121,182,87,209,51,113,136,114,158,20,174,248,131,28,113,73,22,35,17,209,237,151,150,64,138,164,204,194,121,90,95,223,130,246,98,194,48,142,59,150,2,6,130,74,136,244,71,159,108,94,74,42,43,134,241,44,139,71,92,75,174,83,48,148,52,242,65,97,86,181,136,229,65,159,122,38,4,13,
209,37,137,171,242,28,139,43,11,240,189,187,46,236,181,231,94,180,115,187,61,191,89,143,119,112,123,215,218,124,71,238,0,126,246,6,125,24,12,139,253,143,54,233,17,183,85,5,180,210,173,43,91,221,10,108,84,14,135,29,213,130,86,64,10,246,26,153,90,29,6,72,186,185,34,158,111,53,45,132,206,233,110,21,101,146,84,157,154,67,248,162,161,56,27,69,194,152,41,66,69,45,6,135,191,59,44,54,255,183,158,80,119,236,95,52,129,16,19,207,137,152,18,172,167,190,163,37,233,76,176,138,20,216,195,76,201,86,227,231,176,223,31,153,105,74,6,164,32,80,98,164,48,46,69,211,178,171,104,65,183,179,164,229,214,224,235,90,228,93,115,88,177,39,219,235,53,15,104,39,107,235,162,10,11,169,214,174,99,221,69,204,163,216,78,41,249,116,207,38,168,16,55,207,135,108,30,241,192,111,164,120,202,196,172,57,42,199,101,35,38,218,200,208,105,1,254,206,80,100,16,210,17,132,12,164,170,22,239,76,124,230,34,213,213,70,204,121,153,181,52,117,227,245,154,140,52,107,69,212,5,52,179,148,217,38,45,183,125,138,86,171,15,48,144,44,203,
114,198,205,238,58,227,72,107,70,21,69,109,171,170,72,154,200,146,197,16,108,200,74,158,250,170,93,58,118,84,163,254,174,226,160,185,30,68,56,213,165,169,15,31,51,245,77,65,10,39,225,77,20,150,166,117,28,169,70,5,164,62,68,136,19,162,100,69,255,67,113,199,143,207,186,93,187,35,8,47,188,215,30,83,206,45,9,53,154,109,105,149,139,75,242,44,193,213,156,214,71,54,249,51,67,111,42,125,73,166,20,107,40,42,211,111,205,94,37,55,40,57,165,165,13,234,243,155,121,144,80,86,7,161,75,149,118,249,125,102,119,200,100,62,54,138,8,90,72,139,152,208,190,152,181,62,205,92,167,185,53,241,44,209,136,79,62,245,65,207,104,229,119,38,197,132,82,195,215,22,9,142,99,62,113,211,254,32,106,67,34,141,76,95,58,112,40,164,218,172,201,190,45,88,112,203,162,222,154,36,108,15,74,110,197,136,100,50,21,56,146,88,132,11,115,100,64,116,217,81,132,106,86,117,60,0,118,141,233,88,5,119,119,203,196,159,97,23,52,200,226,155,249,144,84,247,229,209,25,189,79,14,184,113,152,239,96,50,189,9,141,85,103,176,240,117,98,197,161,
50,22,130,36,53,45,183,60,150,154,166,82,207,185,176,230,7,226,207,252,173,110,27,43,184,140,224,181,206,175,2,168,172,30,231,154,81,41,13,195,17,38,82,30,128,207,169,232,67,212,236,223,198,9,61,221,235,35,195,148,30,159,231,20,87,1,27,191,192,18,170,88,92,234,36,79,164,225,186,140,9,213,85,149,27,86,179,144,72,135,57,37,128,206,156,166,108,210,119,231,193,52,221,116,151,180,46,127,229,164,66,30,64,180,81,3,30,152,85,111,80,43,76,116,206,181,187,102,92,194,164,55,137,44,222,120,89,25,227,41,86,130,153,139,193,133,254,172,140,214,148,59,22,104,226,235,162,10,45,13,107,120,146,24,30,117,19,169,205,98,157,127,192,242,15,181,66,234,147,9,242,12,93,10,254,235,163,204,4,230,144,200,251,82,164,225,152,72,235,89,81,154,73,36,226,5,157,7,150,140,114,106,152,89,38,118,252,35,89,166,62,209,227,100,21,105,124,29,15,18,183,56,48,60,28,190,192,55,71,9,151,144,0,44,164,74,24,34,183,25,192,238,153,171,233,43,174,21,5,118,66,204,186,105,6,121,245,81,70,7,236,150,231,170,188,233,6,89,215,220,160,
175,3,164,54,232,200,225,217,243,195,226,244,248,217,217,219,253,147,195,226,232,180,120,125,114,252,221,209,211,195,167,156,132,58,229,103,126,167,243,219,163,179,231,199,111,206,10,158,56,217,127,117,246,125,113,252,172,216,127,245,125,241,219,163,87,79,183,139,195,223,189,62,57,60,61,45,142,79,138,163,151,175,95,28,29,242,217,209,171,131,23,111,158,30,189,250,182,120,194,123,175,142,145,242,35,100,157,69,207,142,11,109,152,150,58,58,228,189,103,197,203,195,147,131,231,172,188,255,228,232,197,209,217,247,220,236,115,116,246,74,107,62,99,209,253,226,245,254,201,217,209,193,155,23,251,39,197,235,55,39,175,143,79,15,217,254,41,203,190,58,122,245,236,132,93,14,95,30,190,58,187,207,174,124,86,28,126,199,15,197,233,243,125,138,131,218,106,255,13,208,159,24,190,131,227,215,223,159,28,125,251,252,172,120,126,252,226,233,33,31,62,57,4,178,253,39,47,14,99,43,144,58,120,177,127,244,114,187,120,186,255,114,255,91,65,119,82,28,179,202,137,31,75,208,189,125,126,232,143,216,111,159,127,15,
206,142,142,95,9,141,131,227,87,103,39,252,184,13,150,39,103,245,171,111,143,78,15,57,217,118,114,116,42,130,60,59,57,102,121,145,147,55,68,179,87,122,239,213,97,172,34,82,27,234,154,35,60,34,44,222,128,116,13,203,211,195,253,23,172,5,123,94,173,60,12,55,117,31,234,191,255,219,47,126,241,203,79,252,231,23,221,63,29,5,58,10,116,20,232,40,208,81,224,239,158,2,159,228,52,255,238,169,212,17,224,47,69,129,79,146,199,95,254,165,160,249,203,239,243,105,248,127,234,83,127,121,248,127,22,59,254,8,121,127,22,56,118,72,116,20,248,27,167,192,255,224,159,191,113,20,126,230,224,139,67,119,255,243,51,71,188,67,175,163,64,71,129,142,2,29,5,62,3,5,126,36,28,255,248,215,159,97,239,110,137,142,2,29,5,126,102,20,248,184,197,248,41,223,252,204,136,210,161,211,81,160,163,192,79,165,192,79,49,24,159,244,236,79,5,224,111,236,249,159,113,233,254,111,140,19,29,184,29,5,58,10,116,20,232,40,208,81,160,163,192,95,17,5,212,48,249,43,2,231,51,128,242,177,192,247,51,44,221,45,209,166,192,207,79,116,218,216,
253,249,191,223,33,100,127,254,133,238,219,142,2,29,5,58,10,116,20,232,40,208,81,224,167,82,224,14,119,251,177,143,126,234,210,221,243,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,63,19,10,220,21,32,254,76,80,235,208,248,79,80,224,231,87,182,188,75,210,63,223,103,255,9,82,119,175,118,20,248,111,166,192,207,79,219,255,155,9,218,109,255,169,20,232,68,239,83,41,245,87,243,220,167,123,205,191,26,144,63,27,32,221,176,228,103,35,101,183,80,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,29,5,50,5,62,189,13,221,126,50,191,253,87,249,103,27,208,31,253,251,95,37,6,63,1,168,31,69,176,126,224,39,44,218,61,250,163,20,168,201,154,254,242,163,47,116,15,116,20,248,123,167,192,186,210,124,252,231,191,119,74,117,248,119,20,232,40,208,81,160,163,192,103,162,192,199,93,77,251,155,207,180,89,183,76,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,
71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,192,223,2,5,218,133,161,79,255,251,127,17,102,221,145,233,255,34,194,118,203,118,20,232,40,240,89,41,240,233,198,178,121,242,179,2,208,45,214,81,160,163,192,127,132,2,141,66,234,111,255,145,21,186,119,58,10,116,20,232,40,80,83,224,151,191,252,255,2,0,0,0,255,255,3,0,33,85,184,202);




//additional program support files ---------------------------------------------
programfile__JoanOfArc_mid
:array[0..5318] of byte=(
120,1,237,92,235,83,91,103,122,127,125,86,149,41,161,12,75,25,143,87,165,50,162,154,131,70,32,144,53,172,44,8,57,243,86,32,46,90,153,139,67,165,24,33,144,101,140,0,155,93,156,177,98,79,6,229,140,36,228,38,37,245,76,241,193,83,143,103,210,153,126,238,135,236,125,179,155,205,110,239,247,246,115,63,245,15,232,244,111,112,127,239,77,55,46,193,235,116,147,108,228,124,120,206,251,220,47,239,251,156,231,188,16,174,46,110,172,17,66,236,228,28,249,58,249,229,213,197,55,111,19,162,181,147,231,11,95,107,25,248,75,242,252,13,155,77,187,216,66,158,155,165,111,190,30,89,184,12,206,230,191,207,54,3,231,184,58,27,105,33,26,249,109,226,37,59,88,159,195,127,132,216,128,57,253,191,85,226,70,229,126,135,124,141,80,242,45,146,38,211,88,169,127,237,228,194,185,115,175,160,114,45,127,120,245,245,25,142,21,69,125,78,159,219,207,247,136,127,164,250,248,23,199,163,201,243,33,34,118,5,9,21,210,31,98,115,244,16,237,151,191,165,125,120,222,212,90,189,218,43,166,150,156,212,82,102,113,254,22,209,214,136,102,215,52,246,160,105,118,
170,221,50,181,53,179,78,126,231,187,66,254,175,127,95,251,238,249,85,173,245,13,46,111,158,85,190,56,255,99,33,255,143,126,237,199,231,215,148,252,154,150,154,60,147,253,98,250,39,66,254,159,156,218,79,206,127,91,107,245,188,152,253,18,249,169,144,255,151,175,107,63,101,246,125,92,62,160,165,230,207,100,191,212,243,177,144,255,55,67,251,152,229,47,205,229,151,180,212,216,217,228,253,63,23,242,255,254,13,237,231,76,94,248,143,248,191,113,54,249,249,95,8,249,255,252,61,237,23,76,94,228,31,246,207,84,191,237,18,253,68,200,255,199,176,246,9,203,95,69,254,74,209,243,65,248,170,231,147,19,54,193,159,209,15,198,175,218,31,133,105,137,124,16,14,119,60,26,167,159,188,243,65,116,124,207,120,20,165,218,7,83,227,43,143,166,0,35,211,7,233,71,17,74,194,180,102,211,252,119,169,227,103,194,232,191,158,211,126,198,156,30,84,73,39,39,6,93,252,43,219,179,145,12,9,172,146,224,117,162,155,239,5,246,3,180,35,72,109,35,180,176,165,211,249,103,70,134,188,186,64,174,220,32,253,119,222,117,239,27,180,253,85,218,122,133,22,108,
253,180,72,185,96,134,4,147,68,207,236,13,64,176,125,132,218,131,244,142,78,23,159,209,12,25,217,37,175,101,136,111,119,143,238,83,218,49,66,181,215,104,218,71,103,159,5,214,72,48,77,70,238,17,253,206,222,46,164,58,131,180,117,132,166,117,218,242,236,181,21,38,69,87,137,47,83,14,237,67,196,199,164,236,180,38,76,91,107,145,124,79,132,249,55,46,237,123,108,111,25,42,204,165,19,195,252,223,174,3,61,183,127,167,168,211,174,131,75,185,135,196,149,107,43,94,162,197,123,7,122,190,173,232,162,143,16,107,235,193,165,109,70,176,49,194,142,139,182,29,232,102,137,64,130,28,92,50,203,239,0,171,29,184,242,15,145,36,13,18,229,93,29,235,75,38,91,183,128,86,126,192,24,93,185,242,14,136,29,7,142,220,254,114,209,65,221,159,151,213,187,251,187,240,188,229,224,210,230,190,240,92,223,44,191,13,140,237,192,101,150,239,193,69,59,162,227,152,22,134,201,0,211,3,140,202,16,194,114,153,42,67,120,168,100,232,62,35,156,154,33,158,145,83,50,100,170,12,153,42,67,144,224,89,174,73,222,123,105,151,217,5,171,221,112,206,9,216,9,232,6,
28,3,28,67,94,219,92,244,226,129,99,99,16,143,129,3,199,150,23,48,120,224,88,243,3,250,129,31,0,28,62,112,172,75,250,77,9,87,37,76,5,64,31,60,112,172,74,168,248,148,190,109,169,39,215,8,165,188,25,132,188,23,197,247,163,240,126,192,65,192,0,96,0,112,240,24,168,232,3,160,15,87,248,93,208,227,130,30,23,244,184,160,167,178,206,27,88,247,30,56,160,151,199,103,122,0,67,53,235,97,172,7,176,150,113,231,36,188,45,227,222,146,80,173,111,75,61,219,18,42,250,150,140,79,209,213,122,93,226,215,69,156,142,45,105,239,182,196,155,6,236,51,255,62,79,251,213,198,103,115,21,59,190,47,58,194,223,250,181,239,179,142,32,186,253,252,105,111,139,255,153,120,236,75,20,60,37,31,117,62,142,36,108,70,194,30,78,236,7,74,232,168,17,234,121,60,149,176,143,39,202,19,37,131,106,227,212,54,69,7,31,211,132,109,38,97,139,36,138,177,210,12,181,69,104,43,165,250,99,131,97,32,248,40,12,65,45,66,237,6,245,2,9,89,219,84,162,60,8,113,251,56,181,79,209,81,38,14,43,51,137,226,112,137,210,150,8,109,153,161,99,204,110,56,97,143,38,138,204,110,107,
148,182,70,104,224,49,100,163,92,124,186,52,78,181,41,106,139,82,55,227,140,37,236,51,137,242,104,41,70,91,103,168,61,66,135,25,114,150,137,151,253,165,40,181,205,210,54,134,172,136,15,150,166,40,25,167,109,81,58,253,120,129,25,130,218,178,7,134,160,208,185,64,59,33,222,134,136,104,162,28,128,75,208,9,255,13,225,146,45,144,216,95,19,17,217,2,194,250,87,54,63,49,150,31,158,243,154,252,24,213,252,24,244,67,94,158,102,130,106,55,80,93,130,156,167,237,191,19,242,251,231,45,56,60,108,190,193,148,243,248,213,4,49,18,228,74,162,28,44,189,74,181,43,180,221,224,39,138,188,150,32,35,137,226,5,108,95,76,9,206,17,234,120,28,230,156,35,137,103,97,136,183,134,105,203,72,205,232,208,146,43,246,252,64,52,138,191,251,166,246,3,54,33,137,177,28,99,221,201,19,210,251,23,172,145,155,222,189,17,26,180,140,180,123,207,160,99,150,145,97,112,212,162,25,125,143,114,56,8,56,104,133,111,110,236,133,233,162,53,178,125,7,252,139,150,177,162,11,254,155,126,192,160,21,89,14,238,69,168,110,133,215,246,86,192,248,39,110,203,72,122,64,
241,91,225,215,227,64,24,214,248,178,177,55,78,163,86,56,238,199,154,194,66,129,66,117,97,216,26,191,145,1,197,128,142,73,232,192,250,122,16,235,32,56,211,224,212,45,186,220,5,70,104,204,149,67,80,249,199,3,150,145,96,86,7,172,104,198,187,23,133,68,116,121,80,192,228,128,92,123,0,13,208,117,177,190,206,32,214,203,12,31,180,162,127,36,228,102,54,188,123,51,204,251,149,52,44,175,89,145,237,29,192,226,5,43,114,83,231,174,68,50,189,128,99,150,128,97,224,221,88,195,213,155,12,63,10,232,225,124,227,249,105,184,252,0,225,15,194,229,144,53,158,143,99,157,198,218,205,131,53,242,5,2,143,199,44,122,139,229,53,100,25,16,52,0,195,55,75,1,112,60,12,89,145,180,1,85,30,107,252,214,155,16,157,128,104,161,13,148,32,194,103,37,64,137,114,229,7,144,41,101,172,17,179,7,69,136,2,51,12,132,7,144,21,35,96,209,52,227,12,89,20,222,83,24,11,111,221,131,134,176,21,222,8,1,162,136,235,5,59,30,188,214,120,102,18,54,220,96,96,198,135,45,99,187,212,14,13,251,15,80,223,81,168,134,202,237,1,32,252,80,237,5,196,126,184,229,133,74,152,
216,102,170,13,168,218,129,228,164,21,190,207,52,64,245,86,193,134,7,148,121,187,208,5,221,168,251,237,66,11,48,120,184,185,6,168,161,224,105,136,106,150,145,47,190,3,157,239,217,173,232,45,86,14,148,111,155,149,3,101,225,229,12,201,53,240,55,89,57,253,86,52,23,0,244,2,239,175,225,31,3,157,173,189,214,204,237,49,148,209,131,242,33,203,188,60,185,98,39,30,222,182,34,57,86,39,36,151,67,212,109,155,213,15,107,148,65,212,79,214,19,97,69,224,193,120,126,5,206,47,33,28,86,199,49,107,220,220,194,122,22,25,212,177,158,182,12,243,77,184,142,12,223,26,64,44,163,50,243,200,244,253,194,36,24,222,237,134,133,16,52,33,197,102,65,131,40,42,124,191,112,1,164,97,139,230,153,12,234,104,22,55,160,228,225,26,146,61,134,100,35,201,38,219,206,12,178,100,163,226,121,150,108,86,71,15,135,225,237,119,160,161,224,134,128,7,2,76,5,43,60,171,78,24,176,7,85,241,131,113,128,229,188,11,156,127,138,45,114,211,0,167,23,201,30,4,7,42,156,103,91,4,117,196,6,230,231,250,86,175,80,125,155,5,54,106,133,111,244,2,162,158,91,108,141,179,199,
19,80,232,70,70,150,17,6,118,242,118,6,132,21,152,46,48,39,223,111,181,70,50,221,48,49,141,234,176,195,55,136,106,176,106,82,28,178,30,192,176,21,77,51,136,67,135,179,194,215,56,75,156,174,32,90,79,20,91,106,6,213,103,135,112,230,254,18,96,26,103,234,109,100,176,136,211,8,159,249,225,75,179,34,78,128,208,3,200,14,31,131,88,99,111,178,34,142,155,97,184,248,22,124,246,192,69,108,65,51,134,245,22,178,193,14,95,24,46,175,193,227,121,20,141,197,78,177,183,123,177,102,199,163,48,12,134,119,217,118,96,69,211,177,121,153,166,183,17,210,58,92,219,223,181,34,139,1,16,10,237,214,248,202,48,40,133,54,36,138,25,41,188,105,69,174,15,48,82,135,21,73,50,55,209,27,174,177,94,128,179,191,210,11,86,164,116,149,153,47,64,27,100,163,76,54,138,166,201,50,50,179,26,64,164,133,11,214,84,178,119,111,138,22,46,202,7,228,108,217,205,88,59,192,202,30,38,173,104,82,28,141,25,212,103,6,70,166,160,28,18,239,88,51,8,22,58,218,209,53,157,48,59,13,232,0,68,86,86,186,5,92,102,89,43,56,209,88,6,241,48,106,77,101,252,76,180,5,209,50,68,
113,30,149,97,142,161,2,203,126,232,194,57,155,216,192,186,180,104,77,161,116,83,112,52,138,140,49,135,99,219,142,189,24,188,153,189,237,220,155,101,214,99,56,63,49,90,194,251,194,100,125,98,20,25,147,71,24,107,118,164,99,168,93,12,248,89,51,192,36,218,173,217,251,58,30,128,184,239,103,136,14,107,46,63,188,55,135,61,59,107,122,128,8,1,226,192,204,50,99,80,21,195,126,136,154,105,168,122,159,224,72,141,194,95,29,8,101,131,109,36,48,194,187,24,234,24,219,238,1,164,214,236,214,24,83,109,131,13,47,30,130,214,44,118,22,16,23,96,107,17,182,238,192,70,12,136,123,208,20,99,170,217,3,219,163,216,179,121,9,77,22,48,58,75,94,66,83,152,138,42,188,233,4,29,117,82,114,146,30,3,63,119,197,100,97,23,28,86,140,63,20,151,224,75,15,76,194,185,35,144,165,50,12,188,132,183,37,223,150,132,183,123,65,55,64,167,128,5,98,205,153,65,196,224,5,66,16,162,102,20,174,188,5,75,78,152,100,46,93,196,122,154,229,177,13,18,239,46,90,11,153,225,189,5,100,120,46,143,204,206,49,93,91,232,255,172,8,177,188,7,50,104,180,185,2,219,145,15,177,
71,81,133,40,48,49,115,26,148,7,208,82,98,172,229,183,173,5,28,239,5,90,232,68,93,66,44,182,22,240,206,130,183,250,149,210,57,88,244,255,80,12,31,127,255,138,246,67,54,124,196,213,157,86,224,196,123,139,181,195,76,106,190,156,161,29,135,241,212,112,57,78,7,14,231,0,177,35,176,158,198,250,226,97,18,244,36,232,115,41,63,240,126,224,41,240,61,135,169,84,176,156,162,94,208,3,160,15,2,31,2,222,131,245,48,214,3,160,143,129,238,6,222,0,190,23,120,55,240,109,192,15,0,111,3,62,157,73,117,130,20,204,192,202,23,195,139,36,98,74,34,166,120,42,10,199,46,192,215,16,124,101,49,197,129,111,61,204,166,38,203,89,234,0,125,17,244,54,224,175,1,223,14,239,41,114,216,3,252,36,240,14,224,99,192,119,213,228,192,159,76,105,32,117,39,105,39,176,20,90,123,192,21,6,151,19,210,179,144,238,172,88,85,94,164,128,79,1,63,151,90,70,230,109,21,254,56,214,113,172,83,168,76,138,87,38,29,79,217,192,178,28,167,4,218,222,128,182,22,112,59,161,61,140,117,12,235,46,172,167,177,190,8,169,73,72,57,128,135,148,29,164,184,208,53,13,236,69,68,56,
143,8,59,192,149,94,79,181,1,69,215,121,28,75,120,180,67,102,25,2,204,178,136,64,229,65,85,47,137,188,136,26,79,128,191,27,252,215,192,223,142,8,210,112,143,32,194,244,2,60,141,211,197,5,238,161,200,42,176,41,216,138,211,16,147,73,194,191,36,207,241,10,80,26,214,130,107,14,186,230,160,43,158,18,248,234,254,82,181,192,126,178,67,52,198,44,166,82,194,3,229,145,202,66,28,57,143,35,231,73,236,230,36,118,179,210,50,135,136,230,80,147,133,212,104,121,129,234,160,79,128,222,13,107,215,192,207,244,141,34,34,134,87,59,68,84,58,131,221,157,193,238,86,25,248,124,79,81,213,187,47,241,254,205,202,126,148,149,253,8,144,247,163,172,236,71,160,243,126,148,149,253,40,43,251,81,86,246,163,172,236,71,89,217,143,32,207,251,81,86,246,163,172,236,71,89,217,143,178,178,31,101,211,153,108,165,31,37,161,141,119,130,172,204,36,180,241,78,144,21,187,49,155,149,157,32,43,119,95,86,118,2,120,195,59,1,232,188,19,100,101,39,168,88,247,39,179,213,78,0,110,222,9,178,178,19,100,101,39,144,86,149,23,41,224,121,39,200,202,78,32,249,227,
88,243,211,139,156,240,78,144,77,199,179,213,78,144,149,157,32,43,59,1,124,225,157,0,153,228,157,0,62,242,78,192,164,170,157,0,84,222,9,160,147,119,130,108,122,61,91,237,4,89,217,9,96,153,119,2,25,65,92,230,33,35,171,151,196,154,119,130,172,236,4,200,15,239,4,89,217,9,178,233,5,120,170,58,129,204,106,60,155,78,193,150,234,4,240,143,119,130,172,236,4,146,107,14,186,120,39,144,248,84,37,183,170,22,168,100,181,19,72,15,148,71,25,153,133,56,114,200,59,1,246,17,239,4,82,203,28,34,226,157,32,43,59,1,228,121,39,128,85,222,9,128,231,157,160,178,67,100,39,192,190,226,157,64,102,32,222,220,191,135,47,187,127,155,157,32,222,236,4,108,38,104,118,2,54,133,126,101,223,100,169,188,27,61,119,236,48,149,119,2,134,1,135,1,7,14,147,121,209,187,151,118,131,229,37,252,64,25,4,246,154,46,180,224,161,23,15,6,160,156,10,20,103,126,148,113,174,31,102,118,89,115,217,57,204,228,38,0,187,15,111,228,227,229,27,116,235,112,53,127,173,188,74,191,13,56,1,136,17,54,23,5,253,173,195,204,182,19,16,227,116,110,17,176,237,240,70,46,6,254,
46,240,69,193,87,136,67,193,10,16,25,88,244,194,114,16,208,3,24,170,129,236,77,184,139,181,152,67,86,243,5,47,36,241,145,145,47,56,64,97,62,229,195,208,237,132,170,0,84,13,98,189,119,17,8,207,225,42,156,228,206,236,250,177,246,31,174,229,7,203,107,52,112,184,158,47,108,148,215,97,100,45,95,240,3,211,129,57,212,3,142,22,32,252,153,237,86,160,240,117,133,111,181,93,54,227,12,31,170,183,115,243,221,116,225,165,223,77,205,217,10,95,69,205,217,138,29,224,47,223,183,65,229,55,201,126,119,180,72,127,36,110,141,254,65,215,126,196,110,141,40,191,53,114,158,246,179,237,143,23,159,244,103,220,15,251,233,24,96,15,32,5,236,5,52,158,244,47,73,168,240,75,146,94,129,130,238,187,235,126,232,131,188,239,110,47,160,1,40,215,155,18,102,116,224,71,159,248,42,208,131,117,168,178,214,51,222,135,58,13,62,209,51,30,192,208,19,253,174,90,187,177,30,123,162,67,15,135,208,91,15,5,127,255,166,23,254,6,171,113,128,191,46,158,77,39,214,225,39,253,21,232,192,122,18,235,139,128,211,79,244,156,19,122,195,176,219,13,56,1,232,0,156,4,94,
66,133,223,148,244,140,194,11,232,131,188,15,242,62,240,249,32,239,131,188,15,242,190,156,92,43,88,161,43,126,145,31,125,83,198,141,188,234,200,191,126,87,7,28,69,220,189,128,70,53,126,212,69,172,37,68,190,249,90,229,37,167,242,35,229,239,74,125,57,193,231,2,191,11,250,92,208,239,130,126,23,248,241,123,50,136,83,233,145,121,80,249,80,176,98,71,241,73,184,89,175,95,207,169,181,242,67,242,41,191,20,84,250,164,221,254,77,29,117,24,125,210,127,77,214,73,237,63,181,239,84,221,50,138,46,247,161,196,251,160,135,239,59,172,235,234,32,235,82,201,227,93,25,159,170,99,99,190,85,126,97,87,212,65,193,134,184,149,255,13,249,213,21,94,229,65,217,171,192,6,125,146,175,127,73,198,223,24,247,53,117,30,27,207,157,92,75,186,15,122,124,216,55,213,243,167,206,161,192,7,80,239,0,242,27,128,127,1,212,63,0,127,2,216,175,1,228,139,193,230,249,111,158,127,209,71,154,231,159,231,161,121,254,209,143,155,239,255,230,251,95,245,197,19,222,127,95,144,247,255,203,206,15,58,230,15,62,111,97,254,224,115,96,227,28,128,247,164,192,43,40,
223,227,18,239,131,60,159,111,33,207,231,15,200,243,121,4,125,132,191,151,213,92,130,249,69,208,235,241,47,59,127,85,230,31,53,7,96,206,170,155,199,213,90,65,204,1,220,63,57,55,189,172,253,138,188,154,123,142,204,121,114,30,60,130,23,251,234,101,235,87,137,95,229,89,205,217,205,249,143,239,191,230,252,215,252,254,99,115,205,241,223,127,133,238,223,252,15,95,52,58,23,109,151,31,188,109,128,234,3,56,4,188,7,31,192,131,104,240,1,228,161,225,2,226,238,0,240,195,184,152,144,244,77,185,86,23,20,71,160,226,147,122,212,139,69,125,208,87,96,125,67,236,135,253,126,216,239,71,131,228,23,23,240,143,127,16,195,159,126,92,136,244,231,20,84,116,121,49,35,249,124,57,47,14,122,16,23,14,242,98,69,125,16,171,6,127,87,249,165,46,6,228,5,139,138,247,154,244,7,23,65,252,130,69,65,117,177,160,46,96,212,139,81,197,117,77,234,83,252,138,190,164,244,200,193,65,93,100,68,21,94,189,64,213,139,87,225,27,224,175,197,126,245,247,174,254,32,87,220,249,72,220,160,253,51,209,62,170,222,160,177,95,250,214,158,122,151,218,222,243,226,247,
171,213,131,246,209,9,255,99,158,251,169,219,36,222,7,140,155,184,233,226,83,239,13,246,8,184,73,250,76,246,232,238,163,254,167,222,235,114,21,236,163,78,46,177,89,149,224,143,53,18,180,143,118,61,245,238,8,61,76,251,49,188,74,159,179,143,6,171,182,2,125,180,151,107,231,194,194,31,169,199,187,35,61,24,237,163,142,167,194,225,197,70,222,235,210,247,7,164,111,131,61,246,246,209,0,120,27,125,63,37,90,163,143,94,128,63,199,250,174,50,115,67,234,171,215,238,239,163,34,151,53,209,42,9,149,203,112,31,237,172,211,126,138,39,95,166,188,207,53,243,254,185,236,247,102,222,63,159,62,211,204,123,51,239,199,189,43,155,253,253,164,41,162,249,94,85,153,121,145,121,166,217,103,154,125,230,75,222,103,116,204,255,98,154,215,49,31,235,248,164,16,16,88,57,70,19,220,103,178,153,158,113,138,121,24,127,104,163,113,178,151,39,161,158,167,246,43,224,232,36,205,120,197,44,206,244,157,62,211,51,94,62,172,195,25,240,114,101,194,135,234,52,223,192,35,191,17,234,173,28,255,45,85,207,227,149,95,41,199,127,25,233,247,235,188,150,221,
226,4,94,120,205,149,9,175,165,71,140,87,100,156,125,207,49,219,42,255,136,76,234,99,216,102,174,27,234,242,242,185,70,237,84,174,27,246,58,251,64,226,85,58,83,230,161,167,90,157,218,221,248,27,179,203,177,255,106,206,230,233,153,71,54,190,32,187,188,254,108,214,156,55,17,75,237,253,9,59,199,159,214,81,212,93,75,195,62,172,209,251,169,245,62,189,151,156,33,203,13,182,165,190,218,110,41,118,116,99,47,121,153,253,205,110,100,154,247,51,234,4,240,93,35,107,94,185,103,251,108,239,197,154,115,100,229,205,119,252,155,244,236,121,103,231,229,132,30,255,171,206,51,242,48,224,245,80,127,163,88,185,107,61,161,11,84,237,157,225,235,138,249,173,46,46,143,88,58,230,238,146,243,87,222,90,149,219,96,254,133,91,223,51,88,70,63,213,195,51,223,102,242,249,167,26,217,25,238,146,153,55,234,58,25,145,125,234,201,97,252,170,130,108,34,146,198,94,108,6,109,214,172,102,166,230,251,225,255,183,102,120,155,170,154,53,188,121,170,118,207,94,65,104,83,175,160,35,103,225,171,121,234,112,38,212,15,41,144,145,179,156,58,228,240,75,
113,234,224,103,77,100,103,233,148,144,120,145,78,89,55,197,85,119,227,25,238,2,27,206,205,217,123,228,153,171,197,45,84,187,184,42,216,11,245,200,207,224,188,193,223,95,233,188,53,107,247,235,172,221,20,209,211,213,54,203,127,250,234,14,19,125,134,120,231,200,208,21,233,9,208,206,33,252,204,214,61,65,244,121,86,214,161,112,149,210,61,68,67,79,221,208,243,6,167,140,158,72,137,54,82,102,184,182,27,100,232,8,229,42,167,108,30,67,249,22,183,3,74,141,7,194,183,138,204,181,170,157,158,33,58,252,212,189,193,101,96,231,8,229,59,60,122,80,212,87,91,37,210,89,21,79,13,69,104,155,39,250,6,107,47,181,50,130,146,62,70,91,173,7,245,50,194,107,120,128,188,29,71,129,182,239,240,140,30,241,224,254,137,118,68,60,245,218,132,7,144,129,182,235,100,72,124,181,226,15,188,186,169,160,84,60,168,161,136,154,66,230,72,164,21,10,180,193,206,113,50,160,236,212,101,71,68,138,42,28,145,233,29,194,207,234,221,21,59,53,218,42,94,243,87,206,209,92,139,120,234,61,16,118,4,101,135,92,198,54,61,46,117,80,8,247,106,76,85,10,33,28,175,161,
84,138,199,123,89,173,140,160,152,248,131,185,66,27,233,175,17,235,28,162,173,248,181,152,167,94,254,9,102,187,76,231,171,191,143,112,177,143,142,177,29,201,122,35,255,85,11,212,193,211,71,7,4,142,239,220,218,27,133,202,107,140,79,235,149,47,116,86,150,163,188,234,5,214,211,199,118,61,162,169,177,225,237,163,94,150,233,227,228,212,171,178,222,6,120,143,78,248,21,127,132,13,248,161,94,47,149,56,208,78,106,124,227,143,236,38,86,134,203,39,45,49,214,225,174,181,222,31,197,171,84,10,27,140,167,154,171,129,62,234,17,247,196,85,92,251,127,17,239,123,125,180,91,220,123,146,161,235,164,95,21,222,209,79,91,216,30,147,117,194,159,126,86,148,174,126,106,31,162,163,226,6,154,92,190,135,45,81,45,162,147,19,75,244,50,255,163,71,255,7,66,231,122,125);


programfile__Titanic_mid
:array[0..17454] of byte=(
120,1,237,189,91,112,27,89,154,38,246,31,220,8,32,41,138,18,41,9,186,177,72,129,164,72,137,23,144,4,65,128,9,48,19,23,2,4,1,130,0,193,59,69,10,164,68,137,172,146,68,149,168,123,149,74,78,80,84,169,197,222,181,90,26,169,171,103,214,27,222,13,59,194,126,235,157,234,170,238,218,153,221,24,175,237,221,181,215,187,47,94,191,248,193,177,17,29,81,118,76,248,101,159,236,23,187,252,157,147,0,8,168,116,173,173,222,233,30,183,30,64,37,50,243,156,255,250,253,255,249,207,159,137,177,201,181,243,68,100,33,70,117,236,63,25,155,188,246,17,142,14,211,119,179,38,147,193,97,165,239,230,12,56,254,46,99,180,157,252,43,250,174,155,244,11,14,252,159,244,93,19,195,247,70,219,240,165,198,244,250,242,149,141,94,173,250,151,119,72,187,249,87,102,246,203,170,243,100,239,176,45,204,155,22,163,54,233,126,254,195,243,100,92,37,163,197,240,179,251,79,122,20,82,229,224,47,213,251,119,159,196,162,38,175,162,13,37,7,204,129,128,197,75,119,146,20,240,14,80,82,53,5,168,57,70,218,62,47,217,3,62,109,32,54,102,243,14,24,2,164,169,94,162,128,
220,217,67,82,128,242,53,42,117,199,136,84,95,85,119,228,244,47,85,170,125,146,36,205,228,241,154,98,161,102,140,174,29,120,146,84,12,30,98,114,248,90,146,164,24,13,121,2,44,57,96,146,49,140,28,217,235,33,237,68,44,42,201,100,240,4,181,97,57,97,244,80,91,55,29,197,217,86,149,46,199,232,68,103,132,169,178,5,227,90,249,184,93,238,184,57,166,74,124,92,215,147,100,200,228,83,63,112,83,117,140,206,37,201,229,35,114,39,40,25,210,66,62,197,225,38,237,104,44,90,227,14,91,125,164,249,125,97,124,177,183,147,28,62,202,31,82,233,131,238,72,85,140,152,170,24,48,174,129,143,219,235,9,216,99,106,21,31,183,253,137,135,170,228,152,49,57,20,141,81,40,73,253,30,159,33,25,97,160,40,44,199,172,160,183,61,214,103,148,201,234,137,105,33,57,246,1,70,200,251,158,200,24,141,246,129,203,110,50,37,233,144,42,83,143,98,137,145,252,58,241,38,85,242,14,252,193,137,55,25,130,132,255,230,197,187,215,51,64,109,129,154,24,89,185,190,78,61,241,14,192,148,18,228,30,212,84,117,112,213,77,27,80,210,113,47,237,117,187,201,211,97,131,130,194,
208,207,117,57,150,95,109,163,125,110,130,137,145,76,85,238,62,82,194,228,105,32,12,66,79,228,184,5,138,116,41,100,145,41,228,33,131,28,38,53,48,35,211,186,28,155,148,41,223,33,71,52,213,211,186,15,131,181,98,48,205,38,43,90,173,155,28,24,74,229,163,57,220,62,82,20,173,31,99,73,79,124,178,86,173,144,91,29,36,185,87,115,170,116,92,13,239,241,209,126,220,214,228,83,180,62,31,237,145,123,52,213,231,185,238,166,164,219,207,125,102,245,137,138,33,196,64,176,98,53,70,238,208,101,12,149,125,226,109,6,107,161,131,42,93,244,210,17,55,181,171,253,48,61,77,82,169,183,187,151,148,94,35,238,213,2,79,250,156,218,65,92,126,234,137,167,83,227,6,217,244,68,118,107,221,221,100,87,168,74,237,37,119,184,74,38,115,31,85,67,46,109,94,159,31,151,106,166,39,242,208,130,74,203,50,153,212,254,118,47,157,83,201,45,199,72,141,120,221,220,251,46,123,135,52,191,151,76,50,254,224,18,183,90,199,103,50,130,204,83,16,190,34,239,129,127,245,201,137,54,12,117,227,137,66,78,117,64,171,83,169,83,13,107,14,153,236,152,103,73,142,247,224,142,
189,30,25,190,173,245,203,234,34,6,72,64,116,66,100,113,234,28,158,193,189,235,79,124,190,60,184,233,247,1,63,6,72,13,31,226,211,120,212,251,211,79,124,180,232,27,208,62,80,233,83,31,173,170,10,249,228,19,56,87,251,164,147,180,154,206,62,225,169,112,59,95,74,165,14,153,162,129,174,235,1,0,86,76,179,169,52,48,60,173,185,134,169,54,182,164,121,113,139,245,73,60,2,87,204,135,59,201,228,163,190,182,0,121,6,184,180,140,79,226,164,157,228,182,227,134,162,18,239,101,59,184,157,155,12,183,30,216,144,187,175,210,118,212,0,201,225,247,176,29,5,198,226,251,145,108,199,29,130,249,252,255,206,118,212,48,249,6,94,99,59,62,153,84,229,101,219,201,87,61,81,233,225,135,48,143,124,6,38,197,13,67,13,81,36,68,129,208,78,103,128,16,123,246,70,232,184,28,51,41,136,1,177,199,87,20,58,4,51,182,4,98,76,141,48,95,196,20,162,199,231,2,116,200,71,99,176,191,80,220,168,4,152,172,238,196,225,42,10,177,16,13,167,227,166,100,134,197,101,99,96,96,59,154,38,41,78,85,73,58,156,138,153,19,241,252,237,20,177,4,153,147,137,234,120,48,63,18,
39,75,146,204,1,170,73,249,88,76,177,36,212,199,8,59,158,4,77,165,168,51,25,53,197,194,44,222,247,179,189,113,34,196,216,36,173,38,20,67,108,204,144,74,110,127,156,34,3,190,74,144,41,32,8,87,127,31,9,223,217,40,18,126,68,13,25,229,24,243,164,183,175,168,84,173,244,111,15,32,202,42,192,89,114,253,109,76,68,126,111,34,101,144,218,98,101,145,50,136,112,50,69,110,4,51,53,82,22,41,61,30,114,15,237,70,202,76,101,164,20,104,231,105,35,55,112,45,75,202,88,37,218,201,99,64,28,129,118,25,61,82,166,16,41,93,101,145,50,94,25,41,149,56,2,82,17,237,134,69,164,148,253,8,60,122,164,28,43,69,202,184,30,41,101,68,74,85,68,202,232,43,34,101,134,220,201,2,218,117,129,181,100,89,164,84,138,145,82,241,83,183,191,24,41,59,139,145,18,177,5,222,143,72,57,84,138,148,126,114,143,149,71,202,112,49,82,142,20,35,165,82,140,148,25,82,83,197,72,57,162,71,74,252,225,145,114,180,44,82,6,73,25,214,35,229,212,110,164,12,234,145,114,108,55,82,102,245,72,57,172,71,202,209,242,72,217,57,78,106,182,16,41,195,165,72,25,36,117,172,18,237,130,
197,72,233,27,38,53,94,134,118,1,30,41,95,129,118,30,110,24,60,12,242,252,233,53,86,225,30,34,143,231,181,86,1,107,80,198,244,228,9,182,33,103,43,173,2,57,140,60,246,30,86,225,14,147,18,175,180,10,53,66,178,255,119,105,21,174,239,89,5,178,1,221,42,252,176,10,23,207,159,106,252,34,115,242,146,37,157,53,37,23,88,124,216,24,8,150,67,122,198,156,200,150,32,125,170,58,158,40,135,244,48,139,197,45,137,209,114,72,79,155,98,99,44,30,40,135,244,184,33,54,99,72,77,151,65,186,154,164,8,22,97,201,242,88,148,49,133,50,164,100,118,99,81,134,169,41,230,75,189,20,139,178,70,37,198,228,209,242,88,244,163,18,94,14,233,73,163,156,97,158,121,29,210,149,93,72,111,11,36,73,176,240,7,74,255,91,66,210,31,23,111,191,211,181,241,31,102,233,225,53,17,191,77,164,109,88,36,218,67,9,138,37,236,229,149,136,158,24,153,187,35,44,214,71,17,5,94,108,212,235,17,154,251,137,39,128,240,89,94,137,208,172,175,168,67,96,221,83,86,132,208,238,63,193,178,49,194,215,175,229,165,136,189,35,211,20,153,166,224,244,78,103,144,90,35,180,119,132,142,
43,11,166,240,2,69,23,30,95,9,211,33,5,105,109,112,129,69,102,89,96,214,20,69,90,27,164,67,1,26,139,80,71,116,209,24,206,48,101,114,39,174,144,41,76,44,74,195,35,139,166,200,42,11,142,27,251,19,219,209,17,146,130,84,21,161,195,209,5,115,120,49,127,59,74,44,76,230,200,217,234,224,84,126,36,72,150,8,153,251,169,38,58,198,148,172,37,60,249,56,170,144,39,76,83,81,114,32,167,14,46,27,189,145,135,123,2,17,64,236,118,143,151,108,1,50,6,41,25,153,54,42,11,108,240,252,246,74,52,94,29,161,237,222,40,237,27,36,155,66,109,96,35,200,57,249,3,103,195,43,83,36,173,112,229,174,61,241,210,92,4,9,124,156,252,25,205,236,39,89,9,82,36,166,85,39,232,58,116,66,254,44,37,34,159,250,41,63,16,161,15,18,116,65,172,100,7,35,20,77,126,130,219,239,61,25,36,205,138,133,99,34,110,139,210,135,10,141,69,35,52,168,216,18,208,230,32,245,36,98,154,170,40,106,20,43,31,82,163,56,24,204,222,137,146,49,65,109,131,196,107,105,7,159,68,130,228,237,206,98,164,203,79,2,65,20,248,52,172,122,12,32,39,152,33,220,12,91,169,11,128,156,136,118,4,229,
62,87,132,60,193,89,16,183,20,164,252,137,64,96,26,35,156,120,18,161,83,9,58,30,32,219,96,191,230,82,78,107,225,240,236,94,133,2,24,18,21,129,62,115,152,180,102,133,142,70,146,154,71,25,208,64,120,109,52,174,217,113,167,54,240,36,74,74,36,77,94,153,41,68,131,52,84,46,14,63,230,143,11,113,68,98,164,4,75,226,72,68,32,145,247,16,199,160,66,209,200,127,184,56,132,32,51,92,16,157,10,23,137,102,7,35,88,31,66,81,170,18,207,35,129,42,74,162,94,33,123,100,128,2,167,73,25,32,111,63,245,247,111,197,192,216,195,48,56,190,249,164,159,8,188,66,190,1,34,47,125,65,131,178,163,67,182,250,229,42,175,124,68,241,73,125,190,191,27,130,14,6,189,61,218,116,164,247,209,114,7,153,250,248,242,200,56,200,47,223,131,251,252,40,241,22,107,190,166,135,197,154,175,57,180,188,185,185,170,213,252,35,212,123,239,252,55,78,246,143,120,189,87,173,95,32,211,98,111,53,234,189,23,207,147,69,212,123,243,231,87,26,141,231,152,197,210,86,53,170,106,255,234,234,207,156,67,91,116,76,54,56,233,113,211,49,58,126,108,72,27,114,6,44,199,104,231,174,
147,12,77,242,99,103,19,29,111,210,191,108,210,191,108,11,236,124,230,12,24,218,8,127,42,46,105,34,106,10,252,148,154,200,208,130,251,90,232,120,75,87,174,133,150,156,129,199,93,78,170,115,118,105,173,78,58,90,28,178,79,59,214,68,39,156,184,208,73,13,78,28,57,169,165,116,155,160,161,165,146,134,62,109,72,76,240,185,167,137,36,103,7,46,33,163,211,203,255,176,194,81,233,246,31,60,107,99,192,194,103,109,220,101,75,159,213,25,224,226,248,165,245,216,220,99,39,23,210,25,76,187,80,18,18,190,228,66,210,191,108,162,109,46,185,67,11,91,116,136,200,137,63,78,162,99,11,63,201,29,163,28,191,239,144,126,223,33,76,49,247,0,172,88,155,166,57,99,70,253,72,106,195,81,27,228,184,32,228,216,134,161,219,232,120,155,62,116,27,61,238,117,146,205,121,70,11,54,205,25,157,244,64,230,2,153,219,254,176,137,28,149,179,55,47,60,56,216,76,237,205,11,154,218,76,172,101,238,129,191,5,74,153,214,6,90,200,142,163,134,22,114,182,36,181,206,22,218,215,136,25,26,169,161,49,163,13,53,10,34,252,80,95,211,244,246,98,19,181,52,225,75,62,195,
194,206,167,77,100,57,156,124,236,60,76,199,15,199,114,135,105,233,80,234,113,215,33,232,52,169,235,180,32,129,140,174,211,185,71,119,56,153,153,252,188,147,90,91,112,142,155,66,82,136,172,133,30,93,117,82,117,225,92,83,233,62,125,158,7,39,154,168,17,179,30,108,162,83,5,201,21,228,216,50,93,24,69,168,118,90,55,168,87,79,254,248,176,147,218,156,153,235,78,26,43,155,187,113,14,154,125,124,156,179,154,20,226,107,164,199,141,92,107,58,143,206,133,7,39,156,212,232,196,220,78,58,85,161,188,127,71,199,87,31,120,142,147,245,248,234,118,232,56,169,199,51,90,235,113,114,28,93,124,220,117,148,234,142,78,107,173,71,233,232,225,115,186,112,22,180,99,135,233,196,209,115,143,238,28,37,219,209,133,252,252,81,106,125,245,237,184,225,40,53,28,93,208,134,142,146,113,247,246,161,195,68,71,87,31,156,56,74,141,56,119,240,40,157,58,186,154,191,121,148,236,71,87,183,232,40,253,94,209,210,184,250,75,106,44,67,163,189,205,69,52,178,101,175,175,174,94,106,140,93,191,166,237,253,115,32,210,189,127,118,152,253,185,64,36,231,66,218,
40,221,167,197,68,126,179,184,3,245,155,201,145,73,203,202,5,227,57,102,180,76,230,175,63,85,199,243,139,42,57,21,88,12,202,66,33,224,171,58,92,31,34,249,207,213,251,83,79,85,58,166,202,159,239,1,148,110,170,190,253,127,142,191,70,124,87,143,115,135,158,170,1,237,128,74,167,213,36,110,207,59,213,200,49,156,254,20,1,246,28,174,48,243,178,189,170,214,224,171,252,196,83,153,26,229,72,16,101,104,220,119,28,71,135,124,131,154,205,71,3,242,32,169,42,150,248,72,157,206,242,162,189,210,139,235,31,222,198,21,70,149,234,186,67,56,188,175,213,60,245,244,163,194,16,197,120,209,189,56,175,153,176,174,190,135,154,55,166,65,249,47,255,41,146,164,54,63,234,89,18,182,128,248,38,150,175,203,237,205,122,67,143,131,221,100,129,111,163,186,239,165,127,113,15,67,25,158,250,60,218,1,31,157,150,99,247,101,10,6,122,115,1,202,169,161,77,149,198,134,51,218,254,97,234,138,77,107,77,49,250,32,142,74,74,34,59,21,167,143,146,89,115,130,126,50,148,164,123,145,172,214,23,193,6,66,4,101,73,242,180,147,187,95,59,33,83,131,28,122,80,39,
83,167,172,186,56,173,141,32,93,115,201,178,102,150,233,20,104,221,247,20,255,63,20,162,42,15,42,250,116,20,91,32,238,94,2,10,161,246,17,192,245,65,126,185,65,14,104,216,228,82,228,200,2,246,59,90,100,255,16,254,244,232,55,99,51,1,247,200,84,227,246,73,168,237,247,123,123,134,220,52,133,59,59,159,202,97,158,60,28,148,233,176,215,167,117,226,242,186,167,30,68,53,210,124,221,97,23,174,173,117,7,80,14,146,249,46,6,54,1,109,110,178,116,83,14,119,158,196,156,109,222,46,205,237,165,106,172,242,91,64,150,218,175,245,171,36,201,254,45,236,157,180,131,164,67,222,83,70,140,168,5,158,122,122,81,70,225,163,118,200,125,216,123,17,26,212,58,158,202,158,11,184,236,46,174,1,199,253,218,25,204,215,236,57,173,245,138,45,8,147,27,165,125,95,28,51,251,52,3,102,28,122,170,250,123,177,109,81,227,86,180,81,252,61,140,219,142,63,69,41,170,222,77,29,16,163,211,77,118,31,223,130,217,171,66,74,62,114,187,119,62,4,185,50,181,184,67,70,213,103,244,246,152,3,221,143,99,94,58,165,242,12,25,172,140,187,125,71,60,173,6,57,106,84,156,
121,191,27,23,122,120,169,107,200,237,221,94,193,4,97,177,207,132,130,112,173,28,98,61,221,22,247,208,227,229,30,106,196,166,15,232,235,238,57,164,132,180,97,79,203,61,133,50,242,80,126,83,85,243,159,40,62,19,12,245,67,15,89,225,2,48,35,153,246,168,138,209,45,107,17,111,135,25,130,80,3,61,90,175,26,213,194,33,229,36,46,92,82,149,124,36,128,13,28,50,123,201,24,34,3,54,136,100,159,197,115,218,160,180,222,243,144,223,115,114,211,67,19,158,62,77,118,203,159,31,199,168,50,207,66,76,216,9,117,187,204,178,106,15,156,24,87,251,95,44,5,8,22,100,117,147,1,198,252,163,177,202,149,64,190,144,230,243,97,51,21,127,176,225,166,70,31,118,11,254,167,5,243,32,155,60,56,3,186,60,93,186,20,180,147,30,108,30,137,239,170,188,170,65,23,137,193,75,204,167,98,77,147,191,86,148,138,5,131,254,206,5,179,115,2,4,138,61,57,158,180,117,15,54,184,21,191,55,190,221,224,137,55,121,97,48,180,93,227,193,46,28,253,67,25,118,219,9,187,135,137,209,83,21,169,188,10,4,25,214,78,40,240,202,113,173,65,166,19,248,210,3,237,141,42,147,90,155,66,
14,121,6,117,177,124,123,114,241,39,97,238,208,139,194,161,221,10,161,188,35,167,8,234,18,14,157,212,29,122,180,220,161,135,203,28,122,184,210,161,229,17,114,251,9,198,95,230,208,49,221,161,83,186,67,71,203,28,26,213,173,130,67,135,117,135,150,119,29,122,172,228,208,225,162,67,15,235,14,61,166,59,52,160,217,51,204,139,173,175,112,104,175,238,208,81,221,161,177,33,202,29,58,10,135,30,213,29,218,93,116,104,127,201,161,3,229,14,173,150,57,180,82,112,232,254,146,67,163,78,233,203,98,230,112,209,161,163,186,67,199,203,29,122,76,119,104,229,37,135,198,54,221,80,193,161,107,43,69,15,161,235,210,255,225,162,247,156,134,244,223,79,244,135,97,247,216,175,148,85,98,94,89,51,193,122,122,159,202,25,237,148,151,36,53,195,75,215,80,60,237,125,170,100,12,48,157,132,119,210,128,69,97,191,50,123,20,32,216,226,141,241,163,33,20,37,213,184,209,61,12,120,240,232,240,32,3,30,210,128,135,184,14,15,241,151,225,225,68,71,80,155,243,198,181,86,121,76,243,170,89,45,19,146,243,109,42,45,193,66,79,116,96,227,213,75,251,81,135,128,
231,242,208,57,142,80,151,214,186,84,218,175,100,180,211,10,29,80,39,242,113,108,175,170,147,88,251,76,193,33,181,22,133,142,168,211,26,112,197,43,207,52,224,139,19,234,44,231,200,172,204,105,221,10,237,83,231,23,101,58,39,47,104,232,17,233,85,207,96,60,0,208,34,254,44,73,160,255,40,54,130,100,114,186,147,70,53,108,244,202,230,128,239,37,116,13,31,241,184,12,114,218,168,116,234,232,170,234,232,26,122,25,93,147,172,199,103,113,143,232,144,147,212,33,7,127,56,228,164,75,144,35,31,82,146,2,114,112,134,67,142,87,64,206,136,14,57,226,187,42,239,168,65,29,5,10,135,5,228,140,126,31,114,222,79,216,237,114,216,226,233,55,40,46,129,197,61,2,139,3,192,226,225,151,176,120,208,44,143,218,3,29,227,170,242,18,228,68,26,220,113,191,55,11,200,201,86,64,78,237,31,69,246,190,34,251,175,63,41,228,151,42,242,75,244,252,32,191,60,17,162,134,208,240,56,28,111,234,41,242,76,4,169,54,37,162,5,208,1,162,198,243,33,153,198,229,68,11,76,122,31,218,58,134,84,89,224,214,33,228,86,167,144,184,12,40,64,181,4,140,90,59,133,179,178,26,
65,38,42,114,206,122,156,76,200,17,196,124,238,143,97,37,34,225,132,54,240,20,142,238,83,184,181,11,224,90,123,170,210,45,57,186,15,211,169,234,180,7,151,108,125,246,52,148,220,178,170,40,167,37,13,33,30,254,127,114,91,166,227,17,210,110,121,167,141,145,49,163,127,216,28,12,63,142,249,233,84,132,14,5,201,230,165,113,239,216,145,193,65,131,50,111,12,15,228,209,170,209,226,29,213,106,189,52,228,77,110,175,0,35,194,168,28,136,178,93,173,50,205,250,195,22,239,132,214,171,160,252,48,173,249,2,168,44,224,15,122,67,34,243,15,187,251,169,209,75,211,125,195,135,194,211,38,212,25,6,113,102,144,172,131,161,123,97,202,40,19,218,201,65,178,235,223,85,249,39,13,145,201,252,39,225,49,131,159,88,96,146,69,16,145,195,100,232,227,123,222,22,12,26,201,26,189,227,90,196,175,154,65,183,26,28,214,122,35,243,90,56,154,61,137,11,151,34,217,60,74,78,152,1,149,46,99,148,224,97,237,216,72,28,84,12,225,193,123,131,228,31,148,55,7,105,98,16,120,232,29,255,252,56,8,0,173,97,50,161,137,199,27,49,43,147,246,160,103,60,18,223,57,1,2,
209,122,134,115,65,162,190,84,131,55,235,247,47,110,55,12,46,54,249,169,195,139,136,60,72,189,125,84,251,71,145,189,151,200,58,149,56,154,131,52,190,210,162,167,145,72,13,160,185,49,2,208,71,250,28,77,118,192,58,31,236,71,43,210,211,40,89,20,202,35,80,81,203,83,37,152,239,194,229,19,79,35,105,92,20,228,5,203,91,56,113,224,169,162,60,56,25,5,254,19,172,163,206,139,5,83,160,27,166,128,36,60,226,171,197,13,139,79,3,212,31,68,42,132,139,235,159,6,58,112,46,156,143,122,169,59,72,210,96,0,173,133,53,48,29,62,178,225,169,210,137,194,33,217,195,200,54,148,110,173,62,76,31,40,180,39,10,143,81,122,234,163,88,8,68,98,221,24,68,219,247,52,218,191,49,8,83,133,89,196,173,130,70,148,49,81,178,140,16,134,209,186,158,254,71,230,196,143,122,169,31,51,127,254,49,18,214,12,102,231,166,90,170,220,29,206,23,215,202,230,240,218,242,149,235,90,237,151,119,40,207,254,219,56,251,178,234,54,42,119,3,11,243,198,69,231,30,84,238,206,157,167,42,81,185,251,247,169,239,204,108,152,158,37,67,91,247,146,116,234,59,179,249,230,234,181,
59,141,248,34,163,121,147,84,247,157,217,114,101,253,226,218,117,254,13,112,43,73,29,223,153,141,235,87,248,97,86,91,71,107,99,13,142,47,243,27,18,227,91,7,18,196,190,51,87,157,191,182,186,124,121,179,145,48,242,30,92,231,126,208,243,37,219,99,101,39,236,44,96,99,3,118,214,97,99,245,118,102,180,49,170,126,134,17,238,124,103,54,196,249,128,17,237,147,36,25,190,51,155,54,87,87,249,128,129,252,100,130,14,129,164,59,27,55,58,248,5,131,219,169,47,89,143,157,165,109,108,198,198,198,76,184,219,242,37,59,102,103,38,59,131,82,10,227,164,226,23,82,164,57,112,116,97,149,158,165,211,91,135,191,100,45,54,62,55,110,58,103,103,23,108,236,98,61,91,183,177,37,59,155,177,50,191,157,213,219,4,53,242,179,76,140,165,201,3,142,80,103,192,173,202,62,108,196,131,30,204,95,228,38,213,191,39,77,219,193,20,93,6,93,147,107,203,66,48,225,173,12,26,68,185,96,192,53,23,140,47,73,31,224,190,181,141,91,252,56,147,63,155,164,19,69,46,167,181,75,96,218,138,219,63,186,34,206,39,98,249,27,9,218,91,156,231,89,178,231,193,103,184,2,130,48,
94,220,16,227,109,201,73,50,226,112,3,114,23,66,197,135,157,158,197,194,143,235,191,100,102,43,147,236,140,65,154,43,207,98,244,211,51,24,39,186,124,141,223,23,121,208,153,164,106,92,187,140,131,192,213,36,53,65,155,231,174,109,108,234,84,230,151,147,116,26,87,95,95,227,210,78,142,107,160,82,107,199,52,231,215,55,33,253,244,214,1,92,126,125,249,202,57,156,46,168,114,168,42,65,15,141,184,204,142,251,130,87,206,243,251,166,103,113,124,12,199,155,87,151,207,225,190,120,254,147,4,129,61,227,170,152,102,240,65,230,75,78,157,205,206,122,109,44,97,99,11,54,118,94,98,151,237,236,186,141,221,220,207,174,219,217,69,27,11,218,88,53,116,88,11,141,54,66,80,43,80,92,42,157,95,197,40,215,111,113,37,198,141,41,202,95,205,140,25,210,212,146,142,31,205,8,105,175,114,51,76,201,245,105,192,67,138,154,113,241,141,146,213,165,98,15,164,47,153,205,202,218,237,204,95,197,134,171,217,180,141,205,217,217,25,43,91,144,88,167,149,89,49,93,245,179,20,125,4,202,231,184,126,161,183,45,200,221,11,197,172,45,223,20,34,89,154,3,107,102,
124,113,110,227,178,254,69,62,37,52,107,188,46,20,179,170,93,79,210,103,56,191,169,107,58,49,179,85,35,92,64,183,152,103,73,101,27,10,106,179,177,172,141,173,8,62,47,89,217,149,106,118,161,138,205,74,236,148,157,85,89,185,3,224,26,238,55,5,109,79,107,232,54,150,112,248,178,182,199,118,170,32,201,253,172,197,206,58,235,88,151,141,185,236,172,207,198,124,54,230,183,177,97,137,203,118,178,142,205,153,216,153,189,236,172,157,91,250,234,126,118,225,24,91,171,227,19,158,63,192,86,235,185,237,175,217,216,71,118,118,233,24,187,92,199,174,216,216,85,59,251,248,40,219,236,97,215,79,178,77,43,187,102,231,170,89,133,115,216,216,180,157,69,109,236,16,156,3,178,58,6,227,122,20,130,69,164,86,151,175,9,111,28,127,112,236,75,46,70,201,198,170,112,193,7,204,108,227,150,104,178,49,134,195,21,112,246,144,155,201,5,97,140,169,153,135,251,160,194,235,248,226,214,218,234,53,24,239,114,254,227,24,87,35,131,126,179,217,237,206,44,193,246,76,64,31,168,34,51,157,95,205,112,141,22,4,153,206,106,19,56,88,190,86,50,197,84,208,152,
166,7,39,82,180,5,211,19,240,145,206,110,93,78,211,64,193,122,50,203,26,246,122,76,160,247,210,250,170,208,102,58,185,221,155,166,25,104,235,186,238,182,169,88,190,26,36,149,185,64,86,155,74,210,30,220,179,6,30,185,103,39,250,243,75,9,78,135,249,252,134,110,206,177,60,58,15,30,12,23,181,133,205,164,15,209,108,87,208,214,179,184,250,184,250,183,237,163,246,249,105,91,253,106,205,216,102,213,253,251,174,155,247,164,225,143,173,198,101,201,151,178,213,70,236,104,184,121,22,167,218,239,204,84,112,170,88,232,209,197,24,109,57,49,201,184,240,53,184,226,59,73,214,124,121,131,203,227,89,153,104,5,80,237,138,214,176,113,181,76,182,70,225,47,187,162,213,253,94,23,45,248,219,128,224,117,55,175,144,109,193,205,211,217,252,249,52,39,185,10,115,156,20,243,102,150,225,145,156,19,51,20,202,9,41,73,88,15,16,186,124,225,95,122,124,72,102,243,51,73,74,236,74,87,159,172,36,226,34,158,8,9,115,173,22,194,74,60,63,155,160,200,238,109,64,38,13,74,209,0,168,230,91,235,151,56,80,39,51,15,12,112,118,17,7,106,109,236,136,157,53,
217,217,0,208,70,98,103,108,108,93,98,215,108,108,243,0,135,252,156,157,141,218,138,17,99,24,38,90,242,187,212,204,22,172,85,56,221,179,244,89,6,195,248,48,51,222,146,38,53,29,49,101,104,50,21,219,151,166,4,226,202,81,110,135,2,249,82,201,124,178,120,71,50,241,1,238,64,20,216,85,44,216,3,70,39,187,127,138,190,202,255,130,107,55,185,161,163,74,228,65,131,136,22,166,115,203,34,142,142,167,69,84,181,92,223,184,113,110,141,115,147,45,32,179,128,179,50,96,54,109,92,225,98,214,145,217,124,125,157,99,146,46,196,228,155,128,217,124,105,121,83,24,115,17,153,77,23,184,174,17,78,127,8,52,47,227,78,29,154,77,151,214,69,128,253,62,54,151,99,114,5,157,239,133,202,133,248,82,68,101,195,21,0,69,178,8,201,5,160,72,46,21,16,217,116,105,85,132,226,34,36,235,96,90,2,100,80,161,91,202,123,33,178,229,214,170,110,234,201,34,40,155,47,10,29,232,82,143,253,30,32,114,219,174,97,165,135,41,57,190,21,77,18,165,233,46,172,244,214,178,8,192,33,74,123,83,112,221,36,157,229,30,179,38,80,32,29,39,221,204,112,45,0,80,7,80,126,63,79,2,
240,157,134,113,45,151,96,176,60,196,167,162,76,183,185,242,68,40,141,66,243,144,69,244,26,63,4,20,99,120,145,20,140,11,19,133,69,139,188,128,143,4,135,49,95,191,118,67,32,149,194,144,30,220,21,55,241,4,72,55,225,103,105,23,189,191,45,98,232,134,2,225,153,168,65,183,72,195,218,6,207,21,88,134,12,41,170,202,42,249,117,145,49,88,167,194,134,44,29,77,199,237,89,158,209,217,167,68,174,112,137,179,150,233,49,8,99,181,103,73,251,72,220,6,176,23,209,93,87,113,42,102,207,4,30,176,119,202,36,236,25,90,198,205,113,61,57,46,228,18,5,236,43,154,173,153,251,12,247,189,162,221,114,19,211,45,179,104,185,134,229,75,240,241,98,38,97,190,181,124,71,168,241,157,12,247,230,111,167,250,237,146,211,230,171,177,89,13,128,68,178,253,150,168,23,68,137,68,50,53,125,242,183,181,38,123,176,214,246,73,131,221,221,105,191,224,179,223,87,16,144,120,104,221,184,130,152,94,52,235,150,20,61,94,249,219,152,107,24,86,111,86,4,196,215,231,26,102,228,26,37,137,84,4,196,66,178,241,160,89,132,67,145,170,34,217,80,51,60,56,190,95,178,161,138,
85,193,91,147,13,100,244,5,52,195,66,55,65,60,50,242,212,240,89,92,217,254,76,36,96,157,118,22,177,177,152,157,13,227,63,118,54,82,199,92,18,219,171,167,97,142,247,15,139,218,71,191,117,68,237,43,179,182,192,134,116,255,190,124,225,142,61,176,193,243,151,96,218,238,136,218,72,245,151,229,46,99,213,113,218,25,139,113,27,43,203,94,60,111,200,11,47,33,232,110,127,138,203,43,179,151,13,216,96,33,123,153,228,137,33,150,67,12,206,172,39,134,89,156,188,90,150,189,240,24,92,202,94,84,140,85,153,189,28,64,102,88,139,204,16,185,224,27,178,151,233,45,18,58,171,204,94,176,28,46,101,47,7,196,234,160,148,189,52,38,41,183,155,134,232,190,162,103,47,72,69,42,178,151,109,152,66,49,123,209,252,120,134,98,247,182,103,137,164,118,29,217,11,150,101,165,236,37,190,117,228,93,244,104,98,123,45,204,100,100,163,85,172,214,200,206,90,216,17,19,91,183,176,38,19,219,176,176,1,19,251,216,204,18,102,118,221,34,114,30,19,187,81,37,210,158,26,246,113,21,91,55,178,21,11,203,153,88,208,194,70,77,172,214,204,142,25,25,171,226,163,81,21,
163,253,208,9,95,248,233,40,145,213,92,111,54,128,88,209,2,211,113,224,236,131,233,47,121,206,175,216,216,168,196,198,196,146,161,219,198,106,36,177,10,152,135,100,10,217,146,124,24,11,231,230,20,133,11,119,11,1,226,131,39,73,242,195,190,47,217,65,27,235,64,137,64,24,243,240,1,22,61,201,70,48,230,1,54,86,199,38,236,108,210,206,166,235,217,12,62,109,108,222,206,19,185,243,86,118,81,98,27,18,219,172,103,55,218,216,205,122,118,107,144,221,238,101,55,237,236,134,141,175,43,47,73,236,172,141,13,90,217,158,106,198,172,140,206,131,205,127,139,200,88,133,245,158,30,215,211,115,111,204,180,31,90,159,165,233,188,80,158,64,131,103,19,203,15,247,77,136,85,140,21,246,119,109,245,36,135,230,196,71,249,143,19,124,37,99,186,178,113,125,141,158,205,44,110,119,206,136,197,204,250,149,139,56,63,149,203,175,138,144,35,144,99,114,145,47,101,44,23,244,85,148,110,69,19,9,227,36,22,51,19,98,49,83,176,164,201,197,252,249,73,142,41,226,174,169,143,52,117,138,31,21,139,6,147,211,219,189,147,148,231,213,145,194,114,102,98,54,95,
61,193,151,179,186,229,165,23,243,141,101,102,55,30,55,165,105,107,100,156,234,119,13,47,157,201,171,208,9,55,86,161,249,113,108,126,141,239,226,203,88,252,111,28,95,18,51,213,99,192,23,60,118,11,86,102,10,145,242,29,149,102,222,188,190,204,235,82,187,58,51,34,239,45,83,23,95,120,238,234,74,95,120,150,116,5,169,138,98,142,174,46,228,82,24,234,85,202,130,41,97,142,146,178,244,37,234,179,169,143,242,185,41,94,201,48,111,46,139,120,175,171,11,139,79,29,92,190,175,171,207,210,188,242,85,140,5,250,76,227,241,45,26,231,74,47,162,152,208,215,150,90,84,241,120,54,127,125,156,23,120,138,183,61,75,175,229,175,166,233,96,153,138,197,23,205,111,128,151,42,102,48,112,40,216,35,160,160,213,198,194,86,102,51,176,180,149,131,195,28,160,6,235,41,3,91,39,182,98,101,77,70,14,38,3,140,23,10,248,218,202,192,174,10,108,129,39,94,99,108,212,202,54,141,236,184,141,163,193,186,129,3,75,197,106,11,181,69,221,204,38,206,106,193,114,128,233,124,54,65,53,191,253,94,152,241,225,122,17,231,38,151,182,28,40,32,74,188,72,52,110,99,103,
37,94,48,66,9,131,87,46,236,236,90,61,219,64,65,207,206,22,4,244,244,74,172,6,213,48,120,123,246,217,132,98,158,164,150,201,105,195,4,41,37,28,154,56,95,7,95,83,190,100,134,3,172,198,198,246,217,153,3,181,65,68,77,177,50,76,217,217,152,196,151,136,109,40,206,160,138,129,106,208,110,29,230,89,122,217,54,65,63,107,249,146,25,173,188,92,5,140,219,111,231,12,163,194,51,40,177,56,10,147,245,108,170,158,83,130,210,226,178,149,173,72,236,92,27,59,143,146,99,47,187,88,199,214,176,4,237,101,31,181,240,10,203,149,24,219,136,178,43,39,217,70,61,187,82,207,46,219,216,21,59,219,56,192,174,226,16,236,72,188,76,134,112,126,88,47,190,52,0,135,126,182,15,88,48,114,25,6,61,243,240,8,254,123,25,255,157,140,217,39,104,176,112,48,49,113,112,146,226,220,56,46,23,109,53,29,175,153,160,199,209,47,153,5,32,104,103,71,237,188,8,11,106,79,75,188,120,4,152,198,39,234,169,30,59,207,30,70,235,88,178,158,255,39,140,169,173,108,4,58,174,225,128,158,180,115,177,167,15,176,76,29,27,183,179,140,157,77,72,156,211,140,168,107,165,237,44,
5,140,22,249,7,42,90,7,237,172,214,206,231,170,18,148,243,74,208,159,93,5,245,176,98,243,200,101,252,3,253,190,191,115,9,201,165,88,173,219,109,252,218,189,80,130,157,181,2,252,173,44,42,241,138,172,83,104,198,40,49,202,127,10,243,64,49,215,204,111,134,171,165,125,15,62,129,242,48,186,40,56,85,67,7,86,118,92,172,248,79,72,172,89,12,211,109,231,225,40,14,178,160,15,27,155,181,179,57,4,141,94,182,112,128,157,25,230,149,45,148,199,150,237,108,165,141,173,234,229,96,212,198,80,149,68,221,11,81,165,142,157,147,120,108,185,80,205,214,90,217,250,1,182,118,156,173,30,96,23,218,196,127,80,66,64,84,57,206,206,8,131,91,20,5,229,85,137,93,168,231,3,162,216,176,80,199,150,36,110,248,184,0,145,10,166,128,194,223,133,6,118,177,135,173,157,100,235,126,118,81,102,23,48,62,190,63,206,235,160,107,162,44,136,42,221,197,131,108,205,207,214,101,182,22,101,235,195,236,163,203,236,82,43,251,8,23,212,243,74,30,38,154,146,248,128,8,128,188,182,103,19,148,31,224,255,193,225,34,10,217,40,254,181,179,137,54,94,27,79,53,112,157,65,
145,168,222,5,237,188,64,8,29,163,238,14,233,42,141,76,174,103,131,54,214,47,177,222,58,214,143,242,161,176,128,118,17,123,81,83,132,255,244,137,111,32,67,212,233,241,77,187,196,78,194,104,236,236,148,141,225,75,85,119,21,59,75,192,50,234,248,39,194,62,236,35,11,26,246,74,159,152,217,44,40,177,75,119,37,54,5,9,24,165,59,181,108,194,42,221,54,176,73,16,47,177,57,131,116,107,31,155,175,146,110,56,164,235,168,197,214,74,155,38,30,219,225,114,49,38,161,78,3,163,87,205,210,199,22,214,195,107,183,210,85,198,154,132,45,216,76,210,70,45,51,89,165,43,128,150,131,210,101,135,244,145,67,250,208,33,173,59,164,53,135,116,209,33,93,112,72,171,14,233,188,67,58,231,144,150,29,82,206,33,157,117,72,75,14,105,209,33,157,113,72,11,14,105,222,33,205,57,164,89,135,52,237,144,166,28,210,164,67,202,58,164,9,135,148,113,72,105,135,52,238,144,82,14,41,233,144,18,14,105,212,33,197,29,210,136,67,138,57,164,168,67,26,118,72,17,135,20,118,72,65,135,164,58,36,197,33,13,57,164,128,67,242,59,36,217,33,13,58,36,159,67,26,112,8,35,47,
246,80,91,46,21,119,98,108,217,75,168,242,103,175,95,91,215,14,254,10,187,49,244,223,245,176,95,85,77,145,61,53,142,174,197,197,6,190,27,147,43,118,45,62,248,7,31,252,137,59,180,179,232,38,103,119,100,103,177,27,237,11,250,145,87,125,200,183,38,61,161,135,132,182,47,47,190,244,226,146,16,190,216,89,196,23,226,66,234,12,209,108,243,67,146,67,232,140,218,254,76,52,155,25,60,120,230,56,182,253,25,186,239,229,200,118,122,150,246,120,168,201,77,212,201,59,209,12,149,83,117,70,248,227,201,139,232,70,234,36,39,122,41,186,49,103,55,239,213,32,151,74,10,102,198,38,152,11,123,188,1,242,6,240,246,130,157,27,56,3,154,2,216,172,246,82,200,75,138,119,231,174,76,22,213,143,215,123,160,95,5,27,125,20,162,237,107,152,205,131,158,59,78,182,63,127,23,15,98,160,161,145,223,230,37,213,75,184,211,237,127,200,251,160,60,254,237,187,184,70,52,135,96,76,139,26,32,52,159,5,48,13,8,138,112,50,36,69,76,35,235,211,224,78,62,132,159,124,254,154,16,223,180,221,185,196,39,199,156,120,214,129,19,131,17,209,112,135,151,96,108,163,177,
11,115,109,15,226,50,15,69,113,9,88,192,240,222,64,141,76,59,23,49,188,96,68,2,11,226,70,193,5,127,24,181,48,131,206,200,35,193,72,50,15,22,65,30,103,2,212,234,28,68,252,96,77,232,71,208,73,120,34,212,227,7,29,5,134,176,175,9,65,240,25,95,102,72,8,13,243,136,25,193,141,79,144,174,22,68,87,198,16,134,19,164,189,196,16,40,8,9,134,48,182,80,139,96,136,51,200,53,195,229,133,187,66,37,121,129,39,33,50,93,94,37,134,112,177,104,69,229,12,129,21,220,2,182,10,12,97,44,240,244,74,134,254,29,141,44,80,100,129,130,11,212,191,176,115,163,159,104,68,92,140,189,214,190,105,10,79,147,50,77,209,233,157,187,224,190,15,27,248,243,20,153,231,95,245,204,227,73,155,154,48,81,20,26,195,206,62,31,94,92,30,157,167,193,121,234,155,182,131,158,30,50,5,161,55,92,21,153,222,30,68,175,65,148,252,17,178,139,169,200,207,167,229,74,233,131,246,240,224,2,102,198,32,250,180,81,49,109,184,52,45,134,230,207,245,204,131,196,154,40,223,243,23,198,16,192,218,15,179,248,167,243,119,131,100,140,144,17,67,96,160,17,208,56,77,160,52,56,79,222,
249,237,207,132,113,99,96,3,134,7,111,138,32,16,100,134,231,183,239,138,254,7,139,24,178,32,135,126,46,138,157,27,216,143,213,229,208,47,228,240,50,65,160,6,52,233,210,232,153,215,105,42,147,3,70,215,133,55,56,111,239,225,122,44,151,3,102,67,47,3,228,0,169,67,8,66,26,53,125,194,246,47,98,218,162,40,10,226,23,51,23,197,175,79,11,18,35,133,57,223,36,7,175,144,0,164,193,201,156,230,224,1,33,192,160,12,58,99,208,82,120,158,64,169,2,57,64,13,120,230,71,151,131,87,188,41,160,35,4,176,32,127,104,231,46,8,130,228,32,69,168,25,95,193,255,194,17,26,136,236,108,14,112,77,216,240,20,10,238,192,229,193,48,128,135,250,195,102,33,212,157,91,152,172,159,76,3,1,113,7,30,3,14,161,255,20,162,216,57,47,238,171,195,125,152,213,47,110,197,0,24,57,18,66,75,0,232,216,185,129,11,245,89,59,200,130,249,116,90,244,89,239,226,110,113,21,117,240,233,45,56,135,89,49,0,166,239,15,239,220,197,29,191,66,19,249,159,116,4,28,191,146,62,115,72,247,28,210,167,14,233,19,135,116,215,33,221,113,72,183,29,210,45,135,116,211,33,2,151,67,218,116,
72,215,28,210,199,14,105,195,33,93,113,240,112,116,233,141,17,105,101,55,34,253,137,224,79,247,81,250,213,43,226,211,204,247,66,84,41,62,141,149,133,168,196,150,235,79,192,74,105,247,127,223,233,98,204,169,226,225,230,202,197,77,109,255,87,136,56,182,255,222,197,190,170,58,67,118,117,112,225,188,113,177,183,176,255,111,92,165,42,139,225,81,231,72,180,216,39,31,125,180,41,81,247,243,217,46,195,87,18,115,72,6,135,100,116,73,38,135,100,118,72,22,135,84,229,146,172,14,201,230,144,236,46,73,114,72,213,14,105,143,67,170,113,73,123,29,82,173,67,218,231,144,246,187,164,58,135,84,239,144,14,184,164,131,14,233,144,67,114,56,164,195,46,233,136,67,58,234,144,142,57,164,227,46,169,193,33,125,224,144,26,93,82,147,67,58,225,144,156,14,169,217,37,181,56,164,86,135,116,210,33,181,185,164,118,135,116,202,33,157,118,73,29,14,169,211,33,117,57,164,110,151,228,114,72,61,14,169,215,33,245,185,36,183,67,234,119,72,30,23,34,174,228,21,161,119,208,197,195,48,130,49,66,242,144,139,135,103,4,233,160,75,10,137,152,141,200,61,236,
226,81,28,177,28,17,61,238,226,209,29,49,62,233,146,32,76,132,124,4,254,180,139,39,1,72,5,144,16,76,186,120,114,128,20,97,198,197,115,5,100,12,200,27,22,92,60,135,64,38,129,124,226,172,139,231,22,200,48,86,92,60,213,64,194,129,180,227,130,139,167,32,72,68,144,142,124,232,226,169,9,204,225,178,139,155,6,12,228,42,44,197,197,237,5,86,115,29,22,228,226,118,4,107,186,237,226,150,5,251,130,149,125,234,226,22,7,187,187,255,228,230,243,89,154,255,74,26,238,130,42,122,191,146,162,57,105,36,39,197,115,82,34,39,37,115,82,42,39,141,231,164,76,78,154,200,73,147,57,105,42,39,205,228,164,217,156,52,159,147,22,114,210,98,78,90,202,73,185,156,180,156,147,206,229,164,243,57,233,66,78,186,152,147,214,115,210,135,57,233,82,78,186,156,147,54,114,210,213,156,116,45,39,109,230,164,27,57,233,102,78,186,157,147,238,228,164,79,114,210,167,57,233,179,156,116,255,85,20,77,171,222,45,199,87,156,200,146,79,128,5,48,2,142,192,23,92,1,108,150,92,65,207,204,32,147,11,149,57,25,4,8,49,66,152,144,42,100,59,35,68,61,41,36,15,21,164,133,
70,132,145,63,71,232,249,74,100,98,154,42,221,255,103,35,18,57,184,81,26,29,220,34,97,142,186,45,194,16,185,21,10,19,220,239,224,246,119,192,193,141,15,150,167,155,221,113,221,224,132,181,53,59,184,169,193,206,116,35,211,45,172,187,96,91,207,213,118,10,56,72,110,199,172,110,122,238,235,0,175,30,158,215,241,236,78,183,175,33,145,251,5,139,102,5,155,226,6,37,172,73,55,37,144,175,27,145,110,65,48,31,110,59,130,227,179,194,255,129,2,186,189,64,48,220,82,116,51,17,54,2,249,193,64,32,75,221,52,96,23,220,40,96,17,91,141,207,241,122,37,60,17,192,187,210,209,245,212,76,201,102,194,19,88,145,230,199,67,104,53,84,155,181,227,64,61,0,109,18,89,27,30,248,108,38,165,153,66,205,228,105,22,169,97,66,160,94,136,156,177,102,146,155,201,205,239,221,89,196,133,49,145,108,33,211,116,119,145,220,69,106,23,69,186,30,242,113,112,14,249,152,210,67,161,30,242,244,136,204,13,207,8,168,60,71,11,105,232,242,70,115,48,207,103,120,250,211,76,32,71,222,37,4,185,17,242,82,12,0,18,48,89,129,4,124,203,223,225,212,76,190,102,154,61,162,
83,241,115,228,162,120,151,19,159,12,137,42,94,117,165,246,209,108,23,121,251,40,208,39,82,62,156,152,213,179,152,46,154,233,162,16,39,82,228,73,160,117,170,147,240,222,41,95,175,158,153,209,12,237,116,76,225,109,115,34,253,195,233,153,78,10,225,1,148,94,100,75,219,55,179,30,243,12,109,247,139,84,105,48,75,213,98,6,74,247,145,218,39,178,37,44,77,69,116,1,37,18,238,197,60,217,46,82,244,169,240,24,11,230,153,234,165,64,151,158,51,81,182,144,208,246,234,9,109,111,126,16,19,151,114,90,92,140,33,2,93,228,198,249,84,159,166,166,176,151,134,63,152,3,210,3,71,30,254,86,45,202,120,196,118,65,22,127,178,68,83,248,51,69,52,227,209,6,33,15,208,137,228,23,18,158,1,255,120,114,155,211,89,20,9,228,33,212,35,9,97,112,169,20,232,196,140,32,26,116,234,4,64,48,208,143,24,99,251,26,102,200,116,137,82,119,186,75,80,171,139,9,36,165,186,56,61,144,212,76,31,39,91,233,42,203,46,179,30,24,68,165,224,64,62,164,22,232,227,58,130,236,192,26,207,158,75,178,83,10,58,122,136,141,57,80,179,205,151,2,152,27,3,131,46,188,12,13,164,21,
165,184,115,209,77,108,138,63,127,2,94,141,200,164,211,80,60,136,135,5,114,1,22,141,80,215,140,46,50,208,26,234,45,230,211,152,90,55,65,220,241,149,20,217,133,201,152,128,201,81,129,148,99,2,41,211,175,71,202,51,2,41,207,10,164,92,17,96,185,42,192,114,237,21,96,169,131,209,199,244,92,238,202,125,197,97,243,186,128,205,91,2,57,239,10,228,188,7,216,220,110,124,174,118,237,180,206,210,44,132,133,110,220,144,122,86,69,19,33,41,231,85,180,48,146,186,26,82,233,179,216,234,112,140,62,81,151,225,188,154,65,57,139,182,89,244,175,47,123,209,207,55,242,199,203,223,71,50,241,5,138,173,226,49,181,207,212,101,60,20,160,153,149,179,120,191,158,86,139,87,66,169,203,148,88,232,199,119,18,208,47,25,230,29,24,148,138,61,250,12,239,180,202,134,254,83,74,7,234,224,199,104,22,162,148,119,251,82,138,234,147,161,237,15,147,116,112,118,48,127,103,150,170,102,188,154,58,171,218,102,208,89,61,19,96,179,148,191,63,21,52,205,160,16,5,47,205,198,242,119,179,100,73,5,183,240,58,56,107,138,118,110,99,232,172,250,83,0,3,205,134,31,197,
102,201,55,163,106,42,156,119,10,144,57,19,192,66,255,81,98,134,186,166,34,218,201,41,58,156,13,233,46,175,60,186,59,69,150,153,96,254,222,12,25,167,228,45,154,9,217,166,40,31,157,161,158,41,12,157,29,61,141,163,134,44,13,164,35,63,21,254,20,18,51,76,13,131,21,21,99,230,239,112,142,84,13,207,150,152,211,104,250,79,147,57,131,7,225,178,170,57,67,90,55,80,14,243,169,51,10,156,76,27,154,33,86,160,44,13,202,192,244,143,69,217,83,157,178,135,156,119,78,217,25,78,217,246,157,51,68,243,129,237,207,230,9,89,36,209,243,120,87,215,31,19,202,247,72,40,159,243,87,154,113,92,251,93,37,150,136,251,217,126,58,220,79,114,63,169,253,152,40,67,207,99,253,93,179,94,164,154,72,41,179,122,86,137,164,107,186,152,89,206,225,64,207,46,129,153,34,193,124,126,152,232,144,23,80,8,248,212,115,205,21,92,163,231,155,28,69,113,128,156,179,128,164,218,16,224,211,112,136,167,115,31,209,243,166,16,169,131,184,83,79,69,175,32,27,197,197,72,71,63,214,51,82,28,92,95,122,206,105,228,241,223,0,28,205,14,82,108,144,66,131,184,93,79,86,111,
97,64,113,129,1,81,142,231,22,131,252,154,136,184,236,171,66,42,203,49,25,67,33,157,5,46,243,140,54,79,207,49,226,72,47,77,246,170,147,98,137,30,31,160,169,1,30,121,155,68,46,4,177,143,200,52,45,211,40,127,142,87,29,37,154,70,16,198,211,188,42,246,220,69,52,142,224,5,34,42,252,14,97,120,44,78,115,113,117,14,255,129,177,143,81,106,140,71,250,121,162,241,9,90,152,0,162,215,52,22,171,0,11,248,146,232,204,24,69,198,30,197,16,189,207,144,47,60,74,11,163,154,138,51,168,111,4,135,105,14,79,187,45,196,40,28,171,194,128,65,224,133,56,211,53,151,162,96,74,59,25,36,154,163,195,232,156,195,163,203,136,34,156,146,32,159,253,209,93,113,181,101,38,69,10,46,19,103,14,227,197,72,83,184,12,76,97,205,62,51,140,247,131,109,225,11,64,89,62,58,69,61,147,137,45,154,152,60,141,109,195,134,9,234,199,211,142,147,169,7,92,24,115,163,154,60,71,230,133,209,45,194,212,103,240,7,62,188,128,115,226,72,147,207,144,121,9,95,46,97,72,252,1,1,115,227,63,165,137,81,144,171,249,38,136,38,113,251,36,153,167,240,116,197,20,153,103,208,81,63,
55,138,212,65,235,158,163,234,133,148,166,158,137,179,5,224,208,25,98,75,113,77,89,34,54,50,70,57,72,35,199,101,228,91,26,165,232,40,186,252,137,143,127,102,152,34,144,6,94,81,184,20,171,18,210,122,148,16,103,186,34,41,58,3,54,65,24,222,8,19,78,210,2,216,212,37,120,38,78,17,72,67,92,109,9,167,64,184,118,82,156,57,140,238,221,32,46,19,18,164,240,48,45,64,26,115,73,219,2,164,49,71,61,51,144,6,120,153,192,227,102,96,98,106,82,27,194,211,38,144,220,223,144,80,206,4,254,37,44,252,190,75,148,30,92,197,210,131,88,32,98,153,168,175,180,176,112,212,23,91,215,92,98,189,229,42,86,31,92,197,234,131,75,212,195,197,98,20,11,175,85,151,168,135,187,36,172,59,176,96,205,185,138,37,113,177,156,197,162,86,95,132,205,186,10,235,176,41,151,168,138,187,176,138,121,14,73,3,26,196,218,24,43,100,172,147,199,92,162,58,46,214,207,88,244,140,184,68,117,220,85,172,142,139,245,54,214,70,170,88,129,99,29,30,208,11,228,174,66,129,220,43,86,236,88,183,99,245,238,22,43,249,94,177,242,114,185,36,44,193,186,92,124,181,143,21,25,86,254,
88,255,183,63,152,149,22,159,211,243,190,110,82,186,169,163,155,252,221,120,159,12,69,186,191,0,81,88,229,98,185,139,165,47,214,192,200,242,144,238,97,133,28,206,73,106,78,242,231,36,95,78,234,207,73,189,57,169,43,39,157,206,73,109,185,231,176,12,120,71,7,175,23,242,84,223,95,86,50,177,13,22,75,38,182,244,242,149,198,232,165,27,215,87,181,195,95,163,104,82,245,207,19,236,107,241,114,129,241,133,171,198,69,127,161,104,82,120,221,73,116,169,126,39,250,2,141,254,125,232,248,76,69,52,71,138,90,191,69,47,213,112,143,233,69,58,109,254,118,243,152,173,221,142,22,44,59,225,49,115,135,69,26,221,175,183,92,217,68,203,21,122,104,30,172,125,205,176,247,117,82,60,15,225,179,50,236,187,30,150,248,198,41,118,88,38,176,113,40,118,121,176,165,114,202,42,54,95,112,153,56,229,180,139,190,245,169,23,105,76,27,83,211,167,209,230,210,153,242,54,225,161,133,100,84,66,119,106,95,42,185,31,157,120,167,179,211,123,209,153,241,209,215,188,13,8,155,99,216,149,107,174,99,167,109,188,95,28,219,148,216,13,67,99,196,106,3,111,7,71,
83,236,199,232,142,181,179,155,237,47,166,78,218,144,220,124,205,110,29,120,145,141,238,159,34,219,215,188,141,2,155,50,87,237,188,109,60,193,94,100,98,230,44,25,191,230,123,124,124,143,85,107,123,145,206,214,35,231,56,141,237,235,100,196,248,173,53,100,253,112,30,253,206,182,251,247,27,166,110,88,55,207,216,219,71,109,214,16,56,206,183,191,136,207,48,192,231,183,195,61,210,252,65,91,163,213,238,171,169,234,56,93,189,52,96,189,175,224,130,199,244,2,125,209,49,215,231,93,49,170,65,151,76,107,66,136,246,88,138,92,169,164,54,156,14,86,165,104,187,243,107,190,247,138,61,105,108,73,13,96,203,213,202,102,196,134,27,54,167,249,46,28,118,78,193,151,216,118,67,203,8,54,175,246,217,248,86,33,213,65,96,29,153,177,217,180,111,79,134,102,82,10,90,81,98,73,175,57,69,73,188,28,53,53,218,251,109,79,210,238,190,108,189,127,191,254,230,61,219,135,40,189,38,237,130,104,77,121,145,66,214,150,120,24,67,78,149,78,106,29,105,170,206,206,242,28,174,246,219,11,62,107,160,219,254,98,106,212,240,173,177,201,54,186,95,106,180,218,
96,96,224,11,13,118,43,14,174,240,250,22,91,115,187,228,238,180,13,247,216,167,250,109,75,3,92,255,87,228,186,155,129,99,247,149,6,82,183,198,94,32,13,204,142,229,235,190,230,157,243,205,86,214,105,103,174,99,172,95,236,222,97,195,12,219,135,231,192,89,61,187,120,156,43,96,221,197,55,186,23,173,124,107,109,204,202,100,177,133,219,32,122,189,120,139,190,214,245,34,75,117,169,96,238,219,218,136,109,30,133,244,13,168,193,119,243,30,88,179,173,204,90,209,151,110,13,161,221,239,39,205,96,74,219,242,166,240,188,115,58,142,36,118,123,41,77,71,82,145,7,106,50,126,36,69,209,68,247,193,36,141,38,135,240,22,217,71,231,191,230,70,105,128,182,91,153,100,229,54,234,181,241,29,224,121,43,223,149,4,49,151,96,28,186,249,216,216,173,105,118,187,149,221,178,241,221,108,236,33,99,99,151,164,23,73,26,79,120,118,122,18,52,158,108,127,142,68,252,127,83,19,138,166,198,3,6,52,65,13,197,66,38,188,37,57,22,163,255,249,118,186,111,207,108,255,67,107,154,140,169,30,251,76,175,109,150,182,39,146,73,6,132,78,17,239,73,77,69,114,233,
164,45,69,159,187,210,180,47,179,48,153,142,161,205,243,108,74,169,66,139,54,188,47,165,216,190,69,215,26,26,239,155,215,237,99,155,182,11,119,234,135,63,182,31,187,8,57,72,141,35,48,175,45,235,139,236,56,103,118,33,75,39,210,201,137,175,217,30,27,223,114,198,179,19,216,240,172,147,132,157,156,122,145,229,79,0,105,206,44,53,124,123,51,96,125,49,149,101,223,142,245,73,205,237,182,205,99,92,175,14,11,92,186,173,214,100,235,169,182,79,212,219,241,165,228,148,142,157,180,119,156,182,9,53,75,232,191,188,34,91,111,6,246,8,155,94,192,44,216,62,21,13,6,195,112,32,209,198,132,173,90,60,253,49,119,146,183,49,157,145,216,82,61,203,9,77,195,221,209,132,16,65,47,129,216,173,245,85,49,181,154,69,177,53,42,182,224,199,176,227,138,103,158,208,99,0,132,192,118,43,118,240,173,108,31,186,172,96,222,1,152,17,101,147,219,235,72,113,82,241,203,240,66,251,232,132,189,126,213,38,4,113,16,159,16,196,196,164,36,218,247,62,191,243,53,111,109,128,189,193,102,128,65,251,109,12,27,231,93,48,57,116,91,233,83,137,206,121,72,165,65,
60,168,117,176,158,183,57,224,122,90,132,225,228,255,159,1,116,67,243,60,40,133,7,175,83,212,15,127,6,232,205,255,71,2,189,140,154,238,23,160,23,18,160,151,214,65,111,90,7,189,220,15,2,189,158,93,208,75,191,26,244,50,223,3,189,197,18,232,165,222,6,122,203,239,0,122,131,2,244,32,215,86,30,79,82,154,0,189,105,128,94,226,63,24,244,102,102,211,97,1,122,113,1,122,161,34,232,77,190,13,244,166,116,208,155,214,65,15,249,125,57,232,77,254,112,208,219,190,240,38,176,227,150,252,53,91,221,243,98,102,177,234,235,119,132,189,238,23,51,100,154,93,125,216,56,63,127,8,176,209,61,79,218,95,181,157,145,255,43,149,167,177,254,220,156,239,224,2,141,206,120,154,230,104,251,236,72,246,209,250,8,29,138,103,114,60,225,31,207,97,75,43,154,202,69,146,7,163,52,56,67,181,200,21,18,217,39,242,215,252,169,186,250,106,246,129,141,53,73,172,181,142,57,37,230,1,168,161,193,17,237,21,112,64,209,220,193,251,74,196,19,101,103,171,217,114,61,91,209,91,72,218,56,50,162,25,4,17,246,204,1,222,154,113,166,142,45,30,96,243,240,122,244,47,74,
252,63,11,245,252,70,224,0,144,20,237,70,112,60,244,219,248,37,230,182,243,135,187,142,33,108,73,172,26,109,88,18,179,216,5,248,194,199,183,154,120,89,30,251,3,168,9,163,50,140,250,112,169,250,142,186,49,170,199,216,103,64,245,29,219,14,165,210,59,246,37,176,136,68,238,135,253,10,212,159,75,117,119,212,165,81,119,71,141,26,219,29,168,87,163,106,141,12,15,21,108,236,138,140,138,154,54,42,219,195,101,13,15,168,123,35,153,67,13,28,149,112,175,54,251,2,235,161,210,166,147,225,239,20,51,168,170,240,218,198,234,141,107,155,90,219,175,249,203,153,254,69,63,251,53,207,159,188,217,210,166,211,197,98,155,195,195,175,44,63,87,23,242,126,21,111,166,92,208,176,155,231,15,204,92,11,80,74,70,31,181,123,65,27,144,201,230,89,160,190,180,197,77,249,101,15,225,241,225,122,239,2,169,11,15,189,191,230,225,8,173,87,117,162,109,235,24,218,126,234,89,179,196,90,234,120,226,212,95,207,97,12,104,11,33,162,161,165,23,143,199,33,9,176,178,110,209,211,130,160,138,36,202,135,46,105,137,101,172,188,135,9,109,39,232,168,225,109,42,
34,37,90,0,81,60,67,172,249,181,80,25,114,164,6,222,236,3,125,225,18,128,51,148,133,168,134,103,69,13,213,140,254,203,181,159,71,178,164,78,111,227,157,152,71,240,250,9,101,129,66,11,249,195,10,29,14,81,42,0,98,199,182,8,63,26,161,100,89,128,106,85,122,124,3,239,171,144,233,255,94,143,156,253,41,133,87,41,154,110,137,208,227,250,95,51,123,47,179,16,15,149,120,138,110,79,27,147,234,153,5,77,79,85,63,15,227,133,134,244,103,205,193,117,234,95,207,135,130,180,175,159,58,7,150,41,188,150,15,13,240,23,97,6,112,198,187,158,199,251,130,240,188,254,9,101,141,6,150,243,31,14,96,207,31,111,205,92,35,239,90,62,140,84,55,72,129,193,53,10,174,61,200,10,185,29,70,138,129,54,27,17,60,208,160,118,65,180,208,109,226,41,76,59,187,101,103,119,108,236,238,1,246,201,49,118,215,250,115,44,153,176,23,251,107,118,235,16,195,15,153,212,88,25,3,81,63,159,254,249,239,144,250,159,208,0,207,211,181,247,36,181,140,196,50,163,252,215,69,163,180,141,163,175,243,252,181,245,155,171,90,223,111,96,150,183,254,229,113,246,155,170,89,178,
59,150,23,206,155,22,211,133,183,24,98,47,20,191,90,243,224,63,191,186,84,111,254,66,157,222,217,247,27,30,87,77,13,140,156,95,168,244,87,171,169,89,205,157,162,234,212,116,126,20,103,234,25,36,217,138,102,170,106,150,168,98,147,213,60,156,163,17,11,173,92,122,42,132,156,25,13,200,55,15,112,169,222,20,201,17,250,202,98,118,145,140,34,138,214,127,17,203,238,71,6,214,17,35,67,108,58,159,20,115,33,139,67,231,211,20,218,206,144,112,67,31,13,236,46,177,59,189,236,182,200,191,129,52,71,36,158,249,210,224,23,40,125,196,211,218,80,156,12,241,153,109,51,110,70,199,157,196,115,123,116,102,33,183,7,58,37,241,127,60,183,137,245,4,102,171,253,34,78,91,255,203,200,228,170,198,151,250,233,21,173,45,77,142,244,89,205,254,127,32,29,173,111,225,75,19,60,19,66,84,107,53,212,224,177,17,124,131,20,230,102,0,25,147,246,193,23,168,22,142,79,223,75,167,45,227,212,60,190,112,40,77,109,99,75,71,198,233,35,148,61,18,179,218,80,130,12,99,43,143,174,252,134,103,18,200,180,241,220,221,7,128,47,124,34,179,194,243,173,245,188,195,16,
94,40,139,214,205,40,122,11,69,123,23,50,28,180,140,33,141,65,3,33,60,111,214,202,230,170,217,60,32,81,100,68,64,197,184,196,111,180,131,248,193,47,48,211,248,248,227,153,113,60,153,60,134,191,99,148,95,31,156,212,58,7,169,206,63,169,181,251,241,170,172,73,77,9,16,222,35,139,183,144,78,218,20,218,130,134,204,162,49,19,64,128,236,137,247,195,137,102,53,180,175,89,185,107,125,49,72,123,188,139,63,165,129,165,99,120,167,195,228,0,213,38,86,30,12,252,134,85,213,176,5,179,144,189,141,221,254,128,221,137,178,219,162,139,28,173,122,192,13,9,183,238,249,34,178,178,7,73,177,233,55,204,36,113,135,5,22,32,117,234,20,184,48,2,150,4,82,204,213,113,102,208,4,136,0,192,123,255,68,115,234,58,50,101,116,121,142,179,75,31,240,21,23,111,5,20,205,123,112,67,5,93,158,200,197,204,95,68,8,3,83,224,139,200,217,135,20,62,139,183,114,226,79,25,210,182,255,219,146,81,167,55,46,221,185,186,182,113,101,93,27,248,6,70,125,251,127,32,246,77,213,125,108,240,159,95,240,27,23,9,107,213,7,139,43,78,118,238,56,176,229,239,222,251,69,180,
29,111,222,213,252,209,227,250,159,194,81,99,197,81,131,126,212,161,255,169,60,247,199,251,162,127,160,114,161,111,86,60,166,95,224,125,40,223,156,59,110,89,241,144,229,190,229,156,195,98,9,209,138,199,114,238,152,197,114,94,59,246,139,215,152,5,121,84,188,103,16,141,87,48,156,191,189,198,241,251,199,37,57,251,76,206,130,220,223,195,241,200,121,162,120,155,179,7,106,207,144,238,246,132,215,198,10,229,103,200,114,94,40,127,152,86,50,66,249,245,187,202,207,156,38,1,18,120,34,10,143,205,31,161,40,7,0,113,16,109,135,136,40,211,131,103,160,249,222,244,107,205,1,147,234,35,56,223,11,105,156,141,133,185,248,109,206,174,31,52,134,32,22,119,247,253,192,187,203,68,7,110,157,61,69,57,150,28,131,50,167,57,251,130,247,70,202,28,41,30,64,48,58,207,120,49,228,235,156,228,85,227,189,10,99,43,92,172,66,42,156,166,174,239,209,244,214,49,222,69,42,229,140,21,162,66,5,29,209,198,183,202,166,64,199,143,37,21,110,136,101,182,167,143,94,65,211,187,202,166,194,138,223,77,83,175,113,188,119,160,233,68,153,21,191,218,134,190,
47,39,225,89,111,129,216,55,88,79,133,238,168,35,102,66,129,251,85,222,73,206,198,146,241,188,201,146,202,52,248,110,148,253,56,210,122,3,110,84,104,240,237,52,189,105,164,247,179,170,55,226,208,123,201,233,141,152,84,161,193,87,89,122,185,85,125,179,210,69,191,40,99,81,7,245,46,178,244,114,80,199,73,203,144,0,117,117,23,212,11,105,95,133,24,223,205,17,190,15,129,37,243,221,69,194,246,215,26,93,133,139,190,65,152,21,148,189,131,130,127,24,192,59,203,197,88,38,193,31,144,16,255,224,187,43,157,240,155,149,86,232,178,128,233,186,34,91,75,169,153,214,246,234,140,172,53,87,8,54,173,34,216,80,103,214,132,135,56,132,199,119,208,233,89,211,233,194,129,158,186,59,207,82,23,143,200,216,109,198,143,207,33,9,160,174,194,121,61,167,248,102,165,133,126,129,183,16,119,116,20,70,5,122,160,179,143,103,10,150,219,181,43,45,34,83,24,210,28,191,168,0,191,150,11,212,213,206,71,197,47,215,201,68,45,187,163,234,16,45,7,41,218,129,49,117,44,226,29,80,34,42,11,64,23,121,1,238,140,115,194,156,139,58,38,241,237,251,46,206,143,
78,21,168,65,255,165,30,83,113,166,131,159,41,15,184,194,70,168,117,138,63,226,210,213,110,2,75,173,156,43,158,152,240,185,10,121,42,231,9,3,9,18,113,82,31,69,24,112,95,152,19,95,154,31,251,129,56,95,54,63,231,140,203,132,211,143,249,185,112,43,249,95,199,176,98,8,49,57,248,47,92,85,57,115,144,11,167,48,179,51,89,22,26,192,188,115,81,87,12,232,225,55,11,197,148,248,7,243,149,10,121,41,25,131,247,182,46,9,249,23,249,199,40,96,190,181,130,127,144,40,68,192,167,16,140,112,41,10,254,193,28,88,20,182,193,133,167,83,89,150,176,113,249,243,75,10,196,113,201,85,242,255,22,253,11,229,147,44,248,47,132,35,142,128,37,253,235,202,231,36,8,253,99,254,74,171,228,243,191,164,255,239,99,4,87,62,76,64,215,191,206,130,16,65,185,254,185,150,248,146,141,179,88,166,127,8,31,38,32,28,131,159,132,240,97,2,101,250,215,229,83,97,191,21,252,235,198,223,194,173,128,171,88,16,15,47,40,205,252,10,251,231,41,84,178,24,128,223,198,191,96,190,210,127,94,205,63,8,105,93,50,9,181,23,236,95,112,81,76,148,184,254,33,130,34,42,188,100,5,
190,48,55,1,225,8,220,10,116,120,16,64,82,92,111,136,251,125,156,197,130,22,185,23,150,144,191,32,133,11,175,147,130,48,190,130,21,8,19,252,62,10,8,23,4,22,20,28,5,84,148,89,33,40,19,134,80,54,127,133,20,10,16,132,135,223,224,14,83,5,41,232,186,168,72,196,185,8,42,124,185,224,5,48,1,24,66,137,127,152,192,203,235,173,239,161,64,5,255,208,127,129,132,215,162,160,16,1,55,177,130,255,57,95,66,1,225,2,48,196,87,122,225,43,248,175,64,65,110,255,75,156,121,65,5,159,69,224,31,71,129,50,43,16,46,80,224,31,151,8,124,212,81,128,11,255,236,174,163,11,225,227,188,225,62,51,221,199,75,154,119,177,24,132,200,194,10,4,35,223,199,2,126,62,86,112,68,96,97,113,22,221,10,95,97,5,220,23,74,89,163,240,66,174,8,221,10,116,253,85,90,129,128,195,114,44,46,95,152,234,81,0,36,8,65,112,65,98,254,86,225,241,111,179,130,50,42,244,136,32,64,153,15,161,71,132,151,168,120,41,34,8,68,43,185,131,110,184,8,42,237,84,194,5,16,130,177,202,112,129,135,163,96,165,45,86,88,4,100,161,135,6,29,122,113,51,92,79,167,194,208,186,100,64,253,6,65,
127,240,21,118,1,191,40,27,136,248,234,93,143,17,176,17,92,94,194,72,61,70,8,31,111,160,206,217,98,230,112,122,86,247,145,2,88,34,133,168,196,75,12,1,75,105,119,225,87,48,11,198,218,46,196,12,127,193,15,16,20,163,246,219,80,179,229,45,81,227,53,168,89,178,20,206,72,65,64,133,172,65,8,104,119,126,145,146,84,162,118,185,165,232,178,16,96,81,144,136,238,47,194,94,74,216,93,136,93,194,165,75,168,7,231,2,120,137,144,45,44,133,59,155,8,217,176,148,210,252,220,210,223,228,41,252,36,119,19,24,136,169,232,38,21,158,202,77,163,160,130,215,224,69,209,89,56,255,197,192,83,154,31,227,227,126,185,189,12,47,43,240,2,156,115,18,4,106,148,91,68,37,255,124,136,215,68,77,1,22,130,132,2,255,130,132,210,252,111,211,63,56,231,35,131,255,11,156,127,221,186,117,91,20,242,21,204,87,198,11,142,20,165,168,41,48,162,34,106,87,206,207,239,199,20,130,127,240,244,189,172,17,252,131,121,1,150,133,120,1,18,138,38,80,210,127,129,138,87,100,141,152,159,143,239,43,184,128,8,22,208,194,59,243,255,182,120,241,170,172,169,60,94,240,201,11,
137,99,1,230,192,127,37,70,113,229,149,235,95,196,75,214,186,100,132,60,50,196,128,30,242,91,173,128,58,251,116,92,56,115,58,131,213,196,25,232,172,125,152,103,210,165,24,42,156,31,108,235,97,68,164,145,212,3,74,69,190,168,187,69,207,174,88,116,153,149,110,22,10,47,79,35,90,120,2,161,171,133,155,149,158,76,151,7,176,183,44,38,96,144,5,205,136,52,2,58,21,154,217,85,203,91,96,65,228,144,220,50,132,100,56,9,16,107,171,176,207,183,5,16,97,182,165,249,251,194,248,53,53,110,214,149,243,23,204,178,60,128,114,183,44,165,81,144,143,110,25,165,149,138,112,142,146,65,190,2,22,203,176,30,191,6,28,231,62,33,68,80,32,94,144,80,226,159,203,159,35,195,235,2,40,206,235,105,132,112,14,110,89,240,9,72,1,34,120,167,197,148,238,246,156,132,179,5,88,194,205,149,201,180,16,1,39,174,0,107,21,252,235,202,111,185,80,176,31,225,211,229,65,179,224,144,229,139,169,10,88,0,255,96,65,136,224,149,243,23,228,255,90,88,40,2,130,110,2,188,16,7,206,33,5,144,251,78,252,191,13,22,64,28,72,208,19,168,66,64,121,121,49,81,128,69,17,22,48,51,
68,80,6,139,239,144,52,112,21,115,100,224,252,151,81,254,110,139,105,152,61,244,207,193,153,231,10,92,75,186,9,64,10,156,255,211,88,184,241,76,142,78,227,0,132,158,206,112,118,74,171,42,228,10,101,11,43,113,127,201,242,56,155,98,64,177,155,240,214,218,91,1,79,42,199,40,30,233,88,3,70,223,117,59,170,204,195,42,232,40,205,242,210,5,130,71,78,232,251,236,241,253,168,212,20,234,104,133,29,6,78,244,15,160,169,4,98,21,216,5,253,129,177,162,12,245,163,227,47,9,160,164,169,10,239,68,115,130,174,67,161,229,134,178,123,96,151,101,32,38,198,30,228,73,106,59,146,84,164,170,220,10,168,59,86,176,74,188,63,68,124,197,39,209,252,157,24,20,145,189,88,252,233,196,87,122,88,194,9,253,91,29,130,248,137,86,25,114,160,211,49,189,176,5,223,244,139,255,27,91,79,97,197,215,209,218,134,79,179,248,6,138,163,246,140,73,207,76,91,103,241,189,230,45,176,12,112,128,229,248,240,96,172,128,40,221,69,124,130,68,65,143,240,207,2,159,112,62,206,170,83,5,119,133,146,5,52,130,48,59,216,58,97,208,177,66,142,113,22,203,28,237,141,43,157,16,
247,74,206,181,78,5,119,212,50,42,202,243,135,239,7,42,78,197,110,10,43,130,61,188,180,117,162,144,197,232,190,0,66,244,136,37,36,172,211,34,194,53,226,106,101,46,232,44,209,82,88,239,240,234,224,43,215,59,175,144,8,196,1,114,132,68,121,132,131,171,112,137,64,174,28,58,132,68,116,232,40,3,77,177,216,169,204,104,185,222,75,84,224,102,190,2,229,1,172,144,209,96,224,50,137,112,42,184,80,160,36,206,98,41,163,3,33,92,168,197,189,184,194,218,143,203,69,14,113,142,117,213,8,36,135,25,150,180,195,97,182,178,26,84,70,139,190,20,22,58,226,211,9,66,48,16,55,99,97,35,160,21,145,174,50,140,114,3,41,208,130,91,10,18,121,155,141,136,120,94,201,209,174,68,132,117,240,96,86,98,26,132,148,81,241,110,18,17,130,208,243,25,104,167,16,210,91,133,12,203,108,4,99,241,216,82,153,233,150,73,4,84,128,99,200,69,167,69,55,179,178,124,147,223,207,133,194,37,14,246,185,118,126,28,27,113,114,120,208,149,80,76,111,132,165,20,194,187,208,46,215,139,161,117,65,95,19,155,58,227,72,89,241,195,76,34,212,22,241,74,88,146,112,31,114,166,168,
189,143,67,131,48,25,225,71,157,113,46,32,17,243,116,135,42,136,9,204,160,158,14,97,113,73,117,102,10,32,220,73,103,78,71,120,54,92,12,127,5,185,137,240,39,46,109,79,65,116,37,186,169,29,119,11,209,113,101,250,146,133,226,59,196,84,166,204,87,152,148,192,222,10,243,230,78,166,231,7,93,2,89,117,97,139,81,116,195,126,85,126,184,75,136,16,160,144,94,193,201,244,251,203,212,136,147,194,170,202,160,226,21,176,3,171,214,197,5,219,42,217,38,52,241,86,39,43,19,138,230,7,236,64,28,37,147,42,166,203,111,114,178,215,74,68,248,25,7,98,112,84,52,137,18,248,9,228,41,203,120,43,168,16,128,179,75,133,126,127,153,68,4,230,20,92,29,26,227,128,84,48,35,1,59,248,74,228,9,200,155,39,10,66,41,57,25,206,181,234,119,188,30,118,42,105,17,30,6,161,148,132,90,233,240,5,237,148,23,97,95,237,100,176,145,215,75,164,224,234,229,57,116,5,21,220,18,121,92,42,216,136,96,90,120,201,46,248,189,108,35,144,200,75,225,64,148,156,184,117,136,136,32,128,24,3,21,243,233,18,16,131,80,65,14,119,240,221,245,192,46,4,130,138,226,146,130,187,164,
14,196,2,182,74,64,204,105,121,73,34,175,0,226,55,74,132,35,223,203,165,184,114,216,209,205,20,66,41,129,159,32,164,100,169,175,128,26,128,12,55,214,66,91,136,16,159,238,53,58,28,235,3,193,58,116,175,41,11,147,192,148,242,120,45,118,240,10,193,174,16,122,244,63,58,255,60,45,41,229,106,252,64,64,165,110,145,250,117,69,47,208,143,94,202,250,42,70,44,158,131,25,191,165,3,161,64,65,89,202,87,65,71,33,209,170,252,174,50,91,124,87,106,126,148,12,182,192,229,75,228,114,193,232,190,251,30,125,124,239,44,27,125,78,39,101,14,23,27,131,162,21,7,71,245,11,14,233,127,246,239,254,217,109,88,166,127,95,234,237,28,91,189,190,124,169,241,234,242,121,109,232,31,163,183,243,230,255,184,200,254,49,239,163,63,175,213,240,247,5,182,241,7,17,47,136,70,122,147,197,248,43,53,150,182,172,52,137,95,57,78,63,48,255,169,58,186,109,83,212,67,120,151,4,126,122,21,15,120,215,225,181,120,105,254,123,179,116,88,60,237,189,115,78,63,16,39,95,117,240,111,14,203,238,7,106,160,9,63,213,171,41,114,239,65,188,117,107,19,191,38,250,207,207,
254,53,158,227,235,248,200,142,135,201,238,223,223,254,228,79,189,153,252,232,95,227,151,77,240,214,214,165,91,54,60,233,55,182,41,5,54,64,64,198,252,215,238,203,118,60,131,85,191,106,255,100,137,63,75,55,49,105,199,47,159,224,217,44,82,119,26,255,20,191,36,139,38,251,210,227,3,180,89,98,124,2,63,211,114,109,115,181,49,172,13,254,5,24,191,255,175,110,177,191,16,15,96,94,40,61,64,160,243,141,78,237,255,253,252,200,90,241,173,85,107,249,91,127,230,246,60,108,71,69,250,155,153,221,255,4,182,143,227,155,191,62,231,22,255,217,250,95,11,255,217,157,154,89,138,83,91,71,150,47,109,52,166,33,114,229,47,249,204,255,211,18,251,75,49,179,86,207,167,46,62,251,169,191,48,43,255,247,93,177,209,162,204,71,183,175,74,6,211,223,83,3,196,223,23,24,32,95,160,254,47,249,251,137,170,196,139,178,240,114,162,210,155,137,240,90,162,67,120,27,150,120,15,86,3,222,128,37,222,125,85,122,27,17,30,124,237,114,240,215,92,245,137,183,91,13,136,183,74,250,197,123,38,245,215,13,225,113,12,188,107,8,79,103,36,197,195,26,120,46,23,207,110,
76,139,183,89,226,25,94,60,217,129,231,59,240,132,47,30,247,192,99,191,120,13,21,94,64,117,89,60,18,82,122,167,144,254,66,161,123,218,249,191,231,43,252,26,47,116,188,43,13,250,127,139,210,168,154,92,191,124,117,25,189,197,225,127,194,95,87,249,175,187,217,63,225,13,243,170,230,88,72,155,22,219,120,199,252,135,194,254,200,98,248,252,255,58,89,246,250,176,237,250,255,172,193,111,106,160,142,6,85,124,70,196,231,136,248,76,138,207,180,248,156,20,159,179,226,243,140,248,204,137,207,243,101,159,103,197,255,231,196,103,86,124,166,196,167,62,90,72,252,159,207,165,125,115,172,33,42,142,226,226,115,76,124,150,207,51,35,190,89,16,159,75,226,115,69,124,174,138,207,117,124,150,73,225,122,81,10,230,145,229,107,87,87,181,200,63,133,12,76,255,166,139,253,83,110,16,183,181,83,11,247,10,239,236,132,45,146,120,131,218,227,191,168,29,73,21,141,49,245,185,251,239,247,117,105,169,72,227,231,87,251,232,80,132,182,164,14,254,66,166,201,72,251,196,72,235,213,244,137,135,103,71,248,59,15,241,59,86,85,250,67,201,187,174,208,80,
156,123,95,242,206,181,245,115,155,141,171,151,87,86,241,75,51,43,119,240,148,114,241,197,162,116,180,120,85,205,228,218,198,101,252,196,71,20,191,231,181,122,105,189,236,146,221,129,46,232,231,212,141,43,151,214,175,172,118,93,217,224,87,253,127,88,232,190,4);


programfile__We_Will_Rock_You_mid:array[0..10218] of byte=(
77,84,104,100,0,0,0,6,0,1,0,8,0,120,77,84,114,107,0,0,0,32,0,255,88,4,4,2,24,8,0,255,89,2,1,0,0,255,81,3,11,77,133,248,0,255,89,2,2,0,0,255,47,0,77,84,114,107,0,0,5,218,0,255,33,1,0,0,255,3,5,100,114,117,109,115,0,201,0,0,153,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,
36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,
100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,
0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,
60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,0,255,47,0,77,84,114,107,0,0,5,222,0,255,33,1,0,0,255,3,9,100,114,117,109,32,101,99,104,111,0,201,0,4,153,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,
36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,
39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,
100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,
0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,0,255,47,0,77,84,114,107,0,0,5,223,0,255,33,1,0,0,255,3,10,100,114,117,109,32,101,99,104,111,50,0,201,0,8,153,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,
100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,
0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,
60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,
36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,
36,0,0,39,100,60,39,0,0,255,47,0,77,84,114,107,0,0,4,133,0,255,33,1,0,0,255,3,10,108,101,97,100,32,118,111,99,97,108,0,192,80,143,0,144,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,60,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,81,100,60,81,0,0,79,100,60,79,0,0,79,100,30,79,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,76,100,57,74,100,3,76,0,27,74,0,1,76,100,60,76,0,32,69,100,30,69,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,60,74,100,30,74,0,0,74,100,30,74,0,0,74,100,60,74,0,0,74,100,60,74,0,0,69,100,30,69,0,0,71,100,30,71,0,0,69,100,30,69,0,0,67,100,30,67,0,0,64,100,30,64,0,0,64,100,90,64,0,0,71,100,30,71,0,0,74,100,30,74,0,0,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,60,76,0,130,104,79,100,120,79,0,0,
78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,60,76,0,130,104,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,76,100,60,76,0,0,76,100,30,76,0,0,81,100,60,81,0,0,79,100,60,79,0,0,79,100,30,79,0,0,71,100,30,71,0,0,74,100,60,74,0,0,76,100,30,76,0,0,76,100,60,76,0,0,74,100,30,74,0,0,76,100,60,76,0,30,64,100,30,64,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,60,74,100,30,74,0,0,74,100,30,74,0,0,74,100,60,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,69,100,30,69,0,0,71,100,30,71,0,0,69,100,30,69,0,0,67,100,30,67,0,0,64,100,30,64,0,0,64,100,90,64,0,60,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,60,76,0,130,104,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,
100,60,76,0,130,104,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,81,100,60,81,0,0,79,100,60,79,0,0,79,100,30,79,0,0,71,100,30,71,0,0,74,100,60,74,0,0,76,100,30,76,0,0,76,100,60,76,0,0,76,100,30,76,0,0,76,100,60,76,0,60,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,0,74,100,60,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,69,100,30,69,0,0,71,100,30,71,0,0,69,100,30,69,0,0,67,100,30,67,0,0,64,100,60,64,0,0,76,100,60,76,0,60,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,71,100,60,71,0,129,82,71,100,30,71,0,0,74,100,60,74,0,0,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,
0,0,76,100,60,76,0,129,112,67,100,30,67,0,0,69,100,30,69,0,0,71,100,30,71,0,0,74,100,30,74,0,0,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,60,76,0,129,112,71,100,30,71,0,0,74,100,90,74,0,0,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,60,76,0,0,255,47,0,77,84,114,107,0,0,2,102,0,255,33,1,0,0,255,3,13,98,97,99,107,117,112,32,118,111,99,97,108,115,0,193,81,158,0,145,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,130,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,145,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,
0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,130,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,145,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,130,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,130,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,130,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,
0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,0,255,47,0,77,84,114,107,0,0,8,107,0,255,33,1,1,0,255,3,11,76,101,97,100,32,71,117,105,116,97,114,0,207,84,229,2,191,7,2,5,7,3,15,7,4,10,159,64,100,0,191,7,5,15,7,6,10,7,7,10,7,8,15,7,9,10,7,10,15,7,11,10,7,12,10,7,13,15,7,14,10,7,15,15,7,16,10,7,17,10,7,18,15,7,19,10,7,20,15,7,21,10,7,22,10,7,23,15,7,24,10,7,25,15,7,26,10,7,27,10,7,28,15,7,29,10,7,30,15,7,31,10,7,32,10,7,33,15,7,34,10,7,35,10,7,36,15,7,37,10,7,38,15,7,39,10,7,40,10,7,41,15,7,42,10,7,43,15,7,44,10,7,45,10,7,46,15,7,47,10,7,48,15,7,49,10,7,50,10,7,51,15,7,52,10,7,53,15,7,54,10,7,55,10,7,56,15,7,57,10,7,58,15,7,59,10,7,60,10,7,61,15,7,62,10,7,63,10,7,64,15,7,65,10,7,66,15,7,67,10,7,68,10,7,69,15,7,70,10,7,71,15,7,72,10,7,73,10,7,74,15,7,75,10,7,76,15,7,77,10,7,78,10,7,79,15,7,80,10,7,81,15,7,82,10,7,83,10,7,84,15,7,85,10,7,86,15,7,87,10,7,88,10,7,89,15,7,90,10,7,91,15,7,92,10,7,93,10,7,94,15,7,95,10,7,96,10,7,97,15,7,98,10,7,99,15,7,100,10,7,101,
10,7,102,15,7,103,10,7,104,15,7,105,10,7,106,10,7,107,15,7,108,10,7,109,15,7,110,10,7,111,10,7,112,15,7,113,10,7,114,15,7,115,10,7,116,10,7,117,15,7,118,10,7,119,15,7,120,10,7,121,10,7,122,15,7,123,10,7,124,10,7,125,131,86,159,64,0,0,48,100,0,55,100,0,60,100,0,64,100,15,64,0,0,48,0,0,55,0,0,60,0,0,64,100,0,60,100,0,55,100,0,48,100,131,36,48,0,0,64,0,0,60,0,0,55,0,0,61,100,0,45,100,0,52,100,0,57,100,15,57,0,0,61,0,0,45,0,0,52,0,15,45,100,0,52,100,0,57,100,0,61,100,15,61,0,0,45,0,0,52,0,0,57,0,15,45,100,0,52,100,0,57,100,0,61,100,60,61,0,0,45,0,0,52,0,0,57,0,0,43,100,0,50,100,0,55,100,0,59,100,30,59,0,0,43,0,0,50,0,0,55,0,0,45,100,0,52,100,0,57,100,0,61,100,60,61,0,0,45,0,0,52,0,0,57,0,0,52,100,0,57,100,0,61,100,15,61,0,0,57,0,0,52,0,15,52,100,0,57,100,0,61,100,15,61,0,0,57,0,0,52,0,0,41,100,15,41,0,15,57,100,0,61,100,0,52,100,0,45,100,15,45,0,0,57,0,0,61,0,0,52,0,0,45,100,0,52,100,0,57,100,0,61,100,80,61,0,0,45,0,0,52,0,0,57,0,0,45,100,0,52,100,0,57,100,0,61,100,40,61,0,0,45,0,0,52,0,0,57,0,0,43,100,0,
50,100,0,55,100,0,59,100,30,59,0,0,43,0,0,50,0,0,55,0,0,45,100,0,52,100,0,57,100,0,61,100,30,61,0,0,45,0,0,52,0,0,57,0,0,61,100,0,57,100,0,52,100,0,45,100,30,45,0,0,61,0,0,57,0,0,52,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,60,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,30,64,0,0,73,0,0,69,0,0,74,100,0,69,100,0,66,100,30,66,0,0,45,0,0,74,0,0,69,0,0,66,100,0,69,100,0,74,100,0,45,100,60,74,0,0,66,0,0,69,0,0,74,100,0,69,100,0,66,100,30,66,0,0,45,0,0,74,0,0,69,0,0,73,100,0,69,100,0,64,100,0,45,100,129,82,45,0,0,73,0,0,69,0,0,64,0,30,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,69,100,0,73,100,0,64,100,30,64,0,0,73,0,0,66,100,0,74,100,30,74,0,0,66,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,30,73,0,0,64,0,0,69,0,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,64,100,0,73,100,30,73,0,0,64,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,60,73,0,0,64,0,0,69,0,0,73,100,0,
69,100,0,64,100,30,64,0,0,69,0,0,73,0,0,73,100,90,73,0,0,81,100,0,64,100,30,64,0,0,81,0,0,79,100,0,64,100,30,64,0,0,79,0,0,64,100,30,64,0,0,45,100,0,78,100,30,78,0,0,64,100,30,64,0,0,76,100,30,76,0,0,64,100,30,64,0,0,45,0,0,45,100,0,74,100,0,69,100,0,66,100,30,66,0,0,69,0,0,74,0,0,64,100,0,69,100,0,73,100,30,73,0,0,69,0,0,64,0,0,66,100,30,66,0,0,66,100,0,69,100,0,74,100,129,52,74,0,0,69,0,0,66,0,0,73,100,30,73,0,0,71,100,30,71,0,0,69,100,0,64,100,60,64,0,0,69,0,0,64,100,30,64,0,0,76,100,0,69,100,30,69,0,0,76,0,0,69,100,30,69,0,0,69,100,0,76,100,30,76,0,0,73,100,30,45,0,0,45,100,30,73,0,0,69,0,0,76,100,30,76,0,0,45,0,0,78,100,30,78,0,0,78,100,30,78,0,0,76,100,30,76,0,0,73,100,30,73,0,0,73,100,30,73,0,0,71,100,30,71,0,0,69,100,30,69,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,69,100,0,74,100,0,66,100,0,45,100,30,66,0,0,74,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,69,100,0,66,100,0,74,100,0,45,100,30,74,0,0,66,0,0,64,100,0,73,100,30,73,0,0,45,0,0,69,0,0,64,0,0,73,100,0,
69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,64,100,0,69,100,0,73,100,0,45,100,129,52,45,0,0,64,0,0,69,0,0,73,0,30,73,100,0,69,100,0,64,100,0,45,100,10,45,0,0,73,0,0,69,0,0,64,0,20,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,60,64,0,0,73,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,30,73,0,0,64,0,0,69,0,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,90,45,0,0,73,0,0,69,0,0,64,0,0,74,100,0,69,100,0,66,100,0,45,100,60,45,0,0,74,0,0,69,0,0,66,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,60,64,100,0,69,100,0,73,100,0,45,100,15,45,0,0,64,0,0,69,0,0,73,0,0,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,45,100,0,73,100,0,69,100,0,64,100,60,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,
69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,64,100,30,64,0,0,69,0,0,45,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,74,100,0,69,100,0,66,100,60,66,0,0,45,0,0,74,0,0,69,0,0,45,100,0,73,100,0,64,100,0,69,100,60,69,0,0,45,0,0,73,0,0,64,0,60,45,100,0,73,100,0,69,100,0,64,100,60,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,64,100,30,64,0,0,69,0,0,45,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,74,100,0,69,100,0,66,100,60,66,0,0,45,0,0,74,0,0,69,0,0,73,120,0,69,120,0,64,120,0,45,120,60,45,0,0,73,0,0,69,0,0,64,0,0,255,47,0,77,84,114,107,0,0,6,144,0,255,33,1,0,0,255,3,11,76,101,97,100,32,71,117,
105,116,97,114,0,206,29,0,190,7,86,248,0,158,45,100,0,52,100,0,57,100,0,61,100,60,61,0,0,45,0,0,52,0,0,57,0,0,43,100,0,50,100,0,55,100,0,59,100,30,59,0,0,43,0,0,50,0,0,55,0,0,45,100,0,52,100,0,57,100,0,61,100,60,61,0,0,45,0,0,52,0,0,57,0,0,52,100,0,57,100,0,61,100,15,61,0,0,57,0,0,52,0,15,52,100,0,57,100,0,61,100,15,61,0,0,57,0,0,52,0,0,41,100,15,41,0,15,57,100,0,61,100,0,52,100,0,45,100,15,45,0,0,57,0,0,61,0,0,52,0,0,45,100,0,52,100,0,57,100,0,61,100,80,61,0,0,45,0,0,52,0,0,57,0,0,45,100,0,52,100,0,57,100,0,61,100,40,61,0,0,45,0,0,52,0,0,57,0,0,43,100,0,50,100,0,55,100,0,59,100,30,59,0,0,43,0,0,50,0,0,55,0,0,45,100,0,52,100,0,57,100,0,61,100,30,61,0,0,45,0,0,52,0,0,57,0,0,61,100,0,57,100,0,52,100,0,45,100,30,45,0,0,61,0,0,57,0,0,52,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,60,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,30,64,0,0,73,0,0,69,0,0,74,100,0,69,100,0,66,100,30,66,0,0,45,0,0,74,0,0,69,0,0,66,100,0,69,100,0,74,100,
0,45,100,60,74,0,0,66,0,0,69,0,0,74,100,0,69,100,0,66,100,30,66,0,0,45,0,0,74,0,0,69,0,0,73,100,0,69,100,0,64,100,0,45,100,129,82,45,0,0,73,0,0,69,0,0,64,0,30,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,69,100,0,73,100,0,64,100,30,64,0,0,73,0,0,66,100,0,74,100,30,74,0,0,66,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,30,73,0,0,64,0,0,69,0,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,64,100,0,73,100,30,73,0,0,64,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,60,73,0,0,64,0,0,69,0,0,73,100,0,69,100,0,64,100,30,64,0,0,69,0,0,73,0,0,73,100,90,73,0,0,81,100,0,64,100,30,64,0,0,81,0,0,79,100,0,64,100,30,64,0,0,79,0,0,64,100,30,64,0,0,45,100,0,78,100,30,78,0,0,64,100,30,64,0,0,76,100,30,76,0,0,64,100,30,64,0,0,45,0,0,45,100,0,74,100,0,69,100,0,66,100,30,66,0,0,69,0,0,74,0,0,64,100,0,69,100,0,73,100,30,73,0,0,69,0,0,64,0,0,66,100,30,66,0,0,66,100,0,69,100,0,74,100,129,52,74,0,0,69,0,0,66,0,0,73,100,30,73,0,0,71,100,30,71,0,0,69,100,0,64,100,60,
64,0,0,69,0,0,64,100,30,64,0,0,76,100,0,69,100,30,69,0,0,76,0,0,69,100,30,69,0,0,69,100,0,76,100,30,76,0,0,73,100,30,45,0,0,45,100,30,73,0,0,69,0,0,76,100,30,76,0,0,45,0,0,78,100,30,78,0,0,78,100,30,78,0,0,76,100,30,76,0,0,73,100,30,73,0,0,73,100,30,73,0,0,71,100,30,71,0,0,69,100,30,69,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,69,100,0,74,100,0,66,100,0,45,100,30,66,0,0,74,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,69,100,0,66,100,0,74,100,0,45,100,30,74,0,0,66,0,0,64,100,0,73,100,30,73,0,0,45,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,64,100,0,69,100,0,73,100,0,45,100,129,52,45,0,0,64,0,0,69,0,0,73,0,30,73,100,0,69,100,0,64,100,0,45,100,10,45,0,0,73,0,0,69,0,0,64,0,20,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,60,64,0,0,73,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,30,73,0,0,64,0,0,
69,0,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,90,45,0,0,73,0,0,69,0,0,64,0,0,74,100,0,69,100,0,66,100,0,45,100,60,45,0,0,74,0,0,69,0,0,66,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,60,64,100,0,69,100,0,73,100,0,45,100,15,45,0,0,64,0,0,69,0,0,73,0,0,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,45,100,0,73,100,0,69,100,0,64,100,60,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,64,100,30,64,0,0,69,0,0,45,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,74,100,0,69,100,0,66,100,60,66,0,0,45,0,0,74,0,0,69,0,0,45,100,0,73,100,0,64,100,0,69,100,60,69,0,0,45,0,0,73,0,0,64,0,60,45,100,0,73,100,0,69,100,
0,64,100,60,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,64,100,30,64,0,0,69,0,0,45,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,74,100,0,69,100,0,66,100,60,66,0,0,45,0,0,74,0,0,69,0,0,73,120,0,69,120,0,64,120,0,45,120,60,45,0,0,73,0,0,69,0,0,64,0,0,255,47,0);


programfile__Roses_Are_Red_mid:array[0..4293] of byte=(
120,1,237,93,255,83,28,71,118,239,217,111,31,52,8,14,228,21,66,32,181,214,24,208,24,115,18,32,132,96,89,177,195,205,106,133,64,8,201,230,194,249,100,89,194,8,27,69,54,178,132,49,194,146,227,27,129,132,192,138,101,114,88,62,40,219,85,247,195,221,47,169,84,157,207,178,239,206,167,170,220,151,92,146,203,151,74,93,126,76,85,254,128,252,150,202,111,249,73,121,61,187,179,187,44,140,4,130,205,174,161,171,166,230,189,126,221,211,253,250,245,235,79,247,204,206,206,235,238,29,58,207,24,243,49,133,21,179,255,238,238,189,114,145,82,79,177,135,223,243,120,92,165,121,236,225,41,183,111,166,156,61,220,207,98,89,5,207,178,135,110,68,174,140,190,49,18,168,103,127,220,201,126,165,234,94,198,92,1,151,23,204,123,154,185,207,48,215,32,115,159,103,46,159,203,61,80,234,122,69,115,251,46,187,6,202,220,175,104,46,223,118,247,192,110,75,114,241,63,190,15,229,36,92,195,112,155,37,240,12,195,107,186,224,59,15,16,201,35,201,22,6,181,1,249,42,182,106,40,224,40,212,240,173,147,40,98,40,230,216,198,241,20,135,159,99,59,71,9,199,14,
13,165,126,236,212,80,198,81,206,177,139,99,55,7,231,216,195,17,224,120,154,163,66,195,51,26,42,253,168,210,80,237,199,222,16,52,142,103,57,106,56,158,227,168,53,183,226,219,231,177,239,42,246,95,69,29,181,92,239,71,3,201,14,112,52,170,56,56,140,166,97,28,50,27,209,28,66,139,138,160,134,86,63,66,13,56,172,162,45,132,48,131,206,209,206,241,29,14,131,35,210,128,35,126,68,53,28,85,209,161,225,24,71,39,71,23,199,241,16,186,57,78,104,232,241,227,164,134,83,126,60,207,241,2,71,175,134,239,114,252,25,71,31,199,247,56,94,228,248,62,199,105,142,151,56,206,112,188,172,225,172,31,231,56,250,57,94,209,48,192,113,158,212,27,84,241,170,31,175,113,12,113,92,8,225,207,57,46,106,120,157,227,13,142,97,142,75,28,111,114,92,230,184,162,97,196,143,183,56,70,57,222,230,24,211,112,149,99,156,227,29,142,107,28,215,57,222,229,248,11,117,190,242,93,255,175,240,222,192,116,229,187,183,142,81,98,140,152,241,13,74,111,183,108,208,142,109,212,1,91,109,191,228,0,111,112,7,151,3,44,7,120,99,175,81,171,133,188,92,45,255,193,150,184,
167,254,218,102,114,85,211,181,234,37,49,105,131,99,210,114,14,210,74,219,100,133,250,157,74,15,199,237,32,228,98,27,157,114,195,244,111,201,27,166,6,243,110,243,124,125,83,235,116,125,147,121,80,50,210,8,210,19,86,49,11,110,143,174,162,240,230,153,95,19,85,210,44,18,73,36,146,60,201,44,144,144,34,183,34,107,217,143,221,248,246,252,94,125,108,122,175,126,227,66,78,48,230,229,39,153,5,155,103,173,148,61,149,243,125,45,243,61,121,91,87,242,115,186,173,243,158,188,208,63,124,137,253,70,97,63,83,203,93,140,185,3,204,139,83,222,211,154,235,204,117,247,32,115,157,103,110,159,235,222,222,15,123,116,86,167,143,253,160,71,87,62,236,32,218,65,180,139,104,23,209,158,184,188,155,104,119,74,190,45,23,229,235,116,38,46,57,169,179,90,74,157,76,41,101,215,114,146,228,181,58,19,89,221,58,219,23,175,43,74,52,74,162,78,162,157,86,214,216,15,246,233,76,52,211,21,211,72,104,96,80,174,65,52,93,51,251,42,59,223,110,75,164,73,35,113,9,213,34,52,18,181,68,136,70,210,106,33,141,68,214,202,52,202,9,27,93,221,103,117,129,145,50,
150,133,166,194,52,88,137,148,176,145,144,91,3,49,113,86,100,217,41,97,100,22,21,182,37,235,83,86,74,202,188,63,254,97,72,216,139,133,245,86,178,52,145,80,72,63,76,118,39,142,133,108,25,113,227,100,69,91,102,115,214,181,84,46,66,229,168,22,139,91,174,156,121,48,94,97,208,174,48,20,76,52,146,144,177,32,53,18,212,89,155,206,218,169,156,205,173,84,70,141,200,158,136,113,178,71,34,103,198,36,238,33,22,177,188,139,56,82,82,120,141,205,89,90,183,39,60,201,226,44,25,185,154,112,6,171,56,113,150,119,81,66,200,40,203,226,110,143,202,129,39,75,228,224,192,75,88,201,165,201,248,191,18,32,5,98,200,121,66,107,124,166,150,95,9,245,43,220,193,200,221,138,181,244,203,201,152,193,201,40,151,223,92,90,126,55,208,140,191,45,119,18,114,39,17,127,90,144,169,157,132,4,47,9,94,153,219,167,74,239,202,37,239,74,62,185,246,252,39,61,185,222,210,113,225,181,161,192,235,131,175,190,197,126,123,128,125,174,86,149,39,159,94,95,115,157,185,154,120,122,253,193,137,217,67,6,235,48,152,97,176,176,193,66,134,255,115,108,245,139,255,101,
248,25,182,49,20,181,160,172,24,187,138,193,43,80,193,16,216,134,202,110,104,221,168,173,192,190,98,212,21,163,129,161,238,25,52,250,197,209,204,208,164,161,217,143,32,67,115,19,130,197,8,49,113,110,99,8,209,249,198,83,102,74,67,108,54,37,49,21,94,148,117,200,80,102,155,13,22,137,235,52,113,214,76,73,41,179,81,131,181,27,172,205,96,65,131,178,82,82,74,90,103,168,218,197,189,219,28,213,246,26,247,195,102,175,241,147,246,217,80,132,133,35,204,136,176,174,200,148,222,28,17,134,140,176,20,161,50,219,22,97,193,8,235,20,89,54,171,204,210,147,111,107,122,147,63,76,233,102,34,149,144,83,97,91,120,99,40,20,25,159,13,149,178,112,233,251,123,76,139,42,179,193,82,214,86,74,133,44,170,100,44,247,129,50,219,123,224,211,247,204,222,3,9,230,51,106,109,205,125,166,142,228,66,247,126,161,124,142,195,26,130,28,205,154,248,187,18,253,119,169,142,254,216,68,127,117,82,81,73,127,123,82,17,240,139,255,66,149,251,81,166,97,135,249,170,248,171,84,25,159,237,221,78,147,184,252,211,139,102,239,118,178,203,118,97,32,139,89,36,189,
203,72,122,151,101,108,108,226,163,78,238,67,62,65,173,144,55,44,231,28,98,8,21,91,49,69,36,132,186,22,179,84,154,4,185,170,147,4,114,158,239,244,143,140,176,223,85,179,159,171,122,99,28,223,94,240,158,126,199,117,230,90,2,223,254,52,250,87,149,122,235,141,74,253,112,156,42,105,116,237,242,0,213,31,160,250,99,84,73,163,75,229,21,84,190,130,202,199,168,146,70,151,202,165,254,98,252,236,113,91,58,94,223,108,251,79,181,75,7,181,38,232,70,29,96,27,16,150,2,129,147,227,74,128,120,244,132,95,45,32,58,217,217,73,46,237,47,237,159,92,112,114,111,254,58,249,173,147,124,47,225,235,94,218,112,196,168,146,70,151,202,51,237,255,78,122,58,201,165,254,98,195,104,111,20,151,110,16,157,236,230,36,127,150,252,225,89,242,135,24,85,210,104,186,252,9,54,40,78,13,59,201,229,0,63,122,128,51,189,224,73,251,175,175,253,51,61,94,153,6,104,169,191,184,163,119,94,248,165,253,229,6,49,151,55,136,114,254,102,119,254,58,237,115,156,228,114,253,93,223,245,215,201,206,78,242,76,219,223,169,93,39,185,220,160,175,243,19,193,76,15,112,
166,1,87,234,191,177,1,66,250,207,163,23,236,204,250,255,63,59,255,244,176,218,129,113,42,239,132,244,78,114,121,135,33,239,48,114,249,14,195,201,111,157,228,153,157,192,171,159,191,78,122,58,201,165,254,114,1,94,203,124,148,254,35,253,39,119,253,39,249,94,85,254,223,196,222,171,26,184,200,126,127,154,125,161,246,119,199,223,171,138,122,79,95,118,157,97,137,247,170,110,220,124,233,135,161,43,133,95,96,171,138,34,47,252,30,248,189,40,241,162,76,197,46,15,184,138,10,47,170,25,42,189,208,10,81,203,80,227,197,62,134,90,58,111,65,131,138,70,31,26,11,208,228,67,144,14,32,228,19,7,189,53,74,239,139,182,81,146,222,26,245,161,109,242,21,232,12,58,160,23,88,7,196,139,164,148,108,243,162,141,46,160,162,177,107,232,236,69,19,189,114,106,93,70,47,164,54,210,123,168,62,212,245,76,132,174,40,63,12,230,188,150,65,210,82,218,114,125,70,92,218,114,253,102,207,55,199,150,173,214,39,47,12,221,251,5,202,24,118,249,176,139,144,200,98,196,153,32,201,7,78,140,87,188,200,30,96,224,94,113,174,240,9,144,138,157,3,150,132,202,240,
124,4,74,80,177,3,149,91,5,120,85,107,168,121,6,53,249,2,185,106,75,176,239,105,212,121,81,71,216,82,132,134,18,52,122,45,32,35,44,171,64,211,110,52,229,11,216,105,46,70,112,7,66,133,2,178,218,1,3,56,226,198,17,143,56,31,45,196,177,82,28,43,68,151,27,93,30,116,21,163,171,4,221,64,143,27,61,192,169,237,120,33,31,223,5,250,60,120,177,20,167,11,113,86,69,63,208,239,22,231,1,21,3,192,96,190,8,17,240,154,138,11,30,92,112,227,34,29,192,27,42,46,1,151,11,48,2,140,184,49,226,193,136,207,58,19,111,37,71,221,16,135,7,163,245,19,182,169,204,251,18,116,214,107,153,249,230,76,20,185,24,174,207,50,35,55,22,235,183,204,8,91,218,168,36,1,124,197,0,158,220,180,239,120,64,155,246,188,23,250,199,2,125,253,99,131,236,239,78,177,251,234,158,87,147,127,248,162,63,68,188,147,216,184,127,100,204,133,142,155,151,38,67,199,149,185,240,241,177,201,48,209,118,162,237,68,13,145,97,44,102,198,44,65,148,74,68,173,140,88,218,190,34,44,174,160,211,229,213,84,106,95,108,80,165,162,53,59,109,171,211,38,42,165,211,170,42,181,43,123,188,
166,137,94,166,23,181,219,79,82,171,115,194,78,113,198,214,212,110,44,68,61,16,134,76,82,42,24,58,62,62,23,234,17,76,15,229,244,80,9,162,6,81,131,104,59,209,118,162,97,162,225,30,234,34,157,200,130,9,73,178,100,148,74,68,19,87,10,99,172,172,206,233,250,149,150,204,68,235,183,91,230,58,134,182,220,199,53,134,107,10,218,234,39,59,134,14,207,25,67,173,147,6,209,14,162,169,233,206,161,250,174,33,117,210,34,29,241,220,80,188,180,119,46,74,165,163,67,193,196,85,17,74,71,82,106,177,211,93,67,141,221,67,152,180,200,145,185,78,42,213,57,212,22,191,90,153,235,162,116,215,80,40,81,139,179,46,141,93,84,75,231,16,145,35,235,174,75,75,215,144,139,58,67,36,188,2,77,54,163,85,54,57,40,173,162,251,233,32,100,167,109,216,138,195,231,248,156,161,19,180,24,39,8,82,78,16,248,156,24,159,139,16,141,36,168,18,79,219,148,46,136,151,107,39,218,78,229,98,148,64,203,74,39,105,172,156,93,239,82,26,107,199,174,55,157,218,237,40,115,81,170,55,74,250,197,232,120,90,154,224,201,169,33,167,142,216,29,72,191,46,189,3,177,52,53,64,159,
181,156,140,232,233,26,62,62,109,156,72,152,54,193,8,27,167,219,66,192,246,57,42,17,58,71,75,193,57,90,10,136,26,68,13,162,237,68,219,137,134,137,134,207,9,48,22,37,195,9,73,178,100,148,74,68,19,87,174,170,78,187,49,39,106,43,97,211,152,50,180,128,101,79,235,100,191,13,161,132,48,149,173,125,204,16,174,185,232,57,243,205,251,214,195,65,5,186,219,122,44,72,139,141,11,109,10,66,121,8,22,162,49,31,13,10,234,232,80,81,183,5,181,10,106,93,168,205,135,150,135,74,15,42,92,168,0,2,30,236,162,27,126,31,202,60,40,85,172,195,133,82,122,144,73,135,2,191,27,219,20,17,147,112,155,11,69,116,16,79,7,49,213,52,20,94,106,92,44,41,114,161,19,107,111,234,162,43,23,186,229,182,34,169,86,89,5,210,219,219,204,244,141,106,18,241,5,96,172,114,163,108,95,108,87,110,167,211,150,15,129,50,98,219,155,251,247,9,114,161,35,128,180,86,238,228,10,189,120,193,163,177,148,11,93,124,181,149,11,157,88,235,86,179,208,153,141,217,220,13,144,239,218,171,191,19,181,135,212,166,25,219,195,16,210,8,72,20,207,44,210,33,217,70,207,36,181,160,121,
245,207,14,30,40,114,95,177,204,205,124,234,10,154,254,24,33,61,189,25,31,43,152,135,228,36,141,225,131,216,184,172,236,230,37,121,95,145,211,55,26,18,127,237,129,218,112,67,155,124,134,159,247,59,241,226,205,243,131,195,255,197,254,224,98,95,170,47,190,39,158,223,43,86,184,17,250,96,219,72,226,249,189,249,65,197,71,241,111,115,233,173,55,109,206,60,184,86,97,196,14,77,113,211,230,168,78,155,109,77,21,82,112,9,10,44,65,225,3,110,218,28,149,164,48,2,113,161,205,173,93,37,187,115,139,186,185,172,74,203,10,109,237,164,158,226,75,171,78,195,177,172,233,150,21,174,212,158,95,174,217,23,229,192,139,217,37,39,146,229,181,203,250,226,178,194,149,58,232,23,71,62,170,188,110,94,186,89,121,93,33,102,140,232,228,139,143,151,220,217,249,248,50,127,58,182,86,24,150,174,47,93,63,22,35,202,105,249,93,139,235,255,58,99,158,159,220,201,40,207,209,78,198,219,215,255,246,224,8,251,251,119,216,87,170,110,150,198,247,50,244,113,70,150,250,18,241,173,226,123,71,116,255,87,226,125,221,58,6,205,58,170,233,75,178,137,164,197,
139,47,204,82,150,197,83,153,26,139,167,175,96,214,20,163,177,56,126,110,124,6,181,244,81,90,191,245,146,49,149,108,18,149,208,7,106,169,0,125,163,182,110,155,85,103,149,56,55,80,110,234,81,33,202,208,209,68,103,122,109,216,42,25,231,253,104,74,59,10,208,92,142,230,50,4,203,17,42,191,215,161,171,95,65,247,67,159,170,184,69,223,11,165,180,121,137,152,137,126,193,189,105,232,55,123,40,165,220,59,42,196,71,244,233,58,10,169,118,239,56,69,15,187,117,84,159,210,143,235,73,147,121,126,66,38,203,63,58,122,225,173,254,43,177,143,246,254,195,78,246,11,245,156,89,31,127,137,99,216,138,57,151,124,251,218,252,227,155,31,91,193,31,90,167,98,49,32,30,153,162,133,132,66,147,77,89,100,124,81,73,243,224,162,228,226,204,241,143,173,248,97,173,83,22,121,84,234,49,213,44,214,84,106,67,187,49,135,113,203,188,109,190,124,244,136,203,161,114,30,156,77,109,155,20,176,250,41,129,213,214,56,88,93,161,207,140,191,197,254,113,39,251,165,90,101,118,198,209,170,111,9,90,245,253,40,102,188,219,22,25,127,100,42,54,7,110,199,208,106,
81,73,243,224,162,100,122,53,49,180,186,29,67,171,31,57,167,30,83,205,98,77,165,54,98,66,44,63,110,153,183,205,151,143,30,113,57,84,206,131,179,169,109,147,130,86,127,32,180,82,173,104,8,49,172,250,167,3,236,107,218,89,13,196,177,170,50,13,171,254,210,183,176,56,98,128,255,235,12,198,67,152,73,9,129,192,22,82,18,83,225,69,89,20,15,97,33,37,2,194,196,217,153,148,148,178,144,18,1,129,178,82,82,74,90,103,168,218,197,189,219,28,213,138,120,8,51,34,30,194,194,146,216,0,51,105,241,16,22,236,32,8,100,72,155,85,22,236,104,0,86,60,132,153,68,42,33,167,194,182,208,138,135,176,16,143,135,48,19,251,228,253,66,60,30,194,76,44,30,66,198,114,31,40,11,34,30,194,12,197,67,176,153,207,148,117,232,243,251,123,114,162,123,63,238,251,26,135,56,158,227,216,219,128,42,191,21,3,193,143,167,205,0,2,81,241,151,211,221,42,202,135,81,102,190,132,242,57,109,65,4,62,152,161,192,7,203,50,119,25,101,221,101,25,27,9,178,186,136,136,49,165,11,15,32,158,28,100,57,87,16,3,70,1,15,102,40,224,129,51,147,4,179,3,79,17,152,33,114,101,244,141,
145,192,1,243,3,125,190,70,111,157,174,209,21,73,165,29,164,31,200,121,32,113,64,226,128,196,1,137,3,18,7,36,14,72,28,200,56,14,76,181,203,137,38,39,154,156,104,25,159,104,242,6,87,222,232,203,7,29,242,65,143,196,1,137,3,18,7,36,14,72,28,144,56,32,113,64,226,128,188,1,151,15,32,228,3,8,249,0,66,62,128,144,56,32,113,64,226,128,196,1,137,3,18,7,36,14,72,28,144,56,32,113,64,226,128,196,1,137,3,18,7,36,14,72,28,144,56,32,113,96,3,226,64,242,175,49,91,126,147,252,107,76,227,191,235,243,218,197,214,105,237,162,34,233,102,181,195,235,52,254,175,211,248,75,154,5,59,76,215,207,87,119,182,78,87,119,78,84,101,129,153,25,204,66,163,137,158,110,230,214,19,70,200,17,102,51,143,197,102,238,251,82,247,251,219,108,0,209,82,53,114,68,146,93,223,88,106,132,228,62,46,239,127,146,251,184,131,226,47,206,45,47,143,77,183,188,252,233,150,249,150,235,196,92,255,232,216,188,214,66,75,123,11,45,237,89,161,159,41,113,77,62,110,153,175,166,155,138,106,253,112,26,85,86,152,182,43,90,215,190,233,187,167,53,186,221,213,178,68,99,131,
148,232,209,82,38,235,227,183,196,234,114,28,151,241,151,180,113,92,127,27,37,60,227,22,77,232,98,154,208,197,228,180,217,162,229,212,126,57,181,159,45,90,69,237,87,81,251,217,162,251,169,253,253,212,126,182,104,86,128,156,250,107,183,107,80,255,13,74,103,139,62,79,237,63,79,237,63,41,237,163,235,251,232,250,39,164,105,147,93,66,244,255,203,246,34,102,245,228,206,71,249,87,218,249,196,163,184,190,61,200,254,229,20,123,160,234,94,156,79,251,64,213,205,191,174,252,68,68,2,189,67,81,69,137,25,179,40,69,23,189,67,209,69,63,161,232,162,119,40,186,232,39,20,93,244,78,184,103,186,62,155,37,205,203,159,68,245,177,59,81,93,89,49,237,208,223,223,115,135,62,153,74,23,76,156,181,174,52,244,119,31,128,172,208,198,172,51,49,94,132,232,80,17,228,8,122,173,131,163,57,140,38,13,244,157,216,198,2,52,212,160,174,6,251,128,90,58,242,80,3,104,133,168,6,42,153,8,230,78,209,222,3,20,249,77,3,223,107,133,137,167,224,111,91,81,234,139,31,37,62,248,125,216,70,71,29,138,10,80,4,20,249,80,164,161,16,226,216,90,0,21,80,125,200,3,
242,10,197,217,199,4,227,3,60,214,225,2,92,230,161,59,244,9,231,135,251,217,255,1,26,9,99,174);


programfile__MARYS_MID
:array[0..2302] of byte=(
120,1,236,90,75,108,84,85,24,62,208,193,129,74,208,152,144,8,193,100,18,77,140,100,154,134,210,244,65,105,59,206,195,201,148,66,131,214,8,11,67,137,183,134,8,1,173,33,82,51,19,58,211,153,166,68,193,62,166,221,184,82,246,134,119,116,97,130,248,216,24,87,110,220,235,206,184,50,49,113,85,191,239,252,119,254,94,238,45,45,119,74,5,177,139,230,254,231,127,191,206,185,231,254,157,131,131,39,28,99,204,19,102,131,217,186,97,236,224,224,200,73,99,54,236,50,11,71,34,13,27,135,54,155,133,243,13,198,188,140,199,38,99,62,216,102,204,194,225,134,232,103,177,242,31,46,80,124,150,136,171,23,228,121,103,95,113,23,215,63,183,202,250,183,81,89,255,245,164,93,111,142,254,46,207,157,207,89,252,230,248,231,178,238,205,203,250,213,47,100,253,246,62,121,126,248,188,224,47,157,148,245,229,237,178,254,242,5,89,255,244,169,60,127,117,229,255,254,209,174,183,60,253,145,229,219,242,226,109,89,247,158,146,231,27,85,193,191,187,95,214,23,78,200,250,242,78,89,127,125,84,158,191,188,36,248,63,47,218,117,227,83,
31,219,117,99,124,183,89,104,54,146,163,77,71,204,66,195,182,193,19,195,177,87,206,156,29,137,29,60,62,50,250,190,185,130,76,222,142,154,43,209,243,230,74,99,222,44,28,221,184,209,76,152,169,30,167,148,31,235,113,34,83,73,167,18,155,74,56,241,177,132,93,196,199,146,142,193,95,4,56,112,16,233,97,5,134,164,12,73,25,0,89,103,50,63,150,181,152,138,96,146,78,113,191,43,14,64,196,65,18,75,126,241,20,245,164,32,158,36,32,70,47,137,209,12,245,208,132,2,125,14,244,244,1,211,71,102,2,57,2,57,1,98,240,37,110,93,201,225,153,67,12,36,100,201,177,162,127,224,161,127,26,167,70,158,116,202,18,76,202,25,130,143,204,77,100,42,133,103,10,250,125,126,131,83,50,168,241,67,173,196,143,144,122,156,226,148,199,194,163,152,244,132,39,215,143,73,210,19,227,17,244,123,196,152,169,52,187,188,86,193,52,42,152,70,5,211,168,166,167,243,220,122,165,217,51,36,105,243,228,216,229,210,78,104,65,182,83,154,221,41,226,90,110,144,88,238,160,184,238,22,37,37,29,180,68,18,9,207,82,15,21,42,208,207,46,239,7,166,159,
110,16,56,64,224,128,0,49,244,60,187,155,216,56,144,198,18,116,31,100,41,124,47,255,220,240,60,205,13,12,27,58,205,46,103,48,25,116,185,228,134,112,28,219,207,216,45,232,241,219,221,15,158,248,93,37,9,134,148,120,28,67,90,60,95,159,58,128,243,117,235,107,195,239,157,29,62,253,214,176,19,75,142,154,171,56,93,191,137,154,171,209,99,230,106,99,74,78,215,11,102,186,5,117,45,182,56,145,233,54,2,109,0,58,9,116,122,49,56,18,246,23,113,238,44,242,172,82,170,157,10,219,161,176,139,64,23,0,197,168,45,37,173,210,214,218,197,165,137,106,98,20,77,136,98,15,129,61,0,90,9,180,122,49,202,172,164,250,164,52,27,154,49,77,148,98,130,57,84,235,221,116,172,27,142,37,8,224,20,152,86,76,144,71,109,45,147,195,32,79,51,53,55,67,115,144,164,152,160,207,74,90,198,150,198,165,60,161,114,168,213,169,207,86,157,82,199,144,13,187,191,8,216,253,69,192,238,175,26,166,135,128,221,95,53,76,11,129,250,165,218,41,110,247,23,1,187,191,106,24,181,213,85,35,173,210,86,27,245,172,73,92,157,212,204,68,53,17,176,251,139,
128,221,95,4,236,254,170,97,148,185,181,70,170,79,74,179,17,42,135,106,189,155,214,237,254,34,96,247,87,13,19,228,81,91,203,228,48,200,211,76,133,118,127,17,184,171,73,148,89,139,171,81,40,105,25,91,218,27,202,19,42,135,123,232,15,171,83,159,173,112,82,60,100,216,117,117,238,74,138,215,255,214,211,147,54,120,142,233,25,165,164,135,226,161,158,144,122,170,43,70,61,84,82,168,83,116,253,253,133,174,211,226,106,39,212,87,229,80,153,127,24,239,47,249,40,89,188,207,116,112,227,116,120,51,160,24,189,81,40,70,91,69,49,154,55,197,44,35,165,253,25,188,162,168,148,146,86,105,75,253,9,229,225,253,72,169,66,189,23,237,101,14,247,34,135,186,37,21,163,204,74,170,79,74,179,17,42,135,106,189,151,30,246,194,67,206,72,138,248,242,154,86,76,144,71,109,45,147,141,32,143,54,115,144,164,24,45,174,70,161,164,101,108,105,111,40,79,168,28,106,45,234,179,181,74,41,141,52,24,187,198,165,164,96,45,254,207,245,210,42,7,75,160,24,205,152,246,70,194,49,56,221,204,116,7,254,186,48,148,192,157,205,224,102,105,
112,200,25,220,156,23,63,169,55,189,206,79,234,228,241,145,145,209,216,224,241,209,83,103,70,204,53,124,82,223,137,154,107,209,179,230,90,35,166,187,50,176,156,225,160,166,132,77,51,147,193,40,103,6,67,184,18,6,112,88,196,75,24,83,224,47,2,28,56,136,244,176,2,67,18,71,134,37,140,12,1,76,214,128,138,0,28,117,185,226,0,68,28,36,177,228,23,231,72,168,132,1,11,236,186,164,20,230,30,86,42,71,61,152,204,204,40,48,128,192,75,3,192,12,144,153,0,103,58,37,204,116,8,196,192,24,183,2,125,120,246,35,6,250,199,81,142,139,244,251,167,142,170,19,65,32,131,81,142,13,38,235,12,185,185,137,204,96,48,10,159,141,223,111,112,50,90,85,235,73,223,52,227,47,94,188,43,147,143,94,210,19,158,92,63,38,73,79,184,243,74,212,12,249,150,230,190,71,1,57,148,43,97,106,7,86,0,236,73,79,119,161,201,165,205,208,68,4,56,94,116,235,239,118,59,6,162,247,18,215,30,84,205,25,54,121,6,249,62,64,61,152,69,46,2,135,169,231,48,48,135,233,6,129,67,4,14,9,16,3,99,220,10,244,227,121,8,77,72,111,56,209,116,145,126,255,212,81,
117,34,8,100,217,228,12,56,135,38,151,230,38,204,205,100,236,222,241,248,173,219,65,227,135,105,158,8,105,231,19,179,24,133,141,43,157,48,214,171,255,110,72,216,183,152,107,235,255,131,26,174,153,235,56,76,191,221,109,174,71,223,169,205,38,103,91,206,85,242,227,248,74,155,109,58,87,202,143,99,0,0,12,0,98,90,9,96,0,48,219,70,0,31,130,179,237,231,38,243,227,152,121,44,41,5,18,165,90,200,35,10,1,80,97,19,49,4,84,188,147,70,49,117,240,26,245,187,209,76,30,124,130,123,121,252,154,213,150,7,240,235,89,15,7,57,244,228,199,159,195,127,177,58,242,161,131,190,66,141,216,87,205,236,43,150,56,216,105,29,36,225,27,104,182,147,205,195,86,89,74,10,36,234,105,37,143,40,4,64,133,205,196,16,80,241,46,26,197,148,206,107,212,239,198,30,242,96,184,226,229,241,107,86,91,10,60,120,19,56,95,17,206,226,206,221,186,221,220,192,206,253,46,106,110,68,143,155,27,141,209,218,238,173,182,224,236,44,99,179,85,219,28,83,237,228,2,64,25,233,10,34,66,176,182,67,89,23,149,1,40,227,58,151,174,242,27,186,140,45,92,
229,5,176,140,196,86,249,109,81,70,174,214,200,133,16,222,54,209,83,250,134,148,85,219,185,0,0,215,151,64,132,96,85,7,112,63,21,173,0,172,86,95,118,34,146,119,230,188,19,172,221,116,0,64,25,3,202,165,16,150,42,20,254,135,217,178,98,44,109,89,239,66,216,2,160,97,81,9,83,181,20,58,64,214,0,66,125,93,185,11,66,100,64,89,87,214,26,194,129,181,97,245,213,100,189,99,237,62,88,239,216,7,113,26,174,119,108,4,231,63,142,170,245,51,246,254,222,180,245,36,235,65,158,177,114,205,194,235,16,53,195,173,168,138,41,139,188,206,1,224,117,190,4,34,4,171,239,29,135,147,54,120,37,224,120,175,188,23,134,66,232,93,27,214,102,230,128,215,149,149,243,27,130,85,125,237,70,102,237,173,11,128,189,117,249,178,195,119,53,28,168,189,197,123,101,97,202,24,251,218,183,184,15,225,97,229,239,114,32,103,202,248,247,166,101,189,11,97,47,25,188,96,208,1,75,161,3,100,13,32,212,215,149,187,32,68,6,148,117,101,173,33,28,80,86,70,177,158,87,219,59,247,216,179,139,31,7,27,230,205,77,124,28,124,191,195,220,140,158,54,
55,27,207,203,199,65,113,222,204,245,20,74,249,10,110,140,115,201,66,37,54,151,40,196,43,104,17,44,226,21,252,170,19,127,17,224,192,65,164,135,21,24,146,50,36,97,54,50,151,45,76,230,43,89,139,169,8,38,89,40,238,119,197,1,136,56,72,98,201,47,158,162,30,140,22,97,215,37,37,10,151,96,52,65,19,16,167,9,5,250,10,208,131,201,231,92,31,153,9,228,8,96,144,74,32,6,95,226,214,149,28,158,152,239,88,66,150,28,43,250,7,30,250,167,113,106,228,201,66,89,130,73,21,134,220,220,68,230,82,208,143,95,117,250,253,6,167,100,80,227,135,90,137,31,33,245,36,138,179,238,196,78,135,46,168,206,45,84,231,135,29,230,86,244,77,115,171,113,163,86,103,158,249,152,64,166,231,51,168,206,60,44,78,32,75,88,196,39,48,194,198,95,4,56,112,16,233,97,5,134,36,230,103,2,249,1,48,89,3,42,2,48,153,174,56,0,17,7,73,44,249,197,153,188,9,36,15,118,93,82,10,213,177,82,57,234,65,230,231,21,24,64,117,38,6,128,25,32,51,129,126,2,24,226,17,136,129,49,110,5,250,240,196,8,219,250,199,250,185,72,191,127,234,168,58,17,4,50,168,142,
13,38,91,24,114,115,19,153,71,23,192,103,227,247,27,156,146,65,141,31,166,37,254,105,198,143,223,220,202,171,81,171,99,158,145,114,140,127,197,39,126,25,250,192,41,255,0,0,0,255,255,3,0,220,240,38,20);


programfile__ROCK_MID
:array[0..41535] of byte=(
120,1,100,189,203,87,27,217,151,239,41,240,11,203,24,147,216,233,119,58,241,27,36,89,150,20,8,164,176,140,141,193,128,193,56,243,231,116,57,51,109,167,141,49,198,188,17,66,8,33,35,5,33,80,174,250,149,171,238,69,118,186,107,212,131,94,53,235,213,107,117,61,126,53,191,183,31,195,187,122,212,255,64,211,61,239,217,189,147,94,213,159,239,137,192,153,183,59,215,114,70,156,115,246,222,103,159,253,62,39,34,196,216,147,233,201,64,32,112,48,208,16,8,6,254,195,216,147,220,28,173,175,3,255,246,211,254,253,141,167,155,2,255,246,167,125,7,78,126,253,239,255,205,249,183,155,1,111,240,196,227,192,191,53,52,45,188,157,95,154,92,111,111,15,252,223,193,190,214,123,109,119,3,78,160,239,63,255,26,248,199,96,79,224,31,15,101,3,255,33,245,107,235,63,62,95,253,187,91,59,247,157,7,155,247,157,83,59,195,142,123,114,115,216,185,66,199,77,58,174,170,227,24,29,201,157,81,199,125,189,57,234,212,38,233,186,77,79,84,61,39,232,185,176,51,92,73,109,14,87,46,168,35,226,117,56,110,14,144,237,130,186,94,210,117,
143,155,39,92,91,119,70,184,142,56,77,162,187,31,144,8,19,185,189,204,212,170,158,199,244,108,61,209,93,144,187,204,206,253,149,142,205,251,43,102,166,38,176,117,51,97,168,12,59,213,13,77,144,209,4,143,255,63,19,188,96,130,0,68,70,128,184,0,253,24,228,175,49,177,219,193,64,135,110,98,220,108,77,105,158,86,96,224,97,254,236,230,253,121,49,233,106,158,110,221,68,185,185,8,72,245,129,38,58,11,157,235,208,73,210,51,75,199,247,66,110,228,230,30,55,15,185,158,22,142,13,206,175,45,244,44,210,243,152,107,146,235,117,141,180,50,18,209,205,21,110,206,10,89,32,158,128,18,116,205,50,166,117,236,9,232,48,32,63,2,209,202,188,221,204,219,46,20,205,115,97,103,228,253,196,230,200,251,109,35,238,70,80,236,157,225,210,197,205,225,82,47,43,91,101,97,15,185,62,229,42,137,86,239,106,150,13,136,151,128,100,129,197,142,205,209,98,23,237,135,180,79,3,185,167,141,61,97,69,153,236,166,100,180,15,18,183,117,115,156,155,237,211,16,211,186,31,239,220,223,104,223,188,191,33,18,110,0,26,247,117,243,13,55,152,
129,83,61,13,200,127,146,78,7,32,115,93,60,31,166,167,139,142,71,116,28,84,71,23,29,39,133,36,83,169,245,50,244,19,67,50,136,103,140,52,209,22,11,215,128,200,1,240,144,235,51,174,154,223,216,84,109,64,184,39,233,146,113,189,224,186,39,50,72,84,158,98,135,7,119,238,115,189,95,49,22,117,1,154,210,226,91,174,219,195,16,151,173,25,98,82,158,49,31,173,194,134,214,32,215,107,154,166,196,72,77,19,75,102,140,108,32,179,13,57,192,235,157,145,117,73,28,153,173,7,145,58,230,90,66,65,235,131,155,247,215,37,75,183,25,81,117,237,140,84,80,247,72,101,251,164,136,217,16,99,81,69,148,88,52,42,219,179,4,143,117,100,246,2,136,255,179,184,51,228,184,7,55,135,28,115,115,133,155,211,59,131,114,145,65,103,96,103,192,169,54,111,14,224,148,119,156,159,55,239,56,91,175,5,124,8,24,247,148,238,4,221,46,232,102,160,175,9,186,23,232,237,152,198,246,51,150,217,25,42,181,111,14,149,186,213,193,141,7,124,114,15,248,52,192,23,32,253,84,164,127,1,166,12,200,195,157,161,185,211,155,67,115,119,133,115,98,15,231,
43,112,146,76,176,221,13,78,245,230,206,3,199,109,216,124,0,135,15,54,46,110,62,64,70,116,4,233,232,214,77,35,55,189,220,84,3,220,68,119,238,57,213,137,205,123,142,251,211,30,144,123,90,119,77,123,224,167,184,233,20,237,1,209,190,166,121,91,152,23,166,223,95,219,28,122,159,218,235,184,168,149,158,129,145,40,192,110,17,224,40,204,191,135,249,234,56,61,73,58,58,118,6,214,99,155,3,235,154,180,196,156,131,59,125,206,252,102,159,243,4,192,103,0,78,238,220,150,71,222,118,126,77,128,241,4,12,97,118,112,29,217,233,171,244,110,246,85,90,192,116,79,129,122,157,129,173,22,70,182,102,197,128,196,233,158,208,93,136,187,86,177,210,1,43,39,129,218,206,3,85,29,230,238,5,55,211,92,31,112,61,195,212,131,76,221,180,115,175,204,148,247,202,246,206,64,249,215,107,155,3,229,103,80,201,139,220,121,110,42,220,12,66,109,3,98,189,160,254,122,2,220,103,146,207,73,196,114,109,231,65,249,234,230,131,242,69,117,180,209,209,177,119,147,225,166,218,78,79,43,12,111,5,37,223,132,198,36,114,180,50,209,188,249,
96,34,181,7,28,209,205,53,67,111,192,169,69,153,193,29,212,82,100,118,247,118,134,150,46,109,14,45,93,80,199,5,58,140,65,221,128,157,51,176,227,206,3,108,236,112,68,88,69,117,237,247,186,138,237,155,3,69,163,173,40,88,45,146,200,101,176,190,213,34,90,1,201,105,210,86,38,189,178,243,128,224,243,160,216,78,71,243,206,192,18,43,92,42,210,31,21,192,126,110,204,90,34,220,156,145,173,172,104,45,223,139,156,12,85,194,50,108,93,83,207,5,122,110,50,65,173,65,220,44,106,44,192,228,153,157,129,5,148,184,208,174,142,175,233,184,1,112,214,96,163,153,70,96,35,32,85,23,133,244,88,75,144,198,47,136,160,116,216,68,79,138,142,147,234,8,209,113,129,142,95,207,209,243,92,28,158,135,177,216,206,131,2,242,43,104,9,83,180,101,192,49,255,234,158,229,70,122,169,234,230,180,212,241,134,37,24,220,67,244,44,139,136,140,93,203,52,2,233,101,162,41,230,105,217,25,200,215,240,239,252,180,248,150,127,98,116,43,55,55,7,86,90,119,134,42,224,12,85,238,239,12,86,86,54,7,43,143,196,191,4,111,188,252,37,55,216,89,
225,233,230,64,1,102,243,131,208,8,236,220,203,203,206,242,15,49,188,69,12,111,12,155,127,141,205,191,193,230,183,215,176,249,255,118,144,72,150,34,138,133,184,198,184,198,184,42,27,40,24,42,59,125,205,117,142,43,112,27,164,166,13,197,70,133,224,105,194,89,148,88,165,208,111,211,190,228,95,187,233,87,246,152,229,250,19,215,23,172,235,5,235,106,222,233,223,168,6,55,251,55,254,28,4,242,30,24,87,119,70,203,61,155,163,101,37,66,85,3,80,122,223,190,57,250,94,185,51,75,123,140,107,31,215,43,92,197,81,1,138,221,80,20,167,74,146,202,255,35,92,21,191,53,147,74,145,37,174,63,48,227,51,111,70,103,59,180,217,239,252,58,3,164,214,240,130,171,120,159,252,195,85,107,86,134,23,165,54,40,40,69,98,5,149,4,2,142,210,198,150,134,9,251,131,228,187,65,231,103,58,94,209,126,73,27,0,16,239,108,108,183,111,222,217,248,245,10,61,41,122,174,0,145,7,66,9,195,228,37,12,210,35,174,44,167,101,43,236,43,185,152,172,247,148,155,234,226,31,112,43,224,14,11,87,137,193,224,14,248,56,82,18,121,176,204,181,44,17,
184,200,206,217,10,128,123,219,159,87,153,234,191,158,87,98,18,108,156,107,152,171,167,232,71,78,181,101,147,255,197,192,253,30,92,165,198,130,143,59,15,100,181,13,208,94,110,58,208,72,23,26,129,132,153,86,154,168,42,13,86,117,55,201,205,75,174,25,174,180,215,152,108,13,157,228,185,230,185,46,112,93,192,154,114,72,56,39,171,210,90,167,153,82,130,51,97,233,138,113,13,111,238,97,137,58,3,19,77,64,184,146,228,193,157,59,149,237,169,205,59,149,218,247,32,75,10,176,81,160,76,40,220,164,61,74,251,238,206,104,229,242,230,104,229,56,237,37,218,67,20,52,76,170,130,166,242,152,254,69,104,38,32,169,201,193,51,166,202,56,90,163,114,161,63,203,85,117,215,16,83,42,182,217,56,7,158,125,199,249,115,5,140,187,64,74,87,194,144,12,127,225,26,231,170,234,230,44,215,28,87,102,52,227,114,2,153,168,40,142,67,49,128,224,144,245,123,100,94,122,176,57,90,58,79,255,75,250,95,113,253,43,174,5,102,124,196,140,109,59,253,149,210,102,127,229,111,206,67,96,17,2,82,159,174,143,185,174,114,213,210,165,60,52,1,
225,81,162,3,230,1,129,182,157,193,247,145,205,193,247,178,80,149,190,15,177,216,113,44,246,37,237,39,180,179,76,240,132,9,90,118,238,148,168,22,238,148,254,58,74,207,83,122,154,129,88,1,226,79,62,197,170,166,222,179,49,217,37,107,174,176,150,138,140,192,88,225,214,117,80,71,65,61,227,163,62,98,68,210,168,94,102,153,8,250,61,226,88,135,196,58,40,171,136,109,21,18,74,111,163,229,45,197,220,239,204,66,135,89,143,124,115,212,89,16,234,87,220,200,196,52,187,12,72,11,84,24,137,237,60,34,105,97,157,91,7,65,29,0,85,149,164,150,168,122,124,90,168,205,152,1,194,45,96,99,198,230,80,111,1,37,21,240,226,85,23,54,86,183,144,222,218,36,214,248,146,30,136,175,98,157,89,32,178,17,174,180,179,180,23,187,55,71,23,81,235,2,76,44,16,187,114,83,88,233,196,206,224,218,200,230,224,218,9,5,229,19,88,103,136,185,205,230,195,218,25,156,58,176,51,92,108,217,28,156,34,67,14,23,67,112,71,158,26,36,78,82,39,93,192,104,254,135,192,78,95,233,209,102,95,233,4,67,63,48,50,199,85,58,136,238,244,47,93,222,236,95,
58,67,187,151,118,199,206,96,25,153,148,223,236,244,23,98,155,253,172,99,16,227,24,52,190,241,134,235,43,218,73,174,238,33,216,120,6,23,68,159,149,240,230,224,202,81,191,125,144,226,242,33,181,229,214,126,32,139,64,62,230,58,204,85,217,75,14,189,37,76,83,139,53,131,122,13,212,54,58,158,64,170,109,15,21,3,50,22,152,231,122,15,20,234,203,10,75,175,108,105,237,89,3,57,184,214,142,44,20,19,31,33,126,81,200,209,111,34,142,194,171,216,236,243,38,165,192,30,172,84,75,154,84,169,155,73,215,224,119,13,126,203,240,95,102,210,202,51,74,224,45,249,54,86,106,194,167,38,21,191,99,92,183,142,113,35,154,136,98,35,189,57,184,113,0,82,79,13,19,94,104,103,210,97,178,35,182,13,160,13,224,85,174,50,201,173,213,157,254,114,223,102,127,89,245,241,67,58,74,92,101,230,161,157,254,149,43,155,253,44,220,91,31,66,119,238,211,191,132,199,117,226,113,183,104,43,202,72,248,143,185,46,114,173,118,115,243,91,243,206,24,22,57,70,72,27,171,112,173,112,45,116,111,142,21,66,59,99,235,201,205,177,245,240,206,216,
90,108,147,127,59,99,171,244,175,118,239,140,45,223,220,28,91,238,219,121,168,114,236,33,83,143,224,195,35,84,143,35,212,155,35,132,169,33,135,253,65,129,205,101,225,37,249,124,144,126,183,155,129,131,96,228,65,216,26,96,202,1,166,188,196,245,174,185,62,132,194,67,188,122,4,253,142,144,9,33,125,149,142,147,66,77,209,115,20,154,223,65,139,154,104,132,132,174,29,238,24,187,129,49,104,142,148,163,155,35,229,46,218,152,240,24,69,244,67,74,248,135,102,214,113,0,229,255,218,90,189,20,169,60,29,29,0,76,136,139,113,80,122,193,96,193,101,22,94,190,178,243,176,50,181,249,176,162,41,60,46,134,43,63,176,163,66,157,171,108,215,70,86,97,34,119,123,115,40,183,189,31,136,71,144,58,14,133,30,40,32,170,202,61,35,186,135,104,237,33,94,63,226,44,51,174,61,176,106,131,101,205,125,149,142,11,204,253,68,115,207,67,147,117,173,34,187,92,102,115,36,71,26,165,218,24,222,192,1,87,200,10,43,161,157,161,13,246,138,67,27,71,119,238,151,111,111,222,47,95,218,233,127,79,126,237,127,95,67,156,249,123,155,35,
249,43,144,24,128,4,229,192,218,173,205,225,53,14,43,86,33,177,202,198,103,163,0,230,35,48,83,30,102,225,25,110,55,238,79,25,221,25,89,76,108,142,44,218,59,35,107,172,106,141,107,9,22,74,196,157,98,12,79,103,203,177,209,13,62,172,108,208,222,48,251,166,147,200,190,141,157,229,53,118,150,61,236,35,171,119,216,72,86,3,220,69,184,177,185,50,21,146,28,170,128,90,137,129,26,1,181,139,245,115,37,102,240,143,43,187,119,210,199,8,65,79,213,203,80,229,4,125,189,192,191,218,25,90,219,186,181,57,180,230,6,209,115,132,185,52,41,148,160,40,136,97,44,101,132,234,203,108,47,25,31,97,124,196,92,217,110,126,105,187,41,132,215,192,224,13,4,168,169,171,242,99,55,207,221,53,110,56,40,48,202,192,166,216,228,140,96,231,15,43,17,212,29,227,154,224,26,221,121,88,166,93,238,166,29,162,205,85,199,32,15,177,229,17,231,18,100,251,184,110,189,227,230,153,111,56,231,119,198,54,82,155,99,44,115,172,20,217,28,43,201,6,251,49,135,171,120,76,39,30,19,247,225,48,143,13,12,109,131,25,181,173,122,232,124,3,37,78,
49,156,9,174,178,44,140,20,211,246,54,171,244,116,209,115,122,231,97,113,99,243,97,113,203,246,137,126,195,85,190,34,34,75,208,24,19,110,19,144,226,115,156,14,67,236,154,71,44,247,12,51,101,175,233,29,112,28,4,117,146,85,55,130,206,108,172,24,95,185,68,67,230,152,3,85,30,218,15,102,39,34,122,129,168,0,118,170,39,12,169,135,101,124,165,188,245,2,20,121,44,75,38,236,140,137,61,227,68,154,130,244,101,220,44,135,169,231,56,8,88,213,1,211,234,193,157,33,204,115,104,85,206,82,25,102,214,179,191,199,17,76,126,12,147,127,184,6,223,107,144,40,146,60,71,138,40,232,61,185,252,189,89,72,15,52,143,1,241,10,8,118,252,35,248,215,8,103,108,35,228,221,145,117,76,21,129,14,111,92,218,25,206,115,246,150,199,228,43,57,236,8,147,55,118,136,179,20,183,206,110,242,191,1,248,3,67,150,87,249,30,10,68,247,50,152,101,40,148,199,184,158,193,242,152,124,8,239,185,159,235,219,188,159,35,142,174,177,135,233,95,251,155,153,47,135,134,206,189,255,28,248,114,178,248,116,85,39,139,239,102,242,175,115,185,183,139,
191,6,254,227,249,192,63,29,154,12,252,83,48,241,235,225,127,122,254,230,67,169,30,118,2,245,132,227,126,229,134,157,131,110,194,217,158,169,247,208,19,115,226,110,143,211,232,198,156,72,189,167,66,123,225,134,27,91,104,114,123,42,145,122,90,227,27,25,55,182,17,116,211,206,153,122,207,58,237,153,235,110,207,122,147,27,155,73,120,248,107,17,55,182,22,128,134,229,181,231,34,220,55,184,177,185,46,112,3,208,232,2,55,0,141,176,135,63,127,5,252,35,110,108,222,199,207,129,159,243,241,129,143,205,128,191,1,254,12,248,235,13,224,135,61,252,117,232,107,254,185,171,224,7,161,159,168,199,86,27,152,243,50,243,53,187,177,213,155,224,6,128,249,157,63,143,127,232,111,52,66,35,86,239,201,54,0,3,126,22,124,195,63,237,213,48,248,135,192,143,212,99,111,192,95,189,225,246,172,194,239,155,46,111,253,102,125,77,224,135,153,155,241,60,244,243,154,31,122,146,207,106,8,220,70,179,254,216,44,252,84,194,46,87,228,231,227,175,50,63,227,105,39,94,143,189,19,127,226,31,250,239,50,127,224,159,245,174,218,30,
253,13,214,179,113,24,250,201,122,90,235,93,187,230,166,215,25,95,75,249,243,127,203,252,200,127,206,246,231,191,198,220,180,87,161,175,249,55,174,49,255,33,104,88,245,88,30,249,175,95,113,99,240,155,94,215,56,243,87,152,191,194,252,179,153,122,231,26,244,43,240,87,105,114,59,215,88,31,242,239,204,117,186,157,185,125,200,44,137,181,208,118,174,96,44,65,183,83,252,3,223,89,185,14,47,13,110,103,37,141,237,104,252,18,99,200,159,241,78,233,111,227,38,184,1,183,115,35,225,225,67,191,147,249,18,14,250,170,52,0,115,133,49,232,87,88,175,230,51,248,200,19,126,13,254,250,101,55,182,222,252,59,62,240,102,254,13,230,215,124,107,223,50,23,252,32,143,78,236,35,230,92,165,13,63,235,106,107,126,236,87,243,175,119,121,243,35,143,4,242,233,20,254,6,243,175,35,31,236,185,115,61,198,122,100,63,167,144,223,73,214,196,56,242,234,129,94,15,244,99,121,248,133,94,218,137,124,177,63,163,255,53,198,215,36,255,46,79,254,185,11,30,124,174,199,215,31,246,193,252,210,79,90,254,100,244,31,112,211,21,244,49,
9,253,28,250,205,65,127,18,251,158,219,179,95,218,115,204,63,45,251,184,136,125,180,184,177,233,132,103,127,171,81,116,11,62,242,237,153,135,222,20,235,157,194,95,230,177,159,37,241,171,249,225,103,9,125,188,147,254,241,47,205,47,251,98,60,93,1,127,233,0,243,99,223,162,191,112,206,237,89,104,131,126,23,17,161,161,158,192,94,19,232,63,140,125,135,209,111,34,127,195,77,96,95,225,181,136,137,24,93,172,191,11,255,13,227,223,97,228,147,216,184,238,38,160,31,206,219,245,48,250,75,160,191,132,115,216,13,111,64,15,121,37,178,151,221,4,254,21,70,254,97,214,223,229,116,130,191,207,13,179,126,67,31,127,77,160,175,240,218,109,108,9,253,85,208,55,246,209,89,185,229,217,227,58,250,195,63,58,215,186,140,61,36,246,236,15,253,117,50,127,108,77,246,199,56,243,119,162,207,152,3,60,252,73,191,70,255,232,39,182,214,136,126,53,46,126,99,140,237,135,231,176,55,190,202,124,171,135,25,79,34,43,240,243,223,32,47,228,151,71,126,242,143,245,155,158,127,206,162,127,249,15,242,67,143,140,35,127,217,151,137,
127,232,107,198,247,255,28,242,86,188,203,221,130,30,227,115,208,159,59,2,77,95,127,140,199,208,183,241,127,209,95,197,126,136,7,177,89,228,39,249,111,184,23,97,14,129,57,219,79,60,139,90,31,244,52,186,222,234,69,172,5,34,84,22,14,23,162,158,69,44,225,177,75,178,8,34,162,44,98,146,136,48,79,4,155,188,85,143,209,238,65,98,38,162,207,167,235,61,242,240,105,44,82,22,187,103,81,38,226,138,163,206,122,207,34,227,111,47,186,177,183,65,183,103,177,219,207,0,68,148,10,244,22,144,128,44,54,79,68,155,36,194,229,137,104,90,97,14,139,34,98,167,145,120,207,2,237,215,72,252,53,22,185,144,241,240,231,66,72,192,139,128,61,57,198,39,207,98,241,68,124,248,35,146,213,99,217,43,94,68,203,18,193,196,223,59,52,32,254,222,221,246,214,191,8,189,69,101,4,248,207,50,62,197,252,178,248,108,183,231,81,11,221,38,67,165,43,23,61,254,199,177,136,241,227,240,127,221,227,103,10,254,166,136,128,11,33,188,77,248,183,104,147,209,114,23,234,105,60,34,54,9,254,100,179,155,94,250,6,222,89,223,28,26,159,35,226,190,
238,68,187,120,16,235,237,201,211,158,9,129,203,184,34,202,212,1,52,122,179,158,150,5,46,38,220,116,30,249,44,94,243,228,147,35,99,228,36,255,168,39,255,117,240,21,225,231,241,120,121,248,70,151,231,145,115,120,32,244,211,178,216,153,175,145,255,121,111,253,19,231,220,216,68,7,50,184,80,239,20,127,235,232,87,30,176,68,68,84,4,201,119,154,8,222,89,137,122,22,157,143,226,161,158,197,43,66,117,174,93,198,91,136,192,235,9,51,30,91,191,196,61,22,142,71,26,143,201,95,197,91,88,79,30,122,68,208,4,30,77,100,39,106,211,94,213,124,200,123,253,144,219,185,154,244,219,194,63,66,27,253,43,226,147,17,129,195,171,252,136,10,127,120,26,52,88,159,230,199,163,58,87,241,8,60,222,68,100,50,140,241,232,245,180,239,209,215,225,15,253,194,95,130,245,116,154,140,16,36,234,32,111,209,199,227,59,85,81,16,113,208,59,94,134,190,23,177,31,50,190,201,232,70,31,204,63,131,254,101,47,75,232,79,246,191,6,190,34,154,241,40,228,63,45,143,102,156,10,36,54,135,189,202,62,5,63,141,62,136,8,138,120,6,127,174,139,113,
225,147,241,76,196,149,190,144,207,244,13,79,255,170,8,180,222,25,63,98,47,64,111,18,126,22,246,240,177,47,131,191,71,31,255,153,198,127,214,186,153,27,126,42,242,31,240,231,136,40,178,167,181,40,99,162,135,60,241,207,180,3,254,252,97,244,223,225,193,255,33,163,120,53,154,69,48,104,64,190,33,34,40,17,98,141,136,12,126,152,138,130,72,76,212,136,48,30,36,170,118,18,173,105,99,159,68,98,108,2,253,176,94,141,39,88,111,152,140,97,34,12,25,40,193,122,194,14,248,200,63,92,185,2,45,240,43,140,43,98,19,81,195,200,63,177,134,253,200,222,136,232,49,7,253,51,110,34,172,244,173,140,45,251,18,252,6,246,199,124,157,170,40,164,207,85,252,175,66,196,93,37,3,43,162,110,92,32,195,30,243,34,178,244,145,39,34,82,129,116,42,195,227,255,9,50,176,244,157,0,223,84,32,204,111,236,131,249,99,121,228,101,42,58,228,149,39,158,225,255,94,70,70,127,196,11,83,209,173,163,63,236,207,84,100,138,119,38,99,162,191,121,50,48,235,255,18,255,214,144,63,254,239,225,67,47,167,138,235,15,25,125,85,254,201,184,145,191,
50,48,25,10,249,246,56,63,18,123,142,33,175,218,25,83,178,244,152,18,25,2,21,12,100,28,0,5,100,74,228,216,56,14,175,20,225,164,96,70,14,118,161,222,67,137,23,155,96,193,19,4,156,119,126,64,205,82,210,86,72,17,89,74,94,74,214,216,20,6,178,10,254,20,11,134,65,175,196,160,157,35,96,45,48,254,150,20,177,128,65,191,77,34,0,9,132,0,175,18,37,139,193,155,128,236,27,36,10,55,41,126,131,246,210,33,2,50,14,164,113,2,104,207,98,43,70,75,219,148,132,240,75,9,28,155,221,51,88,74,180,105,2,170,4,142,195,125,73,113,139,40,212,224,147,48,8,192,177,73,74,180,69,230,39,69,247,96,48,49,198,77,10,156,133,190,74,112,82,164,41,81,247,18,146,74,116,5,108,5,116,37,44,149,32,194,55,10,101,254,69,20,242,18,254,84,194,147,32,98,47,73,8,50,184,69,248,103,62,83,34,189,1,126,137,4,134,131,199,222,252,17,223,155,63,246,22,252,189,20,250,214,55,136,60,248,4,68,147,16,21,64,37,63,228,97,228,39,5,83,2,155,128,60,135,65,189,133,254,234,37,228,143,190,36,95,173,31,135,137,45,122,37,190,151,144,8,96,239,36,31,74,
100,12,194,11,168,42,129,101,192,180,87,113,248,213,147,24,113,200,115,8,28,42,65,194,84,201,105,2,174,9,168,56,132,74,20,193,75,63,200,95,14,99,12,62,139,195,100,113,160,53,198,49,216,4,91,136,78,28,54,33,131,196,30,58,23,8,216,11,158,193,122,14,130,67,18,224,59,41,81,59,149,176,103,177,175,89,232,45,194,31,246,151,96,61,137,85,198,41,81,204,124,57,232,231,40,121,247,18,130,182,4,114,216,13,63,32,155,18,138,146,25,7,241,230,199,161,9,16,162,47,7,81,64,142,173,30,4,31,251,86,2,51,91,22,244,169,18,85,14,7,190,9,104,243,200,95,1,54,11,125,214,147,134,94,143,18,228,91,244,175,45,202,91,244,247,5,159,245,40,32,42,161,26,253,209,158,98,92,1,113,141,130,64,1,114,158,18,74,235,123,35,251,61,128,254,123,60,127,153,166,36,86,201,52,205,184,236,107,28,253,140,171,32,16,125,240,89,31,133,137,161,111,18,254,27,18,200,27,198,115,248,159,73,248,237,216,114,51,54,129,125,170,253,138,241,87,36,136,37,2,186,244,99,18,6,252,43,225,200,94,150,240,183,37,173,87,37,26,242,117,186,77,194,12,43,224,
146,48,194,185,184,27,206,29,118,19,211,215,235,93,4,184,48,1,29,56,183,139,132,99,2,48,242,75,172,169,4,86,0,87,192,196,62,84,225,41,224,42,160,99,175,9,2,98,184,18,242,240,73,136,192,129,79,0,130,94,194,148,200,140,43,129,155,18,23,126,77,137,235,219,223,94,65,128,126,140,254,246,18,250,26,252,195,111,167,244,171,45,143,2,186,214,7,125,19,160,101,127,106,175,97,191,107,190,253,162,239,4,252,119,174,30,96,141,36,68,74,82,19,208,133,175,2,192,4,100,96,166,190,114,19,83,231,137,67,200,25,59,51,114,98,171,109,10,61,18,253,255,111,171,35,59,97,171,208,179,113,200,43,132,76,28,67,175,194,207,98,7,232,161,199,1,31,57,247,176,53,52,129,125,49,132,31,170,48,245,19,179,217,106,3,63,237,149,202,61,206,246,43,128,79,35,108,183,201,15,245,33,58,152,97,45,138,165,176,178,121,60,131,212,218,67,41,99,40,230,72,21,42,85,69,81,145,99,94,165,178,44,147,210,243,75,169,128,165,104,179,172,113,82,149,103,185,148,26,146,212,2,158,183,160,205,51,227,19,140,231,88,1,244,98,19,158,229,245,56,68,114,
173,72,150,173,195,131,5,232,47,28,52,145,203,224,47,146,234,21,217,144,188,177,92,69,166,44,150,204,252,70,130,127,196,23,125,54,79,102,28,250,134,127,74,61,47,178,33,241,47,244,225,255,141,54,255,100,10,214,219,163,204,195,97,138,137,220,57,230,199,243,21,185,189,249,253,82,123,145,249,84,234,26,250,200,235,181,54,171,123,145,153,200,42,207,54,135,19,104,76,165,216,59,218,75,42,85,241,236,37,29,94,224,137,242,156,9,248,87,100,157,160,212,82,100,92,100,220,47,213,77,41,181,23,25,208,152,39,127,44,207,200,31,249,105,254,37,248,133,94,236,53,91,5,225,47,176,57,90,192,19,85,234,43,51,190,131,158,34,175,14,67,216,44,165,137,140,105,149,98,179,204,167,200,48,142,5,46,178,222,113,69,102,224,217,172,74,62,58,156,48,145,113,81,165,35,145,122,49,98,74,225,4,150,111,34,179,50,35,250,236,196,162,98,172,175,211,223,220,155,195,0,181,141,103,64,207,63,140,50,145,92,145,217,247,92,19,25,105,119,46,128,79,41,219,201,214,200,148,206,27,237,68,214,19,120,10,246,165,113,69,222,53,50,65,206,43,
173,19,249,11,120,122,43,227,200,83,227,218,218,8,127,209,59,28,235,204,177,94,54,159,157,57,198,137,156,157,68,70,83,42,225,121,198,179,215,67,148,73,148,242,148,198,198,115,41,197,117,152,164,200,30,99,235,213,147,71,30,249,175,188,173,154,201,116,190,254,56,28,51,145,121,17,249,202,254,214,246,34,43,242,151,252,222,144,249,116,88,150,199,127,242,100,98,14,219,140,124,167,161,175,202,0,254,12,190,214,43,251,151,127,73,255,83,210,31,246,49,69,100,205,33,47,182,122,102,235,51,119,195,179,239,119,204,111,50,191,63,255,60,135,127,200,35,54,127,197,179,175,44,145,60,203,225,195,59,109,149,148,233,3,245,238,215,199,221,238,215,173,208,165,127,222,223,130,169,98,18,157,25,244,166,12,81,193,14,84,129,204,35,103,109,162,23,217,114,45,66,119,54,234,149,184,84,32,9,248,82,132,14,43,162,177,37,75,176,233,14,175,18,97,145,59,135,17,68,99,34,44,37,127,130,12,27,166,100,77,224,39,97,228,108,34,174,201,160,109,68,92,14,65,176,195,4,122,217,27,239,194,110,194,28,194,113,120,225,118,17,233,76,
201,141,29,113,24,130,110,189,67,134,24,91,110,47,66,115,136,161,12,152,69,143,28,130,200,206,204,33,26,91,0,244,73,132,149,95,161,231,37,198,225,183,147,12,228,85,12,148,216,210,131,50,182,252,192,248,21,227,178,3,173,135,10,194,148,220,170,16,20,225,177,19,179,37,115,240,35,14,177,98,75,28,234,104,139,181,68,133,243,197,143,241,155,119,248,161,226,98,30,59,83,133,180,42,63,163,61,71,156,80,5,74,134,139,81,113,126,41,145,23,136,99,178,35,19,185,21,215,124,63,54,21,30,118,128,124,77,28,154,39,195,207,163,15,226,144,201,144,196,138,158,245,237,55,166,204,74,44,181,40,66,31,53,199,109,61,188,184,97,76,188,199,249,31,247,215,45,167,154,114,45,103,176,126,211,201,184,55,57,145,141,58,47,220,168,243,164,30,113,170,121,55,226,188,168,199,157,97,55,206,64,194,121,133,180,126,0,99,171,9,140,151,96,116,129,145,2,227,175,192,120,14,198,246,9,48,170,35,34,122,5,144,41,64,6,0,137,3,242,203,30,209,123,128,184,65,168,102,160,154,130,234,15,80,125,11,74,237,4,40,139,80,105,168,167,156,231,110,
138,253,84,196,169,101,233,8,48,154,96,48,64,199,141,122,132,124,111,205,220,112,35,211,176,129,53,70,138,129,122,50,151,113,35,197,54,55,153,251,170,30,193,58,173,233,171,174,53,221,236,70,230,99,102,92,248,145,98,16,26,151,235,17,188,212,226,72,61,194,126,193,90,136,212,147,180,35,165,144,27,41,181,187,201,133,175,235,22,210,142,172,92,114,35,43,192,115,228,107,230,47,69,92,171,164,249,19,245,8,94,102,45,67,127,153,54,27,152,36,214,27,41,117,131,175,249,79,213,45,234,161,200,202,101,240,27,92,43,123,187,30,41,48,95,249,146,107,149,15,187,145,66,87,61,194,184,181,76,123,121,159,27,161,94,50,248,229,152,27,41,127,11,126,171,199,111,25,250,101,232,23,51,72,42,80,79,149,207,186,41,240,145,90,61,14,126,138,122,51,53,27,116,227,217,174,186,93,14,212,227,197,152,27,47,6,92,187,124,179,158,34,170,199,87,174,187,241,149,128,155,122,109,51,134,64,139,55,25,111,116,83,197,27,140,129,191,12,254,50,248,43,93,134,190,205,250,237,82,51,244,59,235,41,228,23,231,145,64,106,190,193,141,115,164,
153,18,125,172,53,85,110,114,227,212,25,41,228,29,39,43,199,241,142,84,241,118,221,46,209,46,116,184,241,66,51,52,194,245,20,222,246,101,60,127,27,101,54,152,118,138,250,37,206,129,71,124,153,249,11,87,221,84,33,224,198,151,51,62,254,89,240,207,26,124,111,188,161,110,191,56,225,218,47,218,128,131,207,101,244,72,221,99,149,144,139,244,192,209,160,145,43,7,41,22,94,20,41,100,140,158,146,28,132,69,156,86,228,120,17,29,32,231,210,101,224,49,36,214,25,65,14,150,115,17,27,192,46,138,113,15,159,163,95,43,183,31,124,27,29,98,71,68,133,72,105,191,155,92,195,206,88,167,133,30,45,236,32,82,20,190,232,93,135,222,17,218,140,75,175,43,87,193,109,4,198,199,199,43,35,165,67,110,114,9,187,212,252,236,43,176,7,230,103,28,57,90,178,179,50,118,133,156,12,126,14,126,136,138,145,66,183,103,7,78,59,252,159,128,127,198,5,143,156,45,228,28,41,223,246,236,0,25,165,144,115,156,236,28,103,254,20,217,45,69,54,143,195,191,209,67,241,26,122,14,34,71,236,0,187,140,23,145,107,241,48,48,189,245,56,235,75,149,
208,43,242,139,151,110,213,227,140,167,136,154,241,220,65,55,197,190,85,227,118,169,19,220,3,140,199,61,59,219,163,207,70,63,142,94,83,37,236,64,248,200,223,216,81,33,12,63,251,177,163,68,221,150,93,20,152,31,189,218,197,180,111,55,223,98,55,232,47,159,242,240,57,26,247,236,0,124,205,95,196,14,225,55,158,99,126,240,109,124,48,94,108,53,252,171,157,42,99,7,207,176,131,103,71,188,117,148,83,245,16,122,140,59,231,220,144,240,144,67,8,255,136,99,23,240,239,134,240,143,16,235,176,56,48,177,8,32,161,146,85,15,33,167,120,145,117,226,31,33,228,36,127,10,81,69,129,231,201,17,248,80,249,178,27,42,179,142,146,13,174,218,87,104,7,160,129,156,224,35,68,21,23,47,54,185,161,156,205,252,208,43,179,78,198,67,69,214,37,124,236,159,121,60,124,244,22,34,126,132,20,63,202,216,187,240,243,62,62,217,41,36,189,192,95,92,252,81,149,132,140,191,192,31,118,28,210,184,244,14,253,80,185,21,252,78,111,125,206,55,192,51,63,235,243,252,239,130,129,79,21,251,208,9,244,176,195,248,10,254,13,255,54,118,231,249,
35,118,176,114,195,179,3,14,236,68,63,197,254,203,224,23,34,232,73,241,0,127,214,252,84,209,232,3,59,192,31,181,62,99,71,45,232,209,247,103,252,36,158,195,223,229,207,146,39,122,54,126,89,184,233,217,97,1,61,23,218,160,25,171,219,90,95,129,245,41,30,80,69,25,250,197,118,112,137,95,200,203,240,91,188,194,253,62,248,69,126,178,227,34,241,0,253,196,241,99,27,157,199,139,103,24,63,79,60,235,244,236,86,118,240,99,131,107,255,232,219,83,169,219,243,231,50,254,133,222,34,69,203,139,211,69,252,169,136,127,115,176,166,184,157,100,223,22,113,90,220,164,19,245,253,239,91,47,126,148,239,249,109,236,68,241,1,61,89,240,17,193,78,240,115,215,194,78,146,224,71,208,83,196,57,15,62,241,132,113,203,204,167,120,131,63,35,39,11,127,48,241,8,123,87,252,176,176,155,72,105,31,60,129,207,62,51,82,186,64,251,172,155,172,92,247,248,43,125,11,61,249,127,202,107,35,39,171,128,127,99,103,17,214,104,21,190,241,226,131,230,167,74,138,224,47,17,108,53,185,118,206,155,191,112,14,120,197,11,229,5,226,122,233,34,
50,196,110,201,164,169,130,228,166,184,218,136,236,210,158,28,169,130,100,103,118,25,61,200,78,10,232,145,249,82,37,244,40,57,99,247,113,252,51,165,113,163,119,236,0,249,145,47,124,124,217,41,122,212,184,244,94,60,231,141,195,159,137,235,78,15,227,216,141,83,27,134,89,247,46,220,142,83,15,185,57,138,175,40,174,228,146,55,157,19,12,85,24,169,53,194,116,5,4,247,34,210,173,30,67,172,109,144,113,83,138,9,240,50,14,47,181,118,209,97,133,188,35,10,161,42,7,151,78,163,8,221,165,255,32,196,220,22,198,182,231,161,4,184,186,161,20,128,82,187,40,221,165,27,171,114,230,24,170,181,225,58,238,44,62,211,77,253,81,61,72,1,114,150,97,183,139,177,102,134,30,50,82,83,250,99,54,254,247,53,132,220,57,8,225,33,188,232,12,145,211,26,147,108,183,55,196,19,86,198,59,144,226,137,42,141,65,88,81,81,210,162,49,101,157,237,199,130,39,199,57,238,105,49,69,53,192,96,170,228,246,209,127,4,145,87,151,24,219,58,192,212,8,158,39,14,113,182,137,33,78,156,67,148,207,113,202,240,120,150,246,108,79,61,68,130,180,156,
24,180,247,187,161,229,176,9,196,161,89,2,222,44,129,95,129,24,252,208,74,8,252,6,130,12,1,134,130,32,68,160,38,176,152,113,19,192,10,81,19,144,44,138,47,57,88,104,158,241,121,57,24,248,24,74,72,9,188,64,64,33,33,135,40,128,188,0,66,0,226,137,145,193,103,27,66,96,130,135,164,73,216,161,185,139,110,104,14,97,144,176,77,0,197,240,77,64,42,197,234,113,202,213,16,219,216,16,219,131,248,66,183,9,184,22,134,23,42,16,192,216,230,155,0,141,97,134,84,0,144,72,83,56,86,156,130,76,248,41,231,106,61,197,1,84,124,150,0,69,65,147,154,138,212,109,141,151,163,24,67,147,107,171,32,97,155,29,135,62,235,116,83,111,122,61,252,34,235,151,161,238,21,44,139,200,111,145,246,124,151,159,8,49,124,147,8,49,220,103,224,47,98,184,108,67,83,207,252,0,186,66,0,84,192,84,0,68,126,10,128,41,182,7,241,28,137,76,243,23,25,39,224,219,240,159,250,133,54,199,20,169,95,84,16,161,77,2,116,138,3,26,147,200,8,80,41,10,210,248,60,142,131,124,83,211,4,48,179,62,223,241,124,249,167,86,190,113,83,204,23,47,16,120,144,191,
69,64,183,208,127,164,64,32,80,96,249,67,33,147,84,1,202,1,82,132,19,239,228,220,21,130,10,109,10,182,200,50,133,70,153,66,167,4,62,137,211,34,80,69,72,228,17,2,184,133,124,77,155,0,238,21,164,42,100,154,40,36,58,25,3,63,71,96,97,123,101,81,80,90,36,136,8,5,29,120,20,46,204,191,2,189,189,192,70,161,146,68,30,145,66,8,222,40,68,178,23,189,192,136,252,34,200,207,82,161,165,4,85,82,224,36,208,18,24,76,193,189,0,63,11,184,8,7,144,26,79,174,19,184,202,167,221,228,122,167,87,8,81,136,88,20,34,145,21,10,17,35,63,10,17,236,55,78,160,52,133,74,158,54,9,38,14,255,166,16,41,163,223,18,1,191,140,189,112,204,16,103,219,27,231,0,54,197,177,137,41,68,176,47,237,16,84,144,210,143,14,165,63,236,27,251,53,9,140,66,71,5,129,93,188,229,209,135,63,131,175,66,72,5,116,129,66,68,9,59,139,62,85,216,32,255,84,30,253,144,128,109,147,144,209,63,242,177,241,15,195,223,28,243,243,4,43,149,35,97,169,160,230,1,64,138,192,24,47,38,234,41,37,220,92,135,151,64,87,8,188,20,170,42,152,227,28,40,218,249,168,55,78,
33,153,98,67,16,103,253,33,228,29,231,157,6,5,206,16,240,33,173,175,220,142,44,154,221,208,98,18,217,170,128,160,0,88,65,95,42,196,212,102,253,248,169,41,48,76,65,99,10,8,226,67,129,66,10,123,11,21,24,215,122,28,10,24,228,27,98,253,20,66,216,139,95,192,44,159,33,150,136,95,10,36,37,10,14,250,204,252,5,47,222,124,105,47,131,143,189,132,74,196,15,225,227,31,166,128,89,4,31,255,18,190,153,143,13,141,41,152,84,128,105,253,242,111,217,119,145,2,6,126,149,24,67,20,194,86,41,225,21,56,108,96,226,229,35,196,20,79,191,41,146,98,74,27,142,18,133,162,10,6,227,223,251,145,47,242,135,255,47,27,138,50,254,39,249,228,40,160,114,248,55,79,196,189,13,9,246,129,190,82,36,110,51,190,66,252,64,190,41,228,103,244,79,1,22,95,57,140,254,177,31,249,119,22,124,142,249,82,217,187,94,65,178,76,1,35,125,47,247,176,25,98,220,216,7,227,218,144,8,126,229,138,107,43,30,172,16,31,76,129,132,253,152,2,137,248,99,218,232,203,20,206,200,95,246,148,61,7,109,214,67,124,54,246,131,254,226,232,207,222,179,207,101,252,
159,13,99,124,97,192,196,215,72,241,2,254,79,154,43,246,120,27,82,54,68,20,32,108,74,253,141,204,180,82,10,27,137,233,16,177,1,127,52,27,74,252,31,249,89,36,238,136,252,157,248,168,141,140,133,252,34,139,20,46,28,43,89,200,47,201,113,70,132,194,34,82,160,112,89,194,127,53,190,23,63,216,176,26,124,10,1,139,196,31,41,128,47,250,248,15,27,83,67,63,201,113,68,4,253,155,248,177,74,252,64,62,17,244,31,65,255,22,242,177,176,255,8,27,212,8,243,203,62,204,70,7,253,68,100,175,154,31,125,69,240,207,136,67,10,92,196,255,85,40,229,41,92,242,196,11,236,67,246,156,34,54,164,176,135,120,137,120,172,252,199,3,168,56,79,112,83,188,3,101,171,208,224,64,222,248,95,1,253,114,44,22,231,152,46,53,179,143,24,142,189,72,254,139,200,127,145,84,47,123,34,94,166,222,161,127,30,96,165,222,161,127,217,227,50,248,196,75,27,253,197,225,199,243,111,228,207,3,26,83,112,230,183,178,32,211,81,168,182,26,143,179,115,33,172,21,141,229,34,117,107,156,114,115,252,162,107,143,31,118,173,241,30,111,188,96,123,227,133,
243,117,107,146,241,183,28,113,76,2,207,35,43,139,35,1,123,249,6,171,167,189,140,196,120,100,103,191,161,52,157,60,232,218,188,181,102,235,72,98,25,120,182,220,246,188,39,113,59,183,196,92,72,44,255,192,104,192,94,14,131,43,13,119,121,237,124,55,247,108,133,242,103,234,22,18,178,121,103,196,154,61,224,218,60,83,151,198,108,34,140,197,35,29,89,152,142,44,236,183,140,207,137,159,132,137,240,102,61,108,65,108,182,146,22,25,212,126,117,213,181,95,161,97,30,225,73,194,22,21,130,69,134,182,11,237,224,146,1,120,139,198,154,33,226,113,16,174,8,96,231,187,208,238,49,232,179,94,14,176,236,87,140,191,131,254,43,232,155,249,193,103,107,106,231,99,28,183,48,62,69,105,61,77,123,170,207,88,156,77,133,98,19,17,44,182,56,182,142,92,178,200,39,123,200,181,23,110,212,45,52,98,243,12,159,126,215,90,164,244,70,62,54,7,88,22,7,88,54,25,68,22,107,163,65,139,119,56,184,114,92,67,123,154,113,14,166,237,233,123,140,65,15,15,181,86,52,142,124,145,143,197,65,191,197,145,142,205,91,60,202,112,54,30,104,201,
3,177,0,27,254,173,185,118,228,3,60,7,112,202,208,86,137,245,41,67,240,76,223,230,224,221,226,157,4,139,35,37,123,46,90,207,224,209,22,22,40,249,103,178,151,189,245,83,1,89,239,224,111,174,27,217,161,111,135,245,225,161,86,129,245,72,63,120,16,145,3,29,201,67,2,245,76,142,234,144,35,151,12,242,183,57,146,177,102,192,159,1,255,181,143,143,7,217,101,182,10,108,253,141,252,120,75,201,198,3,172,233,222,122,6,15,36,114,26,123,203,172,94,197,22,105,27,254,89,255,248,29,147,145,109,50,134,77,198,176,240,16,35,31,34,168,153,127,1,124,34,128,181,140,61,99,111,153,37,244,47,251,152,193,3,231,152,127,6,254,248,84,132,240,115,156,83,198,234,69,86,162,227,126,42,87,155,218,151,170,22,59,231,64,238,15,67,47,24,153,192,165,33,90,62,239,133,13,194,126,4,183,180,230,219,221,200,76,3,138,187,235,165,125,132,18,41,83,54,104,191,36,165,251,139,142,44,16,230,20,6,138,40,81,251,179,34,231,106,26,95,36,12,17,182,34,48,237,157,191,112,14,86,162,236,89,107,247,202,138,101,132,182,204,254,104,254,14,248,
40,137,180,101,206,1,9,155,50,154,8,97,35,34,161,113,78,165,50,40,185,193,57,31,97,61,201,169,177,140,44,50,79,153,194,139,43,145,121,232,99,20,86,81,231,122,40,173,200,254,17,35,179,246,232,231,238,212,147,162,231,116,16,182,46,184,201,249,51,30,60,97,211,194,41,35,43,18,154,251,130,201,251,37,25,158,103,177,3,176,203,110,27,58,96,159,83,166,218,183,202,71,247,132,182,79,242,196,212,180,243,32,216,37,121,97,53,201,211,199,104,169,179,30,37,52,36,39,47,187,209,73,130,251,100,79,61,138,41,39,215,82,140,31,118,163,203,23,234,81,158,121,37,159,126,227,38,159,54,185,81,158,214,42,24,71,179,29,110,148,226,58,201,11,181,73,92,57,202,211,220,228,155,63,140,23,83,110,180,8,189,213,246,122,18,83,137,78,183,187,209,233,195,110,114,60,85,79,98,218,81,138,255,40,167,121,73,76,55,137,41,70,231,206,184,81,76,33,249,186,215,163,191,146,112,163,156,22,38,87,111,212,147,175,24,127,119,217,77,190,58,228,70,223,129,143,148,162,20,199,81,138,179,36,197,79,146,208,24,125,7,253,119,180,49,69,195,31,
166,26,45,29,53,243,71,75,61,220,227,82,58,37,101,183,171,221,181,157,35,40,203,69,49,113,19,162,120,118,148,209,184,9,113,77,184,8,70,56,69,123,226,164,107,77,112,234,48,117,139,49,92,140,36,105,115,170,107,229,111,122,46,34,107,145,139,82,4,24,23,93,33,4,225,226,25,222,194,176,88,183,189,231,66,227,189,104,150,118,190,131,240,132,117,144,228,45,222,98,176,103,58,8,127,251,113,1,171,158,97,211,98,241,218,154,66,70,102,225,98,221,66,46,246,20,214,249,26,250,60,5,55,33,110,5,23,91,97,19,163,249,39,192,159,195,154,224,209,158,235,168,103,112,41,139,34,217,226,68,46,51,119,174,158,121,10,61,60,194,126,135,73,188,107,113,105,227,238,190,171,102,5,7,221,44,161,2,253,218,178,202,183,20,39,243,132,114,138,193,140,198,87,142,176,14,146,189,198,159,147,220,223,2,255,188,203,75,45,20,155,54,197,166,66,169,9,197,19,103,92,123,34,72,56,98,157,216,87,102,169,19,57,127,133,171,95,245,198,95,126,227,218,47,89,247,187,1,76,19,122,69,228,80,100,243,76,177,110,67,223,66,191,208,33,212,131,175,
80,197,179,29,171,8,207,89,240,37,183,61,57,46,247,146,42,88,87,145,83,65,248,183,56,245,212,233,182,61,119,10,25,180,16,206,51,200,17,122,156,94,171,24,201,44,92,71,198,180,231,207,33,99,248,195,43,85,108,216,101,82,105,153,84,64,49,106,232,83,108,153,208,15,253,140,188,176,132,94,240,250,76,174,195,27,39,21,216,60,19,86,177,97,66,53,94,105,179,89,180,28,244,96,82,7,244,23,208,139,236,64,243,113,234,98,230,71,175,94,106,32,106,40,244,47,167,204,105,148,78,223,109,78,89,117,26,167,83,30,155,211,44,211,230,52,222,172,255,45,243,179,217,203,188,229,212,67,235,161,56,178,121,219,199,162,56,86,49,105,240,25,183,202,74,245,224,175,176,30,157,238,19,53,140,29,152,205,208,121,236,224,162,7,79,42,208,169,175,173,205,22,250,137,240,204,49,146,231,241,70,9,249,49,127,164,192,211,7,78,113,176,31,14,10,104,147,42,146,206,1,54,104,172,95,227,47,143,185,145,151,148,30,133,7,94,20,34,34,113,208,64,20,226,148,139,40,103,113,186,111,78,165,73,189,230,148,139,23,90,77,177,165,205,158,240,225,207,
20,99,108,46,77,177,199,233,159,217,236,177,126,179,217,228,180,206,226,148,40,82,184,235,159,50,17,181,85,108,242,76,209,20,139,200,135,232,200,250,136,154,58,149,42,99,95,122,26,193,250,205,41,151,57,101,163,120,44,233,233,72,3,5,31,155,73,157,186,171,216,195,222,172,210,25,214,170,205,33,250,99,253,150,78,242,40,173,44,54,99,178,119,187,116,154,54,235,103,51,164,195,134,204,36,254,128,126,51,147,196,9,233,83,197,41,197,176,61,195,184,236,183,128,31,202,254,202,126,41,102,228,15,62,167,128,25,149,86,156,38,90,197,147,110,102,158,84,137,125,120,81,157,184,131,125,16,253,137,3,248,15,155,49,75,155,43,217,183,241,235,35,216,23,248,242,227,28,250,167,20,203,204,161,127,225,243,142,129,77,214,176,200,74,210,159,141,126,89,7,243,221,246,226,2,155,41,155,205,148,197,235,112,166,20,32,43,218,58,213,103,51,166,226,223,98,51,96,83,154,89,217,94,226,63,242,225,109,181,168,158,42,112,88,17,197,190,146,188,222,26,37,238,36,231,66,245,40,240,61,235,196,79,224,121,171,199,203,7,51,228,7,82,
119,146,103,192,81,214,159,92,141,17,91,3,110,148,167,59,81,252,47,201,102,48,185,208,64,78,224,217,33,167,132,81,14,11,162,232,175,135,103,210,73,74,177,232,202,183,196,115,178,240,116,180,158,36,174,70,201,114,228,25,55,57,117,219,204,151,228,89,99,146,248,31,229,84,62,201,252,81,178,118,20,249,39,243,55,192,133,62,175,15,39,95,55,66,131,98,158,56,25,197,127,225,131,57,193,71,30,73,74,161,36,155,225,104,137,245,161,191,228,82,59,27,13,248,113,104,139,223,217,51,110,146,195,156,104,121,47,126,32,63,78,29,165,127,79,190,232,151,210,207,94,196,255,37,111,252,155,83,66,55,179,120,217,211,191,201,202,141,70,255,158,253,180,131,11,124,233,142,239,159,196,3,214,111,97,223,158,254,53,222,134,254,241,47,149,126,89,226,7,249,210,82,214,198,127,109,54,67,148,188,192,240,180,74,241,140,210,9,191,160,79,165,18,109,243,116,239,40,241,243,154,95,170,95,52,89,223,166,106,176,176,111,155,167,70,182,57,124,196,254,144,151,173,248,32,122,121,63,126,113,88,161,205,148,41,245,100,79,84,13,148,148,
208,96,62,228,163,195,48,47,126,17,159,140,189,177,126,252,203,158,3,95,109,14,195,180,25,204,204,81,106,170,20,158,193,158,102,224,127,30,123,147,253,27,123,39,30,40,254,96,63,54,31,12,216,188,3,96,177,89,204,40,175,82,213,88,228,255,204,108,183,23,239,216,172,89,28,214,216,248,175,109,14,139,240,119,74,81,91,246,43,249,240,130,189,177,79,228,99,228,207,83,41,139,205,122,102,49,234,229,7,191,42,83,126,48,91,5,252,203,139,255,240,175,120,189,194,252,138,167,194,151,255,241,52,192,226,176,200,248,159,248,89,102,28,253,155,248,173,248,193,41,181,173,205,34,241,194,203,31,60,233,227,245,110,249,135,167,63,242,71,177,1,124,230,23,189,25,242,176,182,34,243,3,200,79,250,66,158,146,63,235,55,241,89,249,5,255,177,208,143,225,223,108,101,14,195,127,135,55,62,195,250,85,106,203,127,169,26,61,253,1,79,213,233,213,5,208,51,117,1,248,42,245,121,26,98,21,208,127,22,253,171,74,84,254,89,57,10,125,244,141,126,190,248,255,28,242,51,117,197,31,240,165,191,5,226,243,2,235,231,157,11,139,183,170,
108,226,157,133,253,41,254,155,170,147,248,101,226,237,138,255,52,56,175,205,57,252,228,169,138,229,79,138,223,37,61,181,164,106,101,171,18,201,177,217,230,109,54,235,29,85,175,226,167,121,90,204,102,95,242,67,254,145,63,196,103,115,216,199,83,188,100,142,42,23,122,102,156,248,100,229,136,239,203,131,102,253,145,252,215,140,17,175,176,127,109,85,35,196,191,136,217,154,81,255,233,41,3,117,150,158,142,39,215,192,103,253,17,226,87,196,248,15,241,159,124,98,145,191,172,60,135,123,5,159,127,83,21,147,15,240,31,243,148,195,108,246,137,31,124,80,98,226,63,79,49,84,239,232,169,165,226,59,91,88,236,27,127,203,15,120,246,155,37,254,103,143,35,51,226,47,245,172,236,55,67,61,43,253,232,240,197,210,86,11,255,177,179,248,187,252,199,151,159,237,200,127,105,115,152,105,23,200,207,185,219,190,254,58,152,15,255,161,190,50,241,151,195,22,99,223,170,31,240,31,43,135,255,203,254,84,135,10,223,175,250,237,130,159,191,57,188,176,248,28,34,195,211,126,47,126,195,175,244,151,191,235,217,171,137,255,
212,47,89,226,189,242,63,79,234,77,188,167,30,54,246,187,140,126,151,101,255,232,15,250,182,252,131,250,195,66,62,138,239,201,245,14,14,66,137,151,249,164,217,101,68,121,90,103,234,109,234,163,40,244,146,111,46,81,207,19,223,89,143,137,199,108,13,77,188,229,112,195,212,223,28,198,67,7,29,131,175,248,142,127,71,23,57,92,153,246,158,26,71,121,90,23,149,254,114,228,7,252,39,57,31,102,7,3,189,121,198,137,175,81,236,51,74,188,72,46,178,223,208,56,254,21,165,190,74,178,21,52,252,241,249,135,242,79,50,107,121,249,101,150,113,182,234,201,89,248,129,191,40,245,25,121,12,250,236,103,176,143,36,187,186,36,254,25,93,185,235,213,255,28,230,68,203,240,195,59,126,38,31,16,63,146,139,172,151,167,149,38,254,190,165,166,127,75,253,163,248,43,255,90,68,222,140,219,224,103,180,53,55,71,25,205,110,230,29,250,83,252,144,127,207,34,63,118,125,70,31,60,37,55,250,100,253,166,254,131,62,121,4,26,126,252,224,221,32,43,167,248,79,253,41,127,212,86,152,173,190,149,165,254,67,254,178,23,61,229,183,121,122,
105,252,215,212,127,94,124,54,241,246,29,246,200,209,134,153,79,246,194,7,142,198,94,244,8,139,183,181,237,9,236,113,22,123,228,29,64,115,148,192,81,132,129,231,237,87,155,163,32,107,154,120,198,231,8,214,52,246,13,255,246,36,245,193,36,246,205,62,199,196,111,242,51,118,76,252,34,126,106,159,179,12,252,148,23,31,77,252,41,119,48,134,15,100,191,246,182,250,211,216,31,159,47,216,236,99,246,234,95,139,252,110,243,22,142,153,95,71,13,239,136,135,124,126,227,213,207,172,191,116,142,252,115,129,167,229,146,31,242,157,103,189,207,192,215,122,76,124,68,222,212,15,54,15,91,44,115,84,66,123,10,249,75,62,123,241,59,127,197,91,207,60,235,101,191,104,79,34,127,179,107,39,63,40,255,202,63,249,160,205,202,226,79,146,87,118,111,31,167,163,160,227,222,252,58,234,96,127,106,189,229,169,225,107,228,175,248,93,138,195,31,248,188,189,99,228,195,219,43,70,191,228,43,115,212,97,248,195,127,87,125,253,153,163,32,240,231,192,87,252,99,31,71,222,37,127,81,143,43,63,72,191,218,31,104,253,70,223,196,239,
44,251,7,30,150,152,250,223,248,55,240,203,119,189,249,87,168,95,217,223,218,60,204,50,241,197,28,149,248,248,216,183,149,37,255,240,240,45,147,35,254,19,223,117,170,97,115,234,96,205,223,245,236,133,195,116,83,255,45,251,251,23,30,158,113,200,111,242,187,177,167,189,252,190,204,254,194,228,7,246,71,138,183,236,111,76,189,110,226,23,241,147,122,209,196,115,243,86,10,241,153,195,79,141,39,231,56,117,144,255,81,127,202,95,34,212,23,196,93,100,174,250,27,126,204,62,211,171,191,69,223,171,239,137,71,208,247,226,119,132,248,77,124,224,109,99,51,110,242,135,236,11,124,233,207,236,79,152,207,212,223,138,247,208,7,94,245,183,217,127,240,246,16,167,43,212,167,216,59,245,69,132,248,105,177,255,137,80,191,120,111,221,208,214,83,114,229,43,201,31,250,230,173,21,242,175,119,88,172,252,117,208,248,191,153,95,241,127,153,248,207,195,34,139,250,195,46,18,47,139,251,161,129,191,72,95,38,190,99,127,170,127,204,126,171,157,88,73,252,92,224,168,76,245,255,158,254,102,208,159,244,111,252,27,248,61,
253,243,176,211,212,79,28,21,26,251,47,112,148,135,188,76,253,101,234,247,223,235,75,91,167,70,28,246,235,109,43,99,191,154,15,253,155,253,153,234,3,226,117,134,183,118,204,252,75,223,122,245,195,94,253,163,113,197,251,130,234,31,228,197,7,133,166,173,250,102,89,249,7,255,48,249,132,122,77,249,28,251,48,246,163,250,147,245,107,127,44,249,70,241,23,115,126,131,253,153,120,207,249,79,114,82,241,94,251,3,244,191,30,37,63,236,39,198,82,127,43,62,191,165,254,159,231,20,139,243,31,83,79,11,159,252,149,196,223,162,200,39,57,126,142,179,23,240,103,6,193,85,124,190,2,62,231,65,188,237,146,196,191,163,188,157,31,229,40,54,57,229,157,106,69,23,201,47,248,75,148,253,143,25,159,57,5,46,231,67,248,127,146,183,223,163,133,78,114,55,231,79,28,101,154,243,31,115,62,133,61,189,66,191,124,30,20,165,190,136,234,84,141,15,52,163,196,183,228,36,249,129,248,156,156,100,125,188,229,16,229,97,79,84,250,39,255,155,124,50,13,127,156,63,69,137,183,38,222,231,209,47,248,54,245,143,241,63,234,65,19,15,178,
196,31,229,123,242,151,78,5,77,254,54,254,200,56,15,107,76,253,170,248,81,32,254,83,31,155,163,78,236,199,158,67,254,170,175,231,238,123,241,195,224,99,63,58,42,149,253,176,191,49,245,195,76,159,231,255,236,87,77,253,173,250,79,248,236,175,128,3,198,175,255,246,240,57,255,48,246,105,242,19,241,147,113,147,207,77,254,215,252,60,28,166,190,179,22,208,47,249,209,98,63,100,226,103,142,245,229,56,7,202,131,175,243,149,189,250,83,245,179,234,95,228,103,226,87,153,250,92,241,147,119,196,201,59,196,80,230,231,29,115,207,191,137,95,19,196,31,115,84,140,61,189,134,62,251,95,19,255,121,152,101,248,95,129,127,228,101,155,252,231,199,47,244,111,81,31,152,163,106,246,143,102,253,11,200,143,253,145,205,249,211,109,213,79,38,126,54,186,183,177,191,219,146,15,241,245,182,217,95,80,191,83,255,89,60,76,55,231,31,188,245,150,81,126,48,252,177,31,230,157,98,51,191,234,127,242,143,197,195,52,19,191,201,47,54,239,244,91,179,156,47,232,156,142,135,145,38,191,41,191,98,191,54,254,109,179,191,180,84,127,
112,126,153,169,132,136,13,208,227,107,173,12,242,73,34,255,204,91,236,115,6,249,49,127,146,253,47,118,236,102,52,255,75,218,188,179,156,124,199,209,249,75,234,43,197,71,252,51,147,199,190,150,24,71,94,73,242,71,102,66,245,73,143,209,127,114,9,255,89,58,136,254,195,156,37,48,206,163,140,228,204,126,206,19,148,31,217,127,195,111,114,30,251,226,252,44,67,253,228,237,95,217,111,76,83,255,193,95,18,249,101,86,169,143,242,62,62,231,155,102,126,242,159,25,103,255,109,198,177,47,195,255,180,248,135,159,105,248,19,254,186,240,105,175,223,52,245,172,252,55,195,57,99,146,71,41,25,252,43,185,22,102,237,251,136,207,49,83,239,36,103,225,143,175,133,50,239,210,245,94,225,243,238,115,146,119,200,123,169,159,50,232,63,57,193,249,238,4,227,175,239,121,244,57,159,72,82,207,103,52,174,245,189,163,254,226,252,46,51,137,255,16,239,146,156,15,39,179,60,170,224,115,219,204,47,180,95,177,255,230,107,154,204,47,131,38,62,38,121,180,69,29,199,250,187,224,15,126,76,253,198,56,47,83,100,176,159,228,26,248,
107,180,241,111,197,211,228,70,156,19,116,228,67,61,153,121,1,252,155,139,110,230,5,235,227,235,31,51,190,68,125,201,215,96,25,234,193,36,250,215,249,99,18,255,206,240,53,143,226,121,146,250,33,57,191,143,120,78,253,136,255,70,249,169,67,146,203,81,10,194,63,183,208,130,98,126,153,198,87,96,121,25,40,234,12,211,38,162,56,199,234,81,78,114,147,79,161,240,180,205,141,242,61,159,190,111,139,242,240,45,74,4,214,9,73,146,10,39,202,7,210,201,103,84,152,120,216,222,9,180,44,44,90,98,28,11,143,190,37,2,177,3,212,9,186,222,174,142,150,57,33,231,4,163,135,10,195,156,176,191,209,9,58,17,244,237,128,23,97,215,186,24,215,123,159,215,137,110,192,179,2,115,98,142,5,152,19,22,42,148,40,239,179,241,97,98,61,137,132,163,68,160,228,47,204,71,132,208,235,18,81,78,32,147,68,132,40,175,43,36,177,240,40,17,32,202,252,73,248,139,114,226,208,131,5,232,251,172,40,15,107,162,178,64,241,247,150,246,244,160,55,191,209,16,244,202,68,96,34,84,148,19,82,115,194,178,192,87,2,138,208,188,158,17,45,31,229,155,
191,176,183,3,64,131,81,158,187,36,177,96,118,126,68,93,52,192,9,86,148,19,28,19,225,197,31,31,88,139,63,125,213,17,93,233,160,90,223,207,99,9,230,151,7,97,193,209,9,225,115,162,67,132,226,100,10,217,195,15,59,108,147,161,120,174,2,31,100,40,239,171,144,40,15,243,180,99,233,81,6,147,7,243,4,193,156,32,105,125,202,96,198,66,149,193,160,79,133,242,101,156,10,196,200,143,8,26,45,241,212,132,15,150,205,9,22,15,179,146,115,251,200,138,68,88,248,179,121,29,192,102,220,98,199,96,50,4,21,131,78,4,236,108,159,23,97,205,9,47,22,71,5,101,78,0,120,15,205,94,0,94,59,90,42,36,155,29,164,93,60,64,21,77,197,168,10,46,119,154,136,124,132,44,140,133,43,163,144,193,189,10,1,124,83,1,243,48,76,39,80,83,218,33,11,159,83,253,162,118,40,126,134,224,4,203,230,39,59,172,57,230,23,62,239,241,169,2,202,240,147,18,102,135,194,235,48,54,30,108,45,14,120,21,54,21,21,145,30,124,191,194,209,14,212,156,0,245,123,248,188,207,105,78,168,121,31,210,156,192,168,194,103,7,110,75,255,120,144,108,168,107,242,152,219,
197,55,113,81,69,58,222,27,55,114,213,147,24,60,93,39,109,250,105,132,40,59,19,118,88,230,235,40,99,231,43,216,25,15,121,147,100,138,36,95,29,68,57,169,138,242,56,47,201,215,37,102,156,74,76,126,147,156,25,240,244,64,36,239,209,147,40,30,219,155,39,65,147,188,162,243,186,129,167,81,195,248,17,248,188,102,96,252,136,147,102,179,211,228,73,64,20,59,72,242,80,210,248,17,95,175,68,217,121,245,172,222,242,244,108,78,250,244,228,234,14,118,142,222,151,208,51,59,243,228,18,59,69,217,1,223,165,38,103,225,159,157,184,214,211,195,73,135,190,214,138,82,9,154,74,129,83,252,36,122,140,230,135,253,15,237,249,186,139,239,88,245,161,189,249,42,131,157,154,249,42,131,72,99,190,218,88,237,224,43,139,125,124,49,208,101,190,138,232,36,19,198,230,14,240,245,14,95,73,144,41,58,23,24,231,33,113,140,157,118,39,153,200,251,250,140,175,145,168,84,245,29,96,39,95,47,233,43,141,196,26,227,200,60,54,247,13,248,140,103,239,99,135,60,105,114,198,188,138,206,84,44,156,0,112,194,104,236,201,156,80,98,143,156,
24,155,12,255,22,253,225,191,246,219,97,47,67,234,9,131,57,161,194,62,240,111,235,29,246,51,141,125,188,187,207,56,25,159,159,52,177,120,9,80,39,24,38,67,206,242,96,93,39,100,243,200,93,17,178,248,11,58,225,9,154,243,231,191,242,74,70,199,125,70,11,143,114,234,19,245,91,128,244,225,38,61,252,170,148,203,111,228,226,135,1,247,150,195,155,11,252,110,7,159,123,132,249,186,67,31,11,70,235,9,158,252,134,41,55,194,188,108,155,88,138,251,31,51,242,169,141,249,152,145,79,109,8,110,97,182,171,97,202,179,196,100,175,247,251,31,164,103,126,5,128,207,105,146,245,48,66,75,240,123,38,9,126,221,33,204,241,132,249,186,157,199,151,93,164,127,243,251,35,132,247,196,235,51,110,226,53,159,242,80,30,75,41,225,53,253,222,136,126,159,132,223,167,97,60,204,246,52,193,39,119,97,182,103,230,99,204,85,62,213,65,105,93,27,40,145,224,22,230,147,179,48,233,35,65,112,210,175,15,132,73,191,250,36,44,204,187,82,97,156,45,65,249,149,192,200,194,185,123,230,107,248,46,248,235,170,64,127,253,134,247,177,231,252,
25,120,211,199,158,119,60,124,142,175,245,177,103,162,194,252,28,39,132,49,138,4,229,67,152,119,61,204,167,70,40,51,156,63,201,167,70,29,204,143,188,8,126,97,62,169,210,252,102,62,210,103,34,219,204,124,124,106,68,242,72,76,93,114,195,51,124,252,203,113,121,23,201,35,188,6,125,30,207,118,241,123,68,230,99,83,202,203,240,92,51,243,179,30,202,193,240,210,69,214,211,6,13,228,139,242,195,148,223,225,233,67,140,167,189,175,251,9,254,97,62,5,234,226,247,94,204,250,9,174,97,140,46,49,151,249,242,49,106,152,245,39,54,186,188,113,222,69,51,159,50,49,110,62,117,226,99,105,243,169,212,250,45,239,83,42,62,211,138,225,104,56,136,155,96,155,16,94,229,211,71,146,36,199,255,38,201,196,244,209,55,114,140,233,163,115,142,105,249,117,12,239,211,63,232,164,209,147,62,105,226,99,111,62,219,226,83,185,89,158,85,43,73,176,206,24,239,224,245,80,6,233,99,210,30,202,252,24,143,67,123,102,91,204,167,101,123,159,14,26,124,125,20,47,30,120,67,38,54,206,99,7,126,213,196,124,250,134,156,122,144,83,140,143,
106,204,167,135,36,49,62,158,231,243,181,219,254,167,135,154,159,143,224,145,179,249,244,146,36,22,155,33,169,242,17,139,62,250,238,89,111,39,193,159,128,95,126,229,67,31,201,155,143,156,245,73,217,222,71,225,194,215,122,244,105,222,121,248,188,239,255,254,77,187,247,49,47,78,143,221,160,127,228,207,241,82,130,227,33,243,235,10,252,94,79,87,229,0,114,66,254,216,119,120,150,113,142,115,18,28,47,37,144,91,120,21,249,42,40,32,95,131,207,113,96,152,119,205,18,60,62,50,246,11,76,98,238,60,250,226,43,42,126,7,169,107,131,79,218,8,30,9,244,152,224,152,41,204,182,140,79,193,160,131,221,80,198,37,54,160,67,48,13,235,83,67,138,18,253,46,143,241,35,222,40,145,94,187,248,136,40,65,208,15,19,12,185,50,87,6,62,104,243,59,75,9,126,245,195,252,78,143,232,243,216,157,79,227,160,143,157,160,159,174,141,14,230,150,190,241,83,253,106,3,239,12,115,197,238,240,35,236,48,189,198,207,214,80,132,164,249,213,11,125,82,151,230,216,44,157,35,88,114,172,168,95,137,73,240,43,36,9,182,137,105,253,142,20,73,
60,61,121,213,77,179,13,77,80,36,25,120,228,160,79,236,210,124,210,150,192,15,210,4,177,52,111,188,36,72,46,90,159,126,183,42,193,167,145,250,244,86,118,156,102,253,105,99,199,208,151,140,40,66,18,252,10,75,154,143,160,205,248,210,55,200,7,248,37,173,15,248,13,125,58,169,249,241,99,209,39,248,38,216,134,164,177,243,4,235,77,179,205,77,112,236,154,150,60,209,83,26,191,74,243,73,94,98,158,207,196,8,222,250,228,48,129,125,233,119,147,18,20,137,105,202,232,180,244,56,238,125,2,152,86,28,34,238,165,245,171,40,226,143,228,33,253,164,73,218,134,62,201,35,45,253,136,62,113,42,77,28,226,215,103,136,85,172,15,125,164,249,157,47,125,26,154,230,229,145,180,226,192,4,58,159,128,30,199,164,178,139,180,228,163,31,37,64,62,105,252,35,193,54,56,193,107,28,105,142,73,205,39,119,235,49,214,135,190,120,76,109,226,236,92,167,231,231,147,41,255,147,199,132,231,199,108,115,180,254,176,89,63,113,84,31,181,179,190,4,252,37,240,191,48,227,198,190,216,38,37,40,242,194,20,3,222,39,145,124,114,136,157,134,
249,52,218,208,39,174,36,38,249,29,39,142,125,18,20,7,233,117,228,111,244,3,125,248,51,242,165,72,73,207,221,243,244,199,71,253,102,92,240,228,129,244,235,111,220,52,191,18,148,152,28,240,228,187,218,206,218,176,123,141,83,36,166,199,89,31,219,144,244,56,248,178,39,99,31,45,192,64,95,227,175,52,142,60,94,249,235,95,123,206,218,249,33,187,181,218,5,18,131,187,70,86,232,168,119,235,21,163,52,167,255,221,142,27,199,127,91,136,217,188,149,175,96,205,208,49,186,219,208,172,123,194,168,53,204,95,70,128,198,33,62,28,4,43,81,105,228,235,65,222,71,74,84,246,35,97,183,200,208,117,13,29,163,187,77,83,32,112,167,85,175,228,243,83,28,206,97,60,164,122,10,23,9,82,51,67,80,191,151,23,171,128,21,227,235,139,46,167,122,6,207,107,162,140,226,77,254,158,13,84,202,111,61,131,222,38,54,206,194,198,65,184,116,239,50,105,245,165,9,51,137,202,214,105,79,175,124,128,17,38,110,38,244,17,36,219,247,48,159,84,43,31,36,248,36,219,203,111,248,245,234,113,38,110,247,226,11,219,231,4,199,45,97,182,191,230,215,
92,204,175,189,16,127,228,23,202,15,178,75,94,99,9,83,212,24,124,138,231,48,113,186,75,126,161,113,142,191,195,224,39,40,186,76,126,34,174,98,255,192,120,126,27,230,199,78,194,20,175,137,183,224,155,252,169,184,114,128,24,231,211,55,241,141,241,105,86,131,222,148,191,204,167,179,60,30,198,158,234,97,226,114,130,252,22,102,115,209,165,250,129,199,19,38,174,241,174,59,121,31,187,36,174,80,188,38,56,62,50,249,125,47,62,242,145,138,177,91,126,143,14,190,160,129,93,155,249,193,231,241,122,23,219,123,217,69,152,205,71,24,191,79,76,224,87,216,117,24,187,86,254,79,200,47,177,203,176,228,195,241,145,228,243,123,125,208,198,250,175,123,245,139,225,31,63,93,242,241,101,183,228,79,217,185,241,11,30,127,38,56,158,12,243,120,200,196,85,195,63,248,124,75,96,232,115,188,151,152,69,222,60,30,255,125,253,172,151,31,95,48,159,18,103,241,27,94,207,8,175,162,31,248,235,98,251,30,230,199,60,186,120,87,221,248,177,137,99,248,33,245,148,126,124,131,223,13,195,96,200,155,108,255,189,79,117,201,171,196,
17,243,169,46,227,95,126,79,145,227,7,147,119,249,61,195,24,155,191,30,190,37,240,224,99,192,242,107,69,171,108,102,85,116,190,237,228,231,6,120,231,78,191,158,69,92,140,45,240,41,240,194,73,226,230,101,239,39,15,56,222,232,161,56,140,189,37,47,234,215,138,190,252,218,18,159,152,147,183,123,86,59,161,165,79,129,249,253,65,197,49,252,158,79,134,193,39,79,18,215,189,159,20,96,156,205,153,54,95,177,133,144,249,100,156,77,40,180,104,191,131,63,30,31,244,228,253,249,201,67,177,28,113,111,157,79,185,137,155,61,212,79,230,199,102,84,31,17,87,18,188,110,144,224,241,17,191,106,100,226,40,241,9,121,161,127,242,182,145,95,5,251,51,245,77,200,243,15,62,133,54,249,148,31,155,49,113,77,245,29,121,207,212,135,170,255,200,107,198,126,84,223,200,126,168,91,68,175,139,227,67,147,127,149,215,56,254,83,254,86,220,86,125,104,234,33,197,109,83,223,130,15,189,4,121,197,179,31,229,111,234,43,253,88,7,244,19,108,90,136,255,216,32,252,163,31,239,199,61,164,111,198,89,127,130,159,36,96,30,104,248,250,87,
94,22,255,28,255,152,249,55,200,187,196,121,253,216,135,137,123,250,49,25,229,69,241,167,188,194,241,159,201,107,60,126,55,121,145,245,155,184,202,230,220,228,85,142,103,76,222,196,63,77,222,129,190,201,107,162,175,184,76,221,147,38,174,39,102,89,31,155,247,116,158,188,68,29,144,208,38,7,255,243,242,26,235,159,34,239,41,238,26,255,61,72,94,35,175,8,159,199,19,9,234,182,180,54,53,202,155,242,143,44,113,89,121,229,37,237,113,242,26,199,195,137,151,140,203,62,246,232,243,184,213,240,199,241,84,154,205,75,2,251,48,248,108,138,76,221,128,125,38,94,1,255,134,113,14,71,18,28,255,154,249,245,169,187,236,99,227,178,71,255,21,227,175,68,255,54,244,225,159,250,57,157,221,143,141,32,31,229,229,151,223,186,233,151,65,242,50,252,107,126,94,111,75,240,184,62,205,227,217,196,11,218,207,208,207,11,218,207,224,199,140,119,49,206,239,33,242,248,61,77,252,72,188,190,196,254,226,152,155,158,136,121,254,152,139,225,139,7,224,1,251,210,254,229,143,121,85,251,143,60,121,149,227,167,46,226,23,117,189,
191,63,225,167,3,84,159,163,239,240,58,252,19,31,21,127,137,155,232,248,34,250,197,158,145,135,177,31,214,23,222,56,132,253,120,191,175,152,200,222,68,30,196,44,39,232,229,69,213,61,108,154,245,147,33,134,95,14,63,210,28,111,154,186,193,212,89,146,15,250,201,177,62,173,255,57,227,207,181,126,228,39,123,225,241,170,177,23,30,175,154,188,203,225,85,154,227,207,4,135,75,232,221,183,71,240,57,188,49,227,202,251,188,89,158,230,215,213,188,95,11,227,167,19,200,203,100,192,131,254,175,209,180,147,140,244,3,143,50,96,21,130,50,0,57,216,239,63,62,27,220,212,143,207,182,175,188,46,182,243,223,175,129,255,169,47,240,207,135,38,2,255,28,124,246,235,241,127,126,158,119,255,187,214,143,119,156,151,213,59,206,161,143,119,157,95,170,119,157,253,31,251,157,167,213,126,167,249,227,125,231,69,149,191,65,244,145,159,69,110,168,14,59,239,1,252,9,192,131,0,190,4,240,224,31,0,135,0,252,250,35,63,200,62,91,229,127,34,249,212,135,124,2,100,43,144,223,67,178,13,146,19,220,55,0,61,70,187,9,210,106,159,
134,250,93,218,45,140,255,196,88,128,190,43,180,123,185,78,50,219,73,238,31,126,204,56,135,160,245,227,71,54,193,213,140,51,93,189,5,156,237,196,63,222,250,33,90,189,245,67,174,106,59,143,63,14,56,153,234,128,115,30,58,83,208,110,132,214,247,208,14,126,28,97,41,35,78,227,199,49,167,122,169,58,230,60,3,240,25,128,135,0,124,10,208,17,128,31,1,216,6,224,93,0,47,127,212,79,247,87,71,157,113,86,242,51,28,52,178,26,173,89,156,189,6,169,17,142,94,250,156,118,112,111,179,246,246,143,195,149,35,44,255,28,247,39,170,252,8,56,112,65,218,143,192,209,138,127,1,110,63,125,189,220,159,253,200,47,48,51,105,107,245,161,243,152,137,3,244,79,194,148,56,30,128,177,179,224,184,139,32,184,205,176,52,14,75,251,193,120,2,116,147,218,31,135,156,38,250,158,131,213,80,229,231,175,193,74,128,49,15,194,99,174,54,215,14,168,255,2,108,19,212,127,230,254,40,240,223,113,47,14,158,1,163,153,34,192,245,176,58,247,34,75,115,152,96,153,9,218,185,70,184,106,226,41,144,46,112,141,113,61,0,145,55,16,136,114,237,134,
72,35,247,146,93,130,251,235,92,143,66,180,2,65,77,16,165,45,59,114,219,76,71,159,211,94,237,51,0,213,111,232,248,47,147,72,181,250,16,145,102,80,230,51,20,249,53,138,124,142,2,127,250,152,114,170,119,171,124,119,25,252,120,27,83,184,141,42,123,157,108,181,215,121,2,202,214,17,80,190,7,229,39,80,142,129,242,19,40,227,66,153,0,101,171,36,170,189,128,60,242,65,90,0,121,188,7,242,114,143,234,83,168,182,64,245,41,84,167,64,169,221,2,229,14,178,119,31,33,248,255,107,63,244,220,128,128,83,88,156,219,130,169,185,7,1,115,19,128,181,50,152,99,172,214,252,49,238,76,86,227,252,184,252,71,190,22,93,173,38,157,83,194,187,193,216,113,134,158,50,84,11,249,192,110,66,132,42,16,146,95,184,41,232,156,102,104,82,116,78,1,252,92,116,158,66,167,26,128,142,166,112,239,210,221,200,248,186,232,28,251,216,237,20,171,84,205,81,214,227,22,88,208,89,132,227,246,178,142,195,12,13,50,84,75,128,240,195,30,29,119,30,58,157,162,115,211,231,103,69,116,78,208,243,132,14,119,84,252,56,127,228,167,137,161,71,226,
39,3,29,179,174,187,226,167,113,143,31,155,177,131,12,185,15,33,244,235,65,102,205,50,107,203,199,52,26,228,171,129,42,191,224,12,91,131,176,245,16,174,242,152,212,214,79,152,212,118,7,56,21,80,90,62,118,57,93,80,108,172,118,225,95,73,231,46,243,165,160,185,129,166,182,22,209,230,118,140,30,163,162,204,71,94,153,15,86,123,4,243,227,133,106,234,199,30,70,182,194,0,111,183,65,173,0,181,131,80,139,65,169,21,138,9,168,13,3,209,13,128,123,0,114,219,87,33,183,149,133,197,89,159,197,94,88,108,128,197,56,44,14,195,98,55,44,186,141,226,81,30,189,29,250,24,223,112,170,241,141,163,226,17,170,45,62,85,241,56,8,213,69,241,56,33,30,83,244,72,107,238,0,60,78,195,162,43,21,87,179,226,237,25,119,110,7,119,1,192,159,2,221,206,76,207,152,105,156,107,181,139,155,234,53,248,176,224,225,144,196,127,1,241,95,194,28,20,38,171,17,110,198,141,121,221,129,5,153,217,29,103,130,235,121,174,179,92,183,126,2,245,30,168,77,66,205,248,154,123,204,72,53,6,136,60,73,160,81,174,39,185,78,250,109,145,168,207,125,
180,156,63,85,249,102,225,45,76,87,155,225,90,81,115,6,98,207,25,25,214,200,79,26,57,204,72,19,35,238,73,134,162,254,218,63,220,219,131,153,146,90,54,128,57,43,24,105,251,28,67,105,161,143,11,189,137,161,54,13,69,12,155,81,152,138,58,31,238,2,243,88,48,47,4,211,230,79,142,43,121,232,150,134,166,53,36,190,154,65,47,50,50,4,210,40,35,85,155,181,184,7,89,68,23,55,114,63,93,115,92,107,179,220,12,114,83,29,228,166,200,141,64,229,88,29,92,231,5,177,206,205,107,65,72,48,202,90,167,63,222,89,69,64,171,151,105,255,137,118,59,215,17,174,191,6,124,128,234,77,110,86,233,185,207,213,226,170,217,134,185,126,60,1,67,15,197,234,132,132,80,132,213,243,176,154,133,213,39,140,216,26,121,169,145,10,35,151,36,131,20,67,71,24,26,99,232,111,175,17,7,187,136,122,21,66,140,77,132,57,167,184,120,139,142,160,79,63,70,135,34,177,219,194,77,183,15,217,252,113,240,197,137,234,224,139,243,96,180,9,227,17,3,77,96,216,112,244,119,10,224,25,15,197,35,106,242,133,102,105,3,68,162,82,234,20,45,67,212,80,15,48,127,
2,106,23,68,77,200,39,0,125,182,71,173,87,176,2,25,97,184,17,48,247,44,61,29,10,139,45,180,82,202,237,49,146,89,147,122,186,233,57,34,50,103,128,217,126,65,178,116,143,147,44,45,110,30,114,189,192,117,156,107,109,141,155,7,220,84,239,9,36,192,93,148,155,97,174,33,174,47,185,18,75,248,75,62,2,185,36,144,54,127,72,84,218,233,120,205,181,86,225,230,103,129,8,201,109,242,65,6,124,16,77,244,241,13,204,140,194,75,1,238,148,62,37,73,119,132,14,73,172,1,87,87,130,147,228,112,93,79,27,238,73,64,91,62,14,190,217,95,29,124,115,9,20,35,193,11,160,200,43,239,10,116,22,80,137,69,68,81,199,59,212,241,238,2,144,70,29,81,6,78,51,80,164,227,39,9,39,132,112,206,210,225,94,163,71,5,79,22,136,106,150,100,248,144,100,88,0,228,22,16,95,209,38,136,82,24,124,236,67,131,125,142,187,66,207,45,58,16,62,127,134,5,16,149,13,176,217,135,22,248,51,25,2,201,211,51,224,19,201,236,65,92,161,227,36,40,89,58,30,145,146,221,118,242,113,135,56,185,66,207,37,17,233,6,164,9,66,63,65,228,13,118,249,30,179,252,32,211,
117,247,115,183,61,174,187,227,186,123,207,157,60,111,187,164,174,160,238,54,184,83,73,85,107,229,102,66,55,231,184,121,163,155,11,220,204,234,38,72,52,154,37,24,213,68,211,192,40,196,41,143,255,249,23,110,242,220,252,94,135,54,255,63,170,67,39,230,183,87,222,230,84,135,254,207,183,3,255,114,104,49,240,47,193,142,95,3,255,242,203,137,214,127,121,94,248,176,254,137,74,233,211,119,206,47,91,223,57,135,182,16,223,255,126,230,19,250,251,132,218,95,109,161,145,230,173,81,231,204,167,91,206,225,79,212,60,91,252,201,152,173,91,78,236,211,160,19,248,196,27,113,91,131,78,195,22,236,31,254,196,247,228,159,248,179,111,163,91,3,64,164,156,252,167,7,116,220,118,70,183,184,110,221,118,218,63,241,183,96,62,245,58,63,111,141,48,222,235,188,240,231,168,222,214,28,231,160,221,192,28,13,204,21,103,142,86,230,184,198,28,13,204,17,103,142,160,230,104,244,231,112,111,50,71,128,57,106,9,152,108,128,80,181,1,34,63,129,123,253,15,124,30,129,70,24,252,6,232,136,198,49,104,172,64,162,69,108,198,124,18,
110,59,60,54,192,235,49,248,59,9,111,17,248,109,133,223,67,180,27,13,191,189,204,69,81,198,52,1,166,219,62,200,84,243,76,229,30,130,78,195,167,239,57,33,219,13,244,53,237,94,184,125,120,247,23,251,240,238,173,158,224,238,186,213,180,251,83,172,105,183,59,178,127,235,123,208,7,156,131,187,43,215,155,119,227,151,155,118,151,46,52,237,142,157,109,218,13,159,108,218,61,124,188,105,183,169,181,105,247,218,209,166,221,3,71,154,118,39,155,154,118,247,29,12,238,54,236,107,218,13,4,6,118,223,28,108,218,61,212,210,180,59,242,117,211,110,203,249,166,221,175,46,29,222,61,126,253,240,110,247,141,166,221,159,153,99,35,221,180,251,242,118,211,238,157,59,192,223,253,63,126,134,163,231,76,230,62,252,68,149,184,133,121,246,194,241,4,204,22,224,243,39,88,169,181,178,220,89,150,231,126,255,169,207,121,189,133,157,223,0,233,9,72,27,8,225,25,139,175,73,62,111,69,229,79,80,153,21,149,54,168,60,214,146,79,64,102,68,100,250,32,51,36,50,223,65,102,84,100,250,192,146,238,221,102,232,124,47,58,103,63,221,
115,238,110,241,231,17,11,40,32,135,2,160,243,192,25,103,168,240,233,145,115,111,235,145,211,196,181,133,107,237,20,228,220,251,208,155,135,92,78,228,46,65,110,18,114,5,80,126,18,181,32,29,143,69,255,39,184,154,23,87,237,112,53,238,175,109,88,76,197,160,50,44,166,126,222,91,91,2,164,1,144,180,182,234,21,145,185,6,83,139,48,213,246,137,63,88,187,197,30,4,222,110,193,219,16,16,15,0,88,252,244,208,169,62,217,122,40,72,40,5,32,215,244,233,174,147,217,186,235,52,67,53,3,111,119,33,58,8,209,41,108,118,107,5,99,221,14,67,84,254,18,128,181,183,176,22,132,171,102,173,60,2,74,131,49,237,17,39,107,12,191,207,57,11,6,166,124,15,122,195,6,235,13,24,1,160,27,193,250,117,136,89,215,152,52,200,164,3,96,183,50,113,140,73,163,76,250,128,73,151,52,105,74,147,190,128,196,52,104,237,254,74,130,172,164,155,149,220,101,37,247,88,201,60,43,217,154,102,37,219,103,247,86,114,22,162,22,68,143,66,180,11,162,189,16,189,5,209,25,17,125,34,162,63,64,84,171,144,165,143,193,79,192,231,205,152,139,92,36,0,232,
168,89,201,16,131,40,42,109,48,188,181,111,237,131,159,160,65,193,81,186,241,181,102,102,144,214,228,173,19,70,16,183,156,251,248,101,128,201,186,96,84,17,226,22,204,54,179,228,113,218,205,180,171,143,104,4,232,116,179,120,111,128,101,101,88,86,0,239,13,126,202,224,189,252,181,186,173,140,115,133,105,134,76,228,26,117,126,52,156,18,185,78,195,118,51,157,41,58,14,19,202,46,210,110,160,157,228,62,64,223,9,191,45,132,6,250,190,249,210,166,48,160,111,235,21,51,202,36,82,254,140,205,204,216,192,140,127,197,140,25,102,76,65,172,5,36,121,67,64,177,82,51,182,208,57,232,83,188,236,183,175,249,51,158,252,195,12,10,164,167,129,149,112,31,51,174,25,255,211,28,141,163,116,190,240,9,84,191,165,33,99,186,79,135,166,56,79,91,83,134,124,128,175,184,215,154,126,241,103,216,131,223,163,184,253,39,34,213,105,5,213,125,62,165,231,96,54,3,93,189,230,163,138,116,27,29,103,125,128,164,63,213,81,198,3,244,189,240,73,127,227,143,255,192,120,144,190,218,34,202,22,111,162,24,68,215,213,83,190,246,251,105,
52,209,121,149,246,17,0,58,12,197,123,142,198,69,117,192,24,6,127,159,144,182,22,35,113,137,64,45,79,163,145,105,94,250,83,86,47,210,144,128,196,163,230,140,248,60,220,240,219,205,140,105,249,125,62,194,53,238,213,119,143,241,22,250,254,251,34,234,235,69,125,21,212,214,139,202,218,104,187,234,104,2,242,41,16,151,232,184,68,219,61,206,141,18,131,43,139,191,11,104,147,64,135,125,208,33,64,255,110,134,158,132,64,154,0,145,1,156,16,136,172,67,102,54,8,72,138,14,67,237,52,55,161,61,208,46,64,191,18,232,125,122,130,128,246,138,154,88,179,4,34,147,26,161,177,15,48,247,14,61,71,232,88,163,241,61,62,224,54,98,251,54,29,89,58,70,69,228,107,225,200,80,36,169,191,242,5,129,54,61,67,185,13,105,153,210,85,218,146,156,36,37,195,185,64,123,79,214,106,11,94,237,140,63,254,235,62,26,82,247,24,131,242,142,170,172,91,234,125,68,135,50,241,37,31,163,157,123,185,203,41,127,252,79,62,133,61,14,212,254,175,236,227,23,3,128,125,92,247,237,195,242,245,31,162,45,109,93,162,125,24,160,227,180,91,105,39,
104,159,160,125,133,182,56,240,102,192,62,28,26,226,241,213,30,143,90,213,49,58,99,116,104,213,73,218,65,218,151,104,43,130,202,93,68,225,14,109,57,156,164,34,139,124,202,125,35,125,31,31,33,81,91,2,109,67,196,99,52,206,73,9,231,233,145,129,12,3,226,78,209,219,37,144,131,128,60,165,209,34,16,41,183,21,16,105,221,125,185,71,69,170,28,101,88,225,215,189,0,200,37,225,208,49,139,42,149,236,198,105,191,164,253,90,0,50,183,19,208,144,57,184,243,62,100,145,184,170,140,125,158,184,234,94,33,156,55,2,222,76,180,60,65,148,108,39,73,185,239,24,189,69,103,5,200,94,160,78,208,118,101,142,65,160,7,5,177,64,207,0,29,75,64,116,3,113,90,16,81,58,90,233,152,160,99,26,25,228,144,193,40,237,37,218,63,11,192,242,39,115,109,104,200,180,7,224,239,239,178,220,52,124,122,204,70,99,183,253,110,112,183,113,32,184,251,190,251,224,214,99,138,152,98,252,32,16,7,119,79,69,155,119,79,221,84,161,19,164,232,105,218,253,182,247,200,238,171,59,71,40,66,182,242,123,216,151,41,139,130,187,189,25,15,115,35,37,204,
166,221,51,86,243,238,106,168,105,55,126,169,217,148,65,51,199,131,148,56,193,221,171,193,230,221,201,195,186,111,218,61,114,242,200,110,235,69,149,57,65,83,78,245,102,130,187,78,175,74,156,45,121,115,163,120,59,15,245,230,221,151,25,21,65,193,221,115,221,205,187,169,184,10,46,205,22,48,51,229,174,54,83,108,5,119,35,103,130,187,154,165,131,66,235,80,75,243,238,224,81,102,57,22,220,157,254,42,184,59,114,34,184,251,144,241,239,219,131,187,39,58,131,172,175,105,55,3,189,11,183,131,187,119,238,4,53,163,102,83,9,233,138,114,3,148,183,75,126,207,123,127,129,30,202,185,238,224,238,207,137,38,196,178,7,120,120,247,235,112,243,110,238,170,71,94,211,60,104,11,238,190,61,18,220,189,116,128,197,52,64,62,96,239,94,218,239,245,169,198,91,250,54,8,78,112,247,89,50,184,123,251,22,117,93,111,51,98,21,27,213,241,61,54,174,195,66,0,86,182,191,247,123,142,83,148,157,162,254,113,143,153,58,116,79,224,231,83,18,201,126,35,138,124,103,243,238,247,23,155,118,143,158,245,120,184,79,173,121,233,64,243,
238,221,64,51,60,156,131,135,35,187,234,11,33,142,155,240,240,4,81,252,108,84,27,68,181,193,61,30,166,247,120,184,193,252,205,18,197,93,191,231,43,120,104,132,135,65,99,49,175,239,201,42,60,221,149,186,36,22,73,54,4,59,158,45,156,142,121,182,208,125,163,121,55,223,217,180,107,93,11,82,26,123,98,186,121,225,200,110,203,55,199,141,230,212,103,88,1,255,27,232,121,165,174,209,138,220,205,216,65,12,86,218,96,229,111,127,161,39,0,59,211,52,26,232,252,125,19,116,48,160,77,208,82,238,221,235,69,115,24,255,191,180,5,254,114,232,231,192,95,130,147,191,182,254,229,249,251,125,127,121,190,241,97,254,183,239,198,2,191,61,29,107,248,237,249,152,107,111,127,55,214,176,253,156,127,79,199,182,71,127,27,102,132,142,223,158,140,213,203,191,61,30,171,117,109,63,30,107,221,30,30,187,245,219,40,189,127,226,254,187,177,173,51,127,105,56,240,215,61,219,163,99,109,62,124,219,246,159,198,62,76,1,22,248,237,7,192,158,142,125,181,253,100,172,182,8,149,198,237,31,232,28,29,107,1,183,17,220,22,166,169,77,
131,186,31,212,22,166,106,4,117,123,2,240,65,70,135,33,17,252,237,103,48,96,136,193,227,144,114,53,101,96,251,103,195,225,97,56,221,190,11,93,141,6,32,241,247,125,160,28,2,226,48,36,238,24,38,159,48,240,167,177,191,221,15,225,0,19,29,52,235,25,30,251,240,28,200,99,16,20,143,134,191,172,192,225,239,168,38,0,69,171,254,74,252,205,128,38,226,71,246,248,155,133,120,11,232,33,32,71,224,173,25,30,197,129,150,234,198,64,9,248,60,54,139,191,126,159,191,6,72,252,187,60,82,252,235,62,95,138,41,102,108,246,37,17,252,109,108,236,111,30,109,143,141,189,134,120,3,51,70,1,15,236,161,194,252,223,20,152,241,10,132,175,0,240,144,153,26,96,92,218,169,189,50,179,253,48,118,140,153,27,32,121,12,44,45,160,246,11,144,39,33,117,216,144,241,116,121,18,82,181,32,3,47,97,60,8,153,70,200,6,88,192,118,201,168,253,103,67,70,66,126,5,3,135,181,100,176,255,155,121,160,54,140,128,190,27,59,10,109,172,102,24,212,81,35,148,6,104,126,40,249,44,53,136,30,244,107,25,104,196,12,202,211,177,35,200,245,160,97,107,12,
22,225,224,45,16,135,64,111,96,197,167,255,192,222,113,177,55,5,169,175,126,235,103,16,161,139,212,45,72,29,101,117,87,183,251,33,51,12,9,173,240,187,177,21,250,155,12,165,225,177,255,248,227,111,47,24,248,158,129,31,199,198,182,127,132,252,247,12,190,24,91,162,191,145,190,0,99,15,233,111,162,63,64,255,228,31,250,171,237,166,243,199,177,32,3,213,255,109,28,45,53,128,34,165,254,253,0,147,220,69,99,158,20,31,141,125,72,108,63,162,227,137,89,122,0,200,15,105,32,174,65,185,5,190,79,34,202,15,87,176,207,107,240,123,18,180,19,134,206,99,140,247,187,177,127,56,11,228,48,157,95,253,246,200,44,226,67,6,90,15,52,27,244,52,219,135,243,64,92,21,45,160,78,51,224,217,255,216,216,135,20,146,26,132,150,231,37,63,143,253,195,9,32,71,128,250,218,8,3,190,46,66,235,17,116,90,64,147,116,62,36,129,184,1,45,241,116,4,251,250,208,9,141,239,197,15,252,9,226,31,238,0,97,67,227,164,81,1,52,210,208,120,8,141,166,61,26,93,64,116,65,227,48,248,50,147,15,221,208,24,246,101,211,8,157,15,89,32,2,208,56,4,148,
251,239,203,88,165,228,32,242,127,255,18,181,55,33,135,131,191,253,100,204,232,111,101,24,129,237,159,198,90,125,99,249,112,10,228,23,38,40,224,158,8,165,30,130,129,95,48,2,47,116,96,221,205,64,204,2,113,152,81,99,213,13,64,204,2,113,204,183,127,183,193,48,240,3,230,136,179,182,98,93,242,67,17,251,96,3,218,9,104,147,15,250,97,17,144,22,152,49,126,206,154,129,208,242,158,192,225,51,195,182,140,179,1,6,127,125,38,30,128,14,110,63,27,171,121,248,248,138,22,53,75,111,19,12,137,78,179,104,204,2,127,8,26,103,246,22,101,65,116,216,16,146,135,178,168,115,240,241,212,231,67,90,174,125,13,196,2,16,26,21,47,219,57,32,196,220,9,160,218,124,58,18,161,20,164,160,41,41,22,105,55,226,22,10,59,65,60,33,194,125,51,125,237,180,3,180,99,126,219,45,208,209,74,199,239,121,96,240,142,242,64,118,230,245,226,146,201,3,255,107,32,240,175,135,158,5,254,53,120,230,215,195,255,250,188,180,239,95,159,191,255,80,252,220,87,108,248,204,145,207,231,254,82,224,51,199,203,251,107,156,221,215,250,75,141,53,58,107,
125,69,247,183,210,103,246,199,159,251,203,129,207,131,206,245,26,123,248,26,137,167,214,95,238,254,60,60,79,223,59,198,158,159,174,245,63,111,173,113,95,27,158,79,127,30,92,11,124,30,6,190,191,24,174,13,174,53,214,250,139,244,151,19,159,135,151,129,95,160,127,33,82,235,95,104,172,13,46,52,212,134,151,233,47,208,255,190,1,22,194,204,28,168,113,95,27,46,208,191,40,120,250,231,161,179,0,141,69,104,205,91,134,31,146,30,244,35,134,23,241,212,95,140,155,121,251,179,204,77,63,87,51,247,112,209,162,31,216,85,241,116,2,62,78,208,15,252,106,242,243,96,94,176,240,179,114,186,198,181,54,152,167,127,101,216,163,47,126,138,39,13,239,131,239,91,89,119,234,243,48,180,251,197,211,50,235,93,68,14,203,71,106,195,217,219,222,90,225,103,208,57,9,63,167,106,108,47,152,39,254,121,152,57,7,151,161,179,116,178,54,188,10,237,37,230,88,126,240,121,24,81,83,181,3,31,2,190,177,54,92,98,204,129,127,214,58,188,196,152,89,175,214,138,28,150,18,192,194,167,224,223,195,59,255,204,122,29,248,95,1,94,252,47,33,
159,21,232,20,53,7,114,51,250,18,125,228,80,134,23,163,51,248,209,188,89,250,115,55,106,131,57,127,222,108,204,200,191,127,85,253,200,51,135,110,87,25,43,208,175,245,78,210,63,5,253,41,248,153,132,86,214,242,100,144,131,167,21,209,1,30,89,12,175,196,61,218,232,120,120,249,6,242,151,110,181,94,248,129,118,191,116,188,194,122,87,154,145,5,180,10,215,224,27,254,153,99,112,225,6,116,161,179,132,76,23,88,175,228,38,221,148,160,159,23,63,135,145,81,39,114,1,126,70,240,178,135,35,158,124,102,58,61,250,200,109,112,30,250,243,162,3,255,171,208,153,130,198,162,248,135,254,34,253,83,208,159,162,95,60,74,143,115,201,218,224,92,19,99,199,107,253,203,217,207,60,231,254,60,186,30,248,252,96,252,68,237,193,120,91,237,190,211,90,27,93,239,248,124,31,25,143,46,70,106,163,172,243,62,246,100,224,42,224,163,211,65,120,125,48,211,80,123,48,115,179,54,90,9,128,19,101,28,248,60,243,210,63,56,3,30,107,184,239,8,143,126,236,202,195,235,164,175,161,54,250,158,126,209,95,185,84,27,93,57,0,125,219,131,19,
253,181,175,177,213,211,208,109,4,54,246,249,126,1,254,230,174,212,70,231,160,87,184,237,193,173,67,111,153,121,150,79,194,107,43,112,221,159,239,227,123,163,75,192,97,111,252,149,110,31,14,122,235,192,173,135,128,19,63,93,94,63,122,148,31,74,166,163,216,196,23,62,69,87,107,123,201,218,94,162,199,85,214,103,240,88,31,33,99,84,242,51,242,148,92,160,103,228,194,188,248,218,224,28,244,230,58,107,163,107,222,60,92,205,92,131,210,47,182,10,12,243,36,141,93,203,143,135,151,195,216,10,241,0,95,232,119,110,152,88,96,108,175,220,129,253,130,163,120,144,237,193,158,209,27,240,253,248,25,79,150,176,107,248,98,29,166,31,91,234,47,225,123,37,250,229,103,242,15,193,195,107,127,57,130,111,64,27,95,24,68,142,253,244,13,34,223,225,197,83,181,193,10,180,23,207,225,231,55,232,103,77,194,41,156,194,254,219,128,197,102,138,221,38,52,26,62,151,232,95,194,7,213,95,130,127,252,201,244,103,163,198,126,189,254,155,244,67,95,116,150,136,43,134,151,43,192,95,53,125,194,25,94,97,189,43,162,193,218,176,11,
3,139,95,114,226,0,157,22,250,14,178,62,241,143,108,86,240,193,242,53,35,135,225,149,125,140,177,94,108,116,88,235,45,119,122,254,189,212,44,189,178,38,201,82,240,151,233,199,7,150,233,175,68,61,91,151,15,46,223,148,189,178,94,226,196,114,236,51,135,181,159,123,241,155,33,226,80,47,62,195,17,103,173,207,73,124,238,163,207,244,175,70,106,67,192,247,46,181,214,250,150,174,146,42,232,39,230,15,57,151,128,61,94,235,37,62,245,21,59,63,247,177,166,33,108,179,119,254,20,125,39,106,67,5,232,32,31,62,34,1,150,254,101,232,96,235,204,87,235,101,94,198,63,247,178,222,190,210,77,224,160,143,239,15,21,226,192,6,188,57,178,55,77,31,243,129,7,60,107,234,197,222,250,86,98,53,174,181,33,236,157,123,236,156,245,98,163,60,145,197,223,101,235,13,181,59,200,77,49,81,62,197,195,106,218,178,77,100,65,126,224,222,216,225,48,118,114,223,105,97,12,223,47,37,62,223,193,22,228,211,195,165,235,181,59,149,253,244,201,110,147,6,94,246,195,31,144,7,246,32,125,162,3,60,176,242,229,225,210,101,159,198,239,240,
242,141,225,101,193,67,7,155,150,95,8,94,246,124,127,245,116,237,254,106,171,161,53,156,237,66,223,13,159,51,162,67,28,149,61,112,143,222,177,31,116,165,248,148,41,198,106,25,229,78,197,174,213,248,231,140,114,170,104,173,70,129,3,158,245,14,175,222,52,52,100,187,195,75,49,99,111,253,172,55,35,58,244,101,196,79,9,251,100,77,166,191,24,53,116,76,76,38,190,138,134,178,253,240,170,252,2,26,200,147,51,224,207,67,207,26,106,67,207,44,232,104,12,152,226,117,232,104,126,141,159,166,95,62,40,89,185,71,63,115,78,254,249,59,20,58,198,149,231,214,148,16,39,107,220,215,120,164,84,251,46,27,254,60,2,226,119,36,171,49,22,208,227,124,91,227,90,27,41,157,5,142,241,149,43,244,5,160,209,240,249,59,224,248,91,238,224,54,130,123,148,241,163,181,239,74,29,95,198,69,255,187,229,111,60,186,36,151,49,148,200,31,103,252,50,254,29,206,50,230,116,27,124,238,129,11,48,126,253,247,113,12,143,191,46,111,120,251,174,112,194,31,191,225,141,99,192,223,161,164,177,34,227,8,125,164,32,222,69,255,191,120,26,228,
121,80,239,231,7,99,23,107,15,198,190,66,133,207,106,163,184,162,76,246,22,51,242,152,176,118,203,249,246,51,7,248,184,237,3,220,180,169,102,59,75,159,121,85,227,51,143,223,226,53,94,109,169,241,52,39,244,153,179,254,207,15,156,129,218,3,2,24,143,221,140,236,122,157,55,148,91,65,248,249,193,24,29,103,147,73,166,56,207,20,110,43,244,229,70,93,204,209,204,28,237,38,92,216,180,57,90,99,142,53,230,104,96,142,173,103,208,15,48,207,214,33,159,134,59,6,141,118,209,104,243,249,76,64,163,1,26,17,159,70,18,124,133,93,247,240,30,163,55,33,112,66,140,94,240,25,77,192,104,0,70,111,248,140,14,193,100,51,204,46,252,145,209,70,38,217,26,241,105,52,124,254,222,153,171,125,239,236,131,84,3,164,106,203,198,1,6,222,99,56,133,142,26,87,216,106,168,101,10,93,159,7,48,244,59,36,135,204,194,181,26,215,26,237,90,102,33,237,193,19,228,50,171,23,254,95,218,206,172,57,170,36,203,243,8,65,130,216,55,65,2,153,172,2,130,64,44,34,64,87,161,88,181,160,134,82,105,42,139,204,172,76,72,146,29,36,16,146,16,66,8,
164,68,97,162,8,172,179,123,158,198,44,48,227,11,204,235,188,181,89,127,129,30,155,239,49,111,243,33,102,126,255,227,126,175,60,66,17,85,213,15,243,128,69,200,239,241,227,103,63,199,143,251,13,170,121,138,133,225,119,91,153,3,60,250,45,49,39,255,2,199,99,156,159,195,169,14,207,229,106,194,45,231,206,83,108,13,18,28,6,103,207,2,207,179,37,96,40,64,134,113,166,18,137,46,255,148,117,72,114,188,118,94,29,158,206,174,206,195,118,7,239,51,239,62,1,64,68,147,112,242,56,104,9,26,134,177,219,252,228,25,214,129,110,18,104,126,178,175,54,76,114,103,109,158,119,85,249,206,56,206,72,225,91,162,104,25,214,58,207,78,87,249,169,192,42,223,171,165,215,57,163,205,248,39,104,15,62,103,157,231,193,58,51,172,67,128,27,38,232,230,31,33,31,18,70,137,192,145,127,20,89,96,26,38,17,231,167,89,135,53,74,36,171,60,116,151,224,103,152,245,243,143,224,135,162,152,159,53,170,14,179,190,201,71,114,123,126,170,202,79,117,25,93,195,115,253,181,146,112,83,12,13,79,3,79,18,70,30,200,160,223,248,231,56,152,160,219,
69,32,151,154,145,245,82,95,109,128,34,125,24,89,22,230,247,86,11,4,172,97,124,109,96,170,80,131,6,219,47,20,72,0,130,213,156,225,119,253,14,158,53,10,11,216,244,2,240,240,32,120,217,250,48,5,193,192,34,248,9,64,195,232,184,80,233,175,21,144,211,0,244,15,147,44,134,95,108,169,22,94,127,85,29,120,1,60,129,216,224,223,30,170,22,150,25,19,254,133,162,225,25,64,247,195,175,142,33,211,141,4,255,175,192,211,27,224,255,134,191,129,95,108,7,62,235,225,241,138,87,39,129,133,223,87,155,120,126,213,141,19,16,135,231,145,39,9,195,241,208,231,198,241,255,225,185,147,232,25,190,240,253,66,197,227,33,201,12,75,207,232,30,89,85,7,222,3,143,189,65,27,118,112,10,253,195,43,133,119,97,41,231,198,137,97,195,239,142,27,252,192,98,7,227,87,192,143,12,136,61,14,94,248,181,54,122,4,143,217,215,27,18,134,108,142,241,225,57,244,136,13,201,150,242,207,246,97,63,123,188,45,5,118,52,139,126,209,137,243,37,244,136,236,205,47,158,49,142,221,149,224,109,120,6,120,225,71,254,121,138,65,201,222,214,152,97,93,
130,60,58,173,229,39,176,7,124,14,93,87,243,19,140,155,252,25,159,66,14,130,167,240,204,79,97,63,178,79,138,239,252,131,189,213,252,131,109,232,108,61,54,90,114,248,177,147,252,204,113,143,155,117,103,243,102,111,102,159,227,93,213,252,56,176,178,57,249,7,182,140,188,240,29,232,148,239,34,187,18,246,99,248,149,240,158,226,103,216,102,73,244,60,69,14,74,238,20,204,249,153,19,213,60,5,10,252,160,55,224,141,126,198,61,191,178,207,210,188,231,87,254,55,137,94,228,123,146,233,164,151,167,252,104,234,148,243,137,87,140,195,151,244,50,12,207,3,179,39,170,3,248,220,48,252,22,216,232,17,72,157,77,96,39,3,243,237,140,177,174,236,86,246,204,191,1,138,31,138,27,198,182,241,172,228,240,200,55,102,247,129,7,251,199,87,11,21,103,255,216,31,60,239,129,87,244,62,135,61,84,202,6,63,32,153,190,194,254,137,71,3,179,248,64,101,160,86,80,188,145,191,204,237,70,254,42,114,24,127,55,104,227,42,202,134,159,163,199,231,208,131,45,14,160,71,193,15,16,15,135,129,231,19,219,17,60,120,40,4,21,11,6,102,247,
128,27,58,217,116,21,150,135,28,188,236,220,236,22,28,178,195,119,248,187,104,225,95,97,249,52,112,192,203,223,103,115,206,198,137,89,92,103,129,62,198,103,182,96,235,25,23,3,100,43,138,75,196,31,179,255,101,47,31,249,246,226,81,124,17,122,94,139,95,249,41,107,162,223,129,55,199,89,115,3,115,54,51,158,97,124,93,109,80,27,34,232,209,70,111,16,253,154,223,65,251,32,188,141,188,62,93,229,179,90,192,135,71,94,131,31,123,230,192,158,141,17,240,52,22,248,142,127,225,143,208,62,168,141,199,204,105,54,24,224,81,156,153,5,30,90,6,161,115,100,118,119,117,112,153,130,126,22,217,189,70,110,196,30,54,138,181,65,228,175,127,218,52,22,94,8,15,241,153,124,52,194,134,16,124,213,145,105,232,159,69,254,208,62,136,156,71,38,247,178,177,1,63,185,167,48,61,234,224,13,255,113,112,111,96,13,173,11,30,109,58,209,215,224,60,184,161,135,191,153,243,71,195,93,96,124,100,246,36,240,140,99,211,131,196,171,193,87,200,152,53,70,38,186,170,35,19,224,199,38,10,211,196,19,209,47,249,80,128,107,243,52,184,212,9,
253,224,23,237,60,27,153,132,167,201,206,42,223,161,191,31,88,116,168,113,226,216,8,249,138,239,204,201,3,199,184,230,188,64,158,248,46,223,153,135,28,128,85,46,27,120,143,253,179,97,40,144,203,134,37,31,224,157,190,78,59,27,97,67,55,60,237,228,169,162,94,113,146,171,99,216,149,214,96,28,220,22,223,204,30,176,157,55,196,195,23,249,90,1,95,28,80,252,124,117,194,252,113,128,186,175,240,138,113,54,241,102,183,207,136,51,207,176,31,108,183,240,12,60,130,23,254,215,140,67,187,214,40,188,98,124,66,240,140,63,135,30,197,237,9,232,121,78,222,161,158,148,206,134,137,15,5,252,151,181,176,81,232,167,41,53,64,78,31,126,182,23,252,224,121,9,158,113,244,37,58,21,255,95,192,175,242,29,27,152,225,23,200,89,248,229,3,227,248,35,241,74,62,83,152,24,181,141,141,116,57,252,2,159,70,102,178,233,194,244,152,131,87,62,122,12,60,77,17,114,19,240,99,182,161,146,220,10,216,219,48,58,47,96,19,3,149,235,181,2,141,29,109,146,134,137,63,5,26,95,195,52,179,6,22,21,15,25,83,252,124,121,140,122,131,241,217,205,
196,39,234,1,233,69,113,108,156,248,44,157,40,94,141,199,241,80,241,147,10,148,70,144,197,208,56,30,170,78,33,30,170,46,34,167,144,7,250,124,252,87,60,60,73,28,100,220,114,0,120,88,83,49,52,255,116,47,240,224,81,61,52,11,61,242,83,104,202,79,43,134,17,251,167,85,119,13,186,120,139,141,10,62,255,148,141,147,214,120,85,176,216,12,78,232,33,71,41,158,47,64,255,210,176,163,31,30,68,63,63,185,7,15,192,99,87,46,31,49,254,172,19,250,200,35,70,79,209,106,147,18,248,135,231,136,219,200,210,213,104,192,171,206,122,142,44,230,200,143,146,3,207,242,207,25,199,135,92,61,227,226,143,242,139,234,25,213,146,202,25,249,25,248,197,239,148,227,75,11,228,35,116,50,12,158,252,175,240,250,43,99,211,232,13,251,65,119,86,187,20,158,130,231,49,250,66,14,3,212,159,138,39,150,223,169,75,7,216,76,73,95,230,215,194,79,30,25,168,64,167,226,146,98,52,249,162,64,140,52,253,210,232,179,218,103,145,56,60,163,120,238,228,57,64,189,100,254,162,57,239,192,15,188,226,109,82,23,97,187,133,25,236,92,113,91,49,61,198,
79,189,55,160,58,68,244,83,147,13,188,161,30,195,174,84,159,12,79,253,209,197,85,252,101,160,66,92,149,175,200,39,43,213,219,53,126,167,153,106,252,7,42,240,93,85,254,195,168,126,219,210,241,31,135,214,74,63,81,173,254,244,97,103,245,82,101,167,165,251,12,83,242,149,167,85,254,83,78,210,253,94,171,225,187,151,190,175,118,19,138,185,113,120,190,198,255,251,196,58,119,170,252,255,73,224,7,21,191,32,193,130,235,106,87,102,14,87,175,204,172,188,173,94,101,231,194,234,76,133,250,202,19,166,253,82,227,127,71,97,150,182,60,111,152,181,171,218,51,247,113,206,225,174,140,67,209,102,128,86,46,213,248,207,166,161,108,101,9,10,78,64,81,123,45,127,107,93,141,223,238,196,16,191,173,230,111,77,65,213,213,90,55,10,237,99,55,193,45,117,102,237,175,118,207,127,124,111,156,243,18,1,184,219,160,108,37,11,69,109,80,182,174,214,123,123,119,181,247,246,135,29,80,210,198,180,141,80,135,78,213,215,238,171,68,53,254,23,73,166,110,134,172,9,166,238,175,246,188,254,248,174,214,203,180,244,194,124,53,141,
53,242,2,68,186,198,111,6,177,145,91,153,99,119,148,174,242,3,39,126,181,63,179,146,166,109,178,25,131,75,191,90,190,226,189,136,46,132,132,211,179,37,44,80,16,64,78,159,23,210,74,137,229,119,178,252,159,61,57,37,168,216,193,234,115,14,229,242,93,71,197,114,117,171,87,217,45,0,58,165,50,118,251,224,228,255,54,155,64,56,135,17,206,183,8,6,253,65,90,249,206,190,106,249,14,158,94,185,142,128,74,53,126,244,21,78,127,100,230,165,106,247,220,199,37,175,178,63,128,27,193,115,205,215,11,103,229,123,40,41,67,209,54,79,205,202,65,230,124,3,57,219,106,61,100,207,66,229,227,44,115,214,85,123,22,216,211,115,145,148,17,4,170,21,23,127,223,94,45,83,192,247,122,35,235,175,124,152,34,123,96,8,68,224,28,145,173,143,223,90,2,217,230,42,127,16,134,49,255,215,31,238,49,234,40,30,158,255,48,8,185,24,39,14,137,230,15,178,227,246,167,14,124,14,210,38,29,124,246,148,118,2,237,33,108,137,83,136,11,126,42,102,191,244,241,28,117,174,154,38,135,52,245,28,79,156,253,21,184,45,83,203,189,249,40,153,110,134,
51,54,182,111,118,67,255,202,25,19,174,180,90,166,17,199,61,225,95,80,228,102,232,135,42,110,27,73,199,59,205,130,69,120,129,180,14,241,41,144,176,131,95,100,159,48,191,21,100,31,92,177,109,38,61,255,225,46,79,55,65,124,7,84,188,180,110,129,218,32,69,254,235,53,136,221,12,209,29,16,255,54,96,247,175,19,64,239,1,122,68,52,151,76,1,18,102,95,229,159,23,109,37,110,60,178,202,127,159,173,157,129,155,126,74,8,165,130,72,219,51,66,68,63,101,104,52,157,170,158,169,160,6,82,89,233,121,91,45,250,101,95,53,250,5,148,108,235,250,73,5,253,132,16,133,193,232,105,170,26,17,182,248,94,237,159,233,171,157,147,200,9,35,106,68,68,239,207,87,35,82,46,223,241,237,158,26,191,98,90,43,77,130,107,252,96,245,92,101,119,53,82,104,166,156,233,159,166,215,69,120,228,87,174,107,17,41,173,127,138,181,30,83,110,63,239,53,95,208,182,192,240,45,158,173,70,164,64,109,67,251,49,156,11,149,3,14,39,120,35,74,247,136,126,48,191,100,78,120,237,51,243,209,60,41,250,12,110,164,86,15,127,51,239,40,124,237,129,126,104,
33,13,69,79,160,255,137,104,231,249,44,116,96,204,253,232,36,162,84,137,72,41,253,10,225,108,97,181,190,140,95,173,162,115,149,131,224,217,15,78,158,209,251,227,117,121,219,66,240,235,127,204,3,159,109,79,160,101,238,74,173,31,185,42,181,68,179,103,170,253,148,205,17,169,189,244,170,15,190,196,147,195,199,219,24,224,81,171,104,189,225,189,80,249,175,143,32,218,51,13,144,122,11,133,103,251,169,81,196,56,12,86,246,0,44,5,109,117,11,136,224,121,237,165,32,152,188,25,205,179,119,199,163,180,120,196,222,206,198,136,217,165,133,62,99,64,248,180,184,99,68,76,168,23,182,29,70,142,24,243,18,66,52,141,64,167,9,123,228,188,126,14,171,212,191,136,168,105,250,231,83,38,20,222,237,78,24,209,30,201,20,196,129,91,68,190,50,133,47,109,69,65,167,107,252,116,168,9,39,154,70,9,182,183,2,223,235,168,78,160,103,16,166,19,168,120,59,8,95,7,106,252,215,220,150,127,251,233,1,244,207,119,146,127,17,208,12,124,129,15,33,214,250,151,78,87,251,213,203,33,47,71,212,14,182,62,181,158,120,59,7,111,5,229,211,
199,61,78,176,102,132,199,224,111,27,244,11,47,188,144,91,251,169,35,34,114,107,9,122,76,241,194,141,2,249,25,93,248,6,47,53,185,20,165,186,1,195,99,141,110,232,100,14,65,70,123,193,11,52,57,251,201,201,166,224,25,20,143,19,32,167,106,255,66,191,83,48,249,247,42,77,78,41,254,234,162,228,241,175,215,140,80,121,157,8,141,42,174,81,36,165,70,52,6,17,132,121,21,191,59,94,139,158,167,171,124,218,230,53,122,126,181,198,255,193,96,68,70,108,94,249,175,134,204,58,75,115,242,56,39,124,135,15,198,41,42,11,47,100,161,138,14,204,7,239,185,202,14,55,95,120,159,157,101,62,235,105,163,254,42,182,120,198,205,226,81,158,89,188,24,247,74,133,113,121,146,54,65,5,58,197,242,34,9,64,130,184,192,105,147,9,84,22,254,2,11,167,144,70,24,208,22,121,3,142,249,100,62,222,89,224,36,12,143,100,174,20,29,206,237,132,119,138,65,9,15,28,209,139,94,167,80,241,252,14,126,37,31,214,47,177,89,84,132,145,241,58,126,193,75,227,172,112,95,188,202,240,132,119,24,163,19,63,109,240,189,14,229,236,70,161,24,16,184,165,
80,140,198,156,35,162,137,97,222,72,218,237,167,121,98,138,246,184,137,90,74,47,100,17,12,154,141,137,25,52,33,51,49,104,57,200,115,162,145,154,92,114,16,54,69,74,143,70,151,69,29,39,39,201,136,122,2,218,206,215,164,211,210,51,228,68,241,89,98,211,17,61,219,130,126,75,142,79,209,185,76,74,181,8,197,51,138,58,126,251,183,86,122,194,58,119,112,0,120,41,61,97,252,206,168,193,43,194,70,52,74,35,157,34,216,28,138,76,26,108,253,143,24,191,131,227,222,129,166,71,204,121,170,72,40,220,130,135,167,113,120,26,135,110,139,200,192,208,212,180,8,79,148,143,238,225,132,106,150,0,19,221,187,110,240,78,206,68,66,147,171,224,113,220,95,193,247,43,248,126,222,91,141,126,134,127,10,218,254,95,199,204,70,4,31,225,36,46,66,139,239,75,53,254,27,174,90,233,17,248,111,2,127,147,141,3,205,194,254,123,5,207,183,244,120,2,188,172,107,17,48,91,139,238,99,119,202,58,207,112,68,50,68,116,127,3,242,194,254,197,135,28,145,226,84,206,103,142,40,57,145,57,162,135,60,83,228,125,200,56,13,206,146,244,44,120,163,
71,167,33,130,23,61,4,10,201,85,122,184,69,6,186,69,70,83,80,101,179,232,228,228,240,175,202,135,200,15,237,165,135,192,255,5,250,255,178,11,185,66,235,195,28,240,177,13,18,72,12,55,178,64,62,166,7,54,116,209,45,244,115,139,117,217,44,150,158,74,111,146,141,104,82,243,21,190,140,38,232,100,179,107,89,241,39,236,66,217,144,205,110,244,211,31,234,232,119,176,146,17,155,42,101,74,241,252,23,240,255,5,253,195,111,255,243,162,135,23,253,196,0,120,42,224,231,171,243,56,53,98,29,104,169,69,63,130,255,71,104,102,163,95,98,19,190,106,31,200,201,108,201,203,9,30,74,108,148,163,219,172,115,27,31,16,31,207,254,96,149,130,230,68,156,62,185,56,64,146,96,83,17,9,94,129,121,22,189,41,203,241,47,154,96,83,4,172,138,184,60,167,130,156,32,89,13,39,62,248,45,92,226,89,27,207,246,50,182,203,252,40,207,109,6,21,78,154,147,175,208,100,199,46,56,13,226,121,214,54,92,189,10,222,207,83,86,133,240,221,154,116,130,215,137,81,201,78,201,24,67,174,189,52,203,248,173,108,11,204,194,175,13,93,47,85,82,126,114,
208,209,98,107,168,64,18,254,111,120,198,169,148,170,19,226,70,47,113,179,151,58,186,244,122,131,53,187,215,226,23,46,232,71,54,170,128,122,223,165,170,189,84,77,170,128,242,207,178,70,191,163,231,184,209,174,53,68,143,225,145,237,189,34,81,19,139,242,84,9,226,43,193,191,124,12,249,139,158,205,140,95,113,227,36,220,18,205,41,37,57,100,200,38,189,207,198,173,41,137,31,104,204,154,140,208,99,120,136,75,165,215,106,218,178,209,36,46,9,191,54,218,253,230,255,20,2,84,78,106,184,90,124,81,108,85,62,152,192,174,39,176,107,197,215,87,222,174,85,56,188,39,62,18,251,172,34,4,191,197,47,154,17,209,4,126,51,129,61,32,211,18,77,40,243,3,139,121,177,253,4,241,11,126,157,253,96,167,170,166,94,184,120,103,213,38,126,32,251,76,240,75,254,170,0,127,233,164,210,4,158,196,220,63,173,56,1,157,162,135,38,190,131,133,126,154,23,86,77,178,41,141,238,17,31,169,250,162,123,208,207,166,116,213,143,177,159,36,158,226,199,178,7,154,200,209,93,240,223,149,159,33,39,242,148,112,155,111,210,108,101,46,107,128,
107,30,252,216,178,85,184,79,168,244,158,236,192,166,225,215,55,181,85,49,71,179,196,69,108,156,239,232,64,205,2,240,76,31,129,22,254,126,61,68,158,161,113,6,238,129,55,135,200,47,27,57,33,215,198,217,249,41,55,125,104,178,186,166,35,107,211,192,145,31,186,125,197,8,123,79,126,93,145,99,49,109,28,93,92,210,141,38,107,88,145,235,134,239,115,75,70,57,75,243,184,101,34,126,7,168,198,71,22,88,91,243,120,54,192,102,94,121,89,205,223,145,57,154,134,58,84,160,57,219,63,63,224,224,217,121,140,188,163,73,135,221,14,44,110,96,158,139,151,106,162,141,188,166,9,168,230,23,205,89,126,193,209,240,140,144,223,7,172,25,77,227,14,189,247,207,3,15,111,52,17,105,116,209,244,148,28,196,223,75,87,41,107,55,60,130,61,115,203,1,30,182,129,135,83,125,221,180,193,95,250,133,135,102,147,26,138,253,52,143,68,63,178,97,43,119,138,157,155,227,107,132,60,175,28,206,77,21,120,160,217,61,71,3,114,30,60,175,217,69,136,95,195,207,238,76,141,193,73,197,95,240,217,90,220,90,80,163,2,187,139,11,213,1,114,231,200,
20,113,147,121,138,89,37,109,241,252,169,123,84,193,23,151,55,99,135,25,158,57,125,247,47,81,47,44,97,127,51,28,190,2,23,33,19,120,195,143,212,172,194,79,144,89,196,237,23,43,8,177,131,210,252,9,87,120,47,59,188,86,156,42,78,233,240,228,217,30,120,100,156,91,7,17,141,63,171,61,150,79,130,31,91,210,186,156,230,27,126,237,166,38,24,159,33,150,78,108,2,127,102,181,176,167,57,170,93,84,105,126,51,107,147,175,145,121,196,142,172,68,189,37,159,82,13,194,255,253,101,133,168,104,42,113,232,212,79,115,218,234,157,69,217,1,54,111,177,77,5,61,176,170,209,168,87,204,94,217,36,68,220,22,160,136,181,24,99,133,52,182,38,30,84,104,23,30,146,71,30,82,184,75,191,52,155,74,175,89,95,245,19,252,69,52,242,11,147,108,74,38,169,189,180,185,208,230,99,137,154,78,49,72,245,32,205,70,21,215,113,92,113,245,17,243,228,207,75,212,85,196,57,249,155,58,64,165,165,255,249,7,187,18,163,235,79,188,50,196,118,86,10,229,92,23,67,144,145,141,34,160,33,186,136,67,36,200,17,28,113,20,71,140,175,203,140,46,157,228,
26,19,227,204,25,226,250,146,93,13,34,176,13,209,205,30,34,201,201,96,71,233,102,235,154,11,47,214,24,126,62,109,191,207,187,41,116,219,61,254,251,167,236,202,210,8,193,100,232,62,120,100,152,252,211,117,22,57,163,205,121,15,60,219,198,81,225,127,176,167,170,127,124,135,166,130,135,119,248,117,61,194,205,201,215,70,49,72,112,214,134,110,129,247,214,49,186,250,208,195,233,164,195,47,120,232,132,30,225,31,161,128,24,65,185,163,36,151,161,239,129,255,158,181,73,240,163,207,232,162,139,126,2,249,208,219,19,118,213,43,230,151,78,59,244,48,254,96,55,244,112,101,76,244,204,149,28,60,202,210,117,142,27,224,184,241,156,235,73,56,145,147,21,252,161,68,5,168,161,23,123,171,163,24,197,16,198,52,242,110,140,171,99,226,27,124,24,198,16,39,97,92,37,131,174,62,227,89,14,57,68,194,48,185,210,185,29,125,197,117,75,209,37,60,111,208,219,155,118,187,166,101,114,197,57,116,29,107,136,211,242,33,146,157,174,99,141,44,123,61,224,80,67,115,200,111,110,135,135,47,18,192,128,23,254,103,240,241,12,135,
199,224,70,231,25,23,126,241,193,169,5,87,231,160,95,119,6,208,67,130,31,122,68,251,50,244,112,154,33,218,141,30,2,13,223,193,15,111,4,172,17,112,216,56,167,145,186,162,199,119,174,118,197,244,56,250,5,207,85,65,158,33,111,120,210,53,186,33,93,207,155,222,110,1,124,244,181,151,171,228,195,38,225,6,65,236,198,204,25,127,181,11,156,36,110,155,135,108,135,232,242,34,99,155,55,52,253,199,85,123,122,139,189,154,174,89,11,123,213,53,55,201,124,136,13,152,241,129,46,70,57,213,208,73,19,112,92,57,59,198,85,51,225,222,204,137,211,21,108,128,107,50,156,254,242,10,23,127,235,74,16,207,150,111,120,120,158,81,24,96,91,60,227,122,14,5,128,225,129,151,235,111,185,154,246,118,11,227,155,225,47,23,224,63,194,24,122,51,248,188,135,103,221,55,199,185,134,38,57,105,206,101,198,145,43,52,93,167,48,211,213,55,94,240,98,60,203,181,28,39,239,65,130,169,100,170,235,164,131,232,199,214,197,94,175,227,207,162,95,180,142,46,247,217,184,174,53,141,178,177,51,120,78,175,215,194,139,126,193,247,219,149,32,
217,234,32,126,34,121,234,58,208,32,137,81,215,76,229,15,131,108,112,77,14,208,63,186,204,117,88,100,131,206,25,175,199,47,27,186,78,135,96,16,122,184,6,201,28,112,189,119,114,208,213,162,81,78,73,71,95,239,133,254,173,60,227,58,41,250,21,158,145,133,221,216,34,207,184,5,50,244,254,146,243,15,243,27,236,139,110,139,116,54,202,45,139,196,159,193,117,131,205,238,141,167,103,177,63,201,9,61,47,114,205,78,246,132,141,15,209,102,227,26,175,205,117,246,202,56,197,194,208,155,83,206,246,44,150,97,199,216,132,217,5,183,63,20,247,116,141,83,167,144,226,67,182,143,111,214,110,80,148,223,152,224,26,30,126,97,241,114,233,178,217,184,249,53,137,145,79,232,102,253,73,230,177,190,93,115,158,193,239,56,209,211,184,217,127,236,23,208,229,124,2,120,110,121,136,38,249,158,243,59,249,28,184,150,124,220,144,159,114,202,109,241,24,157,140,114,250,109,116,129,107,200,252,11,122,144,177,193,19,159,184,166,91,27,122,130,223,209,106,179,120,204,173,153,132,15,78,147,134,56,225,114,244,19,47,21,151,20,
55,238,226,119,119,129,95,224,106,41,29,45,249,53,239,25,113,139,235,132,221,224,226,245,48,104,114,254,171,155,93,55,233,8,221,68,118,186,221,149,140,3,127,147,130,74,87,26,153,203,205,43,23,71,111,34,191,49,236,64,55,189,110,46,111,229,249,101,139,15,55,225,57,190,1,118,115,137,98,10,126,21,151,198,176,241,155,11,223,86,111,146,88,199,40,152,70,22,10,166,3,163,71,248,201,85,99,92,71,187,41,252,200,224,38,186,27,163,35,55,38,255,71,14,55,209,155,100,105,248,177,143,239,176,143,239,104,89,42,222,140,209,76,185,185,228,174,139,66,191,173,245,221,3,158,63,72,243,12,250,204,30,156,253,220,132,22,126,225,128,91,98,103,185,37,134,78,208,225,119,224,184,185,0,253,194,175,231,248,196,216,219,78,158,243,108,185,157,103,91,88,39,166,87,215,163,152,79,75,84,55,228,190,51,154,161,113,249,146,241,41,126,192,199,243,115,60,19,79,146,63,52,232,122,184,248,226,153,155,127,12,190,54,219,218,99,196,142,155,146,31,246,117,19,221,141,97,27,223,189,227,6,30,126,250,29,254,113,147,2,104,228,93,129,
184,142,61,179,1,29,225,154,176,252,102,116,98,27,113,158,120,138,204,205,206,185,17,55,244,134,252,196,105,221,200,82,137,252,128,29,40,230,204,225,175,108,102,120,179,151,124,193,245,105,116,173,171,166,163,51,157,228,107,217,13,237,111,174,247,219,184,224,57,237,149,92,71,95,249,113,226,129,249,210,12,133,48,185,108,116,230,27,226,174,243,111,203,9,175,143,50,127,131,243,47,78,171,71,169,55,204,94,185,77,49,52,75,126,34,7,142,188,34,15,41,78,227,115,67,211,228,57,252,119,148,58,100,132,2,214,198,121,54,68,71,113,136,130,103,132,174,226,40,27,8,91,147,218,98,136,2,89,87,148,237,122,63,27,56,213,14,178,41,197,123,201,214,226,7,121,212,236,94,113,197,231,57,147,17,120,84,251,216,107,11,156,18,114,165,156,98,22,252,20,248,138,125,230,159,228,19,87,11,64,19,241,114,148,230,9,87,163,107,67,119,200,151,119,160,145,57,163,227,222,175,228,159,211,59,160,31,185,145,71,149,95,145,173,241,176,154,127,24,103,67,210,156,30,240,139,126,230,12,113,203,140,186,3,29,66,19,45,114,139,47,200,
223,213,1,172,171,120,193,237,26,171,175,216,216,169,86,178,218,234,1,121,145,83,78,243,127,236,109,136,66,242,6,181,196,13,228,166,220,59,66,190,27,93,74,81,7,33,111,54,109,55,216,180,13,221,97,157,59,123,170,55,168,35,70,158,31,226,10,122,15,183,24,161,67,250,86,44,196,158,85,51,234,10,188,116,127,3,123,189,193,38,64,114,176,90,138,77,223,208,93,201,2,24,78,126,111,112,234,174,249,154,43,28,67,239,185,78,106,113,67,115,15,128,135,235,168,52,223,180,97,185,65,109,53,202,213,235,161,39,60,123,69,158,100,163,63,50,115,205,230,242,147,10,78,7,239,89,159,211,127,116,98,124,223,192,31,84,247,221,192,94,116,251,97,232,1,243,31,48,111,242,80,245,134,106,152,169,139,230,79,70,131,98,255,75,230,211,81,215,101,71,211,11,113,220,248,103,125,214,173,221,152,134,126,214,31,161,134,187,65,125,58,106,175,89,200,79,117,117,248,52,249,85,87,218,21,223,34,203,151,215,104,28,140,177,193,188,6,78,229,203,49,244,163,124,169,107,198,99,108,164,21,115,148,147,175,81,215,217,117,101,244,57,54,7,30,
98,202,53,26,1,99,52,150,237,138,177,135,87,190,215,235,2,99,139,125,181,49,112,131,151,117,186,12,63,127,179,70,126,21,158,235,226,138,193,110,14,240,248,147,93,99,230,84,92,248,199,240,167,107,216,111,130,159,219,127,9,254,183,192,99,15,134,255,237,105,135,159,219,28,215,223,102,45,46,186,57,170,63,68,251,54,232,225,117,0,244,12,78,174,56,159,178,107,240,215,216,240,141,113,251,70,175,33,192,39,124,51,46,250,209,207,24,141,131,49,244,114,141,88,116,157,60,165,235,241,215,104,198,142,77,229,76,62,130,191,6,188,201,210,100,212,239,232,7,255,181,233,147,213,107,156,136,232,181,18,225,31,163,150,0,47,240,162,95,242,7,63,183,243,198,76,54,140,191,64,62,47,184,162,76,14,24,123,73,157,4,252,53,221,0,134,223,177,183,237,188,66,161,250,35,34,94,74,62,192,19,63,248,180,184,121,141,219,97,196,239,4,191,232,185,78,156,29,123,11,60,49,69,215,236,175,209,192,184,70,93,112,157,24,53,54,93,242,182,32,126,177,87,154,184,163,52,122,157,92,101,23,87,236,117,169,49,124,234,218,125,244,195,166,
241,58,114,186,198,62,199,217,144,214,138,245,176,5,248,75,181,49,236,246,154,94,97,129,143,235,248,29,223,171,99,147,185,85,189,189,143,225,145,159,248,32,182,95,187,15,60,113,234,58,249,237,218,125,198,105,0,218,149,116,228,234,248,102,93,114,218,53,244,108,58,166,65,49,54,143,62,105,80,40,87,94,123,73,93,135,222,116,125,222,217,41,186,71,111,130,87,141,102,180,210,144,188,118,219,221,240,190,174,70,16,177,84,113,112,224,253,202,79,214,65,176,139,201,11,255,177,207,181,22,144,198,64,101,10,175,116,135,180,156,199,222,240,61,4,77,91,233,247,79,216,168,86,254,207,123,138,195,117,181,44,130,47,82,28,232,13,52,126,96,165,154,125,123,169,54,72,16,214,187,7,89,186,83,217,95,184,129,140,98,7,217,132,234,202,83,145,37,248,217,83,142,227,215,87,179,56,92,81,197,47,5,64,145,68,152,29,63,89,229,127,61,226,138,84,91,53,59,206,56,5,101,22,5,22,17,94,145,238,218,32,137,48,59,29,213,6,113,192,34,255,178,79,78,85,249,172,14,34,144,236,147,254,90,22,28,162,169,72,209,157,208,195,93,252,65,225,
96,163,152,253,229,116,181,136,50,7,9,10,217,95,84,236,51,38,92,6,175,162,27,250,231,46,114,200,205,24,202,201,254,124,166,202,39,7,222,192,255,76,49,46,122,112,136,226,155,211,85,62,161,135,67,240,55,224,33,240,100,233,232,22,41,22,245,143,239,142,95,241,132,17,21,41,110,196,23,63,73,207,213,50,240,192,47,63,175,207,187,22,224,199,193,179,156,223,14,114,172,54,72,146,42,162,184,44,167,45,124,114,69,141,103,116,43,196,111,246,1,207,184,50,151,125,192,219,126,56,226,32,73,167,136,242,115,252,227,125,149,42,159,200,136,192,79,208,209,251,23,57,37,53,146,102,14,67,44,106,147,78,151,63,135,161,72,254,238,29,21,201,126,125,53,135,177,168,120,200,145,56,138,111,206,84,115,20,232,67,4,181,226,155,222,90,14,103,51,120,222,181,200,17,24,5,175,119,105,128,33,8,243,108,174,19,249,147,248,209,99,78,248,161,157,192,206,28,183,201,203,177,185,41,114,165,144,119,70,160,69,52,117,58,122,94,146,64,232,38,26,253,56,249,16,235,42,153,229,248,87,196,57,134,72,202,69,108,40,247,120,127,53,247,24,
251,129,223,161,241,2,23,8,24,167,184,76,232,199,57,114,111,224,87,56,8,58,185,41,240,16,112,138,4,193,220,20,244,19,28,237,117,201,247,200,153,128,160,164,149,123,115,213,222,151,25,66,158,57,156,59,135,227,41,217,20,57,143,95,133,71,254,216,51,127,51,199,201,211,232,127,132,156,57,209,112,242,204,146,72,219,106,252,2,44,29,245,83,85,126,17,150,110,52,69,23,23,246,203,216,26,87,151,72,196,208,67,50,230,111,174,50,69,14,22,154,120,63,195,174,15,151,9,130,67,200,191,44,250,73,250,249,113,54,9,216,85,153,117,243,227,140,131,159,119,74,236,221,165,1,130,196,0,155,36,189,115,201,123,34,172,119,165,86,198,230,134,56,205,201,223,226,138,214,45,100,244,112,71,181,60,81,180,121,42,240,242,111,193,7,207,90,39,79,48,44,115,146,3,175,181,252,93,214,39,193,139,239,50,87,207,180,142,193,99,71,121,240,187,57,217,90,89,9,21,189,229,31,29,176,107,235,101,222,167,26,122,193,187,84,216,117,89,248,73,10,186,186,85,126,143,108,41,190,202,216,145,222,185,204,115,26,165,171,205,42,252,202,115,232,
147,24,97,114,194,111,116,109,90,178,26,130,30,217,144,174,134,149,241,3,93,107,211,123,136,101,142,167,133,159,142,60,107,236,5,247,46,186,243,20,191,188,59,195,59,153,181,50,9,53,255,156,142,61,126,92,126,121,132,205,217,197,90,22,249,153,223,211,21,149,15,100,145,223,32,201,93,49,72,190,159,125,120,160,154,125,168,56,196,248,52,155,118,252,44,75,82,40,82,12,88,156,96,67,146,101,93,139,43,140,103,159,236,37,158,96,19,188,147,53,72,115,72,215,82,93,220,58,65,204,210,219,182,108,242,185,163,161,107,175,206,191,89,151,130,140,239,196,4,226,22,240,89,130,117,18,87,132,31,57,24,188,98,11,250,47,146,188,248,175,36,128,119,155,234,172,249,166,226,22,176,60,227,247,101,238,212,114,114,50,152,142,94,30,51,39,200,33,160,136,99,159,156,28,68,199,157,79,48,96,29,65,138,88,2,160,28,36,66,112,69,178,187,94,212,210,49,112,142,0,85,68,200,4,130,90,68,53,25,209,245,34,56,84,139,79,243,224,21,44,142,64,91,54,7,3,54,135,182,180,112,231,168,164,34,2,108,196,81,106,142,127,197,39,145,221,51,200,
225,104,69,20,47,167,204,81,213,71,56,14,151,63,76,216,185,169,20,142,199,186,100,192,162,28,156,96,25,201,49,169,234,225,197,90,163,69,218,203,142,30,225,63,9,45,224,16,253,79,115,70,15,129,6,92,93,142,30,130,81,196,46,64,114,160,61,10,93,188,200,166,163,221,41,222,174,121,89,182,177,28,221,194,226,20,244,176,110,142,110,97,4,254,136,108,156,147,160,105,43,231,248,87,68,208,17,199,119,162,19,250,192,143,35,27,157,200,129,187,238,57,224,73,12,204,227,88,148,42,65,73,34,231,225,139,56,77,142,23,57,129,113,120,184,187,43,250,117,132,151,163,155,144,35,216,71,116,22,138,79,163,90,14,227,81,251,184,200,157,124,201,70,52,69,220,197,53,122,20,96,95,112,156,66,27,62,199,46,94,235,10,54,135,126,139,180,127,141,126,58,109,17,23,114,100,184,92,57,32,208,114,108,2,237,50,220,156,232,196,168,12,255,12,244,43,72,211,81,51,120,120,146,28,34,238,60,231,232,164,25,15,236,26,12,183,112,193,175,46,232,24,30,238,220,26,61,38,7,228,195,5,34,214,51,249,228,176,29,221,37,41,190,196,16,49,244,28,137,
85,250,149,13,98,123,204,35,17,200,6,37,11,5,76,241,43,221,79,59,252,216,6,193,17,123,19,61,178,91,201,77,60,9,158,170,177,8,188,173,193,125,25,62,45,249,69,36,244,156,100,134,14,162,103,93,240,187,1,30,192,195,187,59,10,126,145,130,13,119,128,203,216,20,255,183,1,129,12,121,114,204,92,86,32,155,32,208,72,254,28,223,151,31,0,47,251,7,87,89,252,18,124,242,111,182,48,143,227,4,193,130,191,124,31,120,104,137,72,162,229,251,145,193,151,117,201,138,106,82,237,247,60,29,188,242,100,47,239,30,0,107,254,5,60,47,220,202,62,203,79,8,148,216,8,239,114,152,60,121,127,201,100,90,230,142,171,228,105,1,139,192,87,70,95,58,78,148,189,57,88,232,159,56,78,96,110,55,248,60,129,38,82,176,7,79,153,59,210,124,178,118,59,73,194,29,243,234,184,162,76,55,158,224,206,113,5,73,5,251,23,110,201,185,236,241,75,151,121,10,0,249,68,25,187,202,211,125,22,158,178,244,72,53,172,227,98,5,251,136,132,162,139,99,121,5,86,238,108,59,122,120,70,55,74,244,151,37,11,236,138,121,134,63,79,129,161,128,30,241,158,79,249,
69,143,21,89,196,16,244,76,124,144,175,99,15,69,118,59,42,0,34,21,48,178,79,238,14,81,60,152,61,155,30,165,119,142,103,116,236,41,127,148,157,72,183,138,89,209,61,238,98,221,35,254,112,117,162,56,73,28,147,173,9,158,119,172,44,158,200,158,159,99,15,42,166,228,143,15,192,79,146,202,201,191,144,51,137,215,173,253,20,190,72,24,42,86,138,248,151,252,69,5,76,196,29,245,156,236,132,130,173,40,63,197,135,156,159,18,232,25,115,190,234,232,65,46,181,28,239,94,229,120,71,67,50,146,189,9,191,100,154,195,158,93,44,17,126,37,18,197,0,112,113,71,58,34,222,230,184,159,93,164,224,49,218,209,101,142,221,154,236,220,252,81,241,13,218,197,131,226,179,108,39,135,44,138,232,183,40,88,240,71,90,23,123,227,111,248,37,94,17,107,69,107,142,119,222,20,155,249,27,122,57,238,166,0,203,170,152,230,221,129,226,228,142,106,47,71,106,217,153,11,174,216,196,78,122,41,120,20,171,178,200,167,119,42,170,245,178,59,86,177,149,125,121,220,37,170,151,91,170,189,236,142,123,233,66,72,70,89,244,37,95,239,165,19,145,
69,62,189,74,84,208,84,156,34,177,209,41,81,12,234,165,43,194,17,189,75,108,208,163,164,214,75,225,93,228,122,76,175,18,39,120,20,63,249,4,214,233,189,151,93,5,255,223,19,60,156,174,246,210,165,201,18,227,138,20,22,226,169,87,69,51,126,93,100,231,168,132,215,203,41,149,193,227,95,197,39,199,128,223,64,76,135,135,39,92,103,96,131,96,120,176,207,34,56,224,7,92,192,67,191,195,191,31,218,145,129,228,47,249,136,126,139,171,224,135,30,71,19,244,75,110,54,206,177,63,133,43,223,77,95,124,247,120,142,51,222,238,233,244,240,232,172,56,113,132,241,175,224,25,252,19,57,135,95,249,133,248,99,248,167,145,231,50,242,140,229,131,255,58,249,128,31,251,76,228,243,252,40,112,224,209,186,26,55,122,132,159,241,249,141,140,123,252,226,55,148,39,252,42,47,244,106,131,32,121,114,100,152,157,236,168,246,190,222,136,60,242,224,17,45,122,134,126,21,83,95,108,3,223,101,179,183,44,5,127,47,133,55,87,27,170,89,21,253,242,23,108,193,197,91,252,17,95,180,152,203,238,26,217,90,126,140,232,50,231,116,189,234,
73,59,248,157,157,91,110,224,20,202,252,200,219,185,98,143,109,16,56,253,202,241,30,160,100,161,184,97,181,0,241,54,82,61,64,188,85,252,143,200,47,86,183,216,184,242,62,248,137,41,69,242,154,229,118,229,114,186,3,162,71,245,70,142,174,160,226,137,248,138,148,199,193,173,120,18,77,229,45,95,232,58,76,246,77,151,21,117,218,44,233,58,73,47,177,211,228,128,94,122,137,75,38,79,186,84,146,179,109,12,231,145,15,185,162,72,225,40,249,24,60,244,100,167,177,55,222,243,200,106,109,78,57,13,30,255,178,113,213,63,196,159,172,198,137,73,166,151,41,236,132,99,102,195,79,254,50,189,203,174,166,142,153,175,100,95,224,147,239,46,57,60,216,122,150,119,244,84,107,152,205,97,63,20,121,108,208,136,41,108,16,116,125,195,54,105,111,185,82,125,78,201,197,42,251,182,218,217,187,251,170,103,239,242,43,37,84,222,140,85,207,61,185,92,59,167,103,48,30,205,113,14,77,50,57,71,43,136,255,153,193,238,243,217,56,215,199,35,187,201,220,174,123,123,255,247,226,186,177,31,94,77,242,115,105,247,244,51,50,15,31,204,
205,185,255,219,227,63,142,173,251,183,77,83,235,254,109,203,224,167,142,127,251,229,208,191,46,126,62,202,207,211,125,58,90,249,248,248,115,23,87,183,63,117,85,118,127,78,113,201,251,83,170,146,250,124,142,223,122,255,116,174,114,246,243,121,222,50,254,116,190,210,247,153,59,237,251,63,93,170,164,53,242,13,35,39,5,115,21,152,173,154,117,149,89,219,132,39,15,158,246,24,207,25,193,28,3,230,152,102,29,101,214,113,225,201,129,103,227,103,254,195,223,51,159,46,84,14,233,81,55,143,246,10,248,60,192,251,62,159,21,61,103,161,231,76,101,229,212,167,51,149,111,62,159,230,58,54,232,55,126,226,203,25,150,232,20,76,47,48,29,130,41,243,124,61,112,43,5,158,183,137,140,118,96,138,250,82,130,150,237,252,177,178,15,10,143,106,137,60,75,108,208,162,101,104,217,200,194,43,57,254,218,9,77,144,122,190,178,71,48,154,181,9,184,149,179,204,218,173,145,110,254,218,43,145,13,124,62,201,90,124,41,176,104,199,167,147,34,131,213,69,79,9,90,54,66,19,8,61,61,167,120,116,240,243,41,73,245,20,82,133,140,28,180,
108,144,124,202,204,216,5,246,149,115,204,216,248,57,205,127,127,252,41,93,57,162,181,134,89,235,99,62,166,126,147,168,255,6,72,123,86,228,89,155,168,191,10,173,219,36,205,11,80,190,91,35,25,70,182,107,190,132,184,87,107,28,96,86,58,198,179,81,120,114,60,223,169,85,15,1,115,64,179,114,204,218,40,60,71,193,115,188,78,43,87,108,9,16,158,6,248,144,56,236,134,214,189,146,248,69,164,189,71,90,185,12,135,219,181,132,248,49,82,47,3,179,73,48,89,96,54,9,166,100,90,65,10,71,145,194,113,7,140,88,69,143,40,252,90,52,159,97,137,131,162,167,78,43,199,165,149,29,144,97,58,40,0,99,182,117,134,89,135,52,203,73,67,202,64,35,27,208,12,58,192,2,164,149,43,44,186,77,52,247,197,244,116,67,79,167,232,185,192,163,221,210,202,41,232,249,38,150,143,209,115,137,25,95,75,62,223,48,107,171,180,114,22,173,24,133,69,30,181,67,193,74,17,209,154,154,123,1,220,32,132,123,64,120,41,198,35,211,67,44,242,7,128,47,48,195,180,35,57,127,37,57,151,224,242,176,248,58,205,243,175,24,93,201,130,176,67,152,187,152,181,
47,198,99,244,92,4,230,176,232,57,197,44,91,253,2,51,118,9,79,15,56,118,72,95,231,240,162,78,137,46,226,81,135,22,117,110,9,239,229,216,34,83,240,190,79,164,202,88,59,180,196,183,144,217,37,249,200,106,143,194,45,92,156,1,51,48,121,96,218,37,159,78,228,211,29,211,99,246,35,10,15,104,9,167,11,22,149,29,110,21,61,101,72,48,47,234,225,249,86,241,117,21,190,204,139,78,27,95,204,186,2,151,91,99,47,218,34,47,58,141,174,118,106,81,25,73,226,69,123,69,207,9,232,217,182,74,51,244,92,133,30,139,50,125,16,191,89,22,46,171,219,38,249,40,94,152,23,109,71,95,87,68,161,252,252,227,176,168,63,13,244,65,65,159,3,114,191,158,93,226,217,78,137,236,34,116,238,17,245,151,145,230,118,141,156,98,228,27,193,56,90,153,165,136,120,70,120,174,130,199,162,157,240,116,10,38,177,90,249,222,14,225,185,8,158,93,210,74,132,86,58,234,180,34,224,122,47,106,131,67,197,174,149,35,48,111,142,113,158,37,44,254,245,27,63,161,167,237,7,230,172,180,34,47,58,33,122,174,196,244,116,66,207,57,209,115,145,37,204,218,210,
208,115,64,244,156,134,30,243,171,3,140,164,5,147,1,102,155,164,113,138,89,198,169,147,6,202,40,227,65,27,165,149,19,104,229,160,8,59,202,162,39,100,37,137,23,157,175,183,36,232,233,128,158,72,244,148,193,122,24,154,72,20,41,196,203,172,179,112,113,64,94,212,131,86,118,105,245,18,195,155,161,0,209,249,0,127,37,86,243,86,214,186,10,158,5,80,252,143,45,138,32,251,121,116,86,95,114,124,249,74,238,125,4,194,142,127,62,161,24,119,2,65,29,227,39,143,63,29,99,117,190,12,32,155,175,249,99,229,107,232,9,76,234,76,101,154,217,127,6,205,60,159,163,96,185,7,146,54,144,76,129,227,38,83,39,152,117,235,115,119,229,218,167,238,202,18,127,63,224,239,251,124,126,16,58,133,178,41,38,126,47,58,218,249,82,16,29,5,80,180,139,142,8,28,29,192,222,2,116,156,79,56,61,6,167,136,37,13,25,22,110,190,133,175,46,102,255,204,228,113,97,57,192,151,52,114,184,135,64,54,33,134,59,200,227,87,214,255,112,15,2,62,182,9,75,30,44,27,4,219,3,236,78,73,240,28,18,236,4,8,29,119,163,99,96,178,158,58,56,39,68,1,183,114,
134,231,237,192,33,130,238,202,105,17,81,98,100,59,132,172,92,249,124,145,116,163,233,159,123,208,49,255,99,102,215,167,30,2,27,143,186,121,190,87,152,203,192,236,142,97,54,9,102,31,48,167,180,150,11,36,124,233,103,157,54,209,115,145,117,118,107,86,15,51,118,198,48,29,208,180,210,199,243,45,162,231,52,48,59,5,179,29,152,43,49,61,27,69,79,158,181,182,105,173,203,172,211,6,77,48,216,131,115,122,154,13,38,23,210,99,52,239,1,230,236,231,35,162,231,20,75,240,229,60,200,58,92,36,64,62,216,29,38,146,198,21,121,212,199,243,77,66,152,5,198,162,69,158,231,237,34,254,146,17,207,163,34,143,218,68,225,0,107,109,22,61,41,232,217,41,122,186,89,171,179,142,158,11,60,223,14,28,192,144,10,220,50,32,231,98,214,119,138,117,197,217,14,173,16,177,66,135,16,159,97,210,193,24,102,171,96,100,240,38,194,18,48,182,248,97,96,18,117,237,145,120,46,178,76,135,200,233,101,169,221,82,197,5,214,90,15,57,143,121,92,61,44,132,147,32,147,191,172,44,225,48,167,100,44,101,134,15,130,189,151,39,213,203,0,127,216,6,
244,94,76,237,131,236,236,160,99,148,24,10,230,187,194,211,201,132,15,199,192,209,206,140,15,27,192,115,72,120,74,12,119,128,167,44,60,125,194,115,20,28,242,243,15,235,204,163,77,96,167,168,131,248,50,206,240,199,253,8,28,68,39,160,21,201,47,227,20,150,96,203,12,111,229,57,74,57,82,249,248,147,48,29,230,207,141,162,168,19,76,91,99,138,190,2,211,11,158,84,119,136,162,163,80,180,151,181,87,222,66,81,103,204,153,156,143,36,117,172,242,113,82,136,142,129,164,157,41,31,118,128,200,172,76,17,160,29,68,127,181,225,69,217,64,158,117,205,79,47,26,73,152,71,25,237,108,149,157,116,153,13,0,35,91,106,19,217,174,234,147,193,0,179,59,182,37,207,136,60,139,71,178,129,93,178,129,18,138,105,151,98,228,71,86,227,149,97,198,96,138,60,223,33,209,244,0,179,94,48,135,129,233,130,51,102,81,131,136,179,52,204,172,151,161,244,67,198,70,137,33,203,140,77,130,185,200,115,43,125,93,1,21,26,211,89,96,14,64,46,52,99,85,162,231,24,35,155,99,122,182,107,45,249,217,6,214,163,214,235,118,194,239,229,185,4,12,
95,222,247,143,240,252,136,228,83,2,184,67,188,43,104,30,141,253,104,111,204,251,46,193,92,224,185,23,130,106,105,22,205,64,120,135,96,14,65,252,183,49,61,198,251,21,214,217,18,211,99,242,233,103,173,13,130,169,243,181,132,30,147,207,89,96,246,199,242,217,40,249,244,33,31,115,213,171,44,97,102,146,196,61,197,162,77,49,140,201,176,23,24,115,182,147,172,158,208,179,73,164,246,67,75,18,103,214,195,63,226,197,163,68,207,67,158,127,60,226,236,157,194,82,214,85,32,115,31,80,118,58,102,217,155,47,61,252,181,43,134,57,35,152,131,192,88,181,118,9,152,77,171,89,151,71,101,254,146,255,17,248,206,161,93,170,128,190,24,38,203,200,102,225,201,27,99,164,214,50,70,110,251,153,110,140,220,242,85,15,137,34,89,107,167,240,244,128,99,167,232,73,199,120,2,122,40,188,221,90,73,5,126,2,46,136,7,125,216,250,70,173,117,141,231,191,64,211,135,141,224,56,44,122,206,130,231,107,61,82,160,90,208,35,21,149,223,174,62,66,244,25,100,107,85,86,15,200,140,158,34,192,182,173,42,48,178,65,122,82,132,233,80,254,
115,126,197,162,151,12,24,190,142,195,197,81,45,113,139,89,255,164,37,14,178,196,38,150,184,193,226,7,62,95,252,237,192,167,139,191,253,65,16,71,128,88,105,19,136,4,250,181,168,56,1,204,17,33,86,33,191,17,70,48,99,246,28,224,92,57,15,224,122,124,157,130,236,28,225,18,123,62,141,186,15,50,234,181,196,35,205,50,24,73,54,203,26,31,142,241,188,83,235,188,101,214,94,45,177,137,37,250,181,252,33,134,187,84,229,168,180,178,58,247,8,76,88,121,113,156,149,143,9,166,23,24,171,169,85,90,237,137,41,252,150,210,106,129,202,234,134,12,234,40,6,101,251,218,83,140,152,148,175,178,194,86,209,229,118,98,160,185,10,26,27,57,14,154,163,66,211,15,140,237,7,148,76,214,51,211,18,142,249,253,0,28,219,118,86,69,215,70,225,113,165,35,28,43,252,236,230,241,138,54,32,57,17,232,10,4,20,160,224,239,55,96,170,90,146,218,132,71,218,116,110,20,163,231,97,84,251,183,251,159,83,11,39,63,165,22,10,32,55,67,59,18,11,199,109,38,160,166,13,146,202,98,79,241,237,176,74,201,243,140,236,19,233,23,32,221,54,100,142,44,
86,234,69,92,29,90,224,36,11,28,17,125,151,44,40,67,122,4,230,45,82,150,35,157,17,87,164,2,83,0,166,125,117,86,40,237,68,76,174,140,246,34,56,40,134,183,34,202,43,74,123,251,225,170,91,124,158,102,245,131,26,137,24,177,194,209,57,25,179,206,177,250,126,209,220,11,205,166,71,55,146,172,5,205,219,161,57,163,233,101,144,173,7,5,218,58,225,240,56,195,7,79,25,28,230,244,226,61,177,7,211,86,1,122,218,63,31,150,38,14,227,46,223,74,181,223,34,110,202,232,1,84,210,166,122,90,173,8,75,104,135,64,191,79,92,56,204,8,65,197,219,54,4,65,200,73,91,170,6,143,242,25,48,46,66,240,69,27,152,253,140,172,67,142,150,88,180,149,53,195,112,219,48,248,83,43,197,92,193,85,106,144,220,5,204,1,177,53,0,91,95,137,173,20,108,237,214,136,219,101,32,57,69,10,219,162,159,65,6,182,55,73,244,150,67,114,95,73,111,105,76,206,54,59,218,107,41,144,80,178,169,239,130,228,186,153,101,233,249,2,107,153,69,148,120,110,129,47,15,61,237,171,166,11,19,42,123,182,198,244,180,137,30,213,206,155,52,162,173,238,37,113,236,10,
126,150,56,12,158,211,210,155,226,129,188,109,101,47,214,119,190,206,221,206,49,210,41,152,139,192,216,234,206,214,192,163,232,102,219,212,173,224,185,42,152,12,48,219,99,43,182,48,112,158,17,235,57,105,150,111,35,65,15,51,97,80,132,17,230,74,132,57,11,124,3,80,183,67,52,247,32,4,89,32,133,89,218,69,154,20,122,179,118,212,97,196,98,101,88,196,115,219,99,119,50,163,91,124,93,98,100,167,164,113,150,181,14,136,30,37,15,219,198,187,182,11,126,118,16,63,59,35,10,51,240,181,93,48,73,24,113,30,131,190,10,16,102,30,163,16,177,25,233,195,169,140,5,204,46,193,132,126,166,181,190,150,47,186,62,25,192,135,153,113,90,244,148,152,209,34,81,165,108,22,48,74,102,73,82,52,219,79,65,179,173,229,98,161,199,179,87,210,80,252,176,109,175,243,51,184,232,128,139,62,233,75,249,223,26,76,137,190,92,140,129,102,167,175,132,66,118,223,174,133,193,116,117,19,54,130,2,93,168,169,1,204,85,56,221,170,13,117,15,35,59,37,40,193,180,11,38,207,136,245,14,52,210,1,28,192,231,81,28,143,92,175,241,114,165,242,233,
114,101,240,51,255,27,99,223,167,12,186,189,44,221,94,102,18,32,125,160,216,44,196,242,255,13,76,92,249,3,98,254,151,30,133,22,183,189,67,116,87,17,221,86,145,209,16,180,128,41,2,221,38,119,200,2,179,89,48,121,72,216,160,145,75,140,236,18,158,124,172,184,160,205,113,218,54,127,136,238,52,241,21,152,146,225,193,198,84,144,110,149,177,169,63,101,29,25,245,17,15,75,113,46,216,32,186,196,241,165,166,195,40,134,10,142,215,213,99,229,158,52,165,96,68,123,24,37,20,40,104,49,93,150,185,69,107,137,230,245,162,80,251,241,118,176,27,205,198,69,196,95,150,218,19,222,21,82,58,4,35,23,182,6,92,138,226,207,76,203,217,60,34,43,153,10,144,102,100,210,244,250,218,166,69,235,130,232,118,209,179,3,122,204,83,206,130,240,107,209,51,12,61,255,252,155,190,29,227,219,127,59,166,232,57,66,228,252,152,213,183,171,124,219,170,109,247,33,182,221,167,69,182,43,50,168,64,35,40,177,120,236,60,139,145,139,140,236,22,140,83,25,179,14,219,44,133,97,240,180,9,207,1,70,206,2,83,129,171,1,85,189,242,39,235,35,101,
248,203,186,79,71,64,99,85,153,147,7,147,54,50,41,167,112,117,14,221,236,215,172,99,192,88,79,217,45,126,158,205,217,249,202,29,185,174,11,73,200,69,6,189,69,254,153,180,147,68,223,30,113,117,9,106,118,138,154,78,16,159,19,197,46,19,129,88,45,191,211,178,36,231,186,140,156,103,100,175,96,212,226,110,103,150,154,24,15,52,160,170,209,58,4,234,31,127,43,59,86,83,107,183,106,240,43,236,7,44,232,93,66,41,59,53,114,158,145,125,130,41,89,248,226,75,134,89,214,101,43,130,199,182,165,234,213,88,115,76,173,169,77,224,34,200,168,97,10,201,106,179,106,113,76,148,69,161,192,44,220,68,122,150,191,14,172,210,99,102,124,210,21,36,125,60,106,251,124,92,206,120,156,156,2,158,87,224,249,184,67,208,119,64,61,4,45,31,14,176,170,245,203,58,89,209,164,241,128,71,34,243,195,238,152,32,215,107,100,254,47,204,191,6,29,204,58,201,44,240,92,140,73,156,225,81,143,72,124,196,35,245,232,125,77,2,65,79,209,155,122,173,31,190,69,152,150,156,148,228,54,74,165,227,241,163,163,60,82,69,250,140,39,63,105,246,36,
136,175,214,17,40,222,183,67,228,135,19,60,250,235,77,241,115,130,69,191,213,162,50,181,83,154,118,150,103,7,100,35,58,65,176,84,228,74,26,70,214,26,232,113,102,29,21,158,12,120,182,11,207,183,140,156,20,30,133,236,83,194,147,184,156,186,108,237,138,113,23,192,92,111,161,146,134,245,251,251,97,103,163,102,37,157,74,37,102,59,55,216,9,229,151,101,162,174,138,67,187,13,109,99,102,57,167,130,30,53,4,219,161,137,213,79,146,228,160,231,28,244,116,10,115,143,173,14,25,162,39,241,24,139,86,106,189,203,93,223,49,233,186,38,73,139,22,100,148,43,247,59,243,187,72,120,103,241,46,12,242,107,69,225,18,230,233,219,199,138,234,216,106,129,89,199,5,179,223,76,3,60,218,187,27,158,2,56,172,209,37,5,155,137,42,25,246,72,132,34,185,83,36,167,89,221,114,183,220,213,26,57,17,225,212,140,197,69,6,212,158,229,209,102,201,187,140,121,110,96,2,233,230,56,254,202,244,175,192,145,197,16,238,243,135,178,223,79,124,223,42,188,251,248,99,245,152,237,251,255,173,99,182,199,175,230,167,116,206,246,105,221,151,
83,179,235,254,215,186,117,255,190,169,178,238,223,183,12,110,251,253,212,236,202,21,198,226,47,51,124,153,209,200,4,95,38,86,174,126,233,250,109,221,23,44,238,75,79,101,235,239,169,202,186,223,187,126,107,251,157,124,249,239,191,44,28,249,146,2,40,53,209,245,37,117,151,207,187,124,62,230,243,49,159,149,117,95,210,139,219,126,79,47,174,99,14,127,131,53,53,195,231,77,62,111,242,57,206,231,120,215,151,174,183,109,192,110,253,157,79,224,78,126,73,205,49,62,199,243,123,124,222,227,243,5,159,47,248,20,62,158,165,231,60,190,120,221,103,60,127,198,243,39,124,62,1,223,146,199,183,212,128,207,175,151,138,225,133,111,25,124,203,30,223,20,243,167,192,243,128,207,7,124,198,244,189,247,248,222,123,124,241,252,105,224,166,129,123,206,231,115,62,133,175,2,62,228,99,252,242,189,217,103,23,114,116,176,240,92,105,243,240,213,215,95,186,12,193,250,47,61,139,91,108,176,171,178,254,247,158,197,63,127,73,63,2,233,163,31,152,212,198,2,82,128,38,125,255,37,253,144,241,135,63,124,233,154,103,252,37,200,
230,25,127,249,189,41,43,13,19,233,7,82,84,147,121,119,120,118,231,71,183,222,2,223,23,128,11,240,173,89,231,22,48,183,88,231,157,95,231,157,95,71,127,79,176,174,254,158,248,222,209,55,231,233,155,251,254,75,55,246,212,61,235,215,65,104,233,103,126,29,12,36,253,248,111,208,245,114,85,144,93,226,71,235,252,236,215,249,89,235,172,62,79,85,126,248,146,142,249,121,191,170,208,174,247,200,7,131,76,223,253,209,193,39,138,102,28,67,73,63,129,174,6,248,174,57,230,155,76,161,115,78,244,241,119,98,192,63,124,233,198,64,186,167,60,63,49,156,214,55,253,52,161,235,54,235,220,70,110,11,208,63,15,253,11,200,105,30,126,94,243,247,61,254,126,205,223,247,188,220,66,189,254,202,188,95,61,125,222,224,141,31,28,34,125,207,203,109,193,203,121,1,126,160,43,61,197,58,179,224,157,2,239,44,120,167,88,231,13,127,63,231,239,55,252,253,220,175,179,236,231,45,243,124,102,221,151,110,140,184,123,26,126,103,88,15,39,79,99,204,233,231,252,253,27,120,239,243,253,190,151,67,98,216,240,107,116,0,191,4,124,76,223,
82,3,188,183,43,211,143,217,162,135,143,237,77,240,166,159,38,248,205,62,60,60,54,148,158,133,30,224,229,216,233,135,240,131,99,167,31,122,126,22,61,63,139,224,51,61,48,47,208,219,26,187,14,248,143,253,138,96,230,228,70,80,51,185,45,194,215,36,235,78,178,238,162,151,119,168,159,152,31,173,51,15,220,60,112,242,31,179,171,38,240,4,170,244,4,250,153,98,29,217,193,20,235,200,14,8,44,230,63,4,150,196,127,66,250,204,198,60,63,177,220,180,142,173,223,100,157,216,174,23,160,11,189,166,165,87,236,195,5,68,198,224,193,100,103,1,202,219,171,231,83,122,50,191,135,62,139,47,243,208,11,127,242,1,250,197,4,254,142,223,249,221,71,158,137,215,118,130,127,117,87,189,131,143,19,184,42,4,174,113,1,16,184,42,4,46,31,56,214,4,20,111,200,138,132,105,20,104,81,16,5,154,130,127,245,68,254,186,214,96,157,115,122,129,196,134,39,129,16,169,211,227,158,129,80,128,62,208,24,94,2,147,49,79,96,178,117,159,250,117,159,122,65,4,142,30,43,210,224,20,88,21,112,9,68,233,167,172,243,180,201,58,177,162,230,3,131,136,
21,252,152,249,82,240,227,38,235,24,62,207,79,108,232,226,199,130,165,214,1,95,72,87,104,120,1,188,25,210,184,95,103,220,203,45,112,12,231,228,126,29,178,112,122,230,239,24,172,55,176,70,254,149,169,45,160,144,169,147,128,18,58,134,201,65,134,3,220,172,151,219,108,131,220,130,4,145,142,29,93,124,134,252,200,33,159,48,95,14,249,164,137,29,196,1,72,243,66,59,176,68,208,68,63,22,136,225,255,109,176,206,91,111,7,247,60,157,247,252,58,208,109,14,32,186,125,2,177,128,18,58,160,5,104,191,78,24,136,67,125,6,114,182,0,211,200,15,118,101,235,96,87,221,56,97,247,164,215,79,236,184,178,3,31,56,204,127,194,117,98,71,23,255,47,209,231,75,167,79,91,71,118,45,185,197,118,29,6,226,216,78,53,47,12,92,161,93,7,118,19,251,149,233,115,198,203,105,6,185,41,113,198,1,242,253,90,57,116,67,83,247,75,207,143,241,224,237,205,251,189,241,19,174,227,215,151,29,167,198,193,173,181,228,51,216,105,106,156,138,208,87,128,22,144,8,162,221,210,209,148,112,182,81,96,240,28,30,83,11,170,192,176,27,18,160,201,117,
138,241,138,175,192,22,153,35,121,47,2,255,50,30,63,149,4,184,244,50,1,110,185,195,87,130,194,75,128,91,174,206,26,0,191,96,98,21,25,191,112,194,3,87,145,101,8,108,25,42,34,57,104,134,69,244,76,17,52,131,161,101,110,195,56,153,52,30,87,38,149,225,101,48,206,204,29,112,188,117,2,203,120,199,201,160,232,204,47,60,251,197,9,44,153,167,113,91,199,85,48,241,120,74,227,100,230,12,153,89,2,19,30,9,75,120,36,160,100,29,31,209,235,214,33,187,103,158,55,89,135,0,154,241,1,180,14,30,7,205,60,6,94,244,123,62,187,228,56,90,215,7,182,140,5,54,71,135,4,159,97,221,46,42,184,12,74,205,60,133,223,151,46,147,100,168,192,50,148,218,202,148,153,86,235,217,28,214,35,144,38,235,41,144,162,216,140,15,216,25,111,216,241,115,147,187,225,107,194,151,225,107,162,39,147,223,90,120,147,159,241,44,58,155,232,41,150,71,160,119,227,7,131,207,192,167,12,176,78,126,56,73,102,210,5,68,211,147,201,7,126,48,200,140,18,18,6,153,33,33,173,153,71,69,151,81,165,137,163,197,124,170,2,204,152,254,154,172,211,130,127,5,
236,204,35,214,33,96,103,30,249,117,188,227,101,168,108,50,49,125,84,60,201,58,36,226,12,1,38,243,196,175,227,3,182,232,116,240,77,228,38,58,9,120,25,37,22,11,8,171,248,76,63,49,63,146,27,9,45,195,150,208,228,102,115,252,58,62,113,103,168,76,51,49,188,236,46,182,27,217,157,232,52,94,153,239,43,179,58,121,83,1,102,30,173,165,47,99,122,107,34,55,18,109,230,217,90,57,155,125,63,243,126,245,236,111,232,167,145,31,130,93,134,74,111,141,62,67,191,139,249,145,191,202,143,148,40,229,191,36,156,53,243,72,138,25,191,131,74,244,195,188,212,91,2,155,197,17,5,56,214,67,142,41,85,240,208,227,130,158,228,75,160,123,197,248,43,2,99,188,133,142,255,78,2,35,207,23,93,224,212,22,156,245,13,159,240,112,110,224,10,186,56,238,169,160,179,29,129,223,81,129,195,109,117,73,84,113,130,181,121,110,92,250,149,190,92,18,93,213,87,221,14,246,30,176,247,160,91,59,15,228,162,173,184,237,60,90,85,210,126,71,98,5,29,246,98,5,157,118,50,218,33,42,30,105,39,234,227,81,184,78,55,201,174,91,21,173,118,16,170,192,
181,131,32,174,252,221,74,122,22,186,176,87,181,48,186,208,143,237,228,84,104,105,39,103,133,214,234,115,233,193,21,52,206,223,195,194,54,109,197,128,179,11,141,75,206,105,237,88,44,57,194,255,187,85,60,93,239,88,71,133,150,118,114,42,180,216,201,53,22,130,221,224,235,246,250,174,43,128,124,97,96,240,161,126,238,194,3,59,225,174,55,193,58,111,36,55,254,182,162,0,254,222,137,190,213,231,198,79,76,95,48,46,189,174,22,168,208,25,22,38,113,1,40,250,165,31,209,47,253,200,14,140,182,192,14,194,66,61,94,71,133,69,92,152,104,7,143,223,38,157,130,16,62,230,167,81,63,90,87,118,160,117,99,59,8,229,237,237,215,236,59,44,28,61,221,242,191,208,110,226,2,76,241,218,244,73,188,150,222,236,111,197,7,253,109,241,97,149,110,201,109,181,0,98,94,178,129,184,137,78,225,135,157,186,201,217,219,187,201,217,118,221,216,141,214,145,220,132,87,114,19,61,138,223,178,23,31,191,235,232,107,225,119,78,63,77,252,148,216,169,141,210,26,255,81,193,61,201,58,42,28,39,93,28,170,91,199,111,72,140,30,209,39,122,160,
175,206,14,124,252,176,206,148,21,135,216,155,58,4,113,225,172,29,60,241,206,228,161,226,142,194,215,228,29,232,213,117,140,188,28,172,238,234,112,178,240,117,151,139,99,146,159,143,123,196,143,148,226,7,246,89,23,247,200,199,169,151,196,53,242,65,234,145,226,155,224,249,252,51,159,127,14,254,142,199,237,83,5,161,98,222,186,47,252,92,59,60,174,255,157,159,152,103,35,187,210,227,153,248,129,7,219,24,116,14,222,167,64,130,32,250,230,87,50,30,128,150,169,68,212,167,146,76,79,104,149,251,248,193,84,226,72,31,57,203,0,188,12,251,150,215,76,197,155,108,234,66,56,21,83,233,91,110,54,213,54,77,77,87,53,235,110,32,184,142,44,115,51,181,118,141,95,177,133,111,26,193,182,163,8,166,226,84,125,34,24,167,114,4,175,174,42,81,37,83,175,248,205,88,48,21,125,155,48,208,183,19,134,145,213,148,224,120,213,152,215,53,83,205,142,154,78,181,8,29,175,234,172,33,32,43,131,250,49,195,196,221,60,207,86,215,163,231,164,174,39,191,101,126,36,223,254,232,226,116,93,93,97,181,187,195,28,230,97,87,183,55,129,
255,19,120,254,212,4,62,193,223,80,31,249,58,95,186,168,195,79,92,202,60,108,130,191,174,206,161,45,79,140,115,124,208,150,95,188,249,37,51,202,188,209,38,243,172,238,197,144,240,247,12,115,228,239,86,7,90,29,228,252,81,117,169,242,147,213,123,228,153,140,207,51,25,54,166,25,117,148,148,215,173,206,101,221,101,249,9,176,252,235,89,94,185,108,198,180,118,195,100,15,92,211,27,72,171,42,220,44,237,154,116,144,112,115,213,67,99,143,20,133,162,68,20,210,139,117,146,113,21,73,157,198,172,26,20,167,171,146,83,68,117,187,160,38,26,72,36,218,0,111,227,77,224,255,2,215,127,105,130,255,46,227,202,168,90,23,211,74,118,54,247,248,126,175,9,60,45,131,140,122,186,70,167,36,23,104,108,25,141,121,205,40,34,214,89,158,167,215,36,238,163,134,42,228,212,43,224,232,133,242,137,133,120,205,249,76,156,81,207,207,214,105,148,87,117,143,23,180,119,35,87,227,17,99,209,2,223,93,211,238,103,114,196,207,206,118,234,114,64,220,101,7,115,124,204,97,181,0,146,72,223,117,28,199,227,150,211,194,92,235,157,207,
224,173,75,219,4,191,229,122,39,161,164,230,82,173,225,155,3,141,185,162,174,25,24,226,71,98,58,21,89,3,111,244,184,32,106,57,86,60,43,135,37,244,147,155,194,28,246,19,120,126,242,240,62,212,91,205,24,214,36,97,109,225,215,149,166,234,240,135,252,162,65,89,188,214,173,59,29,9,107,17,107,0,253,29,249,224,37,170,189,235,229,89,95,131,196,181,186,44,161,174,70,76,228,211,0,111,181,65,19,249,135,252,134,242,49,190,254,19,240,94,206,107,228,99,181,95,19,125,89,13,225,229,175,88,37,185,169,102,182,60,224,225,105,20,153,60,105,74,185,142,119,19,253,134,242,12,229,143,204,187,231,60,253,113,205,41,123,243,53,146,217,79,168,95,179,195,38,252,134,205,90,111,135,102,255,68,2,219,219,72,254,113,13,36,252,201,222,166,65,254,33,254,208,30,18,125,57,187,138,237,39,217,59,52,226,247,181,87,125,45,207,186,173,106,184,132,30,240,135,181,124,8,239,171,146,180,78,155,194,189,76,114,90,16,143,55,145,103,34,31,240,135,242,140,107,68,209,31,202,191,149,61,132,77,105,31,9,205,127,19,249,128,39,148,127,
40,207,80,254,9,61,13,240,86,131,123,250,67,120,191,55,49,121,122,191,83,15,206,197,31,103,111,41,237,67,146,24,65,86,155,165,232,176,26,116,159,183,167,125,126,143,126,197,50,85,108,15,169,138,254,86,109,10,156,209,11,156,253,125,133,8,238,143,137,19,94,149,45,193,27,195,27,93,171,240,245,250,94,197,235,246,34,49,220,85,203,12,102,219,62,19,51,207,199,127,101,226,234,171,213,212,177,16,20,71,11,31,118,251,7,228,49,155,241,97,95,195,64,82,87,197,16,127,157,75,152,113,68,39,16,141,121,201,144,187,196,39,55,207,84,62,236,5,121,56,96,9,75,41,187,177,216,249,235,171,198,69,156,232,92,121,231,82,27,223,97,45,230,0,27,113,217,250,67,167,227,32,25,72,22,129,62,42,155,164,206,88,254,235,108,227,34,78,142,182,72,29,100,204,137,15,88,153,197,214,156,52,10,97,237,34,49,39,240,140,46,156,100,80,210,194,135,61,13,162,55,93,52,21,23,139,204,7,156,204,175,93,36,224,100,173,194,67,156,173,57,129,62,140,63,41,64,231,91,235,68,218,11,56,89,252,207,113,194,212,68,39,139,255,31,56,73,189,16,191,
208,200,182,32,245,194,185,133,149,182,149,158,47,41,10,184,212,175,184,21,101,68,234,62,159,108,130,82,179,124,18,54,82,207,249,252,141,207,223,248,244,238,251,183,63,175,38,112,205,11,53,182,34,132,181,166,165,127,184,21,73,44,151,150,105,88,64,250,52,103,173,212,187,224,137,11,85,54,74,73,235,213,198,127,128,14,120,14,225,61,30,115,191,196,138,193,159,192,55,20,206,97,97,27,226,103,171,157,249,179,199,239,203,6,59,234,176,130,250,71,103,192,132,253,140,63,60,207,124,207,247,239,155,208,115,155,241,219,63,184,112,224,211,80,102,129,2,255,39,198,127,242,133,111,136,223,198,61,188,15,201,25,90,125,153,31,128,255,193,227,247,105,40,163,86,183,201,211,195,251,80,107,114,107,37,79,127,244,99,242,9,241,147,70,147,150,121,40,79,211,163,231,55,212,215,61,224,109,163,208,32,255,86,240,161,252,61,30,219,232,80,174,103,126,246,248,177,61,231,32,240,213,138,30,202,57,59,210,33,237,102,72,115,25,127,249,39,67,90,204,60,147,124,86,55,52,134,223,240,52,161,63,129,135,254,80,158,182,101,116,
242,76,77,203,86,92,233,38,186,82,211,164,47,108,36,181,120,37,177,127,159,25,174,56,5,91,255,37,12,218,56,130,25,88,19,195,240,14,178,198,80,67,199,9,21,97,10,245,140,132,140,83,87,100,30,52,49,140,80,80,161,97,183,82,68,168,184,16,222,240,120,252,161,161,218,186,77,232,33,175,187,51,132,6,69,216,186,30,62,196,239,215,53,197,249,113,59,35,108,37,159,86,252,154,33,121,71,72,28,173,193,144,66,69,123,57,172,145,127,232,56,56,136,234,85,115,192,80,62,161,161,122,7,180,64,148,224,199,193,19,250,145,3,245,112,134,107,127,218,239,172,158,229,52,200,231,54,48,58,123,109,52,236,4,127,3,124,24,72,67,123,240,114,174,119,4,214,109,37,127,127,118,107,240,158,47,147,127,211,241,15,115,102,232,233,101,101,127,191,241,94,246,27,111,22,112,27,105,10,101,111,40,214,76,253,35,227,127,116,138,209,56,2,119,215,255,136,116,218,160,186,98,206,111,132,84,152,34,136,180,23,68,221,70,154,123,151,233,155,77,224,105,74,165,105,122,73,145,33,254,212,28,127,115,107,129,79,127,11,131,34,23,6,221,161,143,195,
211,237,29,172,219,186,147,122,238,170,26,183,57,109,228,171,126,190,187,29,228,20,22,227,181,13,45,17,86,215,13,215,240,101,27,0,15,111,155,16,191,1,198,80,146,13,127,40,55,43,168,61,95,225,6,198,54,87,107,241,187,67,34,143,127,14,62,94,114,155,201,140,14,62,94,114,248,21,110,148,194,117,188,30,76,126,58,212,149,126,56,44,117,215,18,253,58,172,47,71,176,13,20,14,162,107,117,6,31,210,21,242,145,220,98,0,143,223,128,216,70,222,54,41,158,111,2,99,250,215,181,124,212,53,70,8,8,118,120,37,187,48,60,30,222,235,45,108,128,172,161,199,211,105,122,8,225,113,156,244,29,79,63,14,107,252,106,99,78,6,79,91,6,215,102,136,239,100,118,219,8,183,106,20,132,27,49,79,103,170,242,163,191,146,40,252,224,145,30,116,171,44,214,131,14,33,91,53,36,188,255,24,31,62,51,91,195,38,228,219,7,24,107,36,24,188,215,55,1,32,185,6,219,10,191,201,195,195,91,11,220,235,33,108,240,132,248,77,78,30,126,25,252,254,242,67,124,237,112,141,125,91,227,205,195,123,63,91,211,224,9,252,47,77,128,73,251,75,35,117,254,147,
208,211,224,111,247,128,247,135,37,117,240,97,131,36,176,211,110,116,210,189,232,233,153,71,15,108,116,220,85,71,252,97,25,61,120,255,90,195,71,168,135,105,111,31,211,216,71,184,78,104,79,97,35,192,78,1,188,92,195,70,76,232,111,97,28,8,229,212,74,111,230,39,127,75,174,13,241,54,180,139,80,111,9,191,245,246,221,13,140,139,127,224,9,110,73,153,92,56,84,227,211,14,213,92,44,198,255,30,3,167,219,72,143,25,215,245,102,236,220,96,77,38,226,157,113,181,120,117,91,205,203,195,29,246,51,207,39,84,217,181,230,116,251,102,125,119,203,22,57,173,101,98,70,198,95,255,173,107,45,195,103,134,198,173,252,101,181,74,35,209,37,9,211,141,139,126,171,220,195,132,137,220,147,74,211,18,157,139,43,117,248,201,67,73,66,14,225,177,207,140,191,206,94,7,223,170,64,8,11,64,111,7,70,79,43,252,73,1,66,194,71,126,25,110,199,89,37,107,52,56,59,200,216,46,196,217,153,107,223,123,250,57,212,53,126,57,212,117,213,177,135,15,233,247,114,147,252,235,232,183,241,24,222,249,75,178,93,85,139,223,228,247,119,118,44,240,
39,253,27,127,228,235,140,207,215,25,239,151,106,237,187,139,54,94,111,193,165,40,87,36,121,62,146,66,10,120,219,89,197,116,129,211,55,142,157,12,4,143,156,60,127,38,39,175,79,179,11,108,210,232,193,30,91,238,0,195,29,8,49,35,217,97,154,126,154,224,191,7,140,143,67,241,186,86,216,53,213,51,133,224,119,192,127,231,242,65,221,81,75,130,191,65,15,173,14,211,18,248,6,126,125,65,188,198,15,154,210,179,42,135,53,240,97,97,29,218,169,217,163,151,63,177,34,57,42,250,71,252,44,132,55,185,121,253,134,248,67,121,134,240,201,198,163,129,95,95,152,90,161,236,245,46,249,155,61,223,245,246,127,23,62,237,25,235,221,70,190,15,24,191,141,93,178,81,114,241,42,196,233,252,40,197,235,4,241,229,172,212,140,167,211,199,121,59,178,146,191,36,118,233,240,88,189,72,219,41,169,23,23,200,43,173,234,191,176,206,242,126,98,245,113,171,58,216,240,56,185,199,141,97,203,167,150,15,28,125,117,117,118,152,223,225,61,57,96,193,110,244,26,135,228,83,215,192,198,223,85,175,203,14,234,14,124,66,120,175,167,85,58,61,
61,173,240,135,240,86,15,54,129,247,235,202,111,227,60,254,55,235,172,240,210,137,95,87,240,226,167,219,31,160,116,163,47,87,111,193,147,223,104,181,172,179,176,219,164,254,243,241,193,234,72,63,110,114,242,122,183,241,123,192,203,223,117,201,107,145,239,186,76,165,215,75,66,61,132,117,147,233,161,137,92,91,241,29,54,238,67,185,218,186,77,244,108,235,254,45,185,162,207,127,68,15,86,127,9,127,131,30,90,233,205,234,147,181,151,114,76,15,13,121,188,238,192,206,31,132,153,92,67,186,124,93,107,246,199,56,159,110,95,152,212,41,13,124,216,120,19,190,195,125,71,136,223,143,175,193,223,10,222,234,50,175,183,144,158,86,240,166,207,38,244,180,210,91,176,143,168,151,185,226,15,151,29,193,103,239,31,222,71,31,198,43,121,255,62,151,125,216,103,216,251,129,117,254,11,60,245,165,222,63,76,61,1,222,100,9,60,239,15,186,75,70,193,237,112,111,83,172,233,214,137,231,77,242,106,204,178,106,63,230,77,50,15,219,182,203,148,236,125,82,243,252,205,188,86,239,255,173,61,157,248,27,245,65,171,252,77,220,
203,248,253,127,93,29,98,249,207,233,65,227,178,11,171,39,252,184,236,168,14,222,227,145,158,237,82,136,224,213,25,133,207,228,82,120,16,199,51,232,39,201,223,11,124,143,59,136,97,199,209,219,145,173,235,243,144,225,247,241,194,58,172,173,58,136,241,229,223,160,46,177,250,160,85,190,108,213,161,196,6,50,246,182,78,152,171,168,39,108,220,217,93,93,253,97,116,58,255,140,199,215,52,210,66,121,98,215,174,67,223,128,223,232,108,130,223,244,232,226,81,93,199,221,203,205,228,19,226,103,191,148,153,246,240,161,60,177,213,204,68,19,252,9,191,13,250,13,229,131,77,38,245,159,237,11,154,208,99,235,122,252,216,119,82,175,180,162,199,203,205,234,137,208,30,146,58,191,65,62,161,253,132,244,248,6,164,124,123,85,254,232,203,236,176,9,61,248,187,246,47,107,236,217,236,170,9,124,104,207,97,61,29,202,63,180,207,100,31,129,60,67,251,247,120,214,232,43,148,127,82,231,224,71,33,254,240,196,32,180,255,80,191,173,234,197,16,127,8,111,118,232,249,157,67,38,113,163,212,78,87,136,67,111,137,67,111,21,143,
144,171,215,143,213,249,117,126,192,126,165,238,120,141,198,123,43,253,121,187,95,19,47,90,209,215,74,127,62,46,152,254,66,249,146,239,146,151,38,124,63,205,46,163,89,92,104,162,111,79,167,211,135,250,69,13,7,8,161,222,67,185,121,251,177,121,161,222,67,186,66,248,208,239,66,191,104,197,119,232,119,173,224,67,59,52,62,188,30,67,191,176,184,221,36,46,89,220,110,2,31,238,27,67,250,169,75,155,238,199,147,43,110,13,113,195,228,227,240,167,94,5,182,243,202,231,65,226,129,189,255,254,136,121,188,181,153,122,68,222,248,149,188,106,121,240,148,179,55,207,119,221,123,253,58,21,50,27,39,111,234,253,121,120,85,158,148,30,156,239,235,117,211,205,62,111,1,99,175,155,254,203,37,43,80,87,55,128,241,101,130,5,105,156,131,97,203,66,174,227,188,122,141,147,149,160,70,59,82,179,248,48,147,250,113,203,44,137,196,254,65,120,31,225,141,218,132,67,60,221,36,236,51,111,104,81,225,89,104,24,25,194,76,205,56,18,112,153,55,204,212,161,103,180,202,44,166,169,38,158,209,106,103,27,102,210,144,30,143,103,141,
71,88,196,22,126,228,227,45,211,228,105,240,222,2,189,28,76,158,201,206,25,248,48,226,120,75,182,76,17,202,63,217,57,55,224,111,197,111,130,191,33,50,123,75,54,250,67,121,134,145,124,141,71,52,209,87,43,253,182,146,79,40,207,80,95,97,228,103,93,211,175,142,176,66,248,144,30,227,171,137,60,253,186,245,246,70,102,108,21,145,90,69,110,211,99,147,136,145,208,131,252,189,30,215,232,215,235,125,181,18,107,18,145,188,94,76,254,33,191,73,68,109,192,31,100,18,103,91,234,154,197,209,91,62,171,78,243,191,244,4,161,33,12,239,30,128,95,67,177,208,224,226,72,67,108,34,246,91,141,31,191,0,133,5,175,238,153,137,61,80,102,191,85,130,196,236,69,1,187,213,17,199,34,167,49,139,93,241,30,2,75,181,223,6,33,23,217,111,133,104,79,225,53,152,214,30,36,142,137,212,86,246,155,32,173,240,197,112,72,32,245,16,58,56,207,178,223,70,105,196,231,231,39,47,112,209,207,212,139,13,146,176,253,102,10,17,195,232,139,241,197,252,162,45,219,123,232,167,0,248,110,103,118,122,67,54,198,23,63,111,133,47,134,139,233,138,
255,110,164,15,239,182,55,111,19,121,184,117,215,208,23,207,39,87,166,158,174,198,252,212,45,47,191,91,218,187,34,191,152,174,186,207,213,189,88,55,227,171,63,67,16,254,102,138,14,137,108,131,230,82,64,221,225,91,162,160,213,166,131,8,12,15,59,221,111,90,184,16,151,8,140,38,73,242,219,34,129,225,200,5,234,154,23,33,126,20,106,191,201,82,7,15,30,63,190,102,19,143,194,210,227,206,37,227,117,13,63,46,223,244,48,152,80,150,28,30,122,23,179,230,210,61,198,253,117,146,85,131,132,78,12,59,237,223,136,172,107,130,217,184,75,25,117,240,56,132,222,184,90,35,159,86,240,40,84,63,137,176,6,158,80,208,244,112,210,154,4,77,248,37,84,166,237,141,211,192,96,37,127,195,223,4,222,203,65,97,35,150,155,66,86,124,184,182,134,30,28,56,109,215,91,66,135,229,22,54,6,238,154,95,140,135,135,134,158,175,53,250,50,250,61,191,62,197,91,147,203,26,8,77,228,233,155,55,107,232,9,225,125,202,48,60,173,228,73,105,145,52,33,19,120,248,181,230,151,232,65,14,132,238,228,144,145,128,144,182,205,227,234,184,201,199,
244,235,229,137,243,38,135,158,9,61,192,147,154,221,143,54,129,223,14,218,61,188,31,55,251,52,187,109,194,111,72,127,40,159,68,254,13,250,242,120,214,200,231,31,105,122,133,248,67,122,194,67,76,54,68,238,112,172,193,223,41,158,155,94,158,72,232,89,165,83,111,130,183,124,75,160,149,61,183,178,127,179,243,38,246,28,250,87,162,95,252,151,0,157,246,63,165,224,108,145,12,56,215,65,112,87,162,83,208,36,222,205,85,95,154,3,218,221,197,185,224,126,229,28,93,165,255,66,253,251,95,156,162,234,186,62,220,250,208,171,78,18,124,93,151,40,188,39,231,3,155,117,113,254,4,252,159,154,192,35,128,228,250,84,8,111,185,221,49,26,215,140,86,59,96,32,174,43,211,176,219,8,107,25,95,51,26,60,10,113,93,40,106,7,219,209,250,90,222,240,123,122,194,93,117,43,248,112,55,22,226,71,240,238,52,18,252,190,38,181,218,199,211,105,242,241,134,102,93,43,2,109,114,111,47,228,215,215,104,107,228,233,199,215,212,110,33,124,72,127,82,43,33,159,112,119,232,187,5,107,232,193,65,51,241,105,75,88,203,183,234,162,181,218,
69,27,254,255,132,190,60,158,250,90,158,154,52,193,143,60,201,214,234,54,153,60,9,72,153,233,70,252,31,51,171,41,223,151,34,238,34,109,92,34,184,212,159,89,244,155,60,251,221,0,191,201,75,20,221,96,72,223,177,144,29,23,50,30,42,14,143,111,218,46,13,21,17,110,26,90,109,194,194,34,55,196,223,106,27,237,233,92,99,24,161,162,67,67,106,113,60,151,105,213,30,243,155,21,83,132,23,120,189,163,53,24,118,232,56,33,253,161,99,50,78,180,161,245,199,102,37,52,12,239,32,134,223,227,49,195,14,29,211,111,182,140,223,80,158,137,35,160,151,208,80,67,122,252,143,6,233,183,16,226,251,127,138,122,117,237,183,219,232,49,190,16,236,223,173,206,112,141,98,245,55,89,128,15,29,39,212,87,216,78,74,54,61,13,248,77,14,222,80,195,64,225,55,115,198,175,31,55,195,54,7,108,2,159,216,103,131,35,132,244,132,242,79,2,75,3,124,24,24,151,225,61,254,13,149,86,240,161,60,177,43,244,224,218,255,161,252,67,123,243,114,88,19,88,66,249,132,240,97,211,34,196,31,6,210,208,241,61,157,107,236,63,193,223,192,111,232,143,33,
254,132,254,6,120,195,239,229,31,202,167,21,188,217,103,99,32,194,126,90,193,91,66,108,2,223,42,241,133,254,30,234,55,241,23,236,45,148,167,95,87,242,49,219,170,187,3,157,236,113,121,3,65,111,39,220,197,49,95,160,80,206,231,117,63,200,93,134,5,232,237,234,111,125,174,219,181,142,223,250,252,167,239,143,13,222,58,246,227,15,26,255,127,2,0,0,0,255,255,3,0,137,118,242,151);



programfile__AMINOR_MID
:array[0..2128] of byte=(
120,1,236,89,223,79,27,217,25,61,247,142,7,27,10,11,187,192,226,16,126,69,4,214,193,76,48,206,128,103,96,152,181,19,102,199,216,227,53,16,72,194,54,43,37,219,86,106,181,81,43,237,75,251,150,62,244,15,176,100,203,79,243,47,172,180,85,86,251,210,60,84,106,213,167,254,79,244,140,7,131,67,108,199,120,213,135,149,140,132,100,152,123,206,189,223,119,239,253,190,227,51,165,147,223,255,22,192,16,4,127,255,82,58,249,238,91,254,229,224,252,89,68,145,241,24,206,207,36,255,62,63,82,134,14,95,226,124,104,234,203,223,253,121,233,228,187,151,191,249,118,233,234,135,255,87,15,255,240,242,143,127,226,135,104,227,195,82,26,231,27,8,201,134,255,138,243,59,130,28,202,84,248,236,10,24,124,194,63,161,86,178,5,252,144,125,45,43,218,78,198,177,149,44,164,134,37,7,19,249,135,210,202,8,61,35,77,243,211,31,178,28,103,65,232,144,38,159,96,216,217,55,45,19,94,65,152,38,244,109,233,224,54,159,154,128,142,153,98,57,234,97,165,136,169,66,81,38,62,31,39,181,94,73,192,176,147,66,95,19,70,250,22,185,148,138,29,
112,9,3,191,182,147,112,247,68,129,159,19,82,79,204,218,144,6,164,142,51,23,145,108,17,137,29,149,248,116,101,223,83,19,24,207,98,217,61,144,246,3,232,105,97,108,143,239,227,35,29,176,193,213,67,84,12,124,188,239,197,92,152,182,14,35,129,130,43,245,212,228,62,134,109,140,112,213,6,198,242,133,241,2,50,121,8,231,145,170,237,204,147,119,177,162,97,79,95,131,181,44,204,141,121,43,88,61,99,248,136,116,249,138,195,5,174,195,250,76,154,91,115,141,39,12,252,140,24,81,201,150,161,61,220,114,242,81,13,76,214,178,3,85,183,133,149,22,230,174,200,31,220,38,69,35,19,147,121,12,57,197,29,107,83,232,91,194,1,76,75,57,42,127,76,234,88,152,71,78,52,227,29,143,30,193,42,187,74,218,100,202,102,200,190,80,73,195,50,103,97,175,168,185,137,91,12,205,132,154,195,227,92,66,181,53,148,10,210,92,139,149,49,158,131,176,17,99,182,73,247,188,82,130,240,142,149,196,214,40,241,41,102,58,82,124,58,236,225,190,119,160,232,105,216,91,48,204,72,17,113,14,149,204,58,140,32,202,73,15,138,251,249,158,125,15,198,93,
89,200,64,95,83,93,204,112,79,12,40,58,102,243,57,165,145,169,168,99,72,205,224,230,191,94,101,166,44,115,93,209,19,176,230,111,155,80,26,41,113,244,21,88,75,138,169,113,243,201,170,152,24,115,16,156,149,92,197,57,193,230,131,95,17,57,89,217,196,226,209,179,121,158,144,195,39,34,179,33,179,58,204,221,232,17,166,51,193,89,2,15,214,33,166,143,78,119,203,174,204,38,21,51,45,143,128,204,237,41,178,240,100,6,156,50,131,105,175,44,202,112,74,199,106,122,59,226,97,154,188,203,204,148,153,139,195,230,14,205,205,49,176,92,64,119,196,109,207,109,8,115,93,218,233,104,9,147,12,41,135,104,152,169,211,74,1,112,15,68,98,51,200,212,70,165,116,34,18,152,114,177,226,29,75,99,23,250,186,176,239,171,165,96,27,120,154,120,176,140,32,203,51,30,80,122,182,87,40,42,118,10,250,166,52,146,164,157,182,161,52,50,53,225,230,71,10,176,188,47,34,218,182,226,226,14,121,227,204,212,174,174,169,214,42,76,253,150,14,149,147,91,240,172,148,212,239,73,146,153,155,179,86,112,192,185,216,67,206,52,90,113,75,98,125,
47,184,37,201,138,247,165,92,71,212,69,138,187,82,44,75,110,121,118,77,245,16,227,184,49,158,239,8,163,204,226,147,34,70,189,135,59,5,71,102,83,48,214,132,157,156,240,48,194,21,49,97,6,62,113,93,149,43,114,10,82,219,21,46,130,72,201,123,24,209,144,41,150,133,101,240,166,242,168,193,188,131,236,244,52,23,66,234,104,37,27,156,179,145,34,98,158,187,151,223,83,179,235,194,186,199,93,229,212,211,204,133,21,108,194,104,112,156,31,101,221,130,146,120,48,66,82,201,11,114,63,95,146,60,110,46,12,215,131,193,0,31,40,118,34,146,191,92,47,163,84,152,193,125,119,196,197,230,62,215,254,72,177,87,193,35,100,36,23,26,199,144,119,247,211,253,71,209,44,246,246,33,157,47,20,45,19,220,129,21,102,112,135,59,168,107,138,21,63,229,254,147,198,66,220,1,147,132,87,131,106,53,168,86,131,106,53,168,86,191,136,106,213,162,195,254,214,93,135,253,87,224,109,244,149,234,83,139,189,101,117,245,187,104,177,183,44,244,126,127,90,140,212,186,223,170,197,200,165,248,189,107,49,226,211,126,119,45,70,70,225,223,84,
139,145,119,209,111,171,197,72,151,247,219,106,49,98,132,255,115,180,24,169,99,97,30,219,104,49,178,47,248,55,210,98,164,123,238,95,106,49,226,83,204,116,123,45,198,161,146,89,239,71,139,145,119,149,153,234,85,139,113,166,156,31,106,49,34,39,253,254,180,24,89,120,50,59,104,49,242,46,51,83,55,208,98,164,59,245,47,181,24,241,27,126,39,45,198,161,194,239,79,139,145,55,206,76,245,170,197,56,211,168,31,106,49,34,147,126,39,45,198,113,99,60,223,253,104,177,144,183,179,22,35,117,212,191,169,22,35,169,228,5,233,168,197,46,214,219,143,22,35,245,10,51,216,94,139,145,247,213,160,90,93,211,98,76,202,160,90,5,223,177,47,190,57,242,4,13,170,85,79,223,28,153,169,65,181,66,236,255,88,173,174,180,216,208,223,175,105,177,205,119,76,49,252,11,120,19,253,70,125,195,202,90,213,118,44,13,233,75,31,236,13,59,97,181,169,189,142,45,51,180,191,104,29,209,205,226,119,232,51,250,93,132,233,213,86,141,69,140,82,109,209,88,242,93,167,235,107,122,92,196,100,136,209,155,214,214,124,232,107,17,41,170,6,142,27,
142,22,237,44,218,28,161,151,117,70,255,138,152,197,106,91,205,68,216,65,245,125,243,138,0,81,213,30,50,158,100,211,176,154,107,186,85,143,67,159,202,180,166,8,142,133,17,82,21,125,147,54,23,8,91,168,118,86,66,180,164,102,46,253,40,130,95,84,233,68,17,147,98,60,118,211,128,154,227,3,201,72,2,179,78,199,227,208,119,210,215,24,79,232,56,125,77,151,137,152,85,198,211,139,178,89,38,93,174,74,127,137,152,201,234,38,158,53,109,165,185,166,167,244,52,180,146,232,35,113,168,90,109,106,151,23,233,237,91,196,44,51,158,247,245,202,227,166,113,68,19,242,194,53,34,248,73,149,126,209,69,60,187,77,155,40,136,71,84,155,186,228,105,211,26,98,60,161,47,244,149,182,125,151,152,56,227,233,168,63,90,141,32,210,141,85,233,2,17,163,85,215,145,49,238,70,26,230,207,88,227,1,213,6,85,129,141,175,154,134,15,23,24,186,61,167,218,46,135,188,222,224,60,134,101,12,95,186,58,132,69,171,13,37,113,210,52,115,102,185,226,134,147,115,74,3,135,152,52,247,199,106,154,54,12,144,11,104,24,175,161,99,179,219,163,93,
67,162,21,78,222,94,34,144,244,213,224,14,13,238,208,224,14,117,181,60,63,116,135,174,26,151,114,28,54,174,127,79,127,175,254,200,155,85,187,214,157,126,100,173,171,117,239,78,132,233,181,214,238,68,140,82,235,222,157,136,201,16,115,189,59,17,41,106,157,186,19,49,139,181,182,221,137,176,131,218,251,221,137,0,81,251,96,119,34,56,22,70,120,209,157,8,91,168,245,216,157,8,126,81,99,119,34,38,197,120,174,186,19,31,72,70,210,173,59,17,179,202,120,122,234,78,164,203,213,216,157,136,153,172,117,239,78,28,170,214,90,187,19,49,203,140,167,167,238,68,240,147,26,187,211,69,60,87,221,137,15,68,173,123,119,34,38,206,120,122,234,78,164,27,171,177,59,17,163,213,90,187,83,227,65,247,238,68,204,6,231,121,167,59,17,22,173,117,233,78,196,164,185,63,87,221,233,98,158,203,239,176,189,118,39,18,173,112,242,246,221,137,164,87,55,43,242,143,240,102,253,103,248,123,181,78,15,238,39,222,174,122,23,15,238,39,238,91,189,121,211,38,110,244,62,148,212,122,189,245,6,146,75,169,183,220,192,15,188,15,37,62,93,
239,238,193,145,81,212,111,234,193,145,119,177,222,246,198,146,46,95,111,235,193,17,35,234,63,199,131,35,117,44,204,99,27,15,142,236,11,245,206,119,187,205,251,80,210,61,175,95,122,112,196,167,152,233,246,30,28,135,74,102,189,31,15,142,188,171,204,84,47,181,32,120,31,202,153,114,245,208,131,35,114,178,222,159,7,71,22,158,204,14,30,28,121,151,153,169,247,171,70,199,247,161,164,59,173,95,122,112,196,111,212,59,121,112,28,42,234,122,95,239,67,201,27,103,166,58,86,153,107,239,67,57,211,104,61,244,224,136,76,214,59,121,112,28,55,198,243,221,143,7,23,242,118,246,224,72,29,173,55,106,211,13,222,135,146,84,242,130,116,244,224,46,214,123,89,191,110,240,62,148,212,43,204,96,251,18,70,222,160,132,253,15,0,0,255,255,3,0,186,109,240,176);



programfile__HOTCAL_MID
:array[0..16824] of byte=(
120,1,236,125,235,115,27,87,150,223,33,209,205,55,197,151,248,16,197,247,3,162,64,145,32,64,8,15,130,128,90,13,2,32,41,138,166,104,81,52,12,209,180,33,8,54,12,153,18,69,170,45,219,227,65,129,146,53,169,74,213,196,36,55,169,242,135,249,148,143,91,149,154,217,217,77,101,226,84,165,42,95,146,127,97,171,246,19,255,133,173,202,206,110,146,154,252,238,61,13,160,65,81,30,239,204,100,50,227,165,62,180,26,183,207,57,247,220,243,186,231,62,121,251,238,71,105,34,170,161,42,106,163,231,183,239,62,205,225,215,37,250,77,162,250,159,136,126,115,199,86,227,252,25,253,230,29,69,169,238,169,163,223,56,137,1,26,7,233,55,54,245,222,227,7,31,60,162,223,40,45,139,143,247,31,62,26,138,124,240,40,155,121,252,116,103,90,253,249,103,160,65,52,68,84,251,49,37,137,182,136,26,52,84,240,191,223,254,90,95,111,250,185,150,111,252,90,167,113,125,171,91,167,214,159,107,212,249,181,190,243,190,78,61,218,110,159,70,67,225,253,225,48,93,214,50,55,53,242,233,153,131,29,157,158,234,153,62,157,134,244,173,126,157,6,
245,244,188,150,178,233,116,77,163,37,109,99,68,163,94,45,85,248,92,163,131,247,180,236,180,70,203,90,182,80,163,209,180,150,26,211,168,71,79,165,117,186,168,109,93,214,104,88,75,37,53,234,215,54,238,107,212,23,78,204,133,169,90,203,172,107,100,215,210,139,26,205,104,217,180,70,23,195,41,71,152,218,181,141,71,26,53,133,215,93,97,106,12,166,14,212,32,21,146,122,98,80,167,126,125,115,72,167,62,61,147,213,169,69,91,115,104,212,30,222,154,14,211,133,112,238,237,48,26,148,6,28,29,168,225,93,95,152,110,234,153,140,14,90,105,167,70,205,225,204,80,24,181,230,14,54,194,116,96,211,178,243,26,205,107,153,187,26,141,105,105,183,70,13,225,77,119,24,34,202,172,106,228,208,54,123,68,121,182,128,22,22,158,235,217,128,78,55,244,76,74,167,174,88,98,60,70,221,122,238,0,172,28,60,59,151,228,31,70,146,133,47,35,155,245,176,201,246,175,35,52,28,89,191,20,161,209,72,162,51,66,87,34,59,213,48,206,94,20,223,143,236,11,171,189,136,215,54,20,197,191,142,108,182,71,200,33,1,242,126,148,142,160,180,239,235,
72,166,47,66,67,209,108,7,96,191,128,5,125,29,165,222,72,238,54,32,81,80,245,117,36,61,8,176,77,128,87,235,187,14,157,94,126,172,103,251,241,101,16,206,208,140,47,206,175,77,35,203,214,162,116,69,84,173,83,163,150,18,102,166,101,94,118,106,20,209,118,240,99,85,219,149,246,188,255,80,163,142,112,238,114,152,134,195,251,47,242,176,172,230,63,181,150,236,74,183,206,246,107,52,168,229,94,246,106,20,142,100,66,17,10,70,182,132,164,34,185,77,136,92,223,238,209,105,76,223,125,217,10,171,222,63,183,234,63,140,85,159,199,135,63,84,164,61,143,15,255,239,34,221,121,124,56,207,31,254,156,51,177,121,116,89,191,212,126,206,41,110,21,82,94,153,232,150,210,228,78,31,210,228,186,232,244,208,90,246,131,157,199,200,148,107,162,31,124,248,232,225,158,250,139,207,36,236,16,18,228,135,50,65,158,161,134,187,72,144,95,36,15,245,101,10,47,82,240,6,57,215,201,187,248,162,235,23,90,62,116,232,165,102,39,85,133,169,86,167,170,32,189,216,12,173,145,71,35,72,206,161,213,252,66,163,175,166,180,252,200,161,
131,170,230,168,198,67,181,33,42,44,160,244,210,33,192,2,43,164,109,208,212,234,139,251,32,100,63,68,22,30,34,10,80,213,20,189,152,159,152,39,45,68,126,15,5,23,200,227,36,160,188,186,117,232,17,53,212,249,73,1,232,4,125,232,139,209,228,42,133,55,41,184,250,50,7,18,206,195,32,217,38,169,6,233,179,143,10,97,224,108,29,134,117,10,132,201,189,64,222,192,171,119,188,84,5,242,110,106,12,83,50,178,78,65,157,52,80,95,32,159,246,82,5,254,246,97,132,170,52,178,129,138,143,84,15,29,172,105,155,228,141,209,92,140,92,1,114,232,13,130,139,217,195,57,170,66,115,92,212,224,165,106,141,158,157,11,229,92,40,231,150,242,59,187,79,36,67,225,29,242,237,82,48,243,242,131,160,240,92,10,147,45,66,211,190,28,5,183,73,124,206,117,6,69,128,81,125,84,133,241,78,56,101,150,251,178,237,168,181,6,78,15,140,26,31,213,68,232,34,60,244,71,135,122,150,2,73,242,38,200,189,73,225,204,171,21,248,60,60,95,167,234,48,145,155,158,196,210,180,148,33,0,133,182,200,155,122,249,99,16,25,61,12,81,179,151,46,199,168,102,9,
35,32,42,124,8,66,117,135,193,52,233,162,126,114,102,94,205,57,73,13,147,18,36,69,167,207,254,248,76,35,18,69,208,240,4,197,183,200,135,8,187,241,114,29,124,47,34,36,214,72,161,161,241,54,12,214,227,116,208,24,75,145,142,150,109,80,104,157,230,150,235,68,208,250,8,65,171,38,70,132,16,141,160,21,162,248,121,208,58,15,90,223,43,104,137,174,249,210,225,239,99,239,61,22,255,124,11,198,232,208,242,221,191,197,69,151,0,54,162,229,213,195,74,87,253,106,248,148,151,34,1,193,92,91,126,234,141,142,234,0,192,180,150,31,254,131,53,96,149,107,236,250,45,13,24,5,216,140,150,239,63,124,205,109,191,234,125,221,99,171,0,221,32,40,134,210,52,151,32,71,234,213,7,33,170,150,41,19,146,170,141,115,95,61,247,213,179,124,245,197,189,67,88,11,108,198,155,38,45,67,49,244,105,57,114,16,185,136,52,162,57,34,47,117,204,137,238,138,96,77,72,107,189,162,11,232,213,178,164,239,8,51,139,101,201,155,65,31,216,142,100,26,253,2,178,90,128,121,201,22,131,235,229,72,223,165,88,142,230,64,92,152,37,38,117,209,187,
0,29,96,160,134,78,228,32,252,47,206,44,49,45,138,97,0,6,3,24,18,104,155,114,48,224,62,100,73,179,212,189,84,80,160,2,103,22,89,135,144,91,60,167,35,122,190,192,194,65,219,97,28,19,233,34,179,80,157,164,120,169,199,153,19,194,143,239,80,24,234,200,245,120,69,110,65,248,164,147,18,167,183,157,137,105,32,94,56,4,153,56,84,177,51,232,196,100,62,169,58,213,196,169,112,13,209,162,238,48,148,18,53,32,62,234,105,63,96,189,72,96,26,189,212,27,35,204,84,222,2,68,179,150,119,29,58,18,243,250,198,176,142,188,102,7,249,142,205,65,211,32,17,163,47,245,36,33,73,88,74,21,70,98,212,176,36,106,45,136,161,26,90,147,163,64,154,66,59,228,217,161,169,76,33,3,202,7,55,64,26,230,131,145,147,19,48,85,135,129,29,10,238,144,182,227,195,199,21,36,95,213,1,82,49,160,243,144,50,69,205,129,20,133,178,164,229,16,169,25,39,15,156,182,67,79,142,180,4,249,49,228,74,61,1,90,33,126,136,136,135,84,202,79,133,30,0,216,14,253,243,20,198,215,53,210,214,189,2,224,218,33,146,64,116,28,126,178,97,208,136,197,134,4,192,
122,14,39,211,228,78,11,153,249,50,20,204,62,21,144,13,135,110,154,113,103,218,125,52,142,113,155,27,9,228,90,39,6,163,62,44,214,236,82,96,71,180,11,61,192,23,135,1,145,254,125,17,204,9,212,112,6,195,196,1,57,204,195,96,177,0,1,82,189,150,7,195,182,67,119,134,2,50,57,12,167,158,11,242,93,64,28,8,164,33,126,200,17,77,173,13,111,245,133,105,72,219,153,5,83,85,129,28,198,157,212,124,24,205,137,44,81,223,25,0,74,246,16,66,14,139,97,38,68,86,29,165,22,64,172,9,9,248,210,200,113,41,2,81,228,10,16,75,190,64,135,192,141,208,93,232,24,254,27,201,142,131,129,136,48,128,194,194,202,238,5,153,214,85,163,245,43,84,16,253,102,221,161,240,70,200,55,231,2,114,63,198,221,213,72,234,48,158,238,157,91,167,208,38,233,9,207,156,200,237,234,161,77,151,190,65,177,164,72,0,189,137,106,224,78,162,182,78,240,213,16,195,108,246,22,45,193,114,82,176,133,234,24,213,35,223,13,145,234,165,8,192,62,57,60,55,223,115,243,253,115,54,223,243,9,170,243,9,170,239,53,107,23,220,162,232,174,8,167,78,116,161,57,90,202,
189,120,255,23,149,83,165,47,219,208,185,33,255,86,162,162,199,86,17,39,157,216,116,80,220,101,48,245,111,48,125,90,143,233,211,248,179,236,254,7,79,213,191,170,152,53,117,200,109,5,215,48,107,250,95,147,71,238,173,131,89,55,93,119,39,159,186,49,5,186,85,88,242,208,21,239,122,225,19,228,90,158,205,131,219,30,186,236,78,229,220,212,236,218,56,120,226,162,39,174,197,3,143,139,60,174,196,174,139,106,221,155,133,5,55,93,3,214,29,15,13,122,18,243,126,125,220,67,221,193,133,218,191,210,242,182,35,63,185,61,91,211,65,186,224,15,14,131,78,48,134,14,211,131,41,210,240,198,221,48,141,121,214,73,91,1,32,197,16,254,63,57,242,96,95,0,53,226,103,161,233,200,185,125,128,89,85,143,51,149,118,210,69,23,246,6,184,168,211,189,93,184,227,166,65,183,54,239,93,40,120,2,27,157,168,162,253,200,75,253,110,106,8,80,97,36,188,62,138,117,171,94,65,96,244,200,179,57,239,91,232,7,79,193,245,122,31,205,250,22,208,251,118,123,52,188,119,1,173,255,200,183,208,233,161,126,192,54,28,5,19,85,62,10,250,98,85,248,
208,122,20,36,59,38,87,67,91,248,69,193,163,192,178,13,165,13,71,33,234,198,239,158,35,111,172,62,64,151,80,212,123,20,240,215,120,105,26,165,181,71,152,192,9,111,206,7,99,98,243,133,79,171,15,146,10,136,233,35,76,13,251,104,20,16,42,168,94,212,211,99,40,237,57,210,54,219,117,236,168,160,250,208,198,44,122,195,96,186,15,16,67,71,90,18,3,209,58,64,92,62,18,9,239,202,188,182,118,89,71,58,140,41,233,141,43,33,234,212,231,104,110,131,180,100,19,160,15,180,35,232,93,35,101,142,14,148,32,186,86,116,239,217,102,57,9,133,92,201,129,52,69,199,204,82,178,73,206,120,99,102,170,96,15,110,32,17,67,94,33,122,109,100,114,216,2,130,36,5,54,166,167,90,100,218,135,121,235,194,72,112,157,144,121,133,115,45,160,36,103,163,28,225,36,5,147,72,205,154,48,129,37,103,150,10,3,152,226,9,3,111,91,224,201,162,43,162,100,27,37,173,72,42,24,104,208,187,66,115,232,222,83,173,176,33,153,184,79,120,145,3,108,211,220,54,74,192,53,114,244,194,144,119,83,14,40,211,173,152,85,71,238,63,71,118,1,148,98,32,27,178,
248,57,1,148,196,111,192,181,73,74,72,5,236,144,66,40,65,222,245,118,204,153,1,19,64,195,152,74,147,196,185,8,53,218,189,107,52,7,242,219,23,36,26,136,21,134,66,73,10,36,72,75,53,135,72,65,226,163,209,85,224,96,30,78,75,129,1,148,96,0,81,232,15,128,3,0,37,5,79,178,232,170,64,219,4,208,5,100,33,18,173,48,24,0,7,219,164,109,183,131,71,168,94,163,9,224,72,74,0,50,41,13,202,186,0,199,64,32,110,23,16,24,208,228,58,36,26,212,87,232,11,195,33,96,102,208,235,38,75,175,202,47,56,155,240,39,132,220,145,113,106,201,139,72,3,53,49,131,40,146,209,75,97,100,160,72,84,151,41,184,217,33,245,141,161,20,112,174,132,177,84,1,28,124,202,180,35,45,213,132,150,107,37,194,178,252,176,73,254,181,118,148,74,28,32,216,81,179,150,36,63,214,38,146,109,72,101,229,39,85,34,160,210,148,76,133,19,29,82,161,104,159,68,224,26,128,179,221,129,18,73,72,32,244,250,144,23,111,195,38,58,48,253,9,245,195,175,81,2,19,9,110,183,249,68,133,54,216,223,128,239,6,133,55,96,112,45,62,100,168,2,110,28,188,98,158,48,156,105,
133,183,248,4,90,225,178,111,65,2,37,208,100,56,14,236,246,10,108,219,183,66,97,81,130,37,15,65,169,23,203,41,40,10,138,34,204,197,162,153,99,190,85,72,3,203,44,16,8,128,4,165,94,239,188,208,117,120,11,234,175,13,136,162,81,160,193,186,2,219,23,229,26,11,196,89,24,244,162,186,77,10,108,192,36,161,89,1,4,8,48,30,216,186,24,144,22,41,41,233,168,30,202,237,224,73,90,240,4,194,176,220,240,102,43,236,3,214,5,160,1,12,184,4,165,68,153,18,86,143,4,177,24,48,47,0,19,163,13,8,25,227,175,33,207,34,249,32,244,173,54,143,92,196,9,210,168,103,131,124,144,86,234,162,71,52,72,108,152,186,228,89,38,31,164,149,104,199,130,146,143,234,130,52,44,74,128,150,128,144,73,78,208,20,46,123,98,178,104,19,64,140,55,234,89,97,32,140,53,48,42,17,148,122,61,144,150,208,49,23,97,196,50,38,24,16,150,210,10,50,80,6,128,186,225,170,240,151,208,118,151,76,217,149,16,13,9,247,17,190,8,105,169,24,162,195,125,186,197,124,237,22,66,80,167,244,40,56,240,216,28,218,40,208,218,1,129,66,0,93,134,220,49,254,12,109,194,
91,145,252,171,2,8,41,62,40,37,65,9,174,138,18,0,193,49,225,213,27,168,78,8,102,142,182,121,18,59,152,251,202,141,248,119,229,8,6,130,241,60,56,91,71,172,107,59,66,198,139,126,112,46,243,50,143,175,222,35,12,42,36,98,97,14,95,151,143,48,24,20,163,194,220,203,61,124,93,67,160,198,32,72,184,242,35,124,109,58,210,118,9,195,172,96,150,252,169,87,34,190,183,32,18,219,252,210,157,52,114,1,228,249,145,8,132,152,224,207,124,117,203,172,28,210,196,52,186,160,222,169,229,239,105,52,42,64,48,135,17,200,126,229,5,200,0,186,28,155,24,104,65,188,128,89,60,194,44,60,134,78,168,201,147,121,185,11,128,9,212,81,37,165,219,4,62,246,1,51,116,132,54,139,249,51,52,27,65,96,231,96,95,6,69,120,22,2,31,218,90,24,159,222,247,79,35,48,238,204,79,239,215,206,209,245,185,157,170,105,154,156,163,214,233,157,137,105,186,232,204,250,48,187,239,218,247,185,72,117,231,127,226,113,139,129,124,134,162,185,9,228,194,81,186,128,113,122,36,59,27,161,218,56,133,145,53,44,125,58,181,68,20,165,66,237,210,14,69,211,254,
40,85,45,209,13,1,148,246,196,73,137,144,38,144,119,11,215,209,63,68,105,206,187,251,213,91,96,195,177,251,220,251,57,102,245,146,88,103,152,194,96,58,175,78,161,35,117,82,147,43,127,208,230,66,18,240,121,97,216,77,29,158,207,11,61,30,234,243,238,123,189,164,155,204,84,69,83,180,156,26,141,82,205,50,93,90,222,169,138,103,111,160,158,101,114,226,61,154,9,68,169,118,153,92,203,57,138,102,209,227,230,131,152,169,57,90,166,250,40,117,198,83,162,55,182,31,69,51,85,113,26,136,210,64,120,183,26,242,42,44,195,6,10,73,68,75,12,61,35,217,139,17,17,209,234,49,238,236,70,104,138,96,226,34,211,33,139,84,20,245,97,192,26,199,144,62,243,130,228,18,131,24,158,222,153,219,21,161,86,207,118,98,114,9,162,6,197,129,57,49,197,64,90,186,3,61,27,226,23,186,141,1,44,238,206,9,168,3,44,69,3,6,150,88,24,14,231,41,152,47,52,159,204,222,108,35,237,106,147,174,222,141,55,45,69,85,210,122,155,116,229,217,109,37,177,86,143,231,67,93,33,109,240,93,173,142,180,3,47,120,189,25,164,145,80,158,180,125,111,136,106,
52,242,158,132,35,234,240,189,170,163,121,24,103,222,118,98,127,172,228,243,139,250,35,85,77,40,83,139,182,163,121,82,79,72,107,63,130,32,66,152,196,218,45,180,156,84,105,234,147,133,214,238,5,212,52,241,80,87,151,162,205,79,22,68,29,85,154,82,179,132,138,155,251,110,43,221,162,228,18,96,34,43,10,173,213,93,121,11,196,0,223,55,181,168,244,221,110,146,239,109,35,49,165,113,93,209,239,183,62,190,171,126,17,3,124,115,56,162,68,86,212,199,119,155,19,107,202,72,172,22,245,46,69,235,166,22,175,225,43,42,34,237,99,120,84,93,8,125,216,142,113,2,26,160,218,184,94,231,190,163,124,124,11,92,40,225,136,96,4,4,220,119,218,86,87,47,61,187,13,170,54,210,190,234,130,167,173,6,243,20,254,116,54,72,232,187,174,7,63,199,58,89,245,9,88,203,111,43,249,199,202,202,143,209,102,79,203,23,202,237,29,229,157,247,65,83,80,35,173,30,206,129,229,237,122,76,116,248,247,11,79,78,32,91,160,60,187,125,33,178,98,147,45,30,184,27,199,79,53,177,214,252,241,45,69,74,254,18,164,45,101,208,6,54,208,86,136,132,180,
174,135,122,227,236,205,17,249,62,4,176,237,165,186,154,37,21,173,39,45,142,180,51,30,164,96,112,63,23,196,140,79,214,17,160,213,240,167,228,251,244,203,147,135,122,179,196,184,143,150,79,45,182,65,232,80,224,131,35,31,12,143,150,125,48,143,207,107,133,12,66,111,171,250,125,219,252,3,85,201,42,208,221,252,158,186,254,169,114,243,71,202,120,94,249,113,30,205,250,16,141,243,126,174,236,236,171,239,60,81,244,71,202,86,182,102,40,163,220,126,79,81,19,4,98,234,9,171,230,93,193,40,65,203,3,225,220,83,88,84,195,187,90,13,105,35,80,35,84,164,38,90,32,100,210,58,183,151,20,232,202,247,174,208,143,84,136,6,141,181,221,82,86,87,133,165,65,56,80,148,100,180,14,172,143,196,192,119,221,221,184,104,41,228,41,237,240,160,14,22,184,164,237,188,167,81,175,158,123,87,167,1,4,196,200,254,211,19,88,74,205,82,11,208,103,111,194,80,29,0,238,187,45,12,132,180,43,120,130,120,122,189,25,156,64,164,164,141,130,89,112,66,107,224,173,89,188,104,195,12,211,184,222,132,214,160,94,210,250,161,133,174,187,74,
107,18,150,0,128,130,126,20,193,60,30,205,232,114,43,82,36,119,15,155,57,245,60,197,118,94,124,20,35,177,209,182,16,56,143,236,127,228,200,126,239,115,177,36,28,221,253,228,30,53,110,236,134,138,17,94,152,95,51,180,12,19,130,217,76,45,54,195,132,164,39,20,126,116,180,65,7,29,63,168,248,159,224,117,42,111,226,85,98,78,236,130,65,254,242,95,18,255,210,45,241,96,229,228,254,156,114,119,88,217,175,87,143,116,131,78,144,123,76,216,212,79,107,149,222,102,37,219,166,166,59,149,233,1,229,217,132,146,242,194,213,155,48,192,236,136,26,158,40,213,197,141,217,56,213,47,26,99,136,158,34,46,33,88,101,147,74,67,74,249,44,83,139,248,136,240,215,240,84,233,220,87,183,62,179,237,125,169,230,243,133,251,71,139,52,187,104,244,44,210,88,241,89,208,78,208,19,60,187,93,79,90,29,190,94,214,140,121,221,184,168,209,21,209,241,26,31,107,116,33,100,124,85,31,162,3,95,216,152,215,12,228,86,215,117,3,179,246,200,80,170,81,18,52,144,102,7,2,6,198,160,94,188,7,232,157,32,245,75,72,36,242,147,200,17,117,137,
37,135,213,23,117,227,185,102,52,98,45,36,108,32,250,138,19,6,113,227,163,56,181,46,27,243,113,163,10,35,167,101,163,58,78,72,168,107,226,198,124,212,176,197,233,189,40,117,47,24,7,254,5,122,20,49,122,34,52,182,108,184,208,13,136,62,203,247,174,226,250,64,105,205,41,15,158,162,129,220,169,21,30,254,56,175,206,239,41,235,31,42,16,4,194,40,105,109,200,103,26,226,134,43,78,141,192,93,166,198,184,17,140,83,213,178,113,109,153,90,227,6,178,174,186,168,241,20,25,217,156,102,4,79,134,239,137,94,37,159,191,126,180,104,96,44,53,184,72,13,55,69,3,46,223,164,17,228,10,234,199,183,16,174,71,208,111,52,161,141,161,12,186,203,25,12,25,195,70,13,114,37,236,97,175,69,184,87,67,134,59,132,37,27,163,48,34,14,93,24,1,76,205,235,185,249,136,81,139,213,148,8,117,158,84,15,42,68,85,71,218,190,239,228,71,54,165,167,69,217,190,164,222,25,85,30,95,83,26,253,96,120,226,40,178,139,148,231,102,132,188,145,221,121,61,135,141,43,179,58,213,105,217,17,116,34,225,156,56,189,161,101,145,168,85,133,211,242,84,
199,110,193,163,167,128,48,166,83,119,36,23,0,218,9,236,4,149,28,97,33,238,228,86,29,42,139,189,93,13,219,82,194,237,138,218,15,59,82,91,61,82,48,98,197,40,155,136,211,96,60,55,175,111,213,65,242,90,22,71,80,54,209,43,234,59,31,235,208,78,42,21,167,174,165,92,226,196,235,83,86,174,168,222,30,176,219,22,110,87,63,31,83,166,67,160,97,247,250,154,175,221,128,81,218,142,150,104,248,100,51,172,124,50,173,160,234,206,54,212,14,67,70,251,136,58,171,144,180,95,84,110,58,129,208,125,20,53,144,230,53,69,169,63,106,140,67,185,186,81,123,50,63,43,8,126,208,173,180,119,168,61,45,117,189,205,245,145,11,138,191,11,30,1,78,85,96,40,72,201,64,144,186,144,134,70,141,225,40,93,214,141,182,147,15,221,202,168,93,77,244,67,126,109,112,158,158,105,208,87,143,226,6,22,187,46,199,169,47,110,12,225,169,27,24,9,228,47,1,185,62,110,244,197,113,220,198,160,184,209,29,39,44,168,41,200,103,7,129,64,186,209,3,32,224,138,73,187,30,89,208,27,167,26,113,38,70,64,247,72,104,164,195,24,181,200,143,87,37,96,83,204,
240,137,108,18,185,194,231,247,154,134,239,137,68,7,73,3,76,115,39,141,188,163,46,254,80,253,252,158,232,194,187,23,154,97,138,173,73,229,65,170,30,38,11,203,236,186,91,15,75,187,188,85,125,20,163,234,147,201,143,84,251,227,166,108,78,89,220,128,40,59,142,98,6,22,215,122,217,185,99,134,56,28,195,109,89,50,62,56,65,174,217,117,23,9,108,23,82,18,153,181,117,161,195,239,76,139,180,46,254,172,249,193,83,5,217,14,200,32,79,65,164,216,94,2,164,72,126,80,107,103,186,254,65,10,76,136,156,78,230,38,205,72,118,144,53,124,124,171,30,145,67,146,26,134,18,239,159,188,59,175,54,123,133,53,66,225,95,142,40,144,47,212,222,222,161,68,46,168,48,166,9,161,209,22,232,100,252,36,95,165,140,212,170,67,245,74,127,163,242,184,89,121,212,34,244,215,218,9,205,53,67,151,64,130,93,195,222,96,14,147,67,42,20,4,27,255,124,76,29,181,43,67,19,202,128,67,93,152,18,198,242,241,140,218,225,86,96,144,129,235,117,48,91,216,217,182,191,174,110,174,222,21,172,123,119,30,70,166,194,166,144,71,31,105,70,75,148,6,17,
141,116,3,123,47,17,153,38,112,174,41,100,12,132,176,196,102,228,48,71,112,210,57,35,236,83,40,232,100,92,181,17,93,115,84,41,171,53,42,152,131,53,105,173,42,172,31,54,53,211,167,172,142,171,97,151,114,237,6,148,85,11,149,183,196,141,119,96,23,113,163,254,196,22,86,63,158,81,62,181,43,249,33,209,238,153,190,129,59,163,130,61,97,183,113,106,63,25,112,192,178,85,225,188,113,99,14,198,173,194,169,96,234,179,189,192,81,3,215,1,7,115,34,117,217,152,92,166,54,214,89,220,184,18,167,206,152,225,198,114,105,212,112,70,169,121,193,72,157,200,202,125,112,33,72,0,50,1,83,31,116,55,193,220,81,59,156,170,110,78,93,185,162,220,191,172,124,40,164,222,220,112,73,89,186,170,216,194,136,208,35,234,188,26,155,20,189,1,127,66,179,236,99,64,105,59,90,160,203,39,8,31,224,29,82,71,131,87,107,170,193,100,245,137,163,10,252,206,194,255,33,10,112,139,47,96,56,120,81,109,238,86,106,47,139,70,78,140,216,192,115,245,9,186,151,176,75,204,168,86,193,2,80,149,64,127,27,65,19,86,223,203,175,181,96,91,121,234,
16,21,64,168,247,8,134,80,143,47,238,147,42,82,239,40,34,192,104,173,16,177,208,57,216,232,112,195,150,219,65,186,109,217,8,46,83,21,34,250,10,156,137,52,164,59,72,160,145,100,171,28,190,17,187,243,152,123,93,161,218,183,12,247,91,212,176,98,68,197,168,76,102,224,147,71,203,134,186,66,8,213,1,112,37,164,140,64,178,212,80,117,180,138,152,112,71,81,239,81,47,172,16,149,143,171,176,69,229,86,29,155,163,218,219,172,102,219,20,216,34,120,133,253,65,70,48,56,200,26,230,69,90,235,209,91,134,178,74,93,111,209,200,154,97,95,163,174,59,198,236,29,170,127,219,240,188,77,117,171,134,123,149,26,86,141,249,219,70,213,42,93,185,77,23,87,161,47,184,19,124,9,190,199,153,63,50,52,232,66,118,67,162,29,151,183,154,144,123,203,129,64,63,6,74,31,223,106,0,219,213,232,166,26,16,14,0,229,190,211,44,243,116,17,8,238,198,109,240,181,200,10,70,27,213,71,171,84,127,210,118,139,157,181,87,142,148,68,47,254,236,246,40,252,31,221,150,8,123,46,176,108,31,83,209,96,58,9,183,87,191,93,93,43,213,169,162,181,80,
2,4,14,93,194,236,217,207,164,147,137,88,10,101,126,50,173,166,188,104,237,14,106,105,184,99,140,221,161,158,85,99,65,132,232,15,221,2,4,190,176,219,168,200,0,29,2,72,239,170,113,249,4,25,7,44,10,233,6,76,99,122,64,248,44,0,135,38,84,216,253,229,107,8,176,194,62,65,180,110,14,116,61,240,95,24,33,156,140,168,13,157,216,151,35,92,95,255,182,95,133,250,97,95,90,107,61,42,17,22,233,135,184,6,110,58,213,137,17,48,90,7,72,88,26,105,63,18,213,158,120,2,34,138,67,173,171,53,160,212,140,134,206,139,110,99,168,30,74,20,237,67,29,233,78,117,251,146,136,35,96,200,62,86,191,58,14,12,68,39,14,34,194,151,31,122,132,102,225,27,24,124,130,104,211,170,209,191,74,131,119,140,153,59,226,125,29,126,13,158,5,123,136,51,0,71,67,16,222,96,201,8,68,104,32,252,14,14,5,39,6,183,31,118,168,8,101,183,234,46,8,50,39,240,22,41,120,124,248,114,164,166,115,70,80,129,68,189,62,21,2,222,28,132,251,212,1,25,229,176,6,248,70,171,7,121,124,19,48,219,87,141,192,42,217,86,140,192,9,152,242,246,192,5,231,17,18,81,53,
34,4,250,75,88,34,156,90,196,145,101,67,89,161,232,9,156,9,129,245,51,85,152,47,154,13,113,194,75,17,77,33,22,24,49,80,97,199,8,18,69,17,8,71,0,239,104,193,194,148,32,6,194,104,25,194,39,34,0,228,169,138,192,137,170,62,131,13,205,44,27,61,203,34,109,234,92,166,43,197,119,46,233,93,166,145,101,163,123,153,198,151,141,129,37,145,127,245,35,98,44,33,20,98,176,106,224,124,166,45,108,204,98,62,32,38,58,200,151,93,24,51,78,198,168,176,180,130,12,12,86,190,189,84,189,186,90,139,225,248,123,9,197,190,45,186,29,239,199,170,152,80,120,34,6,229,241,103,54,239,231,42,6,229,72,58,187,225,219,67,43,198,229,21,26,151,207,225,21,227,210,10,225,137,18,60,251,87,168,249,228,199,249,250,149,31,215,245,126,105,59,90,49,170,78,62,250,162,25,99,120,4,134,245,79,65,169,10,248,117,39,157,251,117,232,221,92,187,232,42,107,36,144,254,168,187,53,167,226,91,211,9,58,219,201,143,26,80,106,59,249,44,211,22,127,168,204,63,0,33,4,181,7,41,21,19,28,152,245,216,223,66,111,43,146,99,112,11,56,58,185,246,142,232,
26,209,15,167,215,235,1,106,59,129,147,38,196,196,205,133,103,183,235,34,43,109,240,195,237,165,122,244,143,95,196,234,225,176,79,22,192,5,200,99,22,0,147,77,114,246,224,2,199,166,75,144,217,50,178,13,26,88,49,38,86,232,226,178,81,104,92,166,171,43,6,166,124,235,150,141,169,101,209,193,136,236,51,142,144,181,25,174,129,47,33,234,74,83,67,66,166,194,194,161,112,196,206,113,21,86,226,192,19,157,236,82,67,221,110,163,26,107,18,221,42,219,2,32,225,8,48,7,248,2,112,225,241,176,87,181,95,133,17,194,29,68,191,36,60,83,197,48,66,246,151,183,241,222,225,190,36,29,239,6,98,112,143,232,213,225,137,32,70,212,42,82,179,184,225,71,2,127,34,186,137,8,98,21,204,17,94,129,190,7,243,6,72,193,145,43,17,146,114,164,233,113,178,45,139,76,189,49,106,208,18,82,94,3,147,154,88,208,28,9,81,75,68,80,193,0,0,251,135,49,219,55,134,9,29,208,141,26,243,1,3,185,85,99,148,134,3,116,65,51,40,98,204,251,196,128,161,9,123,172,125,212,13,154,186,52,43,175,72,212,176,125,105,208,99,204,187,13,204,202,6,93,6,246,
88,7,92,216,138,99,248,220,56,69,97,204,123,13,204,150,99,116,129,73,108,236,159,170,13,26,46,76,81,69,140,139,39,48,183,124,190,27,204,54,157,236,111,85,161,65,34,86,94,65,150,215,134,92,29,167,162,195,134,88,240,211,140,187,39,152,43,131,206,49,76,152,124,142,17,144,29,131,131,203,91,34,202,98,208,141,185,20,216,5,198,71,249,252,48,156,111,254,129,242,246,102,253,59,239,219,90,190,64,201,136,40,223,174,195,48,42,159,191,130,81,5,40,192,96,100,94,85,131,252,63,22,53,48,169,122,73,182,175,32,166,167,223,69,33,230,111,39,208,95,118,35,91,65,179,7,80,138,195,206,10,62,212,226,244,45,4,8,54,81,86,184,14,62,109,81,106,7,232,8,58,208,139,40,187,14,37,21,90,37,174,116,183,17,1,247,12,217,33,242,113,172,77,146,3,73,161,137,174,139,156,17,7,181,81,58,12,108,148,138,165,201,91,32,0,121,22,122,150,12,138,25,98,37,50,43,176,151,232,185,84,37,173,26,215,87,197,254,32,155,212,61,148,171,194,251,209,239,47,19,150,34,107,165,82,160,77,7,178,94,57,197,15,107,5,12,176,198,1,176,138,222,155,26,
138,136,227,152,63,198,118,32,204,18,23,177,198,48,134,66,9,22,34,139,88,232,176,177,223,172,110,21,140,10,35,1,169,81,24,21,12,110,25,135,202,5,203,40,52,233,32,192,20,177,102,86,137,150,49,170,5,125,19,11,28,214,193,129,100,40,98,44,59,167,222,88,178,41,97,137,241,93,185,34,112,139,236,191,13,189,103,177,34,136,229,26,6,80,24,244,97,93,180,136,117,121,153,108,82,32,189,16,44,100,182,98,56,87,16,234,132,196,170,80,187,44,20,89,120,72,114,27,51,170,192,252,18,14,242,136,249,216,234,24,169,69,44,63,54,54,34,124,20,81,0,115,37,70,29,69,44,8,138,150,104,74,170,177,174,136,130,149,210,57,0,200,159,112,37,116,0,182,24,181,198,168,241,4,93,42,122,222,112,59,33,17,87,78,122,90,170,49,147,107,59,65,28,56,2,135,39,253,141,36,122,163,117,163,247,4,185,118,107,167,138,12,17,61,42,250,103,116,206,24,93,33,227,10,92,183,113,47,224,10,138,46,64,14,205,10,143,143,214,201,179,68,141,171,116,95,58,49,218,138,17,45,60,85,180,91,214,143,165,134,43,75,98,175,28,156,219,6,214,228,87,15,6,182,24,101,
98,229,160,136,53,43,151,46,176,169,172,186,136,126,21,91,27,176,132,161,81,107,17,203,171,137,18,165,136,130,197,40,84,13,34,162,149,69,44,59,96,36,41,36,240,92,151,219,172,26,144,166,54,102,129,2,226,22,172,171,81,177,212,128,67,22,205,69,44,87,17,171,186,132,181,68,53,43,162,186,18,135,147,160,131,157,4,75,229,118,93,199,66,48,134,228,69,20,44,198,160,31,194,42,12,94,134,22,76,187,67,188,110,88,16,163,12,50,75,200,9,243,1,157,5,44,155,74,158,23,196,0,4,235,120,117,11,84,91,196,114,2,5,102,14,203,42,34,226,128,88,93,17,30,232,240,191,43,8,6,216,27,2,58,37,44,248,220,50,169,40,41,98,13,105,232,51,168,126,1,240,194,48,105,205,56,216,88,161,214,53,177,136,180,47,163,46,28,202,11,95,198,170,10,140,220,44,161,153,48,53,161,50,179,68,28,120,153,194,138,26,206,165,225,14,134,34,22,166,59,176,22,131,245,31,225,29,178,240,170,112,91,106,46,33,98,182,1,40,65,121,20,174,136,229,71,69,194,125,202,117,97,230,1,221,68,35,34,127,17,209,141,197,98,20,2,178,136,117,29,116,100,132,41,213,101,
7,135,146,20,34,57,243,9,44,112,40,98,78,17,11,117,149,224,81,5,34,198,68,152,90,139,240,104,20,132,128,118,169,17,177,82,88,93,196,26,0,123,232,185,150,197,204,128,176,236,101,49,63,6,159,69,148,195,44,149,8,29,81,3,60,99,135,107,117,64,86,141,121,135,40,141,4,48,143,35,182,92,212,22,177,48,211,98,134,181,168,1,51,2,58,176,154,138,40,136,114,192,26,12,136,112,135,105,47,225,245,178,46,183,92,235,67,71,41,68,36,11,209,251,0,6,20,218,37,0,2,233,193,173,101,106,94,37,140,98,63,131,158,37,223,30,136,15,30,134,70,162,121,178,208,137,230,193,57,176,86,239,51,72,22,218,161,9,152,185,15,215,104,152,88,51,104,39,236,23,113,176,136,5,155,66,227,177,48,218,90,196,114,4,1,47,214,158,107,138,88,184,174,3,214,7,48,211,30,35,6,99,97,71,76,99,17,107,70,86,141,37,127,181,136,229,150,86,111,197,66,237,88,194,133,9,87,23,177,176,135,8,166,141,93,179,165,186,252,48,50,201,146,173,200,225,56,58,106,108,67,133,178,139,88,65,185,120,94,143,67,24,144,151,12,133,206,24,212,128,85,183,98,192,93,162,105,
217,209,97,97,186,102,206,32,89,238,18,239,132,222,175,20,112,177,212,14,53,215,22,177,16,30,174,97,103,42,66,87,17,5,179,77,67,216,31,130,141,45,152,240,41,214,229,130,29,8,48,179,46,68,163,193,152,0,64,93,42,166,163,196,132,5,114,45,164,255,75,13,36,122,94,4,202,85,163,11,17,89,228,226,24,50,96,8,133,84,11,235,44,251,136,212,173,171,4,46,190,44,246,44,231,253,236,121,63,91,236,92,206,251,217,243,126,246,188,159,61,239,103,35,216,85,113,222,207,138,201,165,223,187,159,221,21,179,121,88,22,26,112,216,142,176,107,8,91,151,176,123,10,107,106,152,182,172,237,105,193,164,97,23,186,109,116,222,152,25,137,77,138,9,49,210,94,140,253,213,169,253,217,125,24,129,35,89,68,70,84,222,150,141,35,70,191,177,93,184,249,224,241,179,189,253,210,222,236,95,126,70,226,223,16,81,45,110,180,152,161,45,228,210,31,145,184,209,226,216,137,51,213,216,8,154,186,240,75,45,127,255,24,105,36,246,82,123,55,20,39,245,121,169,47,152,152,247,38,113,246,28,187,237,186,194,91,34,51,215,115,24,132,174,96,211,148,
119,101,56,78,216,115,87,8,134,183,194,97,154,211,210,88,33,108,249,37,54,107,28,99,207,158,3,187,209,214,40,182,136,211,76,228,74,210,82,162,3,228,221,199,216,99,133,161,39,70,82,24,92,226,214,12,23,82,174,117,108,8,67,14,215,225,221,156,215,215,175,121,49,130,76,32,49,194,88,179,121,41,233,93,34,61,182,129,21,217,177,24,152,162,131,73,144,47,216,142,167,54,200,195,123,102,183,196,177,159,232,214,4,136,95,57,198,92,78,128,90,177,21,76,12,139,92,216,101,219,17,165,171,129,109,36,67,181,30,156,69,221,190,142,244,46,186,37,246,128,197,51,24,118,212,120,214,167,176,33,60,154,208,163,228,245,44,204,121,104,126,138,170,181,13,108,184,29,208,104,27,85,61,61,246,64,56,98,139,44,45,64,68,25,84,159,215,33,34,140,151,144,42,170,126,29,163,38,79,120,117,94,91,199,121,43,108,82,70,134,139,157,127,13,30,186,186,176,208,35,54,66,110,93,89,192,14,180,196,126,156,62,244,80,161,25,36,159,31,251,176,191,44,29,0,165,27,199,193,196,5,156,242,15,167,130,98,220,144,24,141,208,165,104,110,62,156,193,
192,179,61,72,216,71,142,187,195,148,200,154,40,199,94,205,120,90,5,126,28,115,49,199,225,77,172,220,189,21,79,205,71,215,49,180,112,99,5,61,178,101,199,199,145,99,56,40,70,19,56,8,134,67,92,122,226,121,32,209,142,138,90,142,177,146,168,47,66,111,173,203,235,216,120,58,130,77,248,209,4,210,124,96,214,234,201,91,144,182,158,196,5,33,207,3,107,152,166,9,232,155,147,152,127,138,110,143,68,169,7,219,145,245,181,1,236,247,9,167,112,157,73,45,182,232,163,26,199,241,196,6,97,144,168,101,158,123,214,108,168,160,243,88,92,137,183,142,241,112,87,36,11,89,95,247,36,219,157,132,101,238,118,109,203,7,65,57,23,231,177,159,206,73,215,227,52,227,12,188,227,196,221,98,201,57,92,214,230,161,166,9,186,13,138,43,199,56,10,40,182,131,202,61,228,184,83,13,68,91,143,231,104,28,22,133,25,153,185,197,166,16,20,184,57,39,78,119,173,119,97,163,115,44,53,63,183,222,131,205,159,216,146,28,195,121,106,106,95,74,20,220,75,212,59,39,247,192,182,130,102,161,234,220,180,207,77,251,220,180,207,163,54,130,201,121,
212,62,143,218,231,9,201,121,66,242,255,57,33,153,196,193,123,156,5,73,225,196,204,0,230,126,229,69,79,213,147,84,141,8,117,231,24,7,48,130,33,28,232,233,149,57,56,146,184,161,201,205,254,73,28,47,196,117,71,226,22,39,228,132,152,172,197,105,29,59,206,208,227,128,77,56,211,133,83,56,242,180,221,240,228,102,207,36,150,46,61,20,14,144,239,58,206,233,225,48,144,226,163,171,124,83,148,111,189,75,76,197,138,25,244,173,240,0,5,29,228,155,193,225,38,252,20,151,4,76,174,93,158,164,97,156,16,19,135,170,210,109,88,11,144,144,35,40,193,241,48,223,2,112,113,232,9,192,239,225,112,37,206,27,249,66,221,192,149,37,151,144,103,53,28,7,182,201,157,186,134,54,76,29,187,197,153,182,193,240,20,233,179,151,228,117,13,3,238,25,242,206,225,2,186,22,55,213,97,159,108,0,107,154,184,156,41,131,75,101,49,239,61,38,46,169,218,32,119,162,155,207,62,225,212,201,101,212,169,39,123,49,233,140,251,6,188,215,201,237,167,128,38,78,221,185,197,145,152,148,216,99,187,221,45,191,142,121,177,157,102,141,220,242,152,
30,240,221,152,97,95,6,46,86,248,65,218,174,227,196,216,102,179,152,7,167,117,176,217,122,28,242,144,56,60,132,109,155,27,24,158,12,131,223,6,164,152,88,217,169,146,35,145,58,72,37,52,76,115,14,242,206,182,200,115,68,224,119,200,177,134,99,37,157,14,170,113,209,48,142,5,138,131,70,219,23,145,134,202,211,72,163,56,0,40,14,45,165,249,88,19,22,196,70,92,200,70,55,59,176,246,235,192,49,194,25,10,225,170,12,173,97,142,144,191,2,101,76,30,24,4,145,78,164,169,178,222,109,199,108,131,131,220,197,35,76,56,231,4,34,128,180,207,205,11,177,133,22,112,125,9,32,9,37,152,51,118,172,227,148,140,130,225,18,238,46,17,71,156,182,48,252,194,81,68,0,44,162,133,93,199,238,85,114,130,163,228,0,218,118,3,186,168,199,173,132,94,106,195,182,165,112,178,7,227,2,28,33,1,187,206,141,94,156,157,66,18,142,185,235,240,66,51,12,37,72,147,184,103,35,184,213,45,97,70,5,76,226,18,148,229,132,42,113,217,225,60,142,239,97,95,236,184,48,38,84,188,77,206,212,69,57,8,170,151,48,93,208,88,80,71,9,108,113,60,56,139,251,
17,219,165,5,59,194,105,113,157,5,142,87,58,183,65,25,95,209,140,42,39,109,9,250,48,104,28,252,220,104,147,28,138,53,8,12,151,192,131,19,183,134,0,43,9,10,98,144,37,249,188,136,182,45,31,159,187,206,255,71,215,209,86,41,146,32,207,182,56,134,233,219,236,129,121,169,24,106,138,49,48,148,138,72,128,193,109,171,128,217,36,28,184,198,108,130,79,28,62,172,150,11,60,152,78,0,196,21,205,69,145,133,86,140,143,35,116,213,151,36,15,148,188,117,9,159,60,226,235,104,4,199,83,87,112,6,11,75,50,227,62,29,87,187,193,52,154,229,201,68,216,236,53,243,132,97,10,39,12,1,143,42,199,53,92,182,189,66,30,31,249,188,20,212,154,228,241,68,80,174,214,196,236,197,67,65,77,220,15,39,2,26,78,56,74,44,177,170,134,56,166,209,251,56,218,233,193,233,196,77,14,158,216,151,49,164,233,20,217,192,149,226,64,127,15,182,102,59,198,1,67,196,22,28,99,12,109,142,161,173,213,199,224,210,75,227,242,68,221,181,80,24,243,17,152,238,232,148,107,56,40,31,22,151,232,109,226,62,161,9,172,114,195,194,113,166,206,145,68,144,233,
114,137,27,172,198,196,113,99,33,187,46,56,54,124,213,67,91,224,76,28,211,19,103,47,197,122,78,136,198,225,17,98,244,187,77,168,190,95,248,174,116,121,184,246,165,16,142,73,174,226,166,209,110,89,57,200,15,187,112,61,86,166,19,119,111,58,168,31,135,130,69,80,74,216,101,220,80,189,212,226,74,147,35,123,209,69,53,14,26,17,199,152,113,95,74,82,92,129,4,79,13,81,23,200,199,207,71,197,231,163,226,243,81,241,249,168,24,129,237,124,84,252,231,51,42,182,228,63,221,80,93,237,177,101,252,240,246,159,254,208,1,61,15,29,191,54,126,104,67,75,218,121,252,144,248,211,28,58,248,193,184,93,203,43,167,70,15,56,56,255,195,24,56,184,208,190,81,49,18,42,142,29,182,126,40,195,6,172,9,9,205,181,190,105,228,240,167,239,52,183,208,130,142,178,211,192,87,224,66,230,200,123,84,14,186,255,68,157,102,16,140,123,181,124,243,113,229,184,161,255,7,57,100,184,139,198,54,31,123,229,173,143,184,71,200,145,126,133,224,128,201,4,140,12,196,85,255,53,231,235,171,231,235,171,63,196,245,213,39,90,190,173,52,150,252,
248,247,217,55,128,169,67,120,144,70,151,17,225,198,206,220,60,16,253,61,247,13,24,168,1,23,128,54,191,190,115,224,173,63,232,166,129,66,3,42,154,192,223,12,59,181,113,224,19,158,206,250,29,246,12,136,254,57,136,131,191,188,109,224,249,63,115,199,192,243,179,118,10,44,34,12,131,106,29,54,50,136,73,102,8,93,61,46,110,23,24,254,67,236,20,192,230,6,170,2,117,108,23,192,174,4,88,137,101,187,64,207,239,177,83,64,68,90,183,150,239,56,181,89,0,187,2,126,235,62,1,236,82,160,225,227,210,102,1,204,207,120,119,196,190,20,121,101,84,159,11,39,150,196,212,77,191,99,131,92,219,152,129,236,193,198,20,135,152,135,29,246,126,74,174,125,114,236,140,3,6,55,85,57,112,235,243,121,64,63,15,232,63,196,128,142,13,51,216,133,195,151,129,226,42,231,96,122,6,206,59,138,189,67,88,137,193,65,10,252,137,35,120,64,151,30,160,160,151,194,97,220,28,137,114,44,29,244,121,23,177,164,208,9,231,112,226,110,158,57,10,207,83,240,58,174,110,196,54,116,76,234,59,196,130,141,32,134,229,32,113,26,3,119,17,224,82,60,231,
70,55,174,99,20,203,11,14,210,93,20,156,105,144,139,69,0,184,38,238,180,19,87,122,99,9,2,51,201,192,18,83,170,152,185,69,117,78,42,116,96,237,76,82,196,134,43,38,23,22,213,175,95,198,66,72,112,81,220,163,167,175,227,18,241,46,249,21,56,35,98,205,66,92,47,9,134,176,132,129,146,36,34,129,122,44,86,79,48,47,187,37,166,119,71,143,145,169,201,241,92,97,100,78,19,247,90,134,18,67,168,78,108,190,199,9,82,76,205,134,48,95,139,221,83,184,85,18,171,51,13,34,72,172,92,150,127,255,8,127,244,148,230,48,77,188,53,45,167,103,177,111,173,96,155,11,146,190,76,161,149,17,20,201,157,248,107,2,2,140,37,180,57,106,196,126,189,16,174,93,195,238,56,36,140,233,73,156,225,65,9,22,122,192,85,131,232,52,166,112,235,35,190,96,119,219,134,216,4,117,237,88,94,8,9,94,58,176,55,205,131,211,16,216,160,5,112,29,23,6,96,165,13,51,214,125,83,152,47,223,108,157,18,123,220,198,53,224,225,190,188,13,220,255,136,197,50,28,94,176,227,238,186,64,150,180,172,152,125,198,237,2,26,221,199,180,246,212,58,110,38,197,93,229,
163,226,82,201,77,210,182,0,95,35,191,38,113,95,182,248,155,84,201,65,73,1,51,252,151,48,91,61,181,54,36,225,123,196,253,146,184,28,61,109,71,213,16,143,70,111,225,174,116,81,146,233,197,38,59,73,33,130,150,180,30,99,19,34,120,193,202,165,39,43,22,6,29,199,114,103,28,166,238,59,196,93,230,184,225,113,1,106,153,247,164,177,99,14,151,78,66,147,93,184,187,213,143,221,130,226,38,65,113,162,3,75,3,126,186,136,128,237,199,213,139,169,103,64,247,108,192,216,176,189,14,144,131,2,82,220,48,24,245,139,195,24,104,231,164,39,115,217,67,195,2,30,115,254,169,251,242,4,8,40,220,195,181,141,146,108,63,166,75,80,232,167,21,240,135,174,15,183,168,99,21,22,151,34,166,105,50,19,6,139,3,162,59,148,107,21,189,98,59,36,214,57,214,113,149,186,58,137,101,47,97,229,232,41,235,113,239,250,100,230,18,214,33,39,177,118,134,165,80,92,47,185,142,139,76,113,92,8,235,163,227,88,213,16,139,104,153,62,44,181,194,250,125,212,55,185,78,238,181,110,220,199,62,73,163,190,32,225,98,77,44,120,21,7,112,141,56,108,51,
185,217,138,85,81,252,185,46,177,160,11,244,52,54,13,50,238,16,214,113,177,176,33,205,216,41,108,24,107,192,27,188,0,44,118,247,225,182,65,240,30,206,92,6,53,89,215,125,236,42,148,181,131,2,150,126,1,115,95,160,128,102,10,53,162,4,107,205,125,178,229,110,185,130,23,72,10,203,31,195,26,33,172,2,253,220,53,220,90,15,129,120,211,240,99,44,164,66,149,133,110,55,150,87,249,222,85,233,188,240,8,185,200,90,232,17,94,134,59,226,241,199,133,210,216,161,8,35,7,13,200,106,83,172,220,110,218,229,234,107,151,27,151,92,38,71,96,131,110,92,246,34,224,61,178,188,14,50,12,164,96,62,40,239,194,10,160,158,233,7,58,86,122,193,155,255,24,130,199,194,16,90,6,51,136,164,133,86,226,24,240,162,49,176,252,15,113,191,39,76,55,24,195,238,78,156,79,197,38,75,136,24,10,27,199,218,184,7,24,66,237,20,217,238,142,136,114,88,38,214,164,96,68,239,137,235,61,177,91,116,187,19,171,64,32,5,31,129,80,0,236,193,109,243,88,206,74,119,131,8,242,33,200,81,162,220,199,118,69,172,89,122,54,1,15,226,32,50,6,48,109,99,0,231,
146,112,129,4,174,19,197,118,80,79,2,82,70,45,88,203,25,134,220,61,88,209,207,72,150,19,168,29,75,76,108,70,248,235,105,114,199,103,205,49,47,237,232,169,17,52,200,131,37,103,220,88,143,64,116,9,43,209,8,46,161,229,155,144,172,44,156,193,117,151,88,181,14,37,113,208,71,220,41,136,92,12,75,56,34,80,164,214,228,79,156,217,28,68,114,34,22,146,17,97,32,189,205,126,185,250,43,168,121,179,136,129,195,161,97,44,75,93,65,12,68,32,195,66,106,40,9,96,113,120,83,130,225,239,35,211,220,130,64,148,68,80,8,39,198,215,1,47,110,8,196,242,19,66,107,10,68,16,142,80,14,154,98,217,92,59,239,19,206,251,132,243,62,225,188,79,56,239,19,206,251,132,82,159,112,62,4,62,31,2,255,64,135,192,231,166,125,110,218,63,80,211,22,127,195,3,127,155,13,127,188,44,71,110,28,224,219,121,241,254,47,147,68,91,132,131,128,226,95,131,246,242,18,230,66,196,8,20,67,31,252,241,46,108,206,196,216,161,244,7,95,232,43,113,178,48,142,83,133,177,167,15,247,135,86,31,103,247,30,226,175,102,55,76,188,245,100,63,251,120,231,131,
71,87,213,255,88,62,103,184,70,201,40,109,245,80,67,35,200,255,235,218,127,119,243,201,167,55,233,167,245,214,255,126,86,241,171,242,219,193,255,60,235,99,153,153,170,86,48,211,120,251,217,254,195,226,223,159,249,155,138,186,243,180,149,167,134,52,234,254,95,201,127,27,204,98,252,95,21,220,17,79,253,33,134,156,184,63,190,31,127,40,54,27,251,176,31,23,47,196,30,136,167,254,64,124,144,207,131,108,224,163,126,140,118,249,169,101,251,49,56,196,205,242,81,96,104,79,196,15,109,79,60,227,59,32,82,181,178,135,171,191,14,178,190,79,251,49,240,244,61,17,207,112,174,31,3,227,200,30,86,60,15,178,252,35,188,39,138,36,145,170,229,189,254,229,50,169,29,65,74,223,177,112,229,125,208,143,97,184,247,137,120,134,118,250,49,211,162,103,241,249,179,191,129,170,160,176,6,237,171,191,95,171,84,92,89,46,157,107,144,139,162,127,176,183,167,254,117,89,32,31,9,60,96,227,54,13,113,232,243,47,70,211,175,30,141,210,221,129,245,87,235,3,180,51,156,248,201,133,97,114,79,36,95,61,159,160,197,193,237,87,207,6,
233,150,125,227,213,93,59,61,154,216,250,73,235,4,205,12,108,188,154,28,160,66,231,239,140,232,76,93,114,210,168,51,233,116,82,179,99,99,198,65,77,206,204,56,102,244,90,70,179,83,163,212,226,216,24,113,80,175,51,53,229,164,150,209,196,149,81,234,116,108,23,236,14,42,232,142,212,128,131,6,28,41,236,90,175,114,197,166,93,56,8,154,153,194,177,211,218,233,224,220,52,85,187,98,78,23,254,112,241,230,60,182,105,139,221,145,216,249,152,46,60,4,162,109,56,221,55,76,67,195,25,255,48,110,165,219,180,79,80,215,84,246,26,254,224,192,194,112,214,55,76,234,84,198,61,69,13,195,153,161,97,234,155,72,21,234,39,168,176,61,145,189,60,65,195,19,89,239,4,102,39,19,147,78,28,81,204,141,98,28,127,219,153,118,224,15,16,122,182,197,95,30,114,38,192,119,247,68,174,240,14,80,90,39,211,131,147,212,63,153,14,78,194,101,98,215,49,119,226,203,94,193,223,94,95,114,39,166,220,212,226,75,78,249,168,197,157,196,153,203,222,201,76,225,249,36,121,38,19,254,73,82,236,233,231,83,155,170,29,76,209,176,59,225,192,206,
247,216,212,230,240,20,254,8,194,250,53,55,181,78,37,193,106,171,125,173,208,101,167,1,123,122,206,78,213,238,13,65,208,158,152,176,211,197,137,148,100,116,61,48,65,54,123,98,198,142,131,148,217,9,176,211,52,145,115,78,80,243,104,210,61,74,13,19,201,153,9,106,234,75,95,233,163,78,180,48,131,239,213,142,181,33,7,245,57,54,230,167,231,177,194,49,59,77,117,174,237,73,23,21,162,142,228,180,131,46,76,111,79,77,67,25,155,19,14,186,56,158,158,30,167,229,129,116,161,101,128,62,56,87,223,159,181,250,38,179,133,79,38,233,198,100,106,106,18,38,180,238,178,83,227,96,162,16,24,36,223,96,102,124,144,222,30,76,225,221,54,153,240,77,146,58,152,17,239,246,244,123,118,42,172,218,211,243,195,155,138,157,252,246,205,170,97,42,248,196,91,118,212,78,27,246,237,249,225,116,181,157,188,194,187,210,87,38,224,176,169,194,83,7,206,79,36,230,199,215,177,255,97,124,156,90,6,54,11,145,1,154,26,200,141,12,208,189,129,157,192,0,206,69,108,206,143,111,97,29,109,116,156,46,142,102,10,249,81,154,26,221,29,26,165,
119,70,211,61,163,52,54,186,91,232,29,165,222,241,92,161,115,156,6,237,217,235,118,138,252,49,152,159,216,241,79,144,50,154,116,141,82,227,196,134,112,171,190,172,167,143,10,243,125,185,241,62,122,123,98,119,124,2,207,157,143,39,232,194,104,210,51,74,117,19,201,200,4,93,119,36,11,141,136,53,195,142,140,199,65,117,227,219,129,113,178,13,100,181,1,242,243,115,60,59,239,72,85,143,147,31,171,137,227,105,207,56,213,13,228,222,29,160,129,115,119,250,179,118,167,115,245,253,89,171,239,143,17,80,254,37,70,195,129,157,87,187,3,244,214,121,142,248,131,206,17,29,217,0,118,203,140,103,174,140,163,207,207,77,97,75,76,240,60,30,254,89,199,195,115,245,157,171,239,124,104,125,62,180,62,159,25,57,159,25,249,23,54,177,53,238,204,250,157,24,248,103,95,188,255,215,149,83,170,47,199,254,98,212,50,249,221,146,16,243,170,183,178,15,114,234,175,202,243,170,121,74,62,40,205,171,254,99,238,155,177,188,50,70,251,150,231,139,161,177,188,58,70,62,249,220,147,207,130,211,242,3,31,128,33,160,240,159,223,242,
161,12,85,250,240,98,80,126,255,30,180,190,95,141,86,40,84,82,152,41,242,93,250,112,186,70,19,10,223,185,41,167,185,199,119,110,252,239,70,11,116,79,215,136,162,178,36,152,47,84,82,150,106,69,141,111,228,171,244,225,13,180,64,5,178,175,160,197,63,184,70,60,79,243,133,207,162,141,37,194,101,73,148,80,202,218,46,17,102,5,11,90,40,42,213,8,140,50,95,165,15,167,219,104,66,189,145,86,137,21,65,139,161,152,21,188,151,105,49,20,87,82,194,40,41,19,37,111,104,232,25,213,150,168,67,229,120,63,93,109,5,173,18,63,111,128,58,197,144,213,196,193,28,127,197,243,13,126,194,212,75,52,222,208,4,48,116,186,161,53,99,228,45,10,11,232,167,53,106,54,129,9,151,42,41,67,85,212,104,133,50,197,113,70,141,37,20,110,214,119,210,42,161,127,63,161,9,40,70,41,85,242,6,75,195,119,118,211,211,246,88,81,227,247,163,245,70,168,210,135,114,27,81,84,246,147,18,147,172,148,50,247,12,133,103,89,143,208,211,83,169,39,65,203,202,61,222,203,182,93,250,240,253,107,44,161,156,150,4,127,0,19,101,217,151,140,165,92,35,190,
151,185,47,161,176,245,150,101,127,6,20,96,203,53,226,59,139,165,164,148,18,169,146,193,162,68,84,203,60,156,65,176,68,163,236,34,76,4,207,178,56,240,227,116,181,111,164,133,15,103,52,161,196,104,9,175,172,81,230,161,244,161,44,57,254,128,202,191,253,209,169,80,193,60,150,190,23,30,89,212,203,210,56,45,236,51,218,131,162,51,160,208,208,18,245,211,98,124,35,167,192,56,45,32,38,130,103,89,140,37,116,33,32,171,74,42,160,42,104,149,126,128,149,10,168,82,219,207,104,194,25,214,126,48,97,105,214,105,67,3,225,211,234,7,249,178,30,74,76,148,21,139,34,14,223,76,139,185,179,218,225,119,18,172,96,158,169,51,65,60,203,204,191,17,234,12,230,128,120,186,70,43,93,96,156,214,165,85,254,111,38,88,226,129,219,86,102,142,169,227,115,89,38,92,201,25,77,48,161,152,86,5,84,233,71,217,122,172,108,155,180,126,11,20,62,151,163,96,9,253,12,113,148,185,7,202,217,254,119,6,247,40,18,180,24,165,196,138,160,197,63,126,27,173,18,10,123,86,153,175,210,135,50,173,10,238,153,112,5,20,148,134,128,206,31,76,190,
24,133,161,240,44,75,130,161,240,20,26,226,31,128,61,173,199,55,66,225,67,153,86,5,95,165,31,236,1,167,161,206,168,177,130,86,69,141,86,90,120,63,45,9,147,22,67,225,7,27,49,123,27,155,12,251,95,233,9,200,178,128,241,131,89,60,133,192,228,74,207,50,194,235,53,148,128,74,181,161,228,180,57,48,26,131,226,189,196,12,191,155,8,165,207,204,12,235,129,77,162,68,187,2,161,244,131,65,185,37,108,181,37,52,38,106,214,96,69,192,123,169,209,165,154,173,140,157,54,10,43,2,19,178,62,43,106,96,208,210,211,74,181,244,110,34,148,170,6,51,111,66,96,152,51,106,64,81,169,209,204,76,137,28,139,225,180,30,24,193,10,196,104,165,231,233,88,101,101,233,117,52,148,156,109,26,37,122,165,230,150,74,202,98,101,218,160,241,61,162,206,155,248,96,158,4,31,247,127,85,57,202,46,111,92,170,237,198,0,91,125,123,231,131,167,15,255,207,218,55,246,60,54,29,188,184,95,250,15,59,101,94,36,237,249,239,241,223,119,225,157,249,237,204,194,239,81,81,37,136,73,197,44,60,147,38,10,15,210,178,13,123,246,107,0,244,113,235,134,
78,55,171,18,185,242,23,208,14,162,246,33,252,119,73,162,249,236,55,75,148,252,246,188,205,78,207,100,249,193,149,18,85,147,0,192,132,4,223,244,11,84,241,7,102,169,87,66,248,237,211,120,7,189,210,115,191,68,213,36,96,254,103,82,173,36,254,93,223,206,68,168,44,44,255,218,51,219,40,248,56,152,40,181,168,12,96,177,137,202,74,43,127,85,34,152,223,206,4,65,161,208,17,254,219,47,234,72,32,15,190,161,238,55,145,130,52,39,240,13,210,132,70,2,246,32,104,64,219,165,39,218,37,42,122,83,139,94,163,250,223,242,118,252,249,92,144,115,130,4,20,143,119,86,206,139,178,241,84,34,153,191,4,239,101,183,169,4,49,191,85,22,158,249,11,144,133,156,133,125,110,202,203,183,79,11,165,18,185,178,110,252,130,80,174,1,164,104,98,226,189,100,98,248,204,202,22,134,123,38,29,179,208,164,106,249,5,221,72,74,189,248,228,179,219,229,123,89,66,111,20,178,73,232,77,255,177,138,192,31,0,94,119,38,179,122,11,23,175,185,22,240,190,155,198,155,106,182,40,236,12,26,103,86,249,38,118,10,143,236,110,124,243,219,103,64,201,
103,31,144,79,183,124,134,228,179,44,39,214,132,144,86,153,24,156,30,230,123,240,208,170,103,83,75,15,74,112,160,195,237,52,99,155,201,126,25,14,0,175,149,157,85,71,69,25,126,152,126,88,152,49,3,211,12,202,96,59,32,87,112,218,111,200,31,115,248,81,116,7,51,162,162,4,230,41,216,190,90,98,17,176,111,104,138,89,77,5,139,103,149,1,224,0,77,174,128,171,44,227,58,76,92,252,87,217,119,129,99,118,221,97,124,42,53,66,232,166,215,174,129,16,26,33,3,133,104,99,201,39,240,94,238,30,135,142,209,61,214,47,46,14,69,30,61,222,123,152,166,111,28,121,220,49,252,204,145,199,94,186,61,203,243,224,129,35,143,43,130,95,220,47,253,7,128,23,73,9,241,198,255,42,17,190,235,151,73,204,4,169,36,125,102,225,153,8,149,144,149,245,157,73,19,32,126,135,87,62,69,131,205,70,22,30,201,70,238,59,124,248,178,47,155,232,115,132,241,221,103,190,207,50,134,252,234,41,193,236,57,174,91,222,157,252,142,167,223,177,96,193,213,100,137,144,229,190,227,70,9,102,223,17,1,12,4,46,75,204,119,137,53,205,184,18,75,192,251,77,
165,184,44,184,215,44,184,206,210,187,223,225,103,92,249,20,109,1,174,196,210,74,48,251,142,89,203,251,60,191,75,120,65,179,216,94,243,93,226,6,74,48,123,21,60,79,114,185,172,197,148,168,124,15,201,39,155,211,180,164,192,60,4,75,240,251,142,80,137,166,79,190,23,235,21,114,192,187,196,186,102,193,245,150,224,247,28,126,46,151,144,190,18,188,223,225,230,119,9,25,182,224,206,88,222,173,245,10,58,44,31,191,67,232,174,40,43,221,2,111,149,149,75,82,22,237,242,57,110,150,234,242,57,102,248,93,98,77,90,112,173,50,191,97,193,181,202,217,90,239,156,5,215,180,67,89,34,236,129,29,179,84,151,172,209,228,65,194,8,91,45,58,175,73,71,150,8,251,129,61,227,233,119,8,57,176,45,249,28,166,141,73,24,83,38,18,210,172,75,190,155,250,149,117,153,178,149,20,34,76,71,194,152,50,145,239,86,59,177,218,164,208,69,81,206,243,165,247,125,199,77,137,197,186,54,237,68,242,99,190,35,40,5,28,166,205,72,30,24,210,172,69,226,150,53,229,119,8,105,251,164,109,248,29,65,174,69,150,204,201,167,208,163,207,225,146,52,
89,26,12,47,248,172,212,102,64,226,242,87,193,73,145,243,41,249,206,62,101,182,66,226,234,242,41,100,232,115,184,45,245,50,174,176,7,191,131,113,217,114,68,196,240,203,184,81,169,17,230,83,180,200,239,16,214,194,94,224,119,176,244,132,159,250,138,81,69,194,112,116,98,95,171,168,87,66,122,228,83,120,77,209,179,216,234,216,86,77,120,73,135,189,96,65,190,115,237,204,167,136,114,197,56,86,182,52,191,131,97,88,194,66,131,69,139,226,26,133,237,85,202,159,37,204,244,205,40,42,185,18,122,132,196,228,147,181,99,181,82,142,99,44,43,46,103,30,24,82,88,102,81,62,44,1,246,35,174,157,249,231,200,16,150,26,191,206,122,151,88,215,229,147,245,91,238,7,96,27,146,115,150,140,181,94,214,53,235,157,219,200,244,89,35,236,71,220,70,209,141,6,28,220,70,214,166,136,96,69,251,97,158,249,89,142,204,126,135,240,32,244,53,18,210,236,53,228,59,243,207,150,195,186,96,57,48,159,108,87,229,30,106,79,70,161,98,148,40,247,56,126,135,41,43,212,178,231,176,70,39,193,97,49,98,152,222,42,57,97,206,173,54,32,234,221,
151,61,11,224,229,187,53,26,151,123,177,82,4,150,252,151,121,216,119,88,35,210,20,215,43,233,136,72,82,236,109,203,209,219,87,193,179,217,11,72,172,114,36,220,115,8,93,48,63,136,222,146,115,230,185,28,229,246,100,121,177,141,66,182,165,119,75,189,102,15,34,41,148,123,109,43,125,68,170,82,93,251,69,57,203,54,154,246,38,223,203,61,224,190,244,119,110,215,94,69,143,47,108,143,121,240,89,114,16,95,49,94,73,174,204,222,77,190,91,123,46,107,175,103,70,96,201,51,91,130,104,123,137,103,249,126,131,235,146,116,76,153,75,120,83,62,146,103,211,127,37,140,41,79,137,101,141,204,34,190,21,229,108,245,151,178,143,236,59,172,49,89,216,127,169,237,140,203,62,40,107,52,125,185,244,190,47,229,192,61,212,190,67,68,137,34,174,240,68,46,63,21,39,25,87,82,46,203,100,207,33,244,88,212,175,136,78,69,92,43,207,102,60,151,144,194,175,139,245,154,178,146,229,101,91,245,57,216,199,217,174,172,25,145,153,1,162,93,207,100,230,80,228,217,196,149,28,138,8,86,148,27,107,71,196,94,46,217,183,88,166,207,193,148,
57,34,89,35,48,71,60,238,89,38,57,130,73,202,236,209,28,49,172,145,129,35,42,199,28,209,111,22,35,36,107,153,109,213,26,177,185,231,18,182,225,115,112,84,228,150,50,46,219,24,211,228,114,150,36,71,72,107,15,203,184,220,215,112,116,98,45,51,46,199,19,83,146,146,127,214,2,199,82,107,94,193,125,4,199,243,114,100,43,122,7,251,41,75,137,249,225,119,150,146,25,181,88,242,242,233,177,90,157,108,35,67,114,171,205,118,177,60,229,147,219,197,210,102,254,185,15,226,120,206,81,250,117,57,48,22,151,179,108,89,47,92,11,211,97,89,113,123,173,158,203,17,146,165,109,149,39,219,0,75,210,244,50,214,145,228,147,229,108,218,137,44,97,143,230,158,209,26,205,216,18,152,19,31,254,140,131,215,204,3,25,151,33,43,122,28,73,141,107,20,88,7,87,36,130,24,0,226,215,235,67,62,128,191,62,56,52,11,77,132,74,144,239,241,13,32,126,71,185,219,60,72,203,186,11,57,147,117,54,11,238,146,173,105,180,153,70,72,108,51,29,151,34,99,83,99,227,51,59,36,89,110,42,67,190,91,147,51,118,45,118,42,179,147,150,48,55,228,147,141,
128,19,38,83,181,82,172,108,184,12,195,166,192,106,102,211,41,119,42,62,51,17,100,87,100,30,24,222,41,233,176,232,173,46,196,37,108,100,214,161,29,151,48,253,178,180,138,201,4,243,99,186,138,148,9,243,195,53,154,38,34,203,217,220,89,158,28,8,152,31,134,97,250,214,16,195,46,196,37,86,185,49,29,230,182,28,40,145,16,200,90,152,19,51,17,145,37,92,35,83,99,110,185,94,110,35,107,144,19,113,150,51,183,145,13,253,245,68,129,67,134,53,228,49,77,214,187,149,206,13,89,59,83,179,154,254,13,169,95,182,22,43,60,211,225,167,53,4,48,29,166,96,237,80,153,127,254,106,13,49,44,49,150,128,208,47,119,24,230,228,67,49,131,230,177,47,55,190,34,115,151,76,115,57,71,23,22,150,25,119,229,87,51,94,90,154,199,20,22,184,223,144,205,99,179,99,245,88,141,128,33,185,217,175,103,166,172,66,167,165,255,97,177,50,39,76,147,249,97,35,99,53,152,244,101,189,172,30,83,148,178,132,149,202,102,193,226,179,198,75,22,28,155,35,99,49,60,199,72,86,191,169,12,217,94,230,135,71,0,204,173,201,143,172,203,228,74,66,50,29,230,
141,41,152,70,35,33,57,64,240,215,32,199,75,89,110,186,141,164,80,158,159,40,58,27,215,110,117,78,174,145,91,199,109,103,126,152,50,75,219,116,54,73,147,251,46,214,11,83,51,219,43,107,103,248,160,69,143,236,150,44,37,171,241,113,189,229,248,93,28,249,177,229,176,132,173,118,194,253,0,75,204,26,76,89,50,92,47,215,197,252,48,207,172,133,242,252,129,79,102,127,197,17,140,201,191,228,156,223,111,200,247,105,139,253,4,228,59,135,0,205,210,46,110,11,59,21,215,206,114,227,236,222,28,129,89,244,200,60,176,51,155,114,150,95,25,158,157,217,156,95,145,60,112,184,225,214,49,87,220,46,182,97,150,167,105,87,204,179,164,230,150,28,90,243,38,166,195,220,178,204,153,14,227,114,171,185,118,46,231,224,200,22,98,245,95,206,167,184,59,49,131,184,172,151,225,89,14,214,32,206,242,103,57,152,89,191,228,144,219,114,67,190,71,44,242,228,112,195,88,214,81,157,181,165,102,112,151,245,114,6,193,53,90,219,197,20,216,114,172,65,211,106,39,86,121,178,252,77,253,74,202,44,7,182,28,230,223,218,25,251,165,175,
177,196,204,56,32,177,216,38,217,74,173,126,193,60,48,164,41,55,217,118,182,7,134,180,210,97,201,51,125,107,158,200,29,24,91,32,183,145,237,141,97,94,31,121,179,141,177,246,77,126,36,159,44,79,150,143,213,78,216,119,248,105,237,252,184,69,44,13,51,158,72,58,28,217,184,118,43,29,142,129,166,183,178,126,101,123,185,237,92,187,25,111,101,57,247,11,28,217,204,78,90,150,51,5,166,108,182,87,150,179,30,57,110,88,253,197,228,68,214,104,237,236,153,50,243,111,198,31,201,63,107,150,181,99,218,185,164,207,118,197,124,90,227,9,219,57,151,88,227,170,41,25,137,203,48,108,63,166,101,202,186,172,113,149,99,5,71,105,51,190,73,24,214,59,91,154,213,143,216,54,248,171,85,143,220,94,174,209,180,31,201,3,247,140,214,222,153,237,196,218,95,188,222,15,178,84,173,118,197,114,96,57,155,240,146,62,71,0,246,32,171,94,24,134,163,55,123,55,215,203,254,101,106,65,182,148,203,89,179,252,213,26,103,88,71,86,111,98,120,150,60,183,212,76,122,36,53,246,35,214,163,53,206,51,15,236,71,172,77,214,139,85,110,214,184,
196,61,11,107,202,234,191,220,70,198,50,227,128,148,3,235,145,41,176,151,49,159,28,139,88,95,214,248,195,18,96,239,176,218,27,219,15,91,130,105,159,210,134,67,50,206,112,137,201,191,108,239,13,249,100,185,113,45,92,47,243,204,95,185,46,46,103,125,177,196,88,155,44,7,134,100,41,241,59,195,115,139,216,43,185,213,12,207,28,114,100,48,147,90,41,7,246,101,246,56,171,60,217,191,152,130,53,62,48,111,172,71,147,79,73,135,75,24,222,90,206,253,14,151,91,7,27,108,111,44,97,171,95,176,239,84,204,176,74,250,204,33,219,39,243,198,237,226,119,150,12,127,229,114,230,129,57,55,249,145,146,103,121,178,53,154,253,166,44,103,123,224,126,196,202,63,247,89,108,21,214,56,192,150,192,88,214,188,209,148,131,228,153,235,226,153,90,142,24,44,7,107,254,195,156,191,110,183,12,201,229,102,28,147,124,178,142,152,79,171,220,172,20,172,124,178,173,178,148,76,61,178,190,228,147,181,111,245,47,166,201,218,49,229,35,33,217,206,25,222,140,111,146,31,174,203,148,191,132,100,249,223,148,246,207,30,103,202,71,194,179,
124,216,242,173,250,98,155,228,26,189,156,15,75,106,44,127,166,99,230,219,178,156,125,150,229,111,237,143,184,132,159,175,219,45,75,222,170,95,107,15,107,198,7,233,191,108,153,28,159,173,253,38,123,22,71,21,51,94,73,126,24,134,219,101,246,35,86,125,201,119,171,61,176,47,112,47,105,245,95,150,15,247,182,166,126,37,125,150,21,75,155,177,216,223,77,62,37,140,213,206,153,79,211,186,100,237,12,207,52,217,42,204,121,62,249,149,237,141,249,103,30,24,158,117,205,90,96,171,227,114,110,11,199,49,211,158,37,15,204,33,107,196,218,63,50,46,123,129,53,14,240,59,183,215,42,79,238,191,184,165,172,77,182,43,46,97,127,52,203,37,255,76,159,165,97,230,21,146,31,230,141,233,139,242,242,214,4,90,197,214,132,90,108,77,120,235,201,195,157,127,88,248,102,58,175,78,147,79,62,255,193,38,255,43,252,242,11,249,255,175,185,148,159,223,114,217,158,252,114,240,31,30,76,231,149,105,11,213,170,172,216,15,24,121,250,193,222,71,133,191,127,255,27,87,94,113,209,207,126,228,202,171,46,250,219,47,228,175,111,241,203,
44,196,127,127,203,223,190,229,111,2,178,140,240,51,20,2,239,245,255,0,242,213,138,132,220,151,16,123,242,189,92,132,239,248,112,6,148,13,136,183,139,40,32,125,26,145,139,240,252,234,86,145,60,211,50,139,74,223,255,213,236,153,244,43,170,172,224,130,49,185,200,228,162,68,185,204,69,137,62,138,204,42,75,84,184,169,63,101,65,89,212,248,239,133,192,23,135,238,62,254,228,229,55,61,191,106,200,211,55,51,249,170,95,53,104,202,55,51,152,71,60,85,240,173,237,84,65,225,175,247,204,18,101,134,252,51,121,126,22,241,255,211,230,105,240,156,165,192,134,26,254,115,211,169,130,194,163,83,5,101,86,171,126,46,88,189,45,88,253,199,39,191,106,32,250,102,202,228,116,138,126,13,54,74,5,182,111,166,232,167,138,165,64,17,5,95,252,179,10,4,141,95,239,159,70,65,243,43,107,249,145,165,224,181,90,4,141,255,254,206,41,136,23,131,167,10,42,24,19,40,127,185,88,134,184,41,136,126,237,44,23,104,178,113,191,181,218,194,79,252,167,112,126,117,241,84,65,97,198,44,192,223,132,184,199,146,20,180,239,89,192,68,229,
191,234,176,20,8,128,51,240,4,220,134,5,76,252,46,235,141,254,78,232,109,69,232,237,159,62,146,218,189,42,245,102,251,230,42,253,26,108,194,228,184,64,65,193,79,111,88,10,4,196,79,209,214,74,8,40,178,84,240,26,4,19,189,154,87,5,169,171,121,69,16,224,95,95,200,255,254,71,135,252,239,224,129,181,240,47,27,229,175,175,115,103,32,20,94,49,162,79,126,251,86,147,144,223,114,89,185,141,234,91,104,163,178,158,77,63,124,241,119,67,223,204,230,149,89,42,124,59,63,155,87,103,105,79,254,218,47,190,91,75,0,133,242,55,61,25,210,10,255,221,37,214,175,252,110,155,165,103,103,209,183,210,180,214,254,122,249,235,52,173,48,175,127,253,221,168,89,105,50,5,46,177,242,111,125,183,194,188,142,251,221,60,88,113,223,4,105,165,249,125,234,101,120,235,211,90,139,149,154,21,230,245,114,43,63,214,119,43,150,149,178,245,221,10,243,187,189,191,94,163,149,190,245,253,76,206,95,220,255,30,38,126,144,62,11,232,20,189,131,7,69,163,253,142,134,252,51,129,172,236,91,27,138,247,50,79,167,62,88,125,86,84,103,229,230,
76,122,130,146,149,6,35,192,130,94,110,84,126,120,29,8,160,167,171,96,108,107,69,21,64,175,211,40,129,158,45,155,210,103,68,164,51,40,89,171,43,209,46,203,230,245,207,92,98,82,58,69,156,171,56,21,250,74,84,75,65,207,74,20,239,47,223,150,98,18,97,245,255,10,0,0,0,255,255,3,0,237,109,173,127);



programfile__ILLTAKEUHOMEAGAINKATHLEEN_MID
:array[0..1974] of byte=(
120,1,236,89,77,108,84,85,20,190,208,129,146,6,203,191,137,202,162,18,194,79,154,98,105,90,145,50,144,153,150,150,82,91,203,148,154,128,98,180,241,53,64,168,160,141,96,48,77,152,55,12,73,131,73,67,135,106,76,140,75,55,110,44,208,224,202,196,31,22,44,140,113,167,137,11,87,234,94,221,215,239,187,247,189,111,222,116,218,201,12,78,77,213,46,38,247,204,189,231,156,251,157,159,123,207,157,57,253,67,231,60,99,204,90,179,202,172,93,149,238,31,26,187,96,204,170,86,51,119,42,22,91,253,218,58,51,119,173,198,152,36,134,53,198,188,83,111,204,92,170,102,253,171,237,217,31,3,194,143,113,226,230,199,254,58,142,159,183,185,241,151,122,59,62,182,245,89,55,30,253,194,141,87,102,220,248,233,14,55,254,188,195,202,215,111,123,96,191,215,191,176,221,141,19,113,55,62,56,108,199,13,171,157,158,13,29,9,247,61,123,217,141,15,127,183,227,198,13,63,88,61,27,79,31,117,223,63,121,197,141,127,30,179,227,166,238,70,55,126,228,244,108,250,227,3,251,125,243,64,218,141,159,237,181,242,91,54,127,111,191,111,121,
247,158,27,127,123,202,142,91,79,189,232,198,239,102,237,184,173,119,218,141,223,190,108,199,199,135,174,152,185,103,140,243,93,109,187,153,171,217,124,124,247,232,104,195,208,240,133,145,134,211,151,46,55,244,92,122,99,196,204,192,203,95,238,49,51,181,215,204,76,93,194,204,157,94,61,103,222,55,183,226,94,102,60,29,247,98,183,186,188,108,60,221,101,9,223,17,221,30,136,110,204,116,146,232,4,209,235,101,182,167,123,65,28,243,206,164,143,97,236,241,110,62,151,238,241,214,65,58,16,146,26,9,117,112,169,35,170,166,139,106,184,85,39,212,80,111,210,187,217,156,78,122,27,129,6,188,85,68,211,73,163,184,67,15,21,247,128,232,37,225,76,0,65,27,138,208,200,168,136,16,212,80,72,51,242,141,12,239,166,81,244,86,145,111,36,212,71,52,125,81,16,90,146,190,78,170,33,226,110,248,134,234,186,232,226,174,5,93,44,91,4,66,132,208,44,174,70,190,81,164,36,29,153,9,34,149,55,106,98,220,250,177,135,121,67,135,42,224,146,142,216,2,23,47,109,222,0,77,18,32,132,166,135,46,118,176,176,183,203,177,0,68,146,145,
39,243,17,186,248,8,136,36,92,204,137,94,15,106,24,222,62,178,204,11,208,162,250,34,246,6,145,79,64,95,194,234,69,200,146,8,89,181,211,89,190,86,128,86,14,87,120,176,87,14,87,254,140,86,233,82,94,166,135,43,128,85,181,195,58,201,59,36,95,65,215,236,70,5,173,79,158,29,62,127,177,225,249,225,183,207,141,142,140,92,52,119,80,61,191,106,54,119,80,61,239,212,109,11,171,231,20,171,167,143,122,53,197,147,233,227,186,1,225,59,130,183,160,143,11,124,138,103,213,199,45,56,197,234,233,227,154,153,66,160,124,84,158,41,22,26,31,213,51,47,36,53,18,226,1,247,81,61,243,106,88,175,236,86,168,158,86,47,171,167,143,234,9,52,224,173,34,26,86,8,187,3,203,20,128,210,4,16,206,4,16,180,161,8,141,140,138,8,65,13,133,52,35,223,68,188,5,163,232,173,34,223,72,136,7,220,199,229,156,7,161,37,233,99,245,180,136,81,246,172,58,86,79,56,107,33,23,203,22,129,16,193,234,105,197,23,87,35,223,40,82,146,142,204,4,145,202,27,53,49,110,253,200,122,101,9,5,92,210,17,91,224,226,165,205,27,160,65,253,67,92,2,52,172,158,
1,44,236,205,116,150,45,172,158,150,153,213,211,71,245,156,66,245,180,19,172,158,54,188,60,144,243,3,180,168,190,136,189,129,175,81,61,125,84,79,232,125,207,193,26,74,221,24,247,135,48,51,152,2,190,65,16,3,36,6,64,164,82,224,73,129,24,34,65,158,200,76,57,82,1,207,73,110,113,210,234,145,20,8,238,53,72,205,36,164,121,128,51,220,189,143,82,204,196,20,241,16,134,128,245,147,167,63,202,163,165,8,51,196,169,71,75,253,212,83,32,53,200,45,184,251,163,57,33,69,113,2,235,39,65,205,82,120,130,51,39,48,35,30,45,105,166,36,207,36,53,231,175,203,77,191,226,186,92,127,114,228,173,203,35,23,95,31,241,26,58,174,154,187,184,44,191,126,194,220,173,125,211,220,173,59,239,46,75,147,139,123,38,215,236,249,137,92,27,242,36,211,230,197,114,7,245,13,107,153,102,124,14,226,195,149,246,144,183,149,188,173,152,225,221,150,193,221,150,179,51,88,183,252,92,129,204,60,189,226,197,6,113,171,211,233,174,154,94,107,1,177,82,47,241,98,4,102,216,86,136,183,61,196,75,62,218,88,41,94,212,165,146,182,97,61,240,91,
101,24,150,3,222,18,113,91,150,254,85,254,42,198,7,152,94,7,194,24,135,57,204,24,55,34,110,135,152,15,45,100,105,193,140,120,237,12,214,51,135,240,225,10,99,129,140,141,228,142,120,237,78,209,220,41,198,128,172,139,103,148,103,81,12,75,197,91,34,110,69,231,173,146,252,173,228,204,87,194,75,188,251,11,252,123,152,62,59,12,215,11,239,126,196,226,32,38,90,193,155,32,111,176,18,203,137,55,136,186,201,36,192,27,158,227,166,130,24,31,161,94,148,198,80,218,100,154,2,189,45,208,139,10,154,200,205,103,137,185,25,172,103,120,150,41,12,25,102,75,36,31,132,193,162,162,206,3,129,94,96,1,63,120,197,162,220,177,51,196,74,126,26,11,25,228,37,120,149,147,200,208,56,210,80,201,105,50,204,75,38,116,9,94,43,205,253,201,203,252,45,206,51,97,176,62,139,230,100,113,174,23,230,111,52,215,75,228,217,178,188,31,104,91,185,53,160,18,222,18,126,80,254,210,111,204,223,74,206,155,226,86,73,61,22,175,18,217,206,132,245,56,172,221,251,152,103,37,120,247,1,47,121,113,7,230,146,47,45,200,27,36,167,59,23,76,210,
71,194,171,187,90,111,2,59,19,226,13,207,113,225,187,68,188,127,203,191,37,226,102,61,131,245,149,247,3,46,160,208,15,149,230,239,191,205,191,202,95,229,228,226,247,228,202,251,161,242,251,172,146,55,65,37,188,204,179,149,247,67,201,55,65,144,200,101,189,31,138,120,43,57,23,172,155,133,111,229,149,247,67,228,247,177,126,7,240,61,0,191,234,157,186,20,245,77,113,83,157,71,185,12,170,62,247,118,111,146,121,191,231,197,251,255,124,63,216,247,78,224,165,200,143,129,130,183,78,27,124,247,207,190,119,130,103,78,240,39,75,24,55,254,217,210,133,255,246,50,93,232,22,135,237,229,154,159,248,111,79,199,240,216,216,85,244,151,175,142,94,26,51,247,240,111,207,55,79,155,123,181,32,195,191,198,63,52,183,247,122,55,198,175,239,245,98,183,27,241,239,226,245,70,16,59,73,236,4,161,37,17,205,100,110,198,146,8,45,21,19,229,40,108,164,66,110,42,66,154,119,114,137,48,180,164,153,38,46,53,97,73,68,57,60,187,40,181,11,82,130,186,135,51,123,48,35,66,122,68,8,143,8,137,151,99,160,164,68,72,188,152,16,79,
11,129,225,71,219,109,17,178,93,68,177,184,102,170,14,172,28,133,242,152,8,153,35,204,90,210,140,34,40,162,28,158,255,106,40,75,134,123,146,231,52,114,196,31,154,89,28,233,7,199,205,108,237,89,51,91,247,164,251,3,55,115,63,49,205,31,70,89,220,11,211,108,91,100,209,31,0,129,25,18,108,91,100,209,192,153,102,199,32,139,182,197,52,219,93,89,180,125,166,209,253,200,162,85,52,205,206,80,22,237,174,188,144,212,72,136,237,174,44,218,93,121,53,108,48,217,29,58,161,134,122,217,238,202,162,221,85,117,52,108,233,216,29,216,87,2,80,154,0,194,153,0,130,54,20,161,145,81,17,33,168,161,144,102,228,155,136,183,96,20,189,85,228,27,9,177,221,149,69,147,33,15,66,75,210,199,118,151,69,140,62,149,85,199,118,23,156,181,144,139,101,139,64,136,96,187,203,138,47,174,70,190,81,164,36,29,153,9,34,149,55,106,98,220,250,145,13,38,75,40,224,146,142,216,2,23,47,109,222,0,13,218,93,136,75,128,134,237,174,0,22,246,102,22,203,22,182,187,44,51,219,93,89,252,45,135,180,59,99,39,216,238,178,225,101,187,107,126,128,
22,213,23,177,55,240,53,218,93,89,180,187,160,55,128,85,53,125,147,52,147,231,249,47,0,0,0,255,255,3,0,132,193,106,74);


programfile__D_2PRE_MID
:array[0..7103] of byte=(
120,1,236,153,81,83,99,201,117,199,239,181,174,44,17,68,33,106,68,16,145,48,26,207,236,44,12,32,144,144,16,18,146,184,66,72,128,16,195,48,59,177,157,84,170,92,235,196,101,187,28,123,93,91,78,165,252,100,57,207,122,232,15,112,62,132,63,128,43,149,60,228,45,223,105,243,251,119,79,102,215,118,242,9,146,125,25,212,231,118,247,57,167,79,159,115,250,183,15,239,127,250,15,81,20,125,59,138,163,76,244,111,15,239,191,252,121,20,125,235,223,163,175,126,144,36,223,42,231,163,175,158,50,127,241,31,127,27,125,245,55,223,226,163,175,226,210,237,231,95,254,170,81,251,227,255,52,254,83,198,155,127,60,92,211,248,47,62,255,242,103,191,248,209,231,127,36,97,60,255,244,79,63,251,245,231,95,54,219,252,253,237,183,63,251,252,151,95,180,248,107,229,33,124,221,104,242,99,119,252,197,175,126,243,229,207,126,242,211,95,215,246,198,251,181,70,183,219,168,253,232,55,181,239,125,241,155,31,255,250,203,207,107,239,255,255,147,255,67,126,41,189,249,241,63,215,222,127,249,249,223,255,252,27,145,68,4,252,47,227,
199,81,8,228,191,252,215,232,171,231,49,129,155,41,253,224,55,255,248,197,175,126,250,197,47,127,252,205,5,254,237,39,177,107,30,157,46,154,233,75,215,220,59,228,223,162,155,156,214,70,103,217,102,35,179,152,164,219,110,216,207,45,70,105,161,153,230,221,228,42,89,12,211,170,27,165,9,162,200,53,15,55,17,229,220,112,88,98,98,118,152,38,110,54,173,77,135,153,230,193,218,98,198,74,227,211,220,98,154,38,205,180,228,166,173,100,49,78,203,12,197,12,101,92,179,81,226,247,138,75,251,207,152,27,165,252,57,62,173,48,148,119,233,121,212,60,218,89,164,124,53,104,22,145,22,220,184,17,47,6,105,101,204,14,41,170,29,108,33,77,220,224,100,19,105,206,77,88,123,144,238,184,81,83,42,99,208,254,139,225,65,130,106,101,169,52,57,206,243,213,166,27,53,114,205,122,129,15,10,110,56,216,64,186,218,100,211,167,225,42,54,149,221,195,56,63,100,153,167,180,252,128,101,179,180,196,104,222,61,60,36,24,130,19,78,162,217,109,126,241,144,150,102,104,53,153,110,32,205,185,217,67,150,229,170,110,122,153,116,62,205,
248,15,199,151,25,204,219,232,48,119,54,203,97,142,164,81,231,84,203,148,166,105,214,141,135,207,22,72,199,168,249,120,189,55,31,102,250,71,197,197,35,190,186,77,179,139,121,186,218,231,207,249,56,191,184,69,227,254,126,134,161,200,221,14,202,252,78,220,184,183,177,232,167,185,49,203,220,14,95,48,20,187,73,59,215,62,218,70,139,156,27,125,82,92,180,217,247,22,95,141,210,218,45,19,39,167,153,118,187,140,52,239,70,103,146,22,220,195,77,94,82,215,219,143,103,87,69,44,90,119,211,65,1,237,178,61,254,156,113,194,211,116,103,198,220,233,40,211,57,169,234,248,220,120,80,68,231,130,123,188,202,123,139,250,135,201,124,90,64,235,146,187,29,23,80,41,154,163,237,252,54,135,74,101,119,123,157,120,173,187,199,210,26,21,199,91,139,46,26,60,221,202,249,120,250,109,52,236,20,241,116,209,205,238,228,211,252,144,63,31,174,243,40,177,249,128,123,103,215,81,179,94,229,87,226,166,115,157,255,138,123,247,38,143,38,85,52,200,180,206,147,197,59,150,153,63,172,160,193,106,43,93,115,143,248,107,158,110,185,
249,155,152,161,140,59,105,87,131,223,38,165,197,9,122,191,127,40,161,73,201,61,189,137,219,151,235,139,247,252,249,240,54,143,6,165,54,123,60,61,73,137,178,107,117,162,135,119,43,140,62,115,183,183,89,121,166,165,248,64,122,155,86,220,195,83,212,108,72,186,229,102,111,18,164,220,8,188,249,46,196,199,236,62,115,114,226,151,145,235,38,55,69,191,239,195,187,60,22,151,92,189,153,204,238,10,204,41,186,41,46,156,165,249,58,115,181,140,108,154,206,226,163,211,117,70,139,110,212,211,208,218,145,162,7,175,141,248,119,58,72,14,136,229,89,186,113,192,175,241,80,225,85,118,211,11,221,166,146,219,175,103,199,103,154,179,165,171,49,60,47,44,246,25,157,114,94,242,233,222,167,201,184,33,105,89,215,170,143,130,123,146,158,150,56,178,188,123,249,34,30,55,229,86,230,198,46,109,173,47,94,74,193,230,6,119,107,93,199,62,57,139,247,143,42,33,122,234,107,172,156,147,66,147,179,231,163,150,238,89,226,142,78,139,94,199,254,73,121,113,148,70,125,134,70,157,231,12,101,92,253,69,60,220,171,248,59,212,219,
47,44,234,233,74,143,209,209,113,13,105,226,78,142,162,254,65,21,45,18,215,107,203,87,197,30,110,75,207,246,252,181,222,223,75,250,175,37,205,186,238,94,153,216,97,217,79,119,253,196,254,97,208,189,123,82,242,49,213,63,216,233,158,101,248,116,187,203,13,104,183,74,104,25,181,153,216,111,188,96,52,114,221,78,246,148,108,161,53,218,205,146,191,31,125,238,139,236,239,214,147,197,41,74,53,79,183,253,90,103,207,119,251,164,138,179,180,172,137,39,135,113,151,12,72,234,234,114,86,103,47,118,46,27,57,201,78,210,228,18,113,253,48,233,158,86,253,186,103,159,86,135,39,107,200,138,117,118,57,58,201,96,53,27,227,147,46,138,156,53,43,136,228,253,18,62,202,203,228,131,231,113,175,85,89,244,248,179,179,87,90,112,174,29,254,28,54,119,152,152,113,189,211,164,126,88,69,154,117,29,110,80,135,161,225,69,13,15,70,67,142,169,215,142,78,14,52,55,239,58,220,108,77,76,209,95,185,178,71,32,156,176,115,147,91,235,215,110,84,189,252,170,89,59,61,143,122,205,4,99,162,171,180,236,231,246,194,220,49,30,59,77,
11,10,128,250,113,102,120,178,29,78,172,93,25,87,19,22,41,215,217,231,228,32,186,60,140,9,183,221,75,118,235,50,67,183,121,140,245,76,59,145,3,15,147,97,163,204,76,206,171,25,238,250,213,105,109,113,197,87,7,187,241,240,19,121,177,38,159,244,246,203,94,179,241,110,77,115,201,170,154,149,115,189,163,146,183,104,88,127,206,111,44,65,243,30,242,206,145,44,192,126,226,250,64,201,156,37,218,73,155,219,237,237,59,14,246,13,27,193,113,23,157,168,213,140,57,226,221,11,52,57,111,86,134,157,252,226,60,221,110,49,237,162,167,83,161,50,212,183,22,94,218,173,32,82,86,172,201,43,238,162,175,114,193,169,179,243,5,255,158,159,215,210,243,13,62,89,151,71,47,218,241,241,65,14,39,111,35,200,240,193,206,57,163,195,198,214,226,88,201,139,67,175,71,125,102,234,112,187,71,53,252,195,125,58,126,198,121,23,82,45,250,10,105,45,72,207,20,51,72,201,232,39,88,222,108,196,253,97,194,202,21,63,183,183,115,213,206,240,193,206,21,211,250,125,57,46,118,45,238,160,151,158,239,92,147,251,186,233,174,235,83,79,48,
235,154,175,218,31,238,81,183,183,137,136,90,216,41,251,40,79,7,201,73,93,229,105,75,42,244,207,118,88,131,202,213,175,177,111,236,70,167,153,102,67,201,105,67,151,245,226,248,249,100,47,135,93,101,249,34,237,104,90,228,90,135,101,127,29,47,78,131,207,174,79,42,139,107,124,118,116,24,167,173,93,237,175,26,220,167,6,83,147,220,228,117,141,89,88,118,154,81,232,167,124,216,39,111,117,211,146,238,241,237,113,14,111,80,161,91,81,151,195,188,77,183,228,237,33,39,41,247,77,219,242,89,52,101,104,124,28,119,62,249,208,6,96,153,116,159,178,3,81,160,140,212,222,79,38,68,154,114,207,232,117,137,19,35,29,157,203,222,2,22,198,251,173,85,68,155,178,179,59,244,43,98,111,150,140,80,113,251,151,241,176,147,67,74,16,197,238,130,40,189,96,141,113,165,134,52,113,123,157,36,61,82,132,151,125,207,113,82,163,155,64,250,201,54,249,146,186,250,58,122,245,82,133,175,48,162,30,12,207,182,208,57,235,102,151,149,197,43,246,157,116,146,230,65,76,126,222,154,48,58,58,172,62,96,31,78,85,35,213,60,139,166,56,
158,154,230,77,107,213,238,57,107,90,2,121,249,164,29,221,182,243,139,251,116,211,23,106,210,149,124,126,223,82,92,36,247,252,57,59,75,234,100,7,95,5,185,151,211,116,149,161,50,121,32,235,122,175,50,163,51,213,236,162,146,233,176,31,122,149,89,186,194,189,216,114,189,227,120,124,145,67,74,214,39,59,224,159,20,155,111,79,118,187,36,8,242,172,223,239,188,234,247,187,58,175,221,190,202,114,85,183,148,33,167,199,49,71,147,33,43,149,217,15,15,224,235,177,84,121,245,114,122,172,26,84,156,226,129,241,89,229,145,18,50,166,240,222,143,214,41,184,52,117,131,44,150,60,115,143,237,2,71,149,29,243,231,236,34,238,53,86,37,85,69,28,159,87,31,125,201,218,118,119,163,140,180,112,221,182,234,247,51,55,25,230,23,119,105,73,177,243,56,120,161,56,120,68,58,31,196,157,206,22,85,60,239,238,250,59,239,40,104,119,124,59,191,140,219,244,120,157,52,82,7,112,71,181,156,83,64,159,232,95,88,129,90,254,164,153,253,168,69,247,48,103,189,59,110,249,29,118,60,14,171,132,43,221,220,85,220,172,75,167,77,55,235,
174,114,46,27,190,155,195,127,205,52,241,77,210,32,110,147,185,116,39,134,23,202,77,20,193,171,26,241,21,185,209,165,122,94,50,246,235,109,159,41,134,231,187,55,248,147,118,88,57,120,116,26,117,201,61,55,105,197,159,200,217,243,59,170,210,144,124,209,59,210,29,160,242,181,100,165,191,109,195,211,231,179,174,164,107,61,76,26,93,145,208,228,219,77,182,204,176,116,213,77,216,138,185,234,77,70,125,122,71,21,219,170,95,119,88,157,118,37,43,171,147,76,207,146,238,97,130,51,42,110,128,38,105,90,86,212,78,6,181,250,126,236,247,76,71,49,51,67,76,15,55,137,233,85,58,200,151,170,36,142,91,176,223,95,213,25,202,198,110,247,197,232,188,200,28,175,195,1,117,145,42,250,161,123,238,93,84,211,97,150,19,171,28,48,175,223,137,142,78,11,236,85,114,237,110,204,197,127,33,223,92,118,171,11,106,3,45,128,171,31,68,61,114,156,242,115,187,85,27,210,114,112,57,85,69,186,231,9,117,29,221,55,125,165,238,108,15,187,146,149,41,91,25,53,56,236,136,205,106,18,90,231,59,195,70,129,3,91,63,144,110,253,232,136,
172,135,140,200,112,173,179,117,242,200,134,59,250,36,51,32,158,90,105,117,192,57,119,123,185,87,120,130,116,219,37,62,207,142,85,113,25,109,87,48,137,12,213,9,25,170,59,222,81,74,237,226,225,203,43,233,94,86,61,235,247,106,151,189,60,191,42,238,106,148,197,140,45,247,154,253,94,145,172,142,198,153,197,235,180,116,197,77,238,77,242,44,79,109,189,216,238,164,57,204,227,100,231,171,248,126,195,13,103,190,82,186,222,163,206,180,234,134,215,254,26,170,88,141,59,170,145,220,208,78,117,124,231,109,112,211,71,101,146,178,235,92,239,246,238,95,14,238,245,52,137,125,118,243,253,247,120,86,157,63,20,249,34,30,168,23,155,147,70,212,218,150,220,152,93,166,105,81,175,176,199,89,88,98,122,155,16,202,145,27,28,215,198,151,89,37,8,205,153,223,108,50,125,213,77,105,162,143,75,204,229,241,132,70,211,52,167,126,245,110,94,64,74,207,249,189,104,48,72,136,200,170,27,211,153,78,217,97,62,215,35,138,86,64,251,198,205,147,28,115,55,217,215,191,103,154,172,248,56,211,92,250,199,135,120,208,202,177,53,
247,30,183,48,87,113,55,159,104,95,250,213,105,210,108,60,11,251,94,105,229,172,230,222,241,92,208,190,253,97,52,97,31,237,123,245,102,133,232,164,155,190,79,240,126,65,94,158,204,162,38,217,64,119,225,234,94,217,218,247,216,247,79,101,18,20,153,246,58,82,221,187,215,220,161,34,123,93,111,165,25,169,135,244,69,220,199,205,70,232,162,175,198,186,170,107,218,247,118,148,71,90,166,96,70,19,30,62,122,158,92,221,235,25,178,162,154,53,187,217,64,170,125,51,205,139,44,251,34,125,250,122,223,119,165,32,189,139,250,125,101,234,109,119,117,171,10,83,162,57,207,162,243,186,180,106,54,146,201,96,155,185,137,187,186,212,202,28,25,207,162,150,180,250,212,245,246,162,241,137,146,170,207,197,195,131,93,221,12,149,160,241,113,181,121,152,153,182,84,117,42,62,215,166,107,132,2,222,29,235,90,150,121,4,197,189,67,223,157,115,28,242,9,13,52,214,222,172,227,210,53,42,75,230,241,65,85,167,242,200,198,179,185,230,174,187,199,169,62,172,186,119,143,73,231,68,193,177,237,158,254,110,125,241,46,77,252,
235,141,243,123,34,96,155,23,153,135,27,61,148,42,110,206,243,229,65,158,122,54,39,144,102,247,207,189,29,100,232,206,225,14,135,68,191,144,134,151,223,221,213,154,55,124,126,157,52,121,211,223,165,101,77,184,155,111,176,239,170,155,63,174,48,84,113,143,147,152,131,231,6,183,107,243,187,13,118,72,230,105,174,37,5,91,219,119,248,152,196,50,227,233,121,227,51,62,84,160,120,131,39,38,36,105,37,255,86,61,25,83,91,61,19,232,172,115,181,139,169,191,66,106,21,105,2,26,254,77,232,95,208,221,117,118,37,74,47,86,188,167,238,134,153,86,205,199,33,207,35,197,86,81,111,194,57,141,218,24,7,208,156,222,53,21,203,60,154,120,11,221,165,43,88,139,84,87,98,203,221,13,178,45,94,238,146,78,104,1,201,208,45,206,116,126,169,214,168,236,154,237,204,221,153,238,31,183,132,156,124,167,88,126,38,109,230,23,47,111,187,209,25,105,107,158,22,111,137,250,73,79,221,15,46,60,45,251,110,127,218,141,154,62,171,111,139,117,140,235,219,232,146,163,186,235,186,151,238,241,200,164,145,156,189,208,187,61,227,174,218,
59,196,10,207,94,210,35,15,140,153,124,66,123,198,11,72,245,230,138,55,192,21,217,158,250,77,86,80,121,86,247,208,161,251,209,77,13,29,116,150,55,221,46,201,40,241,109,6,165,136,23,128,242,206,136,14,70,181,108,202,179,75,162,14,59,40,139,142,119,85,215,19,119,217,42,79,121,241,92,166,85,63,177,30,183,43,62,167,73,215,97,83,189,153,186,47,205,37,96,97,17,202,245,173,243,112,32,131,227,157,41,189,234,32,173,181,212,185,209,104,28,2,65,212,107,100,221,224,160,34,95,15,84,167,16,116,84,164,232,84,177,68,157,200,224,244,197,100,223,75,93,122,20,181,246,116,149,51,237,180,234,137,78,107,103,124,153,83,30,226,12,229,233,225,121,174,201,170,170,82,23,157,154,239,218,70,175,94,14,95,127,203,27,214,34,22,113,168,164,131,157,50,211,160,60,148,149,150,244,175,71,109,206,110,36,233,134,187,104,84,70,104,116,145,230,85,114,142,62,9,221,254,176,163,151,3,53,230,249,214,104,255,59,124,251,109,188,163,52,223,250,171,252,128,215,197,0,91,58,36,51,209,156,148,233,45,21,83,61,75,50,3,186,4,85,158,
94,163,146,18,213,60,214,58,220,191,65,43,219,174,235,157,176,161,140,216,165,111,215,75,41,221,223,196,115,176,44,140,61,86,237,164,78,115,22,117,189,192,48,147,134,187,94,104,62,207,95,224,112,92,16,94,31,165,246,119,162,33,71,115,46,120,86,160,19,16,140,26,156,69,45,250,67,156,227,206,143,202,233,203,146,196,186,94,195,163,184,205,241,164,122,101,241,242,121,81,30,61,47,32,91,109,83,13,235,47,118,91,7,59,190,232,235,230,182,210,77,69,68,227,40,57,122,29,227,59,176,199,119,159,49,138,161,29,133,16,135,119,156,105,193,138,180,75,135,104,86,119,51,224,205,135,91,26,105,190,165,194,196,145,182,163,14,61,150,239,150,91,101,26,17,62,223,76,211,156,142,25,192,215,219,219,109,0,238,120,104,10,85,181,210,23,35,122,5,89,218,29,100,22,141,116,219,247,254,195,93,90,31,220,95,246,191,6,177,48,17,121,217,141,6,229,201,181,26,33,90,66,30,104,221,100,246,182,236,211,210,228,78,157,127,76,182,219,229,119,214,61,188,87,193,133,182,80,7,71,148,235,225,216,55,248,10,240,209,120,133,188,86,115,
215,127,253,233,205,176,58,163,30,220,232,98,37,238,225,174,132,96,5,190,183,251,64,37,166,163,229,13,133,2,138,130,183,239,3,7,122,248,44,191,120,75,38,126,251,24,144,205,103,20,172,183,56,234,237,104,101,241,25,57,227,1,181,223,166,207,69,170,222,141,95,62,246,214,72,176,171,74,195,243,193,246,19,169,90,201,228,205,245,170,207,181,247,215,235,139,55,220,211,183,115,53,200,80,36,138,207,91,229,241,113,140,30,101,247,72,19,161,178,51,191,17,78,219,160,78,174,50,127,195,189,241,69,178,226,238,39,5,230,175,185,91,26,23,21,190,135,39,61,158,40,64,20,222,135,116,115,134,173,55,253,242,124,182,142,129,69,178,153,118,39,51,98,62,41,218,221,223,168,120,239,128,22,87,153,93,246,141,255,164,61,131,104,77,210,223,253,144,60,28,159,79,50,163,81,116,124,17,181,175,139,191,79,127,59,226,65,187,122,158,102,219,233,22,184,242,70,174,121,239,70,55,209,236,46,58,186,140,57,189,230,40,106,167,27,191,79,163,74,250,219,148,240,89,107,167,171,163,52,158,165,223,119,119,111,226,116,150,105,13,11,72,
107,233,111,245,254,34,186,117,97,238,210,213,163,244,119,60,247,175,162,217,52,131,183,155,147,104,50,138,94,93,109,243,233,247,211,223,254,139,40,82,204,195,255,149,186,240,136,94,156,42,129,40,250,234,127,160,216,254,127,149,124,131,96,235,207,232,63,51,177,65,177,151,80,108,131,98,243,111,209,62,82,236,37,20,219,160,216,203,64,177,13,138,189,164,81,51,58,106,68,145,65,177,17,229,12,138,205,68,81,108,251,72,177,151,68,136,65,177,151,36,50,18,141,65,177,151,84,103,134,98,134,50,6,197,230,247,138,65,177,153,27,65,177,17,85,24,202,91,234,41,246,146,59,98,80,108,164,5,131,98,47,3,197,182,64,177,145,38,6,197,70,154,51,40,54,210,29,27,53,51,232,133,65,158,98,163,154,40,182,65,177,249,106,211,2,197,230,131,130,65,177,145,138,98,27,20,27,155,202,22,40,246,50,80,108,227,12,25,205,27,20,27,67,112,130,167,216,203,64,177,13,138,141,52,103,80,108,150,171,90,160,216,254,67,40,54,230,137,98,27,20,27,115,36,21,197,70,42,138,109,80,236,101,160,216,246,145,98,47,161,216,6,197,94,6,138,109,80,
236,37,20,219,160,216,12,69,6,197,230,119,98,80,236,101,160,216,6,197,102,40,182,64,177,209,34,103,163,79,138,75,40,182,65,177,49,174,70,204,114,146,162,216,72,243,6,197,70,90,48,40,182,164,22,40,54,22,173,27,20,27,237,212,69,27,20,27,245,69,177,45,80,108,29,159,65,177,209,185,96,80,108,111,81,160,216,104,93,50,40,54,42,69,52,188,6,197,70,165,178,65,177,189,214,80,236,160,226,120,107,73,54,55,40,54,154,224,105,79,177,241,116,209,160,216,104,32,138,109,80,108,148,16,197,182,64,177,249,149,24,20,155,179,91,49,40,54,154,84,209,64,20,123,201,27,214,160,216,104,32,138,109,80,108,118,220,50,40,54,67,25,131,98,7,191,77,74,75,40,182,65,177,209,164,100,129,98,47,161,216,40,145,71,3,189,124,13,78,141,18,101,11,20,155,209,103,6,197,150,103,160,216,94,10,197,182,64,177,145,110,25,248,25,105,65,113,9,197,70,207,109,11,20,91,203,200,117,80,108,191,47,20,27,139,75,22,40,54,210,162,65,177,153,32,138,237,151,145,77,129,98,51,90,52,40,54,102,138,98,27,20,155,115,202,115,56,162,216,72,69,177,137,
30,133,87,217,160,216,156,68,201,2,197,102,72,20,219,160,125,75,40,54,115,138,196,103,209,2,197,214,4,93,43,40,246,18,138,109,80,108,142,44,111,129,98,135,185,177,65,177,151,80,108,131,98,115,183,68,177,45,80,236,16,61,245,53,86,22,197,102,84,20,155,209,196,160,216,94,71,40,246,146,42,7,106,51,40,54,67,25,11,20,219,223,33,40,246,50,80,108,131,98,35,77,44,80,108,180,72,12,138,141,175,138,112,13,110,246,158,191,214,129,98,35,205,26,20,155,216,97,217,79,119,253,68,40,182,215,29,138,237,99,42,80,108,134,68,177,13,138,141,150,228,217,172,65,177,25,141,44,80,108,191,6,20,219,223,15,40,118,88,163,158,44,161,216,6,197,246,107,5,138,189,12,20,219,2,197,38,248,68,177,45,80,108,201,2,197,182,64,177,253,186,129,98,35,19,197,54,40,54,86,179,49,62,129,98,27,20,27,145,188,95,194,71,162,216,22,40,246,146,247,140,65,177,151,129,98,27,20,155,137,25,11,20,27,105,214,160,216,220,187,140,65,177,241,32,165,54,198,93,162,216,72,243,6,197,70,154,24,20,219,231,74,40,54,158,36,43,159,84,195,218,141,170,
151,127,164,216,24,19,5,138,109,157,94,152,11,197,198,7,5,250,99,11,20,59,156,152,167,216,44,34,138,109,129,98,19,110,162,216,6,197,246,222,130,98,51,20,67,177,41,3,162,216,204,228,188,154,225,174,67,177,151,80,108,11,20,155,141,107,242,9,20,219,107,6,197,214,92,178,170,102,229,12,138,237,45,130,98,7,23,160,57,20,219,160,216,193,126,226,58,80,108,236,23,197,246,171,116,142,131,125,80,108,63,43,80,108,142,88,20,219,2,197,94,6,138,109,80,108,190,161,50,212,183,150,94,218,173,32,82,86,172,201,43,6,197,38,190,34,131,98,35,143,44,80,108,62,17,197,182,64,177,113,242,54,130,12,31,136,98,27,20,123,25,40,182,5,138,77,84,225,159,163,26,254,225,62,29,63,227,188,11,169,22,245,20,59,72,207,170,65,74,70,135,98,83,5,69,177,89,89,20,219,186,158,98,243,193,14,20,219,64,46,232,22,27,20,59,204,245,20,27,233,174,241,154,95,210,21,210,129,25,20,59,72,123,155,136,168,133,157,178,143,242,64,177,185,166,162,216,6,197,230,171,140,65,177,217,55,182,64,177,145,138,171,89,160,216,216,37,138,109,80,108,4,
145,65,177,81,44,49,40,182,247,25,20,123,9,197,182,64,177,181,191,164,80,108,86,102,223,215,53,102,97,183,167,216,76,36,228,201,91,129,98,27,20,27,111,80,161,61,197,38,25,139,98,27,20,155,83,33,203,183,229,51,222,66,145,5,138,77,116,208,6,96,153,116,135,98,43,10,148,145,2,197,102,31,50,194,235,18,39,70,58,58,151,189,5,44,20,197,70,36,138,109,80,108,173,136,189,89,50,66,197,2,197,70,42,138,109,80,108,44,162,174,85,106,72,19,11,20,155,77,69,252,232,42,106,116,19,72,63,217,38,95,82,87,61,197,70,90,128,98,27,20,27,157,179,6,197,94,66,177,241,183,40,54,249,89,20,219,70,158,98,163,24,111,205,162,5,138,77,222,23,197,182,177,167,216,172,35,138,77,141,18,197,94,6,138,109,19,210,149,124,14,197,230,124,68,177,45,80,108,22,198,63,39,219,164,233,85,134,202,228,129,172,5,138,173,138,161,100,10,197,70,35,42,70,186,194,189,216,178,64,177,145,138,156,208,76,233,20,99,11,20,155,15,34,223,24,156,87,253,126,129,98,115,85,69,177,13,138,205,209,100,200,74,101,246,195,3,220,106,158,146,22,40,182,246,
131,98,91,160,216,8,214,12,138,77,193,165,169,27,100,177,228,153,65,177,57,42,81,108,11,20,91,82,85,196,64,177,153,179,109,48,18,105,97,80,108,164,207,12,138,189,12,20,219,160,216,58,53,208,156,5,138,77,21,207,91,160,216,124,243,204,2,197,102,139,72,29,0,20,155,15,170,6,197,214,10,129,98,219,220,83,108,4,177,65,177,17,36,6,197,38,92,233,230,60,197,102,215,77,131,98,115,46,162,216,196,136,186,87,81,108,27,121,138,173,227,35,231,42,55,81,4,175,106,196,87,100,80,108,60,70,198,126,189,141,156,216,245,20,155,79,68,177,185,79,162,216,203,64,177,137,17,81,108,100,219,164,54,221,129,12,129,47,43,253,109,11,20,27,169,40,182,5,138,141,111,55,217,50,195,210,85,131,98,107,174,122,147,64,177,217,88,20,155,62,91,20,27,153,40,54,229,82,20,27,103,84,12,138,205,33,139,98,91,160,216,126,79,40,54,51,67,76,15,55,137,233,85,58,200,151,170,36,198,45,128,98,235,12,101,99,160,216,204,241,58,64,177,85,69,63,116,207,129,98,115,98,162,216,22,40,54,123,149,12,138,205,197,23,197,54,40,246,50,80,108,11,20,
155,207,185,172,158,98,235,114,170,138,4,138,141,238,162,216,214,246,20,27,89,217,2,197,214,142,129,98,91,160,216,28,152,40,182,5,138,45,127,232,62,67,177,201,35,27,22,40,54,223,136,98,147,55,69,177,149,110,161,216,6,197,166,226,50,218,174,96,18,25,170,19,50,84,160,216,12,85,13,138,141,238,162,216,22,40,54,191,42,6,197,198,140,45,131,98,115,181,119,12,138,189,12,20,219,160,216,44,79,109,245,20,27,243,56,217,249,42,190,223,48,40,54,191,177,227,81,39,94,53,40,54,191,183,84,239,160,216,184,152,115,243,20,91,54,24,20,155,161,178,125,164,216,74,241,31,41,182,5,138,205,23,162,216,116,191,164,17,181,182,37,4,234,12,69,177,13,138,237,151,128,98,19,202,145,5,138,173,4,161,57,80,108,164,171,22,40,54,115,121,60,161,81,160,216,6,197,70,74,207,233,41,54,17,89,53,40,54,210,146,65,177,9,145,2,108,140,125,99,40,54,115,55,217,215,191,103,96,149,236,171,185,244,143,158,98,235,102,27,20,91,115,21,119,80,108,164,244,171,158,98,135,125,175,180,178,40,182,65,177,253,190,129,98,251,125,161,216,68,39,
221,244,125,130,247,11,87,236,27,40,182,191,11,80,108,164,5,245,216,80,108,18,20,153,214,83,108,242,76,213,160,216,72,69,177,13,138,173,244,69,220,139,98,43,71,25,20,27,169,40,182,65,177,145,150,41,152,162,216,36,183,178,65,177,145,138,98,27,20,27,169,246,21,197,102,46,210,167,175,247,125,87,10,82,79,177,217,119,219,160,216,204,45,209,156,103,209,89,20,155,10,46,138,205,220,196,160,216,72,57,50,158,69,45,105,245,169,5,138,173,125,125,28,28,236,234,102,168,4,125,164,216,184,69,20,219,184,138,132,2,222,29,235,90,150,121,4,137,98,227,191,45,142,67,111,6,81,108,52,94,103,104,141,202,34,138,205,168,40,182,65,177,153,187,110,80,108,134,170,22,40,54,39,180,109,80,108,94,75,162,216,254,252,160,216,196,176,40,54,210,138,65,177,201,130,31,40,54,39,241,220,219,17,40,54,135,68,110,76,195,203,15,138,237,13,15,20,27,145,40,54,209,180,193,190,171,6,197,102,168,98,80,108,14,62,99,129,98,179,195,7,138,109,31,41,54,235,215,12,138,205,231,31,40,182,65,177,89,154,54,199,83,108,108,95,161,3,89,231,
106,139,98,115,133,212,42,210,4,120,138,173,112,178,113,119,157,93,137,210,139,21,239,169,64,177,17,113,75,232,165,2,197,54,40,54,210,109,53,167,80,108,212,226,209,212,144,84,20,27,169,174,196,150,5,138,237,165,80,108,164,162,216,148,25,189,219,202,22,40,54,82,110,9,57,249,35,197,182,143,20,27,153,40,182,65,177,153,65,165,60,45,251,110,63,80,108,172,21,197,54,40,54,186,228,168,238,34,17,162,216,20,124,81,108,230,100,12,138,77,172,240,236,221,75,152,43,138,173,119,59,20,27,41,65,197,27,0,138,173,250,77,86,80,121,86,247,0,197,102,197,226,135,14,58,203,155,110,151,100,36,138,13,69,17,197,70,74,245,160,131,81,45,131,98,99,45,179,216,65,89,20,138,237,229,129,98,147,243,68,177,209,82,20,91,57,77,186,66,177,73,88,234,190,52,151,128,133,69,40,215,67,177,153,171,172,35,138,77,198,168,209,8,42,128,3,197,166,52,100,45,80,108,100,162,216,156,166,138,20,157,42,150,168,19,9,20,91,82,11,20,91,94,8,20,219,6,158,98,43,15,5,138,77,153,21,197,70,19,250,80,66,65,93,91,160,216,222,48,40,182,28,42,
41,20,155,105,80,158,110,158,216,65,127,79,177,249,74,20,219,2,197,102,186,40,54,213,35,116,251,80,108,191,114,160,216,124,251,129,98,91,160,216,172,199,27,172,225,121,141,65,177,89,87,80,142,103,137,40,54,82,158,99,158,98,115,169,69,177,209,94,20,27,35,69,177,121,9,168,254,208,199,238,111,226,57,250,74,79,177,145,138,98,27,20,27,175,96,38,13,247,127,83,108,100,162,216,60,50,62,80,108,30,32,95,83,108,170,188,40,182,156,99,129,98,75,12,197,182,64,177,153,205,43,139,151,143,167,216,200,68,177,121,136,139,98,251,162,15,197,198,4,81,108,11,20,27,223,129,61,190,251,140,81,12,237,40,132,56,60,79,177,253,46,80,108,134,240,45,111,190,111,82,108,11,20,155,13,177,202,83,108,62,255,64,177,5,248,2,197,198,43,162,216,22,40,54,123,208,243,13,50,203,64,177,233,101,68,177,113,191,40,54,64,78,20,155,64,88,161,7,19,197,214,193,249,142,204,83,108,159,150,160,216,124,16,147,237,118,249,157,53,40,182,143,80,40,54,95,239,24,20,27,121,89,1,14,197,38,175,213,236,35,197,166,51,19,197,54,40,54,130,21,
122,101,81,108,150,249,154,98,27,20,27,25,124,234,179,252,18,138,109,80,108,126,23,13,138,205,239,178,65,177,151,80,108,186,72,253,22,197,182,64,177,73,176,162,216,244,172,162,216,62,153,64,177,65,69,27,6,197,94,66,177,13,138,77,1,129,34,81,124,160,216,20,144,216,239,5,197,70,9,96,214,77,129,116,185,65,157,92,101,254,134,65,177,73,55,21,131,98,51,127,205,160,216,190,240,65,177,73,1,20,32,10,111,160,216,22,40,54,6,22,201,102,218,157,204,136,249,164,104,131,98,115,119,119,64,139,171,204,22,197,182,137,167,216,248,233,119,63,36,15,255,17,197,254,3,20,155,7,237,159,82,108,251,115,138,253,135,64,177,9,159,175,41,182,125,164,216,72,69,177,137,125,162,251,27,20,219,254,156,98,243,169,167,216,156,223,159,82,108,68,162,216,255,37,0,0,0,0,255,255,3,0,179,214,47,21);


programfile__D_4INV_MID
:array[0..9506] of byte=(
120,1,236,154,223,111,27,201,150,223,201,203,214,146,90,211,144,12,75,176,188,150,247,202,215,210,140,108,73,20,69,55,69,81,162,200,226,143,22,91,84,211,164,100,122,134,134,53,176,156,241,96,60,184,222,157,201,228,6,59,23,200,34,226,189,79,65,36,161,235,189,187,254,143,5,18,96,243,158,228,111,201,123,30,38,159,211,197,209,108,128,100,223,130,188,172,1,67,172,83,167,206,57,245,163,171,206,143,111,127,244,241,67,42,149,250,139,84,154,255,255,216,31,253,248,251,84,42,243,31,83,63,143,157,204,111,150,114,169,159,79,51,127,241,87,151,169,159,223,252,6,166,159,211,11,47,191,249,187,149,209,143,239,191,254,253,202,175,255,254,57,250,232,236,117,127,232,141,126,101,230,151,240,15,143,155,47,7,255,27,213,210,255,31,203,127,222,254,254,135,63,254,248,221,183,31,255,176,178,222,126,182,178,83,173,238,172,252,171,63,174,124,241,253,31,191,249,195,143,239,87,70,223,124,253,241,111,191,255,244,253,183,223,125,243,111,176,242,95,184,255,101,77,254,63,159,147,237,148,253,36,115,255,51,245,243,
147,116,58,245,115,102,225,236,155,175,191,255,241,195,55,63,86,118,127,253,126,82,255,24,164,194,250,225,169,106,63,186,172,171,90,216,236,59,151,74,141,155,106,38,108,247,190,245,122,206,101,91,13,61,90,71,173,175,47,143,84,46,60,244,206,143,234,119,47,15,85,16,122,190,3,233,93,216,86,206,165,167,206,195,102,87,184,223,52,225,82,157,15,205,238,28,146,206,155,234,34,244,122,23,48,244,195,30,127,123,48,182,189,119,194,24,30,159,92,92,30,35,32,224,111,160,222,135,189,147,183,193,233,42,44,123,97,255,245,60,36,191,175,82,225,224,248,195,233,89,243,114,160,30,156,98,199,217,224,226,242,76,101,195,99,255,226,172,91,100,184,27,158,246,231,33,29,135,131,230,131,203,83,212,244,143,239,195,237,246,213,66,24,180,191,233,143,242,72,26,134,189,227,236,101,31,165,193,171,251,104,240,195,254,151,162,97,20,14,152,69,95,5,3,229,132,167,47,199,8,88,96,174,95,157,182,238,48,183,32,28,212,31,67,82,97,63,184,131,204,247,97,48,156,131,187,19,48,199,158,250,155,160,37,178,154,129,202,132,190,119,
209,235,45,94,250,170,141,134,121,168,175,195,254,89,22,13,253,62,189,131,163,79,12,207,133,44,211,224,120,158,197,240,194,254,201,18,36,63,12,94,231,145,248,142,197,17,59,131,30,51,246,213,191,238,169,7,200,106,134,193,209,3,100,41,209,215,15,206,123,39,57,120,95,135,65,63,15,245,36,192,230,126,240,111,219,251,25,168,127,250,169,173,38,62,99,199,61,175,204,216,205,48,232,137,29,39,161,127,180,36,146,195,222,209,60,244,142,104,8,188,143,144,210,97,115,247,79,153,203,166,154,48,231,206,159,211,94,63,203,164,223,120,234,109,216,238,94,176,69,99,196,189,57,234,44,51,172,27,122,167,107,244,186,97,27,147,60,12,111,54,101,187,71,161,194,152,166,26,43,140,105,6,95,181,187,15,104,141,56,19,161,215,90,135,49,29,182,15,127,11,99,42,244,10,15,105,103,194,246,254,138,87,73,67,90,14,219,149,44,164,31,218,106,54,108,214,246,24,184,141,73,63,241,119,24,250,141,11,212,158,135,126,91,254,126,19,246,14,62,103,54,185,208,223,89,165,237,132,189,23,203,180,243,161,255,185,152,55,19,246,214,101,165,
232,223,93,163,157,13,123,165,199,180,239,132,254,250,67,218,153,176,183,241,132,246,92,232,63,122,76,59,21,246,220,77,219,255,100,133,54,242,14,182,104,35,111,237,41,109,182,119,119,137,246,221,208,255,171,71,182,93,122,56,229,23,253,179,97,111,103,157,118,54,244,139,178,218,200,43,109,211,70,255,74,145,54,242,182,229,36,179,153,235,123,182,63,209,71,255,162,216,135,61,85,233,119,66,127,243,9,109,236,221,20,123,232,127,42,167,136,254,162,204,15,253,191,91,178,253,174,216,131,125,235,211,249,110,74,63,250,63,155,218,191,179,98,251,159,203,46,163,127,71,250,145,183,62,249,116,116,32,50,70,236,200,99,182,240,32,108,55,87,88,118,21,54,27,249,233,22,230,88,243,115,217,66,191,252,77,125,87,86,160,22,42,245,152,59,161,17,182,154,243,124,201,163,22,194,218,251,99,175,42,219,62,246,152,218,81,251,131,23,108,218,67,81,151,59,224,13,135,226,17,189,157,80,157,202,161,232,43,38,82,239,126,56,106,204,34,233,109,88,171,45,195,237,135,245,206,202,101,77,52,240,45,212,57,220,232,109,190,124,
221,238,222,97,204,135,208,27,174,32,99,47,236,246,239,33,51,232,202,36,134,95,247,78,101,94,253,48,24,201,62,215,2,182,188,127,54,226,224,207,133,157,151,23,253,87,43,151,29,102,20,156,46,64,226,172,15,102,57,224,175,56,251,11,112,239,201,134,118,187,159,252,179,165,203,46,95,85,247,108,1,89,131,176,231,75,187,19,250,47,23,225,58,9,187,47,69,135,234,34,219,243,190,237,4,11,162,63,244,248,219,97,84,103,48,71,123,24,182,58,210,246,90,44,190,58,28,215,203,51,172,206,215,117,230,80,219,185,168,55,238,50,179,110,157,141,82,189,175,90,39,15,232,27,134,157,96,245,178,133,4,239,108,142,145,220,167,14,171,242,81,108,99,246,204,83,172,105,118,89,43,175,253,161,195,87,235,177,87,173,78,30,222,126,162,229,224,162,213,188,139,164,32,236,112,199,181,84,167,131,4,175,247,166,235,223,135,215,147,145,190,255,190,213,187,131,156,49,215,233,34,60,237,176,215,95,101,13,106,161,143,252,30,86,216,89,51,59,249,52,127,232,28,230,24,59,238,176,50,94,231,162,235,201,137,104,134,254,217,163,100,69,122,
126,30,89,35,110,154,52,99,207,3,230,234,53,63,246,135,107,112,85,194,224,236,33,171,220,225,194,190,143,134,62,202,147,123,208,231,115,235,6,31,78,79,31,35,163,29,14,191,90,228,238,28,132,47,135,11,151,67,110,188,32,112,46,95,114,10,228,190,14,212,159,150,88,254,52,12,219,61,85,230,250,148,83,156,13,187,141,101,14,47,195,151,228,12,119,15,23,253,142,180,150,195,174,154,131,97,194,45,210,158,129,80,241,212,106,232,237,78,124,153,3,215,234,248,168,38,211,57,61,146,165,216,251,84,119,197,124,191,206,105,106,117,223,176,26,111,67,175,49,130,225,167,240,168,57,110,55,229,24,178,29,253,167,28,52,55,60,26,201,70,251,24,113,15,122,55,236,121,14,163,127,144,175,77,117,82,171,106,243,114,85,61,196,90,187,153,62,219,223,99,242,71,157,187,112,33,152,229,61,162,221,110,203,39,240,30,99,238,35,117,193,83,147,165,176,239,159,7,156,91,185,179,251,103,114,191,95,244,213,239,167,151,43,87,127,255,79,207,160,157,35,250,109,112,38,215,85,59,236,243,120,4,234,184,207,182,12,130,243,211,51,121,202,
142,79,153,213,217,233,7,94,185,52,15,223,199,179,87,143,120,248,58,225,233,80,30,190,62,47,164,60,124,65,216,31,204,195,93,235,99,119,112,242,177,63,186,139,164,47,251,172,143,125,120,47,194,118,48,121,143,109,53,33,28,243,254,201,153,15,252,187,8,27,132,94,247,9,236,138,71,121,192,52,230,143,81,213,235,189,235,6,51,112,53,186,170,24,246,2,177,48,19,30,55,159,244,142,51,140,89,12,143,95,102,33,77,130,99,185,255,94,239,241,27,182,147,177,223,17,209,65,120,228,207,178,66,124,64,175,31,177,66,190,92,25,237,238,121,211,155,199,6,191,201,221,118,228,95,28,158,202,94,212,194,250,48,131,83,113,17,170,129,124,20,188,46,95,228,147,3,223,238,45,112,41,212,88,80,190,158,55,189,19,121,47,62,133,77,30,75,20,115,131,124,33,221,65,88,239,203,247,81,171,243,128,212,79,254,188,131,136,212,207,191,184,64,115,255,227,214,5,26,126,247,254,111,191,255,213,251,73,126,165,254,203,111,82,218,186,64,19,92,32,141,11,52,177,46,144,182,46,208,196,186,64,26,23,104,130,11,164,173,11,52,193,5,210,184,64,144,
222,105,158,187,9,111,187,198,5,130,91,92,32,157,184,64,119,74,135,34,236,117,73,101,180,139,92,188,33,93,62,77,121,189,153,137,171,94,233,202,105,142,97,185,178,242,116,175,231,76,42,112,85,189,241,164,170,210,188,28,122,191,247,229,100,95,57,122,231,48,141,199,132,92,72,163,252,100,71,245,245,241,73,182,122,226,208,59,210,149,94,122,114,172,238,84,213,176,2,111,112,146,42,183,253,73,89,221,213,110,247,206,132,3,231,50,172,220,78,247,78,6,80,243,26,7,107,210,83,174,174,54,29,124,44,24,150,171,106,19,55,75,39,110,86,186,94,169,176,8,179,214,217,210,56,91,19,156,45,125,236,167,220,103,23,152,156,210,56,93,168,115,245,105,223,169,20,242,244,174,86,212,154,198,245,154,224,122,233,254,177,115,88,158,155,12,212,202,161,90,192,1,211,137,3,150,45,21,102,208,116,82,82,51,26,55,108,130,27,166,131,87,217,250,70,30,83,86,235,106,85,227,140,193,48,212,229,174,131,63,6,195,94,89,45,224,146,105,92,50,4,47,176,246,233,202,206,91,86,40,173,113,205,88,243,64,15,234,185,106,101,145,222,71,85,44,
192,65,67,237,185,222,47,205,224,163,33,97,101,95,173,226,54,233,196,77,203,20,139,243,232,90,46,170,53,156,53,141,179,86,107,165,240,215,38,190,90,175,169,71,88,35,221,175,117,255,44,227,214,29,76,217,113,213,50,142,155,198,113,67,108,78,115,118,203,187,99,86,208,97,161,230,217,52,79,247,79,50,149,218,34,189,143,42,106,75,227,198,161,244,75,93,109,228,240,228,144,224,86,213,146,236,34,190,203,126,53,143,63,135,174,242,190,186,163,43,245,52,94,157,108,66,69,229,113,225,116,245,200,233,7,175,247,7,25,54,222,209,248,120,8,26,237,51,211,160,159,169,53,102,225,236,214,148,35,156,253,32,87,175,143,216,160,37,237,238,164,241,251,224,28,186,106,94,215,221,62,212,188,174,85,222,78,224,213,251,141,11,206,75,90,87,17,186,175,198,28,40,93,225,244,86,152,73,181,158,74,124,68,167,220,118,80,184,229,171,167,50,171,74,99,6,127,17,93,39,21,49,250,40,93,173,63,96,22,170,202,144,253,35,7,223,17,251,197,119,212,129,55,131,204,172,174,29,158,195,144,214,205,221,12,58,115,186,180,51,154,148,196,134,
221,243,253,122,14,146,219,84,207,116,181,35,22,124,172,50,240,168,147,171,236,142,203,172,78,69,141,68,167,219,59,79,206,84,177,62,158,20,69,194,129,184,160,108,110,179,164,230,180,219,158,101,157,153,94,86,151,91,78,187,27,176,250,57,93,233,228,153,217,72,206,58,94,223,86,185,49,217,82,139,136,206,86,94,200,110,54,100,138,222,105,186,92,91,69,206,118,153,19,199,169,197,101,69,212,158,172,84,179,153,46,53,50,34,162,132,73,170,239,20,15,114,124,150,199,69,53,167,32,148,54,156,102,48,102,30,51,186,221,205,20,246,22,232,11,10,42,39,31,95,113,207,193,165,69,80,90,227,210,38,223,35,46,45,237,140,182,46,45,164,101,141,75,11,105,89,175,190,200,49,169,0,215,86,227,218,34,102,155,149,114,158,213,22,38,171,202,127,134,249,27,245,68,248,6,226,182,84,198,111,140,11,236,60,175,222,150,26,21,68,91,207,241,219,231,136,72,235,18,187,232,171,15,122,189,145,238,29,100,48,110,21,199,78,227,8,11,187,238,161,104,157,117,47,177,232,60,89,26,135,24,58,95,218,186,28,50,248,118,211,12,113,116,241,112,
5,122,86,227,24,67,191,163,253,245,89,164,103,117,161,57,11,61,163,113,144,161,207,105,255,209,226,164,0,125,171,155,134,158,210,56,202,150,255,201,10,107,205,225,65,229,129,179,81,126,6,21,109,107,79,225,114,54,132,186,155,222,106,137,206,187,26,167,25,42,31,95,105,150,49,119,116,161,51,51,149,33,54,207,234,222,206,111,209,49,163,139,53,7,122,86,227,68,91,93,165,71,216,228,232,210,161,28,69,108,95,41,138,116,221,219,94,114,189,89,166,145,73,62,169,245,61,203,237,46,148,143,29,142,208,66,194,187,184,6,149,121,84,31,114,82,50,122,195,149,245,224,152,108,62,129,206,188,55,101,30,200,124,154,158,108,48,47,110,24,203,95,92,134,142,205,191,91,74,164,186,103,217,158,235,32,2,169,204,111,125,186,154,155,15,74,141,52,186,156,196,222,207,100,45,177,107,103,133,177,233,146,44,231,115,167,184,159,159,82,69,34,154,214,55,11,181,123,76,232,132,19,164,183,218,231,71,7,14,203,225,232,194,94,242,53,9,181,184,147,195,43,231,172,110,20,209,182,117,224,224,155,115,126,220,45,86,167,208,200,226,
161,115,170,84,129,190,98,53,167,250,114,86,135,112,226,50,107,191,236,60,223,121,143,183,142,210,154,198,91,231,10,104,104,188,117,94,28,241,214,57,149,238,228,57,183,43,46,187,28,120,86,68,94,41,62,196,246,107,86,32,163,183,26,121,252,119,116,175,111,193,93,104,59,109,238,62,174,182,2,211,217,168,204,226,203,51,172,186,33,103,161,238,224,209,163,187,182,133,37,133,214,12,42,50,26,207,158,93,68,94,195,89,47,207,160,253,173,198,195,71,158,175,241,240,185,1,176,138,203,178,174,20,231,83,44,182,78,62,98,62,104,111,152,122,214,88,65,254,252,51,181,174,113,245,81,44,174,190,246,135,153,242,129,124,235,11,26,151,159,169,121,186,116,148,195,235,103,73,87,74,106,25,199,159,107,122,196,205,55,167,183,189,84,231,229,214,100,91,189,208,4,0,19,2,0,222,183,212,102,99,129,222,229,77,85,212,132,1,220,81,3,189,94,117,240,182,145,176,180,174,86,228,96,118,187,223,109,213,51,196,3,147,174,172,245,172,222,244,28,252,99,212,13,54,153,209,214,105,138,216,128,190,154,222,238,230,252,151,178,109,247,
184,135,183,153,68,247,101,170,152,220,134,138,56,65,123,94,182,212,90,98,143,203,114,103,149,27,14,81,3,83,89,150,183,214,221,91,230,192,112,31,5,169,114,117,1,243,238,149,89,89,119,111,9,234,93,221,25,164,202,251,115,240,62,76,120,11,79,19,222,86,39,93,222,191,15,239,82,66,221,126,50,105,169,12,167,78,171,195,124,249,217,22,235,130,220,181,251,68,29,108,193,156,75,171,252,66,168,89,237,62,95,96,169,29,93,219,153,71,210,188,46,23,214,161,231,180,91,156,39,42,145,103,193,21,11,11,207,160,114,247,238,101,225,206,107,213,91,72,244,150,43,34,5,235,138,179,68,45,200,206,187,204,174,124,112,144,112,119,130,148,123,184,138,41,179,201,117,220,216,132,202,220,121,45,247,242,216,250,56,161,182,55,153,76,74,132,215,187,105,183,180,97,229,214,132,23,125,245,100,7,234,106,65,86,164,92,181,212,110,223,113,171,178,201,75,9,181,246,132,37,207,104,175,157,99,12,150,151,86,173,140,178,204,36,165,59,61,199,45,229,101,117,147,121,23,133,234,232,86,199,113,119,114,88,1,149,89,151,100,197,178,194,
174,14,114,238,139,53,187,22,197,167,173,166,124,211,8,221,73,51,187,167,137,132,221,199,157,166,168,98,241,14,115,12,91,75,230,161,150,16,230,104,143,231,48,177,252,96,19,25,172,69,99,129,120,235,151,41,186,123,235,214,182,214,189,196,102,223,23,238,148,118,247,167,220,199,43,173,158,200,206,200,29,234,50,3,217,196,114,75,230,205,27,122,146,114,213,34,26,31,36,212,222,170,187,159,22,94,77,204,198,129,101,167,208,119,36,243,19,211,28,34,56,206,238,124,178,70,201,62,65,61,152,158,87,246,137,51,80,91,147,225,132,118,218,107,57,110,69,78,24,107,113,32,123,125,95,187,79,115,68,123,88,94,116,213,58,1,159,246,58,67,245,215,243,196,124,208,214,149,122,168,9,251,152,69,71,247,252,92,125,205,97,63,70,56,31,105,116,102,234,234,13,193,159,246,154,185,218,198,5,135,40,165,9,2,25,86,209,193,153,115,176,187,200,151,198,176,147,251,88,157,58,192,43,171,238,166,137,6,25,137,231,144,38,32,212,73,64,232,212,91,15,81,208,144,243,73,88,136,211,118,162,213,137,67,100,56,25,138,5,143,53,193,225,132,
224,16,191,50,221,244,230,144,246,177,169,190,210,245,214,43,130,68,216,9,18,221,58,79,33,111,52,161,34,6,102,181,13,21,145,42,161,162,182,161,34,173,101,77,168,40,39,74,241,85,187,234,29,43,145,226,68,205,208,37,65,163,248,63,222,238,249,86,55,135,243,115,174,11,137,7,158,222,82,175,10,8,41,86,83,222,222,144,143,57,151,92,147,181,116,169,50,230,58,203,136,171,224,239,57,47,218,31,39,47,248,89,119,157,231,101,121,171,9,48,211,250,69,183,198,45,251,185,116,180,186,60,5,3,251,218,162,177,165,94,137,91,227,53,156,66,45,224,166,116,136,171,244,150,247,241,168,153,230,62,225,133,218,27,17,138,162,160,184,161,238,105,162,81,174,67,87,31,141,82,27,120,9,158,234,200,163,186,229,49,225,123,240,236,37,119,116,55,75,112,138,230,126,65,61,208,171,42,165,112,135,200,111,16,159,178,119,242,217,14,181,223,73,109,184,114,94,242,27,106,15,207,232,46,236,99,222,153,12,129,42,114,86,138,44,2,177,42,10,222,227,214,230,203,92,4,73,184,186,167,43,129,156,225,161,238,179,228,73,44,210,26,7,167,206,
1,10,241,2,241,52,245,225,145,51,57,96,202,196,178,236,208,201,33,63,235,108,97,159,27,214,245,211,56,76,92,41,167,114,74,235,47,197,63,242,57,68,51,135,254,28,212,225,33,203,115,64,252,121,192,18,84,123,111,42,221,44,66,103,3,245,86,92,250,158,159,41,123,85,116,255,150,83,37,222,73,3,63,218,33,20,70,203,124,85,85,137,134,117,18,13,167,234,213,251,120,220,235,117,245,132,152,88,19,19,19,129,164,137,79,28,119,183,203,78,63,214,196,198,196,39,29,125,58,116,42,174,196,39,203,21,181,131,207,46,241,137,175,15,235,14,65,50,18,150,14,213,42,113,50,31,34,113,178,83,194,213,12,84,151,16,109,158,205,75,145,64,74,62,181,151,78,175,55,170,244,101,133,157,178,248,156,60,169,65,138,99,179,207,97,173,18,202,237,176,30,251,234,49,17,53,241,91,102,191,55,38,56,195,159,199,113,218,103,186,68,216,140,60,209,129,159,170,120,119,177,202,169,210,42,119,83,94,119,150,245,93,10,212,139,228,54,247,210,196,220,108,135,196,220,34,167,204,115,227,178,101,149,94,170,139,162,178,68,131,68,224,235,226,152,
87,143,114,196,225,136,205,104,27,135,35,118,81,19,135,67,250,65,111,13,229,84,143,8,199,53,225,56,164,103,114,204,10,93,199,6,229,16,240,101,121,175,125,241,248,136,94,95,103,138,199,75,156,9,79,23,252,12,22,164,112,122,23,56,254,29,249,24,154,94,106,107,56,47,219,72,168,206,152,76,226,186,108,248,69,124,135,103,250,240,244,254,126,127,150,177,238,190,236,247,48,67,60,140,121,189,83,12,200,106,150,138,64,158,125,223,147,69,43,31,231,8,231,57,156,68,117,196,165,253,44,65,189,248,18,60,254,186,124,38,147,229,11,149,224,62,83,25,36,30,74,89,125,210,205,94,186,218,203,72,200,34,129,190,86,95,164,182,146,85,159,111,42,37,78,8,17,63,18,137,248,55,244,103,135,142,4,253,168,187,243,217,63,137,251,115,63,75,220,79,245,49,179,240,127,140,251,255,107,38,245,159,254,50,149,138,108,236,127,69,236,31,17,251,95,217,216,63,178,177,255,149,141,253,35,98,255,43,98,255,200,198,254,87,196,254,17,177,63,164,119,17,177,255,21,177,127,68,236,15,183,196,254,145,45,127,32,73,202,31,17,229,15,24,250,
17,73,151,43,114,105,17,193,188,48,70,148,63,174,40,127,68,1,127,41,127,68,182,252,1,203,94,68,104,14,73,202,31,145,45,127,92,217,136,60,34,34,191,34,34,143,108,249,131,225,110,68,58,13,210,113,68,12,126,69,12,30,81,254,128,91,202,31,145,45,127,32,105,24,17,119,95,17,119,71,148,63,208,224,71,68,220,208,71,17,225,54,116,41,127,68,196,218,8,88,96,174,82,254,96,110,65,68,249,3,146,138,136,174,145,249,62,34,180,134,91,202,31,145,45,127,32,171,73,68,29,217,242,199,21,229,15,52,204,67,125,29,81,254,64,131,148,63,34,162,104,134,231,34,91,254,96,49,188,136,242,7,36,63,34,110,70,226,59,22,39,15,119,128,123,31,217,242,7,178,154,17,129,50,178,148,232,179,229,15,120,95,71,148,63,160,74,249,3,170,148,63,160,218,242,7,99,165,252,193,216,205,136,112,86,184,34,202,31,34,57,34,132,133,46,33,108,68,249,3,82,58,146,242,199,149,148,63,162,105,249,131,73,75,249,35,162,252,193,22,141,17,39,229,15,134,117,35,202,31,244,186,17,177,36,19,240,35,202,31,176,140,34,202,31,136,144,242,71,100,203,31,180,164,
252,17,121,173,117,24,211,17,177,34,140,169,136,88,145,118,38,178,177,34,164,229,136,88,17,146,148,63,34,98,68,6,110,99,210,79,252,29,70,126,227,2,181,231,145,223,150,191,223,68,148,63,152,77,46,34,234,163,237,68,148,63,104,231,35,162,61,218,51,17,209,158,237,223,93,163,157,141,136,242,104,223,137,40,127,208,206,68,68,119,180,231,34,202,31,180,83,17,81,157,237,127,178,66,27,121,7,91,180,145,183,246,148,54,219,187,187,68,251,110,68,36,103,219,165,135,83,126,209,63,27,81,254,160,157,141,136,220,104,35,175,180,77,27,251,86,138,180,145,183,189,74,155,205,92,223,179,253,137,62,250,23,197,62,236,169,74,191,19,17,157,209,198,222,77,177,135,254,167,139,182,191,40,243,67,255,239,150,108,191,43,246,96,223,250,116,190,155,210,143,254,207,166,246,239,172,216,254,231,178,203,232,223,145,126,228,217,242,7,180,17,59,242,152,45,60,136,8,177,88,118,21,17,92,77,183,48,199,154,75,249,35,178,229,15,184,107,17,94,9,119,66,35,34,160,226,75,150,128,138,173,147,242,7,99,164,252,17,217,242,135,61,20,
117,185,3,222,112,40,30,209,219,137,8,150,144,40,229,143,200,150,63,144,244,54,34,56,130,219,143,8,142,174,8,142,34,130,35,232,65,114,116,146,242,7,99,62,68,148,63,144,177,23,17,19,33,83,98,162,200,150,63,176,170,31,17,8,49,47,41,127,240,129,141,56,248,115,145,45,127,92,17,253,68,148,63,32,113,214,7,179,28,240,87,156,253,5,184,165,252,17,217,242,199,21,229,143,136,64,7,89,131,136,16,135,118,39,162,252,1,215,73,68,249,3,186,132,53,145,45,127,136,254,136,242,7,178,155,17,229,15,218,195,136,242,7,109,15,39,59,178,229,15,86,71,202,31,145,45,127,48,51,41,127,68,182,252,65,223,48,162,252,113,69,249,35,162,252,193,72,41,127,176,42,82,254,144,217,51,79,177,166,137,227,31,217,242,7,90,70,104,201,195,43,229,143,72,37,229,15,36,5,17,229,15,36,73,249,131,91,85,202,31,240,74,249,35,178,229,15,228,140,185,78,23,225,105,71,184,210,172,65,45,194,121,102,118,195,233,172,153,157,124,154,82,254,96,172,148,63,34,91,254,160,213,140,240,131,147,21,161,252,129,172,17,55,77,154,177,82,254,136,108,249,
3,174,74,68,249,131,85,238,112,97,223,71,67,31,229,114,167,54,241,118,35,91,254,64,70,59,194,207,229,238,28,68,56,185,87,148,63,34,60,220,43,60,220,228,190,150,242,7,203,159,134,65,202,31,92,159,114,138,179,145,245,105,25,46,62,109,100,125,90,90,203,17,62,45,12,19,110,145,246,12,4,241,100,35,41,127,200,28,184,86,165,252,193,79,41,127,68,182,252,1,183,148,63,34,202,31,172,198,219,136,242,7,12,63,69,182,252,193,49,100,59,250,79,57,104,110,68,249,131,46,31,35,238,65,239,70,120,152,140,150,242,7,15,153,148,63,174,112,47,177,246,65,178,153,148,63,152,108,135,27,243,46,92,8,102,121,41,127,68,184,148,72,121,143,49,247,145,154,148,63,34,91,254,96,173,228,53,144,251,93,202,31,211,203,149,171,159,242,7,180,115,68,75,249,3,169,237,8,159,15,146,148,63,34,91,254,224,145,144,242,71,132,171,199,43,151,230,225,147,242,7,15,95,39,162,252,1,169,207,11,41,15,95,16,225,217,193,45,229,15,206,128,148,63,144,36,229,143,233,195,123,17,73,249,3,219,106,66,192,57,67,225,73,68,249,3,97,131,136,242,7,236,
138,71,121,192,52,196,21,131,75,202,31,112,73,249,35,194,237,226,103,38,178,110,23,99,22,35,220,46,72,73,249,35,194,223,226,55,108,73,249,131,159,65,132,155,197,10,241,1,189,126,36,159,189,92,25,182,252,129,13,226,83,193,32,229,15,250,106,17,14,20,78,197,69,132,215,196,71,193,235,242,69,62,57,240,120,74,92,10,82,254,224,235,145,242,7,198,125,138,40,127,136,98,110,144,47,164,59,136,112,134,96,151,242,71,36,158,16,34,126,45,127,228,254,225,159,119,131,254,91,58,245,159,255,242,223,255,135,84,92,58,124,115,77,134,45,118,251,31,202,167,51,215,20,40,226,202,233,252,117,89,29,19,12,196,20,38,174,9,233,98,170,18,215,84,37,226,157,195,11,170,17,215,59,106,20,83,138,128,52,138,43,189,60,44,82,135,136,41,66,48,240,110,236,118,127,143,160,20,237,33,237,15,113,181,89,132,101,114,47,166,208,112,93,87,147,124,76,97,1,142,143,113,165,80,188,174,168,201,221,248,176,188,125,125,200,155,28,151,10,67,236,249,20,215,55,138,194,138,208,174,66,200,100,38,166,20,0,239,69,92,173,36,210,242,241,126,201,
197,130,201,114,92,44,110,94,23,213,36,23,215,90,135,215,53,53,97,54,245,50,242,39,247,99,242,247,140,62,143,43,170,38,138,156,184,218,240,177,229,239,227,253,234,152,193,119,226,74,61,160,99,62,174,30,189,33,25,79,215,133,204,179,214,24,34,104,62,38,241,142,21,75,177,187,51,66,30,109,183,79,59,31,147,114,167,223,137,247,27,239,201,182,35,72,178,237,49,217,118,100,229,226,106,253,156,60,187,172,10,169,132,184,210,184,128,154,134,250,37,164,92,188,127,244,21,3,178,113,237,240,2,25,185,152,20,58,51,70,102,146,66,135,244,85,76,254,28,22,242,231,185,216,38,207,17,32,201,243,152,228,121,178,178,36,207,153,49,99,15,142,25,59,23,187,237,55,208,179,113,185,37,43,206,168,142,232,156,141,73,149,95,111,169,229,184,242,98,148,180,203,181,87,244,207,196,174,26,192,127,47,46,53,190,100,188,19,23,15,78,145,55,23,151,54,206,105,231,226,194,222,197,53,137,202,184,72,206,149,156,182,172,174,138,73,99,95,219,52,118,188,81,191,184,38,135,29,111,169,183,133,147,60,42,36,123,29,23,123,23,112,166,227,
210,224,219,245,134,131,160,115,82,128,113,169,254,218,234,56,20,155,179,113,161,121,138,236,108,188,213,29,51,48,23,111,148,207,145,53,19,111,97,59,105,227,184,208,57,167,127,38,46,214,222,194,239,112,66,63,144,6,70,196,32,38,241,139,217,95,145,244,136,55,220,239,24,197,25,83,99,247,236,14,147,26,51,153,52,189,67,89,143,226,254,5,73,88,134,75,18,54,222,106,95,32,217,97,86,35,59,171,157,33,93,249,120,235,64,44,152,137,11,141,87,208,243,113,177,42,246,47,196,207,119,254,92,187,126,174,254,29,74,222,160,36,19,111,177,133,98,106,161,221,135,241,78,188,81,249,10,58,83,224,240,16,150,196,133,214,39,232,78,188,94,254,211,15,215,235,106,50,138,159,53,138,215,207,212,100,62,38,173,137,113,223,197,165,163,6,83,224,0,110,123,91,215,219,114,52,55,97,217,148,83,187,94,45,202,160,123,136,27,32,110,54,222,244,190,165,39,21,111,157,142,182,187,178,186,99,82,144,113,241,232,156,164,35,6,74,210,49,46,55,92,228,242,37,237,45,51,233,92,92,174,174,209,190,67,123,137,246,221,184,188,191,110,251,11,
79,105,207,210,222,176,237,237,85,218,216,245,108,203,182,215,62,167,157,143,73,40,210,206,198,238,243,117,219,95,144,241,185,216,45,62,161,141,190,194,51,218,156,192,61,225,71,95,69,248,209,199,183,71,226,138,121,30,216,254,195,45,218,156,196,198,166,29,191,247,204,182,219,210,230,228,149,54,236,248,154,180,145,87,151,241,98,255,148,191,42,250,105,39,253,232,47,137,189,180,203,98,15,252,37,233,199,222,226,212,190,157,233,124,160,39,246,190,88,163,159,249,21,63,183,237,164,31,254,93,89,31,230,247,139,125,106,170,255,96,106,127,67,248,101,126,83,253,173,85,218,169,152,212,30,242,152,223,177,200,231,102,193,14,210,119,124,105,50,158,126,228,36,237,36,157,7,105,35,225,62,18,110,209,54,149,150,172,22,237,3,177,22,107,106,211,221,170,200,110,201,41,145,213,189,31,187,79,21,237,73,42,86,127,61,190,86,242,163,190,118,206,141,243,49,38,17,199,213,112,17,31,236,126,186,38,229,22,87,119,71,220,38,127,136,235,173,49,253,31,98,117,162,24,240,247,113,211,251,187,107,146,104,208,39,114,215,
166,99,164,52,232,153,197,210,119,200,230,254,172,75,34,140,193,231,113,225,116,150,211,37,89,48,206,190,124,19,179,113,137,155,77,110,4,210,94,215,47,248,251,188,124,74,174,139,175,129,92,23,95,54,247,70,114,95,180,229,91,230,224,215,2,14,254,66,76,126,11,65,78,188,177,55,89,225,203,248,24,111,212,198,252,117,232,56,166,131,47,135,143,157,236,85,188,170,58,220,33,204,107,195,21,198,201,227,184,184,83,65,212,100,49,46,239,189,34,23,197,50,156,38,47,79,235,156,28,20,86,142,99,18,80,76,121,76,226,41,174,15,191,118,125,135,121,145,58,78,197,237,110,202,245,171,76,42,23,147,123,186,230,129,141,109,238,9,6,201,61,197,228,158,24,201,229,158,228,158,16,54,205,61,197,73,238,105,254,154,88,69,246,176,236,145,248,151,13,248,109,140,75,2,181,193,51,33,153,168,235,219,76,84,124,155,137,186,190,205,68,197,184,39,215,184,39,113,146,137,186,127,77,6,70,172,114,119,83,199,190,139,85,143,99,156,22,168,157,216,230,165,224,149,188,84,140,235,114,77,94,42,182,121,41,228,77,243,82,241,109,94,10,189,
25,210,0,100,165,226,82,187,67,130,138,69,151,236,84,92,126,57,174,208,178,121,169,216,38,165,152,214,69,76,82,138,23,227,156,135,122,204,235,204,51,215,77,211,126,27,87,188,123,244,159,240,138,206,242,0,156,36,55,134,247,129,100,19,246,141,121,187,29,100,125,36,199,196,251,55,25,147,73,130,121,82,38,127,196,134,77,246,216,177,113,92,60,254,170,224,63,96,139,36,63,20,111,13,167,27,237,23,217,190,90,188,223,63,68,207,29,86,248,148,161,89,222,89,121,104,48,244,56,64,50,174,64,255,91,146,61,40,227,9,30,136,178,191,129,53,3,203,164,19,147,218,97,204,112,75,142,195,103,135,127,86,215,255,52,143,99,241,27,255,247,60,206,127,207,164,140,205,225,220,144,195,49,228,112,110,108,14,199,216,28,206,141,205,225,24,114,56,55,228,112,140,205,225,220,144,195,49,228,112,32,189,51,196,235,55,36,39,12,57,28,184,37,135,99,110,241,27,8,19,252,134,1,191,113,67,58,199,88,252,198,13,238,145,1,191,193,48,193,111,24,240,27,55,28,86,131,155,116,131,3,192,113,50,120,74,55,120,16,198,226,55,144,11,105,148,
191,1,191,97,44,126,131,222,145,1,191,113,115,139,223,48,65,130,223,184,97,189,12,248,141,27,60,102,206,145,177,248,13,168,121,3,126,227,134,92,184,177,248,13,24,166,248,13,115,139,223,96,17,166,248,13,67,182,232,134,108,145,177,248,13,76,78,25,240,27,168,115,141,197,111,208,43,248,13,67,238,232,134,220,145,177,248,141,155,91,252,134,185,197,111,160,73,240,27,134,60,210,13,121,36,99,241,27,152,34,248,13,67,54,9,134,161,177,248,13,24,166,248,13,67,78,9,193,11,172,189,224,55,88,161,180,33,183,196,154,7,198,226,55,232,21,252,134,33,195,132,218,115,99,241,27,72,152,226,55,204,45,126,3,93,83,252,134,185,197,111,220,88,252,6,214,204,211,253,218,88,252,6,166,76,241,27,134,204,19,98,115,6,231,27,255,143,21,116,88,168,121,54,205,51,22,191,65,175,224,55,12,121,40,148,126,105,44,126,3,9,83,252,134,185,197,111,160,75,240,27,198,226,55,100,19,44,126,195,220,226,55,216,120,199,128,223,64,144,224,55,140,197,111,192,57,197,111,48,73,193,111,176,65,75,198,226,55,224,20,252,134,193,153,132,154,
55,56,147,55,56,147,6,252,6,231,37,109,240,40,57,36,226,81,26,60,74,150,47,103,168,95,220,226,55,80,56,197,111,24,139,223,64,151,224,55,140,197,111,48,11,193,111,24,139,223,192,126,73,126,25,240,27,200,204,26,240,27,48,164,13,248,13,116,230,12,206,231,13,206,167,177,206,39,36,193,111,24,252,79,184,5,191,97,110,241,27,216,33,46,168,193,5,77,206,20,46,232,13,46,168,177,248,13,54,183,137,91,98,192,111,176,206,130,223,48,22,191,193,234,231,12,248,13,102,38,248,13,86,86,240,27,55,224,55,16,45,248,13,44,20,252,134,177,248,13,228,8,126,195,112,106,201,185,33,74,240,27,198,226,55,68,4,87,162,177,248,13,62,203,41,126,195,88,252,6,243,152,49,22,191,65,223,20,191,97,44,126,3,65,105,67,78,46,249,30,201,201,209,206,24,155,147,131,180,108,200,201,65,90,54,248,186,76,42,32,55,103,200,205,33,102,155,149,18,252,198,141,117,124,13,248,13,17,142,239,107,184,37,45,126,131,25,76,241,27,198,226,55,16,145,54,224,55,232,248,96,44,126,3,227,4,191,97,200,228,9,187,1,191,113,131,115,108,192,111,176,125,
121,67,70,15,58,95,218,250,3,218,240,237,166,25,226,24,240,27,208,179,134,204,30,244,59,6,252,6,210,179,6,252,6,244,140,33,195,7,125,206,128,223,184,193,169,54,224,55,160,167,12,153,62,203,255,100,133,181,22,252,134,177,248,13,168,104,91,123,10,151,224,55,140,197,111,64,189,107,200,250,65,205,161,107,150,49,119,12,248,141,169,12,177,121,214,128,223,64,199,140,1,191,1,61,107,200,2,90,93,165,71,216,228,24,240,27,208,177,125,165,40,210,141,197,111,48,13,193,111,96,249,158,229,78,240,27,28,33,193,111,24,50,131,80,153,71,245,33,39,37,99,192,111,32,131,99,178,249,4,58,243,222,148,121,192,247,52,125,131,187,111,64,8,88,254,226,50,116,108,254,221,82,34,213,226,55,16,33,248,13,116,77,87,51,193,111,160,75,240,27,134,172,33,188,216,181,179,194,88,138,118,44,103,130,223,152,82,69,34,154,18,252,6,19,146,208,193,88,252,6,203,225,24,240,27,48,242,10,230,140,197,111,112,86,5,191,97,44,126,131,243,35,248,13,99,241,27,156,42,193,111,24,139,223,224,200,76,241,27,230,22,191,129,172,154,33,221,200,
21,208,48,164,27,121,113,70,164,27,57,149,238,13,248,13,67,206,81,14,60,43,34,175,20,31,98,251,53,43,144,49,22,191,129,110,193,111,24,139,223,128,65,240,27,198,226,55,24,38,248,13,99,241,27,232,22,252,134,1,191,129,138,140,33,53,201,46,34,47,193,111,160,253,173,33,69,137,60,223,144,162,228,6,192,42,46,203,91,252,134,177,248,13,196,124,48,22,191,129,124,193,111,24,114,149,40,14,200,85,26,139,223,144,229,55,224,55,152,154,103,44,126,131,37,157,226,55,184,166,71,220,124,115,198,226,55,110,192,111,152,254,171,149,27,50,152,188,111,130,223,160,87,240,27,134,60,38,119,212,192,88,252,6,18,166,248,13,115,139,223,184,177,248,13,99,241,27,168,27,16,46,25,139,223,160,175,102,44,126,131,109,155,226,55,140,197,111,192,41,137,78,99,241,27,236,177,132,82,198,226,55,152,138,224,55,12,1,21,7,134,251,40,193,111,96,158,224,55,160,46,65,189,107,44,126,3,94,193,111,24,183,240,52,225,181,248,13,120,5,191,97,220,237,39,55,22,191,97,44,126,131,117,129,154,224,55,216,2,193,111,24,194,45,168,89,3,126,
131,165,118,12,248,13,36,205,27,240,27,208,115,198,226,55,228,89,32,248,130,250,12,42,119,239,94,22,238,188,1,191,145,232,37,8,131,142,117,9,126,3,217,130,223,48,132,98,9,183,197,111,96,138,224,55,152,229,38,84,230,158,224,55,176,85,240,27,56,25,155,76,70,240,27,28,12,193,111,88,185,53,225,69,95,130,223,64,165,224,55,12,33,90,66,181,248,13,214,82,240,27,166,92,123,194,146,103,12,248,13,122,177,188,180,106,101,148,101,38,41,99,241,27,178,186,201,188,139,66,117,140,197,111,96,133,224,55,12,248,13,204,20,252,134,177,248,13,187,22,9,126,195,10,221,73,51,59,193,111,152,114,130,223,128,202,226,29,230,24,38,248,13,238,133,37,132,57,6,252,70,34,223,61,216,68,6,107,145,224,55,126,153,34,193,157,181,173,117,47,177,25,252,6,220,41,67,144,103,185,19,252,6,36,193,111,24,66,61,168,14,15,153,204,155,55,52,193,111,160,81,240,27,166,156,4,124,194,107,72,58,115,96,5,191,97,192,111,64,18,211,4,191,193,217,21,252,134,177,251,4,53,193,111,176,114,130,223,96,229,214,100,56,185,105,99,241,27,104,99,
45,14,100,175,239,27,139,223,192,242,41,126,195,220,226,55,160,9,126,195,144,183,102,22,29,99,241,27,72,29,225,124,164,209,57,197,111,24,139,223,224,16,165,12,248,13,134,85,140,197,111,240,165,49,236,228,62,86,11,126,195,88,252,6,35,167,248,13,115,139,223,64,129,224,55,12,121,109,156,182,19,99,241,27,55,22,191,97,200,110,223,144,221,198,175,20,252,6,210,4,191,97,44,126,3,246,41,126,131,91,78,240,27,24,152,53,54,215,141,84,201,117,27,155,235,166,181,108,200,117,203,137,34,80,229,237,127,199,74,164,56,81,51,116,73,214,91,252,31,139,223,192,249,57,55,224,55,152,204,20,191,193,21,43,248,13,62,102,193,111,152,163,4,191,193,117,38,248,13,99,241,27,55,192,52,240,182,4,191,129,14,193,111,24,98,90,110,89,193,111,24,139,223,176,175,45,26,45,126,195,88,252,6,55,165,224,55,140,197,111,112,159,240,66,37,248,13,20,8,126,195,144,78,231,58,116,141,197,111,96,149,224,55,96,23,252,6,60,130,223,48,133,4,191,129,230,62,17,176,177,248,13,214,90,240,27,236,221,3,14,246,208,88,252,6,84,193,111,224,
25,221,133,125,204,59,35,248,13,228,8,126,195,144,108,71,193,123,220,90,193,111,160,150,124,251,158,33,102,230,188,12,13,248,13,27,139,252,130,223,96,169,4,191,97,8,159,111,192,111,112,255,230,217,33,193,111,24,240,27,28,129,129,177,248,13,190,111,193,111,24,98,104,132,250,28,34,193,111,64,149,24,218,16,67,51,124,222,216,24,26,161,211,24,26,211,5,191,129,238,223,114,170,196,59,105,224,71,75,212,140,150,41,126,195,220,70,205,120,220,83,252,134,33,106,38,2,73,19,159,8,126,131,157,126,108,136,147,137,79,58,198,198,201,244,74,156,140,207,46,241,137,111,108,156,140,132,105,156,204,135,56,197,111,160,169,75,136,54,207,230,77,241,27,134,208,214,226,55,48,104,138,223,48,183,248,13,172,191,48,132,202,56,183,130,223,32,126,19,252,6,193,153,99,8,152,161,166,12,37,2,70,158,152,32,193,111,96,149,224,55,8,113,4,191,193,250,78,241,27,198,77,240,27,108,135,20,13,68,14,122,153,202,152,200,78,240,27,172,10,209,224,20,191,65,172,32,248,13,196,102,140,45,36,32,118,209,80,72,128,244,131,33,234,198,
46,193,111,24,234,9,144,4,191,193,161,153,226,55,32,8,126,195,80,88,224,76,16,189,38,248,13,206,132,103,192,111,96,65,10,167,119,129,227,47,241,185,177,248,13,217,70,106,13,140,201,36,174,11,248,13,124,135,103,198,226,55,24,43,248,13,78,65,134,120,56,197,206,158,98,64,214,224,133,83,137,96,223,5,191,97,44,126,131,195,41,248,13,22,89,240,27,226,75,240,248,27,66,122,251,133,254,130,223,16,51,192,111,24,139,223,144,144,69,42,21,198,226,55,16,62,197,111,24,74,22,72,20,252,134,153,226,55,80,55,197,111,252,47,1,0,0,0,255,255,3,0,217,12,151,244);


programfile__CUM_ON_FEEL_THE_NOISE_MID
:array[0..1303] of byte=(
120,1,236,87,221,79,27,71,16,159,108,40,165,180,141,20,201,170,42,229,122,28,9,178,34,144,107,64,46,132,117,101,93,176,40,20,25,140,109,74,233,35,237,89,33,74,50,68,182,65,65,170,28,29,110,165,170,79,109,42,85,234,75,223,250,208,183,124,60,229,173,31,79,253,83,250,87,184,51,187,94,251,28,31,228,64,49,80,181,15,12,227,223,206,206,206,238,254,102,102,111,101,125,219,3,128,65,184,64,127,15,86,214,43,119,232,215,67,104,110,14,12,136,119,135,160,249,153,160,223,205,194,197,193,111,175,64,115,112,40,251,201,74,126,245,163,133,5,210,103,179,59,247,247,43,183,111,109,215,156,95,157,169,185,185,15,156,15,75,59,120,203,185,185,91,219,222,169,56,171,91,247,202,153,183,111,222,189,235,20,217,166,234,20,203,213,114,101,175,236,209,212,43,139,101,44,87,182,106,101,207,249,124,223,89,221,169,149,63,221,169,212,182,247,157,169,247,39,161,153,4,29,198,208,29,104,142,94,160,213,47,14,46,238,222,174,109,85,224,55,27,30,191,254,16,30,15,187,240,221,4,194,52,250,197,105,128,9,176,167,17,230,16,50,
232,59,25,128,57,128,105,136,37,17,102,16,210,216,168,167,1,102,0,146,96,159,96,74,2,33,197,190,37,57,77,1,36,64,156,45,98,54,42,205,62,197,249,64,60,19,79,204,196,115,54,136,186,98,169,72,33,250,161,27,86,73,67,42,17,134,200,36,132,226,154,145,71,207,125,185,205,117,197,201,52,178,31,226,228,117,16,97,136,60,4,103,62,255,187,230,154,140,243,139,38,9,117,38,195,44,229,251,44,39,59,149,128,54,239,26,117,67,69,251,196,19,251,193,156,160,207,48,206,244,222,123,191,89,164,25,194,50,64,9,226,82,7,215,122,239,104,47,114,92,203,19,95,205,137,39,170,152,193,69,233,2,168,196,209,187,62,51,196,212,201,243,82,201,21,63,77,63,29,87,205,213,161,204,26,135,24,85,151,36,181,209,36,151,154,70,61,154,93,119,175,61,212,157,61,137,156,197,69,202,226,73,176,41,45,90,63,168,89,171,139,246,139,170,233,118,123,155,70,143,250,187,57,191,64,203,63,30,116,112,201,20,138,206,147,67,228,204,147,227,205,92,121,203,115,90,239,142,223,223,131,39,244,238,120,50,236,254,226,126,159,66,153,226,148,33,153,9,232,
199,69,26,241,25,58,212,25,104,204,235,255,223,108,164,208,75,129,255,150,250,23,83,114,45,176,202,87,118,183,253,163,122,9,189,18,196,74,120,48,94,2,81,194,61,146,5,180,10,32,242,104,229,89,151,74,151,164,175,162,181,106,112,173,231,208,202,49,46,21,222,177,209,30,122,237,143,139,27,255,188,174,209,121,45,173,47,163,181,12,98,153,110,126,25,252,119,50,72,73,32,84,106,138,44,202,44,136,69,244,99,139,32,50,104,209,192,34,90,164,47,161,181,100,244,5,180,22,88,151,132,231,241,224,82,30,108,109,164,253,106,221,24,241,228,94,61,139,22,173,179,128,155,228,72,143,234,149,231,209,154,7,138,130,71,181,238,162,229,118,116,42,31,20,41,35,58,184,52,90,105,163,27,220,191,79,204,106,63,99,197,85,195,169,129,249,173,106,21,254,184,10,79,137,76,79,135,221,31,221,71,113,244,226,16,139,46,71,80,142,128,136,46,175,161,188,6,34,186,180,80,90,32,250,39,71,233,202,71,193,30,161,206,61,194,251,110,212,227,96,135,130,209,247,168,45,163,239,81,91,246,111,143,218,115,232,166,194,192,0,83,70,12,83,6,115,
244,101,245,69,21,254,188,1,207,136,43,207,134,221,159,31,252,80,66,169,82,156,211,250,104,189,119,84,213,138,181,28,74,74,250,13,244,54,184,110,112,245,48,69,194,119,242,208,184,161,231,173,211,29,173,131,29,52,40,208,125,21,224,192,61,194,160,81,47,80,42,247,174,172,87,232,197,117,193,210,184,142,78,235,253,137,142,195,247,151,242,200,133,78,203,2,110,182,75,101,142,182,151,131,53,83,67,247,212,1,251,78,137,166,152,0,249,232,75,100,166,206,204,43,240,249,49,148,199,61,242,168,231,127,237,25,227,16,51,62,224,131,47,201,67,177,4,118,1,131,30,120,200,95,50,231,196,183,210,190,129,150,181,95,44,4,10,202,27,127,27,154,188,230,85,118,239,85,225,175,203,240,156,88,242,156,62,139,127,26,107,247,208,49,176,233,199,28,197,76,207,230,49,136,169,145,70,157,90,173,30,105,181,218,80,179,143,199,128,62,159,228,68,36,121,121,150,63,173,35,26,71,119,219,101,153,64,47,1,49,45,147,168,95,198,44,19,40,213,55,185,30,181,148,206,50,137,22,141,106,153,192,14,62,129,150,218,20,75,51,151,61,104,159,
116,68,244,84,153,66,111,138,31,62,124,104,113,70,60,210,169,74,171,81,169,112,17,212,255,51,54,231,238,100,198,145,174,67,156,250,249,51,7,226,188,174,213,150,134,57,210,48,135,24,34,41,137,78,61,182,243,204,213,255,249,163,249,16,206,159,41,100,242,16,103,52,115,136,81,113,148,241,87,140,4,125,118,116,181,80,23,159,195,184,125,130,170,216,218,169,206,211,96,205,12,234,42,71,78,213,242,133,221,181,207,249,5,92,133,173,111,132,186,0,71,104,50,186,195,228,151,245,133,83,221,215,217,158,106,132,213,233,220,58,21,210,84,111,34,185,48,12,225,154,249,42,112,221,199,123,215,106,221,99,96,197,206,205,70,136,191,197,129,232,150,65,110,31,166,147,55,53,212,34,213,24,55,23,126,126,208,23,228,63,0,0,0,255,255,3,0,12,22,139,16);


programfile__Classical_MID
:array[0..15049] of byte=(
120,1,116,156,91,108,220,89,158,215,221,221,153,233,102,232,221,94,13,35,24,70,116,122,38,27,28,59,238,120,188,118,28,183,157,82,217,149,74,85,170,171,92,46,219,113,156,216,202,197,137,226,164,147,109,122,122,153,69,42,33,33,181,115,103,95,232,248,146,248,133,23,36,158,144,16,176,11,59,143,92,23,30,16,66,2,30,17,15,160,21,143,60,241,178,15,195,231,251,253,253,78,37,158,89,158,78,157,115,126,247,219,57,231,127,142,221,93,251,226,238,208,208,208,119,135,222,25,250,222,208,255,233,174,253,205,223,165,247,143,135,126,121,237,216,177,119,127,248,193,208,47,87,222,251,222,253,205,161,95,174,125,103,129,241,161,157,255,242,53,35,127,241,253,255,184,227,246,127,254,55,183,31,254,241,180,219,223,248,31,191,237,246,163,119,103,220,254,214,63,188,225,246,251,189,111,220,254,224,63,253,209,243,5,40,191,247,222,73,83,254,75,223,255,207,255,117,2,122,127,245,171,223,125,244,5,45,253,167,203,204,127,55,231,191,243,243,191,242,232,23,63,100,226,59,127,246,223,13,240,221,127,112,203,237,251,191,
247,119,220,126,240,183,79,14,253,242,167,67,33,245,119,254,239,208,47,223,251,78,243,203,191,245,251,219,67,255,242,243,161,127,242,254,141,157,255,189,240,109,123,115,231,235,111,218,11,67,223,174,222,30,249,102,149,118,229,250,200,55,43,234,223,143,126,111,243,163,111,122,244,151,238,127,244,205,18,109,143,214,253,159,183,232,191,247,109,239,122,159,126,255,219,206,118,255,155,14,243,237,245,17,211,107,93,27,249,166,69,191,121,115,228,155,38,109,3,186,13,218,58,253,58,237,5,250,23,212,191,182,236,126,131,113,205,55,161,19,240,253,232,67,79,253,250,229,192,107,223,8,250,237,235,59,103,205,168,183,89,9,129,0,144,128,237,171,1,176,130,0,82,100,229,6,128,250,177,118,163,242,205,26,237,234,173,212,12,4,105,178,142,36,235,158,31,137,121,56,216,18,16,178,37,238,102,127,59,250,189,59,129,215,187,33,205,177,204,205,62,140,251,223,174,222,217,249,33,136,31,188,49,33,132,69,168,187,49,242,77,151,182,3,33,155,40,85,232,108,69,191,139,138,154,239,49,47,130,221,77,36,54,194,253,202,81,4,
8,138,64,11,130,97,219,185,111,219,107,239,98,159,223,8,155,175,125,228,241,246,237,143,162,191,189,243,1,3,239,124,219,220,120,244,133,173,216,94,220,249,107,76,29,251,182,139,114,230,73,43,158,203,144,92,150,12,180,150,225,74,202,188,146,50,99,44,133,73,39,69,232,50,110,17,75,159,121,211,75,252,14,58,90,84,230,37,106,27,247,30,193,191,152,248,56,195,112,216,64,112,133,126,241,98,107,41,198,47,49,127,137,249,75,235,125,183,173,107,196,173,17,54,118,62,134,2,129,8,132,37,95,78,202,41,193,128,18,125,75,130,68,146,164,85,36,195,11,150,12,9,237,29,220,235,62,173,250,93,240,164,89,115,53,2,113,21,62,242,106,143,248,50,191,180,100,231,65,226,35,161,233,95,235,155,95,147,190,2,184,189,158,1,187,184,114,252,155,69,17,166,21,225,197,107,155,238,247,174,31,55,193,165,205,205,200,180,141,232,175,92,249,200,113,216,187,26,153,183,178,145,253,237,79,129,127,231,219,165,235,153,153,91,57,191,25,113,218,78,151,173,225,42,197,253,250,218,247,34,206,111,127,47,250,219,217,127,176,115,138,129,
247,190,93,189,249,131,8,252,219,63,136,192,199,34,214,52,45,187,142,111,157,40,88,206,137,68,223,137,146,137,177,138,165,220,135,161,18,167,71,12,201,66,81,34,72,20,74,133,18,165,125,115,231,19,76,244,206,183,61,36,21,192,10,129,239,76,195,148,38,64,80,188,157,121,173,13,162,182,69,212,46,97,115,23,33,124,102,196,204,241,94,233,227,51,33,54,175,134,205,91,216,94,62,111,108,68,49,169,95,223,116,177,233,221,8,211,174,34,128,25,34,169,37,70,3,251,20,13,29,205,189,232,119,16,204,177,81,36,95,68,117,249,112,9,134,22,40,77,52,208,228,94,16,110,221,216,180,0,107,87,143,135,205,215,63,10,19,226,67,251,100,59,251,15,178,79,181,181,137,183,183,153,63,70,21,62,30,2,110,29,183,128,197,5,171,15,131,126,15,75,73,224,213,7,253,128,163,38,89,145,235,36,124,111,225,234,160,250,127,255,127,81,253,191,219,187,243,179,237,31,255,206,208,191,186,56,244,79,223,127,48,244,146,144,252,122,135,88,125,217,234,244,119,176,211,203,230,237,202,14,177,250,178,177,85,217,161,24,191,233,223,201,254,86,159,
249,254,203,218,181,254,78,141,249,58,240,20,243,151,141,235,57,79,107,252,171,209,111,220,207,241,187,49,222,130,174,249,100,191,249,101,194,23,184,223,11,250,221,91,253,29,236,255,178,190,209,55,253,222,118,127,7,53,95,54,110,37,61,224,197,167,5,29,211,67,62,245,155,201,191,117,37,198,219,180,214,15,57,5,87,224,219,15,99,188,3,62,126,125,217,190,23,253,246,70,180,221,205,138,249,175,194,151,248,120,57,128,187,153,244,144,195,124,151,83,126,248,200,94,117,240,101,143,218,21,217,167,255,178,139,189,164,71,151,106,229,31,181,197,48,92,119,51,39,174,231,68,11,77,69,177,139,101,141,129,38,106,123,88,82,154,119,225,168,126,7,11,90,226,27,41,9,173,240,218,192,73,211,38,243,246,0,154,89,34,232,216,67,151,179,223,75,9,211,131,221,155,59,103,131,17,162,155,17,166,50,163,98,154,187,125,19,238,177,140,26,96,5,78,132,216,75,214,221,64,216,14,132,69,116,37,37,94,174,176,48,27,96,245,90,197,198,91,193,104,70,128,178,57,160,170,56,172,62,12,227,174,222,140,182,121,21,68,201,222,94,79,221,104,
109,101,56,104,124,69,86,52,165,27,17,14,221,194,154,86,172,187,200,44,202,139,184,211,125,224,186,184,161,69,56,217,72,24,81,70,90,196,104,49,159,240,72,166,254,34,248,30,47,198,167,181,196,132,155,232,254,26,191,251,73,31,62,166,159,97,181,8,188,233,224,12,203,147,116,7,227,41,119,15,203,152,126,246,187,201,167,71,56,107,124,133,214,250,50,174,126,129,111,34,255,17,39,67,199,78,126,208,15,167,195,207,97,8,158,211,244,62,134,243,192,239,241,163,182,176,243,53,222,59,30,172,105,37,226,160,191,177,74,255,131,151,139,87,143,135,10,119,98,126,121,189,191,195,254,224,37,21,213,170,94,98,143,178,195,130,252,178,69,220,88,247,116,218,37,188,238,241,116,94,27,219,58,5,145,81,112,151,128,247,252,90,244,123,232,98,27,144,74,18,164,67,120,41,192,187,224,171,223,198,7,194,47,129,223,133,142,225,208,209,137,0,158,233,131,39,250,131,132,41,54,6,78,244,151,31,84,172,64,47,109,185,204,184,20,234,21,31,167,175,58,36,138,233,22,185,87,83,110,98,199,114,3,103,61,160,163,126,3,58,78,180,171,89,
170,174,71,108,246,238,96,106,49,174,51,32,219,247,8,123,59,49,38,42,47,151,209,220,18,32,169,45,144,18,15,138,13,28,172,57,227,146,168,20,181,46,22,180,5,208,200,150,34,74,108,41,198,5,207,114,107,122,107,20,47,214,152,151,171,55,142,59,15,151,111,109,6,191,155,233,250,27,155,65,103,11,87,154,16,38,52,161,135,136,110,206,100,168,38,74,220,93,194,39,182,65,230,83,215,249,37,223,20,10,69,148,187,73,161,117,147,31,173,133,202,203,30,102,179,146,165,142,161,156,72,183,73,33,187,143,106,34,179,54,73,93,133,54,199,137,156,79,247,2,175,249,65,56,1,231,62,116,133,95,86,174,238,141,71,95,88,137,69,100,85,14,150,248,41,253,22,5,80,136,37,238,154,15,179,234,52,112,199,219,53,188,129,114,234,119,57,164,5,69,34,219,20,127,165,138,180,50,178,87,105,181,88,52,85,82,157,158,56,196,20,9,37,167,39,133,78,253,142,34,192,202,99,46,43,15,128,149,193,1,86,134,152,18,129,178,12,93,84,237,189,200,64,125,37,19,27,68,39,54,203,136,40,119,36,163,41,162,181,41,34,163,41,46,102,31,217,221,207,249,178,80,
54,202,178,0,65,23,8,98,199,245,97,149,115,161,181,97,129,8,245,219,105,233,193,26,154,107,102,39,195,179,172,217,203,119,162,82,244,180,180,217,229,185,8,118,168,142,225,242,144,105,16,231,101,49,30,68,81,6,120,41,131,165,172,119,16,242,109,179,117,144,64,253,110,198,109,153,47,225,218,197,90,78,148,132,107,103,66,181,144,216,198,200,210,210,76,115,15,82,159,190,140,88,232,183,128,19,124,23,205,68,175,137,113,229,158,22,242,4,157,227,97,244,187,199,163,191,157,253,123,59,223,103,224,24,8,218,214,144,137,183,211,168,43,104,232,194,94,138,15,28,223,150,180,139,187,156,137,233,174,18,172,101,127,210,202,226,217,100,222,145,86,98,149,190,240,26,205,136,188,38,238,52,99,178,76,161,89,163,72,41,110,138,198,3,75,32,185,195,230,94,106,112,63,251,183,119,62,68,131,239,189,108,42,100,155,11,127,250,195,151,171,189,212,161,205,14,194,86,98,69,176,87,216,243,152,6,81,46,171,52,189,87,36,1,137,81,141,119,129,179,142,200,42,248,214,229,128,43,117,177,20,147,21,230,101,155,85,232,123,239,181,
146,244,47,37,125,116,48,125,206,180,136,196,90,214,205,13,69,217,37,246,240,147,43,45,91,23,183,202,14,253,88,133,148,72,118,215,66,148,193,46,140,98,35,209,186,77,0,245,99,21,25,204,27,94,214,141,214,186,49,110,143,167,238,124,172,176,125,139,236,237,171,16,120,3,136,108,181,207,195,226,245,102,100,106,189,149,109,47,219,46,24,202,188,38,0,114,85,237,98,32,212,144,85,174,170,97,38,183,27,0,218,119,203,1,56,143,61,231,1,168,178,165,172,210,86,170,253,157,138,250,248,92,253,26,123,122,195,99,127,17,174,174,65,192,128,32,86,100,183,22,144,214,38,61,212,160,85,125,42,81,179,72,95,5,175,129,39,61,254,43,218,54,192,247,248,237,224,80,236,222,200,58,87,34,96,5,56,121,116,17,56,111,139,240,139,172,220,70,53,25,107,149,190,172,93,22,174,55,21,23,71,46,122,183,2,166,28,184,166,141,140,214,180,21,68,114,144,32,162,80,11,139,30,227,2,92,33,36,52,95,60,189,136,206,102,141,35,197,186,108,183,219,56,84,34,12,84,97,222,9,5,188,84,171,115,142,138,194,120,235,233,178,205,217,157,71,4,145,104,
204,164,246,179,137,130,167,141,130,3,93,74,211,145,13,60,173,241,22,14,118,220,166,163,235,11,1,215,94,205,216,2,78,243,139,23,82,84,250,226,211,196,175,22,137,214,244,241,183,233,119,83,162,213,37,36,146,17,218,68,134,148,233,156,207,168,133,131,131,145,204,52,103,48,69,169,141,4,26,31,100,36,126,112,70,54,2,174,199,188,140,88,230,87,152,183,177,201,64,103,5,146,57,43,106,73,31,186,166,127,249,241,22,12,250,47,87,17,196,94,161,53,34,130,184,191,20,253,30,4,196,96,9,2,156,158,95,246,16,208,125,98,94,253,21,90,225,21,133,90,203,120,193,28,186,105,11,8,217,22,16,112,242,208,183,102,180,214,24,73,5,223,94,71,162,54,18,173,32,162,37,41,182,234,33,154,3,69,71,96,243,202,96,92,83,158,57,196,138,214,151,139,121,211,81,235,87,24,224,144,78,41,12,181,214,8,26,111,180,178,191,66,117,48,179,171,112,183,222,76,104,160,148,186,37,82,83,122,182,145,74,226,22,253,155,232,45,53,90,168,33,241,27,8,105,53,215,113,181,244,236,33,147,164,238,17,107,110,219,217,174,32,146,6,86,137,123,113,44,174,
235,102,188,119,225,168,96,234,170,64,233,71,41,133,29,234,145,125,73,212,217,114,68,173,45,87,143,126,19,215,72,164,46,162,10,175,45,229,13,104,25,31,125,241,178,62,26,62,168,255,78,182,228,133,100,173,159,5,210,206,153,12,18,181,115,89,201,72,24,87,52,2,218,45,95,195,163,82,157,13,192,121,0,93,217,240,162,11,214,233,172,108,132,145,43,219,116,86,182,204,164,234,103,16,48,32,136,149,5,100,90,213,166,69,118,40,37,166,131,239,172,38,234,88,122,12,233,128,218,10,150,37,210,74,189,232,0,231,148,192,115,130,235,225,25,217,183,139,71,100,134,21,234,131,93,12,156,248,244,20,70,2,88,131,176,99,1,64,187,30,51,217,245,216,207,4,4,40,10,203,80,246,238,63,3,177,131,50,226,216,195,33,6,196,17,54,120,198,72,23,194,234,119,168,88,150,140,16,144,100,29,60,110,205,202,183,156,46,162,10,176,14,128,204,95,84,41,42,150,210,215,132,176,60,219,0,78,65,214,20,1,39,17,171,163,108,84,22,181,26,186,202,79,23,145,216,155,80,36,121,59,24,187,4,161,37,195,150,150,132,152,179,141,169,205,182,49,248,166,139,
96,30,167,239,113,36,183,0,180,142,114,52,19,221,178,226,205,179,140,56,12,238,134,219,231,105,221,103,49,176,183,193,139,5,143,236,96,96,240,173,235,47,52,7,223,186,38,135,254,245,197,161,127,246,254,23,127,255,131,221,86,175,255,8,182,187,237,149,202,35,196,216,101,15,21,253,245,232,119,104,17,127,151,3,230,35,212,217,237,44,103,255,122,244,249,194,18,120,55,18,239,74,246,55,162,207,161,252,17,234,236,114,142,120,132,58,187,156,100,220,111,93,139,121,182,218,30,111,211,23,255,14,112,226,215,222,78,58,119,147,206,157,190,241,170,55,251,143,208,106,183,194,62,250,81,101,161,191,219,98,192,10,220,78,2,41,48,39,156,16,108,51,9,0,39,65,218,27,125,143,47,222,169,60,98,237,219,237,110,133,34,139,48,84,191,205,184,13,1,156,232,242,1,39,224,152,151,1,122,240,33,18,119,217,126,187,63,192,219,20,221,127,244,91,88,16,201,132,201,71,249,71,156,11,119,249,78,171,129,202,110,7,145,172,91,178,96,171,239,126,139,111,224,198,104,98,100,201,120,145,163,230,35,130,106,183,254,128,31,44,137,72,
21,82,115,222,63,234,14,204,105,146,152,205,82,67,193,188,49,191,121,47,69,191,131,121,223,54,235,192,204,197,74,105,230,34,51,59,0,211,171,175,246,225,63,208,1,165,174,167,82,151,195,60,189,219,125,155,163,197,110,210,74,94,130,162,57,115,216,13,81,128,8,51,4,198,60,34,18,176,187,85,12,106,79,94,237,227,72,88,112,156,11,4,0,140,16,36,225,137,43,60,176,157,60,58,64,88,27,90,107,77,16,74,235,95,11,182,47,65,112,244,97,62,71,159,236,217,196,21,173,130,129,55,13,112,63,195,115,253,209,23,30,88,192,0,11,144,172,109,50,64,158,239,182,50,142,26,56,207,164,52,33,212,1,36,183,140,1,137,84,146,166,1,15,65,214,110,230,68,137,221,121,182,79,54,65,19,154,34,81,7,67,86,110,172,133,152,53,10,181,73,85,9,62,219,72,166,208,238,116,183,173,95,225,233,48,39,135,150,208,0,115,90,46,52,177,70,15,178,255,80,113,255,226,179,221,230,114,36,0,159,166,194,88,100,188,0,75,191,93,140,153,161,48,136,86,8,155,33,138,219,200,224,155,1,173,25,50,110,37,192,179,18,36,154,198,91,28,235,2,129,237,105,96,144,34,
129,33,73,158,46,239,242,17,200,40,232,123,214,250,206,195,203,177,193,132,244,102,207,109,204,42,209,230,254,189,95,37,165,220,106,46,252,217,214,32,175,169,252,142,141,14,166,83,140,116,112,189,219,135,24,221,65,3,45,233,211,190,146,173,19,151,62,223,72,60,209,80,12,88,78,190,172,154,125,169,25,58,239,121,160,65,106,55,228,142,42,220,36,216,252,66,223,130,207,55,179,93,202,150,61,90,104,212,10,192,234,231,217,2,40,196,234,231,0,152,2,148,172,58,5,89,253,74,55,210,162,202,2,228,1,142,64,17,19,108,214,2,130,220,172,44,124,75,76,176,23,179,228,236,148,66,60,13,72,131,58,1,85,151,156,61,33,169,108,181,64,146,23,187,104,175,114,214,21,121,253,88,68,98,215,67,21,86,13,52,129,116,124,172,50,32,148,26,134,82,38,12,82,98,129,179,102,36,201,218,211,101,166,126,241,227,93,78,216,97,161,250,124,184,118,126,169,24,128,77,39,98,247,119,151,80,144,109,222,27,145,22,25,16,231,37,206,208,158,97,239,111,117,184,163,254,250,17,219,132,221,54,198,179,203,120,41,16,138,34,172,100,91,149,162,108,
40,118,123,56,68,234,177,3,49,70,239,124,244,151,182,147,217,21,184,187,108,183,67,239,18,38,3,219,213,9,11,133,111,93,150,210,143,11,228,11,87,241,187,245,107,40,167,1,246,34,17,73,165,69,110,71,214,85,84,116,100,45,166,152,23,178,5,32,34,13,0,253,104,212,248,225,200,98,115,103,5,218,200,169,153,38,155,181,112,221,156,34,235,209,23,187,243,51,25,65,167,178,133,168,226,99,254,116,49,40,33,231,8,106,100,11,41,247,103,1,112,68,49,224,136,202,137,202,185,140,168,18,64,181,106,70,212,5,152,59,230,48,78,101,97,119,107,183,131,38,210,168,117,25,90,45,5,16,91,188,136,138,30,35,50,125,179,252,104,172,48,98,165,216,110,135,82,153,97,245,101,6,100,185,26,134,80,228,204,67,196,18,225,62,243,131,141,74,127,85,22,172,138,13,187,42,67,214,129,176,205,9,122,155,22,155,203,78,124,104,143,154,130,53,36,69,3,10,230,141,159,213,47,145,210,66,103,23,171,107,9,71,56,190,73,8,36,2,207,18,17,89,150,40,211,113,158,197,200,253,201,148,48,23,167,234,85,130,0,145,7,187,169,31,254,9,187,169,15,214,31,252,
236,203,7,95,113,119,248,111,70,134,254,240,253,238,208,94,155,197,255,49,130,238,181,182,250,143,17,96,175,185,84,121,140,96,123,141,78,229,49,2,236,241,109,42,250,180,238,223,237,211,239,239,213,54,250,143,17,104,175,126,173,242,24,197,247,26,55,115,126,59,225,55,163,223,160,111,188,28,231,51,107,240,185,27,112,205,2,127,63,225,238,7,125,182,173,143,201,234,189,250,213,190,233,179,110,63,38,31,246,216,151,5,189,135,129,207,106,16,244,24,151,220,205,43,57,222,140,113,190,119,134,126,201,151,187,75,195,179,109,242,56,95,7,31,227,176,61,246,111,238,243,109,206,109,247,122,197,252,57,138,61,38,97,247,216,251,4,92,161,151,116,154,87,131,31,119,167,150,139,165,209,242,18,24,216,167,191,199,17,206,116,186,212,102,255,168,45,133,225,186,55,115,98,43,39,90,104,42,15,116,183,203,68,72,208,131,179,52,239,34,177,44,194,247,209,144,228,86,106,70,95,120,109,224,228,201,38,125,123,144,121,91,190,72,200,188,250,117,60,41,143,213,110,165,32,124,176,53,97,238,92,130,209,106,50,194,20,54,13,128,
34,220,19,160,36,225,187,231,99,202,220,30,223,51,143,72,182,8,32,133,113,111,69,128,2,88,133,162,140,199,13,88,32,208,90,21,156,41,85,184,239,246,252,42,78,23,92,243,10,136,146,157,205,176,89,178,137,9,239,18,29,26,95,97,249,76,74,17,14,220,229,153,18,119,114,102,221,125,144,125,148,149,40,221,47,197,169,191,215,34,156,108,164,116,239,34,146,121,158,48,145,36,236,138,221,31,208,185,29,227,61,140,104,137,9,19,193,177,139,14,248,175,18,159,116,16,253,53,188,201,129,17,39,132,173,214,239,245,31,243,113,97,111,64,15,205,133,223,35,173,76,47,229,44,78,45,78,94,129,143,77,75,120,11,142,143,224,110,7,105,130,156,118,34,225,231,180,195,114,238,3,111,167,210,58,45,185,34,140,129,175,248,161,187,128,61,238,6,131,53,173,69,41,253,141,85,250,31,236,113,87,24,38,185,19,243,220,21,62,230,104,187,71,9,179,233,116,87,248,152,109,237,94,73,57,46,120,237,36,238,10,99,156,190,109,140,237,92,82,50,229,184,43,140,249,181,152,31,132,205,114,216,132,187,66,199,25,119,133,22,172,56,159,179,67,140,67,
71,2,15,82,16,60,211,7,79,252,6,113,155,177,80,108,201,93,161,21,224,174,208,138,115,87,24,125,130,203,62,128,190,233,94,206,56,47,114,19,255,162,123,9,223,91,223,76,245,75,208,81,159,187,194,176,121,41,77,215,35,22,117,87,104,194,108,19,109,123,62,20,185,159,19,149,61,238,10,67,2,36,181,4,41,241,64,51,56,72,51,46,99,172,57,119,133,150,132,187,194,144,20,141,148,145,37,106,74,177,226,147,171,233,113,87,232,40,228,174,208,249,196,93,97,240,187,153,174,191,177,25,116,148,160,38,132,9,101,130,54,7,184,224,252,176,239,137,18,119,220,21,134,13,72,109,217,164,148,101,221,21,30,21,133,227,83,122,157,31,156,30,41,23,169,36,102,180,153,81,206,229,132,144,181,251,74,110,19,242,202,109,238,10,115,62,221,11,252,145,112,2,206,125,232,10,159,187,66,227,233,59,179,25,20,217,184,35,116,32,151,56,42,125,238,12,77,160,196,159,238,12,77,161,172,41,188,251,136,164,162,88,40,169,6,148,23,137,112,85,139,54,170,136,53,47,15,220,47,139,25,119,134,81,191,56,23,4,69,40,57,45,145,49,86,199,160,168,59,195,
80,146,122,96,35,0,96,165,112,132,149,34,182,100,12,238,12,173,147,238,12,31,115,178,222,227,206,48,242,25,68,39,248,102,196,152,238,12,131,34,90,155,34,50,154,226,98,246,145,221,253,156,231,206,48,68,36,234,45,34,4,93,57,136,33,215,137,117,213,88,213,174,53,28,165,154,182,138,35,92,197,105,93,213,113,132,251,68,163,251,95,169,122,247,247,150,137,29,21,140,65,30,20,135,116,50,108,203,26,59,232,67,80,34,119,100,54,135,99,198,57,223,44,34,63,0,112,232,124,153,161,67,117,51,2,18,24,30,63,120,62,25,12,170,117,25,7,223,33,71,62,217,54,232,106,91,228,242,210,100,222,161,135,181,13,7,93,211,79,122,92,25,26,190,75,53,23,31,206,174,134,231,202,48,232,220,59,30,116,191,60,30,125,90,243,121,176,243,3,6,222,221,107,226,37,49,88,229,75,64,216,12,78,174,239,80,114,5,160,125,91,195,46,219,47,245,185,228,52,37,46,79,13,199,103,171,160,156,53,148,203,203,240,34,173,188,88,163,82,40,44,74,165,104,224,109,141,55,239,164,0,108,239,228,179,178,109,43,154,15,182,67,219,41,249,195,212,164,104,246,213,
206,95,222,107,222,122,23,109,118,190,130,227,223,157,216,211,91,99,203,194,91,227,208,233,250,72,196,193,253,232,243,214,216,50,243,214,248,49,7,167,61,222,26,71,255,231,45,250,239,237,69,181,234,191,73,248,245,145,208,237,218,136,173,200,91,227,208,13,186,142,80,250,138,80,222,26,63,230,128,195,150,115,57,147,42,230,185,190,75,248,72,178,38,244,100,116,222,26,27,142,183,198,166,175,183,198,254,193,155,167,16,8,0,9,200,219,82,143,243,214,216,138,232,173,177,127,240,214,56,50,224,86,106,6,130,188,198,91,227,200,16,40,59,67,104,157,17,16,114,70,220,205,254,118,244,121,107,108,60,222,26,7,99,118,11,60,161,220,211,91,99,16,63,216,227,185,118,32,210,138,16,111,141,35,44,32,228,192,76,21,120,107,28,129,143,138,10,19,222,26,155,160,222,26,7,66,137,248,130,0,65,17,224,173,113,218,118,142,61,255,187,216,231,55,194,230,107,31,121,156,183,198,209,231,173,49,3,239,236,233,173,177,173,168,183,198,76,29,219,227,173,113,240,164,149,17,120,107,28,233,78,235,80,190,146,50,175,164,204,24,203,
201,148,34,240,214,56,68,44,125,230,173,67,226,243,214,56,68,101,222,73,138,219,143,224,95,76,124,156,97,149,176,129,224,120,107,236,126,241,34,111,141,61,206,91,99,47,93,124,34,140,37,76,59,112,35,240,214,24,12,2,17,8,75,190,156,148,83,130,1,37,250,81,46,66,18,222,26,71,31,47,88,50,36,180,119,112,175,251,180,234,243,214,216,154,53,87,35,16,121,107,108,175,242,214,56,248,165,37,121,107,28,248,72,40,252,214,181,88,100,121,107,28,166,231,59,171,39,120,107,28,91,51,90,153,140,183,198,238,243,214,216,4,121,107,28,153,182,17,125,222,26,59,156,120,107,236,121,222,26,71,127,251,83,250,239,236,241,214,56,224,183,114,126,51,194,143,183,198,230,199,91,99,199,53,111,141,35,206,111,127,47,250,219,217,231,173,49,3,239,237,241,214,56,2,255,246,15,34,126,177,136,226,183,88,150,135,174,65,0,203,57,81,232,59,81,50,49,120,107,28,125,24,186,44,18,67,242,72,217,208,240,214,216,137,162,183,198,72,246,14,155,216,0,224,133,110,48,196,148,38,72,80,188,157,121,122,107,140,175,142,237,241,214,56,85,77,
196,204,241,30,62,20,167,21,124,38,68,222,26,219,230,101,183,203,91,227,40,62,215,55,93,68,120,107,108,120,222,26,7,67,36,181,196,104,224,24,66,67,71,115,47,250,188,53,14,223,22,201,121,107,108,159,241,214,56,4,202,224,27,104,114,47,8,243,214,216,65,198,91,227,176,249,250,71,97,66,124,40,19,174,111,103,255,65,246,169,182,94,173,183,183,153,63,198,106,29,123,191,149,173,227,22,176,184,128,183,198,22,156,183,198,161,72,158,189,120,168,17,138,92,39,225,123,124,201,217,211,219,16,131,242,54,196,225,208,33,30,29,231,87,50,78,41,95,202,11,94,6,68,156,178,202,41,126,203,89,151,203,45,195,243,54,196,112,101,31,92,246,3,133,37,111,67,204,167,179,146,244,47,37,253,60,9,103,13,226,236,194,219,144,176,46,165,222,241,193,178,230,150,227,150,91,237,130,244,131,11,81,147,228,6,208,8,188,13,137,22,68,185,71,111,67,252,131,183,33,193,27,94,214,141,214,57,200,184,115,62,117,47,139,75,145,93,111,67,222,2,68,54,222,134,196,142,172,25,59,50,222,134,56,98,234,189,108,121,27,226,1,222,134,216,92,124,
24,53,2,111,67,162,197,76,90,187,107,218,120,233,7,95,190,13,200,219,144,199,124,220,217,227,109,200,99,190,229,236,241,54,228,49,159,159,246,120,27,226,62,111,67,2,62,119,25,122,27,18,128,32,234,235,251,30,111,67,66,155,244,16,111,67,98,91,192,184,150,72,222,134,56,40,121,27,18,227,185,148,22,109,121,80,17,227,28,216,5,207,219,16,155,153,183,33,49,158,17,192,195,13,7,17,111,67,162,80,249,88,204,202,138,106,178,42,111,67,108,237,146,215,111,118,214,16,212,219,144,189,242,125,71,111,67,28,231,188,13,49,201,85,68,116,134,39,11,222,134,88,4,222,134,120,190,120,154,183,33,193,26,71,202,211,92,144,134,234,56,84,34,12,84,97,94,170,240,73,220,42,232,109,136,221,83,227,109,136,205,169,183,33,38,193,219,144,208,114,54,81,240,180,55,36,56,208,91,230,116,36,111,67,60,206,219,16,179,44,142,230,34,204,112,124,31,142,144,1,78,177,197,219,144,16,149,190,68,229,109,72,136,68,107,250,248,219,244,121,27,98,137,244,54,196,70,224,246,215,148,120,27,18,81,11,7,71,45,153,233,140,4,83,202,241,54,196,
227,131,140,196,15,138,242,86,35,224,120,27,98,35,150,121,222,134,132,177,201,64,25,187,131,100,206,138,90,210,135,174,233,243,54,4,6,236,92,16,196,94,161,117,221,69,16,247,249,186,229,178,8,1,229,35,111,67,162,218,33,160,251,196,188,182,92,188,13,49,92,81,72,111,67,130,67,55,109,1,33,219,2,2,178,69,147,190,53,163,181,198,72,234,60,229,51,61,3,253,61,222,134,132,36,197,86,188,13,137,64,225,198,32,120,101,48,234,109,72,132,88,209,154,175,242,97,222,116,148,222,134,184,168,242,54,196,19,188,13,49,70,233,243,54,36,152,93,133,187,245,6,208,122,19,117,214,147,212,244,214,18,169,36,46,111,67,60,206,141,135,213,224,109,136,197,231,109,72,168,201,219,16,235,201,219,16,3,242,54,36,218,118,182,124,172,246,64,249,32,89,92,199,219,16,7,17,111,67,162,85,129,82,84,149,82,200,219,144,240,37,81,103,203,17,181,182,92,61,250,188,13,177,72,188,13,49,158,222,134,4,160,101,100,65,224,109,136,101,227,109,72,180,228,133,124,162,183,33,254,209,156,12,18,188,13,113,188,214,72,24,87,52,2,218,45,215,7,
254,209,60,27,128,188,13,137,202,134,23,93,217,78,103,101,35,140,212,175,77,103,101,203,146,169,183,33,1,8,162,222,134,176,243,96,68,150,47,37,134,183,33,161,38,234,88,77,12,233,144,221,10,150,37,210,74,189,224,65,69,164,4,158,19,28,111,67,108,95,46,14,108,6,110,102,194,197,192,137,143,222,134,24,128,183,33,17,11,0,30,9,121,236,39,215,235,134,202,20,120,27,18,27,228,12,68,238,99,204,145,183,33,1,136,35,228,40,222,15,89,98,222,134,184,63,88,62,9,1,73,198,213,79,104,38,194,82,141,183,33,6,228,109,136,205,95,84,41,42,150,210,199,219,16,123,150,183,33,14,50,189,13,137,36,98,117,52,33,106,163,36,136,143,213,67,123,188,13,137,143,13,72,34,7,151,96,228,109,72,72,134,45,143,44,150,212,102,219,24,91,57,57,17,204,182,167,239,113,36,119,173,165,117,50,195,207,133,13,250,138,11,222,134,68,24,220,13,183,243,54,36,250,44,35,14,11,240,180,224,205,93,39,59,230,222,186,205,248,205,250,91,183,25,147,67,255,118,100,232,143,222,255,124,104,191,201,5,206,19,24,238,215,136,225,39,112,216,175,174,247,
159,64,105,159,237,157,39,230,110,246,159,64,104,191,186,25,227,115,151,163,63,191,218,127,194,82,187,95,89,233,63,129,227,126,131,113,36,222,199,50,65,231,90,194,211,23,126,147,75,70,19,100,111,244,4,147,236,179,152,27,176,1,35,35,94,137,126,243,86,2,150,137,230,70,72,194,206,228,9,182,223,167,34,152,16,127,36,245,4,219,236,87,32,32,9,230,152,23,167,10,156,213,231,11,246,19,108,186,207,197,197,19,108,188,207,201,61,250,119,163,207,55,68,11,210,189,92,49,93,46,54,162,207,184,248,240,53,44,240,192,55,29,240,223,166,195,159,28,89,142,6,120,82,160,249,32,250,124,130,55,60,23,57,30,47,252,11,253,210,111,221,14,56,222,132,4,157,251,73,7,254,114,73,245,90,197,158,168,32,135,244,169,210,202,51,149,171,209,159,163,149,190,179,120,98,150,150,119,50,71,245,67,62,25,154,143,72,71,229,78,207,242,226,196,227,124,155,123,194,183,186,125,46,112,172,247,226,173,232,243,39,7,129,7,188,244,95,188,222,15,56,228,148,125,248,230,244,132,244,221,239,162,191,250,188,183,241,124,123,43,232,242,108,60,
224,240,139,224,22,240,11,15,46,246,107,208,81,164,113,31,107,255,241,128,222,112,45,224,196,167,201,226,18,6,233,69,100,20,0,46,25,35,98,32,224,136,89,206,136,201,0,169,19,89,10,8,54,54,22,132,211,97,56,98,45,225,147,113,151,11,36,115,100,75,251,132,130,52,176,92,147,190,44,207,159,64,132,231,144,80,30,175,35,153,8,47,64,216,26,32,177,52,168,241,88,193,63,22,238,230,4,187,106,6,30,125,177,127,241,243,254,19,190,66,238,115,27,111,25,40,20,244,251,251,85,90,57,145,51,246,19,62,141,239,159,7,238,60,227,122,93,99,64,158,194,120,162,197,45,61,3,149,253,206,149,116,227,122,184,163,132,45,0,103,141,193,155,24,75,125,145,141,160,121,22,195,86,113,156,120,157,199,78,231,105,121,242,99,117,120,42,20,129,190,20,142,227,126,44,2,133,192,117,128,67,80,142,184,68,98,72,70,174,47,220,231,101,88,192,101,34,116,122,217,47,129,146,112,151,174,125,13,222,7,251,60,170,8,243,97,3,153,175,197,183,220,32,140,35,76,24,193,196,136,77,174,35,36,141,80,217,191,132,36,6,224,43,96,96,80,28,60,128,10,194,
152,7,64,213,167,10,107,231,4,230,140,156,79,163,92,66,39,35,200,40,86,6,159,189,69,18,187,150,244,72,187,150,242,192,109,96,4,1,105,232,180,150,147,29,21,196,117,228,185,7,42,3,187,52,31,38,6,173,1,238,60,250,194,24,11,232,165,120,169,240,105,40,196,195,242,18,134,39,70,1,121,187,64,162,151,33,217,91,167,34,9,153,197,165,182,197,132,235,51,89,46,141,231,120,204,18,133,21,19,72,188,58,144,178,50,231,112,211,174,61,192,20,194,152,199,157,178,85,141,58,99,10,40,110,155,41,228,116,232,217,215,223,103,56,17,116,202,112,102,12,106,20,70,144,192,124,93,141,208,161,198,169,166,148,220,230,246,206,227,124,53,181,16,29,52,214,124,147,119,89,33,21,142,145,84,5,128,191,188,8,130,88,64,177,54,136,189,18,67,120,67,12,185,149,54,62,87,16,1,95,138,241,74,244,121,181,120,36,22,185,88,8,60,198,237,44,232,133,47,210,58,40,109,235,220,15,235,240,185,35,178,135,107,232,0,228,66,39,48,211,126,197,4,60,164,11,149,105,189,44,100,57,237,64,73,170,14,50,151,219,145,212,25,23,137,151,30,61,133,7,72,12,
71,107,250,174,71,171,138,88,42,250,28,214,245,26,41,63,88,250,123,25,106,97,198,63,219,26,228,82,89,61,59,228,182,184,243,8,42,90,5,142,6,216,210,216,176,252,249,73,180,153,132,109,197,160,44,174,199,79,161,49,251,94,115,107,67,75,51,77,110,164,130,61,78,211,227,167,253,234,133,8,182,249,139,177,216,207,47,102,219,201,182,5,45,107,6,87,197,20,207,184,162,93,202,150,119,31,30,152,229,184,226,85,106,78,236,165,108,149,170,224,64,230,112,17,235,24,165,113,118,225,239,245,247,245,98,39,4,202,149,190,161,1,121,147,215,78,88,22,193,244,218,41,74,70,214,87,94,59,217,59,218,75,250,7,175,157,114,85,203,1,94,59,89,185,150,54,34,10,49,94,59,217,59,122,237,228,31,122,237,20,245,157,215,78,30,209,193,214,212,56,216,134,205,102,115,133,160,108,91,32,12,99,87,211,42,183,56,216,122,156,131,109,132,35,173,147,115,33,224,56,216,90,51,30,229,122,158,131,109,72,73,95,193,197,193,54,60,64,107,250,24,220,244,57,216,154,129,14,182,78,213,226,103,14,182,225,119,56,184,120,99,8,39,16,152,226,204,193,
214,227,156,126,204,161,131,135,28,182,141,128,227,96,107,67,150,121,14,182,79,56,151,237,175,94,138,181,145,131,109,208,175,37,125,232,154,62,7,91,24,244,247,57,216,90,160,21,90,35,34,136,22,213,21,28,160,62,127,244,96,6,28,108,159,112,192,219,231,96,23,125,156,171,62,7,91,195,21,133,116,176,13,14,188,52,11,227,205,135,17,244,210,44,162,141,35,44,177,211,223,231,165,89,208,44,225,192,75,51,219,83,47,205,60,83,12,174,151,102,193,166,21,122,180,121,105,22,65,134,156,50,148,94,154,89,112,94,154,89,64,206,51,161,0,22,86,182,242,210,44,21,128,187,55,62,237,52,41,41,230,212,43,113,91,22,96,189,52,179,251,120,105,246,132,139,152,125,189,52,243,0,39,27,163,12,218,180,114,71,249,98,90,152,89,238,108,19,32,110,1,112,123,5,0,253,208,19,178,8,201,54,76,236,233,220,173,52,23,115,160,129,102,2,219,159,255,235,153,174,231,178,37,154,149,181,243,191,93,12,202,132,211,55,243,189,138,202,238,207,2,160,31,179,226,166,77,230,156,14,12,78,95,52,112,250,242,125,48,210,183,171,244,133,219,155,16,197,
179,18,181,3,85,235,68,146,168,223,194,159,14,33,22,11,11,158,186,117,9,57,37,65,169,109,45,146,76,112,61,240,109,111,34,75,243,131,72,203,16,29,20,3,30,181,153,81,75,129,162,71,109,251,156,16,35,175,138,77,122,200,96,90,240,116,53,71,83,201,196,71,129,224,77,101,115,122,76,5,239,226,160,54,223,36,3,16,165,132,88,199,165,202,204,1,64,42,91,54,124,77,242,75,202,53,96,232,133,168,156,180,218,9,216,69,123,17,226,217,191,51,251,34,222,210,142,177,14,130,9,211,183,213,50,129,91,48,180,213,176,243,17,194,149,180,34,240,182,46,248,134,3,207,112,8,226,82,2,31,151,18,248,123,91,0,188,75,55,53,85,142,156,39,47,221,7,95,253,10,22,242,177,74,49,139,199,7,15,227,126,115,133,163,228,119,244,48,238,246,208,191,27,29,250,231,239,95,28,58,168,81,118,159,66,149,31,125,183,149,141,254,83,176,15,230,174,247,159,130,124,80,189,214,127,10,213,131,218,205,152,231,88,233,241,58,213,255,41,98,29,212,56,246,25,115,14,72,97,20,72,14,158,198,156,219,138,241,121,177,66,208,131,10,215,83,230,81,101,171,108,
16,14,0,65,11,166,22,70,196,245,131,239,194,70,121,3,224,137,254,65,3,102,24,231,128,127,200,241,20,99,29,112,102,139,254,131,232,183,186,149,167,24,243,128,179,224,83,140,123,192,61,118,244,239,70,159,251,237,192,235,37,222,122,246,175,70,159,7,18,33,17,173,4,169,111,69,159,219,102,243,169,221,143,241,38,165,3,66,125,204,144,162,243,214,220,24,173,181,190,57,242,39,172,238,243,241,201,128,124,242,54,103,158,251,153,67,235,182,224,250,7,156,2,13,207,233,217,28,218,16,228,107,223,1,59,53,107,192,169,217,240,124,108,15,201,176,128,36,91,0,158,29,232,1,159,66,130,95,218,144,21,221,182,229,148,109,99,243,47,80,12,207,25,201,244,43,204,203,209,53,250,162,83,165,208,6,130,188,226,25,36,214,12,23,69,33,25,28,100,243,162,106,147,13,118,168,2,9,133,2,219,102,139,82,34,128,255,42,98,2,21,230,69,176,130,42,110,249,162,229,31,213,123,41,227,157,156,248,202,19,143,190,56,152,110,246,159,78,139,23,210,75,134,233,207,213,239,31,76,99,61,143,167,54,211,104,161,254,12,112,51,180,117,198,37,10,
71,168,136,172,213,180,154,98,78,19,37,146,234,41,115,141,205,84,8,153,129,95,18,161,170,24,84,228,115,242,115,123,30,237,56,141,29,84,54,43,22,254,60,161,224,254,114,244,171,55,42,134,155,39,100,20,230,85,224,132,63,191,20,125,62,7,4,222,181,196,91,57,74,103,246,74,229,41,149,250,96,102,41,84,57,79,254,152,126,58,176,142,53,223,86,173,134,41,100,154,121,76,224,180,186,144,14,77,147,113,44,183,219,216,123,25,175,2,93,89,255,34,243,212,171,131,65,64,241,6,192,0,53,4,51,65,0,68,240,34,182,52,96,218,148,43,22,19,188,8,67,143,103,214,214,107,193,96,30,6,22,36,35,139,3,77,196,11,112,162,91,67,16,181,172,178,193,175,140,179,125,101,130,28,202,80,172,111,145,67,118,214,74,66,114,102,50,106,5,157,164,67,157,63,220,8,136,237,95,133,160,218,8,98,78,52,92,192,178,12,205,223,103,64,226,205,255,60,197,76,187,242,89,195,180,155,68,167,74,73,9,111,253,169,7,19,59,95,31,112,34,139,24,41,129,93,33,87,205,68,32,98,194,253,96,224,102,149,156,135,166,120,233,59,228,209,9,108,162,9,30,206,133,252,
105,195,194,92,95,15,34,217,56,65,135,245,144,95,86,107,66,90,226,241,120,54,0,168,27,206,198,20,159,239,127,14,183,18,38,188,127,49,94,201,32,62,34,68,29,73,155,22,111,22,157,184,106,139,112,229,173,152,69,228,175,128,60,80,161,16,73,217,42,241,174,120,174,80,10,67,249,168,235,165,190,151,149,161,16,42,42,214,112,145,221,47,141,106,11,127,48,114,80,39,82,29,201,151,130,101,165,147,28,8,12,118,135,7,165,196,13,74,24,145,110,142,100,162,172,205,18,110,124,118,103,79,47,8,62,85,226,230,4,19,81,50,81,93,69,255,2,125,118,111,131,249,70,59,76,86,2,182,73,224,122,241,88,212,184,28,13,33,137,90,108,89,97,66,140,217,208,132,205,153,151,205,155,43,203,70,172,95,29,177,32,5,111,158,8,151,119,171,156,149,172,9,23,160,65,48,53,229,59,182,17,26,173,36,52,21,18,92,100,222,41,133,196,178,76,141,242,39,65,56,183,69,184,208,106,156,103,250,244,89,44,114,113,225,82,37,130,0,124,193,55,22,146,238,210,78,235,160,190,248,46,82,14,7,65,84,53,65,52,176,132,8,230,101,29,2,26,231,3,122,104,148,245,178,
5,156,214,79,46,248,194,68,152,94,154,95,0,78,38,109,48,174,126,117,109,217,116,154,43,35,1,135,96,26,47,81,200,55,223,24,135,174,241,237,50,230,147,79,41,74,85,198,37,207,5,162,216,244,9,133,35,240,185,234,113,78,139,113,230,237,218,44,138,109,198,189,206,19,74,150,27,122,114,109,61,13,199,230,45,66,2,190,127,46,125,224,93,113,18,254,2,122,152,190,60,89,103,119,124,80,235,240,203,54,230,156,99,25,106,28,162,99,100,53,71,154,156,94,204,182,172,124,37,82,75,127,190,94,2,4,64,47,14,232,33,127,212,180,143,176,35,88,10,37,120,115,235,105,196,216,220,229,39,203,68,253,7,131,165,176,194,95,126,56,42,107,28,123,141,51,216,196,149,181,126,154,93,179,151,197,178,139,155,99,47,232,212,153,91,123,114,205,63,202,50,55,160,54,189,6,53,45,165,211,18,69,63,102,169,52,90,144,42,216,204,233,71,90,41,253,102,9,82,141,235,174,34,136,222,79,17,75,101,175,240,135,39,129,162,250,231,42,140,61,93,60,184,220,243,204,2,68,181,109,169,83,214,28,241,84,80,233,191,64,185,211,120,67,152,138,0,182,207,246,
104,85,98,137,196,28,98,137,100,165,144,42,233,95,147,245,69,131,63,60,112,91,145,74,146,188,34,47,250,199,34,34,251,71,59,71,22,46,240,67,12,43,151,202,200,98,142,212,78,39,189,65,144,202,172,18,97,1,6,194,169,93,74,136,89,42,154,77,34,33,45,28,137,46,62,213,130,50,72,36,78,125,161,23,17,171,72,173,201,86,142,43,14,63,158,105,114,250,140,40,34,24,53,83,170,6,127,26,227,254,60,165,220,73,44,64,71,17,133,205,81,4,77,33,112,199,19,0,32,120,158,191,110,242,64,139,83,168,185,54,214,30,111,193,140,141,244,250,239,211,30,59,168,42,170,5,91,239,242,67,30,105,92,198,86,242,64,85,63,52,117,65,202,56,123,50,11,235,146,189,190,240,228,218,1,119,7,206,175,182,70,148,136,109,190,214,248,71,157,210,36,114,85,206,155,166,50,112,168,140,39,178,37,247,171,203,201,167,185,194,15,37,193,92,7,41,231,144,178,70,189,148,98,149,243,144,151,93,107,114,155,70,106,114,164,190,220,31,204,221,7,75,182,159,171,22,44,188,98,44,254,32,202,88,211,117,126,56,198,101,57,199,56,132,29,227,185,4,205,81,215,68,99,
22,203,29,113,40,31,120,44,82,163,3,166,227,146,24,248,255,248,79,145,228,28,230,175,183,252,131,127,166,18,65,46,65,98,75,65,124,216,83,10,54,185,174,201,95,27,6,3,253,16,131,166,236,35,50,85,188,43,59,21,217,234,200,234,148,41,53,29,111,56,28,80,87,112,28,0,35,246,20,254,250,219,173,131,26,241,32,110,115,77,70,172,158,226,84,250,241,129,48,112,37,179,144,107,242,177,97,153,177,53,21,150,198,81,96,216,38,75,97,232,193,193,242,163,191,161,131,101,125,251,203,47,127,54,244,39,167,135,254,5,7,203,87,227,141,254,179,241,133,161,87,100,235,51,176,95,81,76,158,129,252,106,122,171,255,12,195,191,26,163,63,70,59,115,189,255,140,141,251,171,201,107,253,103,147,180,227,87,2,111,138,249,41,250,19,75,253,103,19,180,108,244,141,55,117,35,198,39,153,55,252,157,128,31,208,185,21,227,83,189,196,95,78,252,78,226,175,36,254,106,192,205,208,23,255,41,232,139,223,52,227,146,111,14,62,146,123,18,124,241,153,161,53,28,173,225,144,87,112,5,127,118,61,245,43,248,119,43,161,247,237,138,245,158,163,21,
189,74,175,242,140,0,126,85,189,85,121,134,189,95,85,182,179,15,188,250,115,55,19,239,78,226,21,58,91,209,159,97,94,114,76,211,154,255,102,244,103,175,198,252,52,120,150,159,173,41,12,251,175,198,49,160,28,49,189,249,104,132,153,99,175,102,214,18,3,9,236,145,27,137,177,253,232,199,96,124,248,106,118,61,89,195,82,34,207,208,23,75,110,67,62,125,53,183,254,33,242,79,132,46,203,33,59,39,23,83,170,222,132,66,21,10,149,203,169,20,20,172,84,42,177,176,209,127,70,221,124,85,193,136,54,2,125,205,47,224,116,141,179,21,127,70,236,189,154,165,47,209,88,190,130,17,206,22,252,228,197,112,6,127,219,107,188,89,156,103,21,152,183,210,140,91,98,90,75,140,83,133,55,71,80,104,124,16,132,107,1,95,37,120,196,127,118,51,249,17,156,71,240,225,47,252,9,232,43,8,39,113,178,130,161,200,117,22,188,179,154,103,220,65,10,188,228,56,3,253,51,180,227,183,195,246,19,232,171,249,81,57,101,148,98,245,106,154,240,20,36,167,114,107,28,225,221,31,132,57,223,184,99,60,225,74,120,114,198,122,70,174,191,170,210,74,242,
25,56,89,83,90,73,58,131,36,234,79,49,239,244,97,220,146,149,112,205,249,207,104,63,3,110,58,45,55,195,233,31,196,202,171,217,165,240,229,121,92,199,233,147,252,76,231,19,191,98,112,30,87,106,188,178,145,46,38,56,36,200,60,227,22,140,104,114,159,86,253,18,10,231,233,27,175,158,116,136,83,245,103,25,151,11,103,112,149,4,63,143,11,12,135,1,108,122,20,177,233,17,84,166,175,146,151,166,143,235,68,191,24,102,26,151,203,160,159,221,12,197,102,50,4,62,195,37,71,20,77,3,76,192,79,116,103,154,193,247,51,232,25,142,121,209,153,33,4,37,207,103,184,208,227,204,123,60,233,150,186,196,247,50,203,57,8,197,146,255,200,161,80,42,117,106,2,185,237,8,90,209,25,231,243,2,121,217,127,53,9,3,23,24,62,28,153,227,32,152,110,145,110,51,155,199,0,255,204,19,179,89,18,166,113,133,69,225,234,40,48,208,209,180,239,148,20,7,66,194,207,82,92,156,31,165,40,112,6,182,84,227,104,169,162,48,117,27,140,41,138,194,52,110,54,205,44,47,83,184,211,101,46,205,58,139,216,206,200,251,161,214,56,173,171,10,127,29,21,136,
248,81,44,167,191,12,66,83,95,5,129,201,135,21,171,55,65,43,25,199,183,3,177,164,208,44,178,191,157,194,99,72,230,117,1,56,209,155,36,14,100,158,113,226,194,18,223,141,192,158,103,60,226,45,226,97,238,97,8,54,145,182,152,97,94,248,124,115,138,196,160,4,216,36,8,238,120,187,151,125,248,152,63,254,146,1,230,24,119,9,64,97,227,51,239,56,76,186,165,4,204,0,175,249,41,12,244,182,161,198,31,132,156,69,238,9,226,70,122,79,33,159,224,38,233,187,132,36,159,41,232,104,156,79,10,230,51,141,156,146,99,146,248,115,88,0,111,62,132,137,241,211,30,51,216,195,227,200,101,254,180,194,27,231,99,10,134,250,131,145,87,115,181,212,132,86,144,179,20,33,187,144,86,11,67,133,113,105,198,246,203,25,53,73,166,137,227,160,116,124,30,146,71,209,237,191,154,187,148,244,128,155,1,255,92,171,255,236,28,240,147,172,172,150,212,227,67,175,206,145,1,26,231,59,150,249,22,186,195,51,253,103,195,236,70,6,181,107,174,27,4,57,95,88,144,89,82,210,174,0,209,174,184,188,108,87,76,93,85,140,18,90,139,49,62,202,252,40,253,
113,118,245,168,218,31,16,60,79,177,84,237,152,32,167,101,243,194,121,10,68,19,96,92,132,103,96,40,139,140,93,136,88,43,25,55,143,198,174,89,196,32,255,192,134,133,48,5,66,48,219,22,75,41,6,39,218,73,159,113,91,140,113,211,207,61,198,232,167,41,32,203,147,224,231,104,29,83,208,19,223,10,138,201,242,115,151,71,60,94,20,47,123,137,115,208,181,101,209,71,244,207,209,218,162,140,11,191,204,23,248,73,228,22,28,223,75,236,201,226,89,158,124,5,125,228,117,204,39,126,137,132,226,169,73,28,97,15,210,138,126,169,141,147,216,77,227,227,196,160,244,24,67,79,229,230,25,244,240,242,70,140,254,121,250,21,187,157,67,239,183,35,100,124,99,57,236,183,57,18,254,129,142,232,15,83,219,135,69,95,5,109,76,203,227,56,27,229,0,149,143,237,75,253,16,240,196,181,50,194,149,155,71,166,120,12,30,246,71,63,251,137,179,99,98,167,163,88,5,141,75,210,188,93,132,166,174,63,222,2,179,79,153,13,205,231,238,50,160,228,152,36,173,141,193,29,115,160,112,216,54,205,81,254,40,204,225,55,13,81,113,27,84,120,180,48,113,
180,146,85,166,54,11,113,82,83,102,157,219,46,196,179,6,76,136,166,81,10,241,105,190,70,155,232,40,2,41,198,207,128,43,83,143,81,22,100,250,81,214,113,199,190,76,37,46,19,124,26,53,141,73,73,42,145,207,106,68,187,146,105,62,146,154,216,156,126,40,0,43,80,115,49,195,177,226,91,22,175,57,68,214,252,44,90,59,80,178,232,204,106,189,240,64,89,106,166,165,189,115,40,235,227,44,151,0,6,153,3,199,60,196,222,76,138,100,163,55,158,46,135,197,56,74,4,50,167,55,155,100,86,63,204,128,19,106,140,232,135,70,230,56,162,5,65,162,91,244,166,53,32,214,83,164,177,210,109,146,35,102,56,137,124,182,25,57,124,134,81,248,50,19,70,81,28,217,143,250,33,152,73,190,158,120,228,77,212,100,185,25,31,68,13,233,102,80,194,221,184,83,73,158,240,178,201,165,134,0,166,46,242,195,146,44,227,89,219,30,73,100,250,115,24,210,25,219,99,66,197,178,164,234,57,82,81,19,179,211,105,233,243,153,210,8,161,241,179,180,34,48,9,156,8,234,191,91,68,117,206,28,61,203,22,216,28,112,153,57,40,47,102,56,130,15,170,29,87,33,182,228,
24,106,56,91,145,201,217,202,153,47,228,207,61,225,36,79,71,195,20,48,179,26,124,155,240,192,48,154,59,33,101,18,209,24,172,122,162,161,88,158,38,245,237,139,229,18,228,132,148,131,124,181,4,57,108,109,189,226,139,113,14,159,230,63,205,153,23,100,210,124,106,166,96,83,57,141,125,177,96,99,7,99,23,91,143,243,141,205,216,163,146,73,41,192,117,80,136,192,58,22,78,72,20,44,229,104,24,212,16,161,134,67,249,97,170,156,140,99,68,162,104,100,74,161,35,42,211,138,143,105,45,83,147,84,175,35,83,131,208,153,248,53,161,166,68,208,232,124,96,177,84,185,56,137,78,134,209,27,22,124,106,49,204,140,120,73,237,73,153,213,188,72,111,147,41,153,50,42,194,78,120,158,205,75,255,55,135,238,47,57,116,31,187,112,251,231,63,31,250,247,99,67,127,252,254,252,208,235,19,189,254,243,19,11,67,175,57,67,63,7,244,245,153,110,255,57,158,127,61,122,181,255,28,26,175,63,153,236,63,255,132,118,236,90,255,57,94,125,61,188,222,127,142,155,95,159,184,28,120,167,192,59,69,255,228,102,255,249,73,218,209,27,129,119,234,
102,140,15,47,37,252,74,192,179,87,59,66,231,20,120,198,223,72,124,90,241,61,5,127,141,15,195,71,252,10,255,83,107,49,94,228,27,135,143,228,38,252,2,110,53,232,23,185,70,183,130,30,235,144,249,178,14,133,126,201,103,252,65,37,244,190,87,241,248,248,253,232,79,108,86,158,227,255,215,147,215,43,207,177,242,235,137,173,236,211,170,63,126,51,241,104,101,175,241,187,71,251,99,87,43,230,55,202,184,244,25,187,19,253,51,208,179,125,183,99,124,156,55,139,8,208,127,125,2,133,229,136,209,141,71,63,6,227,195,215,99,64,202,226,103,110,39,6,173,40,141,63,4,96,28,128,51,136,98,214,151,130,245,24,162,8,97,226,14,0,19,0,140,35,131,108,51,113,35,100,47,8,147,156,18,94,79,108,28,67,145,207,66,73,148,182,82,8,41,132,179,215,251,207,41,24,175,57,195,198,60,70,211,252,89,90,141,79,19,12,100,242,235,51,24,209,18,48,110,70,244,101,180,97,156,32,167,77,66,71,120,103,160,99,165,139,209,193,23,60,31,116,66,226,196,99,211,224,241,95,117,18,27,224,160,147,206,227,64,16,248,208,183,198,140,139,239,73,232,
42,8,135,111,7,127,14,0,134,27,1,110,228,173,249,81,130,70,166,252,9,240,63,161,61,65,95,182,63,9,31,225,127,204,201,246,249,199,84,155,215,163,164,135,32,139,198,163,132,227,40,222,138,150,113,194,87,150,40,112,167,152,87,216,178,33,126,78,82,190,102,59,105,201,199,8,91,75,74,43,73,75,26,156,98,222,225,207,184,56,179,86,155,95,153,255,20,205,62,213,56,150,114,24,73,178,177,133,202,235,51,75,225,252,159,18,4,63,21,193,140,150,9,162,68,12,126,74,220,105,124,98,35,227,118,61,92,204,33,45,4,35,38,228,154,41,90,9,58,113,57,241,232,27,175,158,125,66,66,253,51,140,203,133,99,40,40,69,126,138,105,13,135,1,108,122,20,177,233,17,212,174,167,14,152,62,38,21,253,98,152,209,12,129,79,49,185,20,27,163,47,122,159,226,162,35,138,162,184,198,79,194,79,116,199,154,9,7,61,195,49,111,131,80,127,140,143,203,61,206,188,199,147,238,201,148,107,34,67,236,12,117,200,161,72,136,10,110,80,63,82,238,147,200,109,71,100,29,59,193,153,251,249,9,60,94,98,106,140,51,119,72,134,4,134,84,54,141,109,30,131,220,
103,158,56,131,201,204,34,19,86,91,212,192,64,71,99,112,230,6,250,216,235,49,32,36,252,25,138,129,49,192,180,80,236,161,28,184,39,224,161,192,60,197,153,155,56,57,246,122,20,55,91,189,204,245,83,184,83,241,83,204,122,6,177,69,137,179,118,16,160,117,85,225,204,29,136,248,81,44,71,191,12,66,167,190,10,2,195,15,43,246,219,73,90,201,120,130,20,19,226,56,50,43,85,217,84,134,136,25,136,159,32,153,215,5,224,68,111,152,56,240,186,64,92,88,226,187,153,8,140,59,17,50,30,198,31,6,189,147,105,139,49,230,133,63,1,188,19,227,86,244,207,32,184,20,25,187,151,125,248,216,68,153,186,227,140,187,132,64,215,248,204,59,14,147,110,89,167,198,128,215,252,41,252,255,182,161,78,60,8,57,139,220,37,245,79,33,159,224,134,137,35,233,83,248,148,245,108,2,122,226,51,138,156,114,196,48,241,39,184,49,224,205,135,56,52,126,218,99,12,123,120,28,185,204,159,86,120,39,56,115,99,168,63,24,121,61,94,75,77,104,5,121,134,149,202,46,164,213,194,48,193,184,56,178,39,112,70,149,21,117,80,58,62,143,168,26,190,40,73,250,
175,199,47,37,61,34,127,140,254,233,86,255,249,105,240,135,59,41,169,199,135,94,159,38,3,52,62,150,253,66,247,71,51,253,231,63,98,51,51,168,93,227,108,9,92,221,65,144,32,103,72,73,187,2,68,71,235,229,101,207,159,186,170,24,197,52,139,49,254,49,243,31,211,63,193,118,19,85,251,3,130,63,165,168,170,118,156,36,167,79,210,22,206,167,64,52,1,198,29,228,48,148,69,62,185,16,177,118,50,51,110,10,141,93,179,232,79,64,119,176,92,32,152,109,139,165,20,131,39,219,73,159,113,249,232,20,227,166,143,37,4,247,241,167,41,96,238,77,198,105,29,83,208,21,223,9,20,147,194,227,151,71,60,94,20,31,3,78,243,167,161,107,203,162,143,232,159,166,181,69,25,127,123,190,192,15,35,183,224,38,153,87,109,44,158,29,167,239,28,67,94,199,124,226,151,72,40,158,26,198,17,142,53,90,209,47,181,113,24,187,105,252,4,49,40,189,63,65,79,229,230,79,208,195,203,27,49,234,92,254,21,253,138,221,78,51,254,118,132,156,216,88,14,251,109,142,132,127,160,35,250,63,34,247,127,36,250,42,104,159,104,121,60,193,126,57,64,229,227,147,
204,13,235,135,128,79,114,230,142,17,206,220,30,57,197,153,59,236,143,126,246,19,219,242,196,78,71,177,10,26,151,164,17,177,82,132,78,93,127,188,5,102,159,50,27,154,143,223,101,64,201,49,76,90,27,131,147,108,160,112,44,54,205,143,57,117,58,252,70,33,42,110,124,49,8,80,90,19,71,43,89,229,20,103,238,32,78,106,202,172,227,156,185,131,120,214,128,147,162,105,148,66,124,148,51,119,132,16,2,41,198,127,2,174,76,253,9,101,65,166,255,152,117,220,177,47,83,137,203,73,78,182,166,49,44,73,37,242,136,70,180,43,25,229,168,109,98,227,250,225,76,131,154,2,239,36,142,21,223,178,120,241,9,54,2,5,173,29,40,89,116,206,104,189,240,64,89,106,244,197,193,52,199,178,62,158,225,204,109,144,178,199,210,71,128,96,82,36,251,152,51,119,88,140,147,68,32,115,212,182,73,206,232,135,25,112,212,142,17,253,208,200,56,71,236,16,154,232,150,208,163,26,144,193,79,145,198,74,183,97,206,220,97,121,242,217,102,228,224,20,70,225,156,23,70,81,28,217,143,250,33,152,97,206,57,30,121,19,53,89,110,78,12,162,134,116,51,40,
225,110,220,169,36,79,120,217,228,82,67,0,167,56,115,135,36,156,60,13,58,130,36,50,253,105,12,233,140,237,49,161,98,89,82,245,52,169,168,137,51,211,105,233,243,153,210,8,161,241,17,90,17,24,6,78,188,39,57,115,71,117,206,28,29,161,26,155,3,46,51,7,229,197,24,103,238,65,181,43,155,223,79,80,195,217,138,76,206,86,14,118,33,127,238,9,135,57,115,135,41,96,102,131,114,230,246,192,143,208,220,9,41,147,136,198,96,213,19,13,197,242,40,169,111,95,72,115,103,16,33,229,32,231,204,29,65,14,91,91,175,248,226,4,103,110,243,31,229,160,11,50,105,126,138,51,119,96,83,57,141,125,177,96,99,7,99,23,91,159,224,224,108,236,143,37,147,82,128,237,114,136,192,58,102,233,139,187,176,148,188,243,166,134,8,85,35,195,28,118,131,42,39,217,24,145,40,226,115,74,161,227,26,174,248,24,213,50,53,76,245,58,50,53,8,157,147,191,38,212,41,17,52,58,103,110,75,149,139,147,232,164,92,111,88,72,12,25,111,76,188,164,246,176,204,106,94,164,183,201,148,76,249,88,132,99,177,35,16,136,190,193,153,251,195,63,228,204,253,190,
206,220,63,251,217,87,67,255,225,248,208,47,222,111,14,29,114,213,253,130,76,63,228,170,251,5,95,192,14,185,101,124,193,23,172,67,174,186,95,112,158,56,36,56,94,192,241,144,43,234,23,156,246,15,185,234,126,193,146,113,200,49,221,120,92,117,191,96,9,60,228,74,233,5,73,119,200,93,160,241,184,234,246,56,31,24,3,254,78,192,15,232,220,138,113,174,186,3,127,57,241,59,137,191,146,248,171,1,199,55,40,243,231,202,204,240,92,117,155,15,87,221,150,155,77,137,249,112,213,29,112,180,146,139,243,146,225,10,62,159,119,67,191,130,127,183,18,122,223,174,120,156,171,110,247,185,234,126,193,135,187,67,174,186,95,112,101,119,200,85,119,244,129,87,159,171,238,192,187,147,120,133,206,86,244,185,234,182,28,92,117,7,255,205,232,115,213,29,252,193,147,125,231,184,85,133,80,255,144,171,110,27,84,87,221,204,28,59,228,170,219,20,102,145,192,30,185,145,24,92,117,131,241,225,33,87,221,33,50,44,229,58,174,186,141,160,171,238,67,174,186,145,119,194,19,149,229,144,157,171,110,35,232,170,27,37,62,60,228,126,51,
148,130,130,149,74,37,184,234,126,193,149,246,33,87,221,49,79,95,243,92,117,123,156,171,238,23,53,250,92,117,135,4,244,37,1,79,184,12,207,173,139,157,193,85,183,241,184,95,12,21,152,183,210,140,91,98,90,5,21,207,185,141,199,85,183,199,7,65,184,22,240,92,117,7,157,205,228,71,112,30,193,135,191,156,197,103,2,7,33,95,252,204,159,123,58,195,113,213,253,130,207,5,135,220,149,68,144,50,46,57,184,234,126,193,210,113,200,85,183,109,207,85,183,231,117,213,253,66,5,231,144,171,110,67,114,213,109,141,35,188,251,131,48,231,170,59,198,19,174,132,39,87,221,47,230,161,204,85,183,37,231,170,59,52,165,149,164,92,117,187,207,241,60,194,159,113,167,79,9,215,156,231,170,251,5,55,184,135,92,117,91,14,93,117,131,88,57,228,170,219,38,229,170,251,5,215,70,228,103,58,159,248,21,3,174,186,61,206,85,183,251,60,128,181,32,92,117,135,96,68,147,92,202,223,105,186,95,66,129,171,238,192,171,39,29,226,84,244,185,234,54,63,174,186,45,56,87,221,1,135,1,108,122,20,145,2,37,223,185,234,14,250,184,78,134,40,134,225,
170,219,138,112,213,109,197,184,234,54,61,174,186,143,42,154,6,224,58,199,116,185,234,14,56,232,217,32,204,203,133,92,117,199,56,46,244,56,243,30,79,186,165,46,113,91,96,57,7,161,88,242,31,57,20,74,69,110,174,186,195,17,180,162,163,171,110,98,163,127,200,85,119,20,24,142,221,230,56,8,38,142,221,135,92,117,3,254,153,39,184,234,142,104,199,21,22,133,189,80,96,160,163,157,204,177,155,25,82,28,8,197,63,87,221,129,81,138,2,219,40,75,197,62,43,170,44,199,110,226,228,216,33,87,221,65,51,203,11,95,81,162,204,165,89,185,234,54,165,185,251,161,22,199,239,168,42,28,187,3,17,63,138,37,87,221,238,115,213,109,2,92,117,91,61,174,186,45,35,95,182,140,88,82,136,171,238,16,49,3,145,239,66,177,46,0,231,117,129,56,240,186,64,92,104,61,153,186,27,129,205,85,119,198,91,196,3,87,221,214,140,171,238,240,43,243,46,1,192,59,49,40,1,54,9,130,171,234,205,220,203,62,124,92,5,241,151,140,202,85,183,233,204,160,176,241,153,119,28,38,221,82,2,184,234,246,60,87,221,71,12,197,85,183,229,228,170,59,244,38,110,
228,27,174,186,195,30,244,165,79,225,195,85,183,199,185,234,54,31,174,186,45,7,87,221,134,155,1,94,114,76,17,38,90,119,10,93,174,186,99,28,185,188,30,209,58,174,56,118,35,192,159,254,240,80,215,133,22,101,130,157,153,101,152,212,15,49,215,117,97,140,112,116,241,136,46,126,130,14,121,97,58,236,110,18,59,20,152,164,146,24,23,198,82,168,56,82,215,133,96,246,9,213,144,72,215,133,152,144,200,198,52,198,224,64,16,40,156,46,76,83,155,119,234,32,209,2,81,113,27,100,73,22,218,65,124,110,22,226,168,39,51,232,186,48,136,167,29,117,93,120,148,184,174,11,77,148,235,66,51,225,203,142,171,49,215,133,14,45,62,65,122,124,92,249,163,152,210,73,33,204,33,73,37,178,174,11,93,217,117,93,104,98,186,46,116,96,112,93,24,1,177,24,118,40,5,128,235,66,207,115,93,24,1,150,142,211,117,97,12,148,116,213,117,161,105,150,24,211,117,161,65,184,46,12,30,98,239,168,43,146,233,186,48,44,198,134,44,144,57,177,216,36,186,46,12,6,156,88,98,68,63,20,212,186,46,12,130,159,103,116,105,64,6,231,186,48,194,137,163,75,56,
137,186,101,183,178,255,12,163,176,93,14,163,40,142,236,71,253,16,140,238,124,60,242,38,106,168,210,71,163,134,117,203,160,172,124,198,157,74,242,132,151,77,46,53,4,160,235,194,144,132,13,188,65,207,34,137,22,85,174,11,95,156,163,157,225,232,130,90,4,88,110,213,184,46,244,4,215,133,161,247,249,136,141,115,8,33,4,174,11,77,128,235,66,19,212,117,161,215,12,174,244,131,3,219,8,115,192,101,230,160,188,208,117,225,33,95,179,13,193,117,161,45,201,117,161,67,230,12,50,121,65,103,127,28,242,231,186,170,235,66,99,76,193,204,249,201,209,197,3,236,182,95,176,147,62,28,83,34,105,167,59,168,28,162,161,88,230,186,48,124,33,205,157,65,132,148,131,156,163,11,110,35,131,96,107,235,21,95,232,186,208,252,117,93,8,50,59,9,93,23,6,54,59,92,99,115,116,9,236,84,70,55,115,182,181,174,11,141,173,235,194,136,166,133,20,161,150,210,23,119,97,41,71,195,160,134,8,53,28,202,15,203,196,129,32,70,36,138,70,116,151,103,27,232,186,16,225,118,190,62,228,186,240,232,212,32,116,126,93,40,93,23,6,58,71,151,140,38,
126,140,155,78,202,245,134,5,71,23,195,232,186,208,106,235,186,48,120,145,222,174,136,37,83,116,93,24,9,207,117,161,244,231,232,242,255,4,0,0,0,255,255,3,0,168,59,66,203);


programfile__Classical2_MID
:array[0..6231] of byte=(
120,1,236,157,219,115,84,87,118,198,247,57,173,150,64,219,99,81,120,202,241,76,98,167,25,23,65,131,17,54,101,143,27,6,83,28,131,16,194,128,46,220,204,213,166,65,109,212,70,82,11,181,4,18,24,20,152,74,85,30,149,219,36,149,231,188,135,185,228,82,243,52,247,153,154,191,98,114,121,202,107,222,67,126,107,173,115,142,206,145,104,210,186,96,187,98,85,82,228,28,245,217,123,175,245,173,111,125,107,237,221,237,156,147,103,70,71,156,115,237,46,112,37,55,123,242,204,212,77,238,254,199,61,57,223,86,8,95,217,228,158,92,8,219,156,123,50,92,216,58,248,167,238,73,251,55,79,84,166,110,212,75,213,210,100,173,50,81,107,52,106,227,245,82,163,58,62,89,157,170,254,67,255,147,246,63,233,155,170,143,151,250,234,51,83,165,211,213,74,163,62,209,216,85,58,61,57,85,155,184,81,26,156,220,93,218,187,171,52,80,223,93,218,243,143,163,79,218,183,94,155,43,189,63,49,93,159,168,213,75,231,106,183,43,99,35,181,239,71,79,218,247,158,25,173,53,74,39,107,35,181,82,95,109,172,90,58,92,159,156,155,170,221,24,157,46,117,
31,254,118,105,207,190,125,239,150,24,56,80,173,141,149,14,237,46,157,30,173,142,141,212,39,74,167,167,118,63,98,206,195,227,149,185,210,181,106,233,147,169,106,117,108,174,52,82,107,76,79,213,174,205,76,87,71,74,159,212,167,74,19,245,137,158,235,245,241,241,234,212,245,90,101,108,151,222,143,215,39,170,211,149,169,185,210,76,163,90,170,79,140,205,185,39,111,58,67,97,219,35,247,100,91,16,184,39,5,127,174,86,31,171,177,76,125,172,238,126,218,237,30,119,204,186,206,200,93,113,238,210,108,240,36,192,169,137,210,169,234,13,150,3,135,145,210,80,101,170,50,94,229,186,52,48,51,126,173,58,213,112,79,130,87,250,48,224,84,125,172,50,49,82,58,125,184,231,59,223,193,233,107,83,149,233,58,159,253,209,233,234,116,105,102,178,52,112,106,104,64,13,181,143,170,165,83,149,233,106,112,61,8,174,109,98,149,173,189,149,233,74,233,200,196,52,198,30,198,11,102,114,237,189,124,240,106,179,225,189,213,177,202,156,142,239,108,54,254,197,103,143,159,156,30,213,241,155,121,236,181,229,235,239,79,156,40,13,
14,184,246,163,193,239,93,20,60,246,239,255,217,161,133,161,225,240,177,63,20,248,195,129,63,26,248,99,129,63,30,250,129,208,15,6,126,56,240,31,134,254,74,224,63,14,125,53,240,55,66,95,11,252,205,192,143,133,126,34,244,211,129,159,41,248,59,129,191,27,250,123,129,255,44,240,15,2,63,31,250,249,119,252,252,107,11,39,134,29,211,235,172,31,4,126,40,240,167,130,133,33,199,223,206,7,254,106,224,175,5,254,122,160,147,6,126,52,240,159,134,58,111,224,199,3,63,17,248,122,193,223,10,253,84,224,27,186,204,237,64,150,153,13,253,92,232,239,22,252,189,77,114,49,219,238,239,116,250,153,46,223,8,252,212,75,126,210,251,137,162,12,31,195,196,226,194,9,89,234,125,183,112,76,156,235,13,252,17,117,174,63,240,24,115,34,88,244,239,84,224,79,7,254,28,142,6,254,66,232,47,22,196,184,138,218,55,18,250,79,212,184,90,193,223,12,101,222,137,14,95,15,252,100,224,111,177,36,198,5,126,58,244,51,161,23,251,48,40,240,115,128,17,40,24,5,127,31,36,190,187,112,204,185,33,65,2,19,64,22,24,64,19,223,111,168,157,50,147,
186,57,99,14,166,163,129,178,224,231,187,23,6,100,40,227,176,242,99,5,108,60,6,145,213,25,35,203,133,254,179,80,214,18,236,123,136,37,3,44,150,230,241,241,96,97,64,160,56,169,147,224,231,69,13,40,30,2,63,238,97,200,167,26,83,144,171,135,25,199,116,129,219,230,85,65,189,42,72,136,101,37,28,59,238,31,180,251,123,237,18,141,57,239,239,20,253,157,173,126,166,221,223,238,242,115,155,253,236,22,34,93,120,236,239,20,60,19,204,188,236,251,220,66,191,196,1,236,129,249,178,58,131,5,172,61,30,46,67,212,22,6,144,130,34,74,196,161,87,91,226,229,126,127,31,59,218,252,61,108,130,15,202,10,176,7,12,232,72,64,136,12,168,66,33,252,25,45,44,28,143,177,239,83,248,1,225,76,176,208,47,120,8,18,102,74,40,72,140,168,53,16,17,118,11,18,58,203,20,228,3,0,93,70,140,128,227,64,93,240,15,218,252,124,175,0,126,159,191,96,74,98,7,70,176,252,68,184,112,60,14,58,25,69,220,33,29,11,19,122,162,200,178,23,224,64,40,225,132,6,198,47,97,86,102,77,188,96,38,225,148,122,39,43,19,100,8,5,43,128,190,215,207,107,166,113,
139,69,36,2,143,241,48,67,204,125,108,191,222,102,169,118,200,45,156,25,38,203,251,66,77,229,192,95,210,176,227,236,104,40,97,199,83,91,24,179,133,204,182,170,197,28,220,141,201,234,166,184,252,234,194,41,65,19,167,160,22,78,225,209,185,96,225,140,160,73,72,63,82,16,107,40,131,162,128,81,4,7,3,49,115,126,151,241,18,53,128,154,132,130,4,28,12,22,78,201,200,225,192,159,85,88,206,147,124,26,16,38,50,125,192,76,35,40,147,2,145,133,37,181,20,127,97,136,173,17,131,115,214,223,239,242,159,109,86,110,108,246,115,69,63,187,201,223,129,148,155,253,76,135,159,238,244,83,155,252,173,45,74,143,130,72,24,244,35,197,175,20,13,171,138,35,219,224,40,81,177,204,96,85,33,67,158,160,146,239,134,146,177,211,196,207,88,129,163,23,204,81,236,207,112,202,18,80,100,83,225,158,52,97,83,184,101,174,148,230,8,27,124,34,206,237,26,231,179,30,147,142,199,38,41,22,102,40,102,163,194,68,15,23,176,78,52,4,53,10,147,0,182,249,89,77,13,153,203,132,225,124,172,197,97,44,12,189,129,16,244,177,63,18,138,222,247,135,
137,36,106,68,137,199,105,201,18,127,174,224,47,135,18,213,171,200,160,130,101,50,136,96,33,202,8,191,144,178,221,207,247,139,84,161,10,44,118,111,179,112,134,144,220,233,16,85,196,44,20,133,176,225,58,153,133,221,85,205,53,50,159,122,194,204,151,94,178,252,132,75,199,117,113,150,61,31,152,116,195,84,158,32,24,169,10,227,49,212,182,248,91,12,200,76,254,87,28,53,142,18,128,111,33,248,198,81,38,37,217,152,163,26,187,203,96,83,205,165,82,109,138,86,65,170,139,42,159,208,20,130,147,172,84,42,179,1,26,2,185,129,109,73,98,90,207,210,146,148,72,245,136,97,12,158,3,10,32,230,95,137,165,26,119,171,10,192,167,5,49,64,198,171,96,128,223,253,54,255,224,154,89,124,40,140,75,212,177,24,0,205,17,173,77,73,98,164,133,201,248,9,158,100,49,118,25,179,114,68,77,216,16,227,100,149,194,210,153,85,85,62,230,7,22,134,5,42,188,77,51,250,131,64,234,149,22,139,65,173,254,103,66,1,17,28,210,212,68,183,140,221,196,82,212,75,117,36,205,78,33,99,158,222,49,216,86,65,140,146,134,216,163,125,170,160,16,7,187,
54,249,187,84,14,50,129,90,178,73,139,70,167,159,126,209,55,138,126,234,69,127,171,232,39,11,210,18,224,34,156,167,85,96,213,79,130,133,97,49,21,116,81,59,173,147,169,39,40,140,176,58,244,39,105,100,18,229,21,74,107,137,39,52,16,251,138,22,33,131,212,114,85,188,33,206,121,135,140,110,196,76,144,52,97,204,20,105,65,18,69,238,55,26,163,109,240,134,5,161,206,133,184,236,178,152,21,110,224,34,78,54,29,106,157,149,71,225,207,245,84,33,153,2,22,81,243,9,134,166,41,68,160,124,72,60,66,153,153,236,60,107,130,169,165,132,192,8,215,10,178,12,88,136,122,89,175,86,200,197,6,81,134,255,147,29,49,3,165,103,209,214,77,120,140,210,23,53,139,140,26,29,126,254,209,183,52,54,20,90,210,252,37,127,247,27,126,182,203,223,249,154,140,161,223,154,46,248,70,155,76,71,106,19,121,226,1,116,8,20,185,66,109,35,129,135,92,81,187,63,252,160,226,91,4,176,249,195,148,70,97,220,100,153,194,11,234,9,139,105,43,153,88,96,66,99,180,180,197,22,166,228,181,242,59,104,89,67,200,65,221,248,11,94,218,244,177,222,176,
193,20,10,115,53,19,5,157,52,125,88,85,200,171,185,131,168,16,22,43,45,66,94,77,81,74,161,37,78,76,222,180,20,178,54,26,243,65,74,55,91,91,221,180,196,33,74,196,71,28,85,129,35,32,44,70,162,2,19,17,96,1,17,0,237,23,5,117,243,41,213,144,239,189,232,31,188,40,154,16,183,55,69,63,167,98,14,234,2,185,14,158,12,173,154,128,19,115,146,7,148,248,164,181,162,8,179,26,104,198,74,169,34,128,35,112,13,16,109,53,97,236,141,133,94,73,252,40,144,220,239,141,251,19,235,138,48,158,16,2,214,53,13,170,133,37,14,136,74,151,204,149,183,124,254,170,73,31,88,32,185,128,79,150,93,14,22,122,37,57,97,35,212,16,125,210,58,133,243,196,84,2,170,230,144,248,146,61,35,82,231,180,77,71,38,89,145,22,87,227,8,9,210,40,196,61,16,80,33,214,55,4,235,179,226,2,198,15,105,71,141,223,172,2,190,160,68,178,166,113,187,103,181,129,65,170,209,42,19,176,133,236,130,22,58,104,225,172,24,138,139,140,140,157,211,146,18,139,100,45,77,109,160,193,62,37,139,133,192,162,217,32,37,172,33,80,100,230,58,36,147,30,84,44,157,1,4,70,
192,2,70,142,197,233,44,70,66,108,43,1,169,32,130,195,13,107,175,136,9,18,192,48,162,240,105,92,66,48,143,69,0,78,106,174,130,48,95,163,125,10,126,63,63,143,206,92,194,1,139,36,194,71,194,29,79,4,67,212,34,100,159,199,231,75,84,124,81,247,66,230,224,243,88,252,112,80,155,10,22,188,21,143,52,68,137,155,212,43,92,35,1,100,76,167,139,58,91,254,183,248,88,123,214,54,198,177,45,208,6,222,204,138,187,120,72,81,224,179,54,182,12,154,28,211,5,62,230,14,218,32,42,231,10,2,120,82,154,201,54,192,193,1,99,11,89,128,177,210,169,103,68,85,26,31,236,124,88,241,15,6,116,57,47,214,67,34,41,49,128,175,187,75,170,9,209,100,22,88,74,143,115,78,119,188,67,33,234,245,104,52,217,70,65,20,4,214,22,35,177,208,9,224,160,14,44,166,148,5,132,58,78,4,247,202,42,210,144,171,118,145,231,200,36,150,221,98,215,216,46,249,63,78,219,169,20,162,200,140,178,69,29,46,234,134,184,182,197,127,218,238,111,106,79,202,35,38,129,84,188,197,74,202,124,84,69,28,164,165,109,243,115,47,249,217,78,69,42,89,71,22,129,254,244,
222,186,2,249,143,177,55,58,82,141,36,79,72,76,232,144,116,87,72,5,94,227,187,213,239,84,255,68,158,210,180,211,198,20,208,132,113,166,186,231,37,243,20,27,20,150,12,98,14,214,98,52,227,4,152,52,243,82,181,38,243,8,196,78,83,76,204,32,35,78,170,70,82,32,213,121,209,26,149,72,194,129,15,204,98,76,71,34,44,121,31,188,145,150,70,136,141,58,33,167,245,184,186,154,185,86,201,76,80,197,86,35,233,195,30,63,239,253,131,162,246,166,218,173,74,240,149,36,82,198,212,81,86,99,10,129,142,57,51,253,5,22,125,92,16,251,250,69,101,72,71,208,195,99,147,70,186,5,76,16,33,208,90,197,76,176,193,20,77,210,147,102,216,202,196,85,127,56,238,223,175,168,214,160,107,253,142,205,88,236,165,150,95,97,233,77,243,143,220,133,215,44,1,219,70,98,173,176,117,96,142,52,221,137,202,200,82,172,211,150,56,122,205,244,23,112,79,37,108,29,141,193,37,50,177,109,26,69,9,197,195,110,83,52,4,227,172,106,12,76,185,25,43,110,154,66,113,254,236,241,39,99,101,230,81,212,146,158,75,59,18,166,197,9,162,189,216,125,91,156,107,
41,63,152,254,144,22,23,210,149,36,34,114,39,64,177,32,46,14,169,161,167,109,147,97,231,46,90,47,225,36,64,145,239,108,14,40,63,210,148,105,39,131,52,217,193,19,84,147,99,24,50,196,154,25,181,194,152,39,164,181,99,24,149,201,92,113,181,104,124,215,80,138,18,187,128,251,104,140,18,156,196,196,19,133,184,205,2,69,140,59,27,74,44,72,254,203,180,86,24,164,0,144,48,38,148,233,113,149,153,2,26,216,17,103,78,162,14,196,73,248,96,132,60,102,185,200,242,32,67,5,98,249,124,163,15,189,78,135,18,146,243,74,130,20,12,216,32,107,91,79,167,245,17,24,80,145,20,3,219,249,45,97,161,228,0,21,111,48,109,241,9,6,171,194,145,35,113,139,79,92,62,176,82,145,244,200,88,112,38,211,91,114,18,38,199,20,233,194,218,120,199,172,39,85,33,36,89,148,250,106,61,1,13,99,187,42,47,201,19,239,45,88,18,112,9,59,7,47,218,176,3,41,57,15,155,144,30,166,19,114,39,105,159,170,42,130,161,123,19,179,154,252,203,68,11,171,161,146,4,73,225,250,16,184,116,131,132,28,25,125,208,242,10,160,97,56,187,86,132,214,122,122,221,136,
10,104,102,187,42,103,218,137,160,52,210,88,60,188,237,31,188,224,239,119,104,219,139,71,28,51,118,168,100,64,45,6,116,72,14,18,103,236,21,177,48,37,87,49,128,171,151,218,204,61,142,28,7,134,41,114,152,222,155,236,172,7,57,126,9,227,198,253,82,135,48,59,38,146,29,163,114,74,166,169,20,55,57,86,102,7,165,179,211,221,191,185,15,91,244,28,15,223,97,39,94,95,12,229,212,5,28,17,137,154,218,98,222,89,76,36,3,104,36,205,175,139,162,68,103,228,36,129,185,52,240,150,199,108,143,152,11,248,8,136,25,197,92,224,5,195,228,144,194,142,94,45,196,26,95,180,77,36,36,62,7,50,34,19,95,102,228,148,81,207,129,200,109,40,76,136,43,122,98,0,79,193,203,116,92,164,110,23,86,88,179,114,56,140,99,170,135,64,48,68,194,90,16,157,133,42,41,88,231,44,29,194,184,137,71,27,72,7,11,174,133,53,61,177,140,115,79,245,14,85,18,141,212,244,147,68,160,50,63,228,255,116,106,100,57,174,235,144,207,36,178,90,169,193,126,186,67,99,170,138,46,165,153,44,87,112,79,183,139,87,25,38,43,118,137,145,22,8,221,99,224,48,177,0,
69,204,75,129,52,141,128,38,117,173,47,176,6,44,96,16,169,106,29,132,9,185,112,15,92,49,114,72,42,142,2,100,188,7,21,116,147,156,52,24,68,9,216,212,105,120,104,140,136,54,85,75,114,71,79,41,169,105,248,99,78,19,246,7,23,44,32,144,72,143,247,15,107,221,37,107,210,233,62,210,77,216,53,165,144,4,92,205,131,60,134,30,86,73,168,43,86,164,33,245,89,161,15,81,51,6,73,192,10,146,135,80,8,118,15,209,62,21,132,148,112,233,18,123,107,101,84,165,160,178,69,150,147,123,236,223,19,123,133,87,36,148,22,99,104,154,106,228,252,65,233,197,143,201,121,165,81,43,33,190,160,0,79,57,139,128,91,178,136,246,30,0,30,175,179,68,157,211,13,188,98,148,93,86,192,239,16,240,169,111,34,143,71,40,87,179,122,94,20,37,186,156,186,199,154,184,55,144,124,13,194,250,68,193,22,183,104,179,184,212,42,229,163,109,185,33,141,181,83,113,116,52,133,56,140,19,32,7,36,157,245,124,145,132,97,145,254,88,134,161,61,43,157,164,42,234,17,173,8,112,152,241,177,32,107,72,224,67,201,244,170,102,167,36,187,238,254,82,6,192,43,227,
63,141,173,48,192,54,61,39,101,201,97,9,91,154,163,170,32,144,0,63,46,81,106,85,40,225,171,101,253,77,173,43,134,151,21,21,194,196,116,34,34,31,179,201,36,113,179,188,60,25,235,57,41,63,172,122,76,124,206,37,217,192,236,18,156,130,36,107,12,78,178,12,92,163,213,37,45,48,223,114,66,216,64,226,106,235,44,235,113,0,209,103,91,84,120,0,86,96,175,6,219,22,21,145,55,210,162,237,50,87,182,20,102,242,75,180,221,242,1,243,141,204,87,172,11,101,70,80,39,154,48,232,234,226,70,213,64,176,208,153,93,146,168,105,3,5,172,246,253,7,115,85,210,142,11,138,224,63,132,248,56,150,103,67,147,16,217,68,160,153,206,117,39,219,37,154,81,108,157,217,196,185,171,80,254,40,106,127,137,88,49,99,154,162,204,43,225,143,55,98,16,192,154,15,102,55,248,36,255,217,41,93,37,50,38,214,88,12,140,226,186,108,160,248,179,148,20,139,32,140,111,227,81,217,182,181,252,47,59,176,7,237,233,32,166,147,157,155,130,202,18,184,51,29,91,54,213,41,245,68,19,9,134,128,239,160,58,65,208,240,0,42,64,2,59,79,0,99,99,89,142,186,148,
86,131,57,141,23,95,54,60,228,75,68,82,135,46,87,191,250,193,11,124,33,162,228,19,65,129,238,144,30,104,129,128,185,198,68,177,165,247,124,44,242,203,114,164,37,200,193,244,225,134,53,94,218,64,72,220,73,53,26,7,36,4,211,46,147,194,122,16,196,20,204,104,193,70,255,82,200,230,63,242,239,115,224,34,212,239,55,61,48,166,199,201,43,106,7,197,181,87,37,55,137,14,14,18,29,14,122,113,211,98,36,249,164,237,3,197,147,175,7,180,173,49,181,1,167,163,98,143,213,117,72,46,153,175,29,151,204,162,205,17,83,208,101,197,166,169,251,162,92,151,165,211,208,124,100,34,0,39,189,113,175,95,149,248,44,93,155,213,32,59,178,103,26,221,215,212,245,68,222,180,253,174,230,152,168,210,137,52,205,168,15,199,52,145,63,140,191,31,3,68,18,140,250,10,194,64,141,116,146,166,148,7,64,154,213,2,42,178,64,128,46,26,60,100,42,150,136,25,178,89,178,211,31,50,3,65,160,79,129,2,136,0,192,0,6,19,89,94,89,118,202,44,150,157,241,49,18,19,73,223,20,31,115,201,20,73,168,168,124,24,2,237,176,63,142,208,39,73,254,144,59,196,
200,150,39,200,36,209,89,109,29,88,25,30,84,98,158,90,140,152,199,232,39,62,233,132,179,124,46,73,100,19,223,7,98,176,41,146,65,173,167,74,246,73,178,121,126,51,51,74,250,104,51,135,147,247,98,19,240,154,101,33,46,38,16,93,136,91,227,75,202,56,121,240,157,56,128,96,214,120,83,127,76,135,21,169,233,0,129,233,146,54,218,235,196,112,24,144,143,182,104,218,108,78,186,88,125,130,180,1,185,219,237,201,73,98,187,28,169,179,129,189,185,89,66,195,26,36,2,122,120,73,178,232,207,247,202,113,205,79,217,171,118,140,4,157,81,112,169,59,184,226,226,159,54,180,71,241,111,20,226,139,205,1,23,162,53,233,47,49,94,120,45,249,37,198,230,248,151,24,199,142,185,159,117,187,31,116,244,185,206,139,27,191,195,200,255,14,163,47,248,55,23,61,186,244,23,189,81,15,39,166,71,162,174,35,206,181,126,125,44,234,66,244,142,70,61,71,87,62,54,187,214,122,205,99,115,246,71,61,124,197,110,115,30,143,122,96,247,137,168,139,35,221,214,175,135,162,46,90,225,129,168,135,134,101,165,99,179,207,175,215,60,54,167,217,115,
60,234,82,143,122,240,104,32,234,82,11,87,127,29,69,61,145,115,135,162,174,67,206,173,229,250,68,180,122,27,178,99,91,143,81,22,231,231,119,125,44,234,129,225,134,249,151,225,58,203,237,213,93,175,47,127,190,60,241,202,106,200,74,175,179,252,89,233,216,102,207,103,245,109,165,215,217,57,87,58,118,249,243,89,158,172,37,94,207,67,127,178,185,191,186,235,181,231,166,173,107,152,155,143,89,221,94,233,117,150,75,171,187,206,226,60,20,245,80,137,134,163,46,90,238,47,195,245,145,168,135,14,225,104,212,165,21,127,53,215,134,243,90,120,152,29,219,76,147,179,156,127,246,245,250,234,225,6,62,207,238,73,214,210,99,228,199,62,186,19,185,71,23,127,230,130,31,216,46,129,45,2,27,5,251,1,244,83,119,9,52,186,139,187,132,206,255,78,118,9,47,148,74,165,193,169,235,163,85,126,255,93,113,191,122,203,253,83,199,123,174,243,235,182,81,120,52,250,55,173,119,195,89,229,93,47,5,95,175,121,204,182,108,38,100,179,168,245,235,172,26,174,78,221,108,173,245,154,199,108,200,42,230,234,170,200,114,214,230,217,
182,250,46,121,189,236,105,61,70,107,137,75,235,99,155,41,239,23,245,247,44,183,87,119,189,190,149,224,203,19,175,172,134,172,244,58,203,135,149,142,109,246,124,86,39,87,122,157,157,115,165,99,151,63,159,229,201,90,226,245,60,244,103,237,186,177,209,25,127,158,29,243,70,231,183,188,134,102,57,188,129,207,179,241,89,175,126,35,138,180,51,190,240,43,71,39,59,146,252,167,135,221,255,119,235,251,235,183,220,63,75,235,219,157,180,190,223,223,104,125,179,229,111,189,90,214,245,154,199,108,123,30,165,103,189,168,152,77,255,181,92,175,165,52,63,143,177,95,84,139,219,108,221,108,27,179,186,235,141,214,215,190,196,202,182,151,217,220,207,254,125,45,215,203,91,208,214,53,54,187,238,90,230,177,177,89,158,172,37,71,158,135,254,172,69,43,108,236,70,235,187,209,250,46,231,64,150,243,207,190,94,95,61,220,104,125,63,223,214,247,215,142,78,246,105,173,175,63,157,156,250,118,166,191,13,57,230,126,222,237,126,40,63,14,121,109,227,199,33,75,127,28,242,239,242,227,144,191,92,93,63,152,173,81,107,249,
129,193,122,205,99,54,100,235,237,179,53,192,234,237,242,103,150,247,5,203,159,105,54,54,251,247,245,154,199,230,180,26,222,31,117,233,79,95,214,231,71,11,7,162,158,3,206,29,140,186,14,58,183,150,235,102,125,235,74,255,126,40,42,31,114,69,251,215,250,142,236,94,234,217,215,203,251,59,195,109,165,127,207,218,176,210,62,101,237,117,192,190,120,61,24,149,15,186,162,253,219,122,239,182,156,255,217,92,88,233,117,95,84,238,115,197,229,255,54,195,179,47,122,175,207,185,103,255,107,54,244,69,93,60,217,250,117,54,142,43,29,155,125,126,189,116,102,189,230,89,30,175,213,233,204,243,211,135,149,230,239,242,231,215,242,67,2,27,107,115,26,230,173,231,66,86,123,179,215,134,213,122,225,124,60,42,31,119,197,103,255,187,82,13,105,246,252,161,168,135,159,240,245,70,93,252,140,243,139,189,78,248,255,30,150,244,70,79,255,183,63,122,111,29,235,212,23,235,111,22,243,207,223,247,181,212,229,252,216,71,119,14,240,131,138,159,187,224,135,45,254,160,130,230,48,115,170,188,35,105,173,243,63,168,248,205,
91,238,95,228,84,121,40,57,85,254,219,141,110,50,171,50,235,165,62,235,53,207,243,171,22,121,182,173,190,179,92,94,69,150,239,244,91,121,38,219,201,109,116,147,27,221,164,117,156,198,127,235,98,179,221,225,74,175,147,74,32,255,89,197,255,167,221,239,243,211,135,86,114,246,217,207,108,116,147,205,186,195,149,254,253,171,220,81,125,149,125,95,175,26,125,128,31,33,208,77,94,248,141,163,251,123,218,73,108,103,147,118,241,183,111,185,127,149,118,113,36,105,23,255,110,163,93,220,104,23,215,66,203,103,151,140,214,91,199,141,118,113,227,240,113,249,161,228,70,187,216,202,97,217,243,248,114,98,237,121,189,209,46,174,180,45,108,246,252,87,185,101,250,42,251,190,150,186,156,31,107,237,226,111,29,221,223,211,218,197,194,135,201,233,98,81,190,184,175,184,95,124,219,253,72,250,196,249,141,239,236,151,126,103,255,31,46,250,222,31,252,213,129,168,124,192,21,15,68,141,3,238,225,190,230,55,123,163,242,94,87,220,27,53,246,242,88,243,155,230,19,228,62,217,31,149,247,187,226,254,168,177,159,217,162,
168,28,185,98,20,53,34,110,246,69,229,125,174,184,47,106,236,227,38,249,254,178,113,112,233,162,185,217,114,55,205,199,228,172,206,141,201,221,180,248,88,210,230,53,14,45,53,180,55,42,247,186,98,111,212,232,229,147,220,99,185,117,114,159,228,22,205,221,228,198,228,208,201,61,150,187,201,141,201,220,220,143,183,91,23,127,225,130,31,181,120,120,15,75,22,15,239,51,233,117,184,58,198,123,107,126,185,211,253,88,210,203,109,164,215,210,244,250,79,73,175,191,222,19,149,247,184,226,158,168,177,7,50,52,191,217,21,149,119,185,226,174,168,177,139,199,154,223,52,159,32,247,201,155,81,249,77,87,124,51,106,188,201,108,239,68,229,119,92,241,157,168,241,14,55,61,81,185,199,21,123,162,70,15,55,111,71,229,183,93,241,237,168,241,246,210,69,115,179,229,110,154,143,201,89,157,27,147,187,105,241,177,119,163,242,187,174,248,110,212,120,119,169,161,57,166,231,30,203,173,147,251,36,183,104,238,38,55,38,135,78,238,177,220,77,110,76,230,230,254,30,78,51,246,240,221,216,47,93,240,227,22,211,11,150,100,210,
235,114,82,189,58,15,215,121,39,83,229,90,165,209,112,191,123,195,253,164,163,156,252,7,26,27,239,134,146,23,92,233,187,161,250,130,255,146,28,251,251,237,81,121,187,43,110,143,26,219,225,74,243,155,82,84,46,185,98,41,106,148,120,172,249,77,243,9,114,159,188,30,149,95,119,197,215,163,198,235,204,214,29,149,187,93,177,59,106,116,115,179,45,42,111,115,197,109,81,99,27,55,59,162,242,14,87,220,17,53,118,44,93,52,55,91,238,166,249,152,156,213,185,49,185,155,22,31,219,25,149,119,186,226,206,168,177,115,169,161,57,186,231,30,203,173,147,251,36,183,104,238,38,55,38,135,78,238,177,220,77,110,76,230,230,254,118,114,108,59,57,246,59,23,252,164,197,28,131,37,139,57,230,190,33,57,230,120,1,219,11,111,28,88,252,159,204,3,95,79,30,232,136,95,37,151,249,236,229,228,51,254,127,134,233,235,229,118,240,30,182,228,221,110,153,169,179,111,171,203,60,240,82,50,188,221,94,96,151,249,104,209,172,193,201,153,70,252,86,187,61,153,7,182,38,99,139,250,186,188,204,39,139,67,23,253,121,227,64,230,129,63,76,
134,190,152,127,17,94,230,145,63,78,30,217,42,175,196,91,124,65,158,188,28,47,243,216,235,201,99,47,63,253,133,121,153,71,95,77,30,221,50,193,139,245,34,222,136,119,151,215,226,237,230,93,121,153,135,190,153,60,244,181,220,91,246,50,79,188,146,60,225,51,111,222,203,124,190,37,249,188,192,219,248,50,127,95,244,57,255,134,190,204,35,139,184,201,35,201,75,251,50,15,44,70,59,121,145,223,238,204,167,139,195,155,192,190,136,192,210,247,244,181,52,203,255,10,0,0,0,255,255,3,0,151,139,107,76);


programfile__MAGGIE_MID
:array[0..11925] of byte=(
120,1,236,125,91,115,27,73,150,222,225,181,0,130,164,120,191,72,164,8,138,197,18,192,18,200,98,9,16,4,161,8,1,4,65,128,32,192,194,93,0,113,101,75,16,41,85,171,91,45,141,186,213,173,233,65,20,41,206,70,216,47,173,8,73,29,227,159,224,39,181,45,105,99,252,180,142,240,37,194,254,11,126,233,39,253,3,191,142,191,44,144,20,186,71,227,221,88,239,218,187,94,68,204,180,192,172,204,147,39,207,45,243,156,60,167,42,158,57,184,67,68,189,212,65,102,250,155,120,230,145,134,191,166,233,79,249,238,238,206,41,19,253,169,208,137,191,255,148,236,226,166,254,7,253,105,133,154,29,6,190,164,63,205,119,160,189,171,71,77,133,3,59,71,51,111,208,203,74,244,55,35,244,134,147,59,250,150,169,152,56,92,224,22,172,220,130,131,187,116,213,178,61,110,9,15,91,54,134,44,129,97,139,239,249,183,63,4,27,20,105,80,172,161,91,222,112,11,53,139,95,47,90,214,231,45,33,253,235,31,130,212,19,161,254,24,141,132,26,20,109,80,188,113,156,137,210,149,72,99,255,141,101,125,196,226,127,238,251,33,68,55,227,212,7,8,177,198,243,
155,24,254,13,199,219,127,136,209,124,172,65,106,163,47,72,119,222,112,124,138,227,117,149,91,212,93,248,255,220,15,17,26,80,105,200,128,70,201,198,72,140,142,175,71,105,60,78,243,192,33,222,184,250,134,19,186,44,33,59,39,0,139,173,115,156,144,98,232,238,12,115,151,131,150,68,204,146,138,88,178,61,220,229,49,203,173,105,0,162,55,150,66,199,15,113,234,74,210,192,27,75,113,214,82,49,253,96,172,4,115,155,222,112,182,94,75,109,219,114,123,144,179,153,44,119,167,56,155,217,114,176,192,217,199,44,247,251,185,165,243,150,47,122,57,113,210,242,208,204,93,153,181,60,234,228,150,25,102,29,111,184,149,46,160,111,86,241,211,242,155,49,78,26,56,3,216,251,198,242,205,0,183,58,199,201,203,150,111,7,209,137,34,212,171,82,223,27,203,179,203,150,239,207,91,26,29,103,93,119,84,246,176,35,70,95,133,13,186,169,13,27,122,13,91,190,62,26,252,33,76,83,0,30,110,88,163,228,7,17,212,134,62,16,166,225,40,153,84,58,15,42,27,68,56,82,66,196,135,26,151,226,212,25,33,197,104,210,251,66,116,9,48,227,52,122,202,
174,231,219,65,26,127,99,121,122,201,242,221,69,240,112,35,70,51,241,134,253,141,229,183,238,31,98,141,169,56,153,129,223,27,75,163,11,92,188,22,105,212,130,13,253,124,144,132,96,99,54,66,231,99,100,71,83,172,113,33,72,150,8,205,198,104,246,20,211,231,125,97,154,81,201,28,165,225,211,38,125,46,10,140,25,81,38,79,49,124,62,25,162,254,56,147,142,169,211,38,221,20,162,139,113,234,142,208,196,41,134,199,106,144,73,79,127,132,166,155,77,113,54,231,64,132,46,196,233,122,164,49,21,164,243,17,90,54,30,245,196,72,95,12,178,161,232,81,139,55,134,131,212,29,163,137,56,245,70,104,197,160,0,132,229,88,139,211,112,4,83,48,113,3,233,58,146,116,156,49,8,61,168,210,204,89,47,72,36,16,155,78,210,130,65,96,74,55,142,106,201,198,152,74,163,105,242,168,13,95,148,46,69,27,158,36,117,169,196,199,27,12,238,118,156,6,162,212,159,164,25,172,217,0,125,28,15,211,96,140,49,120,238,84,84,143,31,69,169,27,194,158,107,28,94,200,81,79,188,161,131,129,250,82,146,186,163,212,23,167,131,51,29,81,67,52,26,167,139,
0,165,54,142,119,162,100,14,19,167,210,165,179,231,133,16,245,26,19,142,157,82,248,216,173,82,47,40,28,165,27,103,179,21,163,76,174,123,226,31,89,115,156,50,196,132,194,36,156,82,224,95,95,53,132,16,164,10,158,193,42,168,212,137,177,97,99,70,131,40,199,137,16,157,131,154,68,232,226,25,107,66,6,129,193,26,241,148,53,135,93,152,11,86,0,171,2,55,32,121,133,72,99,32,72,233,96,195,5,54,71,105,212,152,225,184,8,158,98,65,81,195,40,52,193,103,0,30,120,196,105,242,20,175,227,205,24,117,68,168,79,61,101,158,218,56,196,82,46,0,252,57,149,86,213,6,48,46,197,26,227,17,218,142,52,110,26,44,236,81,233,194,169,44,29,111,134,24,163,33,97,179,167,8,31,142,199,200,162,54,134,34,164,75,144,144,8,172,21,172,147,202,38,6,172,217,211,145,135,137,100,227,104,48,66,102,195,42,116,134,232,140,198,71,144,131,67,176,176,35,205,104,211,193,68,156,25,28,198,254,123,81,226,146,52,132,245,25,188,239,140,211,241,122,152,73,46,169,36,157,177,237,115,0,67,231,223,130,225,161,198,241,86,136,41,227,53,140,193,210,
172,0,61,31,166,106,184,225,73,147,41,76,166,40,77,194,6,156,14,61,194,36,135,169,16,117,39,153,160,244,71,127,133,212,205,52,230,102,20,133,64,94,62,29,115,28,8,17,16,57,23,165,229,51,206,166,0,19,168,71,201,113,74,149,35,172,96,50,70,91,177,198,52,244,46,78,171,145,198,116,144,194,193,198,241,151,65,198,128,174,24,61,80,27,88,57,229,26,199,16,140,222,28,113,105,58,111,44,155,50,141,227,80,134,6,146,108,33,142,51,206,85,85,130,81,134,253,58,7,93,52,140,68,33,70,28,147,246,88,3,202,8,21,135,69,234,9,82,49,216,152,136,144,41,72,125,49,186,126,170,104,199,105,99,21,67,173,115,172,37,49,156,150,50,0,203,136,197,166,13,64,190,50,140,186,107,152,32,202,84,30,58,20,137,208,112,12,66,122,194,133,35,59,196,2,11,142,49,235,213,100,212,115,127,166,161,143,27,74,97,201,48,97,98,180,159,129,0,100,26,71,203,25,26,138,17,148,124,240,180,247,113,0,98,96,116,94,61,69,239,208,154,107,28,5,115,108,102,136,65,15,184,116,42,3,71,185,36,35,183,41,201,140,207,104,148,226,209,198,149,56,13,25,202,109,
53,38,58,162,112,227,48,164,18,135,237,176,169,91,198,216,223,131,183,67,113,58,28,138,55,70,162,164,47,71,27,150,16,101,67,141,223,194,64,38,105,44,202,52,120,238,140,169,187,81,72,5,211,20,235,41,83,153,236,28,157,55,140,68,119,154,45,152,209,178,41,150,174,56,141,36,153,81,144,206,240,135,101,238,206,53,250,210,164,95,75,55,106,106,3,240,99,209,134,156,99,18,7,91,5,8,51,103,195,153,133,131,253,140,146,239,116,174,227,64,152,153,6,104,229,213,51,42,127,167,18,180,176,35,216,48,199,232,86,164,1,221,130,234,66,64,192,19,180,7,96,239,34,141,217,32,5,177,125,72,49,26,82,217,3,108,25,217,72,99,12,18,6,155,202,88,70,174,211,89,159,251,115,13,29,130,56,148,99,51,67,171,6,78,113,63,186,145,38,33,221,24,85,105,86,109,72,216,249,85,218,81,27,142,36,245,166,25,82,157,42,219,146,200,32,245,115,136,237,69,88,94,144,1,251,163,63,214,48,197,73,215,34,4,19,48,174,66,75,24,150,232,137,13,86,63,7,89,140,81,49,198,224,198,241,32,194,108,2,88,196,255,2,33,208,176,15,19,229,152,253,94,56,149,143,
195,20,248,13,173,129,230,159,226,120,88,198,182,151,102,59,157,249,20,151,163,188,74,166,76,163,150,96,150,98,52,65,206,24,77,101,176,240,198,84,146,34,177,198,209,45,40,7,12,46,80,221,105,112,59,84,136,53,176,167,65,161,66,145,198,85,131,52,75,103,212,111,27,230,182,97,110,49,204,59,111,44,223,15,91,158,226,40,121,98,22,187,222,88,30,13,89,190,24,177,220,215,93,150,187,19,150,219,170,101,239,146,165,186,100,41,141,88,118,173,150,252,138,37,123,209,146,154,183,36,126,99,217,241,254,96,136,121,55,204,96,211,152,195,190,171,57,234,132,193,138,147,216,108,130,161,221,137,19,14,73,60,172,252,233,36,199,185,24,245,25,182,215,122,214,180,14,115,104,88,100,239,41,44,186,213,56,127,139,142,21,99,23,229,114,100,61,131,56,103,236,97,11,25,40,194,9,218,135,143,222,88,18,57,75,38,104,201,173,91,242,162,165,52,137,195,49,151,33,44,167,218,9,52,173,111,44,183,39,44,7,67,150,7,35,150,175,6,206,86,219,253,198,242,100,222,242,84,176,252,118,216,210,120,254,187,127,58,235,57,62,103,160,15,59,
82,63,53,2,191,239,195,86,10,45,199,190,120,230,118,141,220,60,117,187,186,215,3,233,244,145,252,83,211,235,250,143,11,29,63,113,69,42,210,225,57,206,111,229,110,94,225,110,30,63,122,193,107,250,192,79,220,205,195,167,47,120,186,248,179,229,186,233,206,130,121,105,220,60,49,212,245,194,166,13,252,188,57,108,146,39,77,233,57,115,118,201,252,104,213,36,187,77,55,111,152,200,95,125,97,163,243,194,193,243,243,2,9,66,93,191,34,208,152,253,222,243,33,59,77,252,28,244,154,234,203,125,10,111,122,225,184,71,63,239,79,155,59,39,250,123,39,77,234,197,190,158,43,166,223,57,77,163,108,252,195,23,14,26,22,239,229,69,50,217,234,107,54,90,224,63,59,76,241,116,225,103,175,167,143,172,166,114,127,199,11,81,3,186,126,238,231,111,77,166,69,179,169,195,210,7,84,38,47,152,242,86,211,216,162,249,123,187,217,179,108,6,180,73,47,160,141,252,196,5,92,47,68,26,227,239,126,249,19,183,158,226,214,225,214,5,191,194,138,110,58,181,158,159,184,141,175,127,222,94,99,115,127,33,1,55,243,158,99,96,207,97,186,183,
210,241,194,73,220,207,191,115,114,47,228,207,58,126,190,121,195,76,254,227,235,47,100,172,97,223,211,135,174,192,119,209,110,158,183,245,188,112,105,93,63,127,111,239,27,88,54,125,119,181,185,128,115,128,234,224,66,250,125,110,243,27,46,156,124,225,2,241,110,95,239,251,124,177,231,133,231,110,215,207,143,103,76,150,41,147,119,218,252,205,172,249,243,69,204,101,118,95,55,1,7,242,79,253,196,133,19,47,60,52,226,62,232,251,137,139,84,184,45,43,183,117,133,139,90,185,216,60,183,99,229,146,115,92,186,235,133,155,102,126,226,114,243,92,190,255,133,120,127,236,39,110,215,202,21,61,88,97,90,188,95,23,169,56,183,175,223,157,163,27,66,189,40,80,143,184,175,251,133,186,73,36,187,64,43,115,245,229,57,146,103,247,245,111,103,233,50,95,191,198,211,146,125,127,217,78,178,189,158,177,83,63,255,89,129,39,110,246,110,116,150,38,248,3,253,46,79,55,108,245,132,141,134,196,250,186,72,23,109,53,167,141,174,240,159,229,120,234,147,246,15,127,35,81,191,99,95,101,172,250,204,37,146,104,191,99,179,211,
117,219,237,85,27,173,8,123,178,64,203,115,117,253,225,28,73,66,61,33,0,198,190,126,29,12,21,238,50,172,230,234,171,115,180,2,68,190,152,37,153,223,87,121,26,182,239,59,236,116,213,190,95,227,235,189,118,10,243,52,106,223,191,101,39,51,16,105,240,52,207,215,92,60,137,124,173,102,219,63,199,99,26,154,22,239,198,69,26,181,221,185,97,35,129,191,173,127,199,147,32,238,23,68,226,36,44,217,177,63,46,209,182,120,251,162,131,6,68,114,205,222,213,191,154,165,21,254,110,141,39,178,31,24,75,222,207,219,201,196,215,211,60,13,204,238,147,181,98,182,146,58,139,150,3,93,227,201,5,116,61,128,101,255,44,105,167,115,182,187,219,54,26,231,247,54,120,154,153,61,56,164,89,178,242,119,179,60,89,236,7,171,118,90,177,239,171,118,26,230,235,59,60,141,216,247,55,237,116,126,238,238,161,85,184,221,53,71,101,129,72,60,144,68,146,196,122,81,164,158,230,154,108,251,17,27,77,9,251,250,231,2,57,133,131,37,129,174,225,15,63,250,58,234,250,172,131,22,108,7,250,61,27,185,109,7,14,27,93,197,31,223,67,9,108,251,
97,172,90,184,163,215,4,242,11,119,69,129,92,24,244,29,116,204,81,79,57,104,80,222,215,111,203,180,38,239,215,28,245,78,153,28,14,90,117,212,51,14,234,23,234,53,199,62,39,208,21,7,57,48,226,62,102,115,212,211,32,12,70,184,100,178,156,14,143,203,52,42,214,245,125,145,60,88,253,138,72,195,66,61,34,208,212,194,65,100,129,166,248,122,130,167,33,140,127,42,144,205,177,31,119,208,40,198,203,50,13,58,234,101,7,117,9,245,172,64,22,12,252,66,36,89,60,208,175,64,227,132,59,187,2,245,46,220,206,44,80,255,92,61,49,103,140,175,8,180,238,56,200,57,168,15,227,189,50,245,56,234,53,225,182,217,65,169,166,184,62,100,196,218,55,72,182,175,47,136,52,107,59,72,219,104,64,184,19,131,29,225,247,245,97,158,49,82,191,194,211,216,92,189,198,31,244,204,17,207,147,155,223,255,13,79,49,190,174,247,243,228,196,63,115,16,26,225,179,188,64,38,123,61,101,167,65,113,159,209,159,223,95,135,37,155,211,244,252,28,69,230,180,149,57,90,21,239,233,243,34,205,9,90,92,160,209,57,109,105,142,174,205,106,58,116,32,55,171,
85,103,169,131,63,192,84,78,254,30,99,190,93,171,218,209,162,97,66,5,182,17,20,73,240,154,131,167,171,188,22,225,105,202,166,49,22,137,247,125,34,93,178,105,203,54,146,37,77,191,41,209,158,83,211,29,78,16,76,203,130,222,146,134,166,121,81,179,137,116,93,212,244,146,72,27,226,125,144,203,41,222,215,121,145,102,4,77,17,136,95,208,164,5,146,128,73,97,150,194,179,218,246,44,141,207,223,95,155,135,49,220,191,1,81,183,107,134,198,222,179,65,25,128,201,62,79,30,254,126,148,167,9,155,230,182,145,93,188,31,192,154,108,26,147,31,241,62,120,185,10,76,52,137,92,210,253,27,18,9,210,65,85,162,14,199,253,170,131,58,68,45,35,82,191,93,51,36,25,132,177,83,196,174,45,217,233,154,253,192,208,144,251,76,67,230,181,157,121,26,225,53,17,170,129,233,66,60,21,121,45,195,83,63,22,32,138,52,110,211,50,54,24,16,109,133,167,85,187,166,239,216,41,101,215,174,218,201,129,63,110,26,36,99,116,23,180,176,64,211,160,254,238,28,109,206,105,234,28,108,135,166,95,130,109,17,52,136,69,231,130,118,125,129,108,130,
166,223,22,104,173,217,217,1,248,14,26,23,180,170,0,132,53,197,65,188,13,52,179,209,134,77,115,217,72,196,31,118,27,77,174,104,183,86,200,108,211,152,133,194,120,141,41,135,230,22,96,245,52,157,23,24,227,178,118,72,186,182,233,192,206,164,233,0,22,104,146,185,9,152,215,152,238,206,107,249,121,24,0,77,226,97,180,64,83,129,60,130,118,131,41,152,166,175,192,206,161,237,50,240,7,202,79,96,239,100,205,208,158,21,45,190,2,189,209,54,192,57,187,22,177,67,175,129,159,64,27,130,230,16,232,42,254,96,251,223,188,22,153,103,79,214,5,67,250,158,204,145,184,160,133,23,24,48,89,164,101,81,75,137,52,40,220,207,9,212,183,160,173,46,192,130,106,58,244,97,71,208,60,2,93,198,31,179,2,45,52,165,79,208,188,2,45,2,137,178,72,65,81,51,4,71,211,207,139,36,216,52,213,198,176,100,226,3,38,125,193,147,108,211,114,54,234,19,239,71,69,38,25,91,160,148,168,217,69,114,75,154,32,209,13,167,118,72,78,178,202,90,65,134,217,212,124,18,93,114,104,121,7,153,68,109,219,96,170,100,35,169,189,157,180,183,147,246,118,
242,191,219,78,132,154,158,22,40,46,212,106,142,59,38,129,244,25,7,205,200,213,164,76,231,28,181,235,14,178,137,123,250,174,72,155,216,91,5,17,230,167,4,235,208,45,30,212,132,170,5,71,19,1,103,137,170,142,51,85,20,135,27,113,143,227,113,108,193,158,122,39,226,160,41,169,154,144,104,200,177,87,114,96,192,158,94,19,201,47,222,213,47,136,180,104,219,99,170,46,86,107,182,250,168,8,147,8,67,119,87,255,66,32,89,248,76,135,217,25,117,20,19,14,26,146,239,232,115,50,205,219,239,232,117,59,121,237,53,182,101,136,119,244,251,34,93,19,107,49,118,36,46,235,56,17,249,249,74,149,167,14,219,126,193,70,156,248,89,86,196,30,117,39,40,209,172,92,215,47,203,52,45,237,233,99,18,142,15,119,216,202,120,177,114,75,132,169,189,253,149,141,212,246,70,218,222,72,219,27,233,223,113,35,229,181,231,61,255,228,220,104,211,223,197,133,14,55,221,231,231,29,134,207,252,236,31,220,95,62,250,226,239,238,34,31,52,221,227,67,183,155,182,196,251,15,206,188,222,54,117,255,82,52,226,31,134,186,199,240,194,63,134,145,
22,66,167,97,164,193,85,217,154,206,164,182,118,194,214,112,118,43,115,120,255,45,153,216,53,254,127,154,238,120,203,101,169,175,129,43,151,142,242,196,97,129,83,172,156,247,10,231,61,126,244,210,253,128,20,173,91,218,219,117,23,86,222,114,94,249,165,82,40,40,212,21,212,166,221,180,236,166,30,133,38,112,181,232,174,116,40,15,74,254,82,183,47,187,235,255,218,236,167,14,165,212,227,163,110,137,252,110,50,251,75,144,128,113,63,153,21,234,86,136,147,11,93,65,234,244,83,183,79,235,241,60,206,121,10,183,125,133,20,58,135,158,44,122,40,233,73,148,2,185,221,0,245,250,212,108,32,210,229,161,115,30,130,143,108,246,209,152,167,120,206,7,32,251,19,184,25,115,21,58,2,15,184,0,85,149,116,37,16,4,216,157,0,245,133,30,143,185,40,226,138,220,14,164,58,131,37,12,156,80,232,124,128,172,161,167,221,74,1,185,2,227,1,12,36,127,32,138,37,244,72,9,82,242,29,0,21,172,118,4,136,252,95,227,2,124,199,29,190,167,68,84,133,122,131,213,146,63,233,112,147,71,9,215,220,81,140,5,137,148,174,151,198,34,186,20,
154,242,19,110,168,150,148,13,147,127,114,82,162,206,183,220,154,233,37,122,187,53,82,30,114,88,191,148,58,167,80,214,125,181,15,79,82,47,149,117,12,247,101,95,42,152,173,14,202,165,221,171,3,111,185,155,193,151,190,189,62,127,178,164,168,29,152,30,13,230,151,62,154,149,104,193,141,161,212,11,52,0,201,160,21,201,105,147,66,3,62,173,195,243,184,232,81,42,190,68,222,135,139,158,253,81,15,237,122,226,21,144,61,144,224,124,148,240,80,143,47,213,235,129,195,78,38,31,72,87,152,84,246,166,125,196,150,25,120,208,199,150,95,189,246,150,243,95,121,169,108,3,163,64,241,101,32,8,22,110,7,104,32,244,248,162,139,198,208,230,120,233,218,216,126,203,173,15,188,12,62,192,74,123,3,81,75,128,86,131,184,236,253,190,91,169,244,7,200,226,161,65,23,93,11,68,77,111,185,224,206,203,16,252,145,108,167,178,215,237,127,132,238,20,124,136,59,81,16,212,130,135,219,47,221,234,232,91,110,195,202,133,16,99,235,124,169,228,46,190,229,194,136,147,205,188,12,238,117,191,229,182,123,64,145,243,111,185,157,9,252,
203,164,38,72,244,150,75,14,128,146,38,137,56,92,32,191,229,82,86,46,99,229,178,135,91,47,197,76,77,46,212,220,105,242,22,201,183,251,59,153,214,229,140,205,77,231,125,212,235,165,41,119,178,198,218,75,253,110,66,164,100,206,189,57,34,210,142,61,215,239,35,147,151,250,220,180,46,197,106,46,15,121,118,73,201,153,93,164,239,75,36,185,10,32,234,140,135,20,169,148,65,136,204,3,137,72,244,217,41,135,112,246,226,141,222,69,38,122,221,46,194,170,54,164,84,205,141,123,201,28,249,139,13,137,244,121,41,57,236,39,206,205,228,121,131,61,72,144,63,107,151,224,172,169,227,240,248,37,90,228,179,243,144,112,240,219,77,55,164,108,205,29,35,37,67,254,66,17,131,215,252,212,229,166,78,104,145,164,214,220,41,82,178,120,48,34,17,60,117,179,148,90,149,72,132,158,136,16,9,50,185,233,150,156,169,185,119,200,91,32,95,78,159,145,73,239,150,211,221,94,34,55,117,248,168,136,209,236,73,97,129,69,147,226,56,94,14,203,164,216,179,144,4,244,233,113,83,66,74,212,92,25,242,228,72,73,1,105,194,181,216,144,139,56,
104,148,66,97,87,142,60,5,204,190,34,33,228,160,206,32,202,96,167,32,159,166,197,8,36,175,3,146,180,72,157,46,74,73,59,53,103,130,24,158,201,239,129,253,130,148,5,65,76,78,70,211,109,103,214,120,160,98,197,171,6,246,78,28,62,249,220,16,212,203,201,230,223,196,10,157,183,200,157,97,243,131,165,58,40,210,231,100,235,234,148,114,53,103,209,24,157,8,72,52,233,100,52,193,137,26,29,118,237,185,154,43,87,99,184,229,41,144,221,114,17,130,128,91,246,220,70,128,97,14,220,206,185,10,53,79,158,148,93,10,228,110,184,64,238,20,2,214,253,18,109,240,185,78,24,14,15,227,88,86,2,221,208,39,15,218,94,193,196,99,82,161,15,2,6,193,82,40,238,86,189,110,90,100,75,98,12,157,150,40,192,83,175,148,115,72,136,106,230,208,167,3,188,241,83,145,33,1,16,5,10,228,87,33,49,231,92,89,51,96,67,180,21,218,242,228,110,122,104,222,3,16,192,49,127,29,82,226,161,69,207,246,160,157,46,123,104,0,138,166,208,172,8,105,133,84,222,34,95,158,130,105,159,155,158,5,33,51,5,206,203,116,51,233,205,56,189,116,133,201,108,153,
130,89,8,178,34,18,25,143,122,131,136,38,20,106,178,49,189,15,171,76,33,90,88,150,115,227,30,102,193,96,87,87,61,185,36,51,140,17,6,57,144,90,150,73,150,99,189,2,41,50,66,191,183,128,97,151,143,6,61,20,115,2,1,67,66,252,183,26,78,72,173,179,56,2,187,229,101,130,187,14,171,141,185,253,197,57,39,5,156,219,28,130,97,78,242,67,176,132,44,35,146,31,130,151,173,65,110,216,4,234,55,144,187,5,144,30,102,82,206,119,251,168,116,242,32,113,65,70,124,147,122,228,157,85,25,113,144,252,37,15,211,252,78,31,121,217,224,44,68,22,131,63,199,96,167,156,239,52,72,135,193,183,64,83,182,168,180,8,53,21,8,36,5,53,0,186,42,228,106,114,170,230,202,50,169,244,229,124,24,214,233,72,141,251,168,199,197,120,234,151,119,106,46,164,215,164,201,151,193,82,45,14,90,98,218,224,66,84,44,14,85,0,152,28,38,133,158,121,83,228,75,221,146,17,62,161,148,152,136,67,212,124,212,233,165,115,128,13,57,100,244,46,0,219,49,145,158,250,16,10,141,67,74,65,245,162,156,52,102,198,130,179,7,184,57,96,129,207,204,24,212,200,197,
204,221,26,88,225,202,51,219,225,43,76,59,232,11,44,214,69,38,104,17,180,212,71,85,166,162,160,38,214,155,42,25,243,198,197,52,15,105,246,178,169,175,202,80,114,216,44,172,41,107,151,17,224,33,125,64,72,131,137,192,9,115,103,128,180,43,201,52,212,151,169,200,136,157,82,214,145,129,142,2,46,132,61,34,23,76,14,202,159,206,13,155,183,104,76,140,225,67,98,170,198,38,110,90,128,60,2,131,61,50,221,113,83,151,152,233,48,38,46,203,249,154,59,219,92,48,36,4,247,10,139,96,172,23,219,46,21,164,188,238,199,51,67,252,109,208,142,97,88,50,88,37,152,111,41,187,44,33,22,10,74,66,253,118,201,95,18,153,242,64,37,164,93,168,4,180,83,247,156,62,129,163,169,47,129,188,126,140,218,229,20,90,144,232,154,132,57,75,164,148,200,95,193,227,130,155,250,141,77,44,32,182,109,55,147,214,182,237,110,219,238,182,237,110,219,238,182,237,110,159,187,219,231,238,246,185,187,125,238,110,159,187,255,81,207,221,204,167,130,43,6,199,165,204,188,88,156,65,207,57,146,125,240,92,12,55,45,197,92,76,56,38,37,120,99,83,50,
217,113,119,37,80,149,197,144,152,31,55,193,14,237,106,141,121,46,187,240,95,107,50,77,137,240,72,50,8,45,32,128,103,184,176,9,222,75,10,115,124,88,7,64,208,123,49,50,72,35,112,183,248,68,13,145,3,55,34,15,8,111,20,189,240,21,122,196,140,137,103,238,2,130,15,157,110,4,22,84,92,170,101,79,157,244,184,68,143,225,138,241,73,60,69,232,163,44,109,27,254,59,28,244,130,71,162,111,144,208,34,38,70,225,129,24,145,147,48,139,199,52,189,251,34,34,39,51,200,99,145,2,86,137,224,142,32,156,133,41,206,9,59,116,89,237,187,12,167,48,97,184,177,204,225,68,6,139,222,227,72,194,161,99,238,87,128,118,24,105,224,140,158,44,223,141,188,1,57,8,223,114,64,166,184,61,213,13,87,27,254,172,143,114,8,98,176,96,4,226,0,153,180,132,36,21,10,35,202,128,105,16,95,100,27,249,142,65,34,184,248,41,132,97,38,68,250,29,252,202,32,245,242,9,120,218,69,68,157,24,162,44,206,128,59,123,189,83,76,15,248,89,244,6,190,86,66,74,26,244,97,207,16,172,26,150,104,77,244,119,179,133,34,57,38,75,139,107,32,18,25,210,209,185,8,
151,45,110,116,70,60,163,8,71,107,77,76,174,35,22,41,26,97,36,55,13,73,25,56,116,160,117,1,143,17,238,24,227,233,188,155,250,16,167,241,83,166,237,123,181,227,102,237,184,89,59,110,214,142,155,49,25,248,231,21,55,147,226,20,140,81,164,74,145,173,52,234,90,253,155,40,91,84,149,0,5,183,40,18,196,54,185,133,242,18,127,24,55,37,183,176,173,186,183,41,136,42,167,208,160,66,254,8,171,175,27,242,111,83,180,218,31,164,136,31,129,184,16,5,227,20,137,83,172,50,142,138,159,24,43,97,28,101,129,61,236,151,40,109,41,160,208,106,17,101,53,126,194,240,113,121,139,66,113,138,110,145,90,169,5,54,81,61,51,28,162,184,175,217,24,196,214,89,9,4,80,16,132,130,76,92,29,245,32,14,29,218,162,104,16,212,157,87,233,70,192,79,241,221,177,16,117,161,0,21,5,166,136,218,179,129,42,69,67,20,171,226,182,229,106,20,25,176,136,163,3,183,50,74,187,112,93,116,19,165,145,70,96,187,219,229,167,80,136,33,25,47,215,2,145,17,220,36,161,68,40,0,228,55,40,20,166,72,0,141,168,255,236,199,77,29,14,48,158,16,155,55,18,24,103,
55,88,1,0,71,157,16,202,70,81,147,116,157,5,233,1,106,135,213,124,69,11,19,168,72,192,165,149,66,35,46,84,111,161,174,144,40,176,73,200,217,70,57,36,160,5,104,84,66,1,18,107,1,245,42,32,157,127,123,52,72,55,25,41,54,40,24,161,200,250,54,106,131,252,59,172,40,141,237,222,160,36,163,51,10,195,72,33,84,4,141,249,119,40,84,29,65,93,28,174,24,80,125,165,108,81,16,39,34,214,7,79,45,18,241,184,63,244,167,40,84,2,167,176,49,207,135,216,222,124,14,177,120,9,61,193,148,50,184,105,76,17,157,8,82,84,1,50,88,87,8,1,215,24,74,214,252,33,198,116,119,152,130,219,88,14,152,142,88,43,218,193,223,62,127,172,201,223,4,11,205,162,3,70,69,40,86,68,173,27,34,186,139,18,161,18,118,26,37,5,126,112,36,3,28,112,107,105,138,19,200,197,201,219,6,127,99,164,130,206,27,67,168,142,2,127,113,107,225,1,167,192,151,245,90,32,132,42,194,129,16,133,125,96,46,102,89,7,31,187,61,168,128,50,170,174,80,94,23,79,131,11,25,198,130,4,88,15,161,66,8,31,53,193,99,50,225,154,98,154,49,183,138,98,59,80,3,5,134,2,170,207,112,
15,23,32,147,43,136,186,37,44,214,224,111,176,31,53,157,96,165,178,105,240,49,8,70,64,200,59,2,49,32,83,196,37,134,7,237,16,254,208,148,2,38,111,131,191,88,14,106,223,80,220,230,133,80,129,74,236,233,38,69,119,45,49,90,196,197,146,135,46,184,24,89,204,64,47,82,6,115,187,67,180,4,145,8,208,152,4,150,129,56,187,96,101,22,64,252,137,193,32,225,30,110,252,132,212,91,53,255,14,132,7,42,144,101,252,5,253,25,228,1,131,206,156,63,209,29,68,73,34,93,100,39,215,38,191,66,32,51,88,143,43,48,40,23,52,168,195,175,142,251,105,187,173,173,109,109,109,107,235,63,19,109,157,228,19,125,238,196,152,146,176,136,177,110,127,134,147,146,163,161,212,239,85,220,132,97,215,97,55,97,132,28,42,194,157,44,44,194,89,77,214,228,248,95,74,166,73,191,35,35,153,230,63,79,119,188,227,144,76,67,84,12,83,249,202,225,35,110,205,202,41,44,153,230,139,87,124,169,38,229,86,223,113,202,202,43,231,37,114,23,121,39,153,221,116,213,185,65,184,33,84,18,23,113,237,108,92,142,187,157,73,60,197,53,26,187,98,187,34,170,50,143,
188,115,96,84,89,70,154,132,147,57,207,131,18,234,75,246,107,114,181,230,218,38,207,230,164,135,174,184,104,214,19,119,120,152,5,158,115,149,200,243,64,247,203,197,154,35,1,151,254,60,43,221,160,171,46,234,179,63,196,197,126,85,42,213,92,183,111,186,104,222,181,142,203,86,24,77,92,22,187,93,85,140,25,197,132,14,41,205,10,99,28,54,24,182,57,7,41,46,100,35,212,113,219,169,95,119,167,183,220,52,233,190,78,74,24,247,155,112,212,111,184,241,250,136,130,238,151,170,61,239,184,181,190,87,34,82,41,8,11,92,91,125,5,223,211,77,22,182,226,210,232,59,206,23,127,229,188,213,251,142,187,25,120,229,196,77,51,22,92,194,125,243,184,155,100,150,66,80,196,76,99,120,168,139,175,164,188,249,29,231,207,188,226,113,145,153,67,102,13,114,230,217,33,5,132,18,180,154,92,199,53,172,203,69,162,43,74,158,226,140,113,55,235,97,105,12,251,35,112,237,151,229,58,156,119,29,169,47,146,253,193,148,241,112,252,29,23,176,189,146,246,128,93,160,248,202,149,18,93,228,98,107,206,207,185,144,238,65,221,239,184,245,213,
87,12,192,237,94,4,35,223,113,193,111,209,25,238,117,143,157,110,224,175,202,43,190,62,248,142,219,24,122,5,26,120,40,250,142,11,25,169,44,155,86,35,139,5,165,94,115,156,58,8,92,71,222,177,60,149,180,233,149,248,148,220,207,144,2,52,5,25,176,114,185,69,80,4,100,66,106,67,69,124,64,238,199,164,60,65,193,9,11,81,32,25,224,228,18,32,83,243,237,166,101,122,32,103,144,24,20,118,199,171,88,174,183,48,132,19,146,200,194,16,72,121,234,242,210,14,98,16,174,68,77,73,179,235,216,113,41,133,60,167,152,39,239,82,8,36,66,64,162,223,149,87,61,100,193,69,57,31,175,177,144,67,166,230,175,232,156,132,242,32,21,131,112,207,156,68,37,152,123,7,1,23,8,56,48,234,230,19,157,126,170,176,174,106,205,95,92,2,212,9,73,45,179,184,68,102,134,71,78,75,250,18,210,144,252,132,76,14,139,152,66,70,64,149,93,99,199,106,190,138,42,211,87,114,22,89,54,25,111,97,196,71,49,25,107,201,114,34,93,240,146,207,158,29,100,113,29,92,212,231,106,202,238,57,23,213,37,138,177,20,148,16,178,90,70,236,16,208,68,14,247,193,200,
4,192,5,55,191,195,48,117,102,107,74,10,1,30,32,171,78,57,201,161,208,5,119,156,149,126,57,11,96,201,46,159,198,65,6,74,17,147,162,70,215,228,188,68,95,74,49,244,92,81,32,71,89,201,173,58,157,132,202,154,110,103,9,52,69,194,217,140,19,120,228,107,82,186,134,44,17,37,119,1,160,23,165,84,209,133,99,106,54,38,161,14,140,204,174,108,1,33,32,48,129,223,225,92,136,172,36,106,72,148,80,146,8,36,233,203,82,174,194,20,44,197,170,99,156,197,128,196,78,141,156,145,203,210,99,79,213,16,118,114,165,106,74,126,210,133,140,111,92,155,179,181,169,76,89,60,233,62,44,21,10,38,166,160,41,184,38,207,32,238,228,78,215,124,249,9,72,230,146,156,205,224,168,224,45,213,220,187,23,69,176,151,8,169,5,184,141,151,145,84,158,101,215,248,192,213,87,158,68,87,187,156,15,50,77,222,101,229,80,174,18,143,124,30,91,22,113,40,150,196,224,162,91,78,128,40,128,183,59,78,122,228,44,132,221,52,237,45,89,112,186,99,102,163,212,101,163,91,94,234,21,96,215,16,247,50,8,224,43,67,187,161,254,186,5,233,15,158,60,160,84,92,
249,65,129,186,100,82,133,236,8,226,91,46,138,179,172,139,66,22,10,227,43,205,163,235,156,17,21,92,68,22,135,171,48,130,82,30,35,155,108,216,133,132,117,160,10,168,57,8,236,44,250,45,56,82,176,13,188,167,128,20,16,92,233,141,187,146,53,49,133,212,42,70,0,31,109,99,85,140,0,165,94,164,187,201,180,15,160,222,194,166,72,189,200,189,112,167,202,44,247,34,9,227,7,217,206,200,113,100,118,96,253,151,0,244,162,156,222,118,225,8,153,103,85,137,174,172,7,25,45,200,173,65,130,136,152,66,220,46,139,112,177,59,81,2,163,125,187,72,31,209,199,141,248,100,4,73,238,200,224,119,171,49,159,97,44,88,22,75,162,38,35,223,139,205,63,138,126,14,57,185,203,178,72,50,146,128,172,175,220,77,153,121,2,144,67,179,152,0,236,50,147,237,108,205,87,64,94,12,172,135,10,204,189,200,156,201,129,79,146,140,44,122,178,120,51,30,120,142,94,130,216,91,248,108,13,233,17,206,34,244,10,10,166,123,164,172,11,150,140,229,65,102,170,72,205,119,150,88,57,35,159,31,117,178,222,1,164,33,129,103,74,202,44,209,45,105,119,203,
9,243,153,198,238,82,117,86,206,33,61,203,137,140,164,120,151,132,210,73,154,199,70,208,182,8,109,139,208,182,8,109,139,208,182,8,237,51,66,251,140,208,62,35,124,234,140,192,110,116,243,53,87,169,230,171,226,188,184,229,72,45,33,23,95,206,251,125,100,245,148,46,8,52,194,28,189,178,131,57,129,44,117,213,204,206,20,200,230,220,77,224,150,208,87,25,102,199,155,124,205,91,65,214,252,6,59,186,231,204,72,57,134,87,224,45,173,184,217,25,126,130,79,195,71,197,225,7,135,76,28,135,224,15,110,226,254,80,201,34,22,89,118,239,202,10,45,163,202,3,175,83,64,57,36,222,109,193,103,81,235,80,96,253,11,219,172,196,163,218,41,193,211,73,227,240,63,225,167,168,187,140,91,78,188,29,160,11,245,246,110,26,81,74,41,5,149,211,192,127,23,248,231,92,72,38,166,62,95,165,230,96,23,212,171,62,194,107,18,186,93,149,126,188,6,1,137,175,158,210,172,139,20,15,94,235,128,179,60,82,100,43,168,80,135,175,51,161,236,162,246,32,108,120,37,198,186,202,110,36,205,162,158,219,87,128,99,131,219,103,11,159,97,253,221,187,
187,248,211,95,233,145,168,40,102,146,184,16,86,210,64,18,145,83,84,194,247,160,238,3,213,157,110,100,220,103,209,82,96,151,201,229,34,174,142,37,148,47,236,214,68,204,152,71,96,16,41,194,67,254,202,85,120,218,184,105,197,146,149,50,124,142,213,246,25,173,125,70,107,159,209,218,103,180,143,103,52,22,114,217,170,57,213,164,4,43,131,223,40,24,75,244,58,105,78,33,175,147,185,148,75,120,11,138,123,11,197,37,40,114,65,44,203,44,192,34,111,215,92,8,166,164,225,155,198,229,109,213,69,195,30,212,31,236,224,230,100,192,135,183,192,144,236,81,109,46,154,134,17,183,171,176,134,25,168,156,11,129,156,173,1,137,210,210,214,121,23,109,122,208,178,131,83,18,130,22,99,118,114,122,66,40,90,99,165,20,124,8,30,248,45,41,80,115,174,215,148,24,144,44,75,235,5,188,30,201,189,62,141,146,31,103,106,18,181,152,74,152,89,112,9,49,161,24,34,21,8,152,248,165,117,212,248,160,63,138,104,50,210,70,201,137,224,68,116,65,161,53,103,6,134,123,22,111,243,113,71,36,35,180,130,200,66,159,16,175,201,145,154,107,171,
230,83,251,101,120,239,155,8,44,58,24,62,41,84,163,221,20,16,76,84,183,240,126,26,196,44,112,27,99,223,102,14,54,240,193,122,149,8,11,233,72,155,88,218,117,79,20,45,136,107,192,89,62,111,167,43,158,173,109,227,2,167,23,113,26,126,171,198,240,223,168,224,102,82,137,213,36,127,205,29,66,0,176,234,84,129,76,196,189,137,50,194,78,96,40,177,125,5,49,159,88,155,254,255,79,233,255,49,56,62,242,213,105,112,188,47,24,11,5,118,154,85,166,107,239,137,200,74,244,95,46,208,123,110,155,202,131,71,125,156,203,202,57,175,112,206,227,7,175,165,74,213,157,190,250,158,115,58,95,43,133,114,176,238,113,211,239,220,206,186,127,15,71,135,176,68,83,74,202,233,38,135,92,192,21,92,51,179,43,229,137,212,124,137,122,104,255,16,66,134,43,191,175,66,236,86,127,218,85,47,41,225,82,192,95,14,221,195,125,31,206,8,65,151,186,23,80,177,189,167,81,240,166,148,16,163,206,163,110,11,247,145,200,108,75,186,149,207,148,245,98,176,162,67,162,68,247,70,222,159,180,188,231,92,221,175,209,27,98,165,172,35,54,55,141,134,
141,215,82,1,209,181,78,99,238,13,183,50,251,158,187,150,124,173,108,118,190,231,220,229,215,193,219,40,128,221,192,207,173,215,238,213,138,159,133,117,250,223,115,215,111,190,134,74,42,1,28,47,34,114,105,8,215,131,70,62,91,222,19,174,248,226,133,208,189,12,2,233,228,137,231,3,137,65,31,109,250,210,3,208,19,153,182,89,53,39,245,224,18,220,85,117,1,200,210,107,37,210,245,158,243,20,94,163,88,53,244,120,40,128,240,26,141,190,231,110,60,229,110,116,188,118,37,190,2,208,64,2,225,236,107,74,152,123,207,121,243,175,165,28,110,77,113,7,203,22,137,134,216,107,183,58,242,158,21,242,174,57,184,181,142,215,74,110,238,61,231,179,178,23,198,173,119,188,14,222,187,248,30,5,153,88,47,254,13,247,188,54,206,62,88,230,216,123,46,98,229,240,14,179,237,231,220,107,223,67,20,115,82,248,145,190,140,164,190,48,142,70,164,39,125,79,41,248,132,194,95,234,139,120,209,39,234,51,125,164,103,149,123,20,216,167,80,93,119,24,23,39,160,175,158,84,30,82,224,30,133,52,93,54,218,80,146,166,71,149,125,242,107,20,
196,251,158,78,137,162,87,49,214,255,37,5,111,235,66,144,93,168,162,8,73,207,41,26,138,113,89,191,25,163,95,15,218,42,39,109,183,245,85,44,47,200,106,69,245,144,239,241,9,46,43,136,141,162,107,152,244,29,223,19,10,62,160,240,29,221,134,0,35,222,100,11,156,51,12,191,58,195,5,57,12,152,131,225,242,57,112,97,248,61,56,193,143,225,28,59,193,165,174,91,209,9,240,48,71,73,169,27,248,237,235,147,64,14,98,128,182,26,214,230,127,132,105,116,212,54,97,2,156,140,245,135,202,3,3,231,7,187,184,246,192,74,252,116,120,81,121,76,129,103,20,122,114,3,76,5,192,16,29,250,208,43,240,16,152,44,6,200,108,208,229,144,17,138,45,246,33,110,231,1,8,66,127,152,99,176,24,252,75,134,228,177,166,2,27,248,132,66,143,237,134,140,76,160,73,97,171,122,76,161,135,60,18,30,140,69,29,230,188,7,196,120,86,247,3,22,106,94,125,116,120,213,251,101,179,201,131,162,63,20,31,162,201,3,178,25,176,144,15,130,228,70,148,42,30,94,195,40,134,215,131,48,171,194,102,25,27,24,184,71,62,240,161,68,193,189,107,65,26,70,69,25,176,
193,112,23,123,0,4,145,151,82,9,250,89,233,28,100,0,162,1,184,205,197,61,92,14,177,155,126,232,228,97,232,4,174,198,112,12,176,152,247,97,1,64,13,18,88,241,178,98,100,20,160,41,15,158,25,8,205,24,154,12,86,28,86,32,102,172,233,153,140,148,1,212,23,163,215,205,147,166,167,130,145,185,10,52,15,51,39,2,240,53,222,30,139,244,130,158,48,29,102,25,255,159,82,248,91,136,19,176,229,208,148,100,235,213,64,244,5,131,232,12,9,54,144,73,172,182,100,228,185,130,21,135,49,223,62,5,239,65,176,33,55,144,37,54,80,61,129,245,232,106,152,213,122,15,97,224,117,134,42,35,186,128,250,74,144,15,168,110,179,38,70,59,175,143,80,95,13,29,52,40,204,132,80,131,222,64,142,186,1,107,155,161,10,93,250,114,222,200,143,133,168,30,150,149,39,228,111,80,240,153,7,219,25,114,58,64,66,31,19,134,223,130,243,2,234,103,145,73,130,166,204,137,96,221,195,197,8,92,45,160,118,24,61,17,25,141,93,23,34,239,3,77,197,182,170,182,85,181,173,170,225,182,170,26,187,86,123,87,109,239,170,237,93,245,255,116,87,253,119,237,93,181,
125,0,110,31,128,225,0,254,147,63,0,235,23,34,213,35,164,194,79,70,171,181,88,97,50,74,91,241,44,50,203,229,56,241,234,238,145,15,159,198,137,103,213,56,62,254,81,221,197,23,119,162,85,37,138,239,242,84,143,106,177,42,190,163,80,141,150,76,49,74,226,91,18,145,178,11,95,171,1,168,90,168,130,111,27,225,163,51,93,193,114,45,84,194,33,62,16,194,231,127,10,71,72,187,30,139,150,106,177,34,50,166,61,49,154,140,103,174,226,203,38,106,233,8,31,78,25,140,231,10,113,124,25,162,84,139,150,241,101,151,149,40,210,233,75,108,14,124,170,103,3,95,124,138,22,116,15,155,164,122,148,138,208,209,23,236,229,26,21,10,150,145,154,143,35,60,82,178,14,101,227,181,25,20,44,237,24,30,1,59,216,95,97,101,123,37,10,149,121,36,60,27,254,26,156,151,10,5,118,89,19,94,122,130,72,7,28,142,16,235,130,212,245,180,13,78,21,75,160,166,195,116,160,140,140,116,138,168,240,24,145,17,77,104,202,158,204,184,235,53,222,40,133,176,196,225,186,241,134,15,10,22,22,49,99,211,109,45,176,18,50,224,149,191,108,56,193,240,76,224,
131,0,213,42,110,70,208,203,108,248,222,135,91,12,9,134,215,69,228,140,3,15,32,145,103,168,2,175,202,69,184,98,168,143,67,211,173,19,188,50,112,9,225,255,245,69,24,170,85,3,175,60,10,20,16,139,65,199,195,27,108,70,128,47,173,27,203,102,46,206,13,165,220,108,90,51,144,2,170,122,39,107,98,244,250,61,123,185,80,243,157,88,103,89,153,157,223,157,6,158,204,209,192,238,110,51,238,36,252,53,17,89,137,254,235,249,142,191,198,7,6,138,155,71,243,220,73,42,230,239,27,156,242,202,201,173,125,195,173,233,110,206,151,70,230,161,138,255,187,56,255,95,125,201,5,174,112,1,188,14,126,253,41,23,212,139,92,240,115,110,163,242,169,180,63,43,151,154,231,210,115,70,154,223,209,191,31,255,240,153,210,215,185,100,138,94,50,63,157,239,252,209,215,232,253,16,94,48,245,218,251,18,215,240,54,122,221,244,35,50,147,252,141,93,100,252,251,158,93,128,195,236,223,227,193,119,223,227,75,202,67,248,169,170,167,129,92,115,29,145,222,199,31,190,186,110,254,78,236,123,58,111,194,43,201,1,103,224,67,202,106,58,88,52,
221,94,61,133,195,249,191,45,192,57,244,61,155,133,47,233,175,78,162,74,193,167,205,40,251,240,165,131,10,2,201,207,190,84,30,176,152,177,239,41,222,64,182,5,71,213,223,192,92,206,15,55,23,77,95,14,118,255,24,124,214,253,33,219,103,10,156,51,63,153,52,87,102,77,119,4,211,208,170,249,129,7,175,180,159,253,209,223,192,55,143,142,50,136,104,220,253,16,115,115,65,222,60,121,222,52,55,53,241,217,76,7,158,113,31,166,121,83,85,70,79,125,245,71,4,43,124,207,138,240,150,149,39,8,122,116,248,26,240,137,191,249,176,228,50,113,23,205,213,17,211,204,160,233,241,192,192,212,185,38,45,50,227,230,223,90,77,55,86,217,208,225,38,45,82,108,253,207,172,112,145,253,133,25,95,29,117,39,211,202,99,208,194,135,234,19,79,67,199,203,111,190,251,80,182,153,111,12,155,238,244,114,63,70,30,119,124,120,218,49,56,223,105,138,247,155,128,245,53,134,133,231,71,124,153,39,132,239,155,133,240,126,178,239,199,62,124,123,205,212,47,155,2,43,248,159,185,95,54,71,174,131,100,231,127,12,34,166,254,84,159,244,209,140,
255,219,69,95,3,85,23,243,202,99,8,237,225,146,239,33,66,201,73,255,151,136,47,224,134,144,11,214,183,241,125,176,216,183,230,15,86,135,249,238,5,83,199,184,105,105,220,20,153,234,91,189,104,158,89,198,124,83,63,70,111,227,211,13,209,72,9,5,22,199,208,180,143,161,207,238,255,126,42,129,166,120,96,103,67,141,109,237,188,161,255,240,45,61,255,159,100,193,107,245,18,84,78,16,151,32,26,98,18,249,223,166,127,79,255,38,146,29,138,144,53,178,115,17,245,40,145,180,21,197,58,145,232,165,8,202,83,178,198,127,163,70,75,102,30,95,73,138,36,108,40,77,136,84,22,34,180,22,173,92,140,210,122,172,138,15,213,108,199,43,151,226,228,83,43,188,74,253,106,18,159,179,25,81,203,198,127,85,227,191,133,25,21,95,43,74,160,34,231,156,90,186,128,143,240,168,233,69,21,95,184,170,90,85,132,111,202,211,113,10,199,170,147,248,180,83,180,58,29,165,112,60,59,131,234,141,184,58,7,59,25,79,27,191,227,248,20,211,72,60,99,252,142,205,226,195,112,241,140,209,162,242,248,198,84,124,119,33,78,107,177,226,88,12,31,8,42,
49,8,145,204,5,212,138,68,114,20,201,79,25,229,41,19,145,56,62,5,55,26,201,161,125,60,18,155,67,45,75,36,221,252,109,180,103,91,126,231,217,234,66,149,11,168,39,65,29,45,138,51,66,165,105,84,159,180,169,20,105,83,137,237,96,109,89,250,191,163,113,31,77,218,194,191,58,53,105,61,27,169,108,60,173,63,251,99,209,122,164,178,183,57,6,39,254,176,84,232,90,162,209,63,114,235,149,59,13,170,55,98,127,88,74,163,65,95,91,218,108,254,179,133,127,14,83,127,228,130,216,103,55,190,225,54,176,207,134,210,220,38,246,217,48,246,217,48,246,217,200,21,110,11,251,108,244,41,183,173,151,184,109,141,139,85,184,184,149,219,113,176,175,167,36,176,189,226,173,143,115,92,30,31,76,153,231,202,93,127,88,208,200,118,139,86,247,104,117,181,107,149,104,129,200,70,180,74,211,127,228,170,86,174,166,119,255,97,225,9,217,10,70,135,245,214,14,250,218,66,131,86,175,54,155,244,53,155,70,75,117,224,134,209,229,37,43,126,148,241,184,217,178,208,252,189,200,158,226,119,107,207,133,70,215,201,83,99,44,126,47,77,178,177,
45,125,140,121,126,1,232,234,39,1,209,114,164,107,217,152,160,101,226,95,224,213,132,244,217,201,104,214,203,213,2,201,104,7,242,172,221,221,210,231,4,177,38,164,147,78,127,14,233,102,11,164,83,50,0,146,109,143,150,75,12,45,208,244,151,11,253,91,48,11,181,192,203,179,223,39,152,121,255,22,204,202,75,54,244,248,51,218,79,180,128,107,65,175,137,219,167,16,171,54,231,108,46,52,123,54,41,227,22,227,77,43,177,62,62,61,105,95,128,184,178,78,39,48,202,182,203,180,180,220,132,55,110,187,142,100,250,113,219,150,241,223,219,236,191,140,74,187,103,157,79,168,100,219,167,37,131,4,77,186,181,136,3,91,26,254,92,254,182,133,170,223,211,234,86,171,28,158,98,183,52,142,89,203,11,207,90,228,240,123,90,242,156,172,166,5,232,47,100,12,200,223,107,145,101,70,241,242,2,198,25,116,99,180,2,60,225,207,97,148,151,239,0,165,214,217,0,8,203,56,37,183,177,158,95,50,6,64,79,249,217,130,76,121,41,250,107,180,151,24,255,202,45,104,1,225,39,45,24,1,208,206,167,48,250,218,192,168,5,247,165,53,3,208,71,180,0,
232,105,11,32,44,237,76,146,63,118,42,27,104,150,91,122,254,106,105,97,3,225,86,140,0,104,229,20,163,86,106,50,97,105,165,38,0,237,181,208,104,204,120,220,138,81,43,141,90,0,205,231,105,225,1,45,127,201,164,0,38,107,30,64,91,204,205,146,200,224,252,146,94,191,146,130,228,39,176,107,89,96,43,56,224,216,106,220,24,165,91,31,27,191,13,249,62,81,142,19,142,255,90,168,90,96,52,205,158,33,26,198,104,70,191,95,155,198,165,60,45,39,217,242,126,57,219,47,144,249,197,20,6,36,198,223,63,131,212,20,225,143,244,249,5,12,12,99,90,253,17,153,79,137,228,242,35,67,146,254,2,136,63,71,227,147,11,98,36,103,72,182,80,179,169,238,77,171,2,99,112,130,75,179,207,106,140,233,244,169,225,60,217,39,108,26,186,125,28,101,48,157,86,189,172,167,177,240,95,46,205,208,138,86,113,51,104,52,240,9,26,1,80,211,164,48,5,255,11,203,44,55,181,167,213,22,176,165,24,246,143,225,222,34,97,104,95,222,102,204,107,154,237,246,54,217,36,43,35,151,97,95,62,109,214,63,177,89,210,106,226,211,188,109,202,156,97,233,79,88,102,
236,23,248,205,38,105,111,153,140,10,117,146,27,40,72,99,154,209,148,67,38,150,223,146,84,234,66,66,110,243,160,199,118,172,246,246,249,233,237,147,81,139,237,160,32,158,195,176,59,14,67,245,169,105,152,154,118,182,189,161,26,198,24,187,244,95,216,80,91,54,225,166,217,102,98,249,151,148,186,124,98,176,63,26,96,195,24,183,55,215,143,135,79,144,166,189,185,182,55,87,155,225,99,125,60,50,25,246,169,108,219,107,182,24,58,150,110,111,156,160,70,219,215,108,30,151,91,253,40,118,52,96,103,96,28,10,254,62,190,102,243,80,209,60,105,53,207,18,0,228,200,119,57,140,179,4,51,239,133,51,209,59,57,51,183,56,194,56,184,181,250,119,255,98,60,206,143,84,187,71,82,158,157,192,216,153,236,41,57,82,32,220,201,214,184,154,99,132,59,141,159,156,241,168,237,113,254,154,38,159,240,56,73,126,118,114,214,61,241,1,234,132,47,170,128,204,39,130,158,36,67,68,79,220,105,227,120,220,212,129,38,237,255,191,241,65,89,180,237,68,114,176,50,135,17,112,115,216,118,97,10,29,54,22,112,115,192,189,253,23,235,143,54,
183,201,102,196,163,189,101,54,53,227,31,61,60,251,47,88,222,88,40,169,37,70,193,172,78,59,254,113,18,50,59,9,219,156,144,167,25,184,251,7,190,50,104,199,63,140,147,197,223,243,250,160,29,255,56,115,187,151,254,222,23,10,237,248,7,244,220,160,163,17,202,105,95,46,180,196,182,12,151,192,136,87,255,50,82,187,180,118,18,163,101,247,37,236,246,238,236,79,118,86,101,155,72,150,86,242,93,43,167,103,91,227,230,129,28,37,230,72,52,195,146,232,35,54,72,244,34,80,130,55,50,116,34,220,142,215,28,178,88,239,62,217,210,39,225,55,35,6,255,111,203,11,94,178,89,201,49,196,6,159,92,173,220,96,47,126,115,88,91,90,194,100,195,247,207,175,180,180,228,200,230,37,199,102,75,75,145,144,38,233,136,182,180,60,96,153,5,77,180,78,32,27,151,63,191,106,105,31,70,13,166,178,200,77,59,126,243,143,126,24,253,120,217,193,50,114,254,151,0,0,0,0,255,255,3,0,72,18,56,140);


programfile__ROCKIN_MID
:array[0..7838] of byte=(
120,1,236,156,221,87,91,231,158,223,119,28,29,197,135,184,12,77,153,148,82,23,19,91,6,5,19,156,8,44,201,104,71,71,230,69,150,101,97,100,23,169,22,88,24,20,140,57,86,130,13,181,3,199,161,214,126,145,19,56,211,179,134,218,62,231,192,180,127,196,172,153,204,219,77,223,95,255,132,94,116,173,94,156,213,171,94,244,174,189,75,63,223,71,2,147,73,167,107,77,143,103,142,87,170,139,157,253,236,223,251,251,243,236,45,226,169,153,149,37,203,178,130,214,27,86,219,27,255,117,106,102,189,202,211,123,214,255,248,193,147,218,15,223,248,159,214,55,215,223,252,129,255,223,172,111,110,6,2,199,186,142,91,223,148,142,129,254,230,188,213,32,252,173,73,235,155,55,223,124,88,253,200,250,230,189,55,128,247,242,159,223,127,171,102,253,126,91,202,250,151,51,238,151,39,118,115,181,85,39,119,215,222,157,170,185,163,206,212,205,85,45,58,128,14,57,83,37,239,154,147,43,220,219,205,214,252,30,39,59,55,6,212,235,114,114,11,110,17,34,239,180,51,117,183,27,220,150,147,45,116,10,149,231,33,236,228,110,122,41,39,123,
167,62,34,65,125,206,212,23,94,84,171,17,103,234,126,27,84,190,13,85,220,201,205,173,192,230,30,227,97,211,201,150,114,187,233,154,119,211,73,23,220,119,119,39,107,238,132,51,89,216,218,29,199,178,241,133,52,119,175,211,25,47,68,88,184,79,88,60,13,74,253,186,51,181,137,161,136,78,34,54,236,76,221,198,162,92,67,164,55,143,240,77,217,180,46,208,9,209,111,58,83,143,102,4,218,4,52,139,94,111,212,201,222,242,229,138,251,33,178,188,211,7,178,2,152,138,189,185,194,67,200,221,17,72,243,78,174,228,246,34,83,46,106,49,211,134,193,126,155,147,158,43,98,47,14,79,22,221,110,25,154,194,62,247,36,43,127,193,25,47,181,9,25,192,153,65,200,221,9,158,6,157,244,109,247,177,51,121,211,146,55,15,156,241,185,95,244,136,104,212,153,188,111,137,168,143,167,176,147,190,233,62,129,160,71,114,251,156,241,219,123,39,118,51,181,250,186,147,217,156,101,177,234,100,10,110,47,139,37,39,115,43,203,221,93,6,146,215,226,24,139,56,139,45,145,140,176,40,58,153,69,121,235,222,112,178,197,37,45,50,64,219,157,236,130,
123,19,154,176,32,113,158,130,114,168,27,197,81,12,112,79,98,51,113,29,175,253,108,211,25,95,220,237,35,16,1,194,115,79,201,191,225,76,85,183,76,212,128,166,156,169,197,89,178,73,140,21,43,39,119,203,66,162,55,232,100,23,77,77,164,156,220,34,62,17,255,119,156,169,10,34,137,246,104,131,239,30,117,119,211,132,120,192,201,85,218,196,70,218,138,126,24,180,50,60,131,216,49,152,188,119,196,116,13,104,218,153,42,172,56,185,114,67,217,4,198,24,101,55,85,73,239,40,120,57,39,93,94,213,226,67,156,56,237,164,139,222,10,142,132,155,161,38,235,228,37,233,140,23,201,58,214,6,177,45,130,108,63,72,241,228,129,248,189,78,238,126,10,67,252,101,236,247,62,84,108,142,59,217,251,97,17,117,96,138,45,162,78,39,87,77,131,170,131,90,244,122,100,92,136,86,104,172,186,89,169,79,220,119,101,103,183,86,242,174,83,162,250,8,243,58,139,37,234,46,47,43,147,78,122,198,152,123,130,184,135,48,217,143,99,110,15,86,122,159,18,246,85,153,59,228,140,223,141,131,242,72,201,98,72,92,99,60,13,225,40,113,25,175,117,43,
81,35,16,251,166,61,6,40,186,221,81,8,220,49,10,202,189,101,98,225,164,31,156,150,132,176,51,121,39,32,225,91,180,213,47,86,41,131,167,1,42,42,205,66,117,51,103,74,234,158,147,185,59,211,132,148,233,198,12,73,207,220,81,145,61,81,73,13,177,160,252,240,17,135,198,8,188,41,41,21,154,173,150,115,50,37,247,56,15,184,159,185,169,162,39,182,233,226,172,180,119,97,105,27,218,159,97,109,217,253,23,247,88,210,222,143,138,162,142,35,81,133,253,16,85,198,156,160,116,245,1,65,226,125,83,225,3,78,166,204,184,48,53,127,223,148,250,73,39,115,219,64,168,170,171,84,116,230,182,194,29,112,174,222,246,232,215,71,162,241,162,176,27,39,234,24,116,215,253,92,86,159,112,178,79,188,9,86,69,39,251,197,140,32,100,155,49,99,6,97,105,86,33,123,76,151,14,97,224,18,129,154,87,196,44,218,58,189,155,170,205,58,169,251,75,80,204,239,94,174,225,217,28,89,185,188,30,23,5,49,157,91,98,81,175,56,227,247,25,144,164,102,247,10,157,124,101,58,226,140,87,141,11,25,76,180,177,138,154,202,20,7,89,152,136,170,143,41,69,
133,148,69,17,199,21,9,165,193,68,226,132,34,161,238,167,249,193,92,173,133,26,78,46,170,244,195,78,54,235,165,157,220,237,48,4,116,79,230,22,19,145,65,65,104,22,220,199,172,220,119,104,255,172,124,164,248,10,222,201,230,170,10,89,150,240,103,23,85,200,238,53,112,7,147,173,164,246,243,250,144,169,142,124,232,100,171,222,214,238,53,13,189,107,143,60,35,41,8,181,33,138,66,208,77,51,248,8,50,21,190,0,70,13,229,49,79,111,231,144,67,133,231,74,43,90,140,66,27,208,156,32,214,12,40,32,55,156,220,29,79,67,197,207,51,153,53,135,242,77,193,180,104,174,44,225,244,92,118,206,31,82,135,49,61,30,121,215,180,122,151,89,29,145,128,119,176,209,13,106,181,140,224,30,232,1,101,205,104,167,156,229,17,153,100,34,76,105,115,217,116,210,215,109,149,161,102,115,144,82,92,33,163,99,74,92,84,19,187,87,171,121,154,199,251,92,58,174,57,83,235,56,203,42,137,182,118,116,176,3,177,145,12,160,132,145,146,45,153,189,101,20,15,152,52,120,144,131,42,32,170,65,168,180,39,106,0,150,235,143,37,129,45,240,145,55,163,
85,175,51,245,197,160,236,101,34,208,19,44,152,151,37,101,130,1,146,45,60,97,193,94,88,72,201,238,9,39,189,56,175,197,49,74,49,130,225,254,9,140,206,203,204,25,25,124,130,21,227,122,188,220,112,202,153,188,219,41,234,62,230,130,37,55,7,217,57,58,161,193,129,241,91,255,68,59,143,6,124,39,37,217,233,92,41,217,206,100,137,154,75,63,240,212,145,84,121,65,3,194,189,229,76,222,82,176,136,113,250,65,151,196,68,32,108,151,82,26,96,97,79,13,89,159,96,100,152,42,166,105,231,154,165,90,54,165,250,184,9,96,87,170,24,192,45,74,118,5,30,154,24,0,110,50,169,75,102,145,3,218,134,175,24,156,41,152,113,67,127,22,134,208,173,83,192,205,188,116,207,224,112,16,221,219,29,26,24,58,146,88,187,211,181,54,117,30,104,85,78,167,51,53,199,246,58,189,48,228,92,190,211,198,192,235,66,9,103,139,245,30,196,211,27,153,46,136,187,157,76,78,190,116,59,151,11,93,136,99,79,37,69,151,184,143,83,198,41,238,151,10,41,39,117,35,184,155,172,69,156,100,172,109,215,134,215,30,251,153,218,90,197,177,138,214,32,141,167,212,
5,157,171,115,84,238,116,169,141,157,130,46,191,10,102,154,176,98,11,88,14,14,37,40,30,145,233,220,122,167,51,61,103,131,12,64,164,131,143,136,66,206,213,79,122,216,196,86,177,19,9,183,24,31,211,12,69,99,108,129,150,159,163,196,167,113,243,106,77,13,214,230,92,125,208,102,184,166,162,171,206,244,109,142,94,247,159,70,12,65,214,88,212,73,99,74,116,192,185,150,181,208,139,203,139,238,13,100,119,80,153,131,206,116,133,50,210,132,206,96,196,180,74,65,118,103,230,238,241,208,14,208,162,26,130,80,119,57,87,138,68,169,144,198,24,246,166,123,238,67,8,180,3,139,32,0,97,27,122,68,216,230,92,97,206,94,187,141,144,69,54,186,198,246,64,165,175,219,88,55,132,132,117,136,21,16,118,136,91,167,241,191,97,108,186,182,212,24,151,37,102,239,244,196,32,137,208,214,166,108,90,187,215,153,169,215,11,156,192,166,11,28,242,138,121,128,102,143,234,33,173,76,206,242,182,246,181,123,206,120,197,180,115,175,147,254,68,21,165,17,122,143,38,184,130,109,87,127,18,118,174,14,245,56,87,38,45,97,84,50,97,230,31,
205,97,92,119,49,108,147,227,65,166,166,17,209,165,162,99,166,62,234,81,157,31,167,185,164,141,141,136,35,232,37,142,12,151,178,67,220,25,195,151,214,181,67,49,24,46,177,179,141,87,153,136,151,178,244,127,82,231,185,100,41,78,145,208,9,246,221,8,16,127,204,73,46,250,11,172,220,5,86,11,187,63,210,38,243,163,149,78,170,139,173,45,85,104,108,137,189,20,225,160,147,249,130,234,152,228,104,153,70,107,154,8,93,222,114,31,58,151,63,202,97,156,203,188,43,170,208,61,29,66,72,119,65,115,97,137,76,32,120,170,186,160,69,47,232,118,103,106,193,179,53,144,52,60,148,169,89,185,197,193,236,30,103,62,230,202,99,142,70,158,70,46,171,198,184,197,106,206,35,99,144,250,69,103,234,137,248,152,99,102,142,115,196,200,49,245,33,254,28,72,189,23,26,217,192,97,186,194,57,144,243,123,151,209,203,136,235,145,236,12,122,103,180,184,37,221,20,177,172,198,159,35,195,235,6,83,72,187,36,198,76,210,164,233,210,225,230,159,39,41,102,234,126,206,98,147,0,123,89,66,207,136,111,28,249,230,217,183,125,14,83,198,62,
222,34,10,230,192,69,53,223,90,64,190,199,169,181,88,215,105,208,130,158,83,231,19,140,153,122,226,42,116,212,109,195,153,135,78,142,179,117,99,2,151,190,210,12,239,164,164,168,166,219,188,0,60,81,151,114,14,50,239,4,56,204,246,86,114,43,130,17,236,77,87,231,44,29,236,243,36,136,96,164,87,52,47,138,88,106,142,79,130,106,22,126,69,181,220,241,187,77,245,170,181,167,106,93,50,223,185,138,150,169,77,206,167,95,116,171,14,51,206,116,149,227,71,129,243,182,114,68,255,61,113,166,203,28,153,238,145,67,53,223,52,46,76,23,12,201,40,0,237,31,218,114,59,217,76,127,186,224,100,158,48,32,238,124,149,50,45,56,101,48,242,154,233,173,201,241,5,135,154,113,145,126,193,12,220,244,218,176,209,53,7,200,14,6,182,13,74,175,22,183,52,106,245,82,209,166,113,71,11,246,144,151,127,204,57,109,206,114,46,149,44,218,144,35,100,218,116,182,181,59,6,149,140,184,204,240,200,220,14,56,233,199,16,44,250,212,207,163,118,103,236,147,28,4,1,196,177,53,100,111,91,206,216,181,77,195,145,229,76,62,54,197,36,167,113,
199,208,69,220,233,176,185,160,51,86,180,155,0,157,233,97,200,233,128,33,53,20,238,216,101,94,39,85,188,215,181,175,94,95,140,178,32,94,215,57,115,17,166,94,162,194,104,5,167,241,217,195,116,136,0,153,97,253,80,152,204,238,13,109,184,55,30,119,1,41,2,9,139,116,133,135,65,231,250,156,167,179,58,163,239,62,249,155,42,200,32,194,158,173,232,149,72,109,175,3,227,36,177,48,7,130,180,188,213,89,96,211,185,92,212,65,144,56,102,231,244,190,25,32,96,11,206,165,98,157,119,175,194,203,151,233,119,206,53,94,166,135,15,95,166,143,89,127,240,214,134,245,7,188,76,255,235,11,191,107,61,75,172,89,207,146,92,227,107,110,175,55,190,102,121,60,120,6,88,5,88,130,160,12,34,81,182,60,30,188,164,128,5,56,184,31,34,120,240,94,2,197,37,81,80,139,75,148,201,101,168,17,53,158,17,34,3,66,162,4,44,131,228,26,159,23,98,30,32,28,2,142,131,52,4,85,41,71,62,15,222,248,242,79,173,103,54,242,82,92,147,21,48,147,21,203,227,193,51,64,204,178,109,16,82,50,137,18,30,188,20,64,214,207,236,9,184,132,72,9,49,97,137,224,
217,24,38,37,115,214,179,203,242,240,178,108,205,89,158,1,130,24,131,243,178,116,92,70,7,15,94,18,224,101,33,242,112,113,252,242,146,0,121,240,4,132,219,56,50,38,215,17,97,28,17,112,172,137,120,169,3,61,2,34,214,232,72,138,3,217,70,135,128,38,180,74,72,30,196,56,242,73,70,35,138,232,73,96,54,39,11,16,10,20,190,200,42,19,69,56,15,227,158,196,100,19,69,101,10,93,9,153,155,144,15,112,41,83,9,233,17,199,129,40,195,1,64,89,50,9,17,7,148,141,132,72,135,18,66,216,199,21,146,113,228,43,233,9,37,68,201,176,193,30,38,132,7,37,229,217,36,161,181,177,55,149,131,37,69,104,121,240,4,156,36,75,60,63,179,207,131,176,207,67,13,82,192,177,166,89,135,113,151,89,6,216,140,228,97,20,137,160,76,107,198,252,104,166,26,177,55,9,105,164,18,29,38,188,32,76,66,112,198,132,89,174,43,30,38,191,0,199,176,72,34,15,117,8,105,128,198,109,66,32,14,194,122,224,126,35,80,10,175,50,149,32,83,74,138,68,152,216,203,58,5,75,62,152,108,1,32,157,141,16,31,36,93,141,32,160,26,205,164,82,8,211,29,66,0,52,8,35,178,169,92,
86,9,72,83,52,18,178,12,130,118,105,36,164,74,66,38,73,70,138,2,178,133,49,201,160,128,4,180,145,147,226,154,148,35,147,200,225,193,19,112,146,146,176,137,125,74,8,3,196,102,1,85,35,138,255,101,137,186,140,18,30,228,80,163,172,17,121,136,80,127,154,178,86,36,17,153,60,8,175,50,165,14,57,224,58,12,175,73,33,162,228,182,194,252,18,65,53,24,160,12,224,58,68,152,134,3,112,232,250,183,106,177,250,101,239,179,196,6,44,92,47,135,217,6,134,39,54,182,23,158,141,19,47,51,214,4,129,198,180,21,135,164,84,67,156,97,242,82,141,9,40,108,213,173,167,12,147,169,111,70,188,103,215,136,152,70,157,52,165,12,3,97,59,192,104,116,166,54,158,10,66,32,85,50,26,93,104,109,12,168,26,163,150,182,105,116,119,195,168,70,202,198,43,164,236,176,231,15,60,58,232,121,89,45,135,14,107,79,150,11,56,158,4,65,156,177,19,7,209,98,234,2,160,58,152,73,250,44,169,145,154,100,164,106,172,38,74,152,204,195,179,49,174,201,249,223,35,253,64,121,128,226,119,122,27,211,150,138,73,108,120,41,162,5,20,103,198,151,183,23,26,186,
229,234,161,97,194,10,128,154,198,76,144,26,51,11,96,81,158,101,156,146,116,216,20,154,34,2,226,189,153,84,178,216,112,168,146,43,238,211,133,86,152,77,138,255,106,195,252,175,190,79,97,254,217,43,117,230,171,20,61,209,232,141,228,60,29,160,174,81,111,76,206,187,255,148,186,165,118,91,51,224,175,180,56,95,109,58,127,195,147,246,213,58,211,170,205,223,240,254,164,83,5,91,99,235,21,137,3,32,27,118,235,21,169,245,138,116,228,68,78,69,180,94,145,190,23,175,72,47,63,25,253,246,127,110,124,50,26,57,252,100,244,166,245,135,111,253,196,250,67,62,25,253,155,94,207,77,61,31,45,88,207,71,184,108,126,145,241,237,146,229,143,20,130,254,104,193,155,121,62,122,17,232,4,216,248,170,63,18,111,243,237,137,128,63,122,209,91,122,62,50,12,34,97,61,31,141,173,250,163,49,203,183,19,109,254,200,176,183,2,37,192,17,144,169,117,223,78,33,102,164,29,78,111,22,74,196,36,133,152,1,1,117,210,130,211,63,246,124,36,5,7,92,118,42,11,162,195,31,69,207,72,202,219,122,41,42,183,226,219,57,137,2,17,71,199,104,14,
81,121,56,50,121,223,206,4,252,145,60,200,156,31,124,158,0,113,1,147,147,249,77,63,153,15,248,23,46,6,253,68,206,155,127,126,1,115,147,40,79,196,231,253,68,188,195,103,237,95,24,246,214,159,95,56,127,128,88,7,17,4,209,233,95,56,143,231,73,27,81,17,56,46,174,248,137,139,109,62,107,63,105,123,171,207,147,152,123,1,7,19,73,16,201,14,159,181,159,76,97,213,5,194,193,56,5,129,142,36,162,114,237,254,133,132,56,154,86,37,38,150,252,4,1,196,66,144,222,230,75,142,17,219,79,140,68,1,162,39,65,116,163,40,183,225,74,38,179,88,20,199,251,128,31,181,9,162,141,15,81,172,74,14,131,24,30,242,163,145,118,223,78,10,1,117,20,100,210,94,194,204,118,63,138,1,118,14,171,162,138,108,6,196,133,25,63,121,161,135,120,89,126,52,142,85,2,70,201,73,114,120,30,81,29,126,52,70,122,51,112,40,223,6,129,231,73,2,24,141,117,146,119,130,104,116,40,186,54,28,118,167,31,197,15,116,32,234,64,121,10,68,10,4,209,53,8,229,35,114,193,122,30,75,173,250,177,84,192,143,92,232,84,62,102,137,17,136,15,64,196,151,252,24,249,142,
124,0,34,137,142,136,66,14,50,118,113,214,143,93,20,16,174,8,58,34,132,132,15,100,207,99,68,55,134,252,68,38,232,71,108,170,36,130,15,49,174,196,197,25,18,213,225,179,246,35,49,16,49,113,72,207,197,121,63,130,169,202,73,204,182,159,199,48,202,24,150,153,241,35,68,35,65,105,197,114,174,219,215,234,3,2,19,111,245,193,255,215,125,176,211,247,156,19,145,105,146,8,63,121,251,145,114,27,221,209,230,39,74,30,173,195,236,51,173,195,236,139,48,251,88,211,215,204,12,250,171,217,111,238,187,52,26,80,155,166,190,232,165,76,207,70,152,65,177,212,22,164,244,108,92,189,75,167,39,24,51,106,209,72,194,61,230,71,18,13,150,196,4,163,215,180,57,216,72,124,11,114,212,79,48,197,51,66,104,48,48,122,35,31,177,79,69,62,162,109,217,92,24,27,105,99,148,17,118,65,194,46,192,131,126,38,77,150,177,208,228,25,94,242,35,195,1,88,64,92,100,160,196,48,202,140,7,118,176,72,44,208,176,90,131,49,129,147,70,22,179,201,168,183,177,56,197,94,97,68,105,160,196,64,48,101,98,204,38,68,109,62,143,0,52,92,73,166,153,128,
41,70,80,18,4,131,170,161,131,169,204,0,107,232,72,106,104,53,3,25,75,49,230,216,12,19,12,248,72,10,14,19,93,69,38,153,66,20,49,156,80,148,217,218,204,158,199,14,19,179,25,165,12,248,17,54,220,81,141,82,109,157,35,239,131,120,63,237,199,222,239,242,71,222,15,179,133,10,33,207,49,96,36,182,226,143,24,115,217,112,101,238,8,33,20,98,148,57,62,106,19,69,244,140,140,224,224,8,233,24,229,138,217,121,116,64,205,144,31,209,140,21,80,27,123,44,137,185,162,38,43,163,182,56,36,70,230,26,63,56,27,144,170,17,57,40,32,74,225,208,184,6,24,107,7,169,232,30,20,215,65,62,152,190,212,22,209,61,8,251,121,106,235,60,86,217,10,164,18,197,222,157,80,161,188,199,28,127,143,45,1,203,98,195,7,25,20,34,50,203,30,1,181,16,113,78,20,49,60,143,124,8,87,124,150,77,189,221,103,205,102,162,232,98,174,118,152,88,98,197,143,17,192,72,4,229,73,234,215,132,93,14,146,40,83,186,113,196,105,107,83,149,70,56,35,196,56,56,196,56,31,68,206,83,113,242,195,230,252,161,188,71,41,134,104,44,76,190,25,27,121,10,206,108,134,
178,106,136,237,101,168,155,125,155,45,58,199,166,46,14,237,171,145,243,20,195,249,54,184,216,141,243,148,181,217,137,101,114,50,111,196,68,47,194,145,193,92,33,76,132,209,49,26,35,181,210,145,33,181,58,50,9,57,26,95,33,215,29,0,57,4,165,164,131,189,109,36,49,79,117,104,7,30,123,62,58,108,251,163,195,94,0,32,28,248,50,58,146,226,28,213,205,134,78,106,19,10,59,209,85,172,46,170,40,134,35,68,54,224,95,28,25,34,102,68,96,88,49,195,236,24,186,34,9,204,78,208,64,153,30,63,145,215,30,174,132,201,159,30,204,238,233,98,227,37,55,50,34,161,188,15,83,191,195,68,55,230,119,55,250,86,122,194,80,134,105,206,97,42,94,85,162,180,170,15,35,38,231,202,30,8,29,178,26,253,167,188,231,77,90,35,228,35,102,251,39,26,93,75,6,35,56,22,25,38,23,28,203,200,249,187,173,189,91,229,254,58,237,221,223,143,151,138,244,95,112,22,119,127,57,218,42,185,215,173,228,90,175,77,127,237,175,77,28,23,191,31,141,254,61,250,122,240,253,72,72,107,242,182,62,88,181,62,88,253,197,31,172,94,126,224,13,166,26,31,120,47,28,
126,224,13,88,95,243,63,216,125,205,7,222,127,123,101,223,122,81,252,73,190,94,204,229,95,204,241,167,145,245,185,82,248,197,77,254,202,165,126,115,237,219,168,147,245,185,114,232,40,106,121,181,94,188,24,17,215,183,80,207,226,47,22,107,225,23,149,90,170,190,88,121,88,175,84,158,110,1,232,0,48,83,95,44,207,214,43,101,175,173,73,145,5,224,30,7,226,255,247,118,240,219,109,245,202,70,241,197,157,154,191,80,191,179,108,189,88,146,61,75,107,146,229,7,235,149,181,223,121,204,202,61,1,81,39,68,110,174,126,103,227,161,22,29,44,58,160,198,232,165,79,221,94,86,249,250,210,74,30,98,111,180,94,41,185,125,47,22,248,31,62,234,11,101,86,243,159,181,189,184,93,75,215,231,83,59,163,245,219,243,254,130,68,118,215,43,213,32,54,33,114,241,147,135,64,86,235,149,187,17,97,114,245,138,1,32,117,177,22,169,87,30,185,199,234,139,69,247,4,184,173,122,229,211,144,104,226,208,184,199,181,234,173,87,30,88,146,19,175,47,222,48,160,21,112,241,38,106,1,33,13,162,25,67,212,91,95,156,183,128,228,235,149,25,25,
203,125,62,47,238,38,98,3,64,86,8,201,189,107,88,50,245,197,91,155,64,176,239,150,177,15,204,82,67,44,1,154,233,110,114,243,215,59,16,165,235,149,226,44,247,108,189,114,219,253,188,41,167,116,160,186,124,84,245,58,102,14,53,153,103,155,8,108,57,180,237,115,119,172,94,185,242,68,50,240,182,224,41,37,178,138,36,17,255,238,250,157,89,66,219,0,21,127,42,254,151,200,229,250,157,181,89,37,231,68,125,233,179,206,23,149,45,55,83,175,76,111,146,146,173,250,194,114,207,139,249,90,144,132,244,212,231,103,17,125,123,229,94,147,153,16,205,73,202,220,162,245,162,196,31,80,213,75,89,10,245,51,183,227,197,236,70,71,189,152,18,58,85,159,205,122,86,125,238,166,191,192,83,190,62,135,201,55,249,63,131,234,55,203,221,0,108,0,75,146,18,175,207,45,144,141,185,218,74,125,174,24,111,146,20,68,178,89,159,171,134,69,130,34,254,128,234,96,101,53,203,252,37,104,230,233,127,89,120,13,250,196,107,127,113,183,134,235,159,201,224,148,85,191,187,238,165,126,101,17,140,6,116,243,235,183,107,199,190,126,251,73,
240,235,183,255,81,224,235,183,183,184,190,96,253,152,251,79,184,54,89,111,112,255,156,235,17,235,135,220,255,33,215,58,235,53,238,15,184,223,231,190,202,245,25,235,79,185,87,185,238,177,254,49,247,21,174,187,172,151,3,210,249,245,219,119,120,94,226,249,19,238,21,235,87,150,205,122,145,245,2,215,109,214,243,220,203,92,183,142,253,202,138,115,159,227,154,229,42,129,187,201,253,31,112,47,130,27,193,230,2,207,51,60,255,125,238,55,184,174,179,206,115,159,70,238,135,220,175,241,60,197,61,199,117,149,117,150,251,21,120,7,185,103,184,46,115,165,129,79,114,159,224,26,199,198,48,114,199,88,95,226,74,129,251,17,87,146,245,199,92,54,114,67,60,39,88,143,114,93,100,45,27,99,92,81,228,246,114,191,192,53,2,124,152,123,132,235,35,214,178,229,60,188,39,185,15,241,252,1,119,217,112,142,245,0,247,247,225,237,66,111,152,231,126,158,251,184,159,229,30,226,58,131,77,157,224,78,179,126,143,171,23,220,41,238,61,92,127,143,245,73,228,118,176,254,187,172,187,185,255,29,174,46,214,127,155,251,187,200,61,
1,239,111,243,220,201,243,223,226,122,135,245,223,228,222,129,220,227,228,227,183,120,110,231,249,111,112,63,193,253,109,174,54,214,63,68,110,128,245,113,174,183,120,14,114,255,1,87,128,245,155,200,181,144,123,140,231,55,120,182,230,27,133,245,224,36,181,4,31,123,199,193,255,168,253,198,76,99,31,137,30,238,35,63,176,254,136,125,228,143,216,71,254,93,156,63,236,251,249,199,76,223,167,31,151,173,159,39,87,188,212,211,100,233,247,122,127,254,241,138,64,37,64,159,10,84,22,232,144,106,77,160,138,64,252,53,250,211,143,43,135,84,238,179,163,100,127,89,97,143,37,172,122,40,204,255,231,191,142,176,63,103,153,247,211,87,40,236,187,177,141,29,198,54,104,253,49,63,194,254,49,177,253,247,99,196,246,23,163,24,242,229,104,197,250,69,130,168,125,153,32,106,71,64,143,4,90,22,232,145,168,150,161,122,9,34,28,95,142,86,15,25,137,237,17,206,95,83,24,177,125,117,194,136,237,171,19,246,221,216,198,15,99,251,150,245,39,196,246,79,136,237,127,184,72,108,127,25,37,68,95,69,171,214,47,99,68,237,171,24,
129,60,2,122,44,80,85,32,182,137,175,162,107,80,81,202,95,197,40,229,35,160,154,64,107,196,246,8,231,175,41,140,216,190,58,97,196,246,213,9,123,25,219,227,167,26,51,225,226,97,108,143,91,127,202,76,248,83,98,251,31,251,221,111,172,189,208,178,223,189,29,90,78,239,133,43,126,104,59,92,177,247,206,21,252,220,246,185,66,231,94,184,228,207,110,135,75,193,189,80,9,84,168,100,239,133,203,126,122,59,92,238,222,59,87,242,23,120,234,220,62,87,242,110,2,121,184,119,170,228,91,219,167,74,11,123,103,150,253,240,246,153,229,248,94,95,25,154,51,165,182,109,22,249,237,51,200,57,85,242,182,160,89,218,59,83,246,237,237,51,229,80,147,166,218,14,141,103,109,159,169,186,55,26,160,129,92,64,108,189,219,3,57,123,239,131,28,6,125,144,235,220,27,40,251,241,237,129,114,120,175,175,228,119,110,247,149,114,123,33,163,163,220,182,205,162,27,137,246,222,123,37,104,222,43,133,247,78,85,161,57,85,205,73,89,16,212,236,94,223,178,223,177,221,183,156,151,27,11,24,109,201,141,32,46,204,238,133,11,216,218,87,206,
111,135,249,179,9,52,219,114,163,7,55,254,215,88,43,66,255,247,8,141,237,157,90,35,155,167,214,66,36,219,143,144,232,33,229,208,38,138,33,19,87,98,74,164,21,224,112,97,133,194,242,54,247,250,114,167,129,250,73,114,67,30,115,254,24,249,105,219,59,53,161,130,201,247,108,179,24,35,199,200,202,147,132,190,82,199,94,56,167,140,229,144,195,130,167,213,237,115,57,111,125,175,47,31,5,234,191,187,221,151,239,148,246,5,180,83,210,37,4,134,74,61,123,252,94,177,176,119,110,2,93,121,116,133,11,217,237,115,19,16,203,158,80,70,114,50,233,109,22,157,219,225,76,240,64,114,84,146,183,144,58,180,119,170,34,123,202,216,83,145,61,133,54,172,164,17,250,10,145,35,246,24,191,114,7,126,165,186,100,207,200,118,95,10,123,80,177,125,38,99,193,137,156,129,76,4,78,220,25,200,116,236,125,32,195,250,114,169,109,22,189,4,192,216,140,61,249,46,236,246,51,216,210,38,155,243,216,98,186,207,6,28,82,139,69,104,159,161,189,51,166,90,51,167,183,89,192,158,193,83,161,194,160,206,25,191,8,11,139,1,242,96,228,20,137,106,
151,90,140,54,204,111,190,126,5,253,170,102,16,101,183,132,155,238,179,147,175,159,143,216,70,17,188,46,99,237,53,156,106,173,34,248,235,222,219,94,30,19,250,245,191,165,6,248,55,158,62,60,60,39,252,208,250,179,183,238,89,127,198,57,225,63,89,191,107,237,15,173,89,251,161,13,247,193,78,104,99,115,103,104,109,115,191,127,195,218,31,72,173,238,12,164,78,239,244,111,184,31,238,15,229,230,119,134,114,99,251,67,203,222,59,59,67,203,238,181,253,126,120,6,214,86,118,6,214,226,59,253,28,143,247,67,0,134,170,169,157,161,106,112,39,180,54,203,90,66,189,147,8,109,3,232,142,54,88,170,75,59,3,213,65,177,32,181,154,6,35,82,116,235,63,13,146,229,249,157,129,229,176,72,70,155,166,165,16,18,196,178,217,253,80,77,90,220,184,248,118,66,252,83,28,77,169,24,82,29,18,203,192,81,169,221,144,121,233,38,9,82,171,182,72,250,176,235,136,173,27,72,197,86,164,46,67,142,170,67,91,151,177,117,185,71,44,73,208,114,109,129,8,184,33,34,224,217,251,253,48,13,24,146,174,157,254,170,59,1,10,143,151,17,176,140,173,
203,72,149,150,53,145,175,185,239,226,1,138,77,212,76,8,8,172,241,239,101,8,6,100,108,180,65,178,134,230,53,19,130,145,253,33,196,132,214,16,187,134,88,25,171,64,175,185,197,166,216,181,135,77,75,154,81,147,245,67,107,105,19,45,124,234,144,212,124,147,36,141,63,105,25,139,84,229,28,229,161,106,0,210,98,35,176,149,149,157,161,138,108,173,185,149,253,48,161,198,198,99,24,186,178,19,174,61,29,218,15,207,135,89,8,106,129,117,79,236,132,231,45,176,222,140,158,130,160,188,89,74,7,254,254,141,167,179,13,234,121,40,191,205,213,11,71,59,156,94,4,253,238,0,6,52,157,62,43,63,243,235,59,161,124,112,231,44,53,99,194,174,204,40,208,103,41,177,157,179,107,1,140,95,21,203,234,126,63,134,132,136,248,217,218,250,206,217,90,7,81,7,41,11,142,72,53,18,33,217,128,100,195,66,50,82,55,200,212,17,169,232,90,235,70,42,122,141,84,177,24,169,91,72,165,146,151,197,130,135,72,229,169,42,249,21,73,196,172,141,37,80,1,36,119,238,132,248,183,52,246,251,203,10,169,177,181,3,169,109,144,119,236,244,151,253,162,
9,216,89,217,91,37,156,138,184,12,38,112,89,65,78,72,44,10,10,77,177,107,155,160,36,22,131,11,223,53,22,198,42,10,171,136,53,202,148,15,62,195,226,187,133,88,120,148,238,144,242,22,90,243,230,95,90,75,18,251,215,176,75,98,43,110,198,48,155,200,110,224,233,6,85,94,21,175,191,108,154,191,105,172,60,134,165,214,174,24,216,50,246,104,12,164,185,58,3,99,119,67,113,197,189,209,144,170,248,173,225,151,98,208,191,108,196,222,51,98,27,6,11,83,83,116,72,216,6,237,217,140,202,183,140,37,180,38,6,232,59,20,107,226,46,99,201,87,37,208,48,214,100,146,114,60,171,114,60,91,67,226,218,65,8,26,177,110,74,53,37,251,73,118,39,252,73,39,36,146,106,239,135,151,169,235,229,184,169,175,240,143,211,59,225,31,103,113,166,195,248,16,254,116,118,39,252,105,10,37,193,253,240,253,193,157,240,253,135,251,225,245,212,78,120,125,193,100,83,77,24,126,4,255,163,30,226,172,100,182,237,135,55,145,191,89,220,15,111,229,119,184,8,189,114,91,49,237,97,237,15,42,92,170,46,220,136,170,73,162,212,120,168,194,236,32,248,
131,181,56,237,163,248,149,183,118,66,101,111,105,63,12,233,1,75,84,108,252,211,117,212,67,167,97,83,217,13,18,194,240,134,186,136,127,55,101,39,84,106,170,81,74,197,199,187,50,24,132,149,58,118,162,228,97,176,134,227,68,156,38,133,165,60,143,22,255,152,233,113,67,109,234,25,142,242,18,8,13,253,160,81,4,78,28,212,105,105,69,58,54,13,135,100,27,219,164,35,207,28,206,107,160,91,232,144,46,154,155,127,155,225,187,28,74,65,168,36,206,85,40,201,95,169,145,138,232,90,143,56,162,136,194,170,124,211,42,190,8,152,112,73,79,40,135,242,92,39,92,65,44,107,223,137,210,0,13,29,101,16,229,35,86,41,192,134,163,76,63,151,187,141,158,126,226,172,8,52,173,82,24,75,84,197,193,32,59,112,166,17,44,5,74,228,154,107,198,117,210,88,96,226,20,188,117,147,18,57,33,5,141,240,162,164,212,99,168,229,122,255,26,102,109,120,131,47,147,40,42,163,231,208,44,101,183,3,29,234,40,77,204,0,220,10,86,101,83,149,178,98,106,235,128,203,56,82,146,14,185,46,7,20,94,149,184,56,14,92,55,129,106,234,105,112,40,83,242,163,
219,200,87,181,71,171,38,133,170,6,74,235,168,124,147,148,50,14,150,181,207,169,170,228,117,183,172,34,33,37,170,129,215,122,211,33,71,185,66,37,204,53,86,137,186,203,68,160,191,106,146,174,9,81,98,74,170,126,15,76,107,100,125,19,225,202,186,105,22,76,130,117,163,49,1,91,155,128,58,184,181,9,40,6,71,119,172,214,38,208,156,27,26,107,173,77,160,181,9,188,22,155,64,99,147,97,99,51,199,169,161,230,70,208,201,113,74,155,25,27,39,239,55,58,86,53,142,84,156,151,217,243,27,199,169,65,104,187,191,115,156,250,246,46,113,112,172,210,38,121,116,183,104,29,175,8,72,235,120,213,58,94,253,101,143,87,165,214,129,247,232,209,245,53,56,240,182,94,11,143,190,72,154,132,252,198,95,11,191,71,57,249,238,139,173,153,0,141,47,6,102,131,54,111,182,255,236,129,62,188,180,94,189,90,175,94,173,239,111,28,173,90,223,223,90,223,223,94,251,239,111,173,87,175,195,79,175,173,47,219,124,8,254,214,151,237,214,17,198,252,44,215,250,9,145,31,17,90,63,33,246,243,19,122,235,39,196,198,207,116,173,175,199,173,159,16,
95,151,159,16,255,207,71,152,111,253,132,200,39,96,243,139,59,63,44,235,151,196,111,127,31,254,243,191,34,242,11,98,235,207,151,248,173,188,245,231,75,251,67,255,239,127,190,180,206,31,70,172,235,79,230,254,183,0,0,0,0,255,255,3,0,16,252,81,205);


programfile__RRWALTZ_MID
:array[0..5505] of byte=(
120,1,236,92,235,83,92,71,118,63,35,44,93,116,141,109,57,150,189,178,101,105,181,24,152,59,6,33,64,82,244,0,163,25,193,12,8,51,26,4,72,22,150,173,149,98,171,140,55,142,228,248,81,195,166,210,77,33,45,85,254,178,91,36,89,231,85,251,105,191,228,67,42,181,222,135,119,189,251,33,149,119,82,249,188,127,192,230,253,250,35,148,223,57,231,222,75,15,61,131,24,140,40,63,84,101,51,115,79,159,87,159,87,247,237,62,163,242,236,252,235,68,180,139,50,180,135,22,202,179,239,252,38,158,46,209,221,203,15,181,236,216,215,74,119,231,118,220,37,186,123,161,165,245,147,206,239,180,222,221,181,243,82,113,122,166,248,23,116,119,215,174,145,241,202,244,197,25,249,122,118,250,220,232,88,241,207,250,106,198,87,129,45,179,133,49,186,123,132,148,251,99,191,67,119,191,150,1,211,150,182,169,115,133,243,149,67,229,226,100,101,116,142,254,138,232,163,96,145,62,10,243,148,39,250,21,229,191,211,186,82,54,52,109,126,247,163,252,98,199,202,52,81,153,162,146,121,246,163,60,61,188,82,162,204,180,161,9,243,20,198,30,
95,153,32,154,166,28,0,147,38,59,201,223,51,66,248,12,80,75,249,197,125,74,59,85,50,143,3,240,84,74,27,130,246,192,42,109,217,100,203,66,59,110,168,108,30,2,234,115,43,227,148,153,48,9,94,6,195,224,59,46,99,251,243,139,115,24,134,78,84,48,135,128,28,172,20,40,3,210,17,115,0,124,195,149,17,34,80,23,77,182,40,218,140,155,29,64,90,218,149,95,156,87,178,131,120,12,121,130,227,102,4,4,143,196,204,38,204,126,12,180,65,173,204,36,143,5,24,59,196,99,147,148,155,48,84,50,143,97,248,108,126,49,139,105,208,4,101,241,148,89,17,177,123,128,249,21,21,155,27,49,52,44,2,59,87,134,41,147,55,64,91,204,173,192,172,35,180,116,8,108,42,50,135,73,158,252,164,121,24,131,207,174,76,242,84,33,141,246,230,23,69,124,133,186,240,180,67,85,124,14,56,135,85,197,168,192,86,167,199,211,249,170,15,156,249,18,134,69,169,178,153,3,221,216,10,140,52,78,75,111,127,169,189,41,86,239,128,57,90,86,42,236,57,184,23,177,154,153,97,103,180,192,96,75,7,24,62,131,255,56,140,167,16,198,250,189,98,150,96,79,196,128,140,46,
96,180,108,90,129,63,206,86,157,48,89,112,2,226,164,121,3,72,83,236,22,80,206,50,211,118,0,186,243,36,226,102,99,216,20,152,224,123,217,28,4,113,197,0,241,118,30,207,21,10,11,28,108,136,201,197,1,248,53,66,188,33,132,198,205,35,16,244,12,187,125,132,67,153,19,97,63,135,4,66,90,146,228,81,0,190,34,49,34,193,46,193,156,149,156,249,42,70,122,242,180,147,35,140,189,207,90,47,221,0,240,97,112,139,144,200,5,230,70,7,56,136,74,60,136,212,92,124,138,167,84,162,11,194,135,67,241,96,126,113,135,6,29,98,179,19,128,29,156,23,18,70,24,94,252,42,135,217,52,11,80,24,242,55,83,49,136,218,197,12,172,149,21,124,12,163,46,64,248,105,128,31,101,1,211,180,196,53,228,161,21,153,50,203,61,195,50,120,214,156,189,187,49,118,16,105,132,249,254,26,198,22,243,244,24,167,192,132,217,59,78,79,64,122,145,103,163,37,1,51,45,147,230,49,72,139,70,189,91,164,220,56,149,192,37,228,188,44,155,125,224,114,82,83,128,141,90,50,57,140,237,132,195,191,193,41,140,132,140,128,176,244,8,0,221,170,18,91,245,108,172,146,120,
1,9,74,207,170,74,154,171,108,127,81,87,235,84,123,126,241,121,21,192,83,40,152,157,192,239,204,47,118,193,184,200,59,157,22,87,159,78,174,14,96,158,89,209,178,132,49,64,73,213,132,223,80,243,22,59,193,136,45,221,178,34,110,97,229,49,127,118,203,121,129,202,148,56,180,118,170,68,56,6,33,136,153,195,215,98,104,54,218,147,60,54,77,147,2,21,62,79,3,42,214,135,123,133,5,135,252,215,56,25,128,41,17,3,46,57,241,44,87,15,140,28,81,207,66,20,237,130,134,208,105,113,70,98,65,2,103,105,152,9,53,252,53,91,202,113,221,45,211,251,32,121,136,125,54,205,21,29,17,161,222,170,96,201,136,141,134,224,161,219,215,85,244,237,121,177,113,86,60,62,197,222,101,7,195,83,79,64,226,94,173,167,110,25,231,169,182,196,65,9,188,162,137,70,140,16,11,101,193,100,121,25,176,52,98,5,104,151,222,134,149,139,4,36,112,221,54,33,163,102,106,180,254,76,70,77,118,52,94,144,220,153,140,178,122,241,76,96,0,16,175,153,201,168,206,100,116,155,102,82,180,52,97,15,194,27,37,59,60,65,207,242,90,103,241,125,74,22,61,24,55,66,
36,59,56,115,72,76,12,57,144,165,55,75,212,50,65,79,194,137,221,43,229,87,168,240,245,93,226,56,164,4,98,226,236,107,116,254,250,238,243,68,103,17,31,111,209,200,251,187,193,15,1,50,106,105,202,238,5,205,208,202,20,91,33,26,177,84,177,188,109,216,199,75,46,170,231,8,45,20,44,149,45,239,21,224,233,74,236,105,16,231,4,206,82,150,158,225,208,130,164,97,139,2,186,56,130,53,152,100,16,153,77,203,223,136,7,37,64,31,236,109,56,149,30,236,109,16,24,159,227,157,234,103,124,111,179,189,181,183,104,182,97,21,121,80,224,63,187,5,126,114,165,252,54,21,174,238,142,151,154,121,58,63,239,44,53,11,241,82,163,43,196,118,46,56,233,27,248,222,51,201,27,248,78,121,3,167,191,38,250,97,240,58,253,48,124,142,95,189,255,133,242,183,231,127,47,103,178,57,202,244,153,108,31,101,6,76,118,128,50,71,249,125,129,230,12,189,106,178,71,41,131,247,134,57,162,87,137,6,4,254,42,15,49,26,224,0,98,168,207,193,7,147,20,191,199,129,247,56,240,195,38,123,56,145,216,97,178,29,148,233,54,217,110,202,40,188,87,168,46,27,
186,98,178,189,66,117,153,232,10,209,97,67,2,132,110,76,174,64,200,234,118,224,96,146,194,179,2,199,68,192,39,43,112,32,131,79,100,178,81,34,177,209,220,117,142,58,119,157,227,38,230,46,76,88,91,204,93,153,64,1,119,238,77,73,7,55,113,10,91,30,220,212,200,176,124,42,5,150,79,165,192,242,41,188,145,244,94,115,251,13,216,55,254,200,225,9,97,16,127,116,224,9,110,137,63,106,199,214,163,235,6,29,124,16,127,172,229,82,39,206,82,45,97,235,84,123,216,186,209,108,37,40,217,166,152,173,6,37,12,161,179,85,235,232,108,213,58,247,180,53,184,129,74,163,28,220,64,5,29,32,61,149,2,91,167,82,214,137,242,84,219,70,210,123,37,148,143,155,236,113,202,156,48,217,19,148,57,105,232,146,161,171,146,75,39,41,115,137,232,170,228,210,137,24,136,81,70,83,32,70,143,139,86,66,194,76,160,149,146,244,11,31,40,124,213,100,251,133,15,134,64,165,153,172,18,155,146,158,106,5,233,169,86,42,29,218,66,43,149,14,17,24,221,136,244,186,81,222,200,242,169,37,215,68,121,138,175,126,87,79,193,239,41,28,150,79,61,120,79,191,
167,82,52,234,52,90,214,137,58,9,18,174,122,90,221,52,80,181,186,129,21,224,144,174,42,65,7,87,122,179,213,13,130,80,173,180,186,129,33,170,149,86,55,133,107,117,83,56,170,27,128,90,37,81,221,0,212,194,231,86,183,173,146,126,133,101,113,129,190,111,181,149,139,154,174,64,106,85,184,21,89,169,86,133,73,97,112,215,170,117,35,170,129,79,107,56,11,91,158,139,70,11,216,194,110,46,231,173,202,148,45,204,83,232,172,220,80,37,96,10,77,201,117,170,4,144,65,130,106,128,60,5,50,72,144,170,200,211,148,15,170,68,202,199,173,18,117,173,138,24,19,163,61,216,7,196,123,157,47,222,62,160,89,191,107,60,32,97,145,59,154,155,235,172,140,64,70,8,105,46,3,25,36,27,200,101,14,54,141,204,164,38,112,194,186,121,122,95,117,78,43,9,132,106,137,128,230,247,146,126,111,157,27,213,22,152,8,217,170,123,0,8,66,182,34,187,211,44,214,85,88,225,88,133,83,248,154,236,78,225,205,236,1,88,168,238,70,116,159,112,204,100,143,81,70,191,171,253,155,178,115,234,107,221,53,169,175,17,27,41,188,233,181,219,202,142,209,202,
155,137,229,74,126,212,138,157,229,123,159,192,123,172,196,134,149,55,10,129,116,88,121,163,176,242,70,33,240,94,75,151,45,93,179,116,197,242,27,5,86,177,107,250,70,33,64,12,1,142,53,23,64,93,224,186,29,56,86,189,20,158,141,153,128,27,191,81,40,19,144,68,86,222,40,68,98,135,141,58,176,106,219,168,27,49,99,163,195,68,189,54,234,77,190,247,216,168,39,25,85,120,159,141,250,136,58,45,31,54,158,180,244,130,173,190,64,116,82,142,28,125,72,39,81,135,93,200,91,26,178,116,194,86,79,16,13,17,94,228,50,62,4,58,228,54,101,189,205,81,245,90,125,151,208,143,28,62,248,93,66,63,58,240,193,239,18,250,81,59,182,30,93,55,8,248,93,66,63,214,114,241,35,131,102,45,205,89,122,85,66,36,173,77,3,118,21,94,83,179,28,184,238,234,144,99,200,246,30,97,2,86,224,163,187,132,184,102,57,17,182,57,27,213,163,90,213,77,223,53,85,135,77,232,252,106,60,29,214,121,181,102,125,106,157,123,37,97,142,91,121,111,177,242,222,98,233,146,152,232,170,173,173,89,14,188,166,102,57,240,154,154,229,192,107,106,150,228,182,74,
172,39,93,106,150,104,162,56,199,172,212,44,209,112,64,104,155,178,51,2,70,125,93,83,179,156,24,168,169,89,14,124,107,99,227,115,90,179,80,176,80,164,180,102,225,16,12,203,201,198,107,22,74,24,202,150,86,177,60,23,178,204,54,215,172,207,123,205,173,23,231,247,94,29,15,88,58,46,235,71,89,124,135,11,204,162,93,174,224,254,13,254,59,46,235,201,1,185,79,196,169,101,122,140,152,185,146,28,35,238,46,78,246,142,93,60,55,91,152,166,191,217,79,63,10,74,244,163,240,235,88,129,232,95,41,255,237,247,126,31,119,253,37,19,78,152,229,33,124,43,154,221,232,9,0,91,180,240,140,3,148,55,33,46,221,113,9,36,194,4,164,88,0,225,82,14,203,24,99,9,139,85,172,26,94,184,248,147,214,155,229,161,17,19,142,57,188,24,11,160,113,145,56,38,77,12,147,102,185,130,6,9,48,30,167,95,30,40,216,176,100,195,9,11,254,54,44,90,71,49,128,242,54,28,177,171,34,199,83,172,85,197,20,84,114,176,106,120,197,138,1,107,196,134,99,107,176,0,26,23,137,177,98,48,119,162,216,170,137,119,222,76,76,220,166,246,61,52,61,55,59,94,166,
191,125,154,126,28,12,208,143,195,151,217,202,255,198,189,82,127,208,107,170,216,197,12,115,3,0,157,54,213,211,98,100,116,255,248,16,197,4,26,134,20,115,88,76,232,67,114,166,138,21,27,240,83,134,134,76,21,219,138,83,9,230,16,3,171,120,4,16,230,87,76,0,5,153,225,112,49,178,23,143,107,48,251,76,21,213,19,192,188,193,150,150,119,43,154,231,62,68,49,129,134,33,197,212,125,13,54,194,130,92,21,66,194,186,210,172,158,190,86,62,164,89,123,138,49,49,253,42,38,14,227,171,229,79,179,65,86,33,170,39,140,41,226,216,158,64,62,85,207,194,169,61,5,153,57,136,169,217,110,160,85,203,171,133,187,77,21,251,33,72,31,228,174,133,42,66,123,48,145,142,139,175,65,83,197,35,128,208,71,49,1,20,100,134,195,239,232,123,192,227,26,204,70,150,23,151,197,145,32,142,195,241,12,123,211,247,145,7,249,101,127,175,149,0,149,2,115,218,58,1,234,65,20,19,139,198,176,37,197,140,3,212,131,228,172,4,168,165,83,92,189,156,0,149,98,118,202,58,1,42,152,88,94,192,86,225,106,62,60,2,232,98,246,89,9,80,111,33,242,151,38,197,
244,183,217,39,132,103,222,58,1,218,164,158,190,86,62,164,89,123,138,49,49,253,213,112,244,33,106,79,24,83,196,57,1,234,89,88,49,197,116,49,207,56,64,61,11,119,91,9,80,75,131,220,44,225,4,40,63,2,232,4,168,96,2,8,197,20,30,7,168,135,217,200,242,178,119,136,35,33,14,80,241,166,239,35,15,178,90,117,119,149,214,86,221,194,244,84,113,140,254,238,105,250,9,170,238,79,194,136,75,214,191,243,53,217,119,143,155,42,246,175,146,143,200,77,24,44,206,136,99,166,138,151,102,169,90,120,117,94,139,227,67,180,218,12,152,42,118,156,58,234,67,124,42,31,162,249,232,74,247,33,62,149,15,241,165,251,16,159,202,135,168,5,164,10,161,206,84,81,133,124,136,175,161,15,241,57,251,16,95,67,31,226,83,249,16,95,186,15,241,169,124,136,47,221,135,248,84,155,147,229,243,217,28,196,215,208,135,212,225,108,37,194,185,220,102,164,12,103,52,65,143,89,201,2,62,147,168,3,233,183,85,188,227,29,23,218,147,182,138,247,4,159,74,71,165,60,199,156,125,136,22,194,1,43,185,35,220,124,136,79,229,67,124,233,62,196,167,242,33,
190,116,31,226,83,249,16,121,11,202,72,33,204,12,91,201,29,177,164,11,241,53,244,33,62,231,205,65,252,89,248,144,141,112,246,53,244,33,91,21,27,91,197,199,159,87,78,22,58,188,53,201,214,99,185,130,205,28,222,148,114,241,150,110,117,53,105,253,102,178,154,4,51,179,211,231,206,143,205,208,223,247,209,199,193,139,244,177,246,91,252,7,229,191,127,249,67,180,3,94,48,11,23,146,118,233,162,89,192,11,17,94,53,208,91,85,198,245,57,94,188,208,227,56,45,15,243,120,152,6,34,247,108,222,158,7,14,158,133,252,246,188,210,131,102,12,35,120,179,192,171,150,50,96,26,233,246,7,13,247,164,162,231,78,71,22,116,0,205,224,147,32,1,20,77,142,23,88,204,142,143,131,137,48,56,23,6,227,97,48,22,6,165,48,40,134,193,104,107,48,18,6,103,195,160,16,6,249,48,56,19,6,195,173,193,11,97,48,20,6,131,97,112,58,12,78,133,193,201,214,224,68,24,252,122,24,28,15,131,99,97,112,52,12,6,90,131,254,48,232,11,131,35,97,208,27,6,135,195,160,167,53,232,14,131,231,195,32,23,6,81,24,100,195,160,43,248,16,154,92,160,204,199,65,
231,210,123,193,196,159,31,251,16,87,4,104,74,133,174,56,107,195,44,46,153,8,55,87,152,196,139,134,94,50,209,75,248,130,139,47,110,205,142,0,196,16,218,113,103,77,4,100,144,140,25,52,210,71,232,140,135,17,92,184,195,231,206,158,6,3,224,14,25,17,184,67,134,67,192,119,22,169,66,27,18,0,175,204,153,104,78,60,4,11,95,49,17,238,110,97,224,87,12,77,153,8,45,166,175,224,209,129,227,76,188,108,208,30,207,55,40,147,124,143,27,225,28,25,62,113,249,56,10,125,112,13,253,167,87,108,204,244,2,159,78,70,56,230,67,16,76,91,186,106,163,171,18,39,46,252,21,110,112,141,5,95,225,222,214,8,218,64,167,171,22,36,17,130,10,36,56,249,186,102,163,107,98,246,139,150,174,219,161,235,68,23,105,121,47,78,197,180,241,117,14,183,60,150,198,109,226,27,62,180,75,124,99,233,37,155,248,134,155,120,19,223,240,137,90,226,27,75,51,54,241,141,3,71,139,111,202,7,231,16,115,54,43,150,187,239,178,100,242,131,50,249,239,62,9,193,23,108,146,135,124,12,146,228,33,79,62,205,67,121,72,242,144,77,145,230,33,147,167,121,104,
105,12,15,113,30,166,52,156,135,76,147,230,33,143,36,121,104,49,150,230,33,15,112,30,182,213,230,97,91,48,26,58,121,216,38,121,24,38,121,216,150,228,97,40,121,216,230,228,97,24,244,183,213,230,97,91,146,135,109,193,68,70,51,48,119,159,125,139,188,107,224,244,151,44,189,104,147,188,115,130,193,85,104,236,222,193,115,103,143,68,79,146,119,78,138,184,225,239,166,142,68,118,146,119,124,45,148,228,29,71,97,204,199,137,206,15,174,185,185,227,230,151,155,71,46,220,21,236,210,186,248,95,186,188,251,82,20,151,237,44,100,34,107,185,162,235,77,122,78,219,242,171,100,3,210,50,85,24,165,127,120,153,126,26,28,166,159,134,121,126,139,253,79,126,139,253,195,162,156,42,97,55,241,6,150,78,156,139,232,15,188,112,40,148,7,8,88,114,94,202,103,121,64,140,177,244,184,182,14,33,214,39,32,150,204,50,255,88,3,188,80,237,240,44,63,149,89,142,59,163,1,197,179,176,95,158,74,216,51,72,36,8,22,163,8,33,216,197,188,152,145,128,68,137,111,93,198,184,40,177,0,20,172,198,35,230,91,151,161,167,20,219,5,240,198,
250,137,147,227,41,96,197,231,170,62,251,58,170,10,111,232,177,60,165,26,240,38,108,67,170,138,158,9,33,102,14,109,101,206,0,221,158,7,47,102,180,202,235,246,252,122,211,78,172,42,218,199,180,98,251,88,47,229,181,142,68,209,94,177,176,210,224,64,101,220,138,189,96,159,73,90,56,199,203,10,141,98,153,25,149,157,201,57,89,143,4,75,150,49,193,2,9,255,230,6,231,64,88,2,39,72,200,85,21,133,150,172,235,96,150,192,87,6,142,131,69,110,30,160,213,153,198,236,92,7,139,144,152,87,236,96,102,148,40,140,57,20,104,1,18,81,246,161,202,8,166,1,237,128,8,55,99,0,58,203,74,234,184,25,180,64,196,105,61,123,62,182,157,112,44,0,148,250,1,28,75,140,40,160,216,91,62,214,214,219,238,211,153,254,246,188,88,134,245,174,96,42,154,0,171,121,254,151,73,158,63,116,182,48,51,67,255,216,78,63,67,87,247,207,194,167,57,209,255,139,19,253,143,106,27,121,107,59,120,219,17,168,237,68,241,7,198,230,241,50,19,127,160,103,119,30,23,113,241,71,237,216,42,221,27,237,210,42,236,208,161,229,119,30,45,15,241,71,202,165,138,
155,255,46,83,237,162,76,100,170,104,187,246,20,97,78,224,27,51,148,182,1,60,225,46,98,109,243,176,219,158,28,19,212,210,197,4,181,18,244,116,253,176,169,74,195,57,31,247,110,14,210,110,170,80,84,103,162,28,124,72,29,206,114,24,124,216,138,116,57,158,236,176,108,145,200,178,45,244,184,212,135,116,98,247,217,233,52,76,240,193,183,203,67,15,100,93,72,59,50,156,29,170,31,104,177,16,199,232,7,26,39,196,161,250,81,59,182,74,39,246,175,161,67,223,133,56,84,63,82,46,226,80,43,14,149,73,248,202,108,14,210,110,197,192,194,89,57,248,144,141,112,246,205,233,67,154,55,112,243,20,245,116,93,174,32,207,210,44,222,241,253,36,139,91,207,22,166,207,29,154,41,92,166,127,26,161,79,130,151,233,19,189,84,253,111,202,255,223,190,63,238,51,220,33,52,96,162,1,162,163,38,58,154,124,87,248,17,19,29,225,95,96,164,56,119,246,56,15,76,48,96,90,142,82,103,159,105,25,160,206,35,166,165,15,127,215,16,228,76,4,197,186,13,247,44,245,224,175,105,233,161,206,156,105,233,166,206,200,180,228,240,151,203,3,227,116,
153,168,139,62,184,214,108,123,83,191,29,234,199,107,101,114,99,45,186,90,153,143,149,249,200,119,237,132,58,98,101,62,210,21,53,32,240,205,81,245,218,193,94,250,193,69,101,170,140,142,222,91,24,140,231,72,6,193,128,21,227,89,49,158,77,140,183,138,115,103,79,206,138,241,164,225,11,237,93,221,86,140,103,197,120,54,49,158,224,116,89,24,239,123,32,208,222,165,237,176,194,102,101,213,70,234,19,51,73,164,238,28,157,190,88,158,161,159,7,83,244,115,44,53,255,195,75,205,159,116,24,122,190,146,125,158,114,242,55,83,251,157,186,94,62,216,65,187,147,81,194,74,176,213,248,16,253,100,7,237,21,185,27,225,223,28,126,167,169,209,159,11,243,186,243,237,52,53,252,55,128,223,44,255,7,248,235,197,91,243,254,250,172,217,115,219,226,39,236,48,7,176,215,123,30,253,167,247,138,234,79,145,197,171,82,238,67,238,167,190,107,74,74,141,133,155,209,234,129,20,152,110,35,53,246,139,228,151,58,209,130,14,156,126,147,29,164,204,96,252,55,236,160,3,120,196,210,144,64,116,212,133,99,41,204,118,113,211,206,70,169,
250,249,61,44,101,184,183,131,158,72,105,5,238,50,244,71,85,129,141,195,183,158,155,104,27,43,192,19,23,91,173,59,163,70,58,111,189,110,137,35,54,110,159,230,117,227,222,22,161,178,137,20,121,236,88,15,238,204,180,9,170,70,82,182,147,219,16,246,96,131,20,13,218,41,249,155,138,206,169,17,100,214,39,7,233,236,160,61,50,72,99,88,119,186,94,110,25,180,237,131,180,163,139,206,15,218,22,32,244,219,71,6,105,255,224,198,38,206,217,193,150,76,5,225,2,221,183,51,120,54,50,78,29,248,6,121,234,86,115,176,193,142,183,211,166,213,143,171,165,188,202,175,187,99,177,53,21,102,3,248,205,242,127,128,191,190,253,191,108,246,105,54,222,234,224,35,239,154,202,172,245,83,53,201,187,58,41,41,132,141,224,235,231,126,35,170,70,240,173,231,198,43,96,82,148,120,197,185,119,253,223,62,221,226,21,48,81,239,129,110,142,5,240,90,20,138,239,212,29,252,55,9,96,30,74,76,183,102,84,23,190,116,249,227,170,34,152,245,87,64,89,254,246,119,80,80,111,5,84,206,201,238,177,193,134,33,201,154,173,143,219,100,130,254,122,
250,185,91,229,235,184,114,99,118,67,125,171,67,219,168,28,185,60,221,172,151,160,146,55,38,75,125,246,206,53,28,229,98,235,147,30,2,239,124,60,57,90,11,102,113,180,54,85,156,165,127,62,73,191,64,207,216,47,180,103,236,127,249,12,248,79,113,193,56,100,34,52,158,225,38,8,77,252,218,8,133,150,233,51,73,255,210,25,233,95,26,54,17,128,184,52,195,143,7,180,127,9,36,120,87,25,51,17,174,209,240,51,0,23,238,240,185,179,167,193,0,119,96,157,49,17,184,163,71,202,33,224,27,207,84,161,13,9,192,133,175,54,60,225,58,11,119,182,21,195,253,72,184,225,155,50,52,106,162,81,124,169,133,163,17,170,96,34,32,163,71,10,63,49,152,52,17,46,119,113,228,232,242,113,20,250,224,26,110,8,181,201,9,76,113,121,118,193,70,23,228,46,22,183,127,218,240,84,170,133,79,241,197,104,44,88,254,113,63,254,151,6,161,19,26,170,74,54,2,50,218,132,220,246,21,92,232,93,180,67,23,137,206,225,36,27,183,170,5,139,127,0,146,255,137,65,32,13,217,196,55,73,35,20,251,38,233,113,97,223,112,167,123,226,27,190,180,228,134,42,246,13,
223,119,38,190,113,224,195,14,31,92,114,166,255,10,225,253,150,37,147,31,148,201,255,224,226,125,22,134,160,107,48,227,23,45,140,151,4,157,99,9,87,161,13,88,238,206,30,49,29,119,251,112,208,57,241,225,250,222,133,139,91,147,160,227,27,231,36,232,216,5,49,31,199,53,223,227,246,163,47,100,28,108,103,204,137,172,229,138,122,41,45,140,244,76,82,24,31,121,247,198,111,191,127,227,230,107,55,94,63,244,27,223,60,189,90,58,105,95,130,241,240,232,173,155,135,70,174,191,243,206,173,183,222,114,198,247,39,227,143,142,223,122,255,221,247,110,221,236,57,52,123,99,225,250,187,14,74,123,130,242,228,235,183,110,222,124,243,198,107,249,55,23,122,111,222,120,239,181,91,191,213,139,255,25,243,255,5,0,0,0,255,255,3,0,171,240,128,51);


programfile__bach_mid
:array[0..2779] of byte=(
120,1,236,87,219,114,219,214,21,93,184,144,186,83,146,117,35,41,18,77,58,227,233,12,75,154,1,69,33,128,17,240,130,0,4,14,0,130,4,73,73,164,44,89,150,19,59,118,219,73,50,78,166,147,60,116,58,253,131,246,27,250,3,206,31,180,95,230,46,56,211,233,115,223,245,164,17,120,46,123,239,117,217,251,140,23,111,190,6,80,132,4,5,63,141,23,239,254,200,255,42,248,176,84,85,185,188,142,15,43,153,255,127,200,148,245,127,30,227,67,27,191,46,40,253,136,15,159,74,252,174,20,166,111,239,191,253,14,239,185,232,253,39,192,191,248,103,237,175,120,191,57,192,251,159,129,181,191,224,239,70,8,43,176,45,72,226,166,41,176,103,7,136,46,53,177,40,70,88,183,177,45,160,6,243,106,0,53,10,234,17,215,92,192,242,234,2,82,144,149,44,108,5,40,248,179,170,15,85,100,154,0,130,57,204,80,54,80,230,122,63,46,153,216,243,238,138,62,142,60,40,65,170,249,183,104,132,48,130,66,128,138,119,167,250,216,52,128,6,118,248,171,145,193,189,174,184,60,205,221,53,176,107,197,16,127,222,228,213,62,182,45,168,230,151,90,150,194,136,101,
19,155,25,74,6,84,203,211,76,15,225,159,100,11,155,33,246,77,72,134,208,166,23,232,198,5,3,235,83,236,116,185,43,208,188,87,48,174,85,19,69,15,135,93,95,50,80,79,111,113,38,148,46,214,83,60,58,227,46,95,235,206,32,238,85,3,27,2,251,103,179,66,23,39,103,144,147,57,244,139,173,4,187,58,212,110,144,71,110,164,235,93,108,27,216,244,50,70,245,200,195,186,37,224,46,118,24,128,139,53,63,174,249,144,131,59,116,68,41,192,110,7,146,62,173,232,40,68,87,104,39,155,17,246,218,80,59,147,252,46,239,166,216,193,102,23,91,204,218,157,212,92,200,230,28,3,127,219,196,238,0,138,183,170,123,220,187,128,127,151,111,111,167,135,172,146,184,67,107,33,181,81,105,65,213,111,75,2,37,29,114,103,132,224,153,166,51,248,165,20,0,29,148,117,64,112,139,143,40,171,240,58,130,213,73,144,174,234,41,15,188,128,191,42,116,112,68,164,184,172,29,34,232,85,136,157,152,160,21,23,218,216,227,198,252,240,8,233,82,107,11,120,153,172,67,74,113,234,1,173,12,126,38,243,118,38,216,130,212,188,32,202,199,1,214,199,75,180,159,
74,77,212,91,19,184,175,25,222,206,24,187,249,130,73,165,9,16,202,134,128,255,86,107,45,212,70,126,111,161,115,135,224,197,78,11,251,34,147,3,236,117,176,78,124,141,43,68,207,180,32,46,68,88,51,240,168,157,177,62,57,61,90,137,210,102,169,177,221,66,33,120,141,230,68,227,153,173,103,59,1,183,223,163,123,181,219,205,131,217,137,102,138,64,149,153,154,23,72,198,59,38,246,19,22,97,154,83,49,175,225,155,83,29,74,59,38,94,213,22,25,117,199,51,203,45,40,250,66,22,168,165,223,160,19,51,205,26,65,73,2,133,144,165,56,73,32,241,228,232,18,198,197,137,65,248,32,167,55,176,66,45,25,67,159,145,108,114,138,99,82,34,154,161,51,84,18,156,118,128,136,55,166,232,6,229,46,24,140,98,185,140,228,212,226,189,33,162,171,66,130,19,30,34,150,208,51,181,253,113,111,176,64,103,46,9,84,58,164,168,64,20,19,190,26,9,220,26,67,92,243,198,99,70,24,124,197,226,28,91,51,248,47,249,107,221,94,193,187,151,125,192,66,205,33,148,223,43,36,143,141,178,77,14,124,91,116,176,225,163,100,83,155,87,20,242,26,233,103,97,
141,10,117,250,72,102,71,9,214,28,200,222,10,118,90,243,32,219,128,255,12,214,176,66,89,249,185,138,41,216,138,137,66,50,128,61,224,93,39,54,212,4,178,59,131,213,171,50,95,242,211,155,193,28,29,120,140,150,60,159,192,8,143,125,172,83,185,49,175,27,105,22,96,166,24,44,215,99,28,229,50,188,82,7,168,78,255,128,238,56,151,155,153,80,80,21,231,118,221,196,113,146,169,14,214,166,56,32,130,131,97,49,65,57,124,65,32,100,174,23,223,192,90,21,67,166,76,57,120,100,99,201,152,35,123,77,189,215,172,121,126,78,255,27,197,66,169,143,157,52,169,103,144,226,5,220,57,177,160,244,74,49,205,231,242,80,96,211,236,33,188,122,100,98,43,228,130,121,45,134,60,93,96,48,216,25,96,123,74,170,167,101,129,98,54,130,17,209,64,182,51,168,211,240,120,138,245,126,138,52,221,235,163,152,98,61,27,215,50,200,221,62,166,33,9,182,51,37,220,81,37,69,193,201,144,56,219,14,74,73,190,171,198,239,103,1,210,249,238,25,54,249,107,50,214,190,88,34,78,153,209,198,23,216,98,60,105,154,139,46,17,4,125,91,199,163,56,146,18,212,
99,192,73,32,46,180,68,144,39,112,80,97,157,207,103,152,78,52,35,149,206,177,59,205,237,69,14,46,97,198,219,1,104,8,197,243,64,59,7,169,8,255,197,158,129,18,235,236,77,11,62,246,76,168,30,10,86,0,247,170,236,162,72,8,252,12,198,21,243,226,175,91,233,10,103,180,181,68,57,67,165,11,164,144,233,174,241,53,249,188,118,54,86,226,220,223,232,141,8,23,185,94,70,66,10,81,30,161,160,79,224,205,182,116,148,120,114,178,208,252,151,185,223,18,35,154,173,183,162,135,147,0,5,119,138,207,252,157,207,176,227,66,141,133,214,101,60,119,196,157,16,239,187,130,156,60,225,119,253,22,3,55,207,90,164,210,0,245,179,148,38,73,50,111,156,97,139,92,26,184,90,51,69,127,81,24,96,173,137,109,150,61,188,221,11,81,162,135,136,219,26,201,16,126,175,53,230,16,111,25,21,29,233,128,190,148,190,42,177,152,13,236,54,175,144,92,109,198,23,228,103,145,92,138,161,52,161,52,238,17,223,31,178,242,13,58,207,13,139,44,137,31,183,4,14,30,247,32,126,216,107,162,229,221,231,78,251,24,45,99,69,230,107,20,145,151,176,239,48,
29,197,189,171,249,169,228,98,219,199,126,55,132,119,155,11,196,29,209,147,105,2,210,192,43,15,216,56,166,218,89,8,55,97,193,89,106,198,95,103,215,232,223,49,181,106,159,39,36,117,46,214,99,12,188,26,61,185,219,59,166,123,144,102,70,86,31,208,148,98,182,194,99,226,232,10,42,78,243,46,136,172,196,62,235,226,196,164,213,67,246,111,96,140,170,6,20,42,81,220,114,77,217,66,113,48,130,41,168,223,195,1,181,192,197,84,220,132,87,43,92,230,205,209,237,231,152,18,11,115,4,65,230,204,164,254,50,95,38,112,68,244,7,30,141,72,234,231,184,171,110,138,179,80,25,224,136,12,9,105,104,169,124,134,3,114,160,155,72,98,174,134,56,61,139,85,2,71,104,244,4,206,138,108,161,179,21,218,227,178,131,226,19,194,49,194,192,129,59,96,119,168,60,97,203,24,105,250,29,187,64,149,125,193,205,27,13,152,224,147,219,250,19,72,17,253,223,67,207,70,59,213,244,231,191,174,81,59,119,185,55,242,75,239,163,67,178,74,78,95,26,37,146,62,151,6,61,250,48,239,66,103,249,41,215,116,147,83,58,167,158,212,28,72,35,126,116,97,187,
112,93,4,11,58,3,253,185,234,95,42,1,170,188,148,85,242,94,85,9,28,119,209,238,220,133,214,99,229,93,120,207,105,83,21,126,247,87,90,48,147,124,156,6,116,173,91,66,128,30,151,13,225,124,201,126,74,4,57,168,32,136,143,2,246,250,68,243,47,217,241,15,121,44,239,245,134,176,135,8,46,9,132,38,150,197,32,39,158,28,101,117,198,16,129,172,200,175,19,115,248,97,222,106,173,160,110,11,4,41,29,137,211,17,165,74,103,86,156,43,248,129,100,131,253,154,126,11,98,109,165,236,2,18,81,238,177,140,175,180,36,96,221,148,30,187,213,4,157,128,202,170,137,153,196,195,217,119,76,182,227,91,30,149,143,49,156,52,172,223,179,63,114,239,199,124,233,219,30,83,83,25,128,197,58,47,89,7,222,171,12,47,101,103,81,143,22,181,33,235,207,218,66,58,127,33,137,89,141,118,17,220,20,4,126,195,56,141,123,248,139,83,90,138,119,195,154,160,49,171,81,65,180,205,70,62,14,29,80,170,173,75,105,16,168,77,84,218,161,212,98,173,124,22,252,176,135,162,126,13,255,134,184,159,116,102,18,39,1,238,213,81,238,176,163,49,133,140,101,
60,213,115,213,176,227,75,195,153,214,207,212,33,221,3,71,206,69,161,143,67,7,5,123,89,97,19,177,86,213,224,25,204,108,211,194,174,73,91,99,187,33,9,151,85,47,163,159,75,231,151,57,76,164,177,207,9,109,33,159,163,76,177,176,254,252,201,199,33,75,202,45,214,88,22,179,10,153,22,141,97,8,54,95,141,153,6,43,244,4,101,245,121,39,252,164,199,70,73,42,174,114,20,24,158,120,46,13,47,161,191,180,117,108,58,183,210,16,249,164,228,224,183,189,182,50,126,131,32,128,103,107,206,85,161,135,3,50,220,94,214,199,185,142,192,187,216,19,123,163,58,169,146,10,56,41,68,15,254,211,10,155,166,61,171,231,137,76,106,206,87,121,1,211,156,246,121,24,14,239,90,98,122,143,97,10,123,81,183,198,236,197,21,243,130,210,214,62,42,17,83,96,72,206,44,52,158,108,221,213,196,66,54,39,27,22,246,12,79,74,231,68,167,192,97,143,114,78,2,88,19,78,29,245,104,14,219,39,172,235,9,109,243,57,153,67,184,57,126,31,4,43,234,154,13,145,14,159,215,36,202,96,143,88,153,188,71,91,108,37,55,74,4,246,104,246,95,37,184,81,5,216,251,
88,103,201,95,40,70,124,200,243,45,159,216,113,98,215,204,48,183,157,96,73,107,162,29,201,134,32,141,101,127,81,33,55,206,125,197,187,206,237,157,204,49,191,204,233,26,100,53,130,197,68,140,148,52,168,5,47,54,57,192,231,116,226,136,146,201,226,190,26,209,7,174,24,88,177,133,189,136,172,32,61,174,165,225,164,206,148,219,177,68,93,71,111,170,173,27,78,59,156,171,55,34,28,53,87,8,222,22,57,144,180,112,210,88,145,225,12,82,110,162,220,64,193,91,178,97,237,122,40,250,175,57,39,215,220,155,156,84,62,54,92,10,243,165,164,207,216,223,165,97,178,227,242,124,236,15,239,249,157,163,175,244,88,84,221,249,198,48,31,78,142,221,123,52,210,210,99,236,91,206,111,236,1,209,217,110,16,223,132,74,60,165,12,219,66,234,89,117,103,177,209,203,153,153,31,110,199,90,207,41,216,56,225,132,233,100,59,61,190,119,66,142,37,204,229,192,18,196,177,230,196,172,246,105,211,149,108,193,239,85,43,38,61,182,154,212,230,140,223,233,219,252,94,183,70,114,99,196,43,42,13,14,165,201,158,133,71,148,79,123,185,70,99,
215,175,40,156,106,103,38,219,25,75,81,214,121,75,110,11,50,103,111,54,8,146,170,103,75,109,255,132,243,185,155,201,244,198,14,179,102,7,153,211,85,212,14,142,109,186,232,136,27,137,87,142,178,51,229,124,254,235,212,154,219,148,62,163,0,79,219,94,94,100,51,81,93,78,179,49,147,130,37,36,51,127,29,20,154,147,28,104,58,198,112,153,179,186,157,176,206,199,109,20,134,188,110,137,214,229,9,103,203,222,66,227,177,148,124,15,167,246,138,33,241,252,109,22,214,226,147,103,74,226,157,112,50,116,175,235,230,12,143,47,10,121,67,199,33,231,195,97,242,187,199,40,18,98,183,7,103,132,167,159,163,241,229,223,46,25,211,83,208,80,20,218,232,255,222,158,239,254,251,246,220,10,239,223,125,255,195,219,175,222,124,247,238,107,252,187,136,95,214,126,194,47,155,95,224,151,159,145,191,60,255,241,240,242,124,120,121,62,188,60,31,94,158,246,195,203,243,225,229,249,240,242,124,120,121,62,188,60,31,94,158,15,47,207,135,151,231,195,203,243,225,229,249,127,189,60,255,3,0,0,255,255,3,0,75,175,76,42);



implementation

end.
